/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.jboss;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JndiRegistry {
    private static final Log LOG = LogFactory.getLog(JndiRegistry.class);

    public static void bindToJndi(String name, Object object) {
        ServiceContainer serviceTarget = CurrentServiceContainer.getServiceContainer();
        if (serviceTarget != null) {
            WritableServiceBasedNamingStore.pushOwner((ServiceTarget)serviceTarget, (ServiceName[])new ServiceName[0]);
            try {
                InitialContext context = new InitialContext();
                context.bind(name, object);
            }
            catch (NamingException e) {
                LOG.error((Object)"Error in binding the object in JNDI.");
            }
        }
    }

    public static void unbindFromJndi(String name) {
        ServiceContainer serviceTarget = CurrentServiceContainer.getServiceContainer();
        if (serviceTarget != null) {
            WritableServiceBasedNamingStore.pushOwner((ServiceTarget)serviceTarget, (ServiceName[])new ServiceName[0]);
            try {
                InitialContext context = new InitialContext();
                context.unbind(name);
            }
            catch (NamingException e) {
                LOG.error((Object)"Error in unbinding the object from JNDI.");
            }
        }
    }
}

