/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseInitialiser {
    private static Log log = LogFactory.getLog(DatabaseInitialiser.class);
    private DataSource datasource;
    private String existsSql = "SELECT * FROM ODE_JOB";
    private String sqlFiles;
    private TransactionManager txm;
    private String hibernateDialect;
    private boolean useEOL = false;

    public DatabaseInitialiser(DataSource ds, TransactionManager manager, String dialect) {
        this.datasource = ds;
        this.txm = manager;
        this.hibernateDialect = dialect;
    }

    protected void initDatabase() throws Exception {
        String[] list;
        Connection conn = this.datasource.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.existsSql.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            log.info((Object)(this.datasource + " datasource is already initialized"));
            return;
        }
        this.sqlFiles = this.getSqlFile(this.hibernateDialect);
        log.info((Object)("Initializing " + this.datasource + " from listed sql files " + this.sqlFiles));
        for (String sql : list = this.sqlFiles.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String resource, Connection conn) {
        try {
            this.txm.begin();
            log.debug((Object)("Execute SQL from resource: " + resource));
            URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
            log.debug((Object)("Execute SQL from resource URL: " + url));
            String sql = this.getStringFromStream(url.openStream());
            sql = sql.replaceAll("(?m)^--([^\n]+)?$", "");
            String[] statements = this.useEOL ? sql.split("[\n;]") : sql.split(";");
            for (String statement : statements) {
                if (statement == null || "".equals(statement.trim())) continue;
                Statement sqlStatement = conn.createStatement();
                try {
                    sqlStatement.executeUpdate(statement);
                }
                finally {
                    sqlStatement.close();
                }
            }
            this.txm.commit();
        }
        catch (Throwable t) {
            if (this.txm != null) {
                try {
                    this.txm.rollback();
                }
                catch (SystemException e) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Failed to create database", t);
        }
    }

    private String getStringFromStream(InputStream is) throws Exception {
        byte[] bytes = DatabaseInitialiser.readStream(is);
        return new String(bytes, "UTF-8");
    }

    public static byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }

    private String getSqlFile(String hibernateDialect) {
        if (hibernateDialect.indexOf("H2Dialect") != -1) {
            return "sqls/h2.sql";
        }
        if (hibernateDialect.indexOf("MySQLInnoDBDialect") != -1) {
            return "sqls/mysql.sql";
        }
        if (hibernateDialect.indexOf("DB2Dialect") != -1) {
            return "sqls/db2.sql";
        }
        if (hibernateDialect.indexOf("Oracle") != -1) {
            return "sqls/oracle.sql";
        }
        if (hibernateDialect.indexOf("PostgreSQLDialect") != -1) {
            return "sqls/postgres.sql";
        }
        if (hibernateDialect.indexOf("SQLServerDialect") != -1) {
            return "sqls/sqlserver.sql";
        }
        if (hibernateDialect.indexOf("SybaseDialect") != -1) {
            return "sqls/sybase.sql";
        }
        throw new RuntimeException("Couldn't find any corresponding sql file for " + hibernateDialect);
    }
}

