/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.scheduler.SchedulerDAOConnection;
import org.apache.ode.dao.scheduler.SchedulerDAOConnectionFactory;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;

@Listener
public class MemberDropListener {
    private static Log logger = LogFactory.getLog(MemberDropListener.class);
    private SchedulerDAOConnectionFactory schedulerCF;
    private TransactionManager txm;

    public MemberDropListener(SchedulerDAOConnectionFactory factory, TransactionManager tm) {
        this.schedulerCF = factory;
        this.txm = tm;
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        ArrayList old = new ArrayList(event.getOldMembers());
        ArrayList actives = new ArrayList(event.getCacheManager().getMembers());
        ArrayList<Address> dropped = new ArrayList<Address>();
        for (Address oldEntry : old) {
            if (actives.contains(oldEntry)) continue;
            dropped.add(oldEntry);
        }
        logger.debug((Object)("dropped nodes =>  " + dropped + "; active node =>  " + event.getCacheManager().getMembers()));
        if (dropped.size() > 0) {
            try {
                this.txm.begin();
                SchedulerDAOConnection conn = this.schedulerCF.getConnection();
                String activeNodeId = ((Address)actives.iterator().next()).toString();
                for (Address addr : dropped) {
                    String deadNodeId = addr.toString();
                    int jobNum = conn.updateReassign(deadNodeId, activeNodeId);
                    logger.info((Object)("Moved " + jobNum + " jobs associated with [" + deadNodeId + "] to the node [" + activeNodeId + "]"));
                }
                this.txm.commit();
            }
            catch (Exception e) {
                logger.error((Object)e);
                try {
                    this.txm.rollback();
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        }
    }
}

