/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.riftsaw.engine.Fault;
import org.riftsaw.engine.Service;
import org.riftsaw.engine.ServiceLocator;
import org.riftsaw.engine.internal.PartnerRoleChannelImpl;
import org.w3c.dom.Element;

public class MessageExchangeContextImpl
implements MessageExchangeContext {
    private ServiceLocator _locator = null;
    private static final Log LOG = LogFactory.getLog(MessageExchangeContextImpl.class);

    public MessageExchangeContextImpl(ServiceLocator locator) {
        this._locator = locator;
    }

    public void invokePartnerUnreliable(PartnerRoleMessageExchange partnerRoleMessageExchange) throws ContextException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoking a partner operation: " + partnerRoleMessageExchange.getOperationName()));
        }
        PartnerRoleChannelImpl channel = (PartnerRoleChannelImpl)partnerRoleMessageExchange.getChannel();
        Service service = this._locator.getService(partnerRoleMessageExchange.getCaller(), channel.getEndpoint().serviceName, channel.getEndpoint().portName);
        if (service != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invoke service=" + service));
            }
            try {
                Map headerParts = partnerRoleMessageExchange.getRequest().getHeaderParts();
                HashMap<String, Object> transferedHeaderParts = new HashMap<String, Object>();
                Set keys = headerParts.keySet();
                for (String key : keys) {
                    Element e = (Element)partnerRoleMessageExchange.getRequest().getHeaderPart(key).getFirstChild();
                    String k = e.getNamespaceURI() == null || e.getNamespaceURI().isEmpty() ? e.getLocalName() : "{" + e.getNamespaceURI() + "}" + e.getLocalName();
                    transferedHeaderParts.put(k, e);
                }
                Element resp = service.invoke(partnerRoleMessageExchange.getOperationName(), partnerRoleMessageExchange.getRequest().getMessage(), transferedHeaderParts);
                if (partnerRoleMessageExchange.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE) {
                    Message responseMessage = partnerRoleMessageExchange.createMessage(partnerRoleMessageExchange.getOperation().getOutput().getMessage().getQName());
                    responseMessage.setMessage(resp);
                    for (String key : transferedHeaderParts.keySet()) {
                        QName qname = QName.valueOf(key);
                        if (transferedHeaderParts.get(key) instanceof Element) {
                            responseMessage.setHeaderPart(qname.getLocalPart(), (Element)transferedHeaderParts.get(key));
                            continue;
                        }
                        LOG.warn((Object)("Header part for '" + key + "' was not an Element"));
                    }
                    partnerRoleMessageExchange.reply(responseMessage);
                }
            }
            catch (Fault f) {
                QName faultName = f.getFaultName();
                javax.wsdl.Fault fault = null;
                if (faultName != null) {
                    fault = partnerRoleMessageExchange.getOperation().getFault(faultName.getLocalPart());
                }
                QName faultType = null;
                if (fault == null) {
                    faultType = new QName(f.getFaultMessage().getNamespaceURI(), f.getFaultMessage().getLocalName());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Fault type from element = " + faultType));
                    }
                } else {
                    faultType = fault.getMessage().getQName();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Fault type from message QName = " + faultType));
                    }
                }
                Message faultMessage = partnerRoleMessageExchange.createMessage(faultType);
                faultMessage.setMessage(f.getFaultMessage());
                partnerRoleMessageExchange.replyWithFault(faultName, faultMessage);
            }
            catch (Exception e) {
                throw new ContextException("Failed to invoke external service", (Throwable)e);
            }
        }
    }

    public void invokePartnerReliable(PartnerRoleMessageExchange mex) throws ContextException {
        throw new UnsupportedOperationException();
    }

    public void invokePartnerTransacted(PartnerRoleMessageExchange mex) throws ContextException {
        this.invokePartnerUnreliable(mex);
    }

    public void onMyRoleMessageExchangeStateChanged(MyRoleMessageExchange myRoleMessageExchange) throws BpelEngineException {
    }

    public void cancel(PartnerRoleMessageExchange mex) throws ContextException {
    }

    public void invokePartner(PartnerRoleMessageExchange mex) throws ContextException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoking a partner operation: " + mex.getOperationName()));
        }
        this.invokePartnerUnreliable(mex);
    }

    public void onAsyncReply(MyRoleMessageExchange mex) throws BpelEngineException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing an async reply from service " + mex.getServiceName()));
        }
    }
}

