/*
 * Decompiled with CFR 0.152.
 */
package org.riftsaw.engine.jboss;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class JndiRegistry {
    private static final Log LOG = LogFactory.getLog(JndiRegistry.class);

    public static void bindToJndi(String name, Object object) {
        ServiceContainer serviceContainer = CurrentServiceContainer.getServiceContainer();
        if (serviceContainer != null) {
            try {
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
                BinderService binderService = new BinderService(bindInfo.getBindName());
                BindListener listener = new BindListener();
                binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue(object)));
                ServiceBuilder builder = serviceContainer.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)listener);
                builder.install();
                listener.await();
                binderService.acquire();
            }
            catch (Throwable e) {
                NamingException ne = new NamingException("Failed to bind " + object + " at location " + name);
                ne.setRootCause(e);
                LOG.error((Object)ne);
            }
        }
    }

    public static void unbindFromJndi(String name) {
        ServiceContainer serviceContainer = CurrentServiceContainer.getServiceContainer();
        if (serviceContainer != null) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
            ServiceController controller = serviceContainer.getService(bindInfo.getBinderServiceName());
            UnbindListener listener = new UnbindListener();
            controller.addListener((ServiceListener)listener);
            try {
                listener.await();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to unbind [" + name + "]"), (Throwable)e);
            }
        }
    }

    private static class UnbindListener
    extends AbstractServiceListener<Object> {
        private boolean complete;

        private UnbindListener() {
        }

        public void listenerAdded(ServiceController<?> controller) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }

        public synchronized void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
            switch (transition) {
                case REMOVING_to_REMOVED: {
                    this.complete = true;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }

        public synchronized void await() throws Exception {
            while (!this.complete) {
                ((Object)((Object)this)).wait();
            }
        }
    }

    private static class BindListener
    extends AbstractServiceListener<Object> {
        private Exception exception;
        private boolean complete;

        private BindListener() {
        }

        public synchronized void transition(ServiceController<? extends Object> serviceController, ServiceController.Transition transition) {
            switch (transition) {
                case STARTING_to_UP: {
                    this.complete = true;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.complete = true;
                    this.exception = serviceController.getStartException();
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }

        public synchronized void await() throws Exception {
            while (!this.complete) {
                ((Object)((Object)this)).wait();
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

