/*
 * Decompiled with CFR 0.152.
 */
package org.riverframework.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Converter {
    private static final Calendar calendar = Calendar.getInstance();
    private static final Map<Matcher, SimpleDateFormat> mapMatcherDateFormat = new HashMap<Matcher, SimpleDateFormat>(){
        {
            this.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}$").matcher(""), new SimpleDateFormat("yyyy-MM-dd"));
            this.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}\\+\\d{2}:\\d{2}$").matcher(""), new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ"));
            this.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}\\+\\d{2}:\\d{2}$").matcher(""), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
            this.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}T\\d{1,2}:\\d{2}:\\d{2}\\.\\d{2}[+-]\\d{2}:\\d{2}$").matcher(""), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        }
    };

    public static String getAsString(Object value) {
        String result = null;
        if (value == null) {
            result = "";
        } else if (value instanceof Double) {
            double n = (Double)value;
            result = n == (double)((long)n) ? String.format("%d", (long)n) : String.format("%s", n);
        } else if (value instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String date = df.format((Date)value);
            result = date.substring(0, date.length() - 2) + ":" + date.substring(date.length() - 2, date.length());
        } else {
            result = value.toString();
        }
        return result;
    }

    public static Integer getAsInteger(Object value) {
        Integer result = null;
        try {
            result = value instanceof String ? Integer.valueOf((String)value) : (value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : null);
        }
        catch (Exception e) {
            result = null;
        }
        return result == null ? 0 : result;
    }

    public static Long getAsLong(Object value) {
        Long result = null;
        try {
            result = value instanceof String ? Long.valueOf((String)value) : (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : null);
        }
        catch (Exception e) {
            result = null;
        }
        return result == null ? 0L : result;
    }

    public static Double getAsDouble(Object value) {
        Double result = null;
        try {
            result = value instanceof String ? Double.valueOf((String)value) : (value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : null);
        }
        catch (Exception e) {
            result = null;
        }
        return result == null ? 0.0 : result;
    }

    public static Date getAsDate(Object value) {
        Date result;
        block10: {
            result = null;
            try {
                if (value instanceof String) {
                    String date = ((String)value).toUpperCase();
                    for (Matcher matcher : mapMatcherDateFormat.keySet()) {
                        SimpleDateFormat sdf;
                        if (!matcher.reset(date).matches() || (sdf = mapMatcherDateFormat.get(matcher)) == null) continue;
                        if (date.endsWith("Z")) {
                            date = date.substring(0, date.length() - 1) + "GMT-00:00";
                        } else if (date.indexOf(84) > -1) {
                            int index = date.indexOf(43);
                            int n = index = index > -1 ? index : date.lastIndexOf(45);
                            if (index > -1) {
                                String left = date.substring(0, index);
                                String right = date.substring(index, date.length());
                                date = left + "GMT" + right;
                            }
                        }
                        sdf.setLenient(false);
                        result = sdf.parse(date);
                        break block10;
                    }
                    break block10;
                }
                if (value instanceof Long) {
                    calendar.setTimeInMillis((Long)value);
                    result = calendar.getTime();
                } else {
                    result = value instanceof Date ? (Date)value : null;
                }
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }
}

