/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.finbin;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySearcher {
    public int indexOf(byte[] srcBytes, byte[] searchBytes) {
        boolean startIndex = false;
        int endIndex = srcBytes.length - 1;
        return this.indexOf(srcBytes, searchBytes, 0, endIndex);
    }

    public int indexOf(byte[] srcBytes, byte[] searchBytes, int startIndex) {
        int endIndex = srcBytes.length - 1;
        return this.indexOf(srcBytes, searchBytes, startIndex, endIndex);
    }

    public int indexOf(byte[] srcBytes, byte[] searchBytes, int startIndex, int endIndex) {
        int searchBytesLeng = searchBytes.length;
        if (searchBytesLeng == 0 || endIndex - startIndex + 1 < searchBytesLeng) {
            return -1;
        }
        int srcBytesLeng = srcBytes.length;
        int maxScanStartPosIdx = srcBytesLeng - searchBytesLeng;
        int loopEndIdx = endIndex < maxScanStartPosIdx ? endIndex : maxScanStartPosIdx;
        int lastScanIdx = -1;
        block0: for (int i = startIndex; i <= loopEndIdx; ++i) {
            for (int j = 0; j < searchBytesLeng; ++j) {
                if (srcBytes[i + j] != searchBytes[j]) continue block0;
                lastScanIdx = i + j;
            }
            if (endIndex < lastScanIdx || lastScanIdx - i + 1 < searchBytesLeng) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    public List<Integer> searchBytes(byte[] srcBytes, byte[] searchBytes) {
        boolean startIdx = false;
        int endIdx = srcBytes.length - 1;
        return this.searchBytes(srcBytes, searchBytes, 0, endIdx);
    }

    public List<Integer> searchBytes(byte[] srcBytes, byte[] searchBytes, int searchStartIndex) {
        int endIdx = srcBytes.length - 1;
        return this.searchBytes(srcBytes, searchBytes, searchStartIndex, endIdx);
    }

    public List<Integer> searchBytes(byte[] srcBytes, byte[] searchBytes, int searchStartIndex, int searchEndIndex) {
        int destSize = searchBytes.length;
        ArrayList<Integer> positionIndexList = new ArrayList<Integer>();
        int cursor = searchStartIndex;
        while (cursor < searchEndIndex + 1) {
            int index = this.indexOf(srcBytes, searchBytes, cursor, searchEndIndex);
            if (index >= 0) {
                positionIndexList.add(index);
                cursor = index + destSize;
                continue;
            }
            ++cursor;
        }
        return positionIndexList;
    }
}

