/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.jdbc.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtils.class);
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";

    private ScriptUtils() {
    }

    public static void splitSqlScript(String resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)script) ? 1 : 0) != 0, (Object)"script must not be null or empty");
        Preconditions.checkArgument((separator != null ? 1 : 0) != 0, (Object)"separator must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentPrefix) ? 1 : 0) != 0, (Object)"commentPrefix must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)blockCommentStartDelimiter) ? 1 : 0) != 0, (Object)"blockCommentStartDelimiter must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)blockCommentEndDelimiter) ? 1 : 0) != 0, (Object)"blockCommentEndDelimiter must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        boolean inEscape = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            int c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (c == 39) {
                boolean bl = inLiteral = !inLiteral;
            }
            if (!inLiteral) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf(FALLBACK_STATEMENT_SEPARATOR, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new ScriptParseException(String.format("Missing block comment end delimiter [%s].", blockCommentEndDelimiter), resource);
                }
                if (c == 32 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (!Strings.isNullOrEmpty((String)sb.toString())) {
            statements.add(sb.toString());
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void executeSqlScript(Connection connection, String scriptPath, String script) throws ScriptException {
        ScriptUtils.executeSqlScript(connection, scriptPath, script, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    /*
     * Exception decompiling
     */
    public static void executeSqlScript(Connection connection, String scriptPath, String script, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class UncategorizedScriptException
    extends RuntimeException {
        public UncategorizedScriptException(String s, Exception ex) {
            super(s, ex);
        }
    }

    private static class ScriptStatementFailedException
    extends RuntimeException {
        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath, SQLException ex) {
            super(String.format("Script execution failed (%s:%d): %s", scriptPath, lineNumber, statement), ex);
        }
    }

    private static class ScriptParseException
    extends RuntimeException {
        public ScriptParseException(String format, String scriptPath) {
            super(String.format(format, scriptPath));
        }
    }
}

