/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.testcontainers.containers;

import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.PortBinding;
import java.util.List;
import org.rnorth.testcontainers.containers.AbstractContainer;
import org.rnorth.testcontainers.containers.DatabaseContainer;

public class PostgreSQLContainer
extends AbstractContainer
implements DatabaseContainer {
    private static final String IMAGE = "postgres";
    private String postgresPort;

    protected void containerIsStarting(ContainerInfo containerInfo) {
        this.postgresPort = ((PortBinding)((List)containerInfo.networkSettings().ports().get("5432/tcp")).get(0)).hostPort();
    }

    protected String getLivenessCheckPort() {
        return this.postgresPort;
    }

    protected ContainerConfig getContainerConfig() {
        return ContainerConfig.builder().image(this.getDockerImageName()).exposedPorts(new String[]{"5432"}).env(new String[]{"POSTGRES_DATABASE=test", "POSTGRES_USER=test", "POSTGRES_PASSWORD=test"}).cmd(new String[]{IMAGE}).build();
    }

    protected String getDockerImageName() {
        return "postgres:" + this.tag;
    }

    public String getName() {
        return "postgresql";
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        return "jdbc:postgresql://" + this.dockerHostIpAddress + ":" + this.postgresPort + "/test";
    }

    public String getUsername() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public String getContainerId() {
        return this.containerId;
    }
}

