/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChooseAccountTypeActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AccountChooser";
    private HashMap<String, AuthInfo> mTypeToAuthenticatorInfo;
    private ArrayList<AuthInfo> mAuthenticatorInfosToDisplay;

    private void $$robo$$android_accounts_ChooseAccountTypeActivity$__constructor__() {
        this.mTypeToAuthenticatorInfo = new HashMap();
    }

    private final void $$robo$$android_accounts_ChooseAccountTypeActivity$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseAccountTypeActivity.onCreate(savedInstanceState=" + savedInstanceState + ")");
        }
        HashSet<Object> setOfAllowableAccountTypes = null;
        String[] validAccountTypes = this.getIntent().getStringArrayExtra("allowableAccountTypes");
        if (validAccountTypes != null) {
            setOfAllowableAccountTypes = new HashSet<Object>(validAccountTypes.length);
            for (String type : validAccountTypes) {
                setOfAllowableAccountTypes.add(type);
            }
        }
        this.buildTypeToAuthDescriptionMap();
        this.mAuthenticatorInfosToDisplay = new ArrayList(this.mTypeToAuthenticatorInfo.size());
        for (Map.Entry entry : this.mTypeToAuthenticatorInfo.entrySet()) {
            String type = (String)entry.getKey();
            AuthInfo info = (AuthInfo)entry.getValue();
            if (setOfAllowableAccountTypes != null && !setOfAllowableAccountTypes.contains(type)) continue;
            this.mAuthenticatorInfosToDisplay.add(info);
        }
        if (this.mAuthenticatorInfosToDisplay.isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putString("errorMessage", "no allowable account types");
            this.setResult(-1, new Intent().putExtras(bundle));
            this.finish();
            return;
        }
        if (this.mAuthenticatorInfosToDisplay.size() == 1) {
            this.setResultAndFinish(this.mAuthenticatorInfosToDisplay.get((int)0).desc.type);
            return;
        }
        this.setContentView(17367106);
        ListView list = (ListView)this.findViewById(16908298);
        list.setAdapter(new AccountArrayAdapter((Context)this, 17367043, this.mAuthenticatorInfosToDisplay));
        list.setChoiceMode(0);
        list.setTextFilterEnabled(false);
        list.setOnItemClickListener(new AdapterView.OnItemClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ChooseAccountTypeActivity this$0;

            private void $$robo$$android_accounts_ChooseAccountTypeActivity_1$__constructor__(ChooseAccountTypeActivity this$0) {
            }

            private final void $$robo$$android_accounts_ChooseAccountTypeActivity_1$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                this.this$0.setResultAndFinish(((AuthInfo)((ChooseAccountTypeActivity)this.this$0).mAuthenticatorInfosToDisplay.get((int)position)).desc.type);
            }

            private void __constructor__(ChooseAccountTypeActivity chooseAccountTypeActivity) {
                this.$$robo$$android_accounts_ChooseAccountTypeActivity_1$__constructor__(chooseAccountTypeActivity);
            }
            {
                this.this$0 = chooseAccountTypeActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountTypeActivity_1$__constructor__(android.accounts.ChooseAccountTypeActivity ), 0, this, chooseAccountTypeActivity);
            }

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_accounts_ChooseAccountTypeActivity_1$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_accounts_ChooseAccountTypeActivity$setResultAndFinish(String type) {
        Bundle bundle = new Bundle();
        bundle.putString("accountType", type);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable("AccountChooser", 2)) {
            Log.v("AccountChooser", "ChooseAccountTypeActivity.setResultAndFinish: selected account type " + type);
        }
        this.finish();
    }

    private final void $$robo$$android_accounts_ChooseAccountTypeActivity$buildTypeToAuthDescriptionMap() {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            Drawable icon;
            String name;
            block6: {
                name = null;
                icon = null;
                try {
                    Context authContext = this.createPackageContext(desc.packageName, 0);
                    icon = authContext.getDrawable(desc.iconId);
                    CharSequence sequence = authContext.getResources().getText(desc.labelId);
                    if (sequence != null) {
                        name = sequence.toString();
                    }
                    name = sequence.toString();
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (Log.isLoggable("AccountChooser", 5)) {
                        Log.w("AccountChooser", "No icon name for account type " + desc.type);
                    }
                }
                catch (Resources.NotFoundException e) {
                    if (!Log.isLoggable("AccountChooser", 5)) break block6;
                    Log.w("AccountChooser", "No icon resource for account type " + desc.type);
                }
            }
            AuthInfo authInfo = new AuthInfo(desc, name, icon);
            this.mTypeToAuthenticatorInfo.put(desc.type, authInfo);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_accounts_ChooseAccountTypeActivity$__constructor__();
    }

    public ChooseAccountTypeActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountTypeActivity$__constructor__(), 0, this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_accounts_ChooseAccountTypeActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private void setResultAndFinish(String string2) {
        InvokeDynamicSupport.bootstrap("setResultAndFinish", $$robo$$android_accounts_ChooseAccountTypeActivity$setResultAndFinish(java.lang.String ), 0, this, string2);
    }

    private void buildTypeToAuthDescriptionMap() {
        InvokeDynamicSupport.bootstrap("buildTypeToAuthDescriptionMap", $$robo$$android_accounts_ChooseAccountTypeActivity$buildTypeToAuthDescriptionMap(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooseAccountTypeActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AccountArrayAdapter
    extends ArrayAdapter<AuthInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private LayoutInflater mLayoutInflater;
        private ArrayList<AuthInfo> mInfos;

        private void $$robo$$android_accounts_ChooseAccountTypeActivity_AccountArrayAdapter$__constructor__(Context context, int textViewResourceId, ArrayList<AuthInfo> infos) {
            this.mInfos = infos;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        private final View $$robo$$android_accounts_ChooseAccountTypeActivity_AccountArrayAdapter$getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.mLayoutInflater.inflate(17367105, null);
                holder = new ViewHolder();
                holder.text = (TextView)convertView.findViewById(16909128);
                holder.icon = (ImageView)convertView.findViewById(16909127);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.text.setText(this.mInfos.get((int)position).name);
            holder.icon.setImageDrawable(this.mInfos.get((int)position).drawable);
            return convertView;
        }

        private void __constructor__(Context context, int n, ArrayList<AuthInfo> arrayList) {
            this.$$robo$$android_accounts_ChooseAccountTypeActivity_AccountArrayAdapter$__constructor__(context, n, arrayList);
        }

        public AccountArrayAdapter(Context context, int n, ArrayList<AuthInfo> arrayList) {
            super(context, n, arrayList);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountTypeActivity_AccountArrayAdapter$__constructor__(android.content.Context int java.util.ArrayList<android.accounts.ChooseAccountTypeActivity$AuthInfo> ), 0, this, context, n, arrayList);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_accounts_ChooseAccountTypeActivity_AccountArrayAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        public /* synthetic */ AccountArrayAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccountArrayAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ViewHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ImageView icon;
        TextView text;

        private void $$robo$$android_accounts_ChooseAccountTypeActivity_ViewHolder$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_accounts_ChooseAccountTypeActivity_ViewHolder$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_accounts_ChooseAccountTypeActivity_ViewHolder$__constructor__();
        }

        private ViewHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountTypeActivity_ViewHolder$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_accounts_ChooseAccountTypeActivity_ViewHolder$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AuthInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AuthenticatorDescription desc;
        String name;
        Drawable drawable;

        private void $$robo$$android_accounts_ChooseAccountTypeActivity_AuthInfo$__constructor__(AuthenticatorDescription desc, String name, Drawable drawable2) {
            this.desc = desc;
            this.name = name;
            this.drawable = drawable2;
        }

        private void __constructor__(AuthenticatorDescription authenticatorDescription, String string2, Drawable drawable2) {
            this.$$robo$$android_accounts_ChooseAccountTypeActivity_AuthInfo$__constructor__(authenticatorDescription, string2, drawable2);
        }

        AuthInfo(AuthenticatorDescription authenticatorDescription, String string2, Drawable drawable2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_ChooseAccountTypeActivity_AuthInfo$__constructor__(android.accounts.AuthenticatorDescription java.lang.String android.graphics.drawable.Drawable ), 0, this, authenticatorDescription, string2, drawable2);
        }

        public /* synthetic */ AuthInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

