/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppOpsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    Context mContext;
    IAppOpsService mService;
    ArrayMap<OnOpChangedListener, IAppOpsCallback> mModeWatchers;
    static IBinder sToken;
    public static int MODE_ALLOWED = 0;
    public static int MODE_IGNORED = 1;
    public static int MODE_ERRORED = 2;
    public static int MODE_DEFAULT = 3;
    public static int OP_NONE = -1;
    public static int OP_COARSE_LOCATION = 0;
    public static int OP_FINE_LOCATION = 1;
    public static int OP_GPS = 2;
    public static int OP_VIBRATE = 3;
    public static int OP_READ_CONTACTS = 4;
    public static int OP_WRITE_CONTACTS = 5;
    public static int OP_READ_CALL_LOG = 6;
    public static int OP_WRITE_CALL_LOG = 7;
    public static int OP_READ_CALENDAR = 8;
    public static int OP_WRITE_CALENDAR = 9;
    public static int OP_WIFI_SCAN = 10;
    public static int OP_POST_NOTIFICATION = 11;
    public static int OP_NEIGHBORING_CELLS = 12;
    public static int OP_CALL_PHONE = 13;
    public static int OP_READ_SMS = 14;
    public static int OP_WRITE_SMS = 15;
    public static int OP_RECEIVE_SMS = 16;
    public static int OP_RECEIVE_EMERGECY_SMS = 17;
    public static int OP_RECEIVE_MMS = 18;
    public static int OP_RECEIVE_WAP_PUSH = 19;
    public static int OP_SEND_SMS = 20;
    public static int OP_READ_ICC_SMS = 21;
    public static int OP_WRITE_ICC_SMS = 22;
    public static int OP_WRITE_SETTINGS = 23;
    public static int OP_SYSTEM_ALERT_WINDOW = 24;
    public static int OP_ACCESS_NOTIFICATIONS = 25;
    public static int OP_CAMERA = 26;
    public static int OP_RECORD_AUDIO = 27;
    public static int OP_PLAY_AUDIO = 28;
    public static int OP_READ_CLIPBOARD = 29;
    public static int OP_WRITE_CLIPBOARD = 30;
    public static int OP_TAKE_MEDIA_BUTTONS = 31;
    public static int OP_TAKE_AUDIO_FOCUS = 32;
    public static int OP_AUDIO_MASTER_VOLUME = 33;
    public static int OP_AUDIO_VOICE_VOLUME = 34;
    public static int OP_AUDIO_RING_VOLUME = 35;
    public static int OP_AUDIO_MEDIA_VOLUME = 36;
    public static int OP_AUDIO_ALARM_VOLUME = 37;
    public static int OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static int OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static int OP_WAKE_LOCK = 40;
    public static int OP_MONITOR_LOCATION = 41;
    public static int OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static int OP_GET_USAGE_STATS = 43;
    public static int OP_MUTE_MICROPHONE = 44;
    public static int OP_TOAST_WINDOW = 45;
    public static int OP_PROJECT_MEDIA = 46;
    public static int OP_ACTIVATE_VPN = 47;
    public static int OP_WRITE_WALLPAPER = 48;
    public static int OP_ASSIST_STRUCTURE = 49;
    public static int OP_ASSIST_SCREENSHOT = 50;
    public static int OP_READ_PHONE_STATE = 51;
    public static int OP_ADD_VOICEMAIL = 52;
    public static int OP_USE_SIP = 53;
    public static int OP_PROCESS_OUTGOING_CALLS = 54;
    public static int OP_USE_FINGERPRINT = 55;
    public static int OP_BODY_SENSORS = 56;
    public static int OP_READ_CELL_BROADCASTS = 57;
    public static int OP_MOCK_LOCATION = 58;
    public static int OP_READ_EXTERNAL_STORAGE = 59;
    public static int OP_WRITE_EXTERNAL_STORAGE = 60;
    public static int OP_TURN_SCREEN_ON = 61;
    public static int OP_GET_ACCOUNTS = 62;
    public static int OP_RUN_IN_BACKGROUND = 63;
    public static int _NUM_OP = 64;
    public static String OPSTR_COARSE_LOCATION = "android:coarse_location";
    public static String OPSTR_FINE_LOCATION = "android:fine_location";
    public static String OPSTR_MONITOR_LOCATION = "android:monitor_location";
    public static String OPSTR_MONITOR_HIGH_POWER_LOCATION = "android:monitor_location_high_power";
    public static String OPSTR_GET_USAGE_STATS = "android:get_usage_stats";
    public static String OPSTR_ACTIVATE_VPN = "android:activate_vpn";
    public static String OPSTR_READ_CONTACTS = "android:read_contacts";
    public static String OPSTR_WRITE_CONTACTS = "android:write_contacts";
    public static String OPSTR_READ_CALL_LOG = "android:read_call_log";
    public static String OPSTR_WRITE_CALL_LOG = "android:write_call_log";
    public static String OPSTR_READ_CALENDAR = "android:read_calendar";
    public static String OPSTR_WRITE_CALENDAR = "android:write_calendar";
    public static String OPSTR_CALL_PHONE = "android:call_phone";
    public static String OPSTR_READ_SMS = "android:read_sms";
    public static String OPSTR_RECEIVE_SMS = "android:receive_sms";
    public static String OPSTR_RECEIVE_MMS = "android:receive_mms";
    public static String OPSTR_RECEIVE_WAP_PUSH = "android:receive_wap_push";
    public static String OPSTR_SEND_SMS = "android:send_sms";
    public static String OPSTR_CAMERA = "android:camera";
    public static String OPSTR_RECORD_AUDIO = "android:record_audio";
    public static String OPSTR_READ_PHONE_STATE = "android:read_phone_state";
    public static String OPSTR_ADD_VOICEMAIL = "android:add_voicemail";
    public static String OPSTR_USE_SIP = "android:use_sip";
    public static String OPSTR_USE_FINGERPRINT = "android:use_fingerprint";
    public static String OPSTR_BODY_SENSORS = "android:body_sensors";
    public static String OPSTR_READ_CELL_BROADCASTS = "android:read_cell_broadcasts";
    public static String OPSTR_MOCK_LOCATION = "android:mock_location";
    public static String OPSTR_READ_EXTERNAL_STORAGE = "android:read_external_storage";
    public static String OPSTR_WRITE_EXTERNAL_STORAGE = "android:write_external_storage";
    public static String OPSTR_SYSTEM_ALERT_WINDOW = "android:system_alert_window";
    public static String OPSTR_WRITE_SETTINGS = "android:write_settings";
    public static String OPSTR_GET_ACCOUNTS = "android:get_accounts";
    private static int[] RUNTIME_PERMISSIONS_OPS;
    private static int[] sOpToSwitch;
    private static String[] sOpToString;
    private static String[] sOpNames;
    private static String[] sOpPerms;
    private static String[] sOpRestrictions;
    private static boolean[] sOpAllowSystemRestrictionBypass;
    private static int[] sOpDefaultMode;
    private static boolean[] sOpDisableReset;
    private static HashMap<String, Integer> sOpStrToOp;
    private static HashMap<String, Integer> sRuntimePermToOp;

    private static final int $$robo$$android_app_AppOpsManager$opToSwitch(int op) {
        return sOpToSwitch[op];
    }

    private static final String $$robo$$android_app_AppOpsManager$opToName(int op) {
        if (op == -1) {
            return "NONE";
        }
        return op < sOpNames.length ? sOpNames[op] : "Unknown(" + op + ")";
    }

    private static final int $$robo$$android_app_AppOpsManager$strDebugOpToOp(String op) {
        for (int i = 0; i < sOpNames.length; ++i) {
            if (!sOpNames[i].equals(op)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown operation string: " + op);
    }

    private static final String $$robo$$android_app_AppOpsManager$opToPermission(int op) {
        return sOpPerms[op];
    }

    private static final String $$robo$$android_app_AppOpsManager$opToRestriction(int op) {
        return sOpRestrictions[op];
    }

    private static final int $$robo$$android_app_AppOpsManager$permissionToOpCode(String permission2) {
        Integer boxedOpCode = sRuntimePermToOp.get(permission2);
        return boxedOpCode != null ? boxedOpCode : -1;
    }

    private static final boolean $$robo$$android_app_AppOpsManager$opAllowSystemBypassRestriction(int op) {
        return sOpAllowSystemRestrictionBypass[op];
    }

    private static final int $$robo$$android_app_AppOpsManager$opToDefaultMode(int op) {
        return sOpDefaultMode[op];
    }

    private static final boolean $$robo$$android_app_AppOpsManager$opAllowsReset(int op) {
        return !sOpDisableReset[op];
    }

    private void $$robo$$android_app_AppOpsManager$__constructor__(Context context, IAppOpsService service) {
        this.mModeWatchers = new ArrayMap();
        this.mContext = context;
        this.mService = service;
    }

    private final List<PackageOps> $$robo$$android_app_AppOpsManager$getPackagesForOps(int[] ops) {
        try {
            return this.mService.getPackagesForOps(ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<PackageOps> $$robo$$android_app_AppOpsManager$getOpsForPackage(int uid, String packageName, int[] ops) {
        try {
            return this.mService.getOpsForPackage(uid, packageName, ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$setUidMode(int code, int uid, int mode) {
        try {
            this.mService.setUidMode(code, uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$setUidMode(String appOp, int uid, int mode) {
        try {
            this.mService.setUidMode(AppOpsManager.strOpToOp(appOp), uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$setUserRestriction(int code, boolean restricted, IBinder token) {
        this.setUserRestriction(code, restricted, token, null);
    }

    private final void $$robo$$android_app_AppOpsManager$setUserRestriction(int code, boolean restricted, IBinder token, String[] exceptionPackages) {
        this.setUserRestrictionForUser(code, restricted, token, exceptionPackages, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_AppOpsManager$setUserRestrictionForUser(int code, boolean restricted, IBinder token, String[] exceptionPackages, int userId) {
        try {
            this.mService.setUserRestriction(code, restricted, token, userId, exceptionPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$setMode(int code, int uid, String packageName, int mode) {
        try {
            this.mService.setMode(code, uid, packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$setRestriction(int code, int usage, int mode, String[] exceptionPackages) {
        try {
            int uid = Binder.getCallingUid();
            this.mService.setAudioRestriction(code, usage, uid, mode, exceptionPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$resetAllModes() {
        try {
            this.mService.resetAllModes(UserHandle.myUserId(), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final String $$robo$$android_app_AppOpsManager$permissionToOp(String permission2) {
        Integer opCode = sRuntimePermToOp.get(permission2);
        if (opCode == null) {
            return null;
        }
        return sOpToString[opCode];
    }

    private final void $$robo$$android_app_AppOpsManager$startWatchingMode(String op, String packageName, OnOpChangedListener callback) {
        this.startWatchingMode(AppOpsManager.strOpToOp(op), packageName, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_AppOpsManager$startWatchingMode(int op, String packageName, OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.get(callback);
            if (cb == null) {
                cb = new ShadowedObject(this, callback){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ OnOpChangedListener val$callback;
                    /* synthetic */ AppOpsManager this$0;

                    private void $$robo$$android_app_AppOpsManager_1$__constructor__(AppOpsManager this$0, OnOpChangedListener onOpChangedListener) {
                    }

                    private final void $$robo$$android_app_AppOpsManager_1$opChanged(int op, int uid, String packageName) {
                        if (this.val$callback instanceof OnOpChangedInternalListener) {
                            ((OnOpChangedInternalListener)this.val$callback).onOpChanged(op, packageName);
                        }
                        if (sOpToString[op] != null) {
                            this.val$callback.onOpChanged(sOpToString[op], packageName);
                        }
                    }

                    private void __constructor__(AppOpsManager appOpsManager, OnOpChangedListener onOpChangedListener) {
                        this.$$robo$$android_app_AppOpsManager_1$__constructor__(appOpsManager, onOpChangedListener);
                    }
                    {
                        this.this$0 = appOpsManager;
                        this.val$callback = onOpChangedListener;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_1$__constructor__(android.app.AppOpsManager android.app.AppOpsManager$OnOpChangedListener ), 0, this, appOpsManager, onOpChangedListener);
                    }

                    @Override
                    public void opChanged(int n, int n2, String string2) {
                        InvokeDynamicSupport.bootstrap("opChanged", $$robo$$android_app_AppOpsManager_1$opChanged(int int java.lang.String ), 0, this, n, n2, string2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                this.mModeWatchers.put(callback, cb);
            }
            try {
                this.mService.startWatchingMode(op, packageName, cb);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_AppOpsManager$stopWatchingMode(OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.get(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingMode(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private final String $$robo$$android_app_AppOpsManager$buildSecurityExceptionMsg(int op, int uid, String packageName) {
        return packageName + " from uid " + uid + " not allowed to perform " + sOpNames[op];
    }

    private static final int $$robo$$android_app_AppOpsManager$strOpToOp(String op) {
        Integer val = sOpStrToOp.get(op);
        if (val == null) {
            throw new IllegalArgumentException("Unknown operation string: " + op);
        }
        return val;
    }

    private final int $$robo$$android_app_AppOpsManager$checkOp(String op, int uid, String packageName) {
        return this.checkOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$checkOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$noteOp(String op, int uid, String packageName) {
        return this.noteOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$noteOpNoThrow(String op, int uid, String packageName) {
        return this.noteOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$noteProxyOp(String op, String proxiedPackageName) {
        return this.noteProxyOp(AppOpsManager.strOpToOp(op), proxiedPackageName);
    }

    private final int $$robo$$android_app_AppOpsManager$noteProxyOpNoThrow(String op, String proxiedPackageName) {
        return this.noteProxyOpNoThrow(AppOpsManager.strOpToOp(op), proxiedPackageName);
    }

    private final int $$robo$$android_app_AppOpsManager$startOp(String op, int uid, String packageName) {
        return this.startOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$startOpNoThrow(String op, int uid, String packageName) {
        return this.startOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final void $$robo$$android_app_AppOpsManager$finishOp(String op, int uid, String packageName) {
        this.finishOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    private final int $$robo$$android_app_AppOpsManager$checkOp(int op, int uid, String packageName) {
        try {
            int mode = this.mService.checkOperation(op, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$checkOpNoThrow(int op, int uid, String packageName) {
        try {
            return this.mService.checkOperation(op, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$checkPackage(int uid, String packageName) {
        try {
            if (this.mService.checkPackage(uid, packageName) != 0) {
                throw new SecurityException("Package " + packageName + " does not belong to " + uid);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$checkAudioOp(int op, int stream, int uid, String packageName) {
        try {
            int mode = this.mService.checkAudioOperation(op, stream, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$checkAudioOpNoThrow(int op, int stream, int uid, String packageName) {
        try {
            return this.mService.checkAudioOperation(op, stream, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$noteOp(int op, int uid, String packageName) {
        try {
            int mode = this.mService.noteOperation(op, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$noteProxyOp(int op, String proxiedPackageName) {
        int mode = this.noteProxyOpNoThrow(op, proxiedPackageName);
        if (mode == 2) {
            throw new SecurityException("Proxy package " + this.mContext.getOpPackageName() + " from uid " + Process.myUid() + " or calling package " + proxiedPackageName + " from uid " + Binder.getCallingUid() + " not allowed to perform " + sOpNames[op]);
        }
        return mode;
    }

    private final int $$robo$$android_app_AppOpsManager$noteProxyOpNoThrow(int op, String proxiedPackageName) {
        try {
            return this.mService.noteProxyOperation(op, this.mContext.getOpPackageName(), Binder.getCallingUid(), proxiedPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$noteOpNoThrow(int op, int uid, String packageName) {
        try {
            return this.mService.noteOperation(op, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$noteOp(int op) {
        return this.noteOp(op, Process.myUid(), this.mContext.getOpPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IBinder $$robo$$android_app_AppOpsManager$getToken(IAppOpsService service) {
        Class<AppOpsManager> clazz = AppOpsManager.class;
        synchronized (AppOpsManager.class) {
            if (sToken != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return sToken;
            }
            try {
                sToken = service.getToken(new Binder());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            return sToken;
        }
    }

    private final int $$robo$$android_app_AppOpsManager$startOp(int op, int uid, String packageName) {
        try {
            int mode = this.mService.startOperation(AppOpsManager.getToken(this.mService), op, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$startOpNoThrow(int op, int uid, String packageName) {
        try {
            return this.mService.startOperation(AppOpsManager.getToken(this.mService), op, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_AppOpsManager$startOp(int op) {
        return this.startOp(op, Process.myUid(), this.mContext.getOpPackageName());
    }

    private final void $$robo$$android_app_AppOpsManager$finishOp(int op, int uid, String packageName) {
        try {
            this.mService.finishOperation(AppOpsManager.getToken(this.mService), op, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AppOpsManager$finishOp(int op) {
        this.finishOp(op, Process.myUid(), this.mContext.getOpPackageName());
    }

    static void __staticInitializer__() {
        RUNTIME_PERMISSIONS_OPS = new int[]{4, 5, 62, 8, 9, 20, 16, 14, 19, 18, 57, 59, 60, 0, 1, 51, 13, 6, 7, 52, 53, 54, 27, 26, 56};
        sOpToSwitch = new int[]{0, 0, 0, 3, 4, 5, 6, 7, 8, 9, 0, 11, 0, 13, 14, 15, 16, 16, 16, 16, 20, 14, 15, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
        sOpToString = new String[]{"android:coarse_location", "android:fine_location", null, null, "android:read_contacts", "android:write_contacts", "android:read_call_log", "android:write_call_log", "android:read_calendar", "android:write_calendar", null, null, null, "android:call_phone", "android:read_sms", null, "android:receive_sms", null, "android:receive_mms", "android:receive_wap_push", "android:send_sms", null, null, "android:write_settings", "android:system_alert_window", null, "android:camera", "android:record_audio", null, null, null, null, null, null, null, null, null, null, null, null, null, "android:monitor_location", "android:monitor_location_high_power", "android:get_usage_stats", null, null, null, "android:activate_vpn", null, null, null, "android:read_phone_state", "android:add_voicemail", "android:use_sip", null, "android:use_fingerprint", "android:body_sensors", "android:read_cell_broadcasts", "android:mock_location", "android:read_external_storage", "android:write_external_storage", null, "android:get_accounts", null};
        sOpNames = new String[]{"COARSE_LOCATION", "FINE_LOCATION", "GPS", "VIBRATE", "READ_CONTACTS", "WRITE_CONTACTS", "READ_CALL_LOG", "WRITE_CALL_LOG", "READ_CALENDAR", "WRITE_CALENDAR", "WIFI_SCAN", "POST_NOTIFICATION", "NEIGHBORING_CELLS", "CALL_PHONE", "READ_SMS", "WRITE_SMS", "RECEIVE_SMS", "RECEIVE_EMERGECY_SMS", "RECEIVE_MMS", "RECEIVE_WAP_PUSH", "SEND_SMS", "READ_ICC_SMS", "WRITE_ICC_SMS", "WRITE_SETTINGS", "SYSTEM_ALERT_WINDOW", "ACCESS_NOTIFICATIONS", "CAMERA", "RECORD_AUDIO", "PLAY_AUDIO", "READ_CLIPBOARD", "WRITE_CLIPBOARD", "TAKE_MEDIA_BUTTONS", "TAKE_AUDIO_FOCUS", "AUDIO_MASTER_VOLUME", "AUDIO_VOICE_VOLUME", "AUDIO_RING_VOLUME", "AUDIO_MEDIA_VOLUME", "AUDIO_ALARM_VOLUME", "AUDIO_NOTIFICATION_VOLUME", "AUDIO_BLUETOOTH_VOLUME", "WAKE_LOCK", "MONITOR_LOCATION", "MONITOR_HIGH_POWER_LOCATION", "GET_USAGE_STATS", "MUTE_MICROPHONE", "TOAST_WINDOW", "PROJECT_MEDIA", "ACTIVATE_VPN", "WRITE_WALLPAPER", "ASSIST_STRUCTURE", "ASSIST_SCREENSHOT", "OP_READ_PHONE_STATE", "ADD_VOICEMAIL", "USE_SIP", "PROCESS_OUTGOING_CALLS", "USE_FINGERPRINT", "BODY_SENSORS", "READ_CELL_BROADCASTS", "MOCK_LOCATION", "READ_EXTERNAL_STORAGE", "WRITE_EXTERNAL_STORAGE", "TURN_ON_SCREEN", "GET_ACCOUNTS", "RUN_IN_BACKGROUND"};
        sOpPerms = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", null, "android.permission.VIBRATE", "android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR", "android.permission.ACCESS_WIFI_STATE", null, null, "android.permission.CALL_PHONE", "android.permission.READ_SMS", null, "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_EMERGENCY_BROADCAST", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.SEND_SMS", "android.permission.READ_SMS", null, "android.permission.WRITE_SETTINGS", "android.permission.SYSTEM_ALERT_WINDOW", "android.permission.ACCESS_NOTIFICATIONS", "android.permission.CAMERA", "android.permission.RECORD_AUDIO", null, null, null, null, null, null, null, null, null, null, null, null, "android.permission.WAKE_LOCK", null, null, "android.permission.PACKAGE_USAGE_STATS", null, null, null, null, null, null, null, "android.permission.READ_PHONE_STATE", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.USE_FINGERPRINT", "android.permission.BODY_SENSORS", "android.permission.READ_CELL_BROADCASTS", null, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", null, "android.permission.GET_ACCOUNTS", null};
        sOpRestrictions = new String[]{"no_share_location", "no_share_location", "no_share_location", null, null, null, "no_outgoing_calls", "no_outgoing_calls", null, null, "no_share_location", null, null, null, "no_sms", "no_sms", "no_sms", null, "no_sms", null, "no_sms", "no_sms", "no_sms", null, "no_create_windows", null, "no_camera", "no_record_audio", null, null, null, null, null, "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", null, "no_share_location", "no_share_location", null, "no_unmute_microphone", "no_create_windows", null, null, "no_wallpaper", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        sOpAllowSystemRestrictionBypass = new boolean[]{true, true, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        sOpDefaultMode = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0};
        sOpDisableReset = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        sOpStrToOp = new HashMap();
        sRuntimePermToOp = new HashMap();
        if (sOpToSwitch.length != 64) {
            throw new IllegalStateException("sOpToSwitch length " + sOpToSwitch.length + " should be " + 64);
        }
        if (sOpToString.length != 64) {
            throw new IllegalStateException("sOpToString length " + sOpToString.length + " should be " + 64);
        }
        if (sOpNames.length != 64) {
            throw new IllegalStateException("sOpNames length " + sOpNames.length + " should be " + 64);
        }
        if (sOpPerms.length != 64) {
            throw new IllegalStateException("sOpPerms length " + sOpPerms.length + " should be " + 64);
        }
        if (sOpDefaultMode.length != 64) {
            throw new IllegalStateException("sOpDefaultMode length " + sOpDefaultMode.length + " should be " + 64);
        }
        if (sOpDisableReset.length != 64) {
            throw new IllegalStateException("sOpDisableReset length " + sOpDisableReset.length + " should be " + 64);
        }
        if (sOpRestrictions.length != 64) {
            throw new IllegalStateException("sOpRestrictions length " + sOpRestrictions.length + " should be " + 64);
        }
        if (sOpAllowSystemRestrictionBypass.length != 64) {
            throw new IllegalStateException("sOpAllowSYstemRestrictionsBypass length " + sOpRestrictions.length + " should be " + 64);
        }
        for (int i = 0; i < 64; ++i) {
            if (sOpToString[i] == null) continue;
            sOpStrToOp.put(sOpToString[i], i);
        }
        for (int op : RUNTIME_PERMISSIONS_OPS) {
            if (sOpPerms[op] == null) continue;
            sRuntimePermToOp.put(sOpPerms[op], op);
        }
    }

    public static int opToSwitch(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("opToSwitch", $$robo$$android_app_AppOpsManager$opToSwitch(int ), 0, (int)n);
    }

    public static String opToName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("opToName", $$robo$$android_app_AppOpsManager$opToName(int ), 0, (int)n);
    }

    public static int strDebugOpToOp(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("strDebugOpToOp", $$robo$$android_app_AppOpsManager$strDebugOpToOp(java.lang.String ), 0, (String)string2);
    }

    public static String opToPermission(int n) {
        return InvokeDynamicSupport.bootstrapStatic("opToPermission", $$robo$$android_app_AppOpsManager$opToPermission(int ), 0, (int)n);
    }

    public static String opToRestriction(int n) {
        return InvokeDynamicSupport.bootstrapStatic("opToRestriction", $$robo$$android_app_AppOpsManager$opToRestriction(int ), 0, (int)n);
    }

    public static int permissionToOpCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("permissionToOpCode", $$robo$$android_app_AppOpsManager$permissionToOpCode(java.lang.String ), 0, (String)string2);
    }

    public static boolean opAllowSystemBypassRestriction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("opAllowSystemBypassRestriction", $$robo$$android_app_AppOpsManager$opAllowSystemBypassRestriction(int ), 0, (int)n);
    }

    public static int opToDefaultMode(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("opToDefaultMode", $$robo$$android_app_AppOpsManager$opToDefaultMode(int ), 0, (int)n);
    }

    public static boolean opAllowsReset(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("opAllowsReset", $$robo$$android_app_AppOpsManager$opAllowsReset(int ), 0, (int)n);
    }

    private void __constructor__(Context context, IAppOpsService iAppOpsService) {
        this.$$robo$$android_app_AppOpsManager$__constructor__(context, iAppOpsService);
    }

    AppOpsManager(Context context, IAppOpsService iAppOpsService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager$__constructor__(android.content.Context com.android.internal.app.IAppOpsService ), 0, this, context, iAppOpsService);
    }

    public List<PackageOps> getPackagesForOps(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getPackagesForOps", $$robo$$android_app_AppOpsManager$getPackagesForOps(int[] ), 0, this, nArray);
    }

    public List<PackageOps> getOpsForPackage(int n, String string2, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getOpsForPackage", $$robo$$android_app_AppOpsManager$getOpsForPackage(int java.lang.String int[] ), 0, this, n, string2, nArray);
    }

    public void setUidMode(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setUidMode", $$robo$$android_app_AppOpsManager$setUidMode(int int int ), 0, this, n, n2, n3);
    }

    public void setUidMode(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUidMode", $$robo$$android_app_AppOpsManager$setUidMode(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public void setUserRestriction(int n, boolean bl, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_app_AppOpsManager$setUserRestriction(int boolean android.os.IBinder ), 0, this, n, bl, iBinder);
    }

    public void setUserRestriction(int n, boolean bl, IBinder iBinder, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_app_AppOpsManager$setUserRestriction(int boolean android.os.IBinder java.lang.String[] ), 0, this, n, bl, iBinder, stringArray);
    }

    public void setUserRestrictionForUser(int n, boolean bl, IBinder iBinder, String[] stringArray, int n2) {
        InvokeDynamicSupport.bootstrap("setUserRestrictionForUser", $$robo$$android_app_AppOpsManager$setUserRestrictionForUser(int boolean android.os.IBinder java.lang.String[] int ), 0, this, n, bl, iBinder, stringArray, n2);
    }

    public void setMode(int n, int n2, String string2, int n3) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_app_AppOpsManager$setMode(int int java.lang.String int ), 0, this, n, n2, string2, n3);
    }

    public void setRestriction(int n, int n2, int n3, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setRestriction", $$robo$$android_app_AppOpsManager$setRestriction(int int int java.lang.String[] ), 0, this, n, n2, n3, stringArray);
    }

    public void resetAllModes() {
        InvokeDynamicSupport.bootstrap("resetAllModes", $$robo$$android_app_AppOpsManager$resetAllModes(), 0, this);
    }

    public static String permissionToOp(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("permissionToOp", $$robo$$android_app_AppOpsManager$permissionToOp(java.lang.String ), 0, (String)string2);
    }

    public void startWatchingMode(String string2, String string3, OnOpChangedListener onOpChangedListener) {
        InvokeDynamicSupport.bootstrap("startWatchingMode", $$robo$$android_app_AppOpsManager$startWatchingMode(java.lang.String java.lang.String android.app.AppOpsManager$OnOpChangedListener ), 0, this, string2, string3, onOpChangedListener);
    }

    public void startWatchingMode(int n, String string2, OnOpChangedListener onOpChangedListener) {
        InvokeDynamicSupport.bootstrap("startWatchingMode", $$robo$$android_app_AppOpsManager$startWatchingMode(int java.lang.String android.app.AppOpsManager$OnOpChangedListener ), 0, this, n, string2, onOpChangedListener);
    }

    public void stopWatchingMode(OnOpChangedListener onOpChangedListener) {
        InvokeDynamicSupport.bootstrap("stopWatchingMode", $$robo$$android_app_AppOpsManager$stopWatchingMode(android.app.AppOpsManager$OnOpChangedListener ), 0, this, onOpChangedListener);
    }

    private String buildSecurityExceptionMsg(int n, int n2, String string2) {
        return InvokeDynamicSupport.bootstrap("buildSecurityExceptionMsg", $$robo$$android_app_AppOpsManager$buildSecurityExceptionMsg(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public static int strOpToOp(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("strOpToOp", $$robo$$android_app_AppOpsManager$strOpToOp(java.lang.String ), 0, (String)string2);
    }

    public int checkOp(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkOp", $$robo$$android_app_AppOpsManager$checkOp(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int checkOpNoThrow(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("checkOpNoThrow", $$robo$$android_app_AppOpsManager$checkOpNoThrow(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int noteOp(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("noteOp", $$robo$$android_app_AppOpsManager$noteOp(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int noteOpNoThrow(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("noteOpNoThrow", $$robo$$android_app_AppOpsManager$noteOpNoThrow(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int noteProxyOp(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("noteProxyOp", $$robo$$android_app_AppOpsManager$noteProxyOp(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int noteProxyOpNoThrow(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("noteProxyOpNoThrow", $$robo$$android_app_AppOpsManager$noteProxyOpNoThrow(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int startOp(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("startOp", $$robo$$android_app_AppOpsManager$startOp(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int startOpNoThrow(String string2, int n, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("startOpNoThrow", $$robo$$android_app_AppOpsManager$startOpNoThrow(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public void finishOp(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("finishOp", $$robo$$android_app_AppOpsManager$finishOp(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public int checkOp(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkOp", $$robo$$android_app_AppOpsManager$checkOp(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int checkOpNoThrow(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkOpNoThrow", $$robo$$android_app_AppOpsManager$checkOpNoThrow(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public void checkPackage(int n, String string2) {
        InvokeDynamicSupport.bootstrap("checkPackage", $$robo$$android_app_AppOpsManager$checkPackage(int java.lang.String ), 0, this, n, string2);
    }

    public int checkAudioOp(int n, int n2, int n3, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkAudioOp", $$robo$$android_app_AppOpsManager$checkAudioOp(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    public int checkAudioOpNoThrow(int n, int n2, int n3, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkAudioOpNoThrow", $$robo$$android_app_AppOpsManager$checkAudioOpNoThrow(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    public int noteOp(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("noteOp", $$robo$$android_app_AppOpsManager$noteOp(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int noteProxyOp(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("noteProxyOp", $$robo$$android_app_AppOpsManager$noteProxyOp(int java.lang.String ), 0, this, n, string2);
    }

    public int noteProxyOpNoThrow(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("noteProxyOpNoThrow", $$robo$$android_app_AppOpsManager$noteProxyOpNoThrow(int java.lang.String ), 0, this, n, string2);
    }

    public int noteOpNoThrow(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("noteOpNoThrow", $$robo$$android_app_AppOpsManager$noteOpNoThrow(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int noteOp(int n) {
        return (int)InvokeDynamicSupport.bootstrap("noteOp", $$robo$$android_app_AppOpsManager$noteOp(int ), 0, this, n);
    }

    public static IBinder getToken(IAppOpsService iAppOpsService) {
        return InvokeDynamicSupport.bootstrapStatic("getToken", $$robo$$android_app_AppOpsManager$getToken(com.android.internal.app.IAppOpsService ), 0, (IAppOpsService)iAppOpsService);
    }

    public int startOp(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("startOp", $$robo$$android_app_AppOpsManager$startOp(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int startOpNoThrow(int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("startOpNoThrow", $$robo$$android_app_AppOpsManager$startOpNoThrow(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public int startOp(int n) {
        return (int)InvokeDynamicSupport.bootstrap("startOp", $$robo$$android_app_AppOpsManager$startOp(int ), 0, this, n);
    }

    public void finishOp(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("finishOp", $$robo$$android_app_AppOpsManager$finishOp(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public void finishOp(int n) {
        InvokeDynamicSupport.bootstrap("finishOp", $$robo$$android_app_AppOpsManager$finishOp(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(AppOpsManager.class);
    }

    public /* synthetic */ AppOpsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppOpsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class OnOpChangedInternalListener
    implements OnOpChangedListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$__constructor__() {
        }

        private final void $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$onOpChanged(String op, String packageName) {
        }

        private final void $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$onOpChanged(int op, String packageName) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$__constructor__();
        }

        public OnOpChangedInternalListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$__constructor__(), 0, this);
        }

        @Override
        public void onOpChanged(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("onOpChanged", $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$onOpChanged(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public void onOpChanged(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onOpChanged", $$robo$$android_app_AppOpsManager_OnOpChangedInternalListener$onOpChanged(int java.lang.String ), 0, this, n, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnOpChangedInternalListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnOpChangedListener
    extends InstrumentedInterface {
        public void onOpChanged(String var1, String var2);
    }

    public static class OpEntry
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mOp;
        private int mMode;
        private long mTime;
        private long mRejectTime;
        private int mDuration;
        private int mProxyUid;
        private String mProxyPackageName;
        public static Parcelable.Creator<OpEntry> CREATOR;

        private void $$robo$$android_app_AppOpsManager_OpEntry$__constructor__(int op, int mode, long time, long rejectTime, int duration, int proxyUid, String proxyPackage) {
            this.mOp = op;
            this.mMode = mode;
            this.mTime = time;
            this.mRejectTime = rejectTime;
            this.mDuration = duration;
            this.mProxyUid = proxyUid;
            this.mProxyPackageName = proxyPackage;
        }

        private final int $$robo$$android_app_AppOpsManager_OpEntry$getOp() {
            return this.mOp;
        }

        private final int $$robo$$android_app_AppOpsManager_OpEntry$getMode() {
            return this.mMode;
        }

        private final long $$robo$$android_app_AppOpsManager_OpEntry$getTime() {
            return this.mTime;
        }

        private final long $$robo$$android_app_AppOpsManager_OpEntry$getRejectTime() {
            return this.mRejectTime;
        }

        private final boolean $$robo$$android_app_AppOpsManager_OpEntry$isRunning() {
            return this.mDuration == -1;
        }

        private final int $$robo$$android_app_AppOpsManager_OpEntry$getDuration() {
            return this.mDuration == -1 ? (int)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mTime) : this.mDuration;
        }

        private final int $$robo$$android_app_AppOpsManager_OpEntry$getProxyUid() {
            return this.mProxyUid;
        }

        private final String $$robo$$android_app_AppOpsManager_OpEntry$getProxyPackageName() {
            return this.mProxyPackageName;
        }

        private final int $$robo$$android_app_AppOpsManager_OpEntry$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_AppOpsManager_OpEntry$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mOp);
            dest.writeInt(this.mMode);
            dest.writeLong(this.mTime);
            dest.writeLong(this.mRejectTime);
            dest.writeInt(this.mDuration);
            dest.writeInt(this.mProxyUid);
            dest.writeString(this.mProxyPackageName);
        }

        private void $$robo$$android_app_AppOpsManager_OpEntry$__constructor__(Parcel source) {
            this.mOp = source.readInt();
            this.mMode = source.readInt();
            this.mTime = source.readLong();
            this.mRejectTime = source.readLong();
            this.mDuration = source.readInt();
            this.mProxyUid = source.readInt();
            this.mProxyPackageName = source.readString();
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<OpEntry>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_AppOpsManager_OpEntry_1$__constructor__() {
                }

                private final OpEntry $$robo$$android_app_AppOpsManager_OpEntry_1$createFromParcel(Parcel source) {
                    return new OpEntry(source);
                }

                private final OpEntry[] $$robo$$android_app_AppOpsManager_OpEntry_1$newArray(int size) {
                    return new OpEntry[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_AppOpsManager_OpEntry_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_OpEntry_1$__constructor__(), 0, this);
                }

                @Override
                public OpEntry createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_AppOpsManager_OpEntry_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public OpEntry[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_AppOpsManager_OpEntry_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, long l, long l2, int n3, int n4, String string2) {
            this.$$robo$$android_app_AppOpsManager_OpEntry$__constructor__(n, n2, l, l2, n3, n4, string2);
        }

        public OpEntry(int n, int n2, long l, long l2, int n3, int n4, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_OpEntry$__constructor__(int int long long int int java.lang.String ), 0, this, n, n2, l, l2, n3, n4, string2);
        }

        public int getOp() {
            return (int)InvokeDynamicSupport.bootstrap("getOp", $$robo$$android_app_AppOpsManager_OpEntry$getOp(), 0, this);
        }

        public int getMode() {
            return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_app_AppOpsManager_OpEntry$getMode(), 0, this);
        }

        public long getTime() {
            return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_app_AppOpsManager_OpEntry$getTime(), 0, this);
        }

        public long getRejectTime() {
            return (long)InvokeDynamicSupport.bootstrap("getRejectTime", $$robo$$android_app_AppOpsManager_OpEntry$getRejectTime(), 0, this);
        }

        public boolean isRunning() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_app_AppOpsManager_OpEntry$isRunning(), 0, this);
        }

        public int getDuration() {
            return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_app_AppOpsManager_OpEntry$getDuration(), 0, this);
        }

        public int getProxyUid() {
            return (int)InvokeDynamicSupport.bootstrap("getProxyUid", $$robo$$android_app_AppOpsManager_OpEntry$getProxyUid(), 0, this);
        }

        public String getProxyPackageName() {
            return InvokeDynamicSupport.bootstrap("getProxyPackageName", $$robo$$android_app_AppOpsManager_OpEntry$getProxyPackageName(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_AppOpsManager_OpEntry$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_AppOpsManager_OpEntry$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_AppOpsManager_OpEntry$__constructor__(parcel);
        }

        OpEntry(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_OpEntry$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        static {
            RobolectricInternals.classInitializing(OpEntry.class);
        }

        public /* synthetic */ OpEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PackageOps
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mPackageName;
        private int mUid;
        private List<OpEntry> mEntries;
        public static Parcelable.Creator<PackageOps> CREATOR;

        private void $$robo$$android_app_AppOpsManager_PackageOps$__constructor__(String packageName, int uid, List<OpEntry> entries) {
            this.mPackageName = packageName;
            this.mUid = uid;
            this.mEntries = entries;
        }

        private final String $$robo$$android_app_AppOpsManager_PackageOps$getPackageName() {
            return this.mPackageName;
        }

        private final int $$robo$$android_app_AppOpsManager_PackageOps$getUid() {
            return this.mUid;
        }

        private final List<OpEntry> $$robo$$android_app_AppOpsManager_PackageOps$getOps() {
            return this.mEntries;
        }

        private final int $$robo$$android_app_AppOpsManager_PackageOps$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_AppOpsManager_PackageOps$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mPackageName);
            dest.writeInt(this.mUid);
            dest.writeInt(this.mEntries.size());
            for (int i = 0; i < this.mEntries.size(); ++i) {
                this.mEntries.get(i).writeToParcel(dest, flags);
            }
        }

        private void $$robo$$android_app_AppOpsManager_PackageOps$__constructor__(Parcel source) {
            this.mPackageName = source.readString();
            this.mUid = source.readInt();
            this.mEntries = new ArrayList<OpEntry>();
            int N = source.readInt();
            for (int i = 0; i < N; ++i) {
                this.mEntries.add(OpEntry.CREATOR.createFromParcel(source));
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<PackageOps>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_AppOpsManager_PackageOps_1$__constructor__() {
                }

                private final PackageOps $$robo$$android_app_AppOpsManager_PackageOps_1$createFromParcel(Parcel source) {
                    return new PackageOps(source);
                }

                private final PackageOps[] $$robo$$android_app_AppOpsManager_PackageOps_1$newArray(int size) {
                    return new PackageOps[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_AppOpsManager_PackageOps_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_PackageOps_1$__constructor__(), 0, this);
                }

                @Override
                public PackageOps createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_AppOpsManager_PackageOps_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public PackageOps[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_AppOpsManager_PackageOps_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, int n, List<OpEntry> list) {
            this.$$robo$$android_app_AppOpsManager_PackageOps$__constructor__(string2, n, list);
        }

        public PackageOps(String string2, int n, List<OpEntry> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_PackageOps$__constructor__(java.lang.String int java.util.List<android.app.AppOpsManager$OpEntry> ), 0, this, string2, n, list);
        }

        public String getPackageName() {
            return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_app_AppOpsManager_PackageOps$getPackageName(), 0, this);
        }

        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_app_AppOpsManager_PackageOps$getUid(), 0, this);
        }

        public List<OpEntry> getOps() {
            return InvokeDynamicSupport.bootstrap("getOps", $$robo$$android_app_AppOpsManager_PackageOps$getOps(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_AppOpsManager_PackageOps$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_AppOpsManager_PackageOps$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_AppOpsManager_PackageOps$__constructor__(parcel);
        }

        PackageOps(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AppOpsManager_PackageOps$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        static {
            RobolectricInternals.classInitializing(PackageOps.class);
        }

        public /* synthetic */ PackageOps() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageOps)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

