/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import com.android.internal.util.ArrayUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResourcesManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ResourcesManager";
    private static boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private static Predicate<WeakReference<Resources>> sEmptyReferencePredicate;
    private CompatibilityInfo mResCompatibilityInfo;
    private Configuration mResConfiguration;
    private ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls;
    private ArrayList<WeakReference<Resources>> mResourceReferences;
    private WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences;
    private ArrayMap<Pair<Integer, DisplayAdjustments>, WeakReference<Display>> mDisplays;

    private void $$robo$$android_app_ResourcesManager$__constructor__() {
        this.mResConfiguration = new Configuration();
        this.mResourceImpls = new ArrayMap();
        this.mResourceReferences = new ArrayList();
        this.mActivityResourceReferences = new WeakHashMap();
        this.mDisplays = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourcesManager $$robo$$android_app_ResourcesManager$getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$invalidatePath(String path) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            int count = 0;
            int i = 0;
            while (i < this.mResourceImpls.size()) {
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                if (key.isPathReferenced(path)) {
                    ResourcesImpl res = (ResourcesImpl)this.mResourceImpls.removeAt(i).get();
                    if (res != null) {
                        res.flushLayoutCache();
                    }
                    ++count;
                    continue;
                }
                ++i;
            }
            Log.i("ResourcesManager", "Invalidated " + count + " asset managers that referenced " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Configuration $$robo$$android_app_ResourcesManager$getConfiguration() {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            return this.mResConfiguration;
        }
    }

    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetrics() {
        return this.getDisplayMetrics(0, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getAdjustedDisplay(displayId, da);
        if (display != null) {
            display.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static final void $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = config.screenWidthDp;
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    private final boolean $$robo$$android_app_ResourcesManager$applyCompatConfigurationLocked(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Display $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int displayId, DisplayAdjustments displayAdjustments) {
        DisplayAdjustments displayAdjustmentsCopy = displayAdjustments != null ? new DisplayAdjustments(displayAdjustments) : new DisplayAdjustments();
        Pair<Integer, DisplayAdjustments> key = Pair.create(displayId, displayAdjustmentsCopy);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Display display;
            WeakReference<Display> wd = this.mDisplays.get(key);
            if (wd != null && (display = (Display)wd.get()) != null) {
                return display;
            }
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            Display display2 = dm.getCompatibleDisplay(displayId, (DisplayAdjustments)key.second);
            if (display2 != null) {
                this.mDisplays.put(key, new WeakReference<Display>(display2));
            }
            return display2;
        }
    }

    private final AssetManager $$robo$$android_app_ResourcesManager$createAssetManager(ResourcesKey key) {
        AssetManager assets = new AssetManager();
        if (key.mResDir != null && assets.addAssetPath(key.mResDir) == 0) {
            throw new Resources.NotFoundException("failed to add asset path " + key.mResDir);
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                if (assets.addAssetPath(splitResDir) != 0) continue;
                throw new Resources.NotFoundException("failed to add split asset path " + splitResDir);
            }
        }
        if (key.mOverlayDirs != null) {
            for (String idmapPath : key.mOverlayDirs) {
                assets.addOverlayPath(idmapPath);
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk") || assets.addAssetPathAsSharedLibrary(libDir) != 0) continue;
                Log.w("ResourcesManager", "Asset path '" + libDir + "' does not exist or contains no resources.");
            }
        }
        return assets;
    }

    private final Configuration $$robo$$android_app_ResourcesManager$generateConfig(ResourcesKey key, DisplayMetrics dm) {
        Configuration config;
        boolean isDefaultDisplay = key.mDisplayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$createResourcesImpl(ResourcesKey key) {
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        AssetManager assets = this.createAssetManager(key);
        DisplayMetrics dm = this.getDisplayMetrics(key.mDisplayId, daj);
        Configuration config = this.generateConfig(key, dm);
        ResourcesImpl impl = new ResourcesImpl(assets, dm, config, daj);
        return impl;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$findResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$findOrCreateResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if (impl == null) {
            impl = this.createResourcesImpl(key);
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    private final ResourcesKey $$robo$$android_app_ResourcesManager$findKeyForResourceImplLocked(ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            ResourcesImpl impl;
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
            if (impl == null || resourceImpl != impl) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    private final ActivityResources $$robo$$android_app_ResourcesManager$getOrCreateActivityResourcesStructLocked(IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources();
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResourcesForActivityLocked(IBinder activityToken, ClassLoader classLoader, ResourcesImpl impl) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        int refCount = activityResources.activityResources.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = activityResources.activityResources.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = new Resources(classLoader);
        resources.setImpl(impl);
        activityResources.activityResources.add(new WeakReference<Resources>(resources));
        return resources;
    }

    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResourcesLocked(ClassLoader classLoader, ResourcesImpl impl) {
        int refCount = this.mResourceReferences.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = this.mResourceReferences.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = new Resources(classLoader);
        resources.setImpl(impl);
        this.mResourceReferences.add(new WeakReference<Resources>(resources));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$createBaseActivityResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(activityToken);
            }
            this.updateResourcesForActivity(activityToken, overrideConfig);
            object = this.getOrCreateResources(activityToken, key, classLoader);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResources(IBinder activityToken, ResourcesKey key, ClassLoader classLoader) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            if (activityToken != null) {
                ResourcesImpl resourcesImpl;
                ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                ArrayUtils.unstableRemoveIf(activityResources.activityResources, sEmptyReferencePredicate);
                if (key.hasOverrideConfiguration() && !activityResources.overrideConfig.equals(Configuration.EMPTY)) {
                    Configuration temp = new Configuration(activityResources.overrideConfig);
                    temp.updateFrom(key.mOverrideConfiguration);
                    key.mOverrideConfiguration.setTo(temp);
                }
                if ((resourcesImpl = this.findResourcesImplForKeyLocked(key)) != null) {
                    return this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl);
                }
            } else {
                ArrayUtils.unstableRemoveIf(this.mResourceReferences, sEmptyReferencePredicate);
                ResourcesImpl resourcesImpl = this.findResourcesImplForKeyLocked(key);
                if (resourcesImpl != null) {
                    return this.getOrCreateResourcesLocked(classLoader, resourcesImpl);
                }
            }
        }
        ResourcesImpl resourcesImpl = this.createResourcesImpl(key);
        ResourcesManager resourcesManager2 = this;
        synchronized (resourcesManager2) {
            ResourcesImpl existingResourcesImpl = this.findResourcesImplForKeyLocked(key);
            if (existingResourcesImpl != null) {
                resourcesImpl.getAssets().close();
                resourcesImpl = existingResourcesImpl;
            } else {
                this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(resourcesImpl));
            }
            Resources resources = activityToken != null ? this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl) : this.getOrCreateResourcesLocked(classLoader, resourcesImpl);
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$getResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Resources resources = this.getOrCreateResources(activityToken, key, classLoader);
            return resources;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$updateResourcesForActivity(IBinder activityToken, Configuration overrideConfig) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            ResourcesManager resourcesManager = this;
            synchronized (resourcesManager) {
                ActivityResources activityResources;
                block15: {
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig)) break block15;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.setToDefaults();
                }
                boolean activityHasOverrideConfig = !activityResources.overrideConfig.equals(Configuration.EMPTY);
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesKey newKey;
                    ResourcesImpl resourcesImpl;
                    WeakReference<Resources> weakResRef = activityResources.activityResources.get(i);
                    Resources resources = (Resources)weakResRef.get();
                    if (resources == null) continue;
                    ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
                    if (oldKey == null) {
                        Slog.e("ResourcesManager", "can't find ResourcesKey for resources impl=" + resources.getImpl());
                        continue;
                    }
                    Configuration rebasedOverrideConfig = new Configuration();
                    if (overrideConfig != null) {
                        rebasedOverrideConfig.setTo(overrideConfig);
                    }
                    if (activityHasOverrideConfig && oldKey.hasOverrideConfiguration()) {
                        Configuration overrideOverrideConfig = Configuration.generateDelta(oldConfig, oldKey.mOverrideConfiguration);
                        rebasedOverrideConfig.updateFrom(overrideOverrideConfig);
                    }
                    if ((resourcesImpl = this.findResourcesImplForKeyLocked(newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayDirs, oldKey.mLibDirs, oldKey.mDisplayId, rebasedOverrideConfig, oldKey.mCompatInfo))) == null) {
                        resourcesImpl = this.createResourcesImpl(newKey);
                        this.mResourceImpls.put(newKey, new WeakReference<ResourcesImpl>(resourcesImpl));
                    }
                    if (resourcesImpl == resources.getImpl()) continue;
                    resources.setImpl(resourcesImpl);
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResourcesLocked");
            if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                boolean bl = false;
                return bl;
            }
            int changes = this.mResConfiguration.updateFrom(config);
            this.mDisplays.clear();
            DisplayMetrics defaultDisplayMetrics = this.getDisplayMetrics();
            if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                this.mResCompatibilityInfo = compat;
                changes |= 0xD00;
            }
            Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
            ApplicationPackageManager.configurationChanged();
            Configuration tmpConfig = null;
            for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                ResourcesImpl r = (ResourcesImpl)this.mResourceImpls.valueAt(i).get();
                if (r != null) {
                    int displayId = key.mDisplayId;
                    boolean isDefaultDisplay = displayId == 0;
                    DisplayMetrics dm = defaultDisplayMetrics;
                    boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
                    if (!isDefaultDisplay || hasOverrideConfiguration) {
                        if (tmpConfig == null) {
                            tmpConfig = new Configuration();
                        }
                        tmpConfig.setTo(config);
                        if (!isDefaultDisplay) {
                            DisplayAdjustments daj = r.getDisplayAdjustments();
                            if (compat != null) {
                                daj = new DisplayAdjustments(daj);
                                daj.setCompatibilityInfo(compat);
                            }
                            dm = this.getDisplayMetrics(displayId, daj);
                            ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, tmpConfig);
                        }
                        if (hasOverrideConfiguration) {
                            tmpConfig.updateFrom(key.mOverrideConfiguration);
                        }
                        r.updateConfiguration(tmpConfig, dm, compat);
                        continue;
                    }
                    r.updateConfiguration(config, dm, compat);
                    continue;
                }
                this.mResourceImpls.removeAt(i);
            }
            boolean bl = changes != 0;
            return bl;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl = (ResourcesImpl)this.mResourceImpls.valueAt(i).get();
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                if (impl == null || !key.mResDir.equals(assetPath) || ArrayUtils.contains(key.mLibDirs, libAsset)) continue;
                int newLibAssetCount = 1 + (key.mLibDirs != null ? key.mLibDirs.length : 0);
                String[] newLibAssets = new String[newLibAssetCount];
                if (key.mLibDirs != null) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)key.mLibDirs, (int)0, (Object)newLibAssets, (int)0, (int)key.mLibDirs.length);
                }
                newLibAssets[newLibAssetCount - 1] = libAsset;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayDirs, newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo));
            }
            if (updatedResourceKeys.isEmpty()) {
                return;
            }
            int resourcesCount = this.mResourceReferences.size();
            for (int i = 0; i < resourcesCount; ++i) {
                ResourcesKey key;
                Resources r = (Resources)this.mResourceReferences.get(i).get();
                if (r == null || (key = (ResourcesKey)updatedResourceKeys.get(r.getImpl())) == null) continue;
                r.setImpl(this.findOrCreateResourcesImplForKeyLocked(key));
            }
            for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
                int resCount = activityResources.activityResources.size();
                for (int i = 0; i < resCount; ++i) {
                    ResourcesKey key;
                    Resources r = (Resources)activityResources.activityResources.get(i).get();
                    if (r == null || (key = (ResourcesKey)updatedResourceKeys.get(r.getImpl())) == null) continue;
                    r.setImpl(this.findOrCreateResourcesImplForKeyLocked(key));
                }
            }
        }
    }

    static void __staticInitializer__() {
        sEmptyReferencePredicate = new Predicate<WeakReference<Resources>>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_ResourcesManager_1$__constructor__() {
            }

            private final boolean $$robo$$android_app_ResourcesManager_1$test(WeakReference<Resources> weakRef) {
                return weakRef == null || weakRef.get() == null;
            }

            private void __constructor__() {
                this.$$robo$$android_app_ResourcesManager_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager_1$__constructor__(), 0, this);
            }

            @Override
            public boolean test(WeakReference<Resources> weakReference) {
                return (boolean)InvokeDynamicSupport.bootstrap("test", $$robo$$android_app_ResourcesManager_1$test(java.lang.ref.WeakReference<android.content.res.Resources> ), 0, this, weakReference);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_app_ResourcesManager$__constructor__();
    }

    public ResourcesManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager$__constructor__(), 0, this);
    }

    public static ResourcesManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_ResourcesManager$getInstance(), 0);
    }

    public void invalidatePath(String string2) {
        InvokeDynamicSupport.bootstrap("invalidatePath", $$robo$$android_app_ResourcesManager$invalidatePath(java.lang.String ), 0, this, string2);
    }

    public Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_app_ResourcesManager$getConfiguration(), 0, this);
    }

    DisplayMetrics getDisplayMetrics() {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_app_ResourcesManager$getDisplayMetrics(), 0, this);
    }

    protected DisplayMetrics getDisplayMetrics(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_app_ResourcesManager$getDisplayMetrics(int android.view.DisplayAdjustments ), 0, this, n, displayAdjustments);
    }

    private static void applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics displayMetrics, Configuration configuration) {
        InvokeDynamicSupport.bootstrapStatic("applyNonDefaultDisplayMetricsToConfiguration", $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfiguration(android.util.DisplayMetrics android.content.res.Configuration ), 0, (DisplayMetrics)displayMetrics, (Configuration)configuration);
    }

    public boolean applyCompatConfigurationLocked(int n, Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyCompatConfigurationLocked", $$robo$$android_app_ResourcesManager$applyCompatConfigurationLocked(int android.content.res.Configuration ), 0, this, n, configuration);
    }

    public Display getAdjustedDisplay(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getAdjustedDisplay", $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int android.view.DisplayAdjustments ), 0, this, n, displayAdjustments);
    }

    protected AssetManager createAssetManager(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("createAssetManager", $$robo$$android_app_ResourcesManager$createAssetManager(android.content.res.ResourcesKey ), 0, this, resourcesKey);
    }

    private Configuration generateConfig(ResourcesKey resourcesKey, DisplayMetrics displayMetrics) {
        return InvokeDynamicSupport.bootstrap("generateConfig", $$robo$$android_app_ResourcesManager$generateConfig(android.content.res.ResourcesKey android.util.DisplayMetrics ), 0, this, resourcesKey, displayMetrics);
    }

    private ResourcesImpl createResourcesImpl(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("createResourcesImpl", $$robo$$android_app_ResourcesManager$createResourcesImpl(android.content.res.ResourcesKey ), 0, this, resourcesKey);
    }

    private ResourcesImpl findResourcesImplForKeyLocked(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("findResourcesImplForKeyLocked", $$robo$$android_app_ResourcesManager$findResourcesImplForKeyLocked(android.content.res.ResourcesKey ), 0, this, resourcesKey);
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("findOrCreateResourcesImplForKeyLocked", $$robo$$android_app_ResourcesManager$findOrCreateResourcesImplForKeyLocked(android.content.res.ResourcesKey ), 0, this, resourcesKey);
    }

    private ResourcesKey findKeyForResourceImplLocked(ResourcesImpl resourcesImpl) {
        return InvokeDynamicSupport.bootstrap("findKeyForResourceImplLocked", $$robo$$android_app_ResourcesManager$findKeyForResourceImplLocked(android.content.res.ResourcesImpl ), 0, this, resourcesImpl);
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("getOrCreateActivityResourcesStructLocked", $$robo$$android_app_ResourcesManager$getOrCreateActivityResourcesStructLocked(android.os.IBinder ), 0, this, iBinder);
    }

    private Resources getOrCreateResourcesForActivityLocked(IBinder iBinder, ClassLoader classLoader, ResourcesImpl resourcesImpl) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResourcesForActivityLocked", $$robo$$android_app_ResourcesManager$getOrCreateResourcesForActivityLocked(android.os.IBinder java.lang.ClassLoader android.content.res.ResourcesImpl ), 0, this, iBinder, classLoader, resourcesImpl);
    }

    private Resources getOrCreateResourcesLocked(ClassLoader classLoader, ResourcesImpl resourcesImpl) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResourcesLocked", $$robo$$android_app_ResourcesManager$getOrCreateResourcesLocked(java.lang.ClassLoader android.content.res.ResourcesImpl ), 0, this, classLoader, resourcesImpl);
    }

    public Resources createBaseActivityResources(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("createBaseActivityResources", $$robo$$android_app_ResourcesManager$createBaseActivityResources(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo java.lang.ClassLoader ), 0, this, iBinder, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo, classLoader);
    }

    private Resources getOrCreateResources(IBinder iBinder, ResourcesKey resourcesKey, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResources", $$robo$$android_app_ResourcesManager$getOrCreateResources(android.os.IBinder android.content.res.ResourcesKey java.lang.ClassLoader ), 0, this, iBinder, resourcesKey, classLoader);
    }

    public Resources getResources(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_app_ResourcesManager$getResources(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo java.lang.ClassLoader ), 0, this, iBinder, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo, classLoader);
    }

    public void updateResourcesForActivity(IBinder iBinder, Configuration configuration) {
        InvokeDynamicSupport.bootstrap("updateResourcesForActivity", $$robo$$android_app_ResourcesManager$updateResourcesForActivity(android.os.IBinder android.content.res.Configuration ), 0, this, iBinder, configuration);
    }

    public boolean applyConfigurationToResourcesLocked(Configuration configuration, CompatibilityInfo compatibilityInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyConfigurationToResourcesLocked", $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(android.content.res.Configuration android.content.res.CompatibilityInfo ), 0, this, configuration, compatibilityInfo);
    }

    public void appendLibAssetForMainAssetPath(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("appendLibAssetForMainAssetPath", $$robo$$android_app_ResourcesManager$appendLibAssetForMainAssetPath(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static {
        RobolectricInternals.classInitializing(ResourcesManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourcesManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ActivityResources
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Configuration overrideConfig;
        public ArrayList<WeakReference<Resources>> activityResources;

        private void $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__() {
            this.overrideConfig = new Configuration();
            this.activityResources = new ArrayList();
        }

        private /* synthetic */ void $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ResourcesManager_ActivityResources$__constructor__();
        }

        private ActivityResources() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityResources)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

