/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.FullBackupDataOutput;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FullBackup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "FullBackup";
    static String TAG_XML_PARSER = "BackupXmlParserLogging";
    public static String APK_TREE_TOKEN = "a";
    public static String OBB_TREE_TOKEN = "obb";
    public static String ROOT_TREE_TOKEN = "r";
    public static String FILES_TREE_TOKEN = "f";
    public static String NO_BACKUP_TREE_TOKEN = "nb";
    public static String DATABASE_TREE_TOKEN = "db";
    public static String SHAREDPREFS_TREE_TOKEN = "sp";
    public static String CACHE_TREE_TOKEN = "c";
    public static String DEVICE_ROOT_TREE_TOKEN = "d_r";
    public static String DEVICE_FILES_TREE_TOKEN = "d_f";
    public static String DEVICE_NO_BACKUP_TREE_TOKEN = "d_nb";
    public static String DEVICE_DATABASE_TREE_TOKEN = "d_db";
    public static String DEVICE_SHAREDPREFS_TREE_TOKEN = "d_sp";
    public static String DEVICE_CACHE_TREE_TOKEN = "d_c";
    public static String MANAGED_EXTERNAL_TREE_TOKEN = "ef";
    public static String SHARED_STORAGE_TOKEN = "shared";
    public static String APPS_PREFIX = "apps/";
    public static String SHARED_PREFIX = "shared/";
    public static String FULL_BACKUP_INTENT_ACTION = "fullback";
    public static String FULL_RESTORE_INTENT_ACTION = "fullrest";
    public static String CONF_TOKEN_INTENT_EXTRA = "conftoken";
    private static Map<String, BackupScheme> kPackageBackupSchemeMap;

    private void $$robo$$android_app_backup_FullBackup$__constructor__() {
    }

    private static final int $$robo$$android_app_backup_FullBackup$backupToTar(String string2, String string3, String string4, String string5, String string6, FullBackupDataOutput fullBackupDataOutput) {
        return 0;
    }

    private static final synchronized BackupScheme $$robo$$android_app_backup_FullBackup$getBackupScheme(Context context) {
        BackupScheme backupSchemeForPackage = kPackageBackupSchemeMap.get(context.getPackageName());
        if (backupSchemeForPackage == null) {
            backupSchemeForPackage = new BackupScheme(context);
            kPackageBackupSchemeMap.put(context.getPackageName(), backupSchemeForPackage);
        }
        return backupSchemeForPackage;
    }

    private static final BackupScheme $$robo$$android_app_backup_FullBackup$getBackupSchemeForTest(Context context) {
        BackupScheme testing = new BackupScheme(context);
        testing.mExcludes = new ArraySet();
        testing.mIncludes = new ArrayMap<String, Set<String>>();
        return testing;
    }

    private static final void $$robo$$android_app_backup_FullBackup$restoreFile(ParcelFileDescriptor data, long size, int type, long mode, long mtime, File outFile) throws IOException {
        if (type == 2) {
            if (outFile != null) {
                outFile.mkdirs();
            }
        } else {
            FileOutputStream out = null;
            try {
                if (outFile != null) {
                    File parent = outFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    out = new FileOutputStream(outFile);
                }
            }
            catch (IOException e) {
                Log.e("FullBackup", "Unable to create/open file " + outFile.getPath(), e);
            }
            byte[] buffer = new byte[32768];
            long origSize = size;
            FileInputStream in = new FileInputStream(data.getFileDescriptor());
            while (size > 0L) {
                int toRead = size > (long)buffer.length ? buffer.length : (int)size;
                int got = in.read(buffer, 0, toRead);
                if (got <= 0) {
                    Log.w("FullBackup", "Incomplete read: expected " + size + " but got " + (origSize - size));
                    break;
                }
                if (out != null) {
                    try {
                        out.write(buffer, 0, got);
                    }
                    catch (IOException e) {
                        Log.e("FullBackup", "Unable to write to file " + outFile.getPath(), e);
                        out.close();
                        out = null;
                        outFile.delete();
                    }
                }
                size -= (long)got;
            }
            if (out != null) {
                out.close();
            }
        }
        if (mode >= 0L && outFile != null) {
            try {
                Os.chmod(outFile.getPath(), (int)(mode &= 0x1C0L));
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            outFile.setLastModified(mtime);
        }
    }

    static void __staticInitializer__() {
        kPackageBackupSchemeMap = new ArrayMap<String, BackupScheme>();
    }

    private void __constructor__() {
        this.$$robo$$android_app_backup_FullBackup$__constructor__();
    }

    public FullBackup() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_FullBackup$__constructor__(), 0, this);
    }

    private static final native /* synthetic */ int $$robo$$backupToTar$nativeBinding(String var0, String var1, String var2, String var3, String var4, FullBackupDataOutput var5);

    public static int backupToTar(String string2, String string3, String string4, String string5, String string6, FullBackupDataOutput fullBackupDataOutput) {
        return (int)InvokeDynamicSupport.bootstrapStatic("backupToTar", $$robo$$android_app_backup_FullBackup$backupToTar(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String android.app.backup.FullBackupDataOutput ), 1, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (FullBackupDataOutput)fullBackupDataOutput);
    }

    static synchronized BackupScheme getBackupScheme(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getBackupScheme", $$robo$$android_app_backup_FullBackup$getBackupScheme(android.content.Context ), 0, (Context)context);
    }

    public static BackupScheme getBackupSchemeForTest(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getBackupSchemeForTest", $$robo$$android_app_backup_FullBackup$getBackupSchemeForTest(android.content.Context ), 0, (Context)context);
    }

    public static void restoreFile(ParcelFileDescriptor parcelFileDescriptor, long l, int n, long l2, long l3, File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("restoreFile", $$robo$$android_app_backup_FullBackup$restoreFile(android.os.ParcelFileDescriptor long int long long java.io.File ), 0, (ParcelFileDescriptor)parcelFileDescriptor, (long)l, (int)n, (long)l2, (long)l3, (File)file);
    }

    static {
        RobolectricInternals.classInitializing(FullBackup.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FullBackup)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BackupScheme
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File FILES_DIR;
        private File DATABASE_DIR;
        private File ROOT_DIR;
        private File SHAREDPREF_DIR;
        private File CACHE_DIR;
        private File NOBACKUP_DIR;
        private File DEVICE_FILES_DIR;
        private File DEVICE_DATABASE_DIR;
        private File DEVICE_ROOT_DIR;
        private File DEVICE_SHAREDPREF_DIR;
        private File DEVICE_CACHE_DIR;
        private File DEVICE_NOBACKUP_DIR;
        private File EXTERNAL_DIR;
        int mFullBackupContent;
        PackageManager mPackageManager;
        String mPackageName;
        Map<String, Set<String>> mIncludes;
        ArraySet<String> mExcludes;

        private final String $$robo$$android_app_backup_FullBackup_BackupScheme$tokenToDirectoryPath(String domainToken) {
            try {
                if (domainToken.equals("f")) {
                    return this.FILES_DIR.getCanonicalPath();
                }
                if (domainToken.equals("db")) {
                    return this.DATABASE_DIR.getCanonicalPath();
                }
                if (domainToken.equals("r")) {
                    return this.ROOT_DIR.getCanonicalPath();
                }
                if (domainToken.equals("sp")) {
                    return this.SHAREDPREF_DIR.getCanonicalPath();
                }
                if (domainToken.equals("c")) {
                    return this.CACHE_DIR.getCanonicalPath();
                }
                if (domainToken.equals("nb")) {
                    return this.NOBACKUP_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_f")) {
                    return this.DEVICE_FILES_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_db")) {
                    return this.DEVICE_DATABASE_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_r")) {
                    return this.DEVICE_ROOT_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_sp")) {
                    return this.DEVICE_SHAREDPREF_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_c")) {
                    return this.DEVICE_CACHE_DIR.getCanonicalPath();
                }
                if (domainToken.equals("d_nb")) {
                    return this.DEVICE_NOBACKUP_DIR.getCanonicalPath();
                }
                if (domainToken.equals("ef")) {
                    if (this.EXTERNAL_DIR != null) {
                        return this.EXTERNAL_DIR.getCanonicalPath();
                    }
                    return null;
                }
                Log.i("FullBackup", "Unrecognized domain " + domainToken);
                return null;
            }
            catch (IOException e) {
                Log.i("FullBackup", "Error reading directory for domain: " + domainToken);
                return null;
            }
        }

        private void $$robo$$android_app_backup_FullBackup_BackupScheme$__constructor__(Context context) {
            this.mFullBackupContent = context.getApplicationInfo().fullBackupContent;
            this.mPackageManager = context.getPackageManager();
            this.mPackageName = context.getPackageName();
            Context ceContext = context.createCredentialProtectedStorageContext();
            this.FILES_DIR = ceContext.getFilesDir();
            this.DATABASE_DIR = ceContext.getDatabasePath("foo").getParentFile();
            this.ROOT_DIR = ceContext.getDataDir();
            this.SHAREDPREF_DIR = ceContext.getSharedPreferencesPath("foo").getParentFile();
            this.CACHE_DIR = ceContext.getCacheDir();
            this.NOBACKUP_DIR = ceContext.getNoBackupFilesDir();
            Context deContext = context.createDeviceProtectedStorageContext();
            this.DEVICE_FILES_DIR = deContext.getFilesDir();
            this.DEVICE_DATABASE_DIR = deContext.getDatabasePath("foo").getParentFile();
            this.DEVICE_ROOT_DIR = deContext.getDataDir();
            this.DEVICE_SHAREDPREF_DIR = deContext.getSharedPreferencesPath("foo").getParentFile();
            this.DEVICE_CACHE_DIR = deContext.getCacheDir();
            this.DEVICE_NOBACKUP_DIR = deContext.getNoBackupFilesDir();
            this.EXTERNAL_DIR = Process.myUid() != 1000 ? context.getExternalFilesDir(null) : null;
        }

        private final boolean $$robo$$android_app_backup_FullBackup_BackupScheme$isFullBackupContentEnabled() {
            if (this.mFullBackupContent < 0) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "android:fullBackupContent - \"false\"");
                }
                return false;
            }
            return true;
        }

        private final synchronized Map<String, Set<String>> $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseAndGetCanonicalIncludePaths() throws IOException, XmlPullParserException {
            if (this.mIncludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mIncludes;
        }

        private final synchronized ArraySet<String> $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseAndGetCanonicalExcludePaths() throws IOException, XmlPullParserException {
            if (this.mExcludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mExcludes;
        }

        private final void $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseBackupSchemeLocked() throws IOException, XmlPullParserException {
            this.mIncludes = new ArrayMap<String, Set<String>>();
            this.mExcludes = new ArraySet();
            if (this.mFullBackupContent == 0) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "android:fullBackupContent - \"true\"");
                }
            } else {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "android:fullBackupContent - found xml resource");
                }
                try (XmlResourceParser parser = null;){
                    parser = this.mPackageManager.getResourcesForApplication(this.mPackageName).getXml(this.mFullBackupContent);
                    this.parseBackupSchemeFromXmlLocked(parser, this.mExcludes, this.mIncludes);
                }
            }
        }

        private final void $$robo$$android_app_backup_FullBackup_BackupScheme$parseBackupSchemeFromXmlLocked(XmlPullParser parser, Set<String> excludes, Map<String, Set<String>> includes) throws IOException, XmlPullParserException {
            int event = parser.getEventType();
            while (event != 2) {
                event = parser.next();
            }
            if (!"full-backup-content".equals(parser.getName())) {
                throw new XmlPullParserException("Xml file didn't start with correct tag (<full-backup-content>). Found \"" + parser.getName() + "\"");
            }
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "\n");
                Log.v("BackupXmlParserLogging", "====================================================");
                Log.v("BackupXmlParserLogging", "Found valid fullBackupContent; parsing xml resource.");
                Log.v("BackupXmlParserLogging", "====================================================");
                Log.v("BackupXmlParserLogging", "");
            }
            while ((event = parser.next()) != 1) {
                switch (event) {
                    case 2: {
                        this.validateInnerTagContents(parser);
                        String domainFromXml = parser.getAttributeValue(null, "domain");
                        File domainDirectory = this.getDirectoryForCriteriaDomain(domainFromXml);
                        if (domainDirectory == null) {
                            if (!Log.isLoggable("BackupXmlParserLogging", 2)) break;
                            Log.v("BackupXmlParserLogging", "...parsing \"" + parser.getName() + "\": domain=\"" + domainFromXml + "\" invalid; skipping");
                            break;
                        }
                        File canonicalFile = this.extractCanonicalFile(domainDirectory, parser.getAttributeValue(null, "path"));
                        if (canonicalFile == null) break;
                        Set<String> activeSet = this.parseCurrentTagForDomain(parser, excludes, includes, domainFromXml);
                        activeSet.add(canonicalFile.getCanonicalPath());
                        if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                            Log.v("BackupXmlParserLogging", "...parsed " + canonicalFile.getCanonicalPath() + " for domain \"" + domainFromXml + "\"");
                        }
                        if ("database".equals(domainFromXml) && !canonicalFile.isDirectory()) {
                            String canonicalJournalPath = canonicalFile.getCanonicalPath() + "-journal";
                            activeSet.add(canonicalJournalPath);
                            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                                Log.v("BackupXmlParserLogging", "...automatically generated " + canonicalJournalPath + ". Ignore if nonexistent.");
                            }
                            String canonicalWalPath = canonicalFile.getCanonicalPath() + "-wal";
                            activeSet.add(canonicalWalPath);
                            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                                Log.v("BackupXmlParserLogging", "...automatically generated " + canonicalWalPath + ". Ignore if nonexistent.");
                            }
                        }
                        if (!"sharedpref".equals(domainFromXml) || canonicalFile.isDirectory() || canonicalFile.getCanonicalPath().endsWith(".xml")) break;
                        String canonicalXmlPath = canonicalFile.getCanonicalPath() + ".xml";
                        activeSet.add(canonicalXmlPath);
                        if (!Log.isLoggable("BackupXmlParserLogging", 2)) break;
                        Log.v("BackupXmlParserLogging", "...automatically generated " + canonicalXmlPath + ". Ignore if nonexistent.");
                    }
                }
            }
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "\n");
                Log.v("BackupXmlParserLogging", "Xml resource parsing complete.");
                Log.v("BackupXmlParserLogging", "Final tally.");
                Log.v("BackupXmlParserLogging", "Includes:");
                if (includes.isEmpty()) {
                    Log.v("BackupXmlParserLogging", "  ...nothing specified (This means the entirety of app data minus excludes)");
                } else {
                    for (Map.Entry<String, Set<String>> entry : includes.entrySet()) {
                        Log.v("BackupXmlParserLogging", "  domain=" + entry.getKey());
                        for (String includeData : entry.getValue()) {
                            Log.v("BackupXmlParserLogging", "  " + includeData);
                        }
                    }
                }
                Log.v("BackupXmlParserLogging", "Excludes:");
                if (excludes.isEmpty()) {
                    Log.v("BackupXmlParserLogging", "  ...nothing to exclude.");
                } else {
                    for (String excludeData : excludes) {
                        Log.v("BackupXmlParserLogging", "  " + excludeData);
                    }
                }
                Log.v("BackupXmlParserLogging", "  ");
                Log.v("BackupXmlParserLogging", "====================================================");
                Log.v("BackupXmlParserLogging", "\n");
            }
        }

        private final Set<String> $$robo$$android_app_backup_FullBackup_BackupScheme$parseCurrentTagForDomain(XmlPullParser parser, Set<String> excludes, Map<String, Set<String>> includes, String domain) throws XmlPullParserException {
            if ("include".equals(parser.getName())) {
                String domainToken = this.getTokenForXmlDomain(domain);
                Set<String> includeSet = includes.get(domainToken);
                if (includeSet == null) {
                    includeSet = new ArraySet<String>();
                    includes.put(domainToken, includeSet);
                }
                return includeSet;
            }
            if ("exclude".equals(parser.getName())) {
                return excludes;
            }
            if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                Log.v("BackupXmlParserLogging", "Invalid tag found in xml \"" + parser.getName() + "\"; aborting operation.");
            }
            throw new XmlPullParserException("Unrecognised tag in backup criteria xml (" + parser.getName() + ")");
        }

        private final String $$robo$$android_app_backup_FullBackup_BackupScheme$getTokenForXmlDomain(String xmlDomain) {
            if ("root".equals(xmlDomain)) {
                return "r";
            }
            if ("file".equals(xmlDomain)) {
                return "f";
            }
            if ("database".equals(xmlDomain)) {
                return "db";
            }
            if ("sharedpref".equals(xmlDomain)) {
                return "sp";
            }
            if ("device_root".equals(xmlDomain)) {
                return "d_r";
            }
            if ("device_file".equals(xmlDomain)) {
                return "d_f";
            }
            if ("device_database".equals(xmlDomain)) {
                return "d_db";
            }
            if ("device_sharedpref".equals(xmlDomain)) {
                return "d_sp";
            }
            if ("external".equals(xmlDomain)) {
                return "ef";
            }
            return null;
        }

        private final File $$robo$$android_app_backup_FullBackup_BackupScheme$extractCanonicalFile(File domain, String filePathFromXml) {
            if (filePathFromXml == null) {
                filePathFromXml = "";
            }
            if (filePathFromXml.contains("..")) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", but the \"..\" path is not permitted; skipping.");
                }
                return null;
            }
            if (filePathFromXml.contains("//")) {
                if (Log.isLoggable("BackupXmlParserLogging", 2)) {
                    Log.v("BackupXmlParserLogging", "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", which contains the invalid \"//\" sequence; skipping.");
                }
                return null;
            }
            return new File(domain, filePathFromXml);
        }

        private final File $$robo$$android_app_backup_FullBackup_BackupScheme$getDirectoryForCriteriaDomain(String domain) {
            if (TextUtils.isEmpty(domain)) {
                return null;
            }
            if ("file".equals(domain)) {
                return this.FILES_DIR;
            }
            if ("database".equals(domain)) {
                return this.DATABASE_DIR;
            }
            if ("root".equals(domain)) {
                return this.ROOT_DIR;
            }
            if ("sharedpref".equals(domain)) {
                return this.SHAREDPREF_DIR;
            }
            if ("device_file".equals(domain)) {
                return this.DEVICE_FILES_DIR;
            }
            if ("device_database".equals(domain)) {
                return this.DEVICE_DATABASE_DIR;
            }
            if ("device_root".equals(domain)) {
                return this.DEVICE_ROOT_DIR;
            }
            if ("device_sharedpref".equals(domain)) {
                return this.DEVICE_SHAREDPREF_DIR;
            }
            if ("external".equals(domain)) {
                return this.EXTERNAL_DIR;
            }
            return null;
        }

        private final void $$robo$$android_app_backup_FullBackup_BackupScheme$validateInnerTagContents(XmlPullParser parser) throws XmlPullParserException {
            if (parser.getAttributeCount() > 2) {
                throw new XmlPullParserException("At most 2 tag attributes allowed for \"" + parser.getName() + "\" tag (\"domain\" & \"path\".");
            }
            if (!"include".equals(parser.getName()) && !"exclude".equals(parser.getName())) {
                throw new XmlPullParserException("A valid tag is one of \"<include/>\" or \"<exclude/>. You provided \"" + parser.getName() + "\"");
            }
        }

        String tokenToDirectoryPath(String string2) {
            return InvokeDynamicSupport.bootstrap("tokenToDirectoryPath", $$robo$$android_app_backup_FullBackup_BackupScheme$tokenToDirectoryPath(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_app_backup_FullBackup_BackupScheme$__constructor__(context);
        }

        BackupScheme(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_FullBackup_BackupScheme$__constructor__(android.content.Context ), 0, this, context);
        }

        boolean isFullBackupContentEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFullBackupContentEnabled", $$robo$$android_app_backup_FullBackup_BackupScheme$isFullBackupContentEnabled(), 0, this);
        }

        public synchronized Map<String, Set<String>> maybeParseAndGetCanonicalIncludePaths() throws IOException, XmlPullParserException {
            return InvokeDynamicSupport.bootstrap("maybeParseAndGetCanonicalIncludePaths", $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseAndGetCanonicalIncludePaths(), 0, this);
        }

        public synchronized ArraySet<String> maybeParseAndGetCanonicalExcludePaths() throws IOException, XmlPullParserException {
            return InvokeDynamicSupport.bootstrap("maybeParseAndGetCanonicalExcludePaths", $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseAndGetCanonicalExcludePaths(), 0, this);
        }

        private void maybeParseBackupSchemeLocked() throws IOException, XmlPullParserException {
            InvokeDynamicSupport.bootstrap("maybeParseBackupSchemeLocked", $$robo$$android_app_backup_FullBackup_BackupScheme$maybeParseBackupSchemeLocked(), 0, this);
        }

        public void parseBackupSchemeFromXmlLocked(XmlPullParser xmlPullParser, Set<String> set, Map<String, Set<String>> map) throws IOException, XmlPullParserException {
            InvokeDynamicSupport.bootstrap("parseBackupSchemeFromXmlLocked", $$robo$$android_app_backup_FullBackup_BackupScheme$parseBackupSchemeFromXmlLocked(org.xmlpull.v1.XmlPullParser java.util.Set<java.lang.String> java.util.Map<java.lang.String, java.util.Set<java.lang.String>> ), 0, this, xmlPullParser, set, map);
        }

        private Set<String> parseCurrentTagForDomain(XmlPullParser xmlPullParser, Set<String> set, Map<String, Set<String>> map, String string2) throws XmlPullParserException {
            return InvokeDynamicSupport.bootstrap("parseCurrentTagForDomain", $$robo$$android_app_backup_FullBackup_BackupScheme$parseCurrentTagForDomain(org.xmlpull.v1.XmlPullParser java.util.Set<java.lang.String> java.util.Map<java.lang.String, java.util.Set<java.lang.String>> java.lang.String ), 0, this, xmlPullParser, set, map, string2);
        }

        private String getTokenForXmlDomain(String string2) {
            return InvokeDynamicSupport.bootstrap("getTokenForXmlDomain", $$robo$$android_app_backup_FullBackup_BackupScheme$getTokenForXmlDomain(java.lang.String ), 0, this, string2);
        }

        private File extractCanonicalFile(File file, String string2) {
            return InvokeDynamicSupport.bootstrap("extractCanonicalFile", $$robo$$android_app_backup_FullBackup_BackupScheme$extractCanonicalFile(java.io.File java.lang.String ), 0, this, file, string2);
        }

        private File getDirectoryForCriteriaDomain(String string2) {
            return InvokeDynamicSupport.bootstrap("getDirectoryForCriteriaDomain", $$robo$$android_app_backup_FullBackup_BackupScheme$getDirectoryForCriteriaDomain(java.lang.String ), 0, this, string2);
        }

        private void validateInnerTagContents(XmlPullParser xmlPullParser) throws XmlPullParserException {
            InvokeDynamicSupport.bootstrap("validateInnerTagContents", $$robo$$android_app_backup_FullBackup_BackupScheme$validateInnerTagContents(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
        }

        public /* synthetic */ BackupScheme() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackupScheme)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

