/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSet;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RestoreSession
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "RestoreSession";
    Context mContext;
    IRestoreSession mBinder;
    RestoreObserverWrapper mObserver;

    private final int $$robo$$android_app_backup_RestoreSession$getAvailableRestoreSets(RestoreObserver observer) {
        int err = -1;
        RestoreObserverWrapper obsWrapper = new RestoreObserverWrapper(this, this.mContext, observer);
        try {
            err = this.mBinder.getAvailableRestoreSets(obsWrapper);
        }
        catch (RemoteException e) {
            Log.d("RestoreSession", "Can't contact server to get available sets");
        }
        return err;
    }

    private final int $$robo$$android_app_backup_RestoreSession$restoreAll(long token, RestoreObserver observer) {
        int err = -1;
        if (this.mObserver != null) {
            Log.d("RestoreSession", "restoreAll() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this, this.mContext, observer);
        try {
            err = this.mBinder.restoreAll(token, this.mObserver);
        }
        catch (RemoteException e) {
            Log.d("RestoreSession", "Can't contact server to restore");
        }
        return err;
    }

    private final int $$robo$$android_app_backup_RestoreSession$restoreSome(long token, RestoreObserver observer, String[] packages) {
        int err = -1;
        if (this.mObserver != null) {
            Log.d("RestoreSession", "restoreAll() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this, this.mContext, observer);
        try {
            err = this.mBinder.restoreSome(token, this.mObserver, packages);
        }
        catch (RemoteException e) {
            Log.d("RestoreSession", "Can't contact server to restore packages");
        }
        return err;
    }

    private final int $$robo$$android_app_backup_RestoreSession$restorePackage(String packageName, RestoreObserver observer) {
        int err = -1;
        if (this.mObserver != null) {
            Log.d("RestoreSession", "restorePackage() called during active restore");
            return -1;
        }
        this.mObserver = new RestoreObserverWrapper(this, this.mContext, observer);
        try {
            err = this.mBinder.restorePackage(packageName, this.mObserver);
        }
        catch (RemoteException e) {
            Log.d("RestoreSession", "Can't contact server to restore package");
        }
        return err;
    }

    private final void $$robo$$android_app_backup_RestoreSession$endRestoreSession() {
        try {
            this.mBinder.endRestoreSession();
        }
        catch (RemoteException e) {
            Log.d("RestoreSession", "Can't contact server to get available sets");
        }
        finally {
            this.mBinder = null;
        }
    }

    private void $$robo$$android_app_backup_RestoreSession$__constructor__(Context context, IRestoreSession binder) {
        this.mObserver = null;
        this.mContext = context;
        this.mBinder = binder;
    }

    public int getAvailableRestoreSets(RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("getAvailableRestoreSets", $$robo$$android_app_backup_RestoreSession$getAvailableRestoreSets(android.app.backup.RestoreObserver ), 0, this, restoreObserver);
    }

    public int restoreAll(long l, RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("restoreAll", $$robo$$android_app_backup_RestoreSession$restoreAll(long android.app.backup.RestoreObserver ), 0, this, l, restoreObserver);
    }

    public int restoreSome(long l, RestoreObserver restoreObserver, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("restoreSome", $$robo$$android_app_backup_RestoreSession$restoreSome(long android.app.backup.RestoreObserver java.lang.String[] ), 0, this, l, restoreObserver, stringArray);
    }

    public int restorePackage(String string2, RestoreObserver restoreObserver) {
        return (int)InvokeDynamicSupport.bootstrap("restorePackage", $$robo$$android_app_backup_RestoreSession$restorePackage(java.lang.String android.app.backup.RestoreObserver ), 0, this, string2, restoreObserver);
    }

    public void endRestoreSession() {
        InvokeDynamicSupport.bootstrap("endRestoreSession", $$robo$$android_app_backup_RestoreSession$endRestoreSession(), 0, this);
    }

    private void __constructor__(Context context, IRestoreSession iRestoreSession) {
        this.$$robo$$android_app_backup_RestoreSession$__constructor__(context, iRestoreSession);
    }

    RestoreSession(Context context, IRestoreSession iRestoreSession) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_RestoreSession$__constructor__(android.content.Context android.app.backup.IRestoreSession ), 0, this, context, iRestoreSession);
    }

    public /* synthetic */ RestoreSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RestoreSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class RestoreObserverWrapper
    extends IRestoreObserver.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Handler mHandler;
        RestoreObserver mAppObserver;
        static int MSG_RESTORE_STARTING = 1;
        static int MSG_UPDATE = 2;
        static int MSG_RESTORE_FINISHED = 3;
        static int MSG_RESTORE_SETS_AVAILABLE = 4;
        /* synthetic */ RestoreSession this$0;

        private void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$__constructor__(RestoreSession restoreSession, Context context, RestoreObserver appObserver) {
            this.mHandler = new ShadowedObject(this, context.getMainLooper(), restoreSession){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ RestoreSession val$this$0;
                /* synthetic */ RestoreObserverWrapper this$1;

                private void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper_1$__constructor__(RestoreObserverWrapper this$1, Looper looper, RestoreSession restoreSession) {
                }

                private final void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            this.this$1.mAppObserver.restoreStarting(msg.arg1);
                            break;
                        }
                        case 2: {
                            this.this$1.mAppObserver.onUpdate(msg.arg1, (String)msg.obj);
                            break;
                        }
                        case 3: {
                            this.this$1.mAppObserver.restoreFinished(msg.arg1);
                            break;
                        }
                        case 4: {
                            this.this$1.mAppObserver.restoreSetsAvailable((RestoreSet[])msg.obj);
                        }
                    }
                }

                private void __constructor__(RestoreObserverWrapper restoreObserverWrapper, Looper looper, RestoreSession restoreSession) {
                    this.$$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper_1$__constructor__(restoreObserverWrapper, looper, restoreSession);
                }
                {
                    this.this$1 = restoreObserverWrapper;
                    this.val$this$0 = restoreSession;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper_1$__constructor__(android.app.backup.RestoreSession$RestoreObserverWrapper android.os.Looper android.app.backup.RestoreSession ), 0, this, restoreObserverWrapper, looper, restoreSession);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mAppObserver = appObserver;
        }

        private final void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreSetsAvailable(RestoreSet[] result) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, result));
        }

        private final void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreStarting(int numPackages) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, numPackages, 0));
        }

        private final void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$onUpdate(int nowBeingRestored, String currentPackage) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(2, nowBeingRestored, 0, currentPackage));
        }

        private final void $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreFinished(int error) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, error, 0));
        }

        private void __constructor__(RestoreSession restoreSession, Context context, RestoreObserver restoreObserver) {
            this.$$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$__constructor__(restoreSession, context, restoreObserver);
        }

        RestoreObserverWrapper(RestoreSession restoreSession, Context context, RestoreObserver restoreObserver) {
            this.this$0 = restoreSession;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$__constructor__(android.app.backup.RestoreSession android.content.Context android.app.backup.RestoreObserver ), 0, this, restoreSession, context, restoreObserver);
        }

        @Override
        public void restoreSetsAvailable(RestoreSet[] restoreSetArray) {
            InvokeDynamicSupport.bootstrap("restoreSetsAvailable", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreSetsAvailable(android.app.backup.RestoreSet[] ), 0, this, restoreSetArray);
        }

        @Override
        public void restoreStarting(int n) {
            InvokeDynamicSupport.bootstrap("restoreStarting", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreStarting(int ), 0, this, n);
        }

        @Override
        public void onUpdate(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onUpdate", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$onUpdate(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public void restoreFinished(int n) {
            InvokeDynamicSupport.bootstrap("restoreFinished", $$robo$$android_app_backup_RestoreSession_RestoreObserverWrapper$restoreFinished(int ), 0, this, n);
        }

        public /* synthetic */ RestoreObserverWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RestoreObserverWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

