/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.NetworkStats;
import android.content.Context;
import android.net.DataUsageRequest;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.Preconditions;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStatsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkStatsManager";
    private static boolean DBG = false;
    public static int CALLBACK_LIMIT_REACHED = 0;
    public static int CALLBACK_RELEASED = 1;
    private Context mContext;
    private INetworkStatsService mService;

    private void $$robo$$android_app_usage_NetworkStatsManager$__constructor__(Context context) {
        this.mContext = context;
        this.mService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
    }

    private final NetworkStats.Bucket $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats.Bucket bucket = null;
        NetworkStats stats = new NetworkStats(this.mContext, template, startTime, endTime);
        bucket = stats.getDeviceSummaryForNetwork();
        stats.close();
        return bucket;
    }

    private final NetworkStats.Bucket $$robo$$android_app_usage_NetworkStatsManager$querySummaryForUser(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats stats = new NetworkStats(this.mContext, template, startTime, endTime);
        stats.startSummaryEnumeration();
        stats.close();
        return stats.getSummaryAggregate();
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$querySummary(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, startTime, endTime);
        result.startSummaryEnumeration();
        return result;
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUid(int networkType, String subscriberId, long startTime, long endTime, int uid) throws SecurityException, RemoteException {
        return this.queryDetailsForUidTag(networkType, subscriberId, startTime, endTime, uid, 0);
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTag(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag) throws SecurityException {
        NetworkStats result;
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        try {
            result = new NetworkStats(this.mContext, template, startTime, endTime);
            result.startHistoryEnumeration(uid, tag);
        }
        catch (RemoteException e) {
            Log.e("NetworkStatsManager", "Error while querying stats for uid=" + uid + " tag=" + tag, e);
            return null;
        }
        return result;
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetails(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, startTime, endTime);
        result.startUserUidEnumeration();
        return result;
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback) {
        this.registerUsageCallback(networkType, subscriberId, thresholdBytes, callback, null);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UsageCallback cannot be null");
        Looper looper = handler == null ? Looper.myLooper() : handler.getLooper();
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        DataUsageRequest request = new DataUsageRequest(0, template, thresholdBytes);
        try {
            CallbackHandler callbackHandler = new CallbackHandler(looper, networkType, subscriberId, callback);
            callback.request = this.mService.registerUsageCallback(this.mContext.getOpPackageName(), request, new Messenger(callbackHandler), new Binder());
            if (callback.request == null) {
                Log.e("NetworkStatsManager", "Request from callback is null; should not happen");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$unregisterUsageCallback(UsageCallback callback) {
        if (callback == null || callback.request == null || ((UsageCallback)callback).request.requestId == 0) {
            throw new IllegalArgumentException("Invalid UsageCallback");
        }
        try {
            this.mService.unregisterUsageRequest(callback.request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final NetworkTemplate $$robo$$android_app_usage_NetworkStatsManager$createTemplate(int networkType, String subscriberId) {
        NetworkTemplate template = null;
        switch (networkType) {
            case 0: {
                template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
                break;
            }
            case 1: {
                template = NetworkTemplate.buildTemplateWifiWildcard();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create template for network type " + networkType + ", subscriberId '" + NetworkIdentity.scrubSubscriberId(subscriberId) + "'.");
            }
        }
        return template;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_usage_NetworkStatsManager$__constructor__(context);
    }

    public NetworkStatsManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public NetworkStats.Bucket querySummaryForDevice(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummaryForDevice", $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public NetworkStats.Bucket querySummaryForUser(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummaryForUser", $$robo$$android_app_usage_NetworkStatsManager$querySummaryForUser(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public NetworkStats querySummary(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummary", $$robo$$android_app_usage_NetworkStatsManager$querySummary(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public NetworkStats queryDetailsForUid(int n, String string2, long l, long l2, int n2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("queryDetailsForUid", $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUid(int java.lang.String long long int ), 0, this, n, string2, l, l2, n2);
    }

    public NetworkStats queryDetailsForUidTag(int n, String string2, long l, long l2, int n2, int n3) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("queryDetailsForUidTag", $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTag(int java.lang.String long long int int ), 0, this, n, string2, l, l2, n2, n3);
    }

    public NetworkStats queryDetails(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("queryDetails", $$robo$$android_app_usage_NetworkStatsManager$queryDetails(int java.lang.String long long ), 0, this, n, string2, l, l2);
    }

    public void registerUsageCallback(int n, String string2, long l, UsageCallback usageCallback) {
        InvokeDynamicSupport.bootstrap("registerUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int java.lang.String long android.app.usage.NetworkStatsManager$UsageCallback ), 0, this, n, string2, l, usageCallback);
    }

    public void registerUsageCallback(int n, String string2, long l, UsageCallback usageCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int java.lang.String long android.app.usage.NetworkStatsManager$UsageCallback android.os.Handler ), 0, this, n, string2, l, usageCallback, handler);
    }

    public void unregisterUsageCallback(UsageCallback usageCallback) {
        InvokeDynamicSupport.bootstrap("unregisterUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$unregisterUsageCallback(android.app.usage.NetworkStatsManager$UsageCallback ), 0, this, usageCallback);
    }

    private static NetworkTemplate createTemplate(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createTemplate", $$robo$$android_app_usage_NetworkStatsManager$createTemplate(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public /* synthetic */ NetworkStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CallbackHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mNetworkType;
        private String mSubscriberId;
        private UsageCallback mCallback;

        private void $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(Looper looper, int networkType, String subscriberId, UsageCallback callback) {
            this.mNetworkType = networkType;
            this.mSubscriberId = subscriberId;
            this.mCallback = callback;
        }

        private final void $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$handleMessage(Message message) {
            DataUsageRequest request = (DataUsageRequest)CallbackHandler.getObject(message, "DataUsageRequest");
            switch (message.what) {
                case 0: {
                    if (this.mCallback != null) {
                        this.mCallback.onThresholdReached(this.mNetworkType, this.mSubscriberId);
                        break;
                    }
                    Log.e("NetworkStatsManager", "limit reached with released callback for " + request);
                    break;
                }
                case 1: {
                    this.mCallback = null;
                }
            }
        }

        private static final Object $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$getObject(Message msg, String key) {
            return msg.getData().getParcelable(key);
        }

        private void __constructor__(Looper looper, int n, String string2, UsageCallback usageCallback) {
            this.$$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(looper, n, string2, usageCallback);
        }

        CallbackHandler(Looper looper, int n, String string2, UsageCallback usageCallback) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(android.os.Looper int java.lang.String android.app.usage.NetworkStatsManager$UsageCallback ), 0, this, looper, n, string2, usageCallback);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private static Object getObject(Message message, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getObject", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$getObject(android.os.Message java.lang.String ), 0, (Message)message, (String)string2);
        }

        public /* synthetic */ CallbackHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class UsageCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DataUsageRequest request;

        private void $$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__() {
        }

        public abstract void onThresholdReached(int var1, String var2);

        private void __constructor__() {
            this.$$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__();
        }

        public UsageCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsageCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

