/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.OobData;
import android.content.Context;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothDevice
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothDevice";
    private static boolean DBG = false;
    private static int CONNECTION_STATE_DISCONNECTED = 0;
    private static int CONNECTION_STATE_CONNECTED = 1;
    private static int CONNECTION_STATE_ENCRYPTED_BREDR = 2;
    private static int CONNECTION_STATE_ENCRYPTED_LE = 4;
    public static int ERROR = Integer.MIN_VALUE;
    public static String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    public static String ACTION_DISAPPEARED = "android.bluetooth.device.action.DISAPPEARED";
    public static String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    public static String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    public static String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    public static String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    public static String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    public static String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";
    public static String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    public static String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    public static int BOND_NONE = 10;
    public static int BOND_BONDING = 11;
    public static int BOND_BONDED = 12;
    public static String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";
    public static int DEVICE_TYPE_UNKNOWN = 0;
    public static int DEVICE_TYPE_CLASSIC = 1;
    public static int DEVICE_TYPE_LE = 2;
    public static int DEVICE_TYPE_DUAL = 3;
    public static String ACTION_SDP_RECORD = "android.bluetooth.device.action.SDP_RECORD";
    public static String ACTION_UUID = "android.bluetooth.device.action.UUID";
    public static String ACTION_MAS_INSTANCE = "android.bluetooth.device.action.MAS_INSTANCE";
    public static String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    public static String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    public static String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    public static String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";
    public static String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";
    public static String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";
    public static String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";
    public static int REQUEST_TYPE_PROFILE_CONNECTION = 1;
    public static int REQUEST_TYPE_PHONEBOOK_ACCESS = 2;
    public static int REQUEST_TYPE_MESSAGE_ACCESS = 3;
    public static int REQUEST_TYPE_SIM_ACCESS = 4;
    public static String EXTRA_PACKAGE_NAME = "android.bluetooth.device.extra.PACKAGE_NAME";
    public static String EXTRA_CLASS_NAME = "android.bluetooth.device.extra.CLASS_NAME";
    public static String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";
    public static int CONNECTION_ACCESS_YES = 1;
    public static int CONNECTION_ACCESS_NO = 2;
    public static String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";
    public static int BOND_SUCCESS = 0;
    public static int UNBOND_REASON_AUTH_FAILED = 1;
    public static int UNBOND_REASON_AUTH_REJECTED = 2;
    public static int UNBOND_REASON_AUTH_CANCELED = 3;
    public static int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    public static int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    public static int UNBOND_REASON_AUTH_TIMEOUT = 6;
    public static int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    public static int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    public static int UNBOND_REASON_REMOVED = 9;
    public static int PAIRING_VARIANT_PIN = 0;
    public static int PAIRING_VARIANT_PASSKEY = 1;
    public static int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    public static int PAIRING_VARIANT_CONSENT = 3;
    public static int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static int PAIRING_VARIANT_DISPLAY_PIN = 5;
    public static int PAIRING_VARIANT_OOB_CONSENT = 6;
    public static int PAIRING_VARIANT_PIN_16_DIGITS = 7;
    public static String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static String EXTRA_SDP_RECORD = "android.bluetooth.device.extra.SDP_RECORD";
    public static String EXTRA_SDP_SEARCH_STATUS = "android.bluetooth.device.extra.SDP_SEARCH_STATUS";
    public static int ACCESS_UNKNOWN = 0;
    public static int ACCESS_ALLOWED = 1;
    public static int ACCESS_REJECTED = 2;
    public static int TRANSPORT_AUTO = 0;
    public static int TRANSPORT_BREDR = 1;
    public static int TRANSPORT_LE = 2;
    public static String EXTRA_MAS_INSTANCE = "android.bluetooth.device.extra.MAS_INSTANCE";
    private static IBluetooth sService;
    private String mAddress;
    static IBluetoothManagerCallback mStateChangeCallback;
    public static Parcelable.Creator<BluetoothDevice> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IBluetooth $$robo$$android_bluetooth_BluetoothDevice$getService() {
        Class<BluetoothDevice> clazz = BluetoothDevice.class;
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                sService = adapter.getBluetoothService(mStateChangeCallback);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sService;
        }
    }

    private void $$robo$$android_bluetooth_BluetoothDevice$__constructor__(String address) {
        BluetoothDevice.getService();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            throw new IllegalArgumentException(address + " is not a valid Bluetooth address");
        }
        this.mAddress = address;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$equals(Object o) {
        if (o instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)o).getAddress());
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$hashCode() {
        return this.mAddress.hashCode();
    }

    private final String $$robo$$android_bluetooth_BluetoothDevice$toString() {
        return this.mAddress;
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$describeContents() {
        return 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothDevice$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAddress);
    }

    private final String $$robo$$android_bluetooth_BluetoothDevice$getAddress() {
        return this.mAddress;
    }

    private final String $$robo$$android_bluetooth_BluetoothDevice$getName() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get Remote Device name");
            return null;
        }
        try {
            return sService.getRemoteName(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return null;
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$getType() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get Remote Device type");
            return 0;
        }
        try {
            return sService.getRemoteType(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return 0;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothDevice$getAlias() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get Remote Device Alias");
            return null;
        }
        try {
            return sService.getRemoteAlias(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return null;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setAlias(String alias) {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot set Remote Device name");
            return false;
        }
        try {
            return sService.setRemoteAlias(this, alias);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final String $$robo$$android_bluetooth_BluetoothDevice$getAliasName() {
        String name = this.getAlias();
        if (name == null) {
            name = this.getName();
        }
        return name;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$createBond() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot create bond to Remote Device");
            return false;
        }
        try {
            Log.i("BluetoothDevice", "createBond() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return sService.createBond(this, 0);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$createBond(int transport) {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot create bond to Remote Device");
            return false;
        }
        if (0 > transport || transport > 2) {
            throw new IllegalArgumentException(transport + " is not a valid Bluetooth transport");
        }
        try {
            Log.i("BluetoothDevice", "createBond() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return sService.createBond(this, transport);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$createBondOutOfBand(int transport, OobData oobData) {
        try {
            return sService.createBondOutOfBand(this, transport, oobData);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setDeviceOutOfBandData(byte[] hash, byte[] randomizer) {
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$cancelBondProcess() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot cancel Remote Device bond");
            return false;
        }
        try {
            Log.i("BluetoothDevice", "cancelBondProcess() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return sService.cancelBondProcess(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$removeBond() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot remove Remote Device bond");
            return false;
        }
        try {
            Log.i("BluetoothDevice", "removeBond() for device " + this.getAddress() + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            return sService.removeBond(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$getBondState() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get bond state");
            return 10;
        }
        try {
            return sService.getBondState(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
        }
        catch (NullPointerException npe) {
            Log.e("BluetoothDevice", "NullPointerException for getBondState() of device (" + this.getAddress() + ")", npe);
        }
        return 10;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$isConnected() {
        if (sService == null) {
            return false;
        }
        try {
            return sService.getConnectionState(this) != 0;
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$isEncrypted() {
        if (sService == null) {
            return false;
        }
        try {
            return sService.getConnectionState(this) > 1;
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final BluetoothClass $$robo$$android_bluetooth_BluetoothDevice$getBluetoothClass() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get Bluetooth Class");
            return null;
        }
        try {
            int classInt = sService.getRemoteClass(this);
            if (classInt == -16777216) {
                return null;
            }
            return new BluetoothClass(classInt);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return null;
        }
    }

    private final ParcelUuid[] $$robo$$android_bluetooth_BluetoothDevice$getUuids() {
        if (sService == null || !this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot get remote device Uuids");
            return null;
        }
        try {
            return sService.getRemoteUuids(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return null;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$fetchUuidsWithSdp() {
        IBluetooth service = sService;
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot fetchUuidsWithSdp");
            return false;
        }
        try {
            return service.fetchRemoteUuids(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$sdpSearch(ParcelUuid uuid) {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot query remote device sdp records");
            return false;
        }
        try {
            return sService.sdpSearch(this, uuid);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setPin(byte[] pin) {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot set Remote Device pin");
            return false;
        }
        try {
            return sService.setPin(this, true, pin.length, pin);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setPasskey(int passkey) {
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setPairingConfirmation(boolean confirm) {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot set pairing confirmation");
            return false;
        }
        try {
            return sService.setPairingConfirmation(this, confirm);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setRemoteOutOfBandData() {
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$cancelPairingUserInput() {
        if (sService == null) {
            Log.e("BluetoothDevice", "BT not enabled. Cannot create pairing user input");
            return false;
        }
        try {
            return sService.cancelBondProcess(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$isBluetoothDock() {
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$isBluetoothEnabled() {
        boolean ret = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            ret = true;
        }
        return ret;
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$getPhonebookAccessPermission() {
        if (sService == null) {
            return 0;
        }
        try {
            return sService.getPhonebookAccessPermission(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return 0;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setPhonebookAccessPermission(int value) {
        if (sService == null) {
            return false;
        }
        try {
            return sService.setPhonebookAccessPermission(this, value);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$getMessageAccessPermission() {
        if (sService == null) {
            return 0;
        }
        try {
            return sService.getMessageAccessPermission(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return 0;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setMessageAccessPermission(int value) {
        if (sService == null) {
            return false;
        }
        try {
            return sService.setMessageAccessPermission(this, value);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final int $$robo$$android_bluetooth_BluetoothDevice$getSimAccessPermission() {
        if (sService == null) {
            return 0;
        }
        try {
            return sService.getSimAccessPermission(this);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return 0;
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothDevice$setSimAccessPermission(int value) {
        if (sService == null) {
            return false;
        }
        try {
            return sService.setSimAccessPermission(this, value);
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return false;
        }
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createRfcommSocket(int channel) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, channel, null);
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(3, -1, true, true, this, channel, null);
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, true, true, this, -1, new ParcelUuid(uuid));
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createInsecureRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, -1, new ParcelUuid(uuid));
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createInsecureRfcommSocket(int port) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(1, -1, false, false, this, port, null);
    }

    private final BluetoothSocket $$robo$$android_bluetooth_BluetoothDevice$createScoSocket() throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e("BluetoothDevice", "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(2, -1, true, true, this, -1, null);
    }

    private static final byte[] $$robo$$android_bluetooth_BluetoothDevice$convertPinToBytes(String pin) {
        byte[] pinBytes;
        if (pin == null) {
            return null;
        }
        try {
            pinBytes = pin.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            Log.e("BluetoothDevice", "UTF-8 not supported?!?");
            return null;
        }
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    private final BluetoothGatt $$robo$$android_bluetooth_BluetoothDevice$connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(context, autoConnect, callback, 0);
    }

    private final BluetoothGatt $$robo$$android_bluetooth_BluetoothDevice$connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager managerService = adapter.getBluetoothManager();
        try {
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return null;
            }
            BluetoothGatt gatt = new BluetoothGatt(context, iGatt, this, transport);
            gatt.connect(autoConnect, callback);
            return gatt;
        }
        catch (RemoteException e) {
            Log.e("BluetoothDevice", "", e);
            return null;
        }
    }

    static void __staticInitializer__() {
        mStateChangeCallback = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_BluetoothDevice_1$__constructor__() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothDevice_1$onBluetoothServiceUp(IBluetooth bluetoothService) throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    if (sService == null) {
                        sService = bluetoothService;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothDevice_1$onBluetoothServiceDown() throws RemoteException {
                Class<BluetoothDevice> clazz = BluetoothDevice.class;
                synchronized (BluetoothDevice.class) {
                    sService = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothDevice_1$onBrEdrDown() {
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_BluetoothDevice_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothDevice_1$__constructor__(), 0, this);
            }

            @Override
            public void onBluetoothServiceUp(IBluetooth iBluetooth) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceUp", $$robo$$android_bluetooth_BluetoothDevice_1$onBluetoothServiceUp(android.bluetooth.IBluetooth ), 0, this, iBluetooth);
            }

            @Override
            public void onBluetoothServiceDown() throws RemoteException {
                InvokeDynamicSupport.bootstrap("onBluetoothServiceDown", $$robo$$android_bluetooth_BluetoothDevice_1$onBluetoothServiceDown(), 0, this);
            }

            @Override
            public void onBrEdrDown() {
                InvokeDynamicSupport.bootstrap("onBrEdrDown", $$robo$$android_bluetooth_BluetoothDevice_1$onBrEdrDown(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CREATOR = new Parcelable.Creator<BluetoothDevice>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_BluetoothDevice_2$__constructor__() {
            }

            private final BluetoothDevice $$robo$$android_bluetooth_BluetoothDevice_2$createFromParcel(Parcel in) {
                return new BluetoothDevice(in.readString());
            }

            private final BluetoothDevice[] $$robo$$android_bluetooth_BluetoothDevice_2$newArray(int size) {
                return new BluetoothDevice[size];
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_BluetoothDevice_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothDevice_2$__constructor__(), 0, this);
            }

            @Override
            public BluetoothDevice createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_bluetooth_BluetoothDevice_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public BluetoothDevice[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_bluetooth_BluetoothDevice_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    static IBluetooth getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_bluetooth_BluetoothDevice$getService(), 0);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_bluetooth_BluetoothDevice$__constructor__(string2);
    }

    BluetoothDevice(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothDevice$__constructor__(java.lang.String ), 0, this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_bluetooth_BluetoothDevice$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_bluetooth_BluetoothDevice$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_BluetoothDevice$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_bluetooth_BluetoothDevice$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_bluetooth_BluetoothDevice$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_bluetooth_BluetoothDevice$getAddress(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_bluetooth_BluetoothDevice$getName(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_bluetooth_BluetoothDevice$getType(), 0, this);
    }

    public String getAlias() {
        return InvokeDynamicSupport.bootstrap("getAlias", $$robo$$android_bluetooth_BluetoothDevice$getAlias(), 0, this);
    }

    public boolean setAlias(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAlias", $$robo$$android_bluetooth_BluetoothDevice$setAlias(java.lang.String ), 0, this, string2);
    }

    public String getAliasName() {
        return InvokeDynamicSupport.bootstrap("getAliasName", $$robo$$android_bluetooth_BluetoothDevice$getAliasName(), 0, this);
    }

    public boolean createBond() {
        return (boolean)InvokeDynamicSupport.bootstrap("createBond", $$robo$$android_bluetooth_BluetoothDevice$createBond(), 0, this);
    }

    public boolean createBond(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("createBond", $$robo$$android_bluetooth_BluetoothDevice$createBond(int ), 0, this, n);
    }

    public boolean createBondOutOfBand(int n, OobData oobData) {
        return (boolean)InvokeDynamicSupport.bootstrap("createBondOutOfBand", $$robo$$android_bluetooth_BluetoothDevice$createBondOutOfBand(int android.bluetooth.OobData ), 0, this, n, oobData);
    }

    public boolean setDeviceOutOfBandData(byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDeviceOutOfBandData", $$robo$$android_bluetooth_BluetoothDevice$setDeviceOutOfBandData(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    public boolean cancelBondProcess() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelBondProcess", $$robo$$android_bluetooth_BluetoothDevice$cancelBondProcess(), 0, this);
    }

    public boolean removeBond() {
        return (boolean)InvokeDynamicSupport.bootstrap("removeBond", $$robo$$android_bluetooth_BluetoothDevice$removeBond(), 0, this);
    }

    public int getBondState() {
        return (int)InvokeDynamicSupport.bootstrap("getBondState", $$robo$$android_bluetooth_BluetoothDevice$getBondState(), 0, this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothDevice$isConnected(), 0, this);
    }

    public boolean isEncrypted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEncrypted", $$robo$$android_bluetooth_BluetoothDevice$isEncrypted(), 0, this);
    }

    public BluetoothClass getBluetoothClass() {
        return InvokeDynamicSupport.bootstrap("getBluetoothClass", $$robo$$android_bluetooth_BluetoothDevice$getBluetoothClass(), 0, this);
    }

    public ParcelUuid[] getUuids() {
        return InvokeDynamicSupport.bootstrap("getUuids", $$robo$$android_bluetooth_BluetoothDevice$getUuids(), 0, this);
    }

    public boolean fetchUuidsWithSdp() {
        return (boolean)InvokeDynamicSupport.bootstrap("fetchUuidsWithSdp", $$robo$$android_bluetooth_BluetoothDevice$fetchUuidsWithSdp(), 0, this);
    }

    public boolean sdpSearch(ParcelUuid parcelUuid) {
        return (boolean)InvokeDynamicSupport.bootstrap("sdpSearch", $$robo$$android_bluetooth_BluetoothDevice$sdpSearch(android.os.ParcelUuid ), 0, this, parcelUuid);
    }

    public boolean setPin(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPin", $$robo$$android_bluetooth_BluetoothDevice$setPin(byte[] ), 0, this, byArray);
    }

    public boolean setPasskey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPasskey", $$robo$$android_bluetooth_BluetoothDevice$setPasskey(int ), 0, this, n);
    }

    public boolean setPairingConfirmation(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPairingConfirmation", $$robo$$android_bluetooth_BluetoothDevice$setPairingConfirmation(boolean ), 0, this, bl);
    }

    public boolean setRemoteOutOfBandData() {
        return (boolean)InvokeDynamicSupport.bootstrap("setRemoteOutOfBandData", $$robo$$android_bluetooth_BluetoothDevice$setRemoteOutOfBandData(), 0, this);
    }

    public boolean cancelPairingUserInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancelPairingUserInput", $$robo$$android_bluetooth_BluetoothDevice$cancelPairingUserInput(), 0, this);
    }

    public boolean isBluetoothDock() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothDock", $$robo$$android_bluetooth_BluetoothDevice$isBluetoothDock(), 0, this);
    }

    boolean isBluetoothEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBluetoothEnabled", $$robo$$android_bluetooth_BluetoothDevice$isBluetoothEnabled(), 0, this);
    }

    public int getPhonebookAccessPermission() {
        return (int)InvokeDynamicSupport.bootstrap("getPhonebookAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$getPhonebookAccessPermission(), 0, this);
    }

    public boolean setPhonebookAccessPermission(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPhonebookAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$setPhonebookAccessPermission(int ), 0, this, n);
    }

    public int getMessageAccessPermission() {
        return (int)InvokeDynamicSupport.bootstrap("getMessageAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$getMessageAccessPermission(), 0, this);
    }

    public boolean setMessageAccessPermission(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setMessageAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$setMessageAccessPermission(int ), 0, this, n);
    }

    public int getSimAccessPermission() {
        return (int)InvokeDynamicSupport.bootstrap("getSimAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$getSimAccessPermission(), 0, this);
    }

    public boolean setSimAccessPermission(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setSimAccessPermission", $$robo$$android_bluetooth_BluetoothDevice$setSimAccessPermission(int ), 0, this, n);
    }

    public BluetoothSocket createRfcommSocket(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("createRfcommSocket", $$robo$$android_bluetooth_BluetoothDevice$createRfcommSocket(int ), 0, this, n);
    }

    public BluetoothSocket createL2capSocket(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("createL2capSocket", $$robo$$android_bluetooth_BluetoothDevice$createL2capSocket(int ), 0, this, n);
    }

    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("createRfcommSocketToServiceRecord", $$robo$$android_bluetooth_BluetoothDevice$createRfcommSocketToServiceRecord(java.util.UUID ), 0, this, uUID);
    }

    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        return InvokeDynamicSupport.bootstrap("createInsecureRfcommSocketToServiceRecord", $$robo$$android_bluetooth_BluetoothDevice$createInsecureRfcommSocketToServiceRecord(java.util.UUID ), 0, this, uUID);
    }

    public BluetoothSocket createInsecureRfcommSocket(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("createInsecureRfcommSocket", $$robo$$android_bluetooth_BluetoothDevice$createInsecureRfcommSocket(int ), 0, this, n);
    }

    public BluetoothSocket createScoSocket() throws IOException {
        return InvokeDynamicSupport.bootstrap("createScoSocket", $$robo$$android_bluetooth_BluetoothDevice$createScoSocket(), 0, this);
    }

    public static byte[] convertPinToBytes(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("convertPinToBytes", $$robo$$android_bluetooth_BluetoothDevice$convertPinToBytes(java.lang.String ), 0, (String)string2);
    }

    public BluetoothGatt connectGatt(Context context, boolean bl, BluetoothGattCallback bluetoothGattCallback) {
        return InvokeDynamicSupport.bootstrap("connectGatt", $$robo$$android_bluetooth_BluetoothDevice$connectGatt(android.content.Context boolean android.bluetooth.BluetoothGattCallback ), 0, this, context, bl, bluetoothGattCallback);
    }

    public BluetoothGatt connectGatt(Context context, boolean bl, BluetoothGattCallback bluetoothGattCallback, int n) {
        return InvokeDynamicSupport.bootstrap("connectGatt", $$robo$$android_bluetooth_BluetoothDevice$connectGatt(android.content.Context boolean android.bluetooth.BluetoothGattCallback int ), 0, this, context, bl, bluetoothGattCallback, n);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothDevice.class);
    }

    public /* synthetic */ BluetoothDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

