/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothLeAdvertiser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothLeAdvertiser";
    private static int MAX_ADVERTISING_DATA_BYTES = 31;
    private static int OVERHEAD_BYTES_PER_FIELD = 2;
    private static int FLAGS_FIELD_BYTES = 3;
    private static int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private static int SERVICE_DATA_UUID_LENGTH = 2;
    private IBluetoothManager mBluetoothManager;
    private Handler mHandler;
    private BluetoothAdapter mBluetoothAdapter;
    private Map<AdvertiseCallback, AdvertiseCallbackWrapper> mLeAdvertisers;

    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(IBluetoothManager bluetoothManager) {
        this.mLeAdvertisers = new HashMap<AdvertiseCallback, AdvertiseCallbackWrapper>();
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            IBluetoothGatt gatt;
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            if (!this.mBluetoothAdapter.isMultipleAdvertisementSupported() && !this.mBluetoothAdapter.isPeripheralModeSupported()) {
                this.postStartFailure(callback, 5);
                return;
            }
            boolean isConnectable = settings.isConnectable();
            if (this.totalBytes(advertiseData, isConnectable) > 31 || this.totalBytes(scanResponse, false) > 31) {
                this.postStartFailure(callback, 1);
                return;
            }
            if (this.mLeAdvertisers.containsKey(callback)) {
                this.postStartFailure(callback, 3);
                return;
            }
            try {
                gatt = this.mBluetoothManager.getBluetoothGatt();
            }
            catch (RemoteException e) {
                Log.e("BluetoothLeAdvertiser", "Failed to get Bluetooth gatt - ", e);
                this.postStartFailure(callback, 4);
                return;
            }
            AdvertiseCallbackWrapper wrapper = new AdvertiseCallbackWrapper(this, callback, advertiseData, scanResponse, settings, gatt);
            wrapper.startRegisteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertising(AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertiseCallbackWrapper wrapper = this.mLeAdvertisers.get(callback);
            if (wrapper == null) {
                return;
            }
            wrapper.stopAdvertising();
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$cleanup() {
        this.mLeAdvertisers.clear();
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$totalBytes(AdvertiseData data, boolean isFlagsIncluded) {
        int size;
        if (data == null) {
            return 0;
        }
        int n = size = isFlagsIncluded ? 3 : 0;
        if (data.getServiceUuids() != null) {
            int num16BitUuids = 0;
            int num32BitUuids = 0;
            int num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid(uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        for (ParcelUuid uuid : data.getServiceData().keySet()) {
            size += 4 + this.byteLength(data.getServiceData().get(uuid));
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + this.byteLength(data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && this.mBluetoothAdapter.getName() != null) {
            size += 2 + this.mBluetoothAdapter.getName().length();
        }
        return size;
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$byteLength(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartFailure(AdvertiseCallback callback, int error) {
        this.mHandler.post(new Runnable(this, callback, error){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertiseCallback val$callback;
            /* synthetic */ int val$error;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(BluetoothLeAdvertiser this$0, AdvertiseCallback advertiseCallback, int n) {
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$run() {
                this.val$callback.onStartFailure(this.val$error);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, int n) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(bluetoothLeAdvertiser, advertiseCallback, n);
            }
            {
                this.this$0 = bluetoothLeAdvertiser;
                this.val$callback = advertiseCallback;
                this.val$error = n;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback int ), 0, this, bluetoothLeAdvertiser, advertiseCallback, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSuccess(AdvertiseCallback callback, AdvertiseSettings settings) {
        this.mHandler.post(new Runnable(this, callback, settings){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertiseCallback val$callback;
            /* synthetic */ AdvertiseSettings val$settings;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(BluetoothLeAdvertiser this$0, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$run() {
                this.val$callback.onStartSuccess(this.val$settings);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }
            {
                this.this$0 = bluetoothLeAdvertiser;
                this.val$callback = advertiseCallback;
                this.val$settings = advertiseSettings;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), 0, this, bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(iBluetoothManager);
    }

    public BluetoothLeAdvertiser(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(android.bluetooth.IBluetoothManager ), 0, this, iBluetoothManager);
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(android.bluetooth.le.AdvertiseSettings android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseCallback ), 0, this, advertiseSettings, advertiseData, advertiseCallback);
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(android.bluetooth.le.AdvertiseSettings android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseCallback ), 0, this, advertiseSettings, advertiseData, advertiseData2, advertiseCallback);
    }

    public void stopAdvertising(AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("stopAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertising(android.bluetooth.le.AdvertiseCallback ), 0, this, advertiseCallback);
    }

    public void cleanup() {
        InvokeDynamicSupport.bootstrap("cleanup", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$cleanup(), 0, this);
    }

    private int totalBytes(AdvertiseData advertiseData, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("totalBytes", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$totalBytes(android.bluetooth.le.AdvertiseData boolean ), 0, this, advertiseData, bl);
    }

    private int byteLength(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("byteLength", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$byteLength(byte[] ), 0, this, byArray);
    }

    private void postStartFailure(AdvertiseCallback advertiseCallback, int n) {
        InvokeDynamicSupport.bootstrap("postStartFailure", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartFailure(android.bluetooth.le.AdvertiseCallback int ), 0, this, advertiseCallback, n);
    }

    private void postStartSuccess(AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
        InvokeDynamicSupport.bootstrap("postStartSuccess", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSuccess(android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), 0, this, advertiseCallback, advertiseSettings);
    }

    public /* synthetic */ BluetoothLeAdvertiser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothLeAdvertiser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class AdvertiseCallbackWrapper
    extends BluetoothGattCallbackWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int LE_CALLBACK_TIMEOUT_MILLIS = 2000;
        private AdvertiseCallback mAdvertiseCallback;
        private AdvertiseData mAdvertisement;
        private AdvertiseData mScanResponse;
        private AdvertiseSettings mSettings;
        private IBluetoothGatt mBluetoothGatt;
        private int mClientIf;
        private boolean mIsAdvertising;
        /* synthetic */ BluetoothLeAdvertiser this$0;

        private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$__constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseSettings settings, IBluetoothGatt bluetoothGatt) {
            this.mIsAdvertising = false;
            this.mAdvertiseCallback = advertiseCallback;
            this.mAdvertisement = advertiseData;
            this.mScanResponse = scanResponse;
            this.mSettings = settings;
            this.mBluetoothGatt = bluetoothGatt;
            this.mClientIf = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$startRegisteration() {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (this.mClientIf == -1) {
                    return;
                }
                try {
                    UUID uuid = UUID.randomUUID();
                    this.mBluetoothGatt.registerClient(new ParcelUuid(uuid), this);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException e) {
                    Log.e("BluetoothLeAdvertiser", "Failed to start registeration", e);
                }
                if (this.mClientIf > 0 && this.mIsAdvertising) {
                    this.this$0.mLeAdvertisers.put(this.mAdvertiseCallback, this);
                } else if (this.mClientIf <= 0) {
                    if (this.mClientIf == 0) {
                        this.mClientIf = -1;
                    }
                    this.this$0.postStartFailure(this.mAdvertiseCallback, 4);
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothLeAdvertiser", "remote exception when unregistering", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$stopAdvertising() {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                try {
                    this.mBluetoothGatt.stopMultiAdvertising(this.mClientIf);
                    this.wait(2000L);
                }
                catch (RemoteException | InterruptedException e) {
                    Log.e("BluetoothLeAdvertiser", "Failed to stop advertising", e);
                }
                if (this.this$0.mLeAdvertisers.containsKey(this.mAdvertiseCallback)) {
                    this.this$0.mLeAdvertisers.remove(this.mAdvertiseCallback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$onClientRegistered(int status, int clientIf) {
            Log.d("BluetoothLeAdvertiser", "onClientRegistered() - status=" + status + " clientIf=" + clientIf);
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (status == 0) {
                    try {
                        if (this.mClientIf == -1) {
                            this.mBluetoothGatt.unregisterClient(clientIf);
                        } else {
                            this.mClientIf = clientIf;
                            this.mBluetoothGatt.startMultiAdvertising(this.mClientIf, this.mAdvertisement, this.mScanResponse, this.mSettings);
                        }
                        return;
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothLeAdvertiser", "failed to start advertising", e);
                    }
                }
                this.mClientIf = -1;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$onMultiAdvertiseCallback(int status, boolean isStart, AdvertiseSettings settings) {
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this;
            synchronized (advertiseCallbackWrapper) {
                if (isStart) {
                    if (status == 0) {
                        this.mIsAdvertising = true;
                        this.this$0.postStartSuccess(this.mAdvertiseCallback, settings);
                    } else {
                        this.this$0.postStartFailure(this.mAdvertiseCallback, status);
                    }
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                        this.mIsAdvertising = false;
                        this.this$0.mLeAdvertisers.remove(this.mAdvertiseCallback);
                    }
                    catch (RemoteException e) {
                        Log.e("BluetoothLeAdvertiser", "remote exception when unregistering", e);
                    }
                }
                this.notifyAll();
            }
        }

        private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings, IBluetoothGatt iBluetoothGatt) {
            this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$__constructor__(bluetoothLeAdvertiser, advertiseCallback, advertiseData, advertiseData2, advertiseSettings, iBluetoothGatt);
        }

        public AdvertiseCallbackWrapper(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings, IBluetoothGatt iBluetoothGatt) {
            this.this$0 = bluetoothLeAdvertiser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseSettings android.bluetooth.IBluetoothGatt ), 0, this, bluetoothLeAdvertiser, advertiseCallback, advertiseData, advertiseData2, advertiseSettings, iBluetoothGatt);
        }

        public void startRegisteration() {
            InvokeDynamicSupport.bootstrap("startRegisteration", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$startRegisteration(), 0, this);
        }

        public void stopAdvertising() {
            InvokeDynamicSupport.bootstrap("stopAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$stopAdvertising(), 0, this);
        }

        @Override
        public void onClientRegistered(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onClientRegistered", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$onClientRegistered(int int ), 0, this, n, n2);
        }

        @Override
        public void onMultiAdvertiseCallback(int n, boolean bl, AdvertiseSettings advertiseSettings) {
            InvokeDynamicSupport.bootstrap("onMultiAdvertiseCallback", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_AdvertiseCallbackWrapper$onMultiAdvertiseCallback(int boolean android.bluetooth.le.AdvertiseSettings ), 0, this, n, bl, advertiseSettings);
        }

        public /* synthetic */ AdvertiseCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdvertiseCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

