/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ScanFilter
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mDeviceName;
    private String mDeviceAddress;
    private ParcelUuid mServiceUuid;
    private ParcelUuid mServiceUuidMask;
    private ParcelUuid mServiceDataUuid;
    private byte[] mServiceData;
    private byte[] mServiceDataMask;
    private int mManufacturerId;
    private byte[] mManufacturerData;
    private byte[] mManufacturerDataMask;
    private static ScanFilter EMPTY;
    public static Parcelable.Creator<ScanFilter> CREATOR;

    private void $$robo$$android_bluetooth_le_ScanFilter$__constructor__(String name, String deviceAddress, ParcelUuid uuid, ParcelUuid uuidMask, ParcelUuid serviceDataUuid, byte[] serviceData, byte[] serviceDataMask, int manufacturerId, byte[] manufacturerData, byte[] manufacturerDataMask) {
        this.mDeviceName = name;
        this.mServiceUuid = uuid;
        this.mServiceUuidMask = uuidMask;
        this.mDeviceAddress = deviceAddress;
        this.mServiceDataUuid = serviceDataUuid;
        this.mServiceData = serviceData;
        this.mServiceDataMask = serviceDataMask;
        this.mManufacturerId = manufacturerId;
        this.mManufacturerData = manufacturerData;
        this.mManufacturerDataMask = manufacturerDataMask;
    }

    private final int $$robo$$android_bluetooth_le_ScanFilter$describeContents() {
        return 0;
    }

    private final void $$robo$$android_bluetooth_le_ScanFilter$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDeviceName == null ? 0 : 1);
        if (this.mDeviceName != null) {
            dest.writeString(this.mDeviceName);
        }
        dest.writeInt(this.mDeviceAddress == null ? 0 : 1);
        if (this.mDeviceAddress != null) {
            dest.writeString(this.mDeviceAddress);
        }
        dest.writeInt(this.mServiceUuid == null ? 0 : 1);
        if (this.mServiceUuid != null) {
            dest.writeParcelable(this.mServiceUuid, flags);
            dest.writeInt(this.mServiceUuidMask == null ? 0 : 1);
            if (this.mServiceUuidMask != null) {
                dest.writeParcelable(this.mServiceUuidMask, flags);
            }
        }
        dest.writeInt(this.mServiceDataUuid == null ? 0 : 1);
        if (this.mServiceDataUuid != null) {
            dest.writeParcelable(this.mServiceDataUuid, flags);
            dest.writeInt(this.mServiceData == null ? 0 : 1);
            if (this.mServiceData != null) {
                dest.writeInt(this.mServiceData.length);
                dest.writeByteArray(this.mServiceData);
                dest.writeInt(this.mServiceDataMask == null ? 0 : 1);
                if (this.mServiceDataMask != null) {
                    dest.writeInt(this.mServiceDataMask.length);
                    dest.writeByteArray(this.mServiceDataMask);
                }
            }
        }
        dest.writeInt(this.mManufacturerId);
        dest.writeInt(this.mManufacturerData == null ? 0 : 1);
        if (this.mManufacturerData != null) {
            dest.writeInt(this.mManufacturerData.length);
            dest.writeByteArray(this.mManufacturerData);
            dest.writeInt(this.mManufacturerDataMask == null ? 0 : 1);
            if (this.mManufacturerDataMask != null) {
                dest.writeInt(this.mManufacturerDataMask.length);
                dest.writeByteArray(this.mManufacturerDataMask);
            }
        }
    }

    private final String $$robo$$android_bluetooth_le_ScanFilter$getDeviceName() {
        return this.mDeviceName;
    }

    private final ParcelUuid $$robo$$android_bluetooth_le_ScanFilter$getServiceUuid() {
        return this.mServiceUuid;
    }

    private final ParcelUuid $$robo$$android_bluetooth_le_ScanFilter$getServiceUuidMask() {
        return this.mServiceUuidMask;
    }

    private final String $$robo$$android_bluetooth_le_ScanFilter$getDeviceAddress() {
        return this.mDeviceAddress;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanFilter$getServiceData() {
        return this.mServiceData;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanFilter$getServiceDataMask() {
        return this.mServiceDataMask;
    }

    private final ParcelUuid $$robo$$android_bluetooth_le_ScanFilter$getServiceDataUuid() {
        return this.mServiceDataUuid;
    }

    private final int $$robo$$android_bluetooth_le_ScanFilter$getManufacturerId() {
        return this.mManufacturerId;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanFilter$getManufacturerData() {
        return this.mManufacturerData;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanFilter$getManufacturerDataMask() {
        return this.mManufacturerDataMask;
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$matches(ScanResult scanResult) {
        if (scanResult == null) {
            return false;
        }
        BluetoothDevice device = scanResult.getDevice();
        if (!(this.mDeviceAddress == null || device != null && this.mDeviceAddress.equals(device.getAddress()))) {
            return false;
        }
        ScanRecord scanRecord = scanResult.getScanRecord();
        if (scanRecord == null && (this.mDeviceName != null || this.mServiceUuid != null || this.mManufacturerData != null || this.mServiceData != null)) {
            return false;
        }
        if (this.mDeviceName != null && !this.mDeviceName.equals(scanRecord.getDeviceName())) {
            return false;
        }
        if (this.mServiceUuid != null && !this.matchesServiceUuids(this.mServiceUuid, this.mServiceUuidMask, scanRecord.getServiceUuids())) {
            return false;
        }
        if (this.mServiceDataUuid != null && !this.matchesPartialData(this.mServiceData, this.mServiceDataMask, scanRecord.getServiceData(this.mServiceDataUuid))) {
            return false;
        }
        return this.mManufacturerId < 0 || this.matchesPartialData(this.mManufacturerData, this.mManufacturerDataMask, scanRecord.getManufacturerSpecificData(this.mManufacturerId));
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$matchesServiceUuids(ParcelUuid uuid, ParcelUuid parcelUuidMask, List<ParcelUuid> uuids) {
        if (uuid == null) {
            return true;
        }
        if (uuids == null) {
            return false;
        }
        for (ParcelUuid parcelUuid : uuids) {
            UUID uuidMask;
            UUID uUID = uuidMask = parcelUuidMask == null ? null : parcelUuidMask.getUuid();
            if (!this.matchesServiceUuid(uuid.getUuid(), uuidMask, parcelUuid.getUuid())) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$matchesServiceUuid(UUID uuid, UUID mask, UUID data) {
        if (mask == null) {
            return uuid.equals(data);
        }
        if ((uuid.getLeastSignificantBits() & mask.getLeastSignificantBits()) != (data.getLeastSignificantBits() & mask.getLeastSignificantBits())) {
            return false;
        }
        return (uuid.getMostSignificantBits() & mask.getMostSignificantBits()) == (data.getMostSignificantBits() & mask.getMostSignificantBits());
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$matchesPartialData(byte[] data, byte[] dataMask, byte[] parsedData) {
        if (parsedData == null || parsedData.length < data.length) {
            return false;
        }
        if (dataMask == null) {
            for (int i = 0; i < data.length; ++i) {
                if (parsedData[i] == data[i]) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < data.length; ++i) {
            if ((dataMask[i] & parsedData[i]) == (dataMask[i] & data[i])) continue;
            return false;
        }
        return true;
    }

    private final String $$robo$$android_bluetooth_le_ScanFilter$toString() {
        return "BluetoothLeScanFilter [mDeviceName=" + this.mDeviceName + ", mDeviceAddress=" + this.mDeviceAddress + ", mUuid=" + this.mServiceUuid + ", mUuidMask=" + this.mServiceUuidMask + ", mServiceDataUuid=" + Objects.toString(this.mServiceDataUuid) + ", mServiceData=" + Arrays.toString(this.mServiceData) + ", mServiceDataMask=" + Arrays.toString(this.mServiceDataMask) + ", mManufacturerId=" + this.mManufacturerId + ", mManufacturerData=" + Arrays.toString(this.mManufacturerData) + ", mManufacturerDataMask=" + Arrays.toString(this.mManufacturerDataMask) + "]";
    }

    private final int $$robo$$android_bluetooth_le_ScanFilter$hashCode() {
        return Objects.hash(this.mDeviceName, this.mDeviceAddress, this.mManufacturerId, Arrays.hashCode(this.mManufacturerData), Arrays.hashCode(this.mManufacturerDataMask), this.mServiceDataUuid, Arrays.hashCode(this.mServiceData), Arrays.hashCode(this.mServiceDataMask), this.mServiceUuid, this.mServiceUuidMask);
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScanFilter other = (ScanFilter)obj;
        return Objects.equals(this.mDeviceName, other.mDeviceName) && Objects.equals(this.mDeviceAddress, other.mDeviceAddress) && this.mManufacturerId == other.mManufacturerId && Objects.deepEquals(this.mManufacturerData, other.mManufacturerData) && Objects.deepEquals(this.mManufacturerDataMask, other.mManufacturerDataMask) && Objects.equals(this.mServiceDataUuid, other.mServiceDataUuid) && Objects.deepEquals(this.mServiceData, other.mServiceData) && Objects.deepEquals(this.mServiceDataMask, other.mServiceDataMask) && Objects.equals(this.mServiceUuid, other.mServiceUuid) && Objects.equals(this.mServiceUuidMask, other.mServiceUuidMask);
    }

    private final boolean $$robo$$android_bluetooth_le_ScanFilter$isAllFieldsEmpty() {
        return EMPTY.equals(this);
    }

    private /* synthetic */ void $$robo$$android_bluetooth_le_ScanFilter$__constructor__(String x0, String x1, ParcelUuid x2, ParcelUuid x3, ParcelUuid x4, byte[] x5, byte[] x6, int x7, byte[] x8, byte[] x9, 1 x10) {
    }

    static void __staticInitializer__() {
        EMPTY = new Builder().build();
        CREATOR = new Parcelable.Creator<ScanFilter>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_le_ScanFilter_1$__constructor__() {
            }

            private final ScanFilter[] $$robo$$android_bluetooth_le_ScanFilter_1$newArray(int size) {
                return new ScanFilter[size];
            }

            private final ScanFilter $$robo$$android_bluetooth_le_ScanFilter_1$createFromParcel(Parcel in) {
                Builder builder = new Builder();
                if (in.readInt() == 1) {
                    builder.setDeviceName(in.readString());
                }
                if (in.readInt() == 1) {
                    builder.setDeviceAddress(in.readString());
                }
                if (in.readInt() == 1) {
                    ParcelUuid uuid = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader());
                    builder.setServiceUuid(uuid);
                    if (in.readInt() == 1) {
                        ParcelUuid uuidMask = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader());
                        builder.setServiceUuid(uuid, uuidMask);
                    }
                }
                if (in.readInt() == 1) {
                    ParcelUuid servcieDataUuid = (ParcelUuid)in.readParcelable(ParcelUuid.class.getClassLoader());
                    if (in.readInt() == 1) {
                        int serviceDataLength = in.readInt();
                        byte[] serviceData = new byte[serviceDataLength];
                        in.readByteArray(serviceData);
                        if (in.readInt() == 0) {
                            builder.setServiceData(servcieDataUuid, serviceData);
                        } else {
                            int serviceDataMaskLength = in.readInt();
                            byte[] serviceDataMask = new byte[serviceDataMaskLength];
                            in.readByteArray(serviceDataMask);
                            builder.setServiceData(servcieDataUuid, serviceData, serviceDataMask);
                        }
                    }
                }
                int manufacturerId = in.readInt();
                if (in.readInt() == 1) {
                    int manufacturerDataLength = in.readInt();
                    byte[] manufacturerData = new byte[manufacturerDataLength];
                    in.readByteArray(manufacturerData);
                    if (in.readInt() == 0) {
                        builder.setManufacturerData(manufacturerId, manufacturerData);
                    } else {
                        int manufacturerDataMaskLength = in.readInt();
                        byte[] manufacturerDataMask = new byte[manufacturerDataMaskLength];
                        in.readByteArray(manufacturerDataMask);
                        builder.setManufacturerData(manufacturerId, manufacturerData, manufacturerDataMask);
                    }
                }
                return builder.build();
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_le_ScanFilter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanFilter_1$__constructor__(), 0, this);
            }

            public ScanFilter[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_bluetooth_le_ScanFilter_1$newArray(int ), 0, this, n);
            }

            @Override
            public ScanFilter createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_bluetooth_le_ScanFilter_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, String string3, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        this.$$robo$$android_bluetooth_le_ScanFilter$__constructor__(string2, string3, parcelUuid, parcelUuid2, parcelUuid3, byArray, byArray2, n, byArray3, byArray4);
    }

    private ScanFilter(String string2, String string3, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanFilter$__constructor__(java.lang.String java.lang.String android.os.ParcelUuid android.os.ParcelUuid android.os.ParcelUuid byte[] byte[] int byte[] byte[] ), 0, this, string2, string3, parcelUuid, parcelUuid2, parcelUuid3, byArray, byArray2, n, byArray3, byArray4);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_bluetooth_le_ScanFilter$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_bluetooth_le_ScanFilter$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getDeviceName() {
        return InvokeDynamicSupport.bootstrap("getDeviceName", $$robo$$android_bluetooth_le_ScanFilter$getDeviceName(), 0, this);
    }

    public ParcelUuid getServiceUuid() {
        return InvokeDynamicSupport.bootstrap("getServiceUuid", $$robo$$android_bluetooth_le_ScanFilter$getServiceUuid(), 0, this);
    }

    public ParcelUuid getServiceUuidMask() {
        return InvokeDynamicSupport.bootstrap("getServiceUuidMask", $$robo$$android_bluetooth_le_ScanFilter$getServiceUuidMask(), 0, this);
    }

    public String getDeviceAddress() {
        return InvokeDynamicSupport.bootstrap("getDeviceAddress", $$robo$$android_bluetooth_le_ScanFilter$getDeviceAddress(), 0, this);
    }

    public byte[] getServiceData() {
        return InvokeDynamicSupport.bootstrap("getServiceData", $$robo$$android_bluetooth_le_ScanFilter$getServiceData(), 0, this);
    }

    public byte[] getServiceDataMask() {
        return InvokeDynamicSupport.bootstrap("getServiceDataMask", $$robo$$android_bluetooth_le_ScanFilter$getServiceDataMask(), 0, this);
    }

    public ParcelUuid getServiceDataUuid() {
        return InvokeDynamicSupport.bootstrap("getServiceDataUuid", $$robo$$android_bluetooth_le_ScanFilter$getServiceDataUuid(), 0, this);
    }

    public int getManufacturerId() {
        return (int)InvokeDynamicSupport.bootstrap("getManufacturerId", $$robo$$android_bluetooth_le_ScanFilter$getManufacturerId(), 0, this);
    }

    public byte[] getManufacturerData() {
        return InvokeDynamicSupport.bootstrap("getManufacturerData", $$robo$$android_bluetooth_le_ScanFilter$getManufacturerData(), 0, this);
    }

    public byte[] getManufacturerDataMask() {
        return InvokeDynamicSupport.bootstrap("getManufacturerDataMask", $$robo$$android_bluetooth_le_ScanFilter$getManufacturerDataMask(), 0, this);
    }

    public boolean matches(ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_bluetooth_le_ScanFilter$matches(android.bluetooth.le.ScanResult ), 0, this, scanResult);
    }

    private boolean matchesServiceUuids(ParcelUuid parcelUuid, ParcelUuid parcelUuid2, List<ParcelUuid> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesServiceUuids", $$robo$$android_bluetooth_le_ScanFilter$matchesServiceUuids(android.os.ParcelUuid android.os.ParcelUuid java.util.List<android.os.ParcelUuid> ), 0, this, parcelUuid, parcelUuid2, list);
    }

    private boolean matchesServiceUuid(UUID uUID, UUID uUID2, UUID uUID3) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesServiceUuid", $$robo$$android_bluetooth_le_ScanFilter$matchesServiceUuid(java.util.UUID java.util.UUID java.util.UUID ), 0, this, uUID, uUID2, uUID3);
    }

    private boolean matchesPartialData(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesPartialData", $$robo$$android_bluetooth_le_ScanFilter$matchesPartialData(byte[] byte[] byte[] ), 0, this, byArray, byArray2, byArray3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_le_ScanFilter$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_bluetooth_le_ScanFilter$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_bluetooth_le_ScanFilter$equals(java.lang.Object ), 0, this, object);
    }

    public boolean isAllFieldsEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAllFieldsEmpty", $$robo$$android_bluetooth_le_ScanFilter$isAllFieldsEmpty(), 0, this);
    }

    private /* synthetic */ void __constructor__(String string2, String string3, ParcelUuid parcelUuid, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray, byte[] byArray2, int n, byte[] byArray3, byte[] byArray4, 1 var11_11) {
        this.$$robo$$android_bluetooth_le_ScanFilter$__constructor__(string2, string3, parcelUuid, parcelUuid2, parcelUuid3, byArray, byArray2, n, byArray3, byArray4, var11_11);
    }

    static {
        RobolectricInternals.classInitializing(ScanFilter.class);
    }

    public /* synthetic */ ScanFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mDeviceName;
        private String mDeviceAddress;
        private ParcelUuid mServiceUuid;
        private ParcelUuid mUuidMask;
        private ParcelUuid mServiceDataUuid;
        private byte[] mServiceData;
        private byte[] mServiceDataMask;
        private int mManufacturerId;
        private byte[] mManufacturerData;
        private byte[] mManufacturerDataMask;

        private void $$robo$$android_bluetooth_le_ScanFilter_Builder$__constructor__() {
            this.mManufacturerId = -1;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setDeviceName(String deviceName) {
            this.mDeviceName = deviceName;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setDeviceAddress(String deviceAddress) {
            if (deviceAddress != null && !BluetoothAdapter.checkBluetoothAddress(deviceAddress)) {
                throw new IllegalArgumentException("invalid device address " + deviceAddress);
            }
            this.mDeviceAddress = deviceAddress;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceUuid(ParcelUuid serviceUuid) {
            this.mServiceUuid = serviceUuid;
            this.mUuidMask = null;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceUuid(ParcelUuid serviceUuid, ParcelUuid uuidMask) {
            if (this.mUuidMask != null && this.mServiceUuid == null) {
                throw new IllegalArgumentException("uuid is null while uuidMask is not null!");
            }
            this.mServiceUuid = serviceUuid;
            this.mUuidMask = uuidMask;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceData(ParcelUuid serviceDataUuid, byte[] serviceData) {
            if (serviceDataUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            this.mServiceDataUuid = serviceDataUuid;
            this.mServiceData = serviceData;
            this.mServiceDataMask = null;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceData(ParcelUuid serviceDataUuid, byte[] serviceData, byte[] serviceDataMask) {
            if (serviceDataUuid == null) {
                throw new IllegalArgumentException("serviceDataUuid is null");
            }
            if (this.mServiceDataMask != null) {
                if (this.mServiceData == null) {
                    throw new IllegalArgumentException("serviceData is null while serviceDataMask is not null");
                }
                if (this.mServiceData.length != this.mServiceDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for service data and service data mask");
                }
            }
            this.mServiceDataUuid = serviceDataUuid;
            this.mServiceData = serviceData;
            this.mServiceDataMask = serviceDataMask;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setManufacturerData(int manufacturerId, byte[] manufacturerData) {
            if (manufacturerData != null && manufacturerId < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            this.mManufacturerId = manufacturerId;
            this.mManufacturerData = manufacturerData;
            this.mManufacturerDataMask = null;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_ScanFilter_Builder$setManufacturerData(int manufacturerId, byte[] manufacturerData, byte[] manufacturerDataMask) {
            if (manufacturerData != null && manufacturerId < 0) {
                throw new IllegalArgumentException("invalid manufacture id");
            }
            if (this.mManufacturerDataMask != null) {
                if (this.mManufacturerData == null) {
                    throw new IllegalArgumentException("manufacturerData is null while manufacturerDataMask is not null");
                }
                if (this.mManufacturerData.length != this.mManufacturerDataMask.length) {
                    throw new IllegalArgumentException("size mismatch for manufacturerData and manufacturerDataMask");
                }
            }
            this.mManufacturerId = manufacturerId;
            this.mManufacturerData = manufacturerData;
            this.mManufacturerDataMask = manufacturerDataMask;
            return this;
        }

        private final ScanFilter $$robo$$android_bluetooth_le_ScanFilter_Builder$build() {
            return new ScanFilter(this.mDeviceName, this.mDeviceAddress, this.mServiceUuid, this.mUuidMask, this.mServiceDataUuid, this.mServiceData, this.mServiceDataMask, this.mManufacturerId, this.mManufacturerData, this.mManufacturerDataMask);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_le_ScanFilter_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanFilter_Builder$__constructor__(), 0, this);
        }

        public Builder setDeviceName(String string2) {
            return InvokeDynamicSupport.bootstrap("setDeviceName", $$robo$$android_bluetooth_le_ScanFilter_Builder$setDeviceName(java.lang.String ), 0, this, string2);
        }

        public Builder setDeviceAddress(String string2) {
            return InvokeDynamicSupport.bootstrap("setDeviceAddress", $$robo$$android_bluetooth_le_ScanFilter_Builder$setDeviceAddress(java.lang.String ), 0, this, string2);
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid) {
            return InvokeDynamicSupport.bootstrap("setServiceUuid", $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceUuid(android.os.ParcelUuid ), 0, this, parcelUuid);
        }

        public Builder setServiceUuid(ParcelUuid parcelUuid, ParcelUuid parcelUuid2) {
            return InvokeDynamicSupport.bootstrap("setServiceUuid", $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceUuid(android.os.ParcelUuid android.os.ParcelUuid ), 0, this, parcelUuid, parcelUuid2);
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setServiceData", $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceData(android.os.ParcelUuid byte[] ), 0, this, parcelUuid, byArray);
        }

        public Builder setServiceData(ParcelUuid parcelUuid, byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("setServiceData", $$robo$$android_bluetooth_le_ScanFilter_Builder$setServiceData(android.os.ParcelUuid byte[] byte[] ), 0, this, parcelUuid, byArray, byArray2);
        }

        public Builder setManufacturerData(int n, byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setManufacturerData", $$robo$$android_bluetooth_le_ScanFilter_Builder$setManufacturerData(int byte[] ), 0, this, n, byArray);
        }

        public Builder setManufacturerData(int n, byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("setManufacturerData", $$robo$$android_bluetooth_le_ScanFilter_Builder$setManufacturerData(int byte[] byte[] ), 0, this, n, byArray, byArray2);
        }

        public ScanFilter build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_bluetooth_le_ScanFilter_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

