/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class EphemeralResolveInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SHA_ALGORITHM = "SHA-256";
    private byte[] mDigestBytes;
    private int mDigestPrefix;
    private String mPackageName;
    private List<IntentFilter> mFilters;
    public static Parcelable.Creator<EphemeralResolveInfo> CREATOR;

    private void $$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(Uri uri, String packageName, List<IntentFilter> filters) {
        this.mFilters = new ArrayList<IntentFilter>();
        if (uri == null || packageName == null || filters == null || filters.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.mDigestBytes = EphemeralResolveInfo.generateDigest(uri);
        this.mDigestPrefix = this.mDigestBytes[0] << 24 | this.mDigestBytes[1] << 16 | this.mDigestBytes[2] << 8 | this.mDigestBytes[3] << 0;
        this.mFilters.addAll(filters);
        this.mPackageName = packageName;
    }

    private void $$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(Parcel in) {
        this.mFilters = new ArrayList<IntentFilter>();
        this.mDigestBytes = in.createByteArray();
        this.mDigestPrefix = in.readInt();
        this.mPackageName = in.readString();
        in.readList(this.mFilters, null);
    }

    private final byte[] $$robo$$android_content_pm_EphemeralResolveInfo$getDigestBytes() {
        return this.mDigestBytes;
    }

    private final int $$robo$$android_content_pm_EphemeralResolveInfo$getDigestPrefix() {
        return this.mDigestPrefix;
    }

    private final String $$robo$$android_content_pm_EphemeralResolveInfo$getPackageName() {
        return this.mPackageName;
    }

    private final List<IntentFilter> $$robo$$android_content_pm_EphemeralResolveInfo$getFilters() {
        return this.mFilters;
    }

    private static final byte[] $$robo$$android_content_pm_EphemeralResolveInfo$generateDigest(Uri uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hostBytes = uri.getHost().getBytes();
            return digest.digest(hostBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not find digest algorithm");
        }
    }

    private final int $$robo$$android_content_pm_EphemeralResolveInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_EphemeralResolveInfo$writeToParcel(Parcel out, int flags) {
        out.writeByteArray(this.mDigestBytes);
        out.writeInt(this.mDigestPrefix);
        out.writeString(this.mPackageName);
        out.writeList(this.mFilters);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<EphemeralResolveInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_EphemeralResolveInfo_1$__constructor__() {
            }

            private final EphemeralResolveInfo $$robo$$android_content_pm_EphemeralResolveInfo_1$createFromParcel(Parcel in) {
                return new EphemeralResolveInfo(in);
            }

            private final EphemeralResolveInfo[] $$robo$$android_content_pm_EphemeralResolveInfo_1$newArray(int size) {
                return new EphemeralResolveInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_EphemeralResolveInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_EphemeralResolveInfo_1$__constructor__(), 0, this);
            }

            @Override
            public EphemeralResolveInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_EphemeralResolveInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public EphemeralResolveInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_EphemeralResolveInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Uri uri, String string2, List<IntentFilter> list) {
        this.$$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(uri, string2, list);
    }

    public EphemeralResolveInfo(Uri uri, String string2, List<IntentFilter> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(android.net.Uri java.lang.String java.util.List<android.content.IntentFilter> ), 0, this, uri, string2, list);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(parcel);
    }

    EphemeralResolveInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_EphemeralResolveInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public byte[] getDigestBytes() {
        return InvokeDynamicSupport.bootstrap("getDigestBytes", $$robo$$android_content_pm_EphemeralResolveInfo$getDigestBytes(), 0, this);
    }

    public int getDigestPrefix() {
        return (int)InvokeDynamicSupport.bootstrap("getDigestPrefix", $$robo$$android_content_pm_EphemeralResolveInfo$getDigestPrefix(), 0, this);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_content_pm_EphemeralResolveInfo$getPackageName(), 0, this);
    }

    public List<IntentFilter> getFilters() {
        return InvokeDynamicSupport.bootstrap("getFilters", $$robo$$android_content_pm_EphemeralResolveInfo$getFilters(), 0, this);
    }

    private static byte[] generateDigest(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("generateDigest", $$robo$$android_content_pm_EphemeralResolveInfo$generateDigest(android.net.Uri ), 0, (Uri)uri);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_EphemeralResolveInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_EphemeralResolveInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(EphemeralResolveInfo.class);
    }

    public /* synthetic */ EphemeralResolveInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EphemeralResolveInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EphemeralResolveIntentInfo
    extends IntentFilter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private EphemeralResolveInfo mResolveInfo;

        private void $$robo$$android_content_pm_EphemeralResolveInfo_EphemeralResolveIntentInfo$__constructor__(IntentFilter orig, EphemeralResolveInfo resolveInfo) {
            this.mResolveInfo = resolveInfo;
        }

        private final EphemeralResolveInfo $$robo$$android_content_pm_EphemeralResolveInfo_EphemeralResolveIntentInfo$getEphemeralResolveInfo() {
            return this.mResolveInfo;
        }

        private void __constructor__(IntentFilter intentFilter, EphemeralResolveInfo ephemeralResolveInfo) {
            this.$$robo$$android_content_pm_EphemeralResolveInfo_EphemeralResolveIntentInfo$__constructor__(intentFilter, ephemeralResolveInfo);
        }

        public EphemeralResolveIntentInfo(IntentFilter intentFilter, EphemeralResolveInfo ephemeralResolveInfo) {
            super(intentFilter);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_EphemeralResolveInfo_EphemeralResolveIntentInfo$__constructor__(android.content.IntentFilter android.content.pm.EphemeralResolveInfo ), 0, this, intentFilter, ephemeralResolveInfo);
        }

        public EphemeralResolveInfo getEphemeralResolveInfo() {
            return InvokeDynamicSupport.bootstrap("getEphemeralResolveInfo", $$robo$$android_content_pm_EphemeralResolveInfo_EphemeralResolveIntentInfo$getEphemeralResolveInfo(), 0, this);
        }

        public /* synthetic */ EphemeralResolveIntentInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EphemeralResolveIntentInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

