/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.BulkCursorDescriptor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Cursor";
    private Object mLock;
    private String mProviderName;
    private ContentObserverProxy mObserver;
    private CrossProcessCursor mCursor;
    private CursorWindow mFilledWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_database_CursorToBulkCursorAdaptor$__constructor__(Cursor cursor, IContentObserver observer, String providerName) {
        this.mLock = new Object();
        this.mCursor = cursor instanceof CrossProcessCursor ? (CrossProcessCursor)cursor : new CrossProcessCursorWrapper(cursor);
        this.mProviderName = providerName;
        Object object = this.mLock;
        synchronized (object) {
            this.createAndRegisterObserverProxyLocked(observer);
        }
    }

    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$closeFilledWindowLocked() {
        if (this.mFilledWindow != null) {
            this.mFilledWindow.close();
            this.mFilledWindow = null;
        }
    }

    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$disposeLocked() {
        if (this.mCursor != null) {
            this.unregisterObserverProxyLocked();
            this.mCursor.close();
            this.mCursor = null;
        }
        this.closeFilledWindowLocked();
    }

    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$throwIfCursorIsClosed() {
        if (this.mCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BulkCursorDescriptor $$robo$$android_database_CursorToBulkCursorAdaptor$getBulkCursorDescriptor() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            BulkCursorDescriptor d = new BulkCursorDescriptor();
            d.cursor = this;
            d.columnNames = this.mCursor.getColumnNames();
            d.wantsAllOnMoveCalls = this.mCursor.getWantsAllOnMoveCalls();
            d.count = this.mCursor.getCount();
            d.window = this.mCursor.getWindow();
            if (d.window != null) {
                d.window.acquireReference();
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CursorWindow $$robo$$android_database_CursorToBulkCursorAdaptor$getWindow(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            if (!this.mCursor.moveToPosition(position)) {
                this.closeFilledWindowLocked();
                return null;
            }
            CursorWindow window = this.mCursor.getWindow();
            if (window != null) {
                this.closeFilledWindowLocked();
            } else {
                window = this.mFilledWindow;
                if (window == null) {
                    window = this.mFilledWindow = new CursorWindow(this.mProviderName);
                } else if (position < window.getStartPosition() || position >= window.getStartPosition() + window.getNumRows()) {
                    window.clear();
                }
                this.mCursor.fillWindow(position, window);
            }
            if (window != null) {
                window.acquireReference();
            }
            return window;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$onMove(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.mCursor.onMove(this.mCursor.getPosition(), position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$deactivate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCursor != null) {
                this.unregisterObserverProxyLocked();
                this.mCursor.deactivate();
            }
            this.closeFilledWindowLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$close() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_CursorToBulkCursorAdaptor$requery(IContentObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.closeFilledWindowLocked();
            try {
                if (!this.mCursor.requery()) {
                    return -1;
                }
            }
            catch (IllegalStateException e) {
                IllegalStateException leakProgram = new IllegalStateException(this.mProviderName + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), e);
                throw leakProgram;
            }
            this.unregisterObserverProxyLocked();
            this.createAndRegisterObserverProxyLocked(observer);
            return this.mCursor.getCount();
        }
    }

    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$createAndRegisterObserverProxyLocked(IContentObserver observer) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(observer, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    private final void $$robo$$android_database_CursorToBulkCursorAdaptor$unregisterObserverProxyLocked() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle $$robo$$android_database_CursorToBulkCursorAdaptor$getExtras() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getExtras();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle $$robo$$android_database_CursorToBulkCursorAdaptor$respond(Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.respond(extras);
        }
    }

    private void __constructor__(Cursor cursor, IContentObserver iContentObserver, String string2) {
        this.$$robo$$android_database_CursorToBulkCursorAdaptor$__constructor__(cursor, iContentObserver, string2);
    }

    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver iContentObserver, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorToBulkCursorAdaptor$__constructor__(android.database.Cursor android.database.IContentObserver java.lang.String ), 0, this, cursor, iContentObserver, string2);
    }

    private void closeFilledWindowLocked() {
        InvokeDynamicSupport.bootstrap("closeFilledWindowLocked", $$robo$$android_database_CursorToBulkCursorAdaptor$closeFilledWindowLocked(), 0, this);
    }

    private void disposeLocked() {
        InvokeDynamicSupport.bootstrap("disposeLocked", $$robo$$android_database_CursorToBulkCursorAdaptor$disposeLocked(), 0, this);
    }

    private void throwIfCursorIsClosed() {
        InvokeDynamicSupport.bootstrap("throwIfCursorIsClosed", $$robo$$android_database_CursorToBulkCursorAdaptor$throwIfCursorIsClosed(), 0, this);
    }

    @Override
    public void binderDied() {
        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_database_CursorToBulkCursorAdaptor$binderDied(), 0, this);
    }

    public BulkCursorDescriptor getBulkCursorDescriptor() {
        return InvokeDynamicSupport.bootstrap("getBulkCursorDescriptor", $$robo$$android_database_CursorToBulkCursorAdaptor$getBulkCursorDescriptor(), 0, this);
    }

    @Override
    public CursorWindow getWindow(int n) {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_database_CursorToBulkCursorAdaptor$getWindow(int ), 0, this, n);
    }

    @Override
    public void onMove(int n) {
        InvokeDynamicSupport.bootstrap("onMove", $$robo$$android_database_CursorToBulkCursorAdaptor$onMove(int ), 0, this, n);
    }

    @Override
    public void deactivate() {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$android_database_CursorToBulkCursorAdaptor$deactivate(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_CursorToBulkCursorAdaptor$close(), 0, this);
    }

    @Override
    public int requery(IContentObserver iContentObserver) {
        return (int)InvokeDynamicSupport.bootstrap("requery", $$robo$$android_database_CursorToBulkCursorAdaptor$requery(android.database.IContentObserver ), 0, this, iContentObserver);
    }

    private void createAndRegisterObserverProxyLocked(IContentObserver iContentObserver) {
        InvokeDynamicSupport.bootstrap("createAndRegisterObserverProxyLocked", $$robo$$android_database_CursorToBulkCursorAdaptor$createAndRegisterObserverProxyLocked(android.database.IContentObserver ), 0, this, iContentObserver);
    }

    private void unregisterObserverProxyLocked() {
        InvokeDynamicSupport.bootstrap("unregisterObserverProxyLocked", $$robo$$android_database_CursorToBulkCursorAdaptor$unregisterObserverProxyLocked(), 0, this);
    }

    @Override
    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_database_CursorToBulkCursorAdaptor$getExtras(), 0, this);
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("respond", $$robo$$android_database_CursorToBulkCursorAdaptor$respond(android.os.Bundle ), 0, this, bundle);
    }

    public /* synthetic */ CursorToBulkCursorAdaptor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorToBulkCursorAdaptor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ContentObserverProxy
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected IContentObserver mRemote;

        private void $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$__constructor__(IContentObserver remoteObserver, IBinder.DeathRecipient recipient) {
            this.mRemote = remoteObserver;
            try {
                remoteObserver.asBinder().linkToDeath(recipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final boolean $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$unlinkToDeath(IBinder.DeathRecipient recipient) {
            return this.mRemote.asBinder().unlinkToDeath(recipient, 0);
        }

        private final boolean $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$deliverSelfNotifications() {
            return false;
        }

        private final void $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$onChange(boolean selfChange, Uri uri) {
            try {
                this.mRemote.onChange(selfChange, uri, Process.myUid());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private void __constructor__(IContentObserver iContentObserver, IBinder.DeathRecipient deathRecipient) {
            this.$$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$__constructor__(iContentObserver, deathRecipient);
        }

        public ContentObserverProxy(IContentObserver iContentObserver, IBinder.DeathRecipient deathRecipient) {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$__constructor__(android.database.IContentObserver android.os.IBinder$DeathRecipient ), 0, this, iContentObserver, deathRecipient);
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient) {
            return (boolean)InvokeDynamicSupport.bootstrap("unlinkToDeath", $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$unlinkToDeath(android.os.IBinder$DeathRecipient ), 0, this, deathRecipient);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return (boolean)InvokeDynamicSupport.bootstrap("deliverSelfNotifications", $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$deliverSelfNotifications(), 0, this);
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_database_CursorToBulkCursorAdaptor_ContentObserverProxy$onChange(boolean android.net.Uri ), 0, this, bl, uri);
        }

        public /* synthetic */ ContentObserverProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentObserverProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

