/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.util.Log;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilterFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static FilterFactory mSharedFactory;
    private HashSet<String> mPackages;
    private static ClassLoader mCurrentClassLoader;
    private static HashSet<String> mLibraries;
    private static Object mClassLoaderGuard;
    private static String TAG = "FilterFactory";
    private static boolean mLogVerbose;

    private void $$robo$$android_filterfw_core_FilterFactory$__constructor__() {
        this.mPackages = new HashSet();
    }

    private static final FilterFactory $$robo$$android_filterfw_core_FilterFactory$sharedFactory() {
        if (mSharedFactory == null) {
            mSharedFactory = new FilterFactory();
        }
        return mSharedFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_filterfw_core_FilterFactory$addFilterLibrary(String libraryPath) {
        if (mLogVerbose) {
            Log.v("FilterFactory", "Adding filter library " + libraryPath);
        }
        Object object = mClassLoaderGuard;
        synchronized (object) {
            if (mLibraries.contains(libraryPath)) {
                if (mLogVerbose) {
                    Log.v("FilterFactory", "Library already added");
                }
                return;
            }
            mLibraries.add(libraryPath);
            mCurrentClassLoader = new PathClassLoader(libraryPath, mCurrentClassLoader);
        }
    }

    private final void $$robo$$android_filterfw_core_FilterFactory$addPackage(String packageName) {
        if (mLogVerbose) {
            Log.v("FilterFactory", "Adding package " + packageName);
        }
        this.mPackages.add(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Filter $$robo$$android_filterfw_core_FilterFactory$createFilterByClassName(String className, String filterName) {
        if (mLogVerbose) {
            Log.v("FilterFactory", "Looking up class " + className);
        }
        Class<?> filterClass = null;
        for (String packageName : this.mPackages) {
            try {
                if (mLogVerbose) {
                    Log.v("FilterFactory", "Trying " + packageName + "." + className);
                }
                Object object = mClassLoaderGuard;
                synchronized (object) {
                    filterClass = mCurrentClassLoader.loadClass(packageName + "." + className);
                }
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (filterClass == null) continue;
            break;
        }
        if (filterClass == null) {
            throw new IllegalArgumentException("Unknown filter class '" + className + "'!");
        }
        return this.createFilterByClass(filterClass, filterName);
    }

    private final Filter $$robo$$android_filterfw_core_FilterFactory$createFilterByClass(Class filterClass, String filterName) {
        try {
            filterClass.asSubclass(Filter.class);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Attempting to allocate class '" + filterClass + "' which is not a subclass of Filter!");
        }
        Constructor filterConstructor = null;
        try {
            filterConstructor = filterClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The filter class '" + filterClass + "' does not have a constructor of the form <init>(String name)!");
        }
        Filter filter = null;
        try {
            filter = (Filter)filterConstructor.newInstance(filterName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (filter == null) {
            throw new IllegalArgumentException("Could not construct the filter '" + filterName + "'!");
        }
        return filter;
    }

    static void __staticInitializer__() {
        mCurrentClassLoader = Thread.currentThread().getContextClassLoader();
        mLibraries = new HashSet();
        mClassLoaderGuard = new Object();
        mLogVerbose = Log.isLoggable("FilterFactory", 2);
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_core_FilterFactory$__constructor__();
    }

    public FilterFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FilterFactory$__constructor__(), 0, this);
    }

    public static FilterFactory sharedFactory() {
        return InvokeDynamicSupport.bootstrapStatic("sharedFactory", $$robo$$android_filterfw_core_FilterFactory$sharedFactory(), 0);
    }

    public static void addFilterLibrary(String string2) {
        InvokeDynamicSupport.bootstrapStatic("addFilterLibrary", $$robo$$android_filterfw_core_FilterFactory$addFilterLibrary(java.lang.String ), 0, (String)string2);
    }

    public void addPackage(String string2) {
        InvokeDynamicSupport.bootstrap("addPackage", $$robo$$android_filterfw_core_FilterFactory$addPackage(java.lang.String ), 0, this, string2);
    }

    public Filter createFilterByClassName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("createFilterByClassName", $$robo$$android_filterfw_core_FilterFactory$createFilterByClassName(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public Filter createFilterByClass(Class clazz, String string2) {
        return InvokeDynamicSupport.bootstrap("createFilterByClass", $$robo$$android_filterfw_core_FilterFactory$createFilterByClass(java.lang.Class java.lang.String ), 0, this, clazz, string2);
    }

    static {
        RobolectricInternals.classInitializing(FilterFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

