/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ColorTemperatureFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="scale", hasDefault=true)
    private float mScale;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    private Program mProgram;
    private int mTarget;
    private String mColorTemperatureShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float scale;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec3 new_color = color.rgb;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scale;\n  new_color.b = color.b - color.b * ( 1.0 - color.b) * scale;\n  if (scale > 0.0) { \n    new_color.g = color.g + color.g * ( 1.0 - color.g) * scale * 0.25;\n  }\n  float max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  gl_FragColor = vec4(new_color, color.a);\n}\n";

    private void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$__constructor__(String name) {
        this.mScale = 0.5f;
        this.mTileSize = 640;
        this.mTarget = 0;
        this.mColorTemperatureShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float scale;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec3 new_color = color.rgb;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scale;\n  new_color.b = color.b - color.b * ( 1.0 - color.b) * scale;\n  if (scale > 0.0) { \n    new_color.g = color.g + color.g * ( 1.0 - color.g) * scale * 0.25;\n  }\n  float max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  gl_FragColor = vec4(new_color, color.a);\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float scale;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  vec3 new_color = color.rgb;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scale;\n  new_color.b = color.b - color.b * ( 1.0 - color.b) * scale;\n  if (scale > 0.0) { \n    new_color.g = color.g + color.g * ( 1.0 - color.g) * scale * 0.25;\n  }\n  float max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  gl_FragColor = vec4(new_color, color.a);\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
            this.updateParameters();
        }
        Frame output = context.getFrameManager().newFrame(inputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$updateParameters() {
        this.mProgram.setHostValue("scale", Float.valueOf(2.0f * this.mScale - 1.0f));
    }

    private final void $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$__constructor__(string2);
    }

    public ColorTemperatureFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$initProgram(android.filterfw.core.FilterContext int ), 0, this, filterContext, n);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private void updateParameters() {
        InvokeDynamicSupport.bootstrap("updateParameters", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$updateParameters(), 0, this);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_imageproc_ColorTemperatureFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), 0, this, string2, filterContext);
    }

    public /* synthetic */ ColorTemperatureFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorTemperatureFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

