/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.Color;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DuotoneFilter
extends Filter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @GenerateFieldPort(name="first_color", hasDefault=true)
    private int mFirstColor;
    @GenerateFieldPort(name="second_color", hasDefault=true)
    private int mSecondColor;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize;
    private Program mProgram;
    private int mTarget;
    private String mDuotoneShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec3 first;\nuniform vec3 second;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float energy = (color.r + color.g + color.b) * 0.3333;\n  vec3 new_color = (1.0 - energy) * first + energy * second;\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n";

    private void $$robo$$android_filterpacks_imageproc_DuotoneFilter$__constructor__(String name) {
        this.mFirstColor = -65536;
        this.mSecondColor = -256;
        this.mTileSize = 640;
        this.mTarget = 0;
        this.mDuotoneShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec3 first;\nuniform vec3 second;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float energy = (color.r + color.g + color.b) * 0.3333;\n  vec3 new_color = (1.0 - energy) * first + energy * second;\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n";
    }

    private final void $$robo$$android_filterpacks_imageproc_DuotoneFilter$setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    private final FrameFormat $$robo$$android_filterpacks_imageproc_DuotoneFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    private final void $$robo$$android_filterpacks_imageproc_DuotoneFilter$initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform vec3 first;\nuniform vec3 second;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  float energy = (color.r + color.g + color.b) * 0.3333;\n  vec3 new_color = (1.0 - energy) * first + energy * second;\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Duotone does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private final void $$robo$$android_filterpacks_imageproc_DuotoneFilter$process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        Frame output = context.getFrameManager().newFrame(inputFormat);
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        this.updateParameters();
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }

    private final void $$robo$$android_filterpacks_imageproc_DuotoneFilter$updateParameters() {
        float[] first = new float[]{(float)Color.red(this.mFirstColor) / 255.0f, (float)Color.green(this.mFirstColor) / 255.0f, (float)Color.blue(this.mFirstColor) / 255.0f};
        float[] second = new float[]{(float)Color.red(this.mSecondColor) / 255.0f, (float)Color.green(this.mSecondColor) / 255.0f, (float)Color.blue(this.mSecondColor) / 255.0f};
        this.mProgram.setHostValue("first", first);
        this.mProgram.setHostValue("second", second);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_imageproc_DuotoneFilter$__constructor__(string2);
    }

    public DuotoneFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_imageproc_DuotoneFilter$__constructor__(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_imageproc_DuotoneFilter$setupPorts(), 0, this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_imageproc_DuotoneFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), 0, this, string2, frameFormat);
    }

    public void initProgram(FilterContext filterContext, int n) {
        InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_filterpacks_imageproc_DuotoneFilter$initProgram(android.filterfw.core.FilterContext int ), 0, this, filterContext, n);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_imageproc_DuotoneFilter$process(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private void updateParameters() {
        InvokeDynamicSupport.bootstrap("updateParameters", $$robo$$android_filterpacks_imageproc_DuotoneFilter$updateParameters(), 0, this);
    }

    public /* synthetic */ DuotoneFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DuotoneFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

