/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GesturePoint;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GestureStroke
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static float TOUCH_TOLERANCE = 3.0f;
    public RectF boundingBox;
    public float length;
    public float[] points;
    private long[] timestamps;
    private Path mCachedPath;

    private void $$robo$$android_gesture_GestureStroke$__constructor__(ArrayList<GesturePoint> points) {
        int count = points.size();
        float[] tmpPoints = new float[count * 2];
        long[] times = new long[count];
        RectF bx = null;
        float len = 0.0f;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            GesturePoint p = points.get(i);
            tmpPoints[i * 2] = p.x;
            tmpPoints[i * 2 + 1] = p.y;
            times[index] = p.timestamp;
            if (bx == null) {
                bx = new RectF();
                bx.top = p.y;
                bx.left = p.x;
                bx.right = p.x;
                bx.bottom = p.y;
                len = 0.0f;
            } else {
                len = (float)((double)len + Math.hypot(p.x - tmpPoints[(i - 1) * 2], p.y - tmpPoints[(i - 1) * 2 + 1]));
                bx.union(p.x, p.y);
            }
            ++index;
        }
        this.timestamps = times;
        this.points = tmpPoints;
        this.boundingBox = bx;
        this.length = len;
    }

    private void $$robo$$android_gesture_GestureStroke$__constructor__(RectF bbx, float len, float[] pts, long[] times) {
        this.boundingBox = new RectF(bbx.left, bbx.top, bbx.right, bbx.bottom);
        this.length = len;
        this.points = (float[])pts.clone();
        this.timestamps = (long[])times.clone();
    }

    private final Object $$robo$$android_gesture_GestureStroke$clone() {
        return new GestureStroke(this.boundingBox, this.length, this.points, this.timestamps);
    }

    private final void $$robo$$android_gesture_GestureStroke$draw(Canvas canvas, Paint paint) {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        canvas.drawPath(this.mCachedPath, paint);
    }

    private final Path $$robo$$android_gesture_GestureStroke$getPath() {
        if (this.mCachedPath == null) {
            this.makePath();
        }
        return this.mCachedPath;
    }

    private final void $$robo$$android_gesture_GestureStroke$makePath() {
        float[] localPoints = this.points;
        int count = localPoints.length;
        Path path = null;
        float mX = 0.0f;
        float mY = 0.0f;
        for (int i = 0; i < count; i += 2) {
            float x = localPoints[i];
            float y = localPoints[i + 1];
            if (path == null) {
                path = new Path();
                path.moveTo(x, y);
                mX = x;
                mY = y;
                continue;
            }
            float dx = Math.abs(x - mX);
            float dy = Math.abs(y - mY);
            if (!(dx >= 3.0f) && !(dy >= 3.0f)) continue;
            path.quadTo(mX, mY, (x + mX) / 2.0f, (y + mY) / 2.0f);
            mX = x;
            mY = y;
        }
        this.mCachedPath = path;
    }

    private final Path $$robo$$android_gesture_GestureStroke$toPath(float width, float height, int numSample) {
        float[] pts = GestureUtils.temporalSampling(this, numSample);
        RectF rect = this.boundingBox;
        GestureUtils.translate(pts, -rect.left, -rect.top);
        float sx = width / rect.width();
        float sy = height / rect.height();
        float scale = sx > sy ? sy : sx;
        GestureUtils.scale(pts, scale, scale);
        float mX = 0.0f;
        float mY = 0.0f;
        Path path = null;
        int count = pts.length;
        for (int i = 0; i < count; i += 2) {
            float x = pts[i];
            float y = pts[i + 1];
            if (path == null) {
                path = new Path();
                path.moveTo(x, y);
                mX = x;
                mY = y;
                continue;
            }
            float dx = Math.abs(x - mX);
            float dy = Math.abs(y - mY);
            if (!(dx >= 3.0f) && !(dy >= 3.0f)) continue;
            path.quadTo(mX, mY, (x + mX) / 2.0f, (y + mY) / 2.0f);
            mX = x;
            mY = y;
        }
        return path;
    }

    private final void $$robo$$android_gesture_GestureStroke$serialize(DataOutputStream out) throws IOException {
        float[] pts = this.points;
        long[] times = this.timestamps;
        int count = this.points.length;
        out.writeInt(count / 2);
        for (int i = 0; i < count; i += 2) {
            out.writeFloat(pts[i]);
            out.writeFloat(pts[i + 1]);
            out.writeLong(times[i / 2]);
        }
    }

    private static final GestureStroke $$robo$$android_gesture_GestureStroke$deserialize(DataInputStream in) throws IOException {
        int count = in.readInt();
        ArrayList<GesturePoint> points = new ArrayList<GesturePoint>(count);
        for (int i = 0; i < count; ++i) {
            points.add(GesturePoint.deserialize(in));
        }
        return new GestureStroke(points);
    }

    private final void $$robo$$android_gesture_GestureStroke$clearPath() {
        if (this.mCachedPath != null) {
            this.mCachedPath.rewind();
        }
    }

    private final OrientedBoundingBox $$robo$$android_gesture_GestureStroke$computeOrientedBoundingBox() {
        return GestureUtils.computeOrientedBoundingBox(this.points);
    }

    private void __constructor__(ArrayList<GesturePoint> arrayList) {
        this.$$robo$$android_gesture_GestureStroke$__constructor__(arrayList);
    }

    public GestureStroke(ArrayList<GesturePoint> arrayList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureStroke$__constructor__(java.util.ArrayList<android.gesture.GesturePoint> ), 0, this, arrayList);
    }

    private void __constructor__(RectF rectF, float f, float[] fArray, long[] lArray) {
        this.$$robo$$android_gesture_GestureStroke$__constructor__(rectF, f, fArray, lArray);
    }

    private GestureStroke(RectF rectF, float f, float[] fArray, long[] lArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_gesture_GestureStroke$__constructor__(android.graphics.RectF float float[] long[] ), 0, this, rectF, f, fArray, lArray);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_gesture_GestureStroke$clone(), 0, this);
    }

    void draw(Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_gesture_GestureStroke$draw(android.graphics.Canvas android.graphics.Paint ), 0, this, canvas, paint);
    }

    public Path getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_gesture_GestureStroke$getPath(), 0, this);
    }

    private void makePath() {
        InvokeDynamicSupport.bootstrap("makePath", $$robo$$android_gesture_GestureStroke$makePath(), 0, this);
    }

    public Path toPath(float f, float f2, int n) {
        return InvokeDynamicSupport.bootstrap("toPath", $$robo$$android_gesture_GestureStroke$toPath(float float int ), 0, this, f, f2, n);
    }

    void serialize(DataOutputStream dataOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("serialize", $$robo$$android_gesture_GestureStroke$serialize(java.io.DataOutputStream ), 0, this, dataOutputStream);
    }

    static GestureStroke deserialize(DataInputStream dataInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("deserialize", $$robo$$android_gesture_GestureStroke$deserialize(java.io.DataInputStream ), 0, (DataInputStream)dataInputStream);
    }

    public void clearPath() {
        InvokeDynamicSupport.bootstrap("clearPath", $$robo$$android_gesture_GestureStroke$clearPath(), 0, this);
    }

    public OrientedBoundingBox computeOrientedBoundingBox() {
        return InvokeDynamicSupport.bootstrap("computeOrientedBoundingBox", $$robo$$android_gesture_GestureStroke$computeOrientedBoundingBox(), 0, this);
    }

    public /* synthetic */ GestureStroke() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GestureStroke)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

