/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import com.android.internal.util.XmlUtils;
import java.util.HashMap;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Color
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int BLACK = -16777216;
    public static int DKGRAY = -12303292;
    public static int GRAY = -7829368;
    public static int LTGRAY = -3355444;
    public static int WHITE = -1;
    public static int RED = -65536;
    public static int GREEN = -16711936;
    public static int BLUE = -16776961;
    public static int YELLOW = -256;
    public static int CYAN = -16711681;
    public static int MAGENTA = -65281;
    public static int TRANSPARENT = 0;
    private static HashMap<String, Integer> sColorNameMap;

    private void $$robo$$android_graphics_Color$__constructor__() {
    }

    private static final int $$robo$$android_graphics_Color$alpha(int color2) {
        return color2 >>> 24;
    }

    private static final int $$robo$$android_graphics_Color$red(int color2) {
        return color2 >> 16 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$green(int color2) {
        return color2 >> 8 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$blue(int color2) {
        return color2 & 0xFF;
    }

    private static final int $$robo$$android_graphics_Color$rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static final int $$robo$$android_graphics_Color$argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static final float $$robo$$android_graphics_Color$luminance(int color2) {
        double red = (double)Color.red(color2) / 255.0;
        red = red < 0.03928 ? red / 12.92 : Math.pow((red + 0.055) / 1.055, 2.4);
        double green = (double)Color.green(color2) / 255.0;
        green = green < 0.03928 ? green / 12.92 : Math.pow((green + 0.055) / 1.055, 2.4);
        double blue = (double)Color.blue(color2) / 255.0;
        blue = blue < 0.03928 ? blue / 12.92 : Math.pow((blue + 0.055) / 1.055, 2.4);
        return (float)(0.2126 * red + 0.7152 * green + 0.0722 * blue);
    }

    private static final int $$robo$$android_graphics_Color$parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color2;
        }
        Integer color3 = sColorNameMap.get(colorString.toLowerCase(Locale.ROOT));
        if (color3 != null) {
            return color3;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    private static final void $$robo$$android_graphics_Color$RGBToHSV(int red, int green, int blue, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(red, green, blue, hsv);
    }

    private static final void $$robo$$android_graphics_Color$colorToHSV(int color2, float[] hsv) {
        Color.RGBToHSV(color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, hsv);
    }

    private static final int $$robo$$android_graphics_Color$HSVToColor(float[] hsv) {
        return Color.HSVToColor(255, hsv);
    }

    private static final int $$robo$$android_graphics_Color$HSVToColor(int alpha, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(alpha, hsv);
    }

    private static final void $$robo$$android_graphics_Color$nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
    }

    private static final int $$robo$$android_graphics_Color$nativeHSVToColor(int n, float[] fArray) {
        return 0;
    }

    private static final int $$robo$$android_graphics_Color$getHtmlColor(String color2) {
        Integer i = sColorNameMap.get(color2.toLowerCase(Locale.ROOT));
        if (i != null) {
            return i;
        }
        try {
            return XmlUtils.convertValueToInt(color2, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    static void __staticInitializer__() {
        sColorNameMap = new HashMap();
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Color$__constructor__();
    }

    public Color() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Color$__constructor__(), 0, this);
    }

    public static int alpha(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("alpha", $$robo$$android_graphics_Color$alpha(int ), 0, (int)n);
    }

    public static int red(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("red", $$robo$$android_graphics_Color$red(int ), 0, (int)n);
    }

    public static int green(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("green", $$robo$$android_graphics_Color$green(int ), 0, (int)n);
    }

    public static int blue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("blue", $$robo$$android_graphics_Color$blue(int ), 0, (int)n);
    }

    public static int rgb(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rgb", $$robo$$android_graphics_Color$rgb(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public static int argb(int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("argb", $$robo$$android_graphics_Color$argb(int int int int ), 0, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public static float luminance(int n) {
        return (float)InvokeDynamicSupport.bootstrapStatic("luminance", $$robo$$android_graphics_Color$luminance(int ), 0, (int)n);
    }

    public static int parseColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseColor", $$robo$$android_graphics_Color$parseColor(java.lang.String ), 0, (String)string2);
    }

    public static void RGBToHSV(int n, int n2, int n3, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("RGBToHSV", $$robo$$android_graphics_Color$RGBToHSV(int int int float[] ), 0, (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    public static void colorToHSV(int n, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("colorToHSV", $$robo$$android_graphics_Color$colorToHSV(int float[] ), 0, (int)n, (float[])fArray);
    }

    public static int HSVToColor(float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("HSVToColor", $$robo$$android_graphics_Color$HSVToColor(float[] ), 0, (float[])fArray);
    }

    public static int HSVToColor(int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("HSVToColor", $$robo$$android_graphics_Color$HSVToColor(int float[] ), 0, (int)n, (float[])fArray);
    }

    private static final native /* synthetic */ void $$robo$$nativeRGBToHSV$nativeBinding(int var0, int var1, int var2, float[] var3);

    private static void nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("nativeRGBToHSV", $$robo$$android_graphics_Color$nativeRGBToHSV(int int int float[] ), 1, (int)n, (int)n2, (int)n3, (float[])fArray);
    }

    private static final native /* synthetic */ int $$robo$$nativeHSVToColor$nativeBinding(int var0, float[] var1);

    private static int nativeHSVToColor(int n, float[] fArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeHSVToColor", $$robo$$android_graphics_Color$nativeHSVToColor(int float[] ), 1, (int)n, (float[])fArray);
    }

    public static int getHtmlColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHtmlColor", $$robo$$android_graphics_Color$getHtmlColor(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Color.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Color)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

