/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class Outline
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float RADIUS_UNDEFINED = Float.NEGATIVE_INFINITY;
    public static int MODE_EMPTY = 0;
    public static int MODE_ROUND_RECT = 1;
    public static int MODE_CONVEX_PATH = 2;
    public int mMode;
    public Path mPath;
    public Rect mRect;
    public float mRadius;
    public float mAlpha;

    private void $$robo$$android_graphics_Outline$__constructor__() {
        this.mMode = 0;
        this.mPath = new Path();
        this.mRect = new Rect();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    private void $$robo$$android_graphics_Outline$__constructor__(Outline src) {
        this.mMode = 0;
        this.mPath = new Path();
        this.mRect = new Rect();
        this.mRadius = Float.NEGATIVE_INFINITY;
        this.set(src);
    }

    private final void $$robo$$android_graphics_Outline$setEmpty() {
        this.mMode = 0;
        this.mPath.rewind();
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    private final boolean $$robo$$android_graphics_Outline$isEmpty() {
        return this.mMode == 0;
    }

    private final boolean $$robo$$android_graphics_Outline$canClip() {
        return this.mMode != 2;
    }

    private final void $$robo$$android_graphics_Outline$setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    private final float $$robo$$android_graphics_Outline$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$android_graphics_Outline$set(Outline src) {
        this.mMode = src.mMode;
        this.mPath.set(src.mPath);
        this.mRect.set(src.mRect);
        this.mRadius = src.mRadius;
        this.mAlpha = src.mAlpha;
    }

    private final void $$robo$$android_graphics_Outline$setRect(int left, int top, int right, int bottom) {
        this.setRoundRect(left, top, right, bottom, 0.0f);
    }

    private final void $$robo$$android_graphics_Outline$setRect(Rect rect) {
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    private final void $$robo$$android_graphics_Outline$setRoundRect(int left, int top, int right, int bottom, float radius) {
        if (left >= right || top >= bottom) {
            this.setEmpty();
            return;
        }
        this.mMode = 1;
        this.mRect.set(left, top, right, bottom);
        this.mRadius = radius;
        this.mPath.rewind();
    }

    private final void $$robo$$android_graphics_Outline$setRoundRect(Rect rect, float radius) {
        this.setRoundRect(rect.left, rect.top, rect.right, rect.bottom, radius);
    }

    private final boolean $$robo$$android_graphics_Outline$getRect(Rect outRect) {
        if (this.mMode != 1) {
            return false;
        }
        outRect.set(this.mRect);
        return true;
    }

    private final float $$robo$$android_graphics_Outline$getRadius() {
        return this.mRadius;
    }

    private final void $$robo$$android_graphics_Outline$setOval(int left, int top, int right, int bottom) {
        if (left >= right || top >= bottom) {
            this.setEmpty();
            return;
        }
        if (bottom - top == right - left) {
            this.setRoundRect(left, top, right, bottom, (float)(bottom - top) / 2.0f);
            return;
        }
        this.mMode = 2;
        this.mPath.rewind();
        this.mPath.addOval(left, top, right, bottom, Path.Direction.CW);
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    private final void $$robo$$android_graphics_Outline$setOval(Rect rect) {
        this.setOval(rect.left, rect.top, rect.right, rect.bottom);
    }

    private final void $$robo$$android_graphics_Outline$setConvexPath(Path convexPath) {
        if (convexPath.isEmpty()) {
            this.setEmpty();
            return;
        }
        if (!convexPath.isConvex()) {
            throw new IllegalArgumentException("path must be convex");
        }
        this.mMode = 2;
        this.mPath.set(convexPath);
        this.mRect.setEmpty();
        this.mRadius = Float.NEGATIVE_INFINITY;
    }

    private final void $$robo$$android_graphics_Outline$offset(int dx, int dy) {
        if (this.mMode == 1) {
            this.mRect.offset(dx, dy);
        } else if (this.mMode == 2) {
            this.mPath.offset(dx, dy);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Outline$__constructor__();
    }

    public Outline() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Outline$__constructor__(), 0, this);
    }

    private void __constructor__(Outline outline) {
        this.$$robo$$android_graphics_Outline$__constructor__(outline);
    }

    public Outline(Outline outline) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Outline$__constructor__(android.graphics.Outline ), 0, this, outline);
    }

    public void setEmpty() {
        InvokeDynamicSupport.bootstrap("setEmpty", $$robo$$android_graphics_Outline$setEmpty(), 0, this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_graphics_Outline$isEmpty(), 0, this);
    }

    public boolean canClip() {
        return (boolean)InvokeDynamicSupport.bootstrap("canClip", $$robo$$android_graphics_Outline$canClip(), 0, this);
    }

    public void setAlpha(float f) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_Outline$setAlpha(float ), 0, this, f);
    }

    public float getAlpha() {
        return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_Outline$getAlpha(), 0, this);
    }

    public void set(Outline outline) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_graphics_Outline$set(android.graphics.Outline ), 0, this, outline);
    }

    public void setRect(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setRect", $$robo$$android_graphics_Outline$setRect(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("setRect", $$robo$$android_graphics_Outline$setRect(android.graphics.Rect ), 0, this, rect);
    }

    public void setRoundRect(int n, int n2, int n3, int n4, float f) {
        InvokeDynamicSupport.bootstrap("setRoundRect", $$robo$$android_graphics_Outline$setRoundRect(int int int int float ), 0, this, n, n2, n3, n4, f);
    }

    public void setRoundRect(Rect rect, float f) {
        InvokeDynamicSupport.bootstrap("setRoundRect", $$robo$$android_graphics_Outline$setRoundRect(android.graphics.Rect float ), 0, this, rect, f);
    }

    public boolean getRect(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getRect", $$robo$$android_graphics_Outline$getRect(android.graphics.Rect ), 0, this, rect);
    }

    public float getRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getRadius", $$robo$$android_graphics_Outline$getRadius(), 0, this);
    }

    public void setOval(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setOval", $$robo$$android_graphics_Outline$setOval(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setOval(Rect rect) {
        InvokeDynamicSupport.bootstrap("setOval", $$robo$$android_graphics_Outline$setOval(android.graphics.Rect ), 0, this, rect);
    }

    public void setConvexPath(Path path) {
        InvokeDynamicSupport.bootstrap("setConvexPath", $$robo$$android_graphics_Outline$setConvexPath(android.graphics.Path ), 0, this, path);
    }

    public void offset(int n, int n2) {
        InvokeDynamicSupport.bootstrap("offset", $$robo$$android_graphics_Outline$offset(int int ), 0, this, n, n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Outline)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

