/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.SparseArray;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DrawableContainer
extends Drawable
implements Drawable.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "DrawableContainer";
    private static boolean DEFAULT_DITHER = true;
    private DrawableContainerState mDrawableContainerState;
    private Rect mHotspotBounds;
    private Drawable mCurrDrawable;
    private Drawable mLastDrawable;
    private int mAlpha;
    private boolean mHasAlpha;
    private int mCurIndex;
    private int mLastIndex;
    private boolean mMutated;
    private Runnable mAnimationRunnable;
    private long mEnterAnimationEnd;
    private long mExitAnimationEnd;
    private BlockInvalidateCallback mBlockInvalidateCallback;

    private void $$robo$$android_graphics_drawable_DrawableContainer$__constructor__() {
        this.mAlpha = 255;
        this.mCurIndex = -1;
        this.mLastIndex = -1;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$draw(Canvas canvas) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.draw(canvas);
        }
        if (this.mLastDrawable != null) {
            this.mLastDrawable.draw(canvas);
        }
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mDrawableContainerState.getChangingConfigurations();
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$needsMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$getPadding(Rect padding) {
        boolean result;
        Rect r = this.mDrawableContainerState.getConstantPadding();
        if (r != null) {
            padding.set(r);
            result = (r.left | r.top | r.bottom | r.right) != 0;
        } else {
            result = this.mCurrDrawable != null ? this.mCurrDrawable.getPadding(padding) : super.getPadding(padding);
        }
        if (this.needsMirroring()) {
            int right;
            int left = padding.left;
            padding.left = right = padding.right;
            padding.right = left;
        }
        return result;
    }

    private final Insets $$robo$$android_graphics_drawable_DrawableContainer$getOpticalInsets() {
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.getOpticalInsets();
        }
        return Insets.NONE;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$getOutline(Outline outline) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.getOutline(outline);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setAlpha(int alpha) {
        if (!this.mHasAlpha || this.mAlpha != alpha) {
            this.mHasAlpha = true;
            this.mAlpha = alpha;
            if (this.mCurrDrawable != null) {
                if (this.mEnterAnimationEnd == 0L) {
                    this.mCurrDrawable.setAlpha(alpha);
                } else {
                    this.animate(false);
                }
            }
        }
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getAlpha() {
        return this.mAlpha;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setDither(boolean dither) {
        if (this.mDrawableContainerState.mDither != dither) {
            this.mDrawableContainerState.mDither = dither;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setDither(this.mDrawableContainerState.mDither);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setColorFilter(ColorFilter colorFilter) {
        this.mDrawableContainerState.mHasColorFilter = true;
        if (this.mDrawableContainerState.mColorFilter != colorFilter) {
            this.mDrawableContainerState.mColorFilter = colorFilter;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setColorFilter(colorFilter);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setTintList(ColorStateList tint) {
        this.mDrawableContainerState.mHasTintList = true;
        if (this.mDrawableContainerState.mTintList != tint) {
            this.mDrawableContainerState.mTintList = tint;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setTintList(tint);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setTintMode(PorterDuff.Mode tintMode) {
        this.mDrawableContainerState.mHasTintMode = true;
        if (this.mDrawableContainerState.mTintMode != tintMode) {
            this.mDrawableContainerState.mTintMode = tintMode;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setTintMode(tintMode);
            }
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setEnterFadeDuration(int ms) {
        this.mDrawableContainerState.mEnterFadeDuration = ms;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setExitFadeDuration(int ms) {
        this.mDrawableContainerState.mExitFadeDuration = ms;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$onBoundsChange(Rect bounds) {
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setBounds(bounds);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setBounds(bounds);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$isStateful() {
        return this.mDrawableContainerState.isStateful();
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setAutoMirrored(boolean mirrored) {
        if (this.mDrawableContainerState.mAutoMirrored != mirrored) {
            this.mDrawableContainerState.mAutoMirrored = mirrored;
            if (this.mCurrDrawable != null) {
                this.mCurrDrawable.setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
            }
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$isAutoMirrored() {
        return this.mDrawableContainerState.mAutoMirrored;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$jumpToCurrentState() {
        boolean changed = false;
        if (this.mLastDrawable != null) {
            this.mLastDrawable.jumpToCurrentState();
            this.mLastDrawable = null;
            this.mLastIndex = -1;
            changed = true;
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.jumpToCurrentState();
            if (this.mHasAlpha) {
                this.mCurrDrawable.setAlpha(this.mAlpha);
            }
        }
        if (this.mExitAnimationEnd != 0L) {
            this.mExitAnimationEnd = 0L;
            changed = true;
        }
        if (this.mEnterAnimationEnd != 0L) {
            this.mEnterAnimationEnd = 0L;
            changed = true;
        }
        if (changed) {
            this.invalidateSelf();
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setHotspot(float x, float y) {
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspot(x, y);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setHotspotBounds(int left, int top, int right, int bottom) {
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setHotspotBounds(left, top, right, bottom);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$getHotspotBounds(Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$onStateChange(int[] state) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setState(state);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setState(state);
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$onLevelChange(int level) {
        if (this.mLastDrawable != null) {
            return this.mLastDrawable.setLevel(level);
        }
        if (this.mCurrDrawable != null) {
            return this.mCurrDrawable.setLevel(level);
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$onLayoutDirectionChanged(int layoutDirection) {
        return this.mDrawableContainerState.setLayoutDirection(layoutDirection, this.getCurrentIndex());
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getIntrinsicWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicWidth() : -1;
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getIntrinsicHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getIntrinsicHeight() : -1;
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getMinimumWidth() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumWidth();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumWidth() : 0;
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getMinimumHeight() {
        if (this.mDrawableContainerState.isConstantSize()) {
            return this.mDrawableContainerState.getConstantMinimumHeight();
        }
        return this.mCurrDrawable != null ? this.mCurrDrawable.getMinimumHeight() : 0;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$invalidateDrawable(Drawable who) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$scheduleDrawable(Drawable who, Runnable what, long when) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$unscheduleDrawable(Drawable who, Runnable what) {
        if (who == this.mCurrDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mLastDrawable != null) {
            this.mLastDrawable.setVisible(visible, restart);
        }
        if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getOpacity() {
        return this.mCurrDrawable == null || !this.mCurrDrawable.isVisible() ? -2 : this.mDrawableContainerState.getOpacity();
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setCurrentIndex(int index) {
        this.selectDrawable(index);
    }

    private final int $$robo$$android_graphics_drawable_DrawableContainer$getCurrentIndex() {
        return this.mCurIndex;
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$selectDrawable(int index) {
        if (index == this.mCurIndex) {
            return false;
        }
        long now = SystemClock.uptimeMillis();
        if (this.mDrawableContainerState.mExitFadeDuration > 0) {
            if (this.mLastDrawable != null) {
                this.mLastDrawable.setVisible(false, false);
            }
            if (this.mCurrDrawable != null) {
                this.mLastDrawable = this.mCurrDrawable;
                this.mLastIndex = this.mCurIndex;
                this.mExitAnimationEnd = now + (long)this.mDrawableContainerState.mExitFadeDuration;
            } else {
                this.mLastDrawable = null;
                this.mLastIndex = -1;
                this.mExitAnimationEnd = 0L;
            }
        } else if (this.mCurrDrawable != null) {
            this.mCurrDrawable.setVisible(false, false);
        }
        if (index >= 0 && index < this.mDrawableContainerState.mNumChildren) {
            Drawable d;
            this.mCurrDrawable = d = this.mDrawableContainerState.getChild(index);
            this.mCurIndex = index;
            if (d != null) {
                if (this.mDrawableContainerState.mEnterFadeDuration > 0) {
                    this.mEnterAnimationEnd = now + (long)this.mDrawableContainerState.mEnterFadeDuration;
                }
                this.initializeDrawableForDisplay(d);
            }
        } else {
            this.mCurrDrawable = null;
            this.mCurIndex = -1;
        }
        if (this.mEnterAnimationEnd != 0L || this.mExitAnimationEnd != 0L) {
            if (this.mAnimationRunnable == null) {
                this.mAnimationRunnable = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ DrawableContainer this$0;

                    private void $$robo$$android_graphics_drawable_DrawableContainer_1$__constructor__(DrawableContainer this$0) {
                    }

                    private final void $$robo$$android_graphics_drawable_DrawableContainer_1$run() {
                        this.this$0.animate(true);
                        this.this$0.invalidateSelf();
                    }

                    private void __constructor__(DrawableContainer drawableContainer) {
                        this.$$robo$$android_graphics_drawable_DrawableContainer_1$__constructor__(drawableContainer);
                    }
                    {
                        this.this$0 = drawableContainer;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableContainer_1$__constructor__(android.graphics.drawable.DrawableContainer ), 0, this, drawableContainer);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_graphics_drawable_DrawableContainer_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                this.unscheduleSelf(this.mAnimationRunnable);
            }
            this.animate(true);
        }
        this.invalidateSelf();
        return true;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$initializeDrawableForDisplay(Drawable d) {
        if (this.mBlockInvalidateCallback == null) {
            this.mBlockInvalidateCallback = new BlockInvalidateCallback();
        }
        d.setCallback(this.mBlockInvalidateCallback.wrap(d.getCallback()));
        try {
            if (this.mDrawableContainerState.mEnterFadeDuration <= 0 && this.mHasAlpha) {
                d.setAlpha(this.mAlpha);
            }
            if (this.mDrawableContainerState.mHasColorFilter) {
                d.setColorFilter(this.mDrawableContainerState.mColorFilter);
            } else {
                if (this.mDrawableContainerState.mHasTintList) {
                    d.setTintList(this.mDrawableContainerState.mTintList);
                }
                if (this.mDrawableContainerState.mHasTintMode) {
                    d.setTintMode(this.mDrawableContainerState.mTintMode);
                }
            }
            d.setVisible(this.isVisible(), true);
            d.setDither(this.mDrawableContainerState.mDither);
            d.setState(this.getState());
            d.setLevel(this.getLevel());
            d.setBounds(this.getBounds());
            d.setLayoutDirection(this.getLayoutDirection());
            d.setAutoMirrored(this.mDrawableContainerState.mAutoMirrored);
            Rect hotspotBounds = this.mHotspotBounds;
            if (hotspotBounds != null) {
                d.setHotspotBounds(hotspotBounds.left, hotspotBounds.top, hotspotBounds.right, hotspotBounds.bottom);
            }
        }
        finally {
            d.setCallback(this.mBlockInvalidateCallback.unwrap());
        }
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$animate(boolean schedule) {
        int animAlpha;
        this.mHasAlpha = true;
        long now = SystemClock.uptimeMillis();
        boolean animating = false;
        if (this.mCurrDrawable != null) {
            if (this.mEnterAnimationEnd != 0L) {
                if (this.mEnterAnimationEnd <= now) {
                    this.mCurrDrawable.setAlpha(this.mAlpha);
                    this.mEnterAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mEnterAnimationEnd - now) * 255L) / this.mDrawableContainerState.mEnterFadeDuration;
                    this.mCurrDrawable.setAlpha((255 - animAlpha) * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mEnterAnimationEnd = 0L;
        }
        if (this.mLastDrawable != null) {
            if (this.mExitAnimationEnd != 0L) {
                if (this.mExitAnimationEnd <= now) {
                    this.mLastDrawable.setVisible(false, false);
                    this.mLastDrawable = null;
                    this.mLastIndex = -1;
                    this.mExitAnimationEnd = 0L;
                } else {
                    animAlpha = (int)((this.mExitAnimationEnd - now) * 255L) / this.mDrawableContainerState.mExitFadeDuration;
                    this.mLastDrawable.setAlpha(animAlpha * this.mAlpha / 255);
                    animating = true;
                }
            }
        } else {
            this.mExitAnimationEnd = 0L;
        }
        if (schedule && animating) {
            this.scheduleSelf(this.mAnimationRunnable, now + 16L);
        }
    }

    private final Drawable $$robo$$android_graphics_drawable_DrawableContainer$getCurrent() {
        return this.mCurrDrawable;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$updateDensity(Resources res) {
        this.mDrawableContainerState.updateDensity(res);
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$applyTheme(Resources.Theme theme) {
        this.mDrawableContainerState.applyTheme(theme);
    }

    private final boolean $$robo$$android_graphics_drawable_DrawableContainer$canApplyTheme() {
        return this.mDrawableContainerState.canApplyTheme();
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_DrawableContainer$getConstantState() {
        if (this.mDrawableContainerState.canConstantState()) {
            this.mDrawableContainerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mDrawableContainerState;
        }
        return null;
    }

    private final Drawable $$robo$$android_graphics_drawable_DrawableContainer$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            DrawableContainerState clone = this.cloneConstantState();
            clone.mutate();
            this.setConstantState(clone);
            this.mMutated = true;
        }
        return this;
    }

    private final DrawableContainerState $$robo$$android_graphics_drawable_DrawableContainer$cloneConstantState() {
        return this.mDrawableContainerState;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$clearMutated() {
        super.clearMutated();
        this.mDrawableContainerState.clearMutated();
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_DrawableContainer$setConstantState(DrawableContainerState state) {
        this.mDrawableContainerState = state;
        if (this.mCurIndex >= 0) {
            this.mCurrDrawable = state.getChild(this.mCurIndex);
            if (this.mCurrDrawable != null) {
                this.initializeDrawableForDisplay(this.mCurrDrawable);
            }
        }
        this.mLastIndex = -1;
        this.mLastDrawable = null;
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_DrawableContainer$__constructor__();
    }

    public DrawableContainer() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableContainer$__constructor__(), 0, this);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_DrawableContainer$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_DrawableContainer$getChangingConfigurations(), 0, this);
    }

    private boolean needsMirroring() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsMirroring", $$robo$$android_graphics_drawable_DrawableContainer$needsMirroring(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_DrawableContainer$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public Insets getOpticalInsets() {
        return InvokeDynamicSupport.bootstrap("getOpticalInsets", $$robo$$android_graphics_drawable_DrawableContainer$getOpticalInsets(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_DrawableContainer$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_DrawableContainer$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_DrawableContainer$getAlpha(), 0, this);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_DrawableContainer$setDither(boolean ), 0, this, bl);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_DrawableContainer$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_DrawableContainer$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_DrawableContainer$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    public void setEnterFadeDuration(int n) {
        InvokeDynamicSupport.bootstrap("setEnterFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer$setEnterFadeDuration(int ), 0, this, n);
    }

    public void setExitFadeDuration(int n) {
        InvokeDynamicSupport.bootstrap("setExitFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer$setExitFadeDuration(int ), 0, this, n);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_DrawableContainer$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_DrawableContainer$isStateful(), 0, this);
    }

    @Override
    public void setAutoMirrored(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoMirrored", $$robo$$android_graphics_drawable_DrawableContainer$setAutoMirrored(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAutoMirrored() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAutoMirrored", $$robo$$android_graphics_drawable_DrawableContainer$isAutoMirrored(), 0, this);
    }

    @Override
    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_graphics_drawable_DrawableContainer$jumpToCurrentState(), 0, this);
    }

    @Override
    public void setHotspot(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setHotspot", $$robo$$android_graphics_drawable_DrawableContainer$setHotspot(float float ), 0, this, f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setHotspotBounds", $$robo$$android_graphics_drawable_DrawableContainer$setHotspotBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("getHotspotBounds", $$robo$$android_graphics_drawable_DrawableContainer$getHotspotBounds(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_DrawableContainer$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLevelChange", $$robo$$android_graphics_drawable_DrawableContainer$onLevelChange(int ), 0, this, n);
    }

    @Override
    public boolean onLayoutDirectionChanged(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLayoutDirectionChanged", $$robo$$android_graphics_drawable_DrawableContainer$onLayoutDirectionChanged(int ), 0, this, n);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_DrawableContainer$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_DrawableContainer$getIntrinsicHeight(), 0, this);
    }

    @Override
    public int getMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumWidth", $$robo$$android_graphics_drawable_DrawableContainer$getMinimumWidth(), 0, this);
    }

    @Override
    public int getMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$android_graphics_drawable_DrawableContainer$getMinimumHeight(), 0, this);
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_DrawableContainer$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_DrawableContainer$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_DrawableContainer$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVisible", $$robo$$android_graphics_drawable_DrawableContainer$setVisible(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_DrawableContainer$getOpacity(), 0, this);
    }

    public void setCurrentIndex(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentIndex", $$robo$$android_graphics_drawable_DrawableContainer$setCurrentIndex(int ), 0, this, n);
    }

    public int getCurrentIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentIndex", $$robo$$android_graphics_drawable_DrawableContainer$getCurrentIndex(), 0, this);
    }

    public boolean selectDrawable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("selectDrawable", $$robo$$android_graphics_drawable_DrawableContainer$selectDrawable(int ), 0, this, n);
    }

    private void initializeDrawableForDisplay(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("initializeDrawableForDisplay", $$robo$$android_graphics_drawable_DrawableContainer$initializeDrawableForDisplay(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    void animate(boolean bl) {
        InvokeDynamicSupport.bootstrap("animate", $$robo$$android_graphics_drawable_DrawableContainer$animate(boolean ), 0, this, bl);
    }

    @Override
    public Drawable getCurrent() {
        return InvokeDynamicSupport.bootstrap("getCurrent", $$robo$$android_graphics_drawable_DrawableContainer$getCurrent(), 0, this);
    }

    void updateDensity(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateDensity", $$robo$$android_graphics_drawable_DrawableContainer$updateDensity(android.content.res.Resources ), 0, this, resources);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_DrawableContainer$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    public boolean canApplyTheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_DrawableContainer$canApplyTheme(), 0, this);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_DrawableContainer$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_DrawableContainer$mutate(), 0, this);
    }

    DrawableContainerState cloneConstantState() {
        return InvokeDynamicSupport.bootstrap("cloneConstantState", $$robo$$android_graphics_drawable_DrawableContainer$cloneConstantState(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_DrawableContainer$clearMutated(), 0, this);
    }

    protected void setConstantState(DrawableContainerState drawableContainerState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_DrawableContainer$setConstantState(android.graphics.drawable.DrawableContainer$DrawableContainerState ), 0, this, drawableContainerState);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawableContainer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BlockInvalidateCallback
    implements Drawable.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Drawable.Callback mCallback;

        private void $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$__constructor__() {
        }

        private final BlockInvalidateCallback $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$wrap(Drawable.Callback callback) {
            this.mCallback = callback;
            return this;
        }

        private final Drawable.Callback $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$unwrap() {
            Drawable.Callback callback = this.mCallback;
            this.mCallback = null;
            return callback;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$invalidateDrawable(Drawable who) {
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$scheduleDrawable(Drawable who, Runnable what, long when) {
            if (this.mCallback != null) {
                this.mCallback.scheduleDrawable(who, what, when);
            }
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$unscheduleDrawable(Drawable who, Runnable what) {
            if (this.mCallback != null) {
                this.mCallback.unscheduleDrawable(who, what);
            }
        }

        private /* synthetic */ void $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$__constructor__();
        }

        private BlockInvalidateCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$__constructor__(), 0, this);
        }

        public BlockInvalidateCallback wrap(Drawable.Callback callback) {
            return InvokeDynamicSupport.bootstrap("wrap", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$wrap(android.graphics.drawable.Drawable$Callback ), 0, this, callback);
        }

        public Drawable.Callback unwrap() {
            return InvokeDynamicSupport.bootstrap("unwrap", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$unwrap(), 0, this);
        }

        @Override
        public void invalidateDrawable(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("invalidateDrawable", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$invalidateDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        @Override
        public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
            InvokeDynamicSupport.bootstrap("scheduleDrawable", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$scheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable long ), 0, this, drawable2, runnable, l);
        }

        @Override
        public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
            InvokeDynamicSupport.bootstrap("unscheduleDrawable", $$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$unscheduleDrawable(android.graphics.drawable.Drawable java.lang.Runnable ), 0, this, drawable2, runnable);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_drawable_DrawableContainer_BlockInvalidateCallback$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BlockInvalidateCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class DrawableContainerState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        DrawableContainer mOwner;
        Resources mSourceRes;
        int mDensity;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        SparseArray<Drawable.ConstantState> mDrawableFutures;
        Drawable[] mDrawables;
        int mNumChildren;
        boolean mVariablePadding;
        boolean mCheckedPadding;
        Rect mConstantPadding;
        boolean mConstantSize;
        boolean mCheckedConstantSize;
        int mConstantWidth;
        int mConstantHeight;
        int mConstantMinimumWidth;
        int mConstantMinimumHeight;
        boolean mCheckedOpacity;
        int mOpacity;
        boolean mCheckedStateful;
        boolean mStateful;
        boolean mCheckedConstantState;
        boolean mCanConstantState;
        boolean mDither;
        boolean mMutated;
        int mLayoutDirection;
        int mEnterFadeDuration;
        int mExitFadeDuration;
        boolean mAutoMirrored;
        ColorFilter mColorFilter;
        boolean mHasColorFilter;
        ColorStateList mTintList;
        PorterDuff.Mode mTintMode;
        boolean mHasTintList;
        boolean mHasTintMode;

        private void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$__constructor__(DrawableContainerState orig, DrawableContainer owner, Resources res) {
            this.mDensity = 160;
            this.mVariablePadding = false;
            this.mConstantSize = false;
            this.mDither = true;
            this.mEnterFadeDuration = 0;
            this.mExitFadeDuration = 0;
            this.mOwner = owner;
            this.mSourceRes = res != null ? res : (orig != null ? orig.mSourceRes : null);
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            if (orig != null) {
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
                this.mVariablePadding = orig.mVariablePadding;
                this.mConstantSize = orig.mConstantSize;
                this.mDither = orig.mDither;
                this.mMutated = orig.mMutated;
                this.mLayoutDirection = orig.mLayoutDirection;
                this.mEnterFadeDuration = orig.mEnterFadeDuration;
                this.mExitFadeDuration = orig.mExitFadeDuration;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mColorFilter = orig.mColorFilter;
                this.mHasColorFilter = orig.mHasColorFilter;
                this.mTintList = orig.mTintList;
                this.mTintMode = orig.mTintMode;
                this.mHasTintList = orig.mHasTintList;
                this.mHasTintMode = orig.mHasTintMode;
                if (orig.mDensity == this.mDensity) {
                    if (orig.mCheckedPadding) {
                        this.mConstantPadding = new Rect(orig.mConstantPadding);
                        this.mCheckedPadding = true;
                    }
                    if (orig.mCheckedConstantSize) {
                        this.mConstantWidth = orig.mConstantWidth;
                        this.mConstantHeight = orig.mConstantHeight;
                        this.mConstantMinimumWidth = orig.mConstantMinimumWidth;
                        this.mConstantMinimumHeight = orig.mConstantMinimumHeight;
                        this.mCheckedConstantSize = true;
                    }
                }
                if (orig.mCheckedOpacity) {
                    this.mOpacity = orig.mOpacity;
                    this.mCheckedOpacity = true;
                }
                if (orig.mCheckedStateful) {
                    this.mStateful = orig.mStateful;
                    this.mCheckedStateful = true;
                }
                Drawable[] origDr = orig.mDrawables;
                this.mDrawables = new Drawable[origDr.length];
                this.mNumChildren = orig.mNumChildren;
                SparseArray<Drawable.ConstantState> origDf = orig.mDrawableFutures;
                this.mDrawableFutures = origDf != null ? origDf.clone() : new SparseArray(this.mNumChildren);
                int N = this.mNumChildren;
                for (int i = 0; i < N; ++i) {
                    if (origDr[i] == null) continue;
                    Drawable.ConstantState cs = origDr[i].getConstantState();
                    if (cs != null) {
                        this.mDrawableFutures.put(i, cs);
                        continue;
                    }
                    this.mDrawables[i] = origDr[i];
                }
            } else {
                this.mDrawables = new Drawable[10];
                this.mNumChildren = 0;
            }
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$addChild(Drawable dr) {
            int pos = this.mNumChildren;
            if (pos >= this.mDrawables.length) {
                this.growArray(pos, pos + 10);
            }
            dr.mutate();
            dr.setVisible(false, true);
            dr.setCallback(this.mOwner);
            this.mDrawables[pos] = dr;
            ++this.mNumChildren;
            this.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
            this.mCheckedStateful = false;
            this.mCheckedOpacity = false;
            this.mConstantPadding = null;
            this.mCheckedPadding = false;
            this.mCheckedConstantSize = false;
            this.mCheckedConstantState = false;
            return pos;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getCapacity() {
            return this.mDrawables.length;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$createAllFutures() {
            if (this.mDrawableFutures != null) {
                int futureCount = this.mDrawableFutures.size();
                for (int keyIndex = 0; keyIndex < futureCount; ++keyIndex) {
                    int index = this.mDrawableFutures.keyAt(keyIndex);
                    Drawable.ConstantState cs = this.mDrawableFutures.valueAt(keyIndex);
                    this.mDrawables[index] = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                }
                this.mDrawableFutures = null;
            }
        }

        private final Drawable $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$prepareDrawable(Drawable child) {
            child.setLayoutDirection(this.mLayoutDirection);
            child.setCallback(this.mOwner);
            child = child.mutate();
            return child;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChildCount() {
            return this.mNumChildren;
        }

        private final Drawable[] $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChildren() {
            this.createAllFutures();
            return this.mDrawables;
        }

        private final Drawable $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChild(int index) {
            int keyIndex;
            Drawable result = this.mDrawables[index];
            if (result != null) {
                return result;
            }
            if (this.mDrawableFutures != null && (keyIndex = this.mDrawableFutures.indexOfKey(index)) >= 0) {
                Drawable prepared;
                Drawable.ConstantState cs = this.mDrawableFutures.valueAt(keyIndex);
                this.mDrawables[index] = prepared = this.prepareDrawable(cs.newDrawable(this.mSourceRes));
                this.mDrawableFutures.removeAt(keyIndex);
                if (this.mDrawableFutures.size() == 0) {
                    this.mDrawableFutures = null;
                }
                return prepared;
            }
            return null;
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setLayoutDirection(int layoutDirection, int currentIndex) {
            boolean changed = false;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                boolean childChanged = drawables[i].setLayoutDirection(layoutDirection);
                if (i != currentIndex) continue;
                changed = childChanged;
            }
            this.mLayoutDirection = layoutDirection;
            return changed;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$updateDensity(Resources res) {
            if (res != null) {
                this.mSourceRes = res;
                int targetDensity = Drawable.resolveDensity(res, this.mDensity);
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                if (sourceDensity != targetDensity) {
                    this.mCheckedConstantSize = false;
                    this.mCheckedPadding = false;
                }
            }
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$applyTheme(Resources.Theme theme) {
            if (theme != null) {
                this.createAllFutures();
                int N = this.mNumChildren;
                Drawable[] drawables = this.mDrawables;
                for (int i = 0; i < N; ++i) {
                    if (drawables[i] == null || !drawables[i].canApplyTheme()) continue;
                    drawables[i].applyTheme(theme);
                    this.mChildrenChangingConfigurations |= drawables[i].getChangingConfigurations();
                }
                this.updateDensity(theme.getResources());
            }
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$canApplyTheme() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState future;
                Drawable d = drawables[i];
                if (!(d != null ? d.canApplyTheme() : (future = this.mDrawableFutures.get(i)) != null && future.canApplyTheme())) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$mutate() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].mutate();
            }
            this.mMutated = true;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$clearMutated() {
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i] == null) continue;
                drawables[i].clearMutated();
            }
            this.mMutated = false;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setVariablePadding(boolean variable) {
            this.mVariablePadding = variable;
        }

        private final Rect $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantPadding() {
            if (this.mVariablePadding) {
                return null;
            }
            if (this.mConstantPadding != null || this.mCheckedPadding) {
                return this.mConstantPadding;
            }
            this.createAllFutures();
            Rect r = null;
            Rect t = new Rect();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (!drawables[i].getPadding(t)) continue;
                if (r == null) {
                    r = new Rect(0, 0, 0, 0);
                }
                if (t.left > r.left) {
                    r.left = t.left;
                }
                if (t.top > r.top) {
                    r.top = t.top;
                }
                if (t.right > r.right) {
                    r.right = t.right;
                }
                if (t.bottom <= r.bottom) continue;
                r.bottom = t.bottom;
            }
            this.mCheckedPadding = true;
            this.mConstantPadding = r;
            return this.mConstantPadding;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setConstantSize(boolean constant) {
            this.mConstantSize = constant;
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$isConstantSize() {
            return this.mConstantSize;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantWidth;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantHeight;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantMinimumWidth() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumWidth;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantMinimumHeight() {
            if (!this.mCheckedConstantSize) {
                this.computeConstantSize();
            }
            return this.mConstantMinimumHeight;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$computeConstantSize() {
            this.mCheckedConstantSize = true;
            this.createAllFutures();
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            this.mConstantHeight = -1;
            this.mConstantWidth = -1;
            this.mConstantMinimumHeight = 0;
            this.mConstantMinimumWidth = 0;
            for (int i = 0; i < N; ++i) {
                Drawable dr = drawables[i];
                int s = dr.getIntrinsicWidth();
                if (s > this.mConstantWidth) {
                    this.mConstantWidth = s;
                }
                if ((s = dr.getIntrinsicHeight()) > this.mConstantHeight) {
                    this.mConstantHeight = s;
                }
                if ((s = dr.getMinimumWidth()) > this.mConstantMinimumWidth) {
                    this.mConstantMinimumWidth = s;
                }
                if ((s = dr.getMinimumHeight()) <= this.mConstantMinimumHeight) continue;
                this.mConstantMinimumHeight = s;
            }
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setEnterFadeDuration(int duration) {
            this.mEnterFadeDuration = duration;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getEnterFadeDuration() {
            return this.mEnterFadeDuration;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setExitFadeDuration(int duration) {
            this.mExitFadeDuration = duration;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getExitFadeDuration() {
            return this.mExitFadeDuration;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getOpacity() {
            if (this.mCheckedOpacity) {
                return this.mOpacity;
            }
            this.createAllFutures();
            this.mCheckedOpacity = true;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            int op = N > 0 ? drawables[0].getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, drawables[i].getOpacity());
            }
            this.mOpacity = op;
            return op;
        }

        private final boolean $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$isStateful() {
            if (this.mCheckedStateful) {
                return this.mStateful;
            }
            this.createAllFutures();
            this.mCheckedStateful = true;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (!drawables[i].isStateful()) continue;
                this.mStateful = true;
                return true;
            }
            this.mStateful = false;
            return false;
        }

        private final void $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$growArray(int oldSize, int newSize) {
            Drawable[] newDrawables = new Drawable[newSize];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mDrawables, (int)0, (Object)newDrawables, (int)0, (int)oldSize);
            this.mDrawables = newDrawables;
        }

        private final synchronized boolean $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$canConstantState() {
            if (this.mCheckedConstantState) {
                return this.mCanConstantState;
            }
            this.createAllFutures();
            this.mCheckedConstantState = true;
            int N = this.mNumChildren;
            Drawable[] drawables = this.mDrawables;
            for (int i = 0; i < N; ++i) {
                if (drawables[i].getConstantState() != null) continue;
                this.mCanConstantState = false;
                return false;
            }
            this.mCanConstantState = true;
            return true;
        }

        private final int $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$addAtlasableBitmaps(Collection<Bitmap> atlasList) {
            int N = this.mNumChildren;
            int pixelCount = 0;
            for (int i = 0; i < N; ++i) {
                Drawable.ConstantState state = this.getChild(i).getConstantState();
                if (state == null) continue;
                pixelCount += state.addAtlasableBitmaps(atlasList);
            }
            return pixelCount;
        }

        private void __constructor__(DrawableContainerState drawableContainerState, DrawableContainer drawableContainer, Resources resources) {
            this.$$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$__constructor__(drawableContainerState, drawableContainer, resources);
        }

        DrawableContainerState(DrawableContainerState drawableContainerState, DrawableContainer drawableContainer, Resources resources) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$__constructor__(android.graphics.drawable.DrawableContainer$DrawableContainerState android.graphics.drawable.DrawableContainer android.content.res.Resources ), 0, this, drawableContainerState, drawableContainer, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChangingConfigurations(), 0, this);
        }

        public int addChild(Drawable drawable2) {
            return (int)InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$addChild(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        int getCapacity() {
            return (int)InvokeDynamicSupport.bootstrap("getCapacity", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getCapacity(), 0, this);
        }

        private void createAllFutures() {
            InvokeDynamicSupport.bootstrap("createAllFutures", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$createAllFutures(), 0, this);
        }

        private Drawable prepareDrawable(Drawable drawable2) {
            return InvokeDynamicSupport.bootstrap("prepareDrawable", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$prepareDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        public int getChildCount() {
            return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChildCount(), 0, this);
        }

        public Drawable[] getChildren() {
            return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChildren(), 0, this);
        }

        public Drawable getChild(int n) {
            return InvokeDynamicSupport.bootstrap("getChild", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getChild(int ), 0, this, n);
        }

        boolean setLayoutDirection(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("setLayoutDirection", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setLayoutDirection(int int ), 0, this, n, n2);
        }

        void updateDensity(Resources resources) {
            InvokeDynamicSupport.bootstrap("updateDensity", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$updateDensity(android.content.res.Resources ), 0, this, resources);
        }

        void applyTheme(Resources.Theme theme) {
            InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$canApplyTheme(), 0, this);
        }

        private void mutate() {
            InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$mutate(), 0, this);
        }

        void clearMutated() {
            InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$clearMutated(), 0, this);
        }

        public void setVariablePadding(boolean bl) {
            InvokeDynamicSupport.bootstrap("setVariablePadding", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setVariablePadding(boolean ), 0, this, bl);
        }

        public Rect getConstantPadding() {
            return InvokeDynamicSupport.bootstrap("getConstantPadding", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantPadding(), 0, this);
        }

        public void setConstantSize(boolean bl) {
            InvokeDynamicSupport.bootstrap("setConstantSize", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setConstantSize(boolean ), 0, this, bl);
        }

        public boolean isConstantSize() {
            return (boolean)InvokeDynamicSupport.bootstrap("isConstantSize", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$isConstantSize(), 0, this);
        }

        public int getConstantWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getConstantWidth", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantWidth(), 0, this);
        }

        public int getConstantHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getConstantHeight", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantHeight(), 0, this);
        }

        public int getConstantMinimumWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getConstantMinimumWidth", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantMinimumWidth(), 0, this);
        }

        public int getConstantMinimumHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getConstantMinimumHeight", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getConstantMinimumHeight(), 0, this);
        }

        protected void computeConstantSize() {
            InvokeDynamicSupport.bootstrap("computeConstantSize", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$computeConstantSize(), 0, this);
        }

        public void setEnterFadeDuration(int n) {
            InvokeDynamicSupport.bootstrap("setEnterFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setEnterFadeDuration(int ), 0, this, n);
        }

        public int getEnterFadeDuration() {
            return (int)InvokeDynamicSupport.bootstrap("getEnterFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getEnterFadeDuration(), 0, this);
        }

        public void setExitFadeDuration(int n) {
            InvokeDynamicSupport.bootstrap("setExitFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$setExitFadeDuration(int ), 0, this, n);
        }

        public int getExitFadeDuration() {
            return (int)InvokeDynamicSupport.bootstrap("getExitFadeDuration", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getExitFadeDuration(), 0, this);
        }

        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$getOpacity(), 0, this);
        }

        public boolean isStateful() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$isStateful(), 0, this);
        }

        public void growArray(int n, int n2) {
            InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$growArray(int int ), 0, this, n, n2);
        }

        public synchronized boolean canConstantState() {
            return (boolean)InvokeDynamicSupport.bootstrap("canConstantState", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$canConstantState(), 0, this);
        }

        @Override
        public int addAtlasableBitmaps(Collection<Bitmap> collection) {
            return (int)InvokeDynamicSupport.bootstrap("addAtlasableBitmaps", $$robo$$android_graphics_drawable_DrawableContainer_DrawableContainerState$addAtlasableBitmaps(java.util.Collection<android.graphics.Bitmap> ), 0, this, collection);
        }

        public /* synthetic */ DrawableContainerState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawableContainerState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

