/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ShapeDrawable
extends Drawable
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ShapeState mShapeState;
    private PorterDuffColorFilter mTintFilter;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__() {
    }

    private void $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(Shape s) {
        this.mShapeState.mShape = s;
    }

    private final Shape $$robo$$android_graphics_drawable_ShapeDrawable$getShape() {
        return this.mShapeState.mShape;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setShape(Shape s) {
        this.mShapeState.mShape = s;
        this.updateShape();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setShaderFactory(ShaderFactory fact) {
        this.mShapeState.mShaderFactory = fact;
    }

    private final ShaderFactory $$robo$$android_graphics_drawable_ShapeDrawable$getShaderFactory() {
        return this.mShapeState.mShaderFactory;
    }

    private final Paint $$robo$$android_graphics_drawable_ShapeDrawable$getPaint() {
        return this.mShapeState.mPaint;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setPadding(int left, int top, int right, int bottom) {
        if ((left | top | right | bottom) == 0) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(left, top, right, bottom);
        }
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setPadding(Rect padding) {
        if (padding == null) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(padding);
        }
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setIntrinsicWidth(int width) {
        this.mShapeState.mIntrinsicWidth = width;
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setIntrinsicHeight(int height) {
        this.mShapeState.mIntrinsicHeight = height;
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_ShapeDrawable$getIntrinsicWidth() {
        return this.mShapeState.mIntrinsicWidth;
    }

    private final int $$robo$$android_graphics_drawable_ShapeDrawable$getIntrinsicHeight() {
        return this.mShapeState.mIntrinsicHeight;
    }

    private final boolean $$robo$$android_graphics_drawable_ShapeDrawable$getPadding(Rect padding) {
        if (this.mShapeState.mPadding != null) {
            padding.set(this.mShapeState.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    private static final int $$robo$$android_graphics_drawable_ShapeDrawable$modulateAlpha(int paintAlpha, int alpha) {
        int scale = alpha + (alpha >>> 7);
        return paintAlpha * scale >>> 8;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$onDraw(Shape shape, Canvas canvas, Paint paint) {
        shape.draw(canvas, paint);
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$draw(Canvas canvas) {
        Rect r = this.getBounds();
        ShapeState state = this.mShapeState;
        Paint paint = state.mPaint;
        int prevAlpha = paint.getAlpha();
        paint.setAlpha(ShapeDrawable.modulateAlpha(prevAlpha, state.mAlpha));
        if (paint.getAlpha() != 0 || paint.getXfermode() != null || paint.hasShadowLayer()) {
            boolean clearColorFilter;
            if (this.mTintFilter != null && paint.getColorFilter() == null) {
                paint.setColorFilter(this.mTintFilter);
                clearColorFilter = true;
            } else {
                clearColorFilter = false;
            }
            if (state.mShape != null) {
                int count = canvas.save();
                canvas.translate(r.left, r.top);
                this.onDraw(state.mShape, canvas, paint);
                canvas.restoreToCount(count);
            } else {
                canvas.drawRect(r, paint);
            }
            if (clearColorFilter) {
                paint.setColorFilter(null);
            }
        }
        paint.setAlpha(prevAlpha);
    }

    private final int $$robo$$android_graphics_drawable_ShapeDrawable$getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.getChangingConfigurations();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setAlpha(int alpha) {
        this.mShapeState.mAlpha = alpha;
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_ShapeDrawable$getAlpha() {
        return this.mShapeState.mAlpha;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setTintList(ColorStateList tint) {
        this.mShapeState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mShapeState.mTintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setTintMode(PorterDuff.Mode tintMode) {
        this.mShapeState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mShapeState.mTint, tintMode);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setColorFilter(ColorFilter colorFilter) {
        this.mShapeState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    private final int $$robo$$android_graphics_drawable_ShapeDrawable$getOpacity() {
        Paint p;
        if (this.mShapeState.mShape == null && (p = this.mShapeState.mPaint).getXfermode() == null) {
            int alpha = p.getAlpha();
            if (alpha == 0) {
                return -2;
            }
            if (alpha == 255) {
                return -1;
            }
        }
        return -3;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$setDither(boolean dither) {
        this.mShapeState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateShape();
    }

    private final boolean $$robo$$android_graphics_drawable_ShapeDrawable$onStateChange(int[] stateSet) {
        ShapeState state = this.mShapeState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_graphics_drawable_ShapeDrawable$isStateful() {
        ShapeState s = this.mShapeState;
        return super.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    private final boolean $$robo$$android_graphics_drawable_ShapeDrawable$inflateTag(String name, Resources r, XmlPullParser parser, AttributeSet attrs) {
        if ("padding".equals(name)) {
            TypedArray a = r.obtainAttributes(attrs, R.styleable.ShapeDrawablePadding);
            this.setPadding(a.getDimensionPixelOffset(0, 0), a.getDimensionPixelOffset(1, 0), a.getDimensionPixelOffset(2, 0), a.getDimensionPixelOffset(3, 0));
            a.recycle();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ShapeDrawable.obtainAttributes(r, theme, attrs, R.styleable.ShapeDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type != 2 || this.inflateTag(name = parser.getName(), r, parser, attrs)) continue;
            Log.w("drawable", "Unknown element: " + name + " for ShapeDrawable " + this);
        }
        this.updateLocalState(r);
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ShapeState state = this.mShapeState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ShapeDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$updateStateFromTypedArray(TypedArray a) {
        ColorStateList tint;
        ShapeState state = this.mShapeState;
        Paint paint = state.mPaint;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int color2 = paint.getColor();
        color2 = a.getColor(4, color2);
        paint.setColor(color2);
        boolean dither = paint.isDither();
        dither = a.getBoolean(0, dither);
        paint.setDither(dither);
        this.setIntrinsicWidth((int)a.getDimension(3, state.mIntrinsicWidth));
        this.setIntrinsicHeight((int)a.getDimension(2, state.mIntrinsicHeight));
        int tintMode = a.getInt(5, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$updateShape() {
        if (this.mShapeState.mShape != null) {
            Rect r = this.getBounds();
            int w = r.width();
            int h = r.height();
            this.mShapeState.mShape.resize(w, h);
            if (this.mShapeState.mShaderFactory != null) {
                this.mShapeState.mPaint.setShader(this.mShapeState.mShaderFactory.resize(w, h));
            }
        }
        this.invalidateSelf();
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$getOutline(Outline outline) {
        if (this.mShapeState.mShape != null) {
            this.mShapeState.mShape.getOutline(outline);
            outline.setAlpha((float)this.getAlpha() / 255.0f);
        }
    }

    private final Drawable.ConstantState $$robo$$android_graphics_drawable_ShapeDrawable$getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    private final Drawable $$robo$$android_graphics_drawable_ShapeDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState.mPaint = this.mShapeState.mPaint != null ? new Paint(this.mShapeState.mPaint) : new Paint(1);
            this.mShapeState.mPadding = this.mShapeState.mPadding != null ? new Rect(this.mShapeState.mPadding) : new Rect();
            try {
                this.mShapeState.mShape = this.mShapeState.mShape.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            this.mMutated = true;
        }
        return this;
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private void $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(ShapeState state, Resources res) {
        this.mShapeState = state;
        this.updateLocalState(res);
    }

    private final void $$robo$$android_graphics_drawable_ShapeDrawable$updateLocalState(Resources res) {
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mShapeState.mTint, this.mShapeState.mTintMode);
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(ShapeState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_ShapeDrawable$__constructor__();
    }

    public ShapeDrawable() {
        this(new ShapeState(null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(), 0, this);
    }

    private void __constructor__(Shape shape) {
        this.$$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(shape);
    }

    public ShapeDrawable(Shape shape) {
        this(new ShapeState(null), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(android.graphics.drawable.shapes.Shape ), 0, this, shape);
    }

    public Shape getShape() {
        return InvokeDynamicSupport.bootstrap("getShape", $$robo$$android_graphics_drawable_ShapeDrawable$getShape(), 0, this);
    }

    public void setShape(Shape shape) {
        InvokeDynamicSupport.bootstrap("setShape", $$robo$$android_graphics_drawable_ShapeDrawable$setShape(android.graphics.drawable.shapes.Shape ), 0, this, shape);
    }

    public void setShaderFactory(ShaderFactory shaderFactory) {
        InvokeDynamicSupport.bootstrap("setShaderFactory", $$robo$$android_graphics_drawable_ShapeDrawable$setShaderFactory(android.graphics.drawable.ShapeDrawable$ShaderFactory ), 0, this, shaderFactory);
    }

    public ShaderFactory getShaderFactory() {
        return InvokeDynamicSupport.bootstrap("getShaderFactory", $$robo$$android_graphics_drawable_ShapeDrawable$getShaderFactory(), 0, this);
    }

    public Paint getPaint() {
        return InvokeDynamicSupport.bootstrap("getPaint", $$robo$$android_graphics_drawable_ShapeDrawable$getPaint(), 0, this);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPadding", $$robo$$android_graphics_drawable_ShapeDrawable$setPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void setPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("setPadding", $$robo$$android_graphics_drawable_ShapeDrawable$setPadding(android.graphics.Rect ), 0, this, rect);
    }

    public void setIntrinsicWidth(int n) {
        InvokeDynamicSupport.bootstrap("setIntrinsicWidth", $$robo$$android_graphics_drawable_ShapeDrawable$setIntrinsicWidth(int ), 0, this, n);
    }

    public void setIntrinsicHeight(int n) {
        InvokeDynamicSupport.bootstrap("setIntrinsicHeight", $$robo$$android_graphics_drawable_ShapeDrawable$setIntrinsicHeight(int ), 0, this, n);
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_graphics_drawable_ShapeDrawable$getIntrinsicWidth(), 0, this);
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_graphics_drawable_ShapeDrawable$getIntrinsicHeight(), 0, this);
    }

    @Override
    public boolean getPadding(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPadding", $$robo$$android_graphics_drawable_ShapeDrawable$getPadding(android.graphics.Rect ), 0, this, rect);
    }

    private static int modulateAlpha(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("modulateAlpha", $$robo$$android_graphics_drawable_ShapeDrawable$modulateAlpha(int int ), 0, (int)n, (int)n2);
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_graphics_drawable_ShapeDrawable$onDraw(android.graphics.drawable.shapes.Shape android.graphics.Canvas android.graphics.Paint ), 0, this, shape, canvas, paint);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_graphics_drawable_ShapeDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ShapeDrawable$getChangingConfigurations(), 0, this);
    }

    @Override
    public void setAlpha(int n) {
        InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_graphics_drawable_ShapeDrawable$setAlpha(int ), 0, this, n);
    }

    @Override
    public int getAlpha() {
        return (int)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$android_graphics_drawable_ShapeDrawable$getAlpha(), 0, this);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTintList", $$robo$$android_graphics_drawable_ShapeDrawable$setTintList(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTintMode", $$robo$$android_graphics_drawable_ShapeDrawable$setTintMode(android.graphics.PorterDuff$Mode ), 0, this, mode);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_graphics_drawable_ShapeDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
    }

    @Override
    public int getOpacity() {
        return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_graphics_drawable_ShapeDrawable$getOpacity(), 0, this);
    }

    @Override
    public void setDither(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_graphics_drawable_ShapeDrawable$setDither(boolean ), 0, this, bl);
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        InvokeDynamicSupport.bootstrap("onBoundsChange", $$robo$$android_graphics_drawable_ShapeDrawable$onBoundsChange(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_ShapeDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_ShapeDrawable$isStateful(), 0, this);
    }

    protected boolean inflateTag(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("inflateTag", $$robo$$android_graphics_drawable_ShapeDrawable$inflateTag(java.lang.String android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), 0, this, string2, resources, xmlPullParser, attributeSet);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_ShapeDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_ShapeDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_ShapeDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void updateShape() {
        InvokeDynamicSupport.bootstrap("updateShape", $$robo$$android_graphics_drawable_ShapeDrawable$updateShape(), 0, this);
    }

    @Override
    public void getOutline(Outline outline) {
        InvokeDynamicSupport.bootstrap("getOutline", $$robo$$android_graphics_drawable_ShapeDrawable$getOutline(android.graphics.Outline ), 0, this, outline);
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_graphics_drawable_ShapeDrawable$getConstantState(), 0, this);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_ShapeDrawable$mutate(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_ShapeDrawable$clearMutated(), 0, this);
    }

    private void __constructor__(ShapeState shapeState, Resources resources) {
        this.$$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(shapeState, resources);
    }

    private ShapeDrawable(ShapeState shapeState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(android.graphics.drawable.ShapeDrawable$ShapeState android.content.res.Resources ), 0, this, shapeState, resources);
    }

    private void updateLocalState(Resources resources) {
        InvokeDynamicSupport.bootstrap("updateLocalState", $$robo$$android_graphics_drawable_ShapeDrawable$updateLocalState(android.content.res.Resources ), 0, this, resources);
    }

    private /* synthetic */ void __constructor__(ShapeState shapeState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_ShapeDrawable$__constructor__(shapeState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShapeDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class ShaderFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_drawable_ShapeDrawable_ShaderFactory$__constructor__() {
        }

        public abstract Shader resize(int var1, int var2);

        private void __constructor__() {
            this.$$robo$$android_graphics_drawable_ShapeDrawable_ShaderFactory$__constructor__();
        }

        public ShaderFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ShapeDrawable_ShaderFactory$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShaderFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ShapeState
    extends Drawable.ConstantState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int mChangingConfigurations;
        Paint mPaint;
        Shape mShape;
        ColorStateList mTint;
        PorterDuff.Mode mTintMode;
        Rect mPadding;
        int mIntrinsicWidth;
        int mIntrinsicHeight;
        int mAlpha;
        ShaderFactory mShaderFactory;

        private void $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$__constructor__(ShapeState orig) {
            this.mTint = null;
            this.mTintMode = Drawable.DEFAULT_TINT_MODE;
            this.mAlpha = 255;
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mPaint = orig.mPaint;
                this.mShape = orig.mShape;
                this.mTint = orig.mTint;
                this.mTintMode = orig.mTintMode;
                this.mPadding = orig.mPadding;
                this.mIntrinsicWidth = orig.mIntrinsicWidth;
                this.mIntrinsicHeight = orig.mIntrinsicHeight;
                this.mAlpha = orig.mAlpha;
                this.mShaderFactory = orig.mShaderFactory;
            } else {
                this.mPaint = new Paint(1);
            }
        }

        private final boolean $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme();
        }

        private final Drawable $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$newDrawable() {
            return new ShapeDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$newDrawable(Resources res) {
            return new ShapeDrawable(this, res);
        }

        private final int $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        private void __constructor__(ShapeState shapeState) {
            this.$$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$__constructor__(shapeState);
        }

        ShapeState(ShapeState shapeState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$__constructor__(android.graphics.drawable.ShapeDrawable$ShapeState ), 0, this, shapeState);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$canApplyTheme(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_graphics_drawable_ShapeDrawable_ShapeState$getChangingConfigurations(), 0, this);
        }

        public /* synthetic */ ShapeState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShapeState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

