/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.util.AndroidException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraAccessException
extends AndroidException
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CAMERA_IN_USE = 4;
    public static int MAX_CAMERAS_IN_USE = 5;
    public static int CAMERA_DISABLED = 1;
    public static int CAMERA_DISCONNECTED = 2;
    public static int CAMERA_ERROR = 3;
    public static int CAMERA_DEPRECATED_HAL = 1000;
    private static long serialVersionUID = 5630338637471475675L;
    private int mReason;

    private final int $$robo$$android_hardware_camera2_CameraAccessException$getReason() {
        return this.mReason;
    }

    private void $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int problem) {
        this.mReason = problem;
    }

    private void $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int problem, String message) {
        this.mReason = problem;
    }

    private void $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int problem, String message, Throwable cause) {
        this.mReason = problem;
    }

    private void $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int problem, Throwable cause) {
        this.mReason = problem;
    }

    private static final String $$robo$$android_hardware_camera2_CameraAccessException$getDefaultMessage(int problem) {
        switch (problem) {
            case 4: {
                return "The camera device is in use already";
            }
            case 5: {
                return "The system-wide limit for number of open cameras has been reached, and more camera devices cannot be opened until previous instances are closed.";
            }
            case 2: {
                return "The camera device is removable and has been disconnected from the Android device, or the camera service has shut down the connection due to a higher-priority access request for the camera device.";
            }
            case 1: {
                return "The camera is disabled due to a device policy, and cannot be opened.";
            }
            case 3: {
                return "The camera device is currently in the error state; no further calls to it will succeed.";
            }
        }
        return null;
    }

    private static final String $$robo$$android_hardware_camera2_CameraAccessException$getCombinedMessage(int problem, String message) {
        String problemString = CameraAccessException.getProblemString(problem);
        return String.format("%s (%d): %s", problemString, problem, message);
    }

    private static final String $$robo$$android_hardware_camera2_CameraAccessException$getProblemString(int problem) {
        String problemString;
        switch (problem) {
            case 4: {
                problemString = "CAMERA_IN_USE";
                break;
            }
            case 5: {
                problemString = "MAX_CAMERAS_IN_USE";
                break;
            }
            case 2: {
                problemString = "CAMERA_DISCONNECTED";
                break;
            }
            case 1: {
                problemString = "CAMERA_DISABLED";
                break;
            }
            case 3: {
                problemString = "CAMERA_ERROR";
                break;
            }
            case 1000: {
                problemString = "CAMERA_DEPRECATED_HAL";
                break;
            }
            default: {
                problemString = "<UNKNOWN ERROR>";
            }
        }
        return problemString;
    }

    public int getReason() {
        return (int)InvokeDynamicSupport.bootstrap("getReason", $$robo$$android_hardware_camera2_CameraAccessException$getReason(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_hardware_camera2_CameraAccessException$__constructor__(n);
    }

    public CameraAccessException(int n) {
        super(CameraAccessException.getDefaultMessage(n));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int ), 0, this, n);
    }

    private void __constructor__(int n, String string2) {
        this.$$robo$$android_hardware_camera2_CameraAccessException$__constructor__(n, string2);
    }

    public CameraAccessException(int n, String string2) {
        super(CameraAccessException.getCombinedMessage(n, string2));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int java.lang.String ), 0, this, n, string2);
    }

    private void __constructor__(int n, String string2, Throwable throwable) {
        this.$$robo$$android_hardware_camera2_CameraAccessException$__constructor__(n, string2, throwable);
    }

    public CameraAccessException(int n, String string2, Throwable throwable) {
        super(CameraAccessException.getCombinedMessage(n, string2), throwable);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int java.lang.String java.lang.Throwable ), 0, this, n, string2, throwable);
    }

    private void __constructor__(int n, Throwable throwable) {
        this.$$robo$$android_hardware_camera2_CameraAccessException$__constructor__(n, throwable);
    }

    public CameraAccessException(int n, Throwable throwable) {
        super(CameraAccessException.getDefaultMessage(n), throwable);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_CameraAccessException$__constructor__(int java.lang.Throwable ), 0, this, n, throwable);
    }

    public static String getDefaultMessage(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultMessage", $$robo$$android_hardware_camera2_CameraAccessException$getDefaultMessage(int ), 0, (int)n);
    }

    private static String getCombinedMessage(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCombinedMessage", $$robo$$android_hardware_camera2_CameraAccessException$getCombinedMessage(int java.lang.String ), 0, (int)n, (String)string2);
    }

    private static String getProblemString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getProblemString", $$robo$$android_hardware_camera2_CameraAccessException$getProblemString(int ), 0, (int)n);
    }

    public /* synthetic */ CameraAccessException() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraAccessException)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

