/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.ImageFormat;
import android.graphics.PixelFormat;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.ImageReader;
import android.media.MediaCodec;
import android.media.MediaRecorder;
import android.renderscript.Allocation;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StreamConfigurationMap
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StreamConfigurationMap";
    private static int HAL_PIXEL_FORMAT_RAW16 = 32;
    private static int HAL_PIXEL_FORMAT_BLOB = 33;
    private static int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    private static int HAL_PIXEL_FORMAT_YCbCr_420_888 = 35;
    private static int HAL_PIXEL_FORMAT_RAW_OPAQUE = 36;
    private static int HAL_PIXEL_FORMAT_RAW10 = 37;
    private static int HAL_PIXEL_FORMAT_RAW12 = 38;
    private static int HAL_PIXEL_FORMAT_Y16 = 540422489;
    private static int HAL_DATASPACE_STANDARD_SHIFT = 16;
    private static int HAL_DATASPACE_TRANSFER_SHIFT = 22;
    private static int HAL_DATASPACE_RANGE_SHIFT = 27;
    private static int HAL_DATASPACE_UNKNOWN = 0;
    private static int HAL_DATASPACE_V0_JFIF = 146931712;
    private static int HAL_DATASPACE_DEPTH = 4096;
    private static long DURATION_20FPS_NS = 50000000L;
    private static int DURATION_MIN_FRAME = 0;
    private static int DURATION_STALL = 1;
    private StreamConfiguration[] mConfigurations;
    private StreamConfigurationDuration[] mMinFrameDurations;
    private StreamConfigurationDuration[] mStallDurations;
    private StreamConfiguration[] mDepthConfigurations;
    private StreamConfigurationDuration[] mDepthMinFrameDurations;
    private StreamConfigurationDuration[] mDepthStallDurations;
    private HighSpeedVideoConfiguration[] mHighSpeedVideoConfigurations;
    private ReprocessFormatsMap mInputOutputFormatsMap;
    private boolean mListHighResolution;
    private SparseIntArray mOutputFormats;
    private SparseIntArray mHighResOutputFormats;
    private SparseIntArray mAllOutputFormats;
    private SparseIntArray mInputFormats;
    private SparseIntArray mDepthOutputFormats;
    private HashMap<Size, Integer> mHighSpeedVideoSizeMap;
    private HashMap<Range<Integer>, Integer> mHighSpeedVideoFpsRangeMap;

    private void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(StreamConfiguration[] configurations, StreamConfigurationDuration[] minFrameDurations, StreamConfigurationDuration[] stallDurations, StreamConfiguration[] depthConfigurations, StreamConfigurationDuration[] depthMinFrameDurations, StreamConfigurationDuration[] depthStallDurations, HighSpeedVideoConfiguration[] highSpeedVideoConfigurations, ReprocessFormatsMap inputOutputFormatsMap, boolean listHighResolution) {
        this.mOutputFormats = new SparseIntArray();
        this.mHighResOutputFormats = new SparseIntArray();
        this.mAllOutputFormats = new SparseIntArray();
        this.mInputFormats = new SparseIntArray();
        this.mDepthOutputFormats = new SparseIntArray();
        this.mHighSpeedVideoSizeMap = new HashMap();
        this.mHighSpeedVideoFpsRangeMap = new HashMap();
        if (configurations == null) {
            Preconditions.checkArrayElementsNotNull(depthConfigurations, "depthConfigurations");
            this.mConfigurations = new StreamConfiguration[0];
            this.mMinFrameDurations = new StreamConfigurationDuration[0];
            this.mStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mConfigurations = Preconditions.checkArrayElementsNotNull(configurations, "configurations");
            this.mMinFrameDurations = Preconditions.checkArrayElementsNotNull(minFrameDurations, "minFrameDurations");
            this.mStallDurations = Preconditions.checkArrayElementsNotNull(stallDurations, "stallDurations");
        }
        this.mListHighResolution = listHighResolution;
        if (depthConfigurations == null) {
            this.mDepthConfigurations = new StreamConfiguration[0];
            this.mDepthMinFrameDurations = new StreamConfigurationDuration[0];
            this.mDepthStallDurations = new StreamConfigurationDuration[0];
        } else {
            this.mDepthConfigurations = Preconditions.checkArrayElementsNotNull(depthConfigurations, "depthConfigurations");
            this.mDepthMinFrameDurations = Preconditions.checkArrayElementsNotNull(depthMinFrameDurations, "depthMinFrameDurations");
            this.mDepthStallDurations = Preconditions.checkArrayElementsNotNull(depthStallDurations, "depthStallDurations");
        }
        this.mHighSpeedVideoConfigurations = highSpeedVideoConfigurations == null ? new HighSpeedVideoConfiguration[0] : Preconditions.checkArrayElementsNotNull(highSpeedVideoConfigurations, "highSpeedVideoConfigurations");
        for (StreamConfiguration streamConfiguration : this.mConfigurations) {
            int fmt = streamConfiguration.getFormat();
            SparseIntArray map = null;
            if (streamConfiguration.isOutput()) {
                this.mAllOutputFormats.put(fmt, this.mAllOutputFormats.get(fmt) + 1);
                long duration = 0L;
                if (this.mListHighResolution) {
                    for (StreamConfigurationDuration configurationDuration : this.mMinFrameDurations) {
                        if (configurationDuration.getFormat() != fmt || configurationDuration.getWidth() != streamConfiguration.getSize().getWidth() || configurationDuration.getHeight() != streamConfiguration.getSize().getHeight()) continue;
                        duration = configurationDuration.getDuration();
                        break;
                    }
                }
                map = duration <= 50000000L ? this.mOutputFormats : this.mHighResOutputFormats;
            } else {
                map = this.mInputFormats;
            }
            map.put(fmt, map.get(fmt) + 1);
        }
        for (StreamConfiguration streamConfiguration : this.mDepthConfigurations) {
            if (!streamConfiguration.isOutput()) continue;
            this.mDepthOutputFormats.put(streamConfiguration.getFormat(), this.mDepthOutputFormats.get(streamConfiguration.getFormat()) + 1);
        }
        if (configurations != null && this.mOutputFormats.indexOfKey(34) < 0) {
            throw new AssertionError((Object)"At least one stream configuration for IMPLEMENTATION_DEFINED must exist");
        }
        for (HighSpeedVideoConfiguration highSpeedVideoConfiguration : this.mHighSpeedVideoConfigurations) {
            Size size = highSpeedVideoConfiguration.getSize();
            Range<Integer> fpsRange = highSpeedVideoConfiguration.getFpsRange();
            Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
            if (fpsRangeCount == null) {
                fpsRangeCount = 0;
            }
            this.mHighSpeedVideoSizeMap.put(size, fpsRangeCount + 1);
            Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
            if (sizeCount == null) {
                sizeCount = 0;
            }
            this.mHighSpeedVideoFpsRangeMap.put(fpsRange, sizeCount + 1);
        }
        this.mInputOutputFormatsMap = inputOutputFormatsMap;
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputFormats() {
        return this.getPublicFormats(true);
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getValidOutputFormatsForInput(int inputFormat) {
        if (this.mInputOutputFormatsMap == null) {
            return new int[0];
        }
        return this.mInputOutputFormatsMap.getOutputs(inputFormat);
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputFormats() {
        return this.getPublicFormats(false);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputSizes(int format) {
        return this.getPublicFormatSizes(format, false, false);
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(int format) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int dataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        if (dataspace == 4096) {
            return this.mDepthOutputFormats.indexOfKey(internalFormat) >= 0;
        }
        return this.getFormatsMap(true).indexOfKey(internalFormat) >= 0;
    }

    private static final <T> boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(Class<T> klass) {
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == ImageReader.class) {
            return true;
        }
        if (klass == MediaRecorder.class) {
            return true;
        }
        if (klass == MediaCodec.class) {
            return true;
        }
        if (klass == Allocation.class) {
            return true;
        }
        if (klass == SurfaceHolder.class) {
            return true;
        }
        return klass == SurfaceTexture.class;
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(Surface surface) {
        StreamConfiguration[] configs;
        Preconditions.checkNotNull(surface, "surface must not be null");
        Size surfaceSize = SurfaceUtils.getSurfaceSize(surface);
        int surfaceFormat = SurfaceUtils.getSurfaceFormat(surface);
        int surfaceDataspace = SurfaceUtils.getSurfaceDataspace(surface);
        boolean isFlexible = SurfaceUtils.isFlexibleConsumer(surface);
        if (surfaceFormat >= 1 && surfaceFormat <= 5) {
            surfaceFormat = 34;
        }
        for (StreamConfiguration config : configs = surfaceDataspace != 4096 ? this.mConfigurations : this.mDepthConfigurations) {
            if (config.getFormat() != surfaceFormat || !config.isOutput()) continue;
            if (config.getSize().equals(surfaceSize)) {
                return true;
            }
            if (!isFlexible || config.getSize().getWidth() > 1920) continue;
            return true;
        }
        return false;
    }

    private final <T> Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(Class<T> klass) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            return null;
        }
        return this.getInternalFormatSizes(34, 0, true, false);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(int format) {
        return this.getPublicFormatSizes(format, true, false);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizes() {
        Set<Size> keySet = this.mHighSpeedVideoSizeMap.keySet();
        return keySet.toArray(new Size[keySet.size()]);
    }

    private final Range<Integer>[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRangesFor(Size size) {
        Integer fpsRangeCount = this.mHighSpeedVideoSizeMap.get(size);
        if (fpsRangeCount == null || fpsRangeCount == 0) {
            throw new IllegalArgumentException(String.format("Size %s does not support high speed video recording", size));
        }
        Range[] fpsRanges = new Range[fpsRangeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!size.equals(config.getSize())) continue;
            fpsRanges[i++] = config.getFpsRange();
        }
        return fpsRanges;
    }

    private final Range<Integer>[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRanges() {
        Set<Range<Integer>> keySet = this.mHighSpeedVideoFpsRangeMap.keySet();
        return keySet.toArray(new Range[keySet.size()]);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizesFor(Range<Integer> fpsRange) {
        Integer sizeCount = this.mHighSpeedVideoFpsRangeMap.get(fpsRange);
        if (sizeCount == null || sizeCount == 0) {
            throw new IllegalArgumentException(String.format("FpsRange %s does not support high speed video recording", fpsRange));
        }
        Size[] sizes = new Size[sizeCount.intValue()];
        int i = 0;
        for (HighSpeedVideoConfiguration config : this.mHighSpeedVideoConfigurations) {
            if (!fpsRange.equals(config.getFpsRange())) continue;
            sizes[i++] = config.getSize();
        }
        return sizes;
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighResolutionOutputSizes(int format) {
        if (!this.mListHighResolution) {
            return null;
        }
        return this.getPublicFormatSizes(format, true, true);
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(int format, Size size) {
        Preconditions.checkNotNull(size, "size must not be null");
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), StreamConfigurationMap.imageFormatToDataspace(format), size, 0);
    }

    private final <T> long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, 0, size, 0);
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(int format, Size size) {
        this.checkArgumentFormatSupported(format, true);
        return this.getInternalFormatDuration(StreamConfigurationMap.imageFormatToInternal(format), StreamConfigurationMap.imageFormatToDataspace(format), size, 1);
    }

    private final <T> long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(Class<T> klass, Size size) {
        if (!StreamConfigurationMap.isOutputSupportedFor(klass)) {
            throw new IllegalArgumentException("klass was not supported");
        }
        return this.getInternalFormatDuration(34, 0, size, 1);
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamConfigurationMap) {
            StreamConfigurationMap other = (StreamConfigurationMap)obj;
            return Arrays.equals(this.mConfigurations, other.mConfigurations) && Arrays.equals(this.mMinFrameDurations, other.mMinFrameDurations) && Arrays.equals(this.mStallDurations, other.mStallDurations) && Arrays.equals(this.mDepthConfigurations, other.mDepthConfigurations) && Arrays.equals(this.mHighSpeedVideoConfigurations, other.mHighSpeedVideoConfigurations);
        }
        return false;
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mConfigurations, this.mMinFrameDurations, this.mStallDurations, this.mDepthConfigurations, this.mHighSpeedVideoConfigurations);
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatSupported(int format, boolean output) {
        StreamConfigurationMap.checkArgumentFormat(format);
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int internalDataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        if (output ? (internalDataspace == 4096 ? this.mDepthOutputFormats.indexOfKey(internalFormat) >= 0 : this.mAllOutputFormats.indexOfKey(internalFormat) >= 0) : this.mInputFormats.indexOfKey(internalFormat) >= 0) {
            return format;
        }
        throw new IllegalArgumentException(String.format("format %x is not supported by this stream configuration map", format));
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatInternal(int format) {
        switch (format) {
            case 33: 
            case 34: 
            case 36: 
            case 540422489: {
                return format;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
        }
        return StreamConfigurationMap.checkArgumentFormat(format);
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormat(int format) {
        if (!ImageFormat.isPublicFormat(format) && !PixelFormat.isPublicFormat(format)) {
            throw new IllegalArgumentException(String.format("format 0x%x was not defined in either ImageFormat or PixelFormat", format));
        }
        return format;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 256;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
        }
        return format;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$depthFormatToPublic(int format) {
        switch (format) {
            case 33: {
                return 257;
            }
            case 540422489: {
                return 1144402265;
            }
            case 256: {
                throw new IllegalArgumentException("ImageFormat.JPEG is an unknown internal format");
            }
            case 34: {
                throw new IllegalArgumentException("IMPLEMENTATION_DEFINED must not leak to public API");
            }
        }
        throw new IllegalArgumentException("Unknown DATASPACE_DEPTH format " + format);
    }

    private static final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToPublic(formats[i]);
        }
        return formats;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int format) {
        switch (format) {
            case 256: 
            case 257: {
                return 33;
            }
            case 1144402265: {
                return 540422489;
            }
        }
        return format;
    }

    private static final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToDataspace(int format) {
        switch (format) {
            case 256: {
                return 146931712;
            }
            case 257: 
            case 1144402265: {
                return 4096;
            }
        }
        return 0;
    }

    private static final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int[] formats) {
        if (formats == null) {
            return null;
        }
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = StreamConfigurationMap.imageFormatToInternal(formats[i]);
        }
        return formats;
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatSizes(int format, boolean output, boolean highRes) {
        try {
            this.checkArgumentFormatSupported(format, output);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        int dataspace = StreamConfigurationMap.imageFormatToDataspace(format);
        return this.getInternalFormatSizes(internalFormat, dataspace, output, highRes);
    }

    private final Size[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatSizes(int format, int dataspace, boolean output, boolean highRes) {
        if (dataspace == 4096 && highRes) {
            return new Size[0];
        }
        SparseIntArray formatsMap = !output ? this.mInputFormats : (dataspace == 4096 ? this.mDepthOutputFormats : (highRes ? this.mHighResOutputFormats : this.mOutputFormats));
        int sizesCount = formatsMap.get(format);
        if ((!output || dataspace == 4096) && sizesCount == 0 || output && dataspace != 4096 && this.mAllOutputFormats.get(format) == 0) {
            throw new IllegalArgumentException("format not available");
        }
        Size[] sizes = new Size[sizesCount];
        int sizeIndex = 0;
        StreamConfiguration[] configurations = dataspace == 4096 ? this.mDepthConfigurations : this.mConfigurations;
        StreamConfigurationDuration[] minFrameDurations = dataspace == 4096 ? this.mDepthMinFrameDurations : this.mMinFrameDurations;
        for (StreamConfiguration config : configurations) {
            int fmt = config.getFormat();
            if (fmt != format || config.isOutput() != output) continue;
            if (output && this.mListHighResolution) {
                long duration = 0L;
                for (int i = 0; i < minFrameDurations.length; ++i) {
                    StreamConfigurationDuration d = minFrameDurations[i];
                    if (d.getFormat() != fmt || d.getWidth() != config.getSize().getWidth() || d.getHeight() != config.getSize().getHeight()) continue;
                    duration = d.getDuration();
                    break;
                }
                if (dataspace != 4096 && highRes != duration > 50000000L) continue;
            }
            sizes[sizeIndex++] = config.getSize();
        }
        if (sizeIndex != sizesCount) {
            throw new AssertionError((Object)("Too few sizes (expected " + sizesCount + ", actual " + sizeIndex + ")"));
        }
        return sizes;
    }

    private final int[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormats(boolean output) {
        int j;
        int[] formats = new int[this.getPublicFormatCount(output)];
        int i = 0;
        SparseIntArray map = this.getFormatsMap(output);
        for (j = 0; j < map.size(); ++j) {
            int format = map.keyAt(j);
            formats[i++] = StreamConfigurationMap.imageFormatToPublic(format);
        }
        if (output) {
            for (j = 0; j < this.mDepthOutputFormats.size(); ++j) {
                formats[i++] = StreamConfigurationMap.depthFormatToPublic(this.mDepthOutputFormats.keyAt(j));
            }
        }
        if (formats.length != i) {
            throw new AssertionError((Object)("Too few formats " + i + ", expected " + formats.length));
        }
        return formats;
    }

    private final SparseIntArray $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getFormatsMap(boolean output) {
        return output ? this.mAllOutputFormats : this.mInputFormats;
    }

    private final long $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatDuration(int format, int dataspace, Size size, int duration) {
        StreamConfigurationDuration[] durations;
        if (!this.isSupportedInternalConfiguration(format, dataspace, size)) {
            throw new IllegalArgumentException("size was not supported");
        }
        for (StreamConfigurationDuration configurationDuration : durations = this.getDurations(duration, dataspace)) {
            if (configurationDuration.getFormat() != format || configurationDuration.getWidth() != size.getWidth() || configurationDuration.getHeight() != size.getHeight()) continue;
            return configurationDuration.getDuration();
        }
        return 0L;
    }

    private final StreamConfigurationDuration[] $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getDurations(int duration, int dataspace) {
        switch (duration) {
            case 0: {
                return dataspace == 4096 ? this.mDepthMinFrameDurations : this.mMinFrameDurations;
            }
            case 1: {
                return dataspace == 4096 ? this.mDepthStallDurations : this.mStallDurations;
            }
        }
        throw new IllegalArgumentException("duration was invalid");
    }

    private final int $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatCount(boolean output) {
        SparseIntArray formatsMap = this.getFormatsMap(output);
        int size = formatsMap.size();
        if (output) {
            size += this.mDepthOutputFormats.size();
        }
        return size;
    }

    private static final <T> boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$arrayContains(T[] array2, T element) {
        if (array2 == null) {
            return false;
        }
        for (T el : array2) {
            if (!Objects.equals(el, element)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isSupportedInternalConfiguration(int format, int dataspace, Size size) {
        StreamConfiguration[] configurations = dataspace == 4096 ? this.mDepthConfigurations : this.mConfigurations;
        for (int i = 0; i < configurations.length; ++i) {
            if (configurations[i].getFormat() != format || !configurations[i].getSize().equals(size)) continue;
            return true;
        }
        return false;
    }

    private final String $$robo$$android_hardware_camera2_params_StreamConfigurationMap$toString() {
        StringBuilder sb = new StringBuilder("StreamConfiguration(");
        this.appendOutputsString(sb);
        sb.append(", ");
        this.appendHighResOutputsString(sb);
        sb.append(", ");
        this.appendInputsString(sb);
        sb.append(", ");
        this.appendValidOutputFormatsForInputString(sb);
        sb.append(", ");
        this.appendHighSpeedVideoConfigurationsString(sb);
        sb.append(")");
        return sb.toString();
    }

    private final void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendOutputsString(StringBuilder sb) {
        int[] formats;
        sb.append("Outputs(");
        for (int format : formats = this.getOutputFormats()) {
            Size[] sizes;
            for (Size size : sizes = this.getOutputSizes(format)) {
                long minFrameDuration = this.getOutputMinFrameDuration(format, size);
                long stallDuration = this.getOutputStallDuration(format, size);
                sb.append(String.format("[w:%d, h:%d, format:%s(%d), min_duration:%d, stall:%d], ", size.getWidth(), size.getHeight(), this.formatToString(format), format, minFrameDuration, stallDuration));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private final void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendHighResOutputsString(StringBuilder sb) {
        int[] formats;
        sb.append("HighResolutionOutputs(");
        for (int format : formats = this.getOutputFormats()) {
            Size[] sizes = this.getHighResolutionOutputSizes(format);
            if (sizes == null) continue;
            for (Size size : sizes) {
                long minFrameDuration = this.getOutputMinFrameDuration(format, size);
                long stallDuration = this.getOutputStallDuration(format, size);
                sb.append(String.format("[w:%d, h:%d, format:%s(%d), min_duration:%d, stall:%d], ", size.getWidth(), size.getHeight(), this.formatToString(format), format, minFrameDuration, stallDuration));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private final void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendInputsString(StringBuilder sb) {
        int[] formats;
        sb.append("Inputs(");
        for (int format : formats = this.getInputFormats()) {
            Size[] sizes;
            for (Size size : sizes = this.getInputSizes(format)) {
                sb.append(String.format("[w:%d, h:%d, format:%s(%d)], ", size.getWidth(), size.getHeight(), this.formatToString(format), format));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private final void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendValidOutputFormatsForInputString(StringBuilder sb) {
        int[] inputFormats;
        sb.append("ValidOutputFormatsForInput(");
        for (int inputFormat : inputFormats = this.getInputFormats()) {
            sb.append(String.format("[in:%s(%d), out:", this.formatToString(inputFormat), inputFormat));
            int[] outputFormats = this.getValidOutputFormatsForInput(inputFormat);
            for (int i = 0; i < outputFormats.length; ++i) {
                sb.append(String.format("%s(%d)", this.formatToString(outputFormats[i]), outputFormats[i]));
                if (i >= outputFormats.length - 1) continue;
                sb.append(", ");
            }
            sb.append("], ");
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private final void $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendHighSpeedVideoConfigurationsString(StringBuilder sb) {
        Size[] sizes;
        sb.append("HighSpeedVideoConfigurations(");
        for (Size size : sizes = this.getHighSpeedVideoSizes()) {
            Range<Integer>[] ranges;
            for (Range<Integer> range : ranges = this.getHighSpeedVideoFpsRangesFor(size)) {
                sb.append(String.format("[w:%d, h:%d, min_fps:%d, max_fps:%d], ", size.getWidth(), size.getHeight(), range.getLower(), range.getUpper()));
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(")");
    }

    private final String $$robo$$android_hardware_camera2_params_StreamConfigurationMap$formatToString(int format) {
        switch (format) {
            case 842094169: {
                return "YV12";
            }
            case 35: {
                return "YUV_420_888";
            }
            case 17: {
                return "NV21";
            }
            case 16: {
                return "NV16";
            }
            case 4: {
                return "RGB_565";
            }
            case 1: {
                return "RGBA_8888";
            }
            case 2: {
                return "RGBX_8888";
            }
            case 3: {
                return "RGB_888";
            }
            case 256: {
                return "JPEG";
            }
            case 20: {
                return "YUY2";
            }
            case 538982489: {
                return "Y8";
            }
            case 540422489: {
                return "Y16";
            }
            case 32: {
                return "RAW_SENSOR";
            }
            case 36: {
                return "RAW_PRIVATE";
            }
            case 37: {
                return "RAW10";
            }
            case 1144402265: {
                return "DEPTH16";
            }
            case 257: {
                return "DEPTH_POINT_CLOUD";
            }
            case 34: {
                return "PRIVATE";
            }
        }
        return "UNKNOWN";
    }

    private void __constructor__(StreamConfiguration[] streamConfigurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray2, StreamConfiguration[] streamConfigurationArray2, StreamConfigurationDuration[] streamConfigurationDurationArray3, StreamConfigurationDuration[] streamConfigurationDurationArray4, HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray, ReprocessFormatsMap reprocessFormatsMap, boolean bl) {
        this.$$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(streamConfigurationArray, streamConfigurationDurationArray, streamConfigurationDurationArray2, streamConfigurationArray2, streamConfigurationDurationArray3, streamConfigurationDurationArray4, highSpeedVideoConfigurationArray, reprocessFormatsMap, bl);
    }

    public StreamConfigurationMap(StreamConfiguration[] streamConfigurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray, StreamConfigurationDuration[] streamConfigurationDurationArray2, StreamConfiguration[] streamConfigurationArray2, StreamConfigurationDuration[] streamConfigurationDurationArray3, StreamConfigurationDuration[] streamConfigurationDurationArray4, HighSpeedVideoConfiguration[] highSpeedVideoConfigurationArray, ReprocessFormatsMap reprocessFormatsMap, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$__constructor__(android.hardware.camera2.params.StreamConfiguration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.StreamConfiguration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.StreamConfigurationDuration[] android.hardware.camera2.params.HighSpeedVideoConfiguration[] android.hardware.camera2.params.ReprocessFormatsMap boolean ), 0, this, streamConfigurationArray, streamConfigurationDurationArray, streamConfigurationDurationArray2, streamConfigurationArray2, streamConfigurationDurationArray3, streamConfigurationDurationArray4, highSpeedVideoConfigurationArray, reprocessFormatsMap, bl);
    }

    public int[] getOutputFormats() {
        return InvokeDynamicSupport.bootstrap("getOutputFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputFormats(), 0, this);
    }

    public int[] getValidOutputFormatsForInput(int n) {
        return InvokeDynamicSupport.bootstrap("getValidOutputFormatsForInput", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getValidOutputFormatsForInput(int ), 0, this, n);
    }

    public int[] getInputFormats() {
        return InvokeDynamicSupport.bootstrap("getInputFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputFormats(), 0, this);
    }

    public Size[] getInputSizes(int n) {
        return InvokeDynamicSupport.bootstrap("getInputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInputSizes(int ), 0, this, n);
    }

    public boolean isOutputSupportedFor(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(int ), 0, this, n);
    }

    public static <T> boolean isOutputSupportedFor(Class<T> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(java.lang.Class<T> ), 0, clazz);
    }

    public boolean isOutputSupportedFor(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutputSupportedFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isOutputSupportedFor(android.view.Surface ), 0, this, surface);
    }

    public <T> Size[] getOutputSizes(Class<T> clazz) {
        return InvokeDynamicSupport.bootstrap("getOutputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(java.lang.Class<T> ), 0, this, clazz);
    }

    public Size[] getOutputSizes(int n) {
        return InvokeDynamicSupport.bootstrap("getOutputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputSizes(int ), 0, this, n);
    }

    public Size[] getHighSpeedVideoSizes() {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizes(), 0, this);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRangesFor(Size size) {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoFpsRangesFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRangesFor(android.util.Size ), 0, this, size);
    }

    public Range<Integer>[] getHighSpeedVideoFpsRanges() {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoFpsRanges", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoFpsRanges(), 0, this);
    }

    public Size[] getHighSpeedVideoSizesFor(Range<Integer> range) {
        return InvokeDynamicSupport.bootstrap("getHighSpeedVideoSizesFor", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighSpeedVideoSizesFor(android.util.Range<java.lang.Integer> ), 0, this, range);
    }

    public Size[] getHighResolutionOutputSizes(int n) {
        return InvokeDynamicSupport.bootstrap("getHighResolutionOutputSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getHighResolutionOutputSizes(int ), 0, this, n);
    }

    public long getOutputMinFrameDuration(int n, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputMinFrameDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(int android.util.Size ), 0, this, n, size);
    }

    public <T> long getOutputMinFrameDuration(Class<T> clazz, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputMinFrameDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputMinFrameDuration(java.lang.Class<T> android.util.Size ), 0, this, clazz, size);
    }

    public long getOutputStallDuration(int n, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputStallDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(int android.util.Size ), 0, this, n, size);
    }

    public <T> long getOutputStallDuration(Class<T> clazz, Size size) {
        return (long)InvokeDynamicSupport.bootstrap("getOutputStallDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getOutputStallDuration(java.lang.Class<T> android.util.Size ), 0, this, clazz, size);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$hashCode(), 0, this);
    }

    private int checkArgumentFormatSupported(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("checkArgumentFormatSupported", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatSupported(int boolean ), 0, this, n, bl);
    }

    static int checkArgumentFormatInternal(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentFormatInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormatInternal(int ), 0, (int)n);
    }

    static int checkArgumentFormat(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentFormat", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$checkArgumentFormat(int ), 0, (int)n);
    }

    static int imageFormatToPublic(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("imageFormatToPublic", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int ), 0, (int)n);
    }

    static int depthFormatToPublic(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("depthFormatToPublic", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$depthFormatToPublic(int ), 0, (int)n);
    }

    static int[] imageFormatToPublic(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("imageFormatToPublic", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToPublic(int[] ), 0, (int[])nArray);
    }

    static int imageFormatToInternal(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("imageFormatToInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int ), 0, (int)n);
    }

    static int imageFormatToDataspace(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("imageFormatToDataspace", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToDataspace(int ), 0, (int)n);
    }

    public static int[] imageFormatToInternal(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("imageFormatToInternal", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$imageFormatToInternal(int[] ), 0, (int[])nArray);
    }

    private Size[] getPublicFormatSizes(int n, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getPublicFormatSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatSizes(int boolean boolean ), 0, this, n, bl, bl2);
    }

    private Size[] getInternalFormatSizes(int n, int n2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getInternalFormatSizes", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatSizes(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    private int[] getPublicFormats(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPublicFormats", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormats(boolean ), 0, this, bl);
    }

    private SparseIntArray getFormatsMap(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getFormatsMap", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getFormatsMap(boolean ), 0, this, bl);
    }

    private long getInternalFormatDuration(int n, int n2, Size size, int n3) {
        return (long)InvokeDynamicSupport.bootstrap("getInternalFormatDuration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getInternalFormatDuration(int int android.util.Size int ), 0, this, n, n2, size, n3);
    }

    private StreamConfigurationDuration[] getDurations(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getDurations", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getDurations(int int ), 0, this, n, n2);
    }

    private int getPublicFormatCount(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getPublicFormatCount", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$getPublicFormatCount(boolean ), 0, this, bl);
    }

    private static <T> boolean arrayContains(T[] TArray, T t) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayContains", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$arrayContains(T[] T ), 0, (Object[])TArray, t);
    }

    private boolean isSupportedInternalConfiguration(int n, int n2, Size size) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedInternalConfiguration", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$isSupportedInternalConfiguration(int int android.util.Size ), 0, this, n, n2, size);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$toString(), 0, this);
    }

    private void appendOutputsString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendOutputsString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendOutputsString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private void appendHighResOutputsString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendHighResOutputsString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendHighResOutputsString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private void appendInputsString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendInputsString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendInputsString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private void appendValidOutputFormatsForInputString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendValidOutputFormatsForInputString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendValidOutputFormatsForInputString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private void appendHighSpeedVideoConfigurationsString(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrap("appendHighSpeedVideoConfigurationsString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$appendHighSpeedVideoConfigurationsString(java.lang.StringBuilder ), 0, this, stringBuilder);
    }

    private String formatToString(int n) {
        return InvokeDynamicSupport.bootstrap("formatToString", $$robo$$android_hardware_camera2_params_StreamConfigurationMap$formatToString(int ), 0, this, n);
    }

    public /* synthetic */ StreamConfigurationMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StreamConfigurationMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

