/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.GeofenceHardwareMonitorEvent;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IGeofenceHardwareCallback;
import android.hardware.location.IGeofenceHardwareMonitorCallback;
import android.location.IFusedGeofenceHardware;
import android.location.IGpsGeofenceHardware;
import android.location.Location;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Iterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class GeofenceHardwareImpl
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GeofenceHardwareImpl";
    private static boolean DEBUG;
    private static int FIRST_VERSION_WITH_CAPABILITIES = 2;
    private Context mContext;
    private static GeofenceHardwareImpl sInstance;
    private PowerManager.WakeLock mWakeLock;
    private SparseArray<IGeofenceHardwareCallback> mGeofences;
    private ArrayList<IGeofenceHardwareMonitorCallback>[] mCallbacks;
    private ArrayList<Reaper> mReapers;
    private IFusedGeofenceHardware mFusedService;
    private IGpsGeofenceHardware mGpsService;
    private int mCapabilities;
    private int mVersion;
    private int[] mSupportedMonitorTypes;
    private static int GEOFENCE_TRANSITION_CALLBACK = 1;
    private static int ADD_GEOFENCE_CALLBACK = 2;
    private static int REMOVE_GEOFENCE_CALLBACK = 3;
    private static int PAUSE_GEOFENCE_CALLBACK = 4;
    private static int RESUME_GEOFENCE_CALLBACK = 5;
    private static int GEOFENCE_CALLBACK_BINDER_DIED = 6;
    private static int GEOFENCE_STATUS = 1;
    private static int CALLBACK_ADD = 2;
    private static int CALLBACK_REMOVE = 3;
    private static int MONITOR_CALLBACK_BINDER_DIED = 4;
    private static int REAPER_GEOFENCE_ADDED = 1;
    private static int REAPER_MONITOR_CALLBACK_ADDED = 2;
    private static int REAPER_REMOVED = 3;
    private static int LOCATION_INVALID = 0;
    private static int LOCATION_HAS_LAT_LONG = 1;
    private static int LOCATION_HAS_ALTITUDE = 2;
    private static int LOCATION_HAS_SPEED = 4;
    private static int LOCATION_HAS_BEARING = 8;
    private static int LOCATION_HAS_ACCURACY = 16;
    private static int RESOLUTION_LEVEL_NONE = 1;
    private static int RESOLUTION_LEVEL_COARSE = 2;
    private static int RESOLUTION_LEVEL_FINE = 3;
    private static int CAPABILITY_GNSS = 1;
    private Handler mGeofenceHandler;
    private Handler mCallbacksHandler;
    private Handler mReaperHandler;

    private static final synchronized GeofenceHardwareImpl $$robo$$android_hardware_location_GeofenceHardwareImpl$getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new GeofenceHardwareImpl(context);
        }
        return sInstance;
    }

    private void $$robo$$android_hardware_location_GeofenceHardwareImpl$__constructor__(Context context) {
        this.mGeofences = new SparseArray();
        this.mCallbacks = new ArrayList[2];
        this.mReapers = new ArrayList();
        this.mVersion = 1;
        this.mSupportedMonitorTypes = new int[2];
        this.mGeofenceHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GeofenceHardwareImpl this$0;

            private void $$robo$$android_hardware_location_GeofenceHardwareImpl_1$__constructor__(GeofenceHardwareImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_location_GeofenceHardwareImpl_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 2: {
                        IGeofenceHardwareCallback callback;
                        int geofenceId = msg.arg1;
                        SparseArray sparseArray = this.this$0.mGeofences;
                        synchronized (sparseArray) {
                            callback = (IGeofenceHardwareCallback)this.this$0.mGeofences.get(geofenceId);
                        }
                        if (callback != null) {
                            try {
                                callback.onGeofenceAdd(geofenceId, msg.arg2);
                            }
                            catch (RemoteException e2) {
                                Log.i("GeofenceHardwareImpl", "Remote Exception:" + e2);
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 3: {
                        IGeofenceHardwareCallback callback;
                        int geofenceId = msg.arg1;
                        SparseArray e2 = this.this$0.mGeofences;
                        synchronized (e2) {
                            callback = (IGeofenceHardwareCallback)this.this$0.mGeofences.get(geofenceId);
                        }
                        if (callback != null) {
                            try {
                                callback.onGeofenceRemove(geofenceId, msg.arg2);
                            }
                            catch (RemoteException e2) {
                                // empty catch block
                            }
                            IBinder callbackBinder22 = callback.asBinder();
                            boolean callbackInUse2 = false;
                            SparseArray sparseArray = this.this$0.mGeofences;
                            synchronized (sparseArray) {
                                this.this$0.mGeofences.remove(geofenceId);
                                for (int i = 0; i < this.this$0.mGeofences.size(); ++i) {
                                    if (((IGeofenceHardwareCallback)this.this$0.mGeofences.valueAt(i)).asBinder() != callbackBinder22) continue;
                                    callbackInUse2 = true;
                                    break;
                                }
                            }
                            if (!callbackInUse2) {
                                Iterator iterator = this.this$0.mReapers.iterator();
                                while (iterator.hasNext()) {
                                    Reaper reaper = (Reaper)iterator.next();
                                    if (reaper.mCallback == null || reaper.mCallback.asBinder() != callbackBinder22) continue;
                                    iterator.remove();
                                    reaper.unlinkToDeath();
                                    if (!DEBUG) continue;
                                    Log.d("GeofenceHardwareImpl", String.format("Removed reaper %s because binder %s is no longer needed.", reaper, callbackBinder22));
                                }
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 4: {
                        IGeofenceHardwareCallback callback;
                        int geofenceId = msg.arg1;
                        SparseArray callbackBinder22 = this.this$0.mGeofences;
                        synchronized (callbackBinder22) {
                            callback = (IGeofenceHardwareCallback)this.this$0.mGeofences.get(geofenceId);
                        }
                        if (callback != null) {
                            try {
                                callback.onGeofencePause(geofenceId, msg.arg2);
                            }
                            catch (RemoteException callbackBinder22) {
                                // empty catch block
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 5: {
                        IGeofenceHardwareCallback callback;
                        int geofenceId = msg.arg1;
                        SparseArray callbackBinder22 = this.this$0.mGeofences;
                        synchronized (callbackBinder22) {
                            callback = (IGeofenceHardwareCallback)this.this$0.mGeofences.get(geofenceId);
                        }
                        if (callback != null) {
                            try {
                                callback.onGeofenceResume(geofenceId, msg.arg2);
                            }
                            catch (RemoteException callbackBinder22) {
                                // empty catch block
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 1: {
                        IGeofenceHardwareCallback callback;
                        GeofenceTransition geofenceTransition = (GeofenceTransition)msg.obj;
                        SparseArray callbackInUse2 = this.this$0.mGeofences;
                        synchronized (callbackInUse2) {
                            callback = (IGeofenceHardwareCallback)this.this$0.mGeofences.get(geofenceTransition.mGeofenceId);
                            if (DEBUG) {
                                Log.d("GeofenceHardwareImpl", "GeofenceTransistionCallback: GPS : GeofenceId: " + geofenceTransition.mGeofenceId + " Transition: " + geofenceTransition.mTransition + " Location: " + geofenceTransition.mLocation + ":" + this.this$0.mGeofences);
                            }
                        }
                        if (callback != null) {
                            try {
                                callback.onGeofenceTransition(geofenceTransition.mGeofenceId, geofenceTransition.mTransition, geofenceTransition.mLocation, geofenceTransition.mTimestamp, geofenceTransition.mMonitoringType);
                            }
                            catch (RemoteException callbackInUse2) {
                                // empty catch block
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 6: {
                        IGeofenceHardwareCallback callback = (IGeofenceHardwareCallback)msg.obj;
                        if (DEBUG) {
                            Log.d("GeofenceHardwareImpl", "Geofence callback reaped:" + callback);
                        }
                        int monitoringType = msg.arg1;
                        SparseArray sparseArray = this.this$0.mGeofences;
                        synchronized (sparseArray) {
                            for (int i = 0; i < this.this$0.mGeofences.size(); ++i) {
                                if (!((IGeofenceHardwareCallback)this.this$0.mGeofences.valueAt(i)).equals(callback)) continue;
                                int geofenceId = this.this$0.mGeofences.keyAt(i);
                                this.this$0.removeGeofence(this.this$0.mGeofences.keyAt(i), monitoringType);
                                this.this$0.mGeofences.remove(geofenceId);
                            }
                            break;
                        }
                    }
                }
            }

            private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl) {
                this.$$robo$$android_hardware_location_GeofenceHardwareImpl_1$__constructor__(geofenceHardwareImpl);
            }
            {
                this.this$0 = geofenceHardwareImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_1$__constructor__(android.hardware.location.GeofenceHardwareImpl ), 0, this, geofenceHardwareImpl);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_location_GeofenceHardwareImpl_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallbacksHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GeofenceHardwareImpl this$0;

            private void $$robo$$android_hardware_location_GeofenceHardwareImpl_2$__constructor__(GeofenceHardwareImpl this$0) {
            }

            private final void $$robo$$android_hardware_location_GeofenceHardwareImpl_2$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        GeofenceHardwareMonitorEvent event = (GeofenceHardwareMonitorEvent)msg.obj;
                        ArrayList callbackList = this.this$0.mCallbacks[event.getMonitoringType()];
                        if (callbackList != null) {
                            if (DEBUG) {
                                Log.d("GeofenceHardwareImpl", "MonitoringSystemChangeCallback: " + event);
                            }
                            for (IGeofenceHardwareMonitorCallback c : callbackList) {
                                try {
                                    c.onMonitoringSystemChange(event);
                                }
                                catch (RemoteException e) {
                                    Log.d("GeofenceHardwareImpl", "Error reporting onMonitoringSystemChange.", e);
                                }
                            }
                        }
                        this.this$0.releaseWakeLock();
                        break;
                    }
                    case 2: {
                        int monitoringType = msg.arg1;
                        IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                        ArrayList<IGeofenceHardwareMonitorCallback> callbackList = this.this$0.mCallbacks[monitoringType];
                        if (callbackList == null) {
                            ((GeofenceHardwareImpl)this.this$0).mCallbacks[monitoringType] = callbackList = new ArrayList<IGeofenceHardwareMonitorCallback>();
                        }
                        if (callbackList.contains(callback)) break;
                        callbackList.add(callback);
                        break;
                    }
                    case 3: {
                        int monitoringType = msg.arg1;
                        IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                        ArrayList callbackList = this.this$0.mCallbacks[monitoringType];
                        if (callbackList == null) break;
                        callbackList.remove(callback);
                        break;
                    }
                    case 4: {
                        ArrayList callbackList;
                        IGeofenceHardwareMonitorCallback callback = (IGeofenceHardwareMonitorCallback)msg.obj;
                        if (DEBUG) {
                            Log.d("GeofenceHardwareImpl", "Monitor callback reaped:" + callback);
                        }
                        if ((callbackList = this.this$0.mCallbacks[msg.arg1]) == null || !callbackList.contains(callback)) break;
                        callbackList.remove(callback);
                    }
                }
            }

            private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl) {
                this.$$robo$$android_hardware_location_GeofenceHardwareImpl_2$__constructor__(geofenceHardwareImpl);
            }
            {
                this.this$0 = geofenceHardwareImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_2$__constructor__(android.hardware.location.GeofenceHardwareImpl ), 0, this, geofenceHardwareImpl);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_location_GeofenceHardwareImpl_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mReaperHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GeofenceHardwareImpl this$0;

            private void $$robo$$android_hardware_location_GeofenceHardwareImpl_3$__constructor__(GeofenceHardwareImpl this$0) {
            }

            private final void $$robo$$android_hardware_location_GeofenceHardwareImpl_3$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        IGeofenceHardwareCallback callback = (IGeofenceHardwareCallback)msg.obj;
                        int monitoringType = msg.arg1;
                        Reaper r = new Reaper(this.this$0, callback, monitoringType);
                        if (this.this$0.mReapers.contains(r)) break;
                        this.this$0.mReapers.add(r);
                        IBinder b = callback.asBinder();
                        try {
                            b.linkToDeath(r, 0);
                        }
                        catch (RemoteException remoteException) {}
                        break;
                    }
                    case 2: {
                        IGeofenceHardwareMonitorCallback monitorCallback = (IGeofenceHardwareMonitorCallback)msg.obj;
                        int monitoringType = msg.arg1;
                        Reaper r = new Reaper(this.this$0, monitorCallback, monitoringType);
                        if (this.this$0.mReapers.contains(r)) break;
                        this.this$0.mReapers.add(r);
                        IBinder b = monitorCallback.asBinder();
                        try {
                            b.linkToDeath(r, 0);
                        }
                        catch (RemoteException remoteException) {}
                        break;
                    }
                    case 3: {
                        Reaper r = (Reaper)msg.obj;
                        this.this$0.mReapers.remove(r);
                    }
                }
            }

            private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl) {
                this.$$robo$$android_hardware_location_GeofenceHardwareImpl_3$__constructor__(geofenceHardwareImpl);
            }
            {
                this.this$0 = geofenceHardwareImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_3$__constructor__(android.hardware.location.GeofenceHardwareImpl ), 0, this, geofenceHardwareImpl);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_location_GeofenceHardwareImpl_3$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.setMonitorAvailability(0, 2);
        this.setMonitorAvailability(1, 2);
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$acquireWakeLock() {
        if (this.mWakeLock == null) {
            PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
            this.mWakeLock = powerManager.newWakeLock(1, "GeofenceHardwareImpl");
        }
        this.mWakeLock.acquire();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$releaseWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$updateGpsHardwareAvailability() {
        boolean gpsSupported;
        try {
            gpsSupported = this.mGpsService.isHardwareGeofenceSupported();
        }
        catch (RemoteException e) {
            Log.e("GeofenceHardwareImpl", "Remote Exception calling LocationManagerService");
            gpsSupported = false;
        }
        if (gpsSupported) {
            this.setMonitorAvailability(0, 0);
        }
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$updateFusedHardwareAvailability() {
        boolean fusedSupported;
        try {
            boolean hasGnnsCapabilities;
            boolean bl = hasGnnsCapabilities = this.mVersion < 2 || (this.mCapabilities & 1) != 0;
            fusedSupported = this.mFusedService != null ? this.mFusedService.isSupported() && hasGnnsCapabilities : false;
        }
        catch (RemoteException e) {
            Log.e("GeofenceHardwareImpl", "RemoteException calling LocationManagerService");
            fusedSupported = false;
        }
        if (fusedSupported) {
            this.setMonitorAvailability(1, 0);
        }
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$setGpsHardwareGeofence(IGpsGeofenceHardware service) {
        if (this.mGpsService == null) {
            this.mGpsService = service;
            this.updateGpsHardwareAvailability();
        } else if (service == null) {
            this.mGpsService = null;
            Log.w("GeofenceHardwareImpl", "GPS Geofence Hardware service seems to have crashed");
        } else {
            Log.e("GeofenceHardwareImpl", "Error: GpsService being set again.");
        }
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$onCapabilities(int capabilities) {
        this.mCapabilities = capabilities;
        this.updateFusedHardwareAvailability();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$setVersion(int version) {
        this.mVersion = version;
        this.updateFusedHardwareAvailability();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$setFusedGeofenceHardware(IFusedGeofenceHardware service) {
        if (this.mFusedService == null) {
            this.mFusedService = service;
            this.updateFusedHardwareAvailability();
        } else if (service == null) {
            this.mFusedService = null;
            Log.w("GeofenceHardwareImpl", "Fused Geofence Hardware service seems to have crashed");
        } else {
            Log.e("GeofenceHardwareImpl", "Error: FusedService being set again");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_hardware_location_GeofenceHardwareImpl$getMonitoringTypes() {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            boolean gpsSupported = this.mSupportedMonitorTypes[0] != 2;
            boolean fusedSupported = this.mSupportedMonitorTypes[1] != 2;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (gpsSupported) {
                if (fusedSupported) {
                    return new int[]{0, 1};
                }
                return new int[]{0};
            }
            if (fusedSupported) {
                return new int[]{1};
            }
            return new int[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_location_GeofenceHardwareImpl$getStatusOfMonitoringType(int monitoringType) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            if (monitoringType >= this.mSupportedMonitorTypes.length || monitoringType < 0) {
                throw new IllegalArgumentException("Unknown monitoring type");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mSupportedMonitorTypes[monitoringType];
        }
    }

    private final int $$robo$$android_hardware_location_GeofenceHardwareImpl$getCapabilitiesForMonitoringType(int monitoringType) {
        switch (this.mSupportedMonitorTypes[monitoringType]) {
            case 0: {
                switch (monitoringType) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        if (this.mVersion >= 2) {
                            return this.mCapabilities;
                        }
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$addCircularFence(int monitoringType, GeofenceHardwareRequestParcelable request, IGeofenceHardwareCallback callback) {
        boolean result;
        int geofenceId = request.getId();
        if (DEBUG) {
            String message = String.format("addCircularFence: monitoringType=%d, %s", monitoringType, request);
            Log.d("GeofenceHardwareImpl", message);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            this.mGeofences.put(geofenceId, callback);
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.addCircularHardwareGeofence(request.getId(), request.getLatitude(), request.getLongitude(), request.getRadius(), request.getLastTransition(), request.getMonitorTransitions(), request.getNotificationResponsiveness(), request.getUnknownTimer());
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "AddGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.addGeofences(new GeofenceHardwareRequestParcelable[]{request});
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "AddGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (result) {
            Message m = this.mReaperHandler.obtainMessage(1, callback);
            m.arg1 = monitoringType;
            this.mReaperHandler.sendMessage(m);
        } else {
            sparseArray = this.mGeofences;
            synchronized (sparseArray) {
                this.mGeofences.remove(geofenceId);
            }
        }
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "addCircularFence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$removeGeofence(int geofenceId, int monitoringType) {
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "Remove Geofence: GeofenceId: " + geofenceId);
        }
        boolean result = false;
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.removeHardwareGeofence(geofenceId);
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "RemoveGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.removeGeofences(new int[]{geofenceId});
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "RemoveGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "removeGeofence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$pauseGeofence(int geofenceId, int monitoringType) {
        boolean result;
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "Pause Geofence: GeofenceId: " + geofenceId);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.pauseHardwareGeofence(geofenceId);
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "PauseGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.pauseMonitoringGeofence(geofenceId);
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "PauseGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "pauseGeofence: Result is: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$resumeGeofence(int geofenceId, int monitoringType, int monitorTransition) {
        boolean result;
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "Resume Geofence: GeofenceId: " + geofenceId);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(geofenceId) == null) {
                throw new IllegalArgumentException("Geofence " + geofenceId + " not registered.");
            }
        }
        switch (monitoringType) {
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    result = this.mGpsService.resumeHardwareGeofence(geofenceId, monitorTransition);
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "ResumeGeofence: Remote Exception calling LocationManagerService");
                    result = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.resumeMonitoringGeofence(geofenceId, monitorTransition);
                    result = true;
                }
                catch (RemoteException e) {
                    Log.e("GeofenceHardwareImpl", "ResumeGeofence: RemoteException calling LocationManagerService");
                    result = false;
                }
                break;
            }
            default: {
                result = false;
            }
        }
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "resumeGeofence: Result is: " + result);
        }
        return result;
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$registerForMonitorStateChangeCallback(int monitoringType, IGeofenceHardwareMonitorCallback callback) {
        Message reaperMessage = this.mReaperHandler.obtainMessage(2, callback);
        reaperMessage.arg1 = monitoringType;
        this.mReaperHandler.sendMessage(reaperMessage);
        Message m = this.mCallbacksHandler.obtainMessage(2, callback);
        m.arg1 = monitoringType;
        this.mCallbacksHandler.sendMessage(m);
        return true;
    }

    private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl$unregisterForMonitorStateChangeCallback(int monitoringType, IGeofenceHardwareMonitorCallback callback) {
        Message m = this.mCallbacksHandler.obtainMessage(3, callback);
        m.arg1 = monitoringType;
        this.mCallbacksHandler.sendMessage(m);
        return true;
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceTransition(int geofenceId, Location location, int transition2, long transitionTimestamp, int monitoringType, int sourcesUsed) {
        if (location == null) {
            Log.e("GeofenceHardwareImpl", String.format("Invalid Geofence Transition: location=null", new Object[0]));
            return;
        }
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "GeofenceTransition| " + location + ", transition:" + transition2 + ", transitionTimestamp:" + transitionTimestamp + ", monitoringType:" + monitoringType + ", sourcesUsed:" + sourcesUsed);
        }
        GeofenceTransition geofenceTransition = new GeofenceTransition(this, geofenceId, transition2, transitionTimestamp, location, monitoringType, sourcesUsed);
        this.acquireWakeLock();
        Message message = this.mGeofenceHandler.obtainMessage(1, geofenceTransition);
        message.sendToTarget();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceMonitorStatus(int monitoringType, int monitoringStatus, Location location, int source) {
        this.setMonitorAvailability(monitoringType, monitoringStatus);
        this.acquireWakeLock();
        GeofenceHardwareMonitorEvent event = new GeofenceHardwareMonitorEvent(monitoringType, monitoringStatus, source, location);
        Message message = this.mCallbacksHandler.obtainMessage(1, event);
        message.sendToTarget();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceOperationStatus(int operation, int geofenceId, int operationStatus) {
        this.acquireWakeLock();
        Message message = this.mGeofenceHandler.obtainMessage(operation);
        message.arg1 = geofenceId;
        message.arg2 = operationStatus;
        message.sendToTarget();
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceAddStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "AddCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(2, geofenceId, status);
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceRemoveStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "RemoveCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(3, geofenceId, status);
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofencePauseStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "PauseCallbac| id:" + geofenceId + ", status" + status);
        }
        this.reportGeofenceOperationStatus(4, geofenceId, status);
    }

    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceResumeStatus(int geofenceId, int status) {
        if (DEBUG) {
            Log.d("GeofenceHardwareImpl", "ResumeCallback| id:" + geofenceId + ", status:" + status);
        }
        this.reportGeofenceOperationStatus(5, geofenceId, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_location_GeofenceHardwareImpl$setMonitorAvailability(int monitor, int val) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (this.mSupportedMonitorTypes) {
            this.mSupportedMonitorTypes[monitor] = val;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private final int $$robo$$android_hardware_location_GeofenceHardwareImpl$getMonitoringResolutionLevel(int monitoringType) {
        switch (monitoringType) {
            case 0: {
                return 3;
            }
            case 1: {
                return 3;
            }
        }
        return 1;
    }

    private final int $$robo$$android_hardware_location_GeofenceHardwareImpl$getAllowedResolutionLevel(int pid, int uid) {
        if (this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", pid, uid) == 0) {
            return 3;
        }
        if (this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid) == 0) {
            return 2;
        }
        return 1;
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("GeofenceHardwareImpl", 3);
    }

    public static synchronized GeofenceHardwareImpl getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_hardware_location_GeofenceHardwareImpl$getInstance(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_hardware_location_GeofenceHardwareImpl$__constructor__(context);
    }

    private GeofenceHardwareImpl(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl$__constructor__(android.content.Context ), 0, this, context);
    }

    private void acquireWakeLock() {
        InvokeDynamicSupport.bootstrap("acquireWakeLock", $$robo$$android_hardware_location_GeofenceHardwareImpl$acquireWakeLock(), 0, this);
    }

    private void releaseWakeLock() {
        InvokeDynamicSupport.bootstrap("releaseWakeLock", $$robo$$android_hardware_location_GeofenceHardwareImpl$releaseWakeLock(), 0, this);
    }

    private void updateGpsHardwareAvailability() {
        InvokeDynamicSupport.bootstrap("updateGpsHardwareAvailability", $$robo$$android_hardware_location_GeofenceHardwareImpl$updateGpsHardwareAvailability(), 0, this);
    }

    private void updateFusedHardwareAvailability() {
        InvokeDynamicSupport.bootstrap("updateFusedHardwareAvailability", $$robo$$android_hardware_location_GeofenceHardwareImpl$updateFusedHardwareAvailability(), 0, this);
    }

    public void setGpsHardwareGeofence(IGpsGeofenceHardware iGpsGeofenceHardware) {
        InvokeDynamicSupport.bootstrap("setGpsHardwareGeofence", $$robo$$android_hardware_location_GeofenceHardwareImpl$setGpsHardwareGeofence(android.location.IGpsGeofenceHardware ), 0, this, iGpsGeofenceHardware);
    }

    public void onCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("onCapabilities", $$robo$$android_hardware_location_GeofenceHardwareImpl$onCapabilities(int ), 0, this, n);
    }

    public void setVersion(int n) {
        InvokeDynamicSupport.bootstrap("setVersion", $$robo$$android_hardware_location_GeofenceHardwareImpl$setVersion(int ), 0, this, n);
    }

    public void setFusedGeofenceHardware(IFusedGeofenceHardware iFusedGeofenceHardware) {
        InvokeDynamicSupport.bootstrap("setFusedGeofenceHardware", $$robo$$android_hardware_location_GeofenceHardwareImpl$setFusedGeofenceHardware(android.location.IFusedGeofenceHardware ), 0, this, iFusedGeofenceHardware);
    }

    public int[] getMonitoringTypes() {
        return InvokeDynamicSupport.bootstrap("getMonitoringTypes", $$robo$$android_hardware_location_GeofenceHardwareImpl$getMonitoringTypes(), 0, this);
    }

    public int getStatusOfMonitoringType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStatusOfMonitoringType", $$robo$$android_hardware_location_GeofenceHardwareImpl$getStatusOfMonitoringType(int ), 0, this, n);
    }

    public int getCapabilitiesForMonitoringType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCapabilitiesForMonitoringType", $$robo$$android_hardware_location_GeofenceHardwareImpl$getCapabilitiesForMonitoringType(int ), 0, this, n);
    }

    public boolean addCircularFence(int n, GeofenceHardwareRequestParcelable geofenceHardwareRequestParcelable, IGeofenceHardwareCallback iGeofenceHardwareCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("addCircularFence", $$robo$$android_hardware_location_GeofenceHardwareImpl$addCircularFence(int android.hardware.location.GeofenceHardwareRequestParcelable android.hardware.location.IGeofenceHardwareCallback ), 0, this, n, geofenceHardwareRequestParcelable, iGeofenceHardwareCallback);
    }

    public boolean removeGeofence(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeGeofence", $$robo$$android_hardware_location_GeofenceHardwareImpl$removeGeofence(int int ), 0, this, n, n2);
    }

    public boolean pauseGeofence(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("pauseGeofence", $$robo$$android_hardware_location_GeofenceHardwareImpl$pauseGeofence(int int ), 0, this, n, n2);
    }

    public boolean resumeGeofence(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("resumeGeofence", $$robo$$android_hardware_location_GeofenceHardwareImpl$resumeGeofence(int int int ), 0, this, n, n2, n3);
    }

    public boolean registerForMonitorStateChangeCallback(int n, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerForMonitorStateChangeCallback", $$robo$$android_hardware_location_GeofenceHardwareImpl$registerForMonitorStateChangeCallback(int android.hardware.location.IGeofenceHardwareMonitorCallback ), 0, this, n, iGeofenceHardwareMonitorCallback);
    }

    public boolean unregisterForMonitorStateChangeCallback(int n, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterForMonitorStateChangeCallback", $$robo$$android_hardware_location_GeofenceHardwareImpl$unregisterForMonitorStateChangeCallback(int android.hardware.location.IGeofenceHardwareMonitorCallback ), 0, this, n, iGeofenceHardwareMonitorCallback);
    }

    public void reportGeofenceTransition(int n, Location location, int n2, long l, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("reportGeofenceTransition", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceTransition(int android.location.Location int long int int ), 0, this, n, location, n2, l, n3, n4);
    }

    public void reportGeofenceMonitorStatus(int n, int n2, Location location, int n3) {
        InvokeDynamicSupport.bootstrap("reportGeofenceMonitorStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceMonitorStatus(int int android.location.Location int ), 0, this, n, n2, location, n3);
    }

    private void reportGeofenceOperationStatus(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("reportGeofenceOperationStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceOperationStatus(int int int ), 0, this, n, n2, n3);
    }

    public void reportGeofenceAddStatus(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportGeofenceAddStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceAddStatus(int int ), 0, this, n, n2);
    }

    public void reportGeofenceRemoveStatus(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportGeofenceRemoveStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceRemoveStatus(int int ), 0, this, n, n2);
    }

    public void reportGeofencePauseStatus(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportGeofencePauseStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofencePauseStatus(int int ), 0, this, n, n2);
    }

    public void reportGeofenceResumeStatus(int n, int n2) {
        InvokeDynamicSupport.bootstrap("reportGeofenceResumeStatus", $$robo$$android_hardware_location_GeofenceHardwareImpl$reportGeofenceResumeStatus(int int ), 0, this, n, n2);
    }

    private void setMonitorAvailability(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setMonitorAvailability", $$robo$$android_hardware_location_GeofenceHardwareImpl$setMonitorAvailability(int int ), 0, this, n, n2);
    }

    int getMonitoringResolutionLevel(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMonitoringResolutionLevel", $$robo$$android_hardware_location_GeofenceHardwareImpl$getMonitoringResolutionLevel(int ), 0, this, n);
    }

    int getAllowedResolutionLevel(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getAllowedResolutionLevel", $$robo$$android_hardware_location_GeofenceHardwareImpl$getAllowedResolutionLevel(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(GeofenceHardwareImpl.class);
    }

    public /* synthetic */ GeofenceHardwareImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeofenceHardwareImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Reaper
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IGeofenceHardwareMonitorCallback mMonitorCallback;
        private IGeofenceHardwareCallback mCallback;
        private int mMonitoringType;
        /* synthetic */ GeofenceHardwareImpl this$0;

        private void $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(GeofenceHardwareImpl this$0, IGeofenceHardwareCallback c, int monitoringType) {
            this.mCallback = c;
            this.mMonitoringType = monitoringType;
        }

        private void $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(GeofenceHardwareImpl this$0, IGeofenceHardwareMonitorCallback c, int monitoringType) {
            this.mMonitorCallback = c;
            this.mMonitoringType = monitoringType;
        }

        private final void $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$binderDied() {
            if (this.mCallback != null) {
                Message m = this.this$0.mGeofenceHandler.obtainMessage(6, this.mCallback);
                m.arg1 = this.mMonitoringType;
                this.this$0.mGeofenceHandler.sendMessage(m);
            } else if (this.mMonitorCallback != null) {
                Message m = this.this$0.mCallbacksHandler.obtainMessage(4, this.mMonitorCallback);
                m.arg1 = this.mMonitoringType;
                this.this$0.mCallbacksHandler.sendMessage(m);
            }
            Message reaperMessage = this.this$0.mReaperHandler.obtainMessage(3, this);
            this.this$0.mReaperHandler.sendMessage(reaperMessage);
        }

        private final int $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$hashCode() {
            int result = 17;
            result = 31 * result + (this.mCallback != null ? this.mCallback.asBinder().hashCode() : 0);
            result = 31 * result + (this.mMonitorCallback != null ? this.mMonitorCallback.asBinder().hashCode() : 0);
            result = 31 * result + this.mMonitoringType;
            return result;
        }

        private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            Reaper rhs = (Reaper)obj;
            return this.binderEquals(rhs.mCallback, this.mCallback) && this.binderEquals(rhs.mMonitorCallback, this.mMonitorCallback) && rhs.mMonitoringType == this.mMonitoringType;
        }

        private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$binderEquals(IInterface left, IInterface right) {
            if (left == null) {
                return right == null;
            }
            return right == null ? false : left.asBinder() == right.asBinder();
        }

        private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$unlinkToDeath() {
            if (this.mMonitorCallback != null) {
                return this.mMonitorCallback.asBinder().unlinkToDeath(this, 0);
            }
            if (this.mCallback != null) {
                return this.mCallback.asBinder().unlinkToDeath(this, 0);
            }
            return true;
        }

        private final boolean $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$callbackEquals(IGeofenceHardwareCallback cb) {
            return this.mCallback != null && this.mCallback.asBinder() == cb.asBinder();
        }

        private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl, IGeofenceHardwareCallback iGeofenceHardwareCallback, int n) {
            this.$$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(geofenceHardwareImpl, iGeofenceHardwareCallback, n);
        }

        Reaper(GeofenceHardwareImpl geofenceHardwareImpl, IGeofenceHardwareCallback iGeofenceHardwareCallback, int n) {
            this.this$0 = geofenceHardwareImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(android.hardware.location.GeofenceHardwareImpl android.hardware.location.IGeofenceHardwareCallback int ), 0, this, geofenceHardwareImpl, iGeofenceHardwareCallback, n);
        }

        private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback, int n) {
            this.$$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(geofenceHardwareImpl, iGeofenceHardwareMonitorCallback, n);
        }

        Reaper(GeofenceHardwareImpl geofenceHardwareImpl, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback, int n) {
            this.this$0 = geofenceHardwareImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$__constructor__(android.hardware.location.GeofenceHardwareImpl android.hardware.location.IGeofenceHardwareMonitorCallback int ), 0, this, geofenceHardwareImpl, iGeofenceHardwareMonitorCallback, n);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$binderDied(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$equals(java.lang.Object ), 0, this, object);
        }

        private boolean binderEquals(IInterface iInterface, IInterface iInterface2) {
            return (boolean)InvokeDynamicSupport.bootstrap("binderEquals", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$binderEquals(android.os.IInterface android.os.IInterface ), 0, this, iInterface, iInterface2);
        }

        private boolean unlinkToDeath() {
            return (boolean)InvokeDynamicSupport.bootstrap("unlinkToDeath", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$unlinkToDeath(), 0, this);
        }

        private boolean callbackEquals(IGeofenceHardwareCallback iGeofenceHardwareCallback) {
            return (boolean)InvokeDynamicSupport.bootstrap("callbackEquals", $$robo$$android_hardware_location_GeofenceHardwareImpl_Reaper$callbackEquals(android.hardware.location.IGeofenceHardwareCallback ), 0, this, iGeofenceHardwareCallback);
        }

        public /* synthetic */ Reaper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Reaper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class GeofenceTransition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mGeofenceId;
        private int mTransition;
        private long mTimestamp;
        private Location mLocation;
        private int mMonitoringType;
        private int mSourcesUsed;
        /* synthetic */ GeofenceHardwareImpl this$0;

        private void $$robo$$android_hardware_location_GeofenceHardwareImpl_GeofenceTransition$__constructor__(GeofenceHardwareImpl geofenceHardwareImpl, int geofenceId, int transition2, long timestamp, Location location, int monitoringType, int sourcesUsed) {
            this.mGeofenceId = geofenceId;
            this.mTransition = transition2;
            this.mTimestamp = timestamp;
            this.mLocation = location;
            this.mMonitoringType = monitoringType;
            this.mSourcesUsed = sourcesUsed;
        }

        private void __constructor__(GeofenceHardwareImpl geofenceHardwareImpl, int n, int n2, long l, Location location, int n3, int n4) {
            this.$$robo$$android_hardware_location_GeofenceHardwareImpl_GeofenceTransition$__constructor__(geofenceHardwareImpl, n, n2, l, location, n3, n4);
        }

        GeofenceTransition(GeofenceHardwareImpl geofenceHardwareImpl, int n, int n2, long l, Location location, int n3, int n4) {
            this.this$0 = geofenceHardwareImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_GeofenceHardwareImpl_GeofenceTransition$__constructor__(android.hardware.location.GeofenceHardwareImpl int int long android.location.Location int int ), 0, this, geofenceHardwareImpl, n, n2, l, location, n3, n4);
        }

        public /* synthetic */ GeofenceTransition() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeofenceTransition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

