/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.CacheValue;
import android.icu.impl.ICUBinary;
import android.icu.impl.ICUData;
import android.icu.impl.SoftCache;
import android.icu.impl.UResource;
import android.icu.util.ICUException;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.ULocale;
import android.icu.util.UResourceTypeMismatchException;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ICUResourceBundleReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int DATA_FORMAT = 1382380354;
    private static IsAcceptable IS_ACCEPTABLE;
    private static int URES_INDEX_LENGTH = 0;
    private static int URES_INDEX_KEYS_TOP = 1;
    private static int URES_INDEX_BUNDLE_TOP = 3;
    private static int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static int URES_INDEX_ATTRIBUTES = 5;
    private static int URES_INDEX_16BIT_TOP = 6;
    private static int URES_INDEX_POOL_CHECKSUM = 7;
    private static int URES_ATT_NO_FALLBACK = 1;
    private static int URES_ATT_IS_POOL_BUNDLE = 2;
    private static int URES_ATT_USES_POOL_BUNDLE = 4;
    private static CharBuffer EMPTY_16_BIT_UNITS;
    static int LARGE_SIZE = 24;
    private static boolean DEBUG = false;
    private int dataVersion;
    private ByteBuffer bytes;
    private byte[] keyBytes;
    private CharBuffer b16BitUnits;
    private ICUResourceBundleReader poolBundleReader;
    private int rootRes;
    private int localKeyLimit;
    private int poolStringIndexLimit;
    private int poolStringIndex16Limit;
    private boolean noFallback;
    private boolean isPoolBundle;
    private boolean usesPoolBundle;
    private int poolCheckSum;
    private ResourceCache resourceCache;
    private static ReaderCache CACHE;
    private static ICUResourceBundleReader NULL_READER;
    private static byte[] emptyBytes;
    private static ByteBuffer emptyByteBuffer;
    private static char[] emptyChars;
    private static int[] emptyInts;
    private static String emptyString = "";
    private static Array EMPTY_ARRAY;
    private static Table EMPTY_TABLE;
    private static int[] PUBLIC_TYPES;
    private static String ICU_RESOURCE_SUFFIX = ".res";
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__() {
    }

    private void $$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(ByteBuffer inBytes, String baseName, String localeID, ClassLoader loader) throws IOException {
        this.init(inBytes);
        if (this.usesPoolBundle) {
            this.poolBundleReader = ICUResourceBundleReader.getReader(baseName, "pool", loader);
            if (!this.poolBundleReader.isPoolBundle) {
                throw new IllegalStateException("pool.res is not a pool bundle");
            }
            if (this.poolBundleReader.poolCheckSum != this.poolCheckSum) {
                throw new IllegalStateException("pool.res has a different checksum than this bundle");
            }
        }
    }

    private static final ICUResourceBundleReader $$robo$$android_icu_impl_ICUResourceBundleReader$getReader(String baseName, String localeID, ClassLoader root) {
        ReaderCacheKey info = new ReaderCacheKey(baseName, localeID);
        ICUResourceBundleReader reader = (ICUResourceBundleReader)CACHE.getInstance(info, root);
        if (reader == NULL_READER) {
            return null;
        }
        return reader;
    }

    private final void $$robo$$android_icu_impl_ICUResourceBundleReader$init(ByteBuffer inBytes) throws IOException {
        int bundleTop;
        this.dataVersion = ICUBinary.readHeader(inBytes, 1382380354, IS_ACCEPTABLE);
        byte majorFormatVersion = inBytes.get(16);
        this.bytes = ICUBinary.sliceWithOrder(inBytes);
        int dataLength = this.bytes.remaining();
        this.rootRes = this.bytes.getInt(0);
        int indexes0 = this.getIndexesInt(0);
        int indexLength = indexes0 & 0xFF;
        if (indexLength <= 4) {
            throw new ICUException("not enough indexes");
        }
        if (dataLength < 1 + indexLength << 2 || dataLength < (bundleTop = this.getIndexesInt(3)) << 2) {
            throw new ICUException("not enough bytes");
        }
        int maxOffset = bundleTop - 1;
        if (majorFormatVersion >= 3) {
            this.poolStringIndexLimit = indexes0 >>> 8;
        }
        if (indexLength > 5) {
            int att = this.getIndexesInt(5);
            this.noFallback = (att & 1) != 0;
            this.isPoolBundle = (att & 2) != 0;
            this.usesPoolBundle = (att & 4) != 0;
            this.poolStringIndexLimit |= (att & 0xF000) << 12;
            this.poolStringIndex16Limit = att >>> 16;
        }
        int keysBottom = 1 + indexLength;
        int keysTop = this.getIndexesInt(1);
        if (keysTop > keysBottom) {
            if (this.isPoolBundle) {
                this.keyBytes = new byte[keysTop - keysBottom << 2];
                this.bytes.position(keysBottom << 2);
            } else {
                this.localKeyLimit = keysTop << 2;
                this.keyBytes = new byte[this.localKeyLimit];
            }
            this.bytes.get(this.keyBytes);
        }
        if (indexLength > 6) {
            int _16BitTop = this.getIndexesInt(6);
            if (_16BitTop > keysTop) {
                int num16BitUnits = (_16BitTop - keysTop) * 2;
                this.bytes.position(keysTop << 2);
                this.b16BitUnits = this.bytes.asCharBuffer();
                this.b16BitUnits.limit(num16BitUnits);
                maxOffset |= num16BitUnits - 1;
            } else {
                this.b16BitUnits = EMPTY_16_BIT_UNITS;
            }
        } else {
            this.b16BitUnits = EMPTY_16_BIT_UNITS;
        }
        if (indexLength > 7) {
            this.poolCheckSum = this.getIndexesInt(7);
        }
        if (!this.isPoolBundle || this.b16BitUnits.length() > 1) {
            this.resourceCache = new ResourceCache(maxOffset);
        }
        this.bytes.position(0);
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getIndexesInt(int i) {
        return this.bytes.getInt(1 + i << 2);
    }

    private final VersionInfo $$robo$$android_icu_impl_ICUResourceBundleReader$getVersion() {
        return ICUBinary.getVersionInfoFromCompactInt(this.dataVersion);
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getRootResource() {
        return this.rootRes;
    }

    private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$getNoFallback() {
        return this.noFallback;
    }

    private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$getUsesPoolBundle() {
        return this.usesPoolBundle;
    }

    private static final int $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_TYPE(int res) {
        return res >>> 28;
    }

    private static final int $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_OFFSET(int res) {
        return res & 0xFFFFFFF;
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getResourceByteOffset(int offset) {
        return offset << 2;
    }

    private static final int $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_INT(int res) {
        return res << 4 >> 4;
    }

    private static final int $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_UINT(int res) {
        return res & 0xFFFFFFF;
    }

    private static final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$URES_IS_ARRAY(int type) {
        return type == 8 || type == 9;
    }

    private static final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$URES_IS_TABLE(int type) {
        return type == 2 || type == 5 || type == 4;
    }

    private final char[] $$robo$$android_icu_impl_ICUResourceBundleReader$getChars(int offset, int count) {
        char[] chars = new char[count];
        if (count <= 16) {
            for (int i = 0; i < count; ++i) {
                chars[i] = this.bytes.getChar(offset);
                offset += 2;
            }
        } else {
            CharBuffer temp = this.bytes.asCharBuffer();
            temp.position(offset / 2);
            temp.get(chars);
        }
        return chars;
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getInt(int offset) {
        return this.bytes.getInt(offset);
    }

    private final int[] $$robo$$android_icu_impl_ICUResourceBundleReader$getInts(int offset, int count) {
        int[] ints = new int[count];
        if (count <= 16) {
            for (int i = 0; i < count; ++i) {
                ints[i] = this.bytes.getInt(offset);
                offset += 4;
            }
        } else {
            IntBuffer temp = this.bytes.asIntBuffer();
            temp.position(offset / 4);
            temp.get(ints);
        }
        return ints;
    }

    private final char[] $$robo$$android_icu_impl_ICUResourceBundleReader$getTable16KeyOffsets(int offset) {
        int length;
        if ((length = this.b16BitUnits.charAt(offset++)) > 0) {
            char[] result = new char[length];
            if (length <= 16) {
                for (int i = 0; i < length; ++i) {
                    result[i] = this.b16BitUnits.charAt(offset++);
                }
            } else {
                CharBuffer temp = this.b16BitUnits.duplicate();
                temp.position(offset);
                temp.get(result);
            }
            return result;
        }
        return emptyChars;
    }

    private final char[] $$robo$$android_icu_impl_ICUResourceBundleReader$getTableKeyOffsets(int offset) {
        char length = this.bytes.getChar(offset);
        if (length > '\u0000') {
            return this.getChars(offset + 2, length);
        }
        return emptyChars;
    }

    private final int[] $$robo$$android_icu_impl_ICUResourceBundleReader$getTable32KeyOffsets(int offset) {
        int length = this.getInt(offset);
        if (length > 0) {
            return this.getInts(offset + 4, length);
        }
        return emptyInts;
    }

    private static final String $$robo$$android_icu_impl_ICUResourceBundleReader$makeKeyStringFromBytes(byte[] keyBytes, int keyOffset) {
        byte b;
        StringBuilder sb = new StringBuilder();
        while ((b = keyBytes[keyOffset]) != 0) {
            ++keyOffset;
            sb.append((char)b);
        }
        return sb.toString();
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$getKey16String(int keyOffset) {
        if (keyOffset < this.localKeyLimit) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.keyBytes, keyOffset);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleReader.keyBytes, keyOffset - this.localKeyLimit);
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$getKey32String(int keyOffset) {
        if (keyOffset >= 0) {
            return ICUResourceBundleReader.makeKeyStringFromBytes(this.keyBytes, keyOffset);
        }
        return ICUResourceBundleReader.makeKeyStringFromBytes(this.poolBundleReader.keyBytes, keyOffset & Integer.MAX_VALUE);
    }

    private final void $$robo$$android_icu_impl_ICUResourceBundleReader$setKeyFromKey16(int keyOffset, UResource.Key key) {
        if (keyOffset < this.localKeyLimit) {
            key.setBytes(this.keyBytes, keyOffset);
        } else {
            key.setBytes(this.poolBundleReader.keyBytes, keyOffset - this.localKeyLimit);
        }
    }

    private final void $$robo$$android_icu_impl_ICUResourceBundleReader$setKeyFromKey32(int keyOffset, UResource.Key key) {
        if (keyOffset >= 0) {
            key.setBytes(this.keyBytes, keyOffset);
        } else {
            key.setBytes(this.poolBundleReader.keyBytes, keyOffset & Integer.MAX_VALUE);
        }
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$compareKeys(CharSequence key, char keyOffset) {
        if (keyOffset < this.localKeyLimit) {
            return ICUBinary.compareKeys(key, this.keyBytes, (int)keyOffset);
        }
        return ICUBinary.compareKeys(key, this.poolBundleReader.keyBytes, keyOffset - this.localKeyLimit);
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$compareKeys32(CharSequence key, int keyOffset) {
        if (keyOffset >= 0) {
            return ICUBinary.compareKeys(key, this.keyBytes, keyOffset);
        }
        return ICUBinary.compareKeys(key, this.poolBundleReader.keyBytes, keyOffset & Integer.MAX_VALUE);
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$getStringV2(int res) {
        String s;
        if (!$assertionsDisabled && ICUResourceBundleReader.RES_GET_TYPE(res) != 6) {
            throw new AssertionError();
        }
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (!$assertionsDisabled && offset == 0) {
            throw new AssertionError();
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (String)value;
        }
        char first = this.b16BitUnits.charAt(offset);
        if ((first & 0xFFFFFC00) != 56320) {
            char c;
            if (first == '\u0000') {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            while ((c = this.b16BitUnits.charAt(++offset)) != '\u0000') {
                sb.append(c);
            }
            s = sb.toString();
        } else {
            int length;
            if (first < '\udfef') {
                length = first & 0x3FF;
                ++offset;
            } else if (first < '\udfff') {
                length = first - 57327 << 16 | this.b16BitUnits.charAt(offset + 1);
                offset += 2;
            } else {
                length = this.b16BitUnits.charAt(offset + 1) << 16 | this.b16BitUnits.charAt(offset + 2);
                offset += 3;
            }
            s = this.b16BitUnits.subSequence(offset, offset + length).toString();
        }
        return (String)this.resourceCache.putIfAbsent(res, s, s.length() * 2);
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$makeStringFromBytes(int offset, int length) {
        if (length <= 16) {
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                sb.append(this.bytes.getChar(offset));
                offset += 2;
            }
            return sb.toString();
        }
        CharBuffer cs = this.bytes.asCharBuffer();
        return cs.subSequence(offset /= 2, offset + length).toString();
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$getString(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (res != offset && ICUResourceBundleReader.RES_GET_TYPE(res) != 6) {
            return null;
        }
        if (offset == 0) {
            return "";
        }
        if (res != offset) {
            if (offset < this.poolStringIndexLimit) {
                return this.poolBundleReader.getStringV2(res);
            }
            return this.getStringV2(res - this.poolStringIndexLimit);
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (String)value;
        }
        offset = this.getResourceByteOffset(offset);
        int length = this.getInt(offset);
        String s = this.makeStringFromBytes(offset + 4, length);
        return (String)this.resourceCache.putIfAbsent(res, s, s.length() * 2);
    }

    private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$isNoInheritanceMarker(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset != 0) {
            if (res == offset) {
                return this.getInt(offset = this.getResourceByteOffset(offset)) == 3 && this.bytes.getChar(offset + 4) == '\u2205' && this.bytes.getChar(offset + 6) == '\u2205' && this.bytes.getChar(offset + 8) == '\u2205';
            }
            if (ICUResourceBundleReader.RES_GET_TYPE(res) == 6) {
                if (offset < this.poolStringIndexLimit) {
                    return this.poolBundleReader.isStringV2NoInheritanceMarker(offset);
                }
                return this.isStringV2NoInheritanceMarker(offset - this.poolStringIndexLimit);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader$isStringV2NoInheritanceMarker(int offset) {
        char first = this.b16BitUnits.charAt(offset);
        if (first == '\u2205') {
            return this.b16BitUnits.charAt(offset + 1) == '\u2205' && this.b16BitUnits.charAt(offset + 2) == '\u2205' && this.b16BitUnits.charAt(offset + 3) == '\u0000';
        }
        if (first == '\udc03') {
            return this.b16BitUnits.charAt(offset + 1) == '\u2205' && this.b16BitUnits.charAt(offset + 2) == '\u2205' && this.b16BitUnits.charAt(offset + 3) == '\u2205';
        }
        return false;
    }

    private final String $$robo$$android_icu_impl_ICUResourceBundleReader$getAlias(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 3) {
            if (offset == 0) {
                return "";
            }
            Object value = this.resourceCache.get(res);
            if (value != null) {
                return (String)value;
            }
            offset = this.getResourceByteOffset(offset);
            int length = this.getInt(offset);
            String s = this.makeStringFromBytes(offset + 4, length);
            return (String)this.resourceCache.putIfAbsent(res, s, length * 2);
        }
        return null;
    }

    private final byte[] $$robo$$android_icu_impl_ICUResourceBundleReader$getBinary(int res, byte[] ba) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 1) {
            if (offset == 0) {
                return emptyBytes;
            }
            int length = this.getInt(offset = this.getResourceByteOffset(offset));
            if (length == 0) {
                return emptyBytes;
            }
            if (ba == null || ba.length != length) {
                ba = new byte[length];
            }
            offset += 4;
            if (length <= 16) {
                for (int i = 0; i < length; ++i) {
                    ba[i] = this.bytes.get(offset++);
                }
            } else {
                ByteBuffer temp = this.bytes.duplicate();
                temp.position(offset);
                temp.get(ba);
            }
            return ba;
        }
        return null;
    }

    private final ByteBuffer $$robo$$android_icu_impl_ICUResourceBundleReader$getBinary(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 1) {
            if (offset == 0) {
                return emptyByteBuffer.duplicate();
            }
            int length = this.getInt(offset = this.getResourceByteOffset(offset));
            if (length == 0) {
                return emptyByteBuffer.duplicate();
            }
            ByteBuffer result = this.bytes.duplicate();
            result.position(offset += 4).limit(offset + length);
            result = ICUBinary.sliceWithOrder(result);
            if (!result.isReadOnly()) {
                result = result.asReadOnlyBuffer();
            }
            return result;
        }
        return null;
    }

    private final int[] $$robo$$android_icu_impl_ICUResourceBundleReader$getIntVector(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (ICUResourceBundleReader.RES_GET_TYPE(res) == 14) {
            if (offset == 0) {
                return emptyInts;
            }
            offset = this.getResourceByteOffset(offset);
            int length = this.getInt(offset);
            return this.getInts(offset + 4, length);
        }
        return null;
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getArrayLength(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return 0;
        }
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (type == 8) {
            offset = this.getResourceByteOffset(offset);
            return this.getInt(offset);
        }
        if (type == 9) {
            return this.b16BitUnits.charAt(offset);
        }
        return 0;
    }

    private final Array $$robo$$android_icu_impl_ICUResourceBundleReader$getArray(int res) {
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (!ICUResourceBundleReader.URES_IS_ARRAY(type)) {
            return null;
        }
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return EMPTY_ARRAY;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Array)value;
        }
        Array array2 = type == 8 ? new Array32(this, offset) : new Array16(this, offset);
        return (Array)this.resourceCache.putIfAbsent(res, array2, 0);
    }

    private final int $$robo$$android_icu_impl_ICUResourceBundleReader$getTableLength(int res) {
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return 0;
        }
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (type == 2) {
            offset = this.getResourceByteOffset(offset);
            return this.bytes.getChar(offset);
        }
        if (type == 5) {
            return this.b16BitUnits.charAt(offset);
        }
        if (type == 4) {
            offset = this.getResourceByteOffset(offset);
            return this.getInt(offset);
        }
        return 0;
    }

    private final Table $$robo$$android_icu_impl_ICUResourceBundleReader$getTable(int res) {
        int size;
        Table table;
        int type = ICUResourceBundleReader.RES_GET_TYPE(res);
        if (!ICUResourceBundleReader.URES_IS_TABLE(type)) {
            return null;
        }
        int offset = ICUResourceBundleReader.RES_GET_OFFSET(res);
        if (offset == 0) {
            return EMPTY_TABLE;
        }
        Object value = this.resourceCache.get(res);
        if (value != null) {
            return (Table)value;
        }
        if (type == 2) {
            table = new Table1632(this, offset);
            size = table.getSize() * 2;
        } else if (type == 5) {
            table = new Table16(this, offset);
            size = table.getSize() * 2;
        } else {
            table = new Table32(this, offset);
            size = table.getSize() * 4;
        }
        return (Table)this.resourceCache.putIfAbsent(res, table, size);
    }

    private static final String $$robo$$android_icu_impl_ICUResourceBundleReader$getFullName(String baseName, String localeName) {
        if (baseName == null || baseName.length() == 0) {
            if (localeName.length() == 0) {
                localeName = ULocale.getDefault().toString();
                return localeName;
            }
            return localeName + ".res";
        }
        if (baseName.indexOf(46) == -1) {
            if (baseName.charAt(baseName.length() - 1) != '/') {
                return baseName + "/" + localeName + ".res";
            }
            return baseName + localeName + ".res";
        }
        baseName = baseName.replace('.', '/');
        if (localeName.length() == 0) {
            return baseName + ".res";
        }
        return baseName + "_" + localeName + ".res";
    }

    private /* synthetic */ void $$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(ByteBuffer x0, String x1, String x2, ClassLoader x3, 1 x4) throws IOException {
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !ICUResourceBundleReader.class.desiredAssertionStatus();
        IS_ACCEPTABLE = new IsAcceptable();
        EMPTY_16_BIT_UNITS = CharBuffer.wrap("\u0000");
        CACHE = new ReaderCache();
        NULL_READER = new ICUResourceBundleReader();
        emptyBytes = new byte[0];
        emptyByteBuffer = ByteBuffer.allocate(0).asReadOnlyBuffer();
        emptyChars = new char[0];
        emptyInts = new int[0];
        EMPTY_ARRAY = new Array();
        EMPTY_TABLE = new Table();
        PUBLIC_TYPES = new int[]{0, 1, 2, 3, 2, 2, 0, 7, 8, 8, -1, -1, -1, -1, 14, -1};
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__();
    }

    private ICUResourceBundleReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(), 0, this);
    }

    private void __constructor__(ByteBuffer byteBuffer, String string2, String string3, ClassLoader classLoader) throws IOException {
        this.$$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(byteBuffer, string2, string3, classLoader);
    }

    private ICUResourceBundleReader(ByteBuffer byteBuffer, String string2, String string3, ClassLoader classLoader) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(java.nio.ByteBuffer java.lang.String java.lang.String java.lang.ClassLoader ), 0, this, byteBuffer, string2, string3, classLoader);
    }

    static ICUResourceBundleReader getReader(String string2, String string3, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrapStatic("getReader", $$robo$$android_icu_impl_ICUResourceBundleReader$getReader(java.lang.String java.lang.String java.lang.ClassLoader ), 0, (String)string2, (String)string3, (ClassLoader)classLoader);
    }

    private void init(ByteBuffer byteBuffer) throws IOException {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_impl_ICUResourceBundleReader$init(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    private int getIndexesInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIndexesInt", $$robo$$android_icu_impl_ICUResourceBundleReader$getIndexesInt(int ), 0, this, n);
    }

    VersionInfo getVersion() {
        return InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_icu_impl_ICUResourceBundleReader$getVersion(), 0, this);
    }

    int getRootResource() {
        return (int)InvokeDynamicSupport.bootstrap("getRootResource", $$robo$$android_icu_impl_ICUResourceBundleReader$getRootResource(), 0, this);
    }

    boolean getNoFallback() {
        return (boolean)InvokeDynamicSupport.bootstrap("getNoFallback", $$robo$$android_icu_impl_ICUResourceBundleReader$getNoFallback(), 0, this);
    }

    boolean getUsesPoolBundle() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUsesPoolBundle", $$robo$$android_icu_impl_ICUResourceBundleReader$getUsesPoolBundle(), 0, this);
    }

    static int RES_GET_TYPE(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("RES_GET_TYPE", $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_TYPE(int ), 0, (int)n);
    }

    private static int RES_GET_OFFSET(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("RES_GET_OFFSET", $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_OFFSET(int ), 0, (int)n);
    }

    private int getResourceByteOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceByteOffset", $$robo$$android_icu_impl_ICUResourceBundleReader$getResourceByteOffset(int ), 0, this, n);
    }

    static int RES_GET_INT(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("RES_GET_INT", $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_INT(int ), 0, (int)n);
    }

    static int RES_GET_UINT(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("RES_GET_UINT", $$robo$$android_icu_impl_ICUResourceBundleReader$RES_GET_UINT(int ), 0, (int)n);
    }

    static boolean URES_IS_ARRAY(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("URES_IS_ARRAY", $$robo$$android_icu_impl_ICUResourceBundleReader$URES_IS_ARRAY(int ), 0, (int)n);
    }

    static boolean URES_IS_TABLE(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("URES_IS_TABLE", $$robo$$android_icu_impl_ICUResourceBundleReader$URES_IS_TABLE(int ), 0, (int)n);
    }

    private char[] getChars(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getChars", $$robo$$android_icu_impl_ICUResourceBundleReader$getChars(int int ), 0, this, n, n2);
    }

    private int getInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_icu_impl_ICUResourceBundleReader$getInt(int ), 0, this, n);
    }

    private int[] getInts(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getInts", $$robo$$android_icu_impl_ICUResourceBundleReader$getInts(int int ), 0, this, n, n2);
    }

    private char[] getTable16KeyOffsets(int n) {
        return InvokeDynamicSupport.bootstrap("getTable16KeyOffsets", $$robo$$android_icu_impl_ICUResourceBundleReader$getTable16KeyOffsets(int ), 0, this, n);
    }

    private char[] getTableKeyOffsets(int n) {
        return InvokeDynamicSupport.bootstrap("getTableKeyOffsets", $$robo$$android_icu_impl_ICUResourceBundleReader$getTableKeyOffsets(int ), 0, this, n);
    }

    private int[] getTable32KeyOffsets(int n) {
        return InvokeDynamicSupport.bootstrap("getTable32KeyOffsets", $$robo$$android_icu_impl_ICUResourceBundleReader$getTable32KeyOffsets(int ), 0, this, n);
    }

    private static String makeKeyStringFromBytes(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("makeKeyStringFromBytes", $$robo$$android_icu_impl_ICUResourceBundleReader$makeKeyStringFromBytes(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    private String getKey16String(int n) {
        return InvokeDynamicSupport.bootstrap("getKey16String", $$robo$$android_icu_impl_ICUResourceBundleReader$getKey16String(int ), 0, this, n);
    }

    private String getKey32String(int n) {
        return InvokeDynamicSupport.bootstrap("getKey32String", $$robo$$android_icu_impl_ICUResourceBundleReader$getKey32String(int ), 0, this, n);
    }

    private void setKeyFromKey16(int n, UResource.Key key) {
        InvokeDynamicSupport.bootstrap("setKeyFromKey16", $$robo$$android_icu_impl_ICUResourceBundleReader$setKeyFromKey16(int android.icu.impl.UResource$Key ), 0, this, n, key);
    }

    private void setKeyFromKey32(int n, UResource.Key key) {
        InvokeDynamicSupport.bootstrap("setKeyFromKey32", $$robo$$android_icu_impl_ICUResourceBundleReader$setKeyFromKey32(int android.icu.impl.UResource$Key ), 0, this, n, key);
    }

    private int compareKeys(CharSequence charSequence, char c) {
        return (int)InvokeDynamicSupport.bootstrap("compareKeys", $$robo$$android_icu_impl_ICUResourceBundleReader$compareKeys(java.lang.CharSequence char ), 0, this, charSequence, c);
    }

    private int compareKeys32(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrap("compareKeys32", $$robo$$android_icu_impl_ICUResourceBundleReader$compareKeys32(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    String getStringV2(int n) {
        return InvokeDynamicSupport.bootstrap("getStringV2", $$robo$$android_icu_impl_ICUResourceBundleReader$getStringV2(int ), 0, this, n);
    }

    private String makeStringFromBytes(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("makeStringFromBytes", $$robo$$android_icu_impl_ICUResourceBundleReader$makeStringFromBytes(int int ), 0, this, n, n2);
    }

    String getString(int n) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_icu_impl_ICUResourceBundleReader$getString(int ), 0, this, n);
    }

    private boolean isNoInheritanceMarker(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNoInheritanceMarker", $$robo$$android_icu_impl_ICUResourceBundleReader$isNoInheritanceMarker(int ), 0, this, n);
    }

    private boolean isStringV2NoInheritanceMarker(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isStringV2NoInheritanceMarker", $$robo$$android_icu_impl_ICUResourceBundleReader$isStringV2NoInheritanceMarker(int ), 0, this, n);
    }

    String getAlias(int n) {
        return InvokeDynamicSupport.bootstrap("getAlias", $$robo$$android_icu_impl_ICUResourceBundleReader$getAlias(int ), 0, this, n);
    }

    byte[] getBinary(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("getBinary", $$robo$$android_icu_impl_ICUResourceBundleReader$getBinary(int byte[] ), 0, this, n, byArray);
    }

    ByteBuffer getBinary(int n) {
        return InvokeDynamicSupport.bootstrap("getBinary", $$robo$$android_icu_impl_ICUResourceBundleReader$getBinary(int ), 0, this, n);
    }

    int[] getIntVector(int n) {
        return InvokeDynamicSupport.bootstrap("getIntVector", $$robo$$android_icu_impl_ICUResourceBundleReader$getIntVector(int ), 0, this, n);
    }

    private int getArrayLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getArrayLength", $$robo$$android_icu_impl_ICUResourceBundleReader$getArrayLength(int ), 0, this, n);
    }

    Array getArray(int n) {
        return InvokeDynamicSupport.bootstrap("getArray", $$robo$$android_icu_impl_ICUResourceBundleReader$getArray(int ), 0, this, n);
    }

    private int getTableLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTableLength", $$robo$$android_icu_impl_ICUResourceBundleReader$getTableLength(int ), 0, this, n);
    }

    Table getTable(int n) {
        return InvokeDynamicSupport.bootstrap("getTable", $$robo$$android_icu_impl_ICUResourceBundleReader$getTable(int ), 0, this, n);
    }

    public static String getFullName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getFullName", $$robo$$android_icu_impl_ICUResourceBundleReader$getFullName(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private /* synthetic */ void __constructor__(ByteBuffer byteBuffer, String string2, String string3, ClassLoader classLoader, 1 var5_5) throws IOException {
        this.$$robo$$android_icu_impl_ICUResourceBundleReader$__constructor__(byteBuffer, string2, string3, classLoader, var5_5);
    }

    static {
        RobolectricInternals.classInitializing(ICUResourceBundleReader.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUResourceBundleReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ResourceCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SIMPLE_LENGTH = 32;
        private static int ROOT_BITS = 7;
        private static int NEXT_BITS = 6;
        private int[] keys;
        private Object[] values;
        private int length;
        private int maxOffsetBits;
        private int levelBitsList;
        private Level rootLevel;
        static /* synthetic */ boolean $assertionsDisabled;

        private static final boolean $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$storeDirectly(int size) {
            return size < 24 || CacheValue.futureInstancesWillBeStrong();
        }

        private static final Object $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$putIfCleared(Object[] values, int index, Object item, int size) {
            Object value = values[index];
            if (!(value instanceof SoftReference)) {
                return value;
            }
            if (!$assertionsDisabled && size < 24) {
                throw new AssertionError();
            }
            if ((value = ((SoftReference)value).get()) != null) {
                return value;
            }
            values[index] = CacheValue.futureInstancesWillBeStrong() ? item : new SoftReference<Object>(item);
            return item;
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$__constructor__(int maxOffset) {
            this.keys = new int[32];
            this.values = new Object[32];
            if (!$assertionsDisabled && maxOffset == 0) {
                throw new AssertionError();
            }
            this.maxOffsetBits = 28;
            while (maxOffset <= 0x7FFFFFF) {
                maxOffset <<= 1;
                --this.maxOffsetBits;
            }
            int keyBits = this.maxOffsetBits + 2;
            if (keyBits <= 7) {
                this.levelBitsList = keyBits;
            } else if (keyBits < 10) {
                this.levelBitsList = 0x30 | keyBits - 3;
            } else {
                this.levelBitsList = 7;
                keyBits -= 7;
                int shift = 4;
                while (true) {
                    if (keyBits <= 6) {
                        this.levelBitsList |= keyBits << shift;
                        break;
                    }
                    if (keyBits < 9) {
                        this.levelBitsList |= (0x30 | keyBits - 3) << shift;
                        break;
                    }
                    this.levelBitsList |= 6 << shift;
                    keyBits -= 6;
                    shift += 4;
                }
            }
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$makeKey(int res) {
            int type = ICUResourceBundleReader.RES_GET_TYPE(res);
            int miniType = type == 6 ? 1 : (type == 5 ? 3 : (type == 9 ? 2 : 0));
            return ICUResourceBundleReader.RES_GET_OFFSET(res) | miniType << this.maxOffsetBits;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$findSimple(int key) {
            int start = 0;
            int limit = this.length;
            while (limit - start > 8) {
                int mid = (start + limit) / 2;
                if (key < this.keys[mid]) {
                    limit = mid;
                    continue;
                }
                start = mid;
            }
            while (start < limit) {
                int k = this.keys[start];
                if (key < k) {
                    return ~start;
                }
                if (key == k) {
                    return start;
                }
                ++start;
            }
            return ~start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final synchronized Object $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$get(int res) {
            Object value;
            if (!$assertionsDisabled && ICUResourceBundleReader.RES_GET_OFFSET(res) == 0) {
                throw new AssertionError();
            }
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index < 0) return null;
                value = this.values[index];
            } else {
                value = this.rootLevel.get(this.makeKey(res));
                if (value == null) {
                    return null;
                }
            }
            if (!(value instanceof SoftReference)) return value;
            return ((SoftReference)value).get();
        }

        private final synchronized Object $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$putIfAbsent(int res, Object item, int size) {
            if (this.length >= 0) {
                int index = this.findSimple(res);
                if (index >= 0) {
                    return ResourceCache.putIfCleared(this.values, index, item, size);
                }
                if (this.length < 32) {
                    if ((index ^= 0xFFFFFFFF) < this.length) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.keys, (int)index, (int[])this.keys, (int)(index + 1), (int)(this.length - index));
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.values, (int)index, (Object)this.values, (int)(index + 1), (int)(this.length - index));
                    }
                    ++this.length;
                    this.keys[index] = res;
                    this.values[index] = ResourceCache.storeDirectly(size) ? item : new SoftReference<Object>(item);
                    return item;
                }
                this.rootLevel = new Level(this.levelBitsList, 0);
                for (int i = 0; i < 32; ++i) {
                    this.rootLevel.putIfAbsent(this.makeKey(this.keys[i]), this.values[i], 0);
                }
                this.keys = null;
                this.values = null;
                this.length = -1;
            }
            return this.rootLevel.putIfAbsent(this.makeKey(res), item, size);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ICUResourceBundleReader.class.desiredAssertionStatus();
        }

        private static boolean storeDirectly(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("storeDirectly", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$storeDirectly(int ), 0, (int)n);
        }

        private static Object putIfCleared(Object[] objectArray, int n, Object object, int n2) {
            return InvokeDynamicSupport.bootstrapStatic("putIfCleared", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$putIfCleared(java.lang.Object[] int java.lang.Object int ), 0, (Object[])objectArray, (int)n, (Object)object, (int)n2);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$__constructor__(n);
        }

        ResourceCache(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$__constructor__(int ), 0, this, n);
        }

        private int makeKey(int n) {
            return (int)InvokeDynamicSupport.bootstrap("makeKey", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$makeKey(int ), 0, this, n);
        }

        private int findSimple(int n) {
            return (int)InvokeDynamicSupport.bootstrap("findSimple", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$findSimple(int ), 0, this, n);
        }

        synchronized Object get(int n) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$get(int ), 0, this, n);
        }

        synchronized Object putIfAbsent(int n, Object object, int n2) {
            return InvokeDynamicSupport.bootstrap("putIfAbsent", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache$putIfAbsent(int java.lang.Object int ), 0, this, n, object, n2);
        }

        static {
            RobolectricInternals.classInitializing(ResourceCache.class);
        }

        public /* synthetic */ ResourceCache() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class Level
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int levelBitsList;
            int shift;
            int mask;
            int[] keys;
            Object[] values;
            static /* synthetic */ boolean $assertionsDisabled;

            private void $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$__constructor__(int levelBitsList, int shift) {
                this.levelBitsList = levelBitsList;
                this.shift = shift;
                int bits = levelBitsList & 0xF;
                if (!$assertionsDisabled && bits == 0) {
                    throw new AssertionError();
                }
                int length = 1 << bits;
                this.mask = length - 1;
                this.keys = new int[length];
                this.values = new Object[length];
            }

            private final Object $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$get(int key) {
                Level level;
                int index = key >> this.shift & this.mask;
                int k = this.keys[index];
                if (k == key) {
                    return this.values[index];
                }
                if (k == 0 && (level = (Level)this.values[index]) != null) {
                    return level.get(key);
                }
                return null;
            }

            private final Object $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$putIfAbsent(int key, Object item, int size) {
                int index = key >> this.shift & this.mask;
                int k = this.keys[index];
                if (k == key) {
                    return ResourceCache.putIfCleared(this.values, index, item, size);
                }
                if (k == 0) {
                    Level level = (Level)this.values[index];
                    if (level != null) {
                        return level.putIfAbsent(key, item, size);
                    }
                    this.keys[index] = key;
                    this.values[index] = ResourceCache.storeDirectly(size) ? item : new SoftReference<Object>(item);
                    return item;
                }
                Level level = new Level(this.levelBitsList >> 4, this.shift + (this.levelBitsList & 0xF));
                int i = k >> level.shift & level.mask;
                level.keys[i] = k;
                level.values[i] = this.values[index];
                this.keys[index] = 0;
                this.values[index] = level;
                return level.putIfAbsent(key, item, size);
            }

            static void __staticInitializer__() {
                $assertionsDisabled = !ICUResourceBundleReader.class.desiredAssertionStatus();
            }

            private void __constructor__(int n, int n2) {
                this.$$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$__constructor__(n, n2);
            }

            Level(int n, int n2) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$__constructor__(int int ), 0, this, n, n2);
            }

            Object get(int n) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$get(int ), 0, this, n);
            }

            Object putIfAbsent(int n, Object object, int n2) {
                return InvokeDynamicSupport.bootstrap("putIfAbsent", $$robo$$android_icu_impl_ICUResourceBundleReader_ResourceCache_Level$putIfAbsent(int java.lang.Object int ), 0, this, n, object, n2);
            }

            static {
                RobolectricInternals.classInitializing(Level.class);
            }

            public /* synthetic */ Level() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Level)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Table32
    extends Table
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Table32$getContainerResource(ICUResourceBundleReader reader, int index) {
            return this.getContainer32Resource(reader, index);
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Table32$__constructor__(ICUResourceBundleReader reader, int offset) {
            offset = reader.getResourceByteOffset(offset);
            this.key32Offsets = reader.getTable32KeyOffsets(offset);
            this.size = this.key32Offsets.length;
            this.itemsOffset = offset + 4 * (1 + this.size);
        }

        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Table32$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        private void __constructor__(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Table32$__constructor__(iCUResourceBundleReader, n);
        }

        Table32(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Table32$__constructor__(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        public /* synthetic */ Table32() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Table32)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Table16
    extends Table
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Table16$getContainerResource(ICUResourceBundleReader reader, int index) {
            return this.getContainer16Resource(reader, index);
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Table16$__constructor__(ICUResourceBundleReader reader, int offset) {
            this.keyOffsets = reader.getTable16KeyOffsets(offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = offset + 1 + this.size;
        }

        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Table16$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        private void __constructor__(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Table16$__constructor__(iCUResourceBundleReader, n);
        }

        Table16(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Table16$__constructor__(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        public /* synthetic */ Table16() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Table16)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Table1632
    extends Table
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Table1632$getContainerResource(ICUResourceBundleReader reader, int index) {
            return this.getContainer32Resource(reader, index);
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Table1632$__constructor__(ICUResourceBundleReader reader, int offset) {
            offset = reader.getResourceByteOffset(offset);
            this.keyOffsets = reader.getTableKeyOffsets(offset);
            this.size = this.keyOffsets.length;
            this.itemsOffset = offset + 2 * (this.size + 2 & 0xFFFFFFFE);
        }

        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Table1632$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        private void __constructor__(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Table1632$__constructor__(iCUResourceBundleReader, n);
        }

        Table1632(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Table1632$__constructor__(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        public /* synthetic */ Table1632() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Table1632)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Table
    extends Container
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected char[] keyOffsets;
        protected int[] key32Offsets;
        private static int URESDATA_ITEM_NOT_FOUND = -1;
        static /* synthetic */ boolean $assertionsDisabled;

        private final String $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getKey(ICUResourceBundleReader reader, int index) {
            if (index < 0 || this.size <= index) {
                return null;
            }
            return this.keyOffsets != null ? reader.getKey16String(this.keyOffsets[index]) : reader.getKey32String(this.key32Offsets[index]);
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Table$findTableItem(ICUResourceBundleReader reader, CharSequence key) {
            int start = 0;
            int limit = this.size;
            while (start < limit) {
                int mid = start + limit >>> 1;
                int result = this.keyOffsets != null ? reader.compareKeys(key, this.keyOffsets[mid]) : reader.compareKeys32(key, this.key32Offsets[mid]);
                if (result < 0) {
                    limit = mid;
                    continue;
                }
                if (result > 0) {
                    start = mid + 1;
                    continue;
                }
                return mid;
            }
            return -1;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getResource(ICUResourceBundleReader reader, String resKey) {
            return this.getContainerResource(reader, this.findTableItem(reader, resKey));
        }

        private final void $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getAllItems(ICUResourceBundleReader reader, UResource.Key key, ReaderValue value, UResource.TableSink sink) {
            for (int i = 0; i < this.size; ++i) {
                Object subSink;
                int numItems;
                if (this.keyOffsets != null) {
                    reader.setKeyFromKey16(this.keyOffsets[i], key);
                } else {
                    reader.setKeyFromKey32(this.key32Offsets[i], key);
                }
                int res = this.getContainerResource(reader, i);
                int type = ICUResourceBundleReader.RES_GET_TYPE(res);
                if (ICUResourceBundleReader.URES_IS_ARRAY(type)) {
                    numItems = reader.getArrayLength(res);
                    subSink = sink.getOrCreateArraySink(key, numItems);
                    if (subSink == null) continue;
                    Array array2 = reader.getArray(res);
                    if (!$assertionsDisabled && array2.size != numItems) {
                        throw new AssertionError();
                    }
                    array2.getAllItems(reader, key, value, (UResource.ArraySink)subSink);
                    continue;
                }
                if (ICUResourceBundleReader.URES_IS_TABLE(type)) {
                    numItems = reader.getTableLength(res);
                    subSink = sink.getOrCreateTableSink(key, numItems);
                    if (subSink == null) continue;
                    Table table = reader.getTable(res);
                    if (!$assertionsDisabled && table.size != numItems) {
                        throw new AssertionError();
                    }
                    table.getAllItems(reader, key, value, (UResource.TableSink)subSink);
                    continue;
                }
                if (reader.isNoInheritanceMarker(res)) {
                    sink.putNoFallback(key);
                    continue;
                }
                value.res = res;
                sink.put(key, value);
            }
            sink.leave();
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Table$__constructor__() {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ICUResourceBundleReader.class.desiredAssertionStatus();
        }

        String getKey(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getKey(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        int findTableItem(ICUResourceBundleReader iCUResourceBundleReader, CharSequence charSequence) {
            return (int)InvokeDynamicSupport.bootstrap("findTableItem", $$robo$$android_icu_impl_ICUResourceBundleReader_Table$findTableItem(android.icu.impl.ICUResourceBundleReader java.lang.CharSequence ), 0, this, iCUResourceBundleReader, charSequence);
        }

        @Override
        int getResource(ICUResourceBundleReader iCUResourceBundleReader, String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getResource(android.icu.impl.ICUResourceBundleReader java.lang.String ), 0, this, iCUResourceBundleReader, string2);
        }

        void getAllItems(ICUResourceBundleReader iCUResourceBundleReader, UResource.Key key, ReaderValue readerValue, UResource.TableSink tableSink) {
            InvokeDynamicSupport.bootstrap("getAllItems", $$robo$$android_icu_impl_ICUResourceBundleReader_Table$getAllItems(android.icu.impl.ICUResourceBundleReader android.icu.impl.UResource$Key android.icu.impl.ICUResourceBundleReader$ReaderValue android.icu.impl.UResource$TableSink ), 0, this, iCUResourceBundleReader, key, readerValue, tableSink);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Table$__constructor__();
        }

        Table() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Table$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Table.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Table)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Array16
    extends Array
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Array16$getContainerResource(ICUResourceBundleReader reader, int index) {
            return this.getContainer16Resource(reader, index);
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Array16$__constructor__(ICUResourceBundleReader reader, int offset) {
            this.size = reader.b16BitUnits.charAt(offset);
            this.itemsOffset = offset + 1;
        }

        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Array16$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        private void __constructor__(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Array16$__constructor__(iCUResourceBundleReader, n);
        }

        Array16(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Array16$__constructor__(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        public /* synthetic */ Array16() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Array16)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Array32
    extends Array
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Array32$getContainerResource(ICUResourceBundleReader reader, int index) {
            return this.getContainer32Resource(reader, index);
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Array32$__constructor__(ICUResourceBundleReader reader, int offset) {
            offset = reader.getResourceByteOffset(offset);
            this.size = reader.getInt(offset);
            this.itemsOffset = offset + 4;
        }

        @Override
        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Array32$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        private void __constructor__(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Array32$__constructor__(iCUResourceBundleReader, n);
        }

        Array32(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Array32$__constructor__(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        public /* synthetic */ Array32() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Array32)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Array
    extends Container
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Array$__constructor__() {
        }

        private final void $$robo$$android_icu_impl_ICUResourceBundleReader_Array$getAllItems(ICUResourceBundleReader reader, UResource.Key key, ReaderValue value, UResource.ArraySink sink) {
            for (int i = 0; i < this.size; ++i) {
                Object subSink;
                int numItems;
                int res = this.getContainerResource(reader, i);
                int type = ICUResourceBundleReader.RES_GET_TYPE(res);
                if (ICUResourceBundleReader.URES_IS_ARRAY(type)) {
                    numItems = reader.getArrayLength(res);
                    subSink = sink.getOrCreateArraySink(i, numItems);
                    if (subSink == null) continue;
                    Array array2 = reader.getArray(res);
                    if (!$assertionsDisabled && array2.size != numItems) {
                        throw new AssertionError();
                    }
                    array2.getAllItems(reader, key, value, (UResource.ArraySink)subSink);
                    continue;
                }
                if (ICUResourceBundleReader.URES_IS_TABLE(type)) {
                    numItems = reader.getTableLength(res);
                    subSink = sink.getOrCreateTableSink(i, numItems);
                    if (subSink == null) continue;
                    Table table = reader.getTable(res);
                    if (!$assertionsDisabled && table.size != numItems) {
                        throw new AssertionError();
                    }
                    table.getAllItems(reader, key, value, (UResource.TableSink)subSink);
                    continue;
                }
                value.res = res;
                sink.put(i, value);
            }
            sink.leave();
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !ICUResourceBundleReader.class.desiredAssertionStatus();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Array$__constructor__();
        }

        Array() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Array$__constructor__(), 0, this);
        }

        void getAllItems(ICUResourceBundleReader iCUResourceBundleReader, UResource.Key key, ReaderValue readerValue, UResource.ArraySink arraySink) {
            InvokeDynamicSupport.bootstrap("getAllItems", $$robo$$android_icu_impl_ICUResourceBundleReader_Array$getAllItems(android.icu.impl.ICUResourceBundleReader android.icu.impl.UResource$Key android.icu.impl.ICUResourceBundleReader$ReaderValue android.icu.impl.UResource$ArraySink ), 0, this, iCUResourceBundleReader, key, readerValue, arraySink);
        }

        static {
            RobolectricInternals.classInitializing(Array.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Array)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Container
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected int size;
        protected int itemsOffset;

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getSize() {
            return this.size;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainerResource(ICUResourceBundleReader reader, int index) {
            return -1;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainer16Resource(ICUResourceBundleReader reader, int index) {
            if (index < 0 || this.size <= index) {
                return -1;
            }
            int res16 = reader.b16BitUnits.charAt(this.itemsOffset + index);
            if (res16 >= reader.poolStringIndex16Limit) {
                res16 = res16 - reader.poolStringIndex16Limit + reader.poolStringIndexLimit;
            }
            return 0x60000000 | res16;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainer32Resource(ICUResourceBundleReader reader, int index) {
            if (index < 0 || this.size <= index) {
                return -1;
            }
            return reader.getInt(this.itemsOffset + 4 * index);
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getResource(ICUResourceBundleReader reader, String resKey) {
            return this.getContainerResource(reader, Integer.parseInt(resKey));
        }

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_Container$__constructor__() {
        }

        int getSize() {
            return (int)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getSize(), 0, this);
        }

        int getContainerResource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainerResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainerResource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        protected int getContainer16Resource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainer16Resource", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainer16Resource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        protected int getContainer32Resource(ICUResourceBundleReader iCUResourceBundleReader, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getContainer32Resource", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getContainer32Resource(android.icu.impl.ICUResourceBundleReader int ), 0, this, iCUResourceBundleReader, n);
        }

        int getResource(ICUResourceBundleReader iCUResourceBundleReader, String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getResource", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$getResource(android.icu.impl.ICUResourceBundleReader java.lang.String ), 0, this, iCUResourceBundleReader, string2);
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_Container$__constructor__();
        }

        Container() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_Container$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Container)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ReaderValue
    extends UResource.Value
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ICUResourceBundleReader reader;
        private int res;

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$__constructor__() {
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getType() {
            return PUBLIC_TYPES[ICUResourceBundleReader.RES_GET_TYPE(this.res)];
        }

        private final String $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getString() {
            String s = this.reader.getString(this.res);
            if (s == null) {
                throw new UResourceTypeMismatchException("");
            }
            return s;
        }

        private final String $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getAliasString() {
            String s = this.reader.getAlias(this.res);
            if (s == null) {
                throw new UResourceTypeMismatchException("");
            }
            return s;
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getInt() {
            if (ICUResourceBundleReader.RES_GET_TYPE(this.res) != 7) {
                throw new UResourceTypeMismatchException("");
            }
            return ICUResourceBundleReader.RES_GET_INT(this.res);
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getUInt() {
            if (ICUResourceBundleReader.RES_GET_TYPE(this.res) != 7) {
                throw new UResourceTypeMismatchException("");
            }
            return ICUResourceBundleReader.RES_GET_UINT(this.res);
        }

        private final int[] $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getIntVector() {
            int[] iv = this.reader.getIntVector(this.res);
            if (iv == null) {
                throw new UResourceTypeMismatchException("");
            }
            return iv;
        }

        private final ByteBuffer $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getBinary() {
            ByteBuffer bb = this.reader.getBinary(this.res);
            if (bb == null) {
                throw new UResourceTypeMismatchException("");
            }
            return bb;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$__constructor__();
        }

        ReaderValue() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$__constructor__(), 0, this);
        }

        @Override
        public int getType() {
            return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getType(), 0, this);
        }

        @Override
        public String getString() {
            return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getString(), 0, this);
        }

        @Override
        public String getAliasString() {
            return InvokeDynamicSupport.bootstrap("getAliasString", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getAliasString(), 0, this);
        }

        @Override
        public int getInt() {
            return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getInt(), 0, this);
        }

        @Override
        public int getUInt() {
            return (int)InvokeDynamicSupport.bootstrap("getUInt", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getUInt(), 0, this);
        }

        @Override
        public int[] getIntVector() {
            return InvokeDynamicSupport.bootstrap("getIntVector", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getIntVector(), 0, this);
        }

        @Override
        public ByteBuffer getBinary() {
            return InvokeDynamicSupport.bootstrap("getBinary", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderValue$getBinary(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReaderValue)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ReaderCache
    extends SoftCache<ReaderCacheKey, ICUResourceBundleReader, ClassLoader> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$__constructor__() {
        }

        private final ICUResourceBundleReader $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$createInstance(ReaderCacheKey key, ClassLoader loader) {
            String fullName = ICUResourceBundleReader.getFullName(key.baseName, key.localeID);
            try {
                ByteBuffer inBytes;
                if (key.baseName != null && key.baseName.startsWith("android/icu/impl/data/icudt56b")) {
                    String itemPath = fullName.substring("android/icu/impl/data/icudt56b".length() + 1);
                    inBytes = ICUBinary.getData(loader, fullName, itemPath);
                    if (inBytes == null) {
                        return NULL_READER;
                    }
                } else {
                    InputStream stream = ICUData.getStream(loader, fullName);
                    if (stream == null) {
                        return NULL_READER;
                    }
                    inBytes = ICUBinary.getByteBufferFromInputStreamAndCloseStream(stream);
                }
                return new ICUResourceBundleReader(inBytes, key.baseName, key.localeID, loader);
            }
            catch (IOException ex) {
                throw new ICUUncheckedIOException("Data file " + fullName + " is corrupt - " + ex.getMessage(), ex);
            }
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$__constructor__();
        }

        private ReaderCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$__constructor__(), 0, this);
        }

        @Override
        protected ICUResourceBundleReader createInstance(ReaderCacheKey readerCacheKey, ClassLoader classLoader) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$createInstance(android.icu.impl.ICUResourceBundleReader$ReaderCacheKey java.lang.ClassLoader ), 0, this, readerCacheKey, classLoader);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCache$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReaderCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ReaderCacheKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String baseName;
        String localeID;

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$__constructor__(String baseName, String localeID) {
            this.baseName = baseName == null ? "" : baseName;
            this.localeID = localeID == null ? "" : localeID;
        }

        private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReaderCacheKey)) {
                return false;
            }
            ReaderCacheKey info = (ReaderCacheKey)obj;
            return this.baseName.equals(info.baseName) && this.localeID.equals(info.localeID);
        }

        private final int $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$hashCode() {
            return this.baseName.hashCode() ^ this.localeID.hashCode();
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$__constructor__(string2, string3);
        }

        ReaderCacheKey(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_impl_ICUResourceBundleReader_ReaderCacheKey$hashCode(), 0, this);
        }

        public /* synthetic */ ReaderCacheKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReaderCacheKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class IsAcceptable
    implements ICUBinary.Authenticate,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$__constructor__() {
        }

        private final boolean $$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$isDataVersionAcceptable(byte[] formatVersion) {
            return formatVersion[0] == 1 && (formatVersion[1] & 0xFF) >= 1 || 2 <= formatVersion[0] && formatVersion[0] <= 3;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$__constructor__();
        }

        private IsAcceptable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$__constructor__(), 0, this);
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDataVersionAcceptable", $$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$isDataVersionAcceptable(byte[] ), 0, this, byArray);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_ICUResourceBundleReader_IsAcceptable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IsAcceptable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

