/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Trie;
import android.icu.text.UTF16;
import android.icu.util.RangeValueIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TrieIterator
implements RangeValueIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BMP_INDEX_LENGTH_ = 2048;
    private static int LEAD_SURROGATE_MIN_VALUE_ = 55296;
    private static int TRAIL_SURROGATE_MIN_VALUE_ = 56320;
    private static int TRAIL_SURROGATE_COUNT_ = 1024;
    private static int TRAIL_SURROGATE_INDEX_BLOCK_LENGTH_ = 32;
    private static int DATA_BLOCK_LENGTH_ = 32;
    private Trie m_trie_;
    private int m_initialValue_;
    private int m_currentCodepoint_;
    private int m_nextCodepoint_;
    private int m_nextValue_;
    private int m_nextIndex_;
    private int m_nextBlock_;
    private int m_nextBlockIndex_;
    private int m_nextTrailIndexOffset_;

    private void $$robo$$android_icu_impl_TrieIterator$__constructor__(Trie trie) {
        if (trie == null) {
            throw new IllegalArgumentException("Argument trie cannot be null");
        }
        this.m_trie_ = trie;
        this.m_initialValue_ = this.extract(this.m_trie_.getInitialValue());
        this.reset();
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$next(RangeValueIterator.Element element) {
        if (this.m_nextCodepoint_ > 0x10FFFF) {
            return false;
        }
        if (this.m_nextCodepoint_ < 65536 && this.calculateNextBMPElement(element)) {
            return true;
        }
        this.calculateNextSupplementaryElement(element);
        return true;
    }

    private final void $$robo$$android_icu_impl_TrieIterator$reset() {
        this.m_currentCodepoint_ = 0;
        this.m_nextCodepoint_ = 0;
        this.m_nextIndex_ = 0;
        this.m_nextBlock_ = this.m_trie_.m_index_[0] << 2;
        this.m_nextValue_ = this.m_nextBlock_ == this.m_trie_.m_dataOffset_ ? this.m_initialValue_ : this.extract(this.m_trie_.getValue(this.m_nextBlock_));
        this.m_nextBlockIndex_ = 0;
        this.m_nextTrailIndexOffset_ = 32;
    }

    private final int $$robo$$android_icu_impl_TrieIterator$extract(int value) {
        return value;
    }

    private final void $$robo$$android_icu_impl_TrieIterator$setResult(RangeValueIterator.Element element, int start, int limit, int value) {
        element.start = start;
        element.limit = limit;
        element.value = value;
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$calculateNextBMPElement(RangeValueIterator.Element element) {
        int currentValue = this.m_nextValue_;
        this.m_currentCodepoint_ = this.m_nextCodepoint_++;
        ++this.m_nextBlockIndex_;
        if (!this.checkBlockDetail(currentValue)) {
            this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
            return true;
        }
        while (this.m_nextCodepoint_ < 65536) {
            this.m_nextIndex_ = this.m_nextCodepoint_ == 55296 ? 2048 : (this.m_nextCodepoint_ == 56320 ? this.m_nextCodepoint_ >> 5 : ++this.m_nextIndex_);
            this.m_nextBlockIndex_ = 0;
            if (this.checkBlock(currentValue)) continue;
            this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
            return true;
        }
        --this.m_nextCodepoint_;
        --this.m_nextBlockIndex_;
        return false;
    }

    private final void $$robo$$android_icu_impl_TrieIterator$calculateNextSupplementaryElement(RangeValueIterator.Element element) {
        int currentValue = this.m_nextValue_;
        ++this.m_nextCodepoint_;
        ++this.m_nextBlockIndex_;
        if (UTF16.getTrailSurrogate(this.m_nextCodepoint_) != '\udc00') {
            if (!this.checkNullNextTrailIndex() && !this.checkBlockDetail(currentValue)) {
                this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
                this.m_currentCodepoint_ = this.m_nextCodepoint_;
                return;
            }
            ++this.m_nextIndex_;
            ++this.m_nextTrailIndexOffset_;
            if (!this.checkTrailBlock(currentValue)) {
                this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
                this.m_currentCodepoint_ = this.m_nextCodepoint_;
                return;
            }
        }
        int nextLead = UTF16.getLeadSurrogate(this.m_nextCodepoint_);
        while (nextLead < 56320) {
            int leadBlock = this.m_trie_.m_index_[nextLead >> 5] << 2;
            if (leadBlock == this.m_trie_.m_dataOffset_) {
                if (currentValue != this.m_initialValue_) {
                    this.m_nextValue_ = this.m_initialValue_;
                    this.m_nextBlock_ = leadBlock;
                    this.m_nextBlockIndex_ = 0;
                    this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
                    this.m_currentCodepoint_ = this.m_nextCodepoint_;
                    return;
                }
                this.m_nextCodepoint_ = Character.toCodePoint((char)(nextLead += 32), '\udc00');
                continue;
            }
            if (this.m_trie_.m_dataManipulate_ == null) {
                throw new NullPointerException("The field DataManipulate in this Trie is null");
            }
            this.m_nextIndex_ = this.m_trie_.m_dataManipulate_.getFoldingOffset(this.m_trie_.getValue(leadBlock + (nextLead & 0x1F)));
            if (this.m_nextIndex_ <= 0) {
                if (currentValue != this.m_initialValue_) {
                    this.m_nextValue_ = this.m_initialValue_;
                    this.m_nextBlock_ = this.m_trie_.m_dataOffset_;
                    this.m_nextBlockIndex_ = 0;
                    this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
                    this.m_currentCodepoint_ = this.m_nextCodepoint_;
                    return;
                }
                this.m_nextCodepoint_ += 1024;
            } else {
                this.m_nextTrailIndexOffset_ = 0;
                if (!this.checkTrailBlock(currentValue)) {
                    this.setResult(element, this.m_currentCodepoint_, this.m_nextCodepoint_, currentValue);
                    this.m_currentCodepoint_ = this.m_nextCodepoint_;
                    return;
                }
            }
            ++nextLead;
        }
        this.setResult(element, this.m_currentCodepoint_, 0x110000, currentValue);
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$checkBlockDetail(int currentValue) {
        while (this.m_nextBlockIndex_ < 32) {
            this.m_nextValue_ = this.extract(this.m_trie_.getValue(this.m_nextBlock_ + this.m_nextBlockIndex_));
            if (this.m_nextValue_ != currentValue) {
                return false;
            }
            ++this.m_nextBlockIndex_;
            ++this.m_nextCodepoint_;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$checkBlock(int currentValue) {
        int currentBlock = this.m_nextBlock_;
        this.m_nextBlock_ = this.m_trie_.m_index_[this.m_nextIndex_] << 2;
        if (this.m_nextBlock_ == currentBlock && this.m_nextCodepoint_ - this.m_currentCodepoint_ >= 32) {
            this.m_nextCodepoint_ += 32;
        } else if (this.m_nextBlock_ == this.m_trie_.m_dataOffset_) {
            if (currentValue != this.m_initialValue_) {
                this.m_nextValue_ = this.m_initialValue_;
                this.m_nextBlockIndex_ = 0;
                return false;
            }
            this.m_nextCodepoint_ += 32;
        } else if (!this.checkBlockDetail(currentValue)) {
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$checkTrailBlock(int currentValue) {
        while (this.m_nextTrailIndexOffset_ < 32) {
            this.m_nextBlockIndex_ = 0;
            if (!this.checkBlock(currentValue)) {
                return false;
            }
            ++this.m_nextTrailIndexOffset_;
            ++this.m_nextIndex_;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_impl_TrieIterator$checkNullNextTrailIndex() {
        if (this.m_nextIndex_ <= 0) {
            this.m_nextCodepoint_ += 1023;
            char nextLead = UTF16.getLeadSurrogate(this.m_nextCodepoint_);
            int leadBlock = this.m_trie_.m_index_[nextLead >> 5] << 2;
            if (this.m_trie_.m_dataManipulate_ == null) {
                throw new NullPointerException("The field DataManipulate in this Trie is null");
            }
            this.m_nextIndex_ = this.m_trie_.m_dataManipulate_.getFoldingOffset(this.m_trie_.getValue(leadBlock + (nextLead & 0x1F)));
            --this.m_nextIndex_;
            this.m_nextBlockIndex_ = 32;
            return true;
        }
        return false;
    }

    private void __constructor__(Trie trie) {
        this.$$robo$$android_icu_impl_TrieIterator$__constructor__(trie);
    }

    public TrieIterator(Trie trie) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TrieIterator$__constructor__(android.icu.impl.Trie ), 0, this, trie);
    }

    @Override
    public boolean next(RangeValueIterator.Element element) {
        return (boolean)InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_impl_TrieIterator$next(android.icu.util.RangeValueIterator$Element ), 0, this, element);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_TrieIterator$reset(), 0, this);
    }

    protected int extract(int n) {
        return (int)InvokeDynamicSupport.bootstrap("extract", $$robo$$android_icu_impl_TrieIterator$extract(int ), 0, this, n);
    }

    private void setResult(RangeValueIterator.Element element, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setResult", $$robo$$android_icu_impl_TrieIterator$setResult(android.icu.util.RangeValueIterator$Element int int int ), 0, this, element, n, n2, n3);
    }

    private boolean calculateNextBMPElement(RangeValueIterator.Element element) {
        return (boolean)InvokeDynamicSupport.bootstrap("calculateNextBMPElement", $$robo$$android_icu_impl_TrieIterator$calculateNextBMPElement(android.icu.util.RangeValueIterator$Element ), 0, this, element);
    }

    private void calculateNextSupplementaryElement(RangeValueIterator.Element element) {
        InvokeDynamicSupport.bootstrap("calculateNextSupplementaryElement", $$robo$$android_icu_impl_TrieIterator$calculateNextSupplementaryElement(android.icu.util.RangeValueIterator$Element ), 0, this, element);
    }

    private boolean checkBlockDetail(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkBlockDetail", $$robo$$android_icu_impl_TrieIterator$checkBlockDetail(int ), 0, this, n);
    }

    private boolean checkBlock(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkBlock", $$robo$$android_icu_impl_TrieIterator$checkBlock(int ), 0, this, n);
    }

    private boolean checkTrailBlock(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkTrailBlock", $$robo$$android_icu_impl_TrieIterator$checkTrailBlock(int ), 0, this, n);
    }

    private boolean checkNullNextTrailIndex() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkNullNextTrailIndex", $$robo$$android_icu_impl_TrieIterator$checkNullNextTrailIndex(), 0, this);
    }

    public /* synthetic */ TrieIterator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrieIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

