/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CalendarData;
import android.icu.impl.CalendarUtil;
import android.icu.impl.ICUCache;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SimpleCache;
import android.icu.impl.Utility;
import android.icu.text.NumberingSystem;
import android.icu.text.TimeZoneNames;
import android.icu.util.Calendar;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import android.icu.util.UResourceBundleIterator;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DateFormatSymbols
implements Serializable,
Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int FORMAT = 0;
    public static int STANDALONE = 1;
    @Deprecated
    public static int NUMERIC = 2;
    @Deprecated
    public static int DT_CONTEXT_COUNT = 3;
    public static int ABBREVIATED = 0;
    public static int WIDE = 1;
    public static int NARROW = 2;
    public static int SHORT = 3;
    @Deprecated
    public static int DT_WIDTH_COUNT = 4;
    static int DT_LEAP_MONTH_PATTERN_FORMAT_WIDE = 0;
    static int DT_LEAP_MONTH_PATTERN_FORMAT_ABBREV = 1;
    static int DT_LEAP_MONTH_PATTERN_FORMAT_NARROW = 2;
    static int DT_LEAP_MONTH_PATTERN_STANDALONE_WIDE = 3;
    static int DT_LEAP_MONTH_PATTERN_STANDALONE_ABBREV = 4;
    static int DT_LEAP_MONTH_PATTERN_STANDALONE_NARROW = 5;
    static int DT_LEAP_MONTH_PATTERN_NUMERIC = 6;
    static int DT_MONTH_PATTERN_COUNT = 7;
    static String DEFAULT_TIME_SEPARATOR = ":";
    static String ALTERNATE_TIME_SEPARATOR = ".";
    String[] eras;
    String[] eraNames;
    String[] narrowEras;
    String[] months;
    String[] shortMonths;
    String[] narrowMonths;
    String[] standaloneMonths;
    String[] standaloneShortMonths;
    String[] standaloneNarrowMonths;
    String[] weekdays;
    String[] shortWeekdays;
    String[] shorterWeekdays;
    String[] narrowWeekdays;
    String[] standaloneWeekdays;
    String[] standaloneShortWeekdays;
    String[] standaloneShorterWeekdays;
    String[] standaloneNarrowWeekdays;
    String[] ampms;
    String[] ampmsNarrow;
    private String timeSeparator;
    String[] shortQuarters;
    String[] quarters;
    String[] standaloneShortQuarters;
    String[] standaloneQuarters;
    String[] leapMonthPatterns;
    String[] shortYearNames;
    String[] shortZodiacNames;
    private String[][] zoneStrings;
    static String patternChars = "GyMdkHmsSEDFwWahKzYeugAZvcLQqVUOXxr";
    String localPatternChars;
    private static long serialVersionUID = -5987973545549424702L;
    private static String[][] CALENDAR_CLASSES;
    private static Map<String, CapitalizationContextUsage> contextUsageTypeMap;
    Map<CapitalizationContextUsage, boolean[]> capitalization;
    static int millisPerHour = 3600000;
    private static ICUCache<String, DateFormatSymbols> DFSCACHE;
    private ULocale requestedLocale;
    private ULocale validLocale;
    private ULocale actualLocale;

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__() {
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(Locale locale) {
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(ULocale locale) {
        this.eras = null;
        this.eraNames = null;
        this.narrowEras = null;
        this.months = null;
        this.shortMonths = null;
        this.narrowMonths = null;
        this.standaloneMonths = null;
        this.standaloneShortMonths = null;
        this.standaloneNarrowMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.shorterWeekdays = null;
        this.narrowWeekdays = null;
        this.standaloneWeekdays = null;
        this.standaloneShortWeekdays = null;
        this.standaloneShorterWeekdays = null;
        this.standaloneNarrowWeekdays = null;
        this.ampms = null;
        this.ampmsNarrow = null;
        this.timeSeparator = null;
        this.shortQuarters = null;
        this.quarters = null;
        this.standaloneShortQuarters = null;
        this.standaloneQuarters = null;
        this.leapMonthPatterns = null;
        this.shortYearNames = null;
        this.shortZodiacNames = null;
        this.zoneStrings = null;
        this.localPatternChars = null;
        this.capitalization = null;
        this.initializeData(locale, CalendarUtil.getCalendarType(locale));
    }

    private static final DateFormatSymbols $$robo$$android_icu_text_DateFormatSymbols$getInstance() {
        return new DateFormatSymbols();
    }

    private static final DateFormatSymbols $$robo$$android_icu_text_DateFormatSymbols$getInstance(Locale locale) {
        return new DateFormatSymbols(locale);
    }

    private static final DateFormatSymbols $$robo$$android_icu_text_DateFormatSymbols$getInstance(ULocale locale) {
        return new DateFormatSymbols(locale);
    }

    private static final Locale[] $$robo$$android_icu_text_DateFormatSymbols$getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_DateFormatSymbols$getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getEras() {
        return this.duplicate(this.eras);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getEraNames() {
        return this.duplicate(this.eraNames);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setEraNames(String[] newEraNames) {
        this.eraNames = this.duplicate(newEraNames);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getMonths() {
        return this.duplicate(this.months);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getMonths(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.months;
                        break;
                    }
                    case 0: 
                    case 3: {
                        returnValue = this.shortMonths;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowMonths;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneMonths;
                        break block0;
                    }
                    case 0: 
                    case 3: {
                        returnValue = this.standaloneShortMonths;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowMonths;
                    }
                }
            }
        }
        if (returnValue == null) {
            throw new IllegalArgumentException("Bad context or width argument");
        }
        return this.duplicate(returnValue);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setMonths(String[] newMonths, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.months = this.duplicate(newMonths);
                        break block0;
                    }
                    case 0: {
                        this.shortMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 2: {
                        this.narrowMonths = this.duplicate(newMonths);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortMonths = this.duplicate(newMonths);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowMonths = this.duplicate(newMonths);
                        break block0;
                    }
                }
            }
        }
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getWeekdays(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.weekdays;
                        break;
                    }
                    case 0: {
                        returnValue = this.shortWeekdays;
                        break;
                    }
                    case 3: {
                        returnValue = this.shorterWeekdays != null ? this.shorterWeekdays : this.shortWeekdays;
                        break;
                    }
                    case 2: {
                        returnValue = this.narrowWeekdays;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneWeekdays;
                        break block0;
                    }
                    case 0: {
                        returnValue = this.standaloneShortWeekdays;
                        break block0;
                    }
                    case 3: {
                        returnValue = this.standaloneShorterWeekdays != null ? this.standaloneShorterWeekdays : this.standaloneShortWeekdays;
                        break block0;
                    }
                    case 2: {
                        returnValue = this.standaloneNarrowWeekdays;
                    }
                }
            }
        }
        if (returnValue == null) {
            throw new IllegalArgumentException("Bad context or width argument");
        }
        return this.duplicate(returnValue);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setWeekdays(String[] newWeekdays, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.weekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 0: {
                        this.shortWeekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 3: {
                        this.shorterWeekdays = this.duplicate(newWeekdays);
                        break;
                    }
                    case 2: {
                        this.narrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 3: {
                        this.standaloneShorterWeekdays = this.duplicate(newWeekdays);
                        break block0;
                    }
                    case 2: {
                        this.standaloneNarrowWeekdays = this.duplicate(newWeekdays);
                    }
                }
            }
        }
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setShortWeekdays(String[] newAbbrevWeekdays) {
        this.shortWeekdays = this.duplicate(newAbbrevWeekdays);
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getQuarters(int context, int width) {
        String[] returnValue = null;
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        returnValue = this.quarters;
                        break;
                    }
                    case 0: 
                    case 3: {
                        returnValue = this.shortQuarters;
                        break;
                    }
                    case 2: {
                        returnValue = null;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        returnValue = this.standaloneQuarters;
                        break block0;
                    }
                    case 0: 
                    case 3: {
                        returnValue = this.standaloneShortQuarters;
                        break block0;
                    }
                    case 2: {
                        returnValue = null;
                    }
                }
            }
        }
        if (returnValue == null) {
            throw new IllegalArgumentException("Bad context or width argument");
        }
        return this.duplicate(returnValue);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setQuarters(String[] newQuarters, int context, int width) {
        block0 : switch (context) {
            case 0: {
                switch (width) {
                    case 1: {
                        this.quarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 0: {
                        this.shortQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (width) {
                    case 1: {
                        this.standaloneQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 0: {
                        this.standaloneShortQuarters = this.duplicate(newQuarters);
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                }
            }
        }
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getYearNames(int context, int width) {
        if (this.shortYearNames != null) {
            return this.duplicate(this.shortYearNames);
        }
        return null;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setYearNames(String[] yearNames, int context, int width) {
        if (context == 0 && width == 0) {
            this.shortYearNames = this.duplicate(yearNames);
        }
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getZodiacNames(int context, int width) {
        if (this.shortZodiacNames != null) {
            return this.duplicate(this.shortZodiacNames);
        }
        return null;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setZodiacNames(String[] zodiacNames, int context, int width) {
        if (context == 0 && width == 0) {
            this.shortZodiacNames = this.duplicate(zodiacNames);
        }
    }

    @Deprecated
    private final String $$robo$$android_icu_text_DateFormatSymbols$getLeapMonthPattern(int context, int width) {
        if (this.leapMonthPatterns != null) {
            int leapMonthPatternIndex = -1;
            switch (context) {
                case 0: {
                    switch (width) {
                        case 1: {
                            leapMonthPatternIndex = 0;
                            break;
                        }
                        case 0: 
                        case 3: {
                            leapMonthPatternIndex = 1;
                            break;
                        }
                        case 2: {
                            leapMonthPatternIndex = 2;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (width) {
                        case 1: {
                            leapMonthPatternIndex = 3;
                            break;
                        }
                        case 0: 
                        case 3: {
                            leapMonthPatternIndex = 1;
                            break;
                        }
                        case 2: {
                            leapMonthPatternIndex = 5;
                        }
                    }
                    break;
                }
                case 2: {
                    leapMonthPatternIndex = 6;
                }
            }
            if (leapMonthPatternIndex < 0) {
                throw new IllegalArgumentException("Bad context or width argument");
            }
            return this.leapMonthPatterns[leapMonthPatternIndex];
        }
        return null;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_DateFormatSymbols$setLeapMonthPattern(String leapMonthPattern, int context, int width) {
        if (this.leapMonthPatterns != null) {
            int leapMonthPatternIndex = -1;
            block0 : switch (context) {
                case 0: {
                    switch (width) {
                        case 1: {
                            leapMonthPatternIndex = 0;
                            break block0;
                        }
                        case 0: {
                            leapMonthPatternIndex = 1;
                            break block0;
                        }
                        case 2: {
                            leapMonthPatternIndex = 2;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (width) {
                        case 1: {
                            leapMonthPatternIndex = 3;
                            break block0;
                        }
                        case 0: {
                            leapMonthPatternIndex = 1;
                            break block0;
                        }
                        case 2: {
                            leapMonthPatternIndex = 5;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    leapMonthPatternIndex = 6;
                    break;
                }
            }
            if (leapMonthPatternIndex >= 0) {
                this.leapMonthPatterns[leapMonthPatternIndex] = leapMonthPattern;
            }
        }
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    private final String $$robo$$android_icu_text_DateFormatSymbols$getTimeSeparatorString() {
        return this.timeSeparator;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setTimeSeparatorString(String newTimeSeparator) {
        this.timeSeparator = newTimeSeparator;
    }

    private final String[][] $$robo$$android_icu_text_DateFormatSymbols$getZoneStrings() {
        if (this.zoneStrings != null) {
            return this.duplicate(this.zoneStrings);
        }
        String[] tzIDs = TimeZone.getAvailableIDs();
        TimeZoneNames tznames = TimeZoneNames.getInstance(this.validLocale);
        tznames.loadAllDisplayNames();
        TimeZoneNames.NameType[] types = new TimeZoneNames.NameType[]{TimeZoneNames.NameType.LONG_STANDARD, TimeZoneNames.NameType.SHORT_STANDARD, TimeZoneNames.NameType.LONG_DAYLIGHT, TimeZoneNames.NameType.SHORT_DAYLIGHT};
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        String[][] array2 = new String[tzIDs.length][5];
        for (int i = 0; i < tzIDs.length; ++i) {
            String canonicalID = TimeZone.getCanonicalID(tzIDs[i]);
            if (canonicalID == null) {
                canonicalID = tzIDs[i];
            }
            array2[i][0] = tzIDs[i];
            tznames.getDisplayNames(canonicalID, types, (long)now, array2[i], 1);
        }
        this.zoneStrings = array2;
        return this.zoneStrings;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setZoneStrings(String[][] newZoneStrings) {
        this.zoneStrings = this.duplicate(newZoneStrings);
    }

    private final String $$robo$$android_icu_text_DateFormatSymbols$getLocalPatternChars() {
        return this.localPatternChars;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars;
    }

    private final Object $$robo$$android_icu_text_DateFormatSymbols$clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private final int $$robo$$android_icu_text_DateFormatSymbols$hashCode() {
        return this.requestedLocale.toString().hashCode();
    }

    private final boolean $$robo$$android_icu_text_DateFormatSymbols$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Utility.arrayEquals(this.eras, (Object)that.eras) && Utility.arrayEquals(this.eraNames, (Object)that.eraNames) && Utility.arrayEquals(this.months, (Object)that.months) && Utility.arrayEquals(this.shortMonths, (Object)that.shortMonths) && Utility.arrayEquals(this.narrowMonths, (Object)that.narrowMonths) && Utility.arrayEquals(this.standaloneMonths, (Object)that.standaloneMonths) && Utility.arrayEquals(this.standaloneShortMonths, (Object)that.standaloneShortMonths) && Utility.arrayEquals(this.standaloneNarrowMonths, (Object)that.standaloneNarrowMonths) && Utility.arrayEquals(this.weekdays, (Object)that.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)that.shortWeekdays) && Utility.arrayEquals(this.shorterWeekdays, (Object)that.shorterWeekdays) && Utility.arrayEquals(this.narrowWeekdays, (Object)that.narrowWeekdays) && Utility.arrayEquals(this.standaloneWeekdays, (Object)that.standaloneWeekdays) && Utility.arrayEquals(this.standaloneShortWeekdays, (Object)that.standaloneShortWeekdays) && Utility.arrayEquals(this.standaloneShorterWeekdays, (Object)that.standaloneShorterWeekdays) && Utility.arrayEquals(this.standaloneNarrowWeekdays, (Object)that.standaloneNarrowWeekdays) && Utility.arrayEquals(this.ampms, (Object)that.ampms) && Utility.arrayEquals(this.ampmsNarrow, (Object)that.ampmsNarrow) && Utility.arrayEquals(this.timeSeparator, (Object)that.timeSeparator) && DateFormatSymbols.arrayOfArrayEquals(this.zoneStrings, that.zoneStrings) && this.requestedLocale.getDisplayName().equals(that.requestedLocale.getDisplayName()) && Utility.arrayEquals(this.localPatternChars, (Object)that.localPatternChars);
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$initializeData(ULocale desiredLocale, String type) {
        DateFormatSymbols dfs;
        String key = desiredLocale.getBaseName() + "+" + type;
        String ns = desiredLocale.getKeywordValue("numbers");
        if (ns != null && ns.length() > 0) {
            key = key + "+" + ns;
        }
        if ((dfs = DFSCACHE.get(key)) == null) {
            CalendarData calData = new CalendarData(desiredLocale, type);
            this.initializeData(desiredLocale, calData);
            if (this.getClass().getName().equals("android.icu.text.DateFormatSymbols")) {
                dfs = (DateFormatSymbols)this.clone();
                DFSCACHE.put(key, dfs);
            }
        } else {
            this.initializeData(dfs);
        }
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$initializeData(DateFormatSymbols dfs) {
        this.eras = dfs.eras;
        this.eraNames = dfs.eraNames;
        this.narrowEras = dfs.narrowEras;
        this.months = dfs.months;
        this.shortMonths = dfs.shortMonths;
        this.narrowMonths = dfs.narrowMonths;
        this.standaloneMonths = dfs.standaloneMonths;
        this.standaloneShortMonths = dfs.standaloneShortMonths;
        this.standaloneNarrowMonths = dfs.standaloneNarrowMonths;
        this.weekdays = dfs.weekdays;
        this.shortWeekdays = dfs.shortWeekdays;
        this.shorterWeekdays = dfs.shorterWeekdays;
        this.narrowWeekdays = dfs.narrowWeekdays;
        this.standaloneWeekdays = dfs.standaloneWeekdays;
        this.standaloneShortWeekdays = dfs.standaloneShortWeekdays;
        this.standaloneShorterWeekdays = dfs.standaloneShorterWeekdays;
        this.standaloneNarrowWeekdays = dfs.standaloneNarrowWeekdays;
        this.ampms = dfs.ampms;
        this.ampmsNarrow = dfs.ampmsNarrow;
        this.timeSeparator = dfs.timeSeparator;
        this.shortQuarters = dfs.shortQuarters;
        this.quarters = dfs.quarters;
        this.standaloneShortQuarters = dfs.standaloneShortQuarters;
        this.standaloneQuarters = dfs.standaloneQuarters;
        this.leapMonthPatterns = dfs.leapMonthPatterns;
        this.shortYearNames = dfs.shortYearNames;
        this.shortZodiacNames = dfs.shortZodiacNames;
        this.zoneStrings = dfs.zoneStrings;
        this.localPatternChars = dfs.localPatternChars;
        this.capitalization = dfs.capitalization;
        this.actualLocale = dfs.actualLocale;
        this.validLocale = dfs.validLocale;
        this.requestedLocale = dfs.requestedLocale;
    }

    @Deprecated
    private final void $$robo$$android_icu_text_DateFormatSymbols$initializeData(ULocale desiredLocale, CalendarData calData) {
        NumberingSystem ns;
        CapitalizationContextUsage[] allUsages;
        this.eras = calData.getEras("abbreviated");
        this.eraNames = calData.getEras("wide");
        this.narrowEras = calData.getEras("narrow");
        this.months = calData.getStringArray("monthNames", "wide");
        this.shortMonths = calData.getStringArray("monthNames", "abbreviated");
        this.narrowMonths = calData.getStringArray("monthNames", "narrow");
        this.standaloneMonths = calData.getStringArray("monthNames", "stand-alone", "wide");
        this.standaloneShortMonths = calData.getStringArray("monthNames", "stand-alone", "abbreviated");
        this.standaloneNarrowMonths = calData.getStringArray("monthNames", "stand-alone", "narrow");
        String[] lWeekdays = calData.getStringArray("dayNames", "wide");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)lWeekdays, (int)0, (Object)this.weekdays, (int)1, (int)lWeekdays.length);
        String[] aWeekdays = calData.getStringArray("dayNames", "abbreviated");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)aWeekdays, (int)0, (Object)this.shortWeekdays, (int)1, (int)aWeekdays.length);
        String[] sWeekdays = calData.getStringArray("dayNames", "short");
        this.shorterWeekdays = new String[8];
        this.shorterWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)sWeekdays, (int)0, (Object)this.shorterWeekdays, (int)1, (int)sWeekdays.length);
        String[] nWeekdays = null;
        try {
            nWeekdays = calData.getStringArray("dayNames", "narrow");
        }
        catch (MissingResourceException e) {
            try {
                nWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
            }
            catch (MissingResourceException e1) {
                nWeekdays = calData.getStringArray("dayNames", "abbreviated");
            }
        }
        this.narrowWeekdays = new String[8];
        this.narrowWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)nWeekdays, (int)0, (Object)this.narrowWeekdays, (int)1, (int)nWeekdays.length);
        String[] swWeekdays = null;
        swWeekdays = calData.getStringArray("dayNames", "stand-alone", "wide");
        this.standaloneWeekdays = new String[8];
        this.standaloneWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)swWeekdays, (int)0, (Object)this.standaloneWeekdays, (int)1, (int)swWeekdays.length);
        String[] saWeekdays = null;
        saWeekdays = calData.getStringArray("dayNames", "stand-alone", "abbreviated");
        this.standaloneShortWeekdays = new String[8];
        this.standaloneShortWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)saWeekdays, (int)0, (Object)this.standaloneShortWeekdays, (int)1, (int)saWeekdays.length);
        String[] ssWeekdays = null;
        ssWeekdays = calData.getStringArray("dayNames", "stand-alone", "short");
        this.standaloneShorterWeekdays = new String[8];
        this.standaloneShorterWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ssWeekdays, (int)0, (Object)this.standaloneShorterWeekdays, (int)1, (int)ssWeekdays.length);
        String[] snWeekdays = null;
        snWeekdays = calData.getStringArray("dayNames", "stand-alone", "narrow");
        this.standaloneNarrowWeekdays = new String[8];
        this.standaloneNarrowWeekdays[0] = "";
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)snWeekdays, (int)0, (Object)this.standaloneNarrowWeekdays, (int)1, (int)snWeekdays.length);
        this.ampms = calData.getStringArray("AmPmMarkers");
        this.ampmsNarrow = calData.getStringArray("AmPmMarkersNarrow");
        this.quarters = calData.getStringArray("quarters", "wide");
        this.shortQuarters = calData.getStringArray("quarters", "abbreviated");
        this.standaloneQuarters = calData.getStringArray("quarters", "stand-alone", "wide");
        this.standaloneShortQuarters = calData.getStringArray("quarters", "stand-alone", "abbreviated");
        ICUResourceBundle monthPatternsBundle = null;
        try {
            monthPatternsBundle = calData.get("monthPatterns");
        }
        catch (MissingResourceException e) {
            monthPatternsBundle = null;
        }
        if (monthPatternsBundle != null) {
            this.leapMonthPatterns = new String[7];
            this.leapMonthPatterns[0] = calData.get("monthPatterns", "wide").get("leap").getString();
            this.leapMonthPatterns[1] = calData.get("monthPatterns", "abbreviated").get("leap").getString();
            this.leapMonthPatterns[2] = calData.get("monthPatterns", "narrow").get("leap").getString();
            this.leapMonthPatterns[3] = calData.get("monthPatterns", "stand-alone", "wide").get("leap").getString();
            this.leapMonthPatterns[4] = calData.get("monthPatterns", "stand-alone", "abbreviated").get("leap").getString();
            this.leapMonthPatterns[5] = calData.get("monthPatterns", "stand-alone", "narrow").get("leap").getString();
            this.leapMonthPatterns[6] = calData.get("monthPatterns", "numeric", "all").get("leap").getString();
        }
        ICUResourceBundle cyclicNameSetsBundle = null;
        try {
            cyclicNameSetsBundle = calData.get("cyclicNameSets");
        }
        catch (MissingResourceException e) {
            cyclicNameSetsBundle = null;
        }
        if (cyclicNameSetsBundle != null) {
            this.shortYearNames = calData.get("cyclicNameSets", "years", "format", "abbreviated").getStringArray();
            this.shortZodiacNames = calData.get("cyclicNameSets", "zodiacs", "format", "abbreviated").getStringArray();
        }
        this.requestedLocale = desiredLocale;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", desiredLocale);
        this.localPatternChars = "GyMdkHmsSEDFwWahKzYeugAZvcLQqVUOXxr";
        ULocale uloc = rb.getULocale();
        this.setLocale(uloc, uloc);
        this.capitalization = new HashMap<CapitalizationContextUsage, boolean[]>();
        boolean[] noTransforms = new boolean[]{false, false};
        for (CapitalizationContextUsage usage : allUsages = CapitalizationContextUsage.values()) {
            this.capitalization.put(usage, noTransforms);
        }
        ICUResourceBundle contextTransformsBundle = null;
        try {
            contextTransformsBundle = rb.getWithFallback("contextTransforms");
        }
        catch (MissingResourceException e) {
            contextTransformsBundle = null;
        }
        if (contextTransformsBundle != null) {
            UResourceBundleIterator ctIterator = contextTransformsBundle.getIterator();
            while (ctIterator.hasNext()) {
                String usageKey;
                CapitalizationContextUsage usage;
                UResourceBundle contextTransformUsage = ctIterator.next();
                int[] intVector = contextTransformUsage.getIntVector();
                if (intVector.length < 2 || (usage = contextUsageTypeMap.get(usageKey = contextTransformUsage.getKey())) == null) continue;
                boolean[] transforms = new boolean[]{intVector[0] != 0, intVector[1] != 0};
                this.capitalization.put(usage, transforms);
            }
        }
        String nsName = (ns = NumberingSystem.getInstance(desiredLocale)) == null ? "latn" : ns.getName();
        String tsPath = "NumberElements/" + nsName + "/symbols/timeSeparator";
        try {
            this.setTimeSeparatorString(rb.getStringWithFallback(tsPath));
        }
        catch (MissingResourceException e) {
            this.setTimeSeparatorString(":");
        }
    }

    private static final boolean $$robo$$android_icu_text_DateFormatSymbols$arrayOfArrayEquals(Object[][] aa1, Object[][] aa2) {
        if (aa1 == aa2) {
            return true;
        }
        if (aa1 == null || aa2 == null) {
            return false;
        }
        if (aa1.length != aa2.length) {
            return false;
        }
        boolean equal = true;
        for (int i = 0; i < aa1.length && (equal = Utility.arrayEquals(aa1[i], (Object)aa2[i])); ++i) {
        }
        return equal;
    }

    private final String[] $$robo$$android_icu_text_DateFormatSymbols$duplicate(String[] srcArray) {
        return (String[])srcArray.clone();
    }

    private final String[][] $$robo$$android_icu_text_DateFormatSymbols$duplicate(String[][] srcArray) {
        String[][] aCopy = new String[srcArray.length][];
        for (int i = 0; i < srcArray.length; ++i) {
            aCopy[i] = this.duplicate(srcArray[i]);
        }
        return aCopy;
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(Calendar cal, Locale locale) {
        this.eras = null;
        this.eraNames = null;
        this.narrowEras = null;
        this.months = null;
        this.shortMonths = null;
        this.narrowMonths = null;
        this.standaloneMonths = null;
        this.standaloneShortMonths = null;
        this.standaloneNarrowMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.shorterWeekdays = null;
        this.narrowWeekdays = null;
        this.standaloneWeekdays = null;
        this.standaloneShortWeekdays = null;
        this.standaloneShorterWeekdays = null;
        this.standaloneNarrowWeekdays = null;
        this.ampms = null;
        this.ampmsNarrow = null;
        this.timeSeparator = null;
        this.shortQuarters = null;
        this.quarters = null;
        this.standaloneShortQuarters = null;
        this.standaloneQuarters = null;
        this.leapMonthPatterns = null;
        this.shortYearNames = null;
        this.shortZodiacNames = null;
        this.zoneStrings = null;
        this.localPatternChars = null;
        this.capitalization = null;
        this.initializeData(ULocale.forLocale(locale), cal.getType());
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(Calendar cal, ULocale locale) {
        this.eras = null;
        this.eraNames = null;
        this.narrowEras = null;
        this.months = null;
        this.shortMonths = null;
        this.narrowMonths = null;
        this.standaloneMonths = null;
        this.standaloneShortMonths = null;
        this.standaloneNarrowMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.shorterWeekdays = null;
        this.narrowWeekdays = null;
        this.standaloneWeekdays = null;
        this.standaloneShortWeekdays = null;
        this.standaloneShorterWeekdays = null;
        this.standaloneNarrowWeekdays = null;
        this.ampms = null;
        this.ampmsNarrow = null;
        this.timeSeparator = null;
        this.shortQuarters = null;
        this.quarters = null;
        this.standaloneShortQuarters = null;
        this.standaloneQuarters = null;
        this.leapMonthPatterns = null;
        this.shortYearNames = null;
        this.shortZodiacNames = null;
        this.zoneStrings = null;
        this.localPatternChars = null;
        this.capitalization = null;
        this.initializeData(locale, cal.getType());
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(Class<? extends Calendar> calendarClass, Locale locale) {
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(Class<? extends Calendar> calendarClass, ULocale locale) {
        this.eras = null;
        this.eraNames = null;
        this.narrowEras = null;
        this.months = null;
        this.shortMonths = null;
        this.narrowMonths = null;
        this.standaloneMonths = null;
        this.standaloneShortMonths = null;
        this.standaloneNarrowMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.shorterWeekdays = null;
        this.narrowWeekdays = null;
        this.standaloneWeekdays = null;
        this.standaloneShortWeekdays = null;
        this.standaloneShorterWeekdays = null;
        this.standaloneNarrowWeekdays = null;
        this.ampms = null;
        this.ampmsNarrow = null;
        this.timeSeparator = null;
        this.shortQuarters = null;
        this.quarters = null;
        this.standaloneShortQuarters = null;
        this.standaloneQuarters = null;
        this.leapMonthPatterns = null;
        this.shortYearNames = null;
        this.shortZodiacNames = null;
        this.zoneStrings = null;
        this.localPatternChars = null;
        this.capitalization = null;
        String fullName = calendarClass.getName();
        int lastDot = fullName.lastIndexOf(46);
        String className = fullName.substring(lastDot + 1);
        String calType = null;
        for (String[] calClassInfo : CALENDAR_CLASSES) {
            if (!calClassInfo[0].equals(className)) continue;
            calType = calClassInfo[1];
            break;
        }
        if (calType == null) {
            calType = className.replaceAll("Calendar", "").toLowerCase(Locale.ENGLISH);
        }
        this.initializeData(locale, calType);
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(ResourceBundle bundle, Locale locale) {
    }

    private void $$robo$$android_icu_text_DateFormatSymbols$__constructor__(ResourceBundle bundle, ULocale locale) {
        this.eras = null;
        this.eraNames = null;
        this.narrowEras = null;
        this.months = null;
        this.shortMonths = null;
        this.narrowMonths = null;
        this.standaloneMonths = null;
        this.standaloneShortMonths = null;
        this.standaloneNarrowMonths = null;
        this.weekdays = null;
        this.shortWeekdays = null;
        this.shorterWeekdays = null;
        this.narrowWeekdays = null;
        this.standaloneWeekdays = null;
        this.standaloneShortWeekdays = null;
        this.standaloneShorterWeekdays = null;
        this.standaloneNarrowWeekdays = null;
        this.ampms = null;
        this.ampmsNarrow = null;
        this.timeSeparator = null;
        this.shortQuarters = null;
        this.quarters = null;
        this.standaloneShortQuarters = null;
        this.standaloneQuarters = null;
        this.leapMonthPatterns = null;
        this.shortYearNames = null;
        this.shortZodiacNames = null;
        this.zoneStrings = null;
        this.localPatternChars = null;
        this.capitalization = null;
        this.initializeData(locale, new CalendarData((ICUResourceBundle)bundle, CalendarUtil.getCalendarType(locale)));
    }

    @Deprecated
    private static final ResourceBundle $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(Class<? extends Calendar> calendarClass, Locale locale) throws MissingResourceException {
        return null;
    }

    @Deprecated
    private static final ResourceBundle $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(Class<? extends Calendar> calendarClass, ULocale locale) throws MissingResourceException {
        return null;
    }

    @Deprecated
    private static final ResourceBundle $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(Calendar cal, Locale locale) throws MissingResourceException {
        return null;
    }

    @Deprecated
    private static final ResourceBundle $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(Calendar cal, ULocale locale) throws MissingResourceException {
        return null;
    }

    private final ULocale $$robo$$android_icu_text_DateFormatSymbols$getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    private final void $$robo$$android_icu_text_DateFormatSymbols$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    static void __staticInitializer__() {
        CALENDAR_CLASSES = new String[][]{{"GregorianCalendar", "gregorian"}, {"JapaneseCalendar", "japanese"}, {"BuddhistCalendar", "buddhist"}, {"TaiwanCalendar", "roc"}, {"PersianCalendar", "persian"}, {"IslamicCalendar", "islamic"}, {"HebrewCalendar", "hebrew"}, {"ChineseCalendar", "chinese"}, {"IndianCalendar", "indian"}, {"CopticCalendar", "coptic"}, {"EthiopicCalendar", "ethiopic"}};
        contextUsageTypeMap = new HashMap<String, CapitalizationContextUsage>();
        contextUsageTypeMap.put("month-format-except-narrow", CapitalizationContextUsage.MONTH_FORMAT);
        contextUsageTypeMap.put("month-standalone-except-narrow", CapitalizationContextUsage.MONTH_STANDALONE);
        contextUsageTypeMap.put("month-narrow", CapitalizationContextUsage.MONTH_NARROW);
        contextUsageTypeMap.put("day-format-except-narrow", CapitalizationContextUsage.DAY_FORMAT);
        contextUsageTypeMap.put("day-standalone-except-narrow", CapitalizationContextUsage.DAY_STANDALONE);
        contextUsageTypeMap.put("day-narrow", CapitalizationContextUsage.DAY_NARROW);
        contextUsageTypeMap.put("era-name", CapitalizationContextUsage.ERA_WIDE);
        contextUsageTypeMap.put("era-abbr", CapitalizationContextUsage.ERA_ABBREV);
        contextUsageTypeMap.put("era-narrow", CapitalizationContextUsage.ERA_NARROW);
        contextUsageTypeMap.put("zone-long", CapitalizationContextUsage.ZONE_LONG);
        contextUsageTypeMap.put("zone-short", CapitalizationContextUsage.ZONE_SHORT);
        contextUsageTypeMap.put("metazone-long", CapitalizationContextUsage.METAZONE_LONG);
        contextUsageTypeMap.put("metazone-short", CapitalizationContextUsage.METAZONE_SHORT);
        DFSCACHE = new SimpleCache<String, DateFormatSymbols>();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__();
    }

    public DateFormatSymbols() {
        this(ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(), 0, this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(locale);
    }

    public DateFormatSymbols(Locale locale) {
        this(ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(uLocale);
    }

    public DateFormatSymbols(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static DateFormatSymbols getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormatSymbols$getInstance(), 0);
    }

    public static DateFormatSymbols getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormatSymbols$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static DateFormatSymbols getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DateFormatSymbols$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_DateFormatSymbols$getAvailableLocales(), 0);
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_DateFormatSymbols$getAvailableULocales(), 0);
    }

    public String[] getEras() {
        return InvokeDynamicSupport.bootstrap("getEras", $$robo$$android_icu_text_DateFormatSymbols$getEras(), 0, this);
    }

    public void setEras(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setEras", $$robo$$android_icu_text_DateFormatSymbols$setEras(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getEraNames() {
        return InvokeDynamicSupport.bootstrap("getEraNames", $$robo$$android_icu_text_DateFormatSymbols$getEraNames(), 0, this);
    }

    public void setEraNames(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setEraNames", $$robo$$android_icu_text_DateFormatSymbols$setEraNames(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getMonths() {
        return InvokeDynamicSupport.bootstrap("getMonths", $$robo$$android_icu_text_DateFormatSymbols$getMonths(), 0, this);
    }

    public String[] getMonths(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getMonths", $$robo$$android_icu_text_DateFormatSymbols$getMonths(int int ), 0, this, n, n2);
    }

    public void setMonths(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setMonths", $$robo$$android_icu_text_DateFormatSymbols$setMonths(java.lang.String[] ), 0, this, stringArray);
    }

    public void setMonths(String[] stringArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setMonths", $$robo$$android_icu_text_DateFormatSymbols$setMonths(java.lang.String[] int int ), 0, this, stringArray, n, n2);
    }

    public String[] getShortMonths() {
        return InvokeDynamicSupport.bootstrap("getShortMonths", $$robo$$android_icu_text_DateFormatSymbols$getShortMonths(), 0, this);
    }

    public void setShortMonths(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setShortMonths", $$robo$$android_icu_text_DateFormatSymbols$setShortMonths(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getWeekdays() {
        return InvokeDynamicSupport.bootstrap("getWeekdays", $$robo$$android_icu_text_DateFormatSymbols$getWeekdays(), 0, this);
    }

    public String[] getWeekdays(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getWeekdays", $$robo$$android_icu_text_DateFormatSymbols$getWeekdays(int int ), 0, this, n, n2);
    }

    public void setWeekdays(String[] stringArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setWeekdays", $$robo$$android_icu_text_DateFormatSymbols$setWeekdays(java.lang.String[] int int ), 0, this, stringArray, n, n2);
    }

    public void setWeekdays(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setWeekdays", $$robo$$android_icu_text_DateFormatSymbols$setWeekdays(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getShortWeekdays() {
        return InvokeDynamicSupport.bootstrap("getShortWeekdays", $$robo$$android_icu_text_DateFormatSymbols$getShortWeekdays(), 0, this);
    }

    public void setShortWeekdays(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setShortWeekdays", $$robo$$android_icu_text_DateFormatSymbols$setShortWeekdays(java.lang.String[] ), 0, this, stringArray);
    }

    public String[] getQuarters(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getQuarters", $$robo$$android_icu_text_DateFormatSymbols$getQuarters(int int ), 0, this, n, n2);
    }

    public void setQuarters(String[] stringArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setQuarters", $$robo$$android_icu_text_DateFormatSymbols$setQuarters(java.lang.String[] int int ), 0, this, stringArray, n, n2);
    }

    public String[] getYearNames(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getYearNames", $$robo$$android_icu_text_DateFormatSymbols$getYearNames(int int ), 0, this, n, n2);
    }

    public void setYearNames(String[] stringArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setYearNames", $$robo$$android_icu_text_DateFormatSymbols$setYearNames(java.lang.String[] int int ), 0, this, stringArray, n, n2);
    }

    public String[] getZodiacNames(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getZodiacNames", $$robo$$android_icu_text_DateFormatSymbols$getZodiacNames(int int ), 0, this, n, n2);
    }

    public void setZodiacNames(String[] stringArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setZodiacNames", $$robo$$android_icu_text_DateFormatSymbols$setZodiacNames(java.lang.String[] int int ), 0, this, stringArray, n, n2);
    }

    @Deprecated
    public String getLeapMonthPattern(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getLeapMonthPattern", $$robo$$android_icu_text_DateFormatSymbols$getLeapMonthPattern(int int ), 0, this, n, n2);
    }

    @Deprecated
    public void setLeapMonthPattern(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLeapMonthPattern", $$robo$$android_icu_text_DateFormatSymbols$setLeapMonthPattern(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public String[] getAmPmStrings() {
        return InvokeDynamicSupport.bootstrap("getAmPmStrings", $$robo$$android_icu_text_DateFormatSymbols$getAmPmStrings(), 0, this);
    }

    public void setAmPmStrings(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setAmPmStrings", $$robo$$android_icu_text_DateFormatSymbols$setAmPmStrings(java.lang.String[] ), 0, this, stringArray);
    }

    public String getTimeSeparatorString() {
        return InvokeDynamicSupport.bootstrap("getTimeSeparatorString", $$robo$$android_icu_text_DateFormatSymbols$getTimeSeparatorString(), 0, this);
    }

    public void setTimeSeparatorString(String string2) {
        InvokeDynamicSupport.bootstrap("setTimeSeparatorString", $$robo$$android_icu_text_DateFormatSymbols$setTimeSeparatorString(java.lang.String ), 0, this, string2);
    }

    public String[][] getZoneStrings() {
        return InvokeDynamicSupport.bootstrap("getZoneStrings", $$robo$$android_icu_text_DateFormatSymbols$getZoneStrings(), 0, this);
    }

    public void setZoneStrings(String[][] stringArray) {
        InvokeDynamicSupport.bootstrap("setZoneStrings", $$robo$$android_icu_text_DateFormatSymbols$setZoneStrings(java.lang.String[][] ), 0, this, stringArray);
    }

    public String getLocalPatternChars() {
        return InvokeDynamicSupport.bootstrap("getLocalPatternChars", $$robo$$android_icu_text_DateFormatSymbols$getLocalPatternChars(), 0, this);
    }

    public void setLocalPatternChars(String string2) {
        InvokeDynamicSupport.bootstrap("setLocalPatternChars", $$robo$$android_icu_text_DateFormatSymbols$setLocalPatternChars(java.lang.String ), 0, this, string2);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DateFormatSymbols$clone(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DateFormatSymbols$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DateFormatSymbols$equals(java.lang.Object ), 0, this, object);
    }

    protected void initializeData(ULocale uLocale, String string2) {
        InvokeDynamicSupport.bootstrap("initializeData", $$robo$$android_icu_text_DateFormatSymbols$initializeData(android.icu.util.ULocale java.lang.String ), 0, this, uLocale, string2);
    }

    void initializeData(DateFormatSymbols dateFormatSymbols) {
        InvokeDynamicSupport.bootstrap("initializeData", $$robo$$android_icu_text_DateFormatSymbols$initializeData(android.icu.text.DateFormatSymbols ), 0, this, dateFormatSymbols);
    }

    @Deprecated
    protected void initializeData(ULocale uLocale, CalendarData calendarData) {
        InvokeDynamicSupport.bootstrap("initializeData", $$robo$$android_icu_text_DateFormatSymbols$initializeData(android.icu.util.ULocale android.icu.impl.CalendarData ), 0, this, uLocale, calendarData);
    }

    private static boolean arrayOfArrayEquals(Object[][] objectArray, Object[][] objectArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("arrayOfArrayEquals", $$robo$$android_icu_text_DateFormatSymbols$arrayOfArrayEquals(java.lang.Object[][] java.lang.Object[][] ), 0, (Object[][])objectArray, (Object[][])objectArray2);
    }

    private String[] duplicate(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("duplicate", $$robo$$android_icu_text_DateFormatSymbols$duplicate(java.lang.String[] ), 0, this, stringArray);
    }

    private String[][] duplicate(String[][] stringArray) {
        return InvokeDynamicSupport.bootstrap("duplicate", $$robo$$android_icu_text_DateFormatSymbols$duplicate(java.lang.String[][] ), 0, this, stringArray);
    }

    private void __constructor__(Calendar calendar, Locale locale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(calendar, locale);
    }

    public DateFormatSymbols(Calendar calendar, Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(android.icu.util.Calendar java.util.Locale ), 0, this, calendar, locale);
    }

    private void __constructor__(Calendar calendar, ULocale uLocale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(calendar, uLocale);
    }

    public DateFormatSymbols(Calendar calendar, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(android.icu.util.Calendar android.icu.util.ULocale ), 0, this, calendar, uLocale);
    }

    private void __constructor__(Class<? extends Calendar> clazz, Locale locale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(clazz, locale);
    }

    public DateFormatSymbols(Class<? extends Calendar> clazz, Locale locale) {
        this(clazz, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(java.lang.Class<? extends android.icu.util.Calendar> java.util.Locale ), 0, this, clazz, locale);
    }

    private void __constructor__(Class<? extends Calendar> clazz, ULocale uLocale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(clazz, uLocale);
    }

    public DateFormatSymbols(Class<? extends Calendar> clazz, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(java.lang.Class<? extends android.icu.util.Calendar> android.icu.util.ULocale ), 0, this, clazz, uLocale);
    }

    private void __constructor__(ResourceBundle resourceBundle, Locale locale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(resourceBundle, locale);
    }

    public DateFormatSymbols(ResourceBundle resourceBundle, Locale locale) {
        this(resourceBundle, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(java.util.ResourceBundle java.util.Locale ), 0, this, resourceBundle, locale);
    }

    private void __constructor__(ResourceBundle resourceBundle, ULocale uLocale) {
        this.$$robo$$android_icu_text_DateFormatSymbols$__constructor__(resourceBundle, uLocale);
    }

    public DateFormatSymbols(ResourceBundle resourceBundle, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols$__constructor__(java.util.ResourceBundle android.icu.util.ULocale ), 0, this, resourceBundle, uLocale);
    }

    @Deprecated
    public static ResourceBundle getDateFormatBundle(Class<? extends Calendar> clazz, Locale locale) throws MissingResourceException {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatBundle", $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(java.lang.Class<? extends android.icu.util.Calendar> java.util.Locale ), 0, clazz, (Locale)locale);
    }

    @Deprecated
    public static ResourceBundle getDateFormatBundle(Class<? extends Calendar> clazz, ULocale uLocale) throws MissingResourceException {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatBundle", $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(java.lang.Class<? extends android.icu.util.Calendar> android.icu.util.ULocale ), 0, clazz, (ULocale)uLocale);
    }

    @Deprecated
    public static ResourceBundle getDateFormatBundle(Calendar calendar, Locale locale) throws MissingResourceException {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatBundle", $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(android.icu.util.Calendar java.util.Locale ), 0, (Calendar)calendar, (Locale)locale);
    }

    @Deprecated
    public static ResourceBundle getDateFormatBundle(Calendar calendar, ULocale uLocale) throws MissingResourceException {
        return InvokeDynamicSupport.bootstrapStatic("getDateFormatBundle", $$robo$$android_icu_text_DateFormatSymbols$getDateFormatBundle(android.icu.util.Calendar android.icu.util.ULocale ), 0, (Calendar)calendar, (ULocale)uLocale);
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_DateFormatSymbols$getLocale(android.icu.util.ULocale$Type ), 0, this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_DateFormatSymbols$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DateFormatSymbols$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    static {
        RobolectricInternals.classInitializing(DateFormatSymbols.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateFormatSymbols)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CapitalizationContextUsage
    extends Enum<CapitalizationContextUsage> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CapitalizationContextUsage OTHER;
        public static /* enum */ CapitalizationContextUsage MONTH_FORMAT;
        public static /* enum */ CapitalizationContextUsage MONTH_STANDALONE;
        public static /* enum */ CapitalizationContextUsage MONTH_NARROW;
        public static /* enum */ CapitalizationContextUsage DAY_FORMAT;
        public static /* enum */ CapitalizationContextUsage DAY_STANDALONE;
        public static /* enum */ CapitalizationContextUsage DAY_NARROW;
        public static /* enum */ CapitalizationContextUsage ERA_WIDE;
        public static /* enum */ CapitalizationContextUsage ERA_ABBREV;
        public static /* enum */ CapitalizationContextUsage ERA_NARROW;
        public static /* enum */ CapitalizationContextUsage ZONE_LONG;
        public static /* enum */ CapitalizationContextUsage ZONE_SHORT;
        public static /* enum */ CapitalizationContextUsage METAZONE_LONG;
        public static /* enum */ CapitalizationContextUsage METAZONE_SHORT;
        private static /* synthetic */ CapitalizationContextUsage[] $VALUES;

        private static final CapitalizationContextUsage[] $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$values() {
            return (CapitalizationContextUsage[])$VALUES.clone();
        }

        private static final CapitalizationContextUsage $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$valueOf(String name) {
            return Enum.valueOf(CapitalizationContextUsage.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            OTHER = new CapitalizationContextUsage();
            MONTH_FORMAT = new CapitalizationContextUsage();
            MONTH_STANDALONE = new CapitalizationContextUsage();
            MONTH_NARROW = new CapitalizationContextUsage();
            DAY_FORMAT = new CapitalizationContextUsage();
            DAY_STANDALONE = new CapitalizationContextUsage();
            DAY_NARROW = new CapitalizationContextUsage();
            ERA_WIDE = new CapitalizationContextUsage();
            ERA_ABBREV = new CapitalizationContextUsage();
            ERA_NARROW = new CapitalizationContextUsage();
            ZONE_LONG = new CapitalizationContextUsage();
            ZONE_SHORT = new CapitalizationContextUsage();
            METAZONE_LONG = new CapitalizationContextUsage();
            METAZONE_SHORT = new CapitalizationContextUsage();
            $VALUES = new CapitalizationContextUsage[]{OTHER, MONTH_FORMAT, MONTH_STANDALONE, MONTH_NARROW, DAY_FORMAT, DAY_STANDALONE, DAY_NARROW, ERA_WIDE, ERA_ABBREV, ERA_NARROW, ZONE_LONG, ZONE_SHORT, METAZONE_LONG, METAZONE_SHORT};
        }

        public static CapitalizationContextUsage[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$values(), 0);
        }

        public static CapitalizationContextUsage valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$__constructor__(string2, n);
        }

        private CapitalizationContextUsage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DateFormatSymbols_CapitalizationContextUsage$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(CapitalizationContextUsage.class);
        }

        public /* synthetic */ CapitalizationContextUsage() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapitalizationContextUsage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

