/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CurrencyData;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.text.NumberingSystem;
import android.icu.util.Currency;
import android.icu.util.ICUCloneNotSupportedException;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DecimalFormatSymbols
implements Cloneable,
Serializable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CURRENCY_SPC_CURRENCY_MATCH = 0;
    public static int CURRENCY_SPC_SURROUNDING_MATCH = 1;
    public static int CURRENCY_SPC_INSERT = 2;
    private String[] currencySpcBeforeSym;
    private String[] currencySpcAfterSym;
    private char zeroDigit;
    private char[] digits;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char sigDigit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char monetaryGroupingSeparator;
    private char exponential;
    private String exponentSeparator;
    private char padEscape;
    private char plusSign;
    private Locale requestedLocale;
    private ULocale ulocale;
    private String minusString;
    private String plusString;
    private String exponentMultiplicationSign;
    private static long serialVersionUID = 5772796243397350300L;
    private static int currentSerialVersion = 8;
    private int serialVersionOnStream;
    private static SoftCache<ULocale, CacheData, Void> cachedLocaleData;
    private String currencyPattern;
    private ULocale validLocale;
    private ULocale actualLocale;
    private transient Currency currency;

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__() {
        this.minusString = null;
        this.plusString = null;
        this.exponentMultiplicationSign = null;
        this.serialVersionOnStream = 8;
        this.currencyPattern = null;
        this.initialize(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(Locale locale) {
        this.minusString = null;
        this.plusString = null;
        this.exponentMultiplicationSign = null;
        this.serialVersionOnStream = 8;
        this.currencyPattern = null;
        this.initialize(ULocale.forLocale(locale));
    }

    private void $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(ULocale locale) {
        this.minusString = null;
        this.plusString = null;
        this.exponentMultiplicationSign = null;
        this.serialVersionOnStream = 8;
        this.currencyPattern = null;
        this.initialize(locale);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance() {
        return new DecimalFormatSymbols();
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(Locale locale) {
        return new DecimalFormatSymbols(locale);
    }

    private static final DecimalFormatSymbols $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(ULocale locale) {
        return new DecimalFormatSymbols(locale);
    }

    private static final Locale[] $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales();
    }

    private static final ULocale[] $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales();
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getZeroDigit() {
        if (this.digits != null) {
            return this.digits[0];
        }
        return this.zeroDigit;
    }

    private final char[] $$robo$$android_icu_text_DecimalFormatSymbols$getDigits() {
        if (this.digits != null) {
            return (char[])this.digits.clone();
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    private final char[] $$robo$$android_icu_text_DecimalFormatSymbols$getDigitsLocal() {
        if (this.digits != null) {
            return this.digits;
        }
        char[] digitArray = new char[10];
        for (int i = 0; i < 10; ++i) {
            digitArray[i] = (char)(this.zeroDigit + i);
        }
        return digitArray;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setZeroDigit(char zeroDigit) {
        if (this.digits != null) {
            this.digits[0] = zeroDigit;
            for (int i = 1; i < 10; ++i) {
                this.digits[i] = (char)(zeroDigit + i);
            }
        } else {
            this.zeroDigit = zeroDigit;
        }
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getSignificantDigit() {
        return this.sigDigit;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setSignificantDigit(char sigDigit) {
        this.sigDigit = sigDigit;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparator() {
        return this.groupingSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparator() {
        return this.decimalSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPerMill() {
        return this.perMill;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPerMill(char perMill) {
        this.perMill = perMill;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPercent() {
        return this.percent;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPercent(char percent) {
        this.percent = percent;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getDigit() {
        return this.digit;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setDigit(char digit) {
        this.digit = digit;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPatternSeparator() {
        return this.patternSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPatternSeparator(char patternSeparator) {
        this.patternSeparator = patternSeparator;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getInfinity() {
        return this.infinity;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setInfinity(String infinity) {
        this.infinity = infinity;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getNaN() {
        return this.NaN;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setNaN(String NaN) {
        this.NaN = NaN;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSign() {
        return this.minusSign;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getMinusString() {
        return this.minusString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSign(char minusSign) {
        this.minusSign = minusSign;
        char[] minusArray = new char[]{minusSign};
        this.minusString = new String(minusArray);
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencySymbol() {
        return this.currencySymbol;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setInternationalCurrencySymbol(String currency) {
        this.intlCurrencySymbol = currency;
    }

    private final Currency $$robo$$android_icu_text_DecimalFormatSymbols$getCurrency() {
        return this.currency;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.requestedLocale);
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparator() {
        return this.monetaryGroupingSeparator;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencyPattern() {
        return this.currencyPattern;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparator(char sep) {
        this.monetarySeparator = sep;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparator(char sep) {
        this.monetaryGroupingSeparator = sep;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getExponentMultiplicationSign() {
        return this.exponentMultiplicationSign;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setExponentMultiplicationSign(String exponentMultiplicationSign) {
        this.exponentMultiplicationSign = exponentMultiplicationSign;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getExponentSeparator() {
        return this.exponentSeparator;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setExponentSeparator(String exp) {
        this.exponentSeparator = exp;
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSign() {
        return this.plusSign;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPlusString() {
        return this.plusString;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSign(char plus) {
        this.plusSign = plus;
        char[] plusArray = new char[]{this.plusSign};
        this.plusString = new String(plusArray);
    }

    private final char $$robo$$android_icu_text_DecimalFormatSymbols$getPadEscape() {
        return this.padEscape;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPadEscape(char c) {
        this.padEscape = c;
    }

    private final String $$robo$$android_icu_text_DecimalFormatSymbols$getPatternForCurrencySpacing(int itemType, boolean beforeCurrency) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            return this.currencySpcBeforeSym[itemType];
        }
        return this.currencySpcAfterSym[itemType];
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setPatternForCurrencySpacing(int itemType, boolean beforeCurrency, String pattern) {
        if (itemType < 0 || itemType > 2) {
            throw new IllegalArgumentException("unknown currency spacing: " + itemType);
        }
        if (beforeCurrency) {
            this.currencySpcBeforeSym[itemType] = pattern;
        } else {
            this.currencySpcAfterSym[itemType] = pattern;
        }
    }

    private final Locale $$robo$$android_icu_text_DecimalFormatSymbols$getLocale() {
        return this.requestedLocale;
    }

    private final ULocale $$robo$$android_icu_text_DecimalFormatSymbols$getULocale() {
        return this.ulocale;
    }

    private final Object $$robo$$android_icu_text_DecimalFormatSymbols$clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ICUCloneNotSupportedException(e);
        }
    }

    private final boolean $$robo$$android_icu_text_DecimalFormatSymbols$equals(Object obj) {
        int i;
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols other = (DecimalFormatSymbols)obj;
        for (i = 0; i <= 2; ++i) {
            if (!this.currencySpcBeforeSym[i].equals(other.currencySpcBeforeSym[i])) {
                return false;
            }
            if (this.currencySpcAfterSym[i].equals(other.currencySpcAfterSym[i])) continue;
            return false;
        }
        if (other.digits == null) {
            for (i = 0; i < 10; ++i) {
                if (this.digits[i] == other.zeroDigit + i) continue;
                return false;
            }
        } else if (!Arrays.equals(this.digits, other.digits)) {
            return false;
        }
        return this.groupingSeparator == other.groupingSeparator && this.decimalSeparator == other.decimalSeparator && this.percent == other.percent && this.perMill == other.perMill && this.digit == other.digit && this.minusSign == other.minusSign && this.minusString.equals(other.minusString) && this.patternSeparator == other.patternSeparator && this.infinity.equals(other.infinity) && this.NaN.equals(other.NaN) && this.currencySymbol.equals(other.currencySymbol) && this.intlCurrencySymbol.equals(other.intlCurrencySymbol) && this.padEscape == other.padEscape && this.plusSign == other.plusSign && this.plusString.equals(other.plusString) && this.exponentSeparator.equals(other.exponentSeparator) && this.monetarySeparator == other.monetarySeparator && this.monetaryGroupingSeparator == other.monetaryGroupingSeparator && this.exponentMultiplicationSign.equals(other.exponentMultiplicationSign);
    }

    private final int $$robo$$android_icu_text_DecimalFormatSymbols$hashCode() {
        int result = this.digits[0];
        result = result * 37 + this.groupingSeparator;
        result = result * 37 + this.decimalSeparator;
        return result;
    }

    private static final boolean $$robo$$android_icu_text_DecimalFormatSymbols$isBidiMark(char c) {
        return c == '\u200e' || c == '\u200f' || c == '\u061c';
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$initialize(ULocale locale) {
        this.requestedLocale = locale.toLocale();
        this.ulocale = locale;
        CacheData symbolData = cachedLocaleData.getInstance(locale, null);
        this.digits = (char[])symbolData.digits.clone();
        String[] numberElements = symbolData.symbolsArray;
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", locale);
        ULocale uloc = r.getULocale();
        this.setLocale(uloc, uloc);
        this.decimalSeparator = numberElements[0].charAt(0);
        this.groupingSeparator = numberElements[1].charAt(0);
        this.patternSeparator = numberElements[2].charAt(0);
        this.percent = numberElements[3].charAt(numberElements[3].length() - 1);
        this.minusString = numberElements[4];
        this.minusSign = this.minusString.length() > 1 && DecimalFormatSymbols.isBidiMark(this.minusString.charAt(0)) ? this.minusString.charAt(1) : this.minusString.charAt(0);
        this.plusString = numberElements[5];
        this.plusSign = this.plusString.length() > 1 && DecimalFormatSymbols.isBidiMark(this.plusString.charAt(0)) ? this.plusString.charAt(1) : this.plusString.charAt(0);
        this.exponentSeparator = numberElements[6];
        this.perMill = numberElements[7].charAt(0);
        this.infinity = numberElements[8];
        this.NaN = numberElements[9];
        this.monetarySeparator = numberElements[10] != null ? numberElements[10].charAt(0) : this.decimalSeparator;
        this.monetaryGroupingSeparator = numberElements[11] != null ? numberElements[11].charAt(0) : this.groupingSeparator;
        this.exponentMultiplicationSign = numberElements[12] != null ? numberElements[12] : "\u00d7";
        this.digit = (char)35;
        this.padEscape = (char)42;
        this.sigDigit = (char)64;
        CurrencyData.CurrencyDisplayInfo info = CurrencyData.provider.getInstance(locale, true);
        String currname = null;
        this.currency = Currency.getInstance(locale);
        if (this.currency != null) {
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
            boolean[] isChoiceFormat = new boolean[1];
            currname = this.currency.getName(locale, 0, isChoiceFormat);
            this.currencySymbol = isChoiceFormat[0] ? new ChoiceFormat(currname).format(2.0) : currname;
            CurrencyData.CurrencyFormatInfo fmtInfo = info.getFormatInfo(this.intlCurrencySymbol);
            if (fmtInfo != null) {
                this.currencyPattern = fmtInfo.currencyPattern;
                this.monetarySeparator = fmtInfo.monetarySeparator;
                this.monetaryGroupingSeparator = fmtInfo.monetaryGroupingSeparator;
            }
        } else {
            this.intlCurrencySymbol = "XXX";
            this.currencySymbol = "\u00a4";
        }
        this.currencySpcBeforeSym = new String[3];
        this.currencySpcAfterSym = new String[3];
        this.initSpacingInfo(info.getSpacingInfo());
    }

    private static final CacheData $$robo$$android_icu_text_DecimalFormatSymbols$loadSymbols(ULocale locale) {
        String nsName;
        NumberingSystem ns = NumberingSystem.getInstance(locale);
        char[] digits = new char[10];
        if (ns != null && ns.getRadix() == 10 && !ns.isAlgorithmic() && NumberingSystem.isValidDigitString(ns.getDescription())) {
            String digitString = ns.getDescription();
            digits[0] = digitString.charAt(0);
            digits[1] = digitString.charAt(1);
            digits[2] = digitString.charAt(2);
            digits[3] = digitString.charAt(3);
            digits[4] = digitString.charAt(4);
            digits[5] = digitString.charAt(5);
            digits[6] = digitString.charAt(6);
            digits[7] = digitString.charAt(7);
            digits[8] = digitString.charAt(8);
            digits[9] = digitString.charAt(9);
            nsName = ns.getName();
        } else {
            digits[0] = 48;
            digits[1] = 49;
            digits[2] = 50;
            digits[3] = 51;
            digits[4] = 52;
            digits[5] = 53;
            digits[6] = 54;
            digits[7] = 55;
            digits[8] = 56;
            digits[9] = 57;
            nsName = "latn";
        }
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt56b", locale);
        boolean isLatn = nsName.equals("latn");
        String baseKey = "NumberElements/" + nsName + "/symbols/";
        String latnKey = "NumberElements/latn/symbols/";
        String[] symbolKeys = new String[]{"decimal", "group", "list", "percentSign", "minusSign", "plusSign", "exponential", "perMille", "infinity", "nan", "currencyDecimal", "currencyGroup", "superscriptingExponent"};
        String[] fallbackElements = new String[]{".", ",", ";", "%", "-", "+", "E", "\u2030", "\u221e", "NaN", null, null};
        String[] symbolsArray = new String[symbolKeys.length];
        for (int i = 0; i < symbolKeys.length; ++i) {
            try {
                symbolsArray[i] = rb.getStringWithFallback(baseKey + symbolKeys[i]);
                continue;
            }
            catch (MissingResourceException ex) {
                if (!isLatn) {
                    try {
                        symbolsArray[i] = rb.getStringWithFallback(latnKey + symbolKeys[i]);
                    }
                    catch (MissingResourceException ex1) {
                        symbolsArray[i] = fallbackElements[i];
                    }
                    continue;
                }
                symbolsArray[i] = fallbackElements[i];
            }
        }
        return new CacheData(digits, symbolsArray);
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$initSpacingInfo(CurrencyData.CurrencySpacingInfo spcInfo) {
        this.currencySpcBeforeSym[0] = spcInfo.beforeCurrencyMatch;
        this.currencySpcBeforeSym[1] = spcInfo.beforeContextMatch;
        this.currencySpcBeforeSym[2] = spcInfo.beforeInsert;
        this.currencySpcAfterSym[0] = spcInfo.afterCurrencyMatch;
        this.currencySpcAfterSym[1] = spcInfo.afterContextMatch;
        this.currencySpcAfterSym[2] = spcInfo.afterInsert;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.padEscape = (char)42;
            this.plusSign = (char)43;
            this.exponentSeparator = String.valueOf(this.exponential);
        }
        if (this.serialVersionOnStream < 3) {
            this.requestedLocale = Locale.getDefault();
        }
        if (this.serialVersionOnStream < 4) {
            this.ulocale = ULocale.forLocale(this.requestedLocale);
        }
        if (this.serialVersionOnStream < 5) {
            this.monetaryGroupingSeparator = this.groupingSeparator;
        }
        if (this.serialVersionOnStream < 6) {
            if (this.currencySpcBeforeSym == null) {
                this.currencySpcBeforeSym = new String[3];
            }
            if (this.currencySpcAfterSym == null) {
                this.currencySpcAfterSym = new String[3];
            }
            this.initSpacingInfo(CurrencyData.CurrencySpacingInfo.DEFAULT);
        }
        if (this.serialVersionOnStream < 7) {
            if (this.minusString == null) {
                char[] minusArray = new char[]{this.minusSign};
                this.minusString = new String(minusArray);
            }
            if (this.plusString == null) {
                char[] plusArray = new char[]{this.plusSign};
                this.plusString = new String(plusArray);
            }
        }
        if (this.serialVersionOnStream < 8 && this.exponentMultiplicationSign == null) {
            this.exponentMultiplicationSign = "\u00d7";
        }
        this.serialVersionOnStream = 8;
        this.currency = Currency.getInstance(this.intlCurrencySymbol);
    }

    private final ULocale $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(ULocale.Type type) {
        return type == ULocale.ACTUAL_LOCALE ? this.actualLocale : this.validLocale;
    }

    private final void $$robo$$android_icu_text_DecimalFormatSymbols$setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static void __staticInitializer__() {
        cachedLocaleData = new SoftCache<ULocale, CacheData, Void>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__() {
            }

            private final CacheData $$robo$$android_icu_text_DecimalFormatSymbols_1$createInstance(ULocale key, Void unused) {
                return DecimalFormatSymbols.loadSymbols(key);
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols_1$__constructor__(), 0, this);
            }

            @Override
            protected CacheData createInstance(ULocale uLocale, Void void_) {
                return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_text_DecimalFormatSymbols_1$createInstance(android.icu.util.ULocale java.lang.Void ), 0, this, uLocale, void_);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__();
    }

    public DecimalFormatSymbols() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(), 0, this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(locale);
    }

    public DecimalFormatSymbols(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(uLocale);
    }

    public DecimalFormatSymbols(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public static DecimalFormatSymbols getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(), 0);
    }

    public static DecimalFormatSymbols getInstance(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(java.util.Locale ), 0, (Locale)locale);
    }

    public static DecimalFormatSymbols getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_DecimalFormatSymbols$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public static Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableLocales", $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableLocales(), 0);
    }

    public static ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableULocales", $$robo$$android_icu_text_DecimalFormatSymbols$getAvailableULocales(), 0);
    }

    public char getZeroDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getZeroDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getZeroDigit(), 0, this);
    }

    public char[] getDigits() {
        return InvokeDynamicSupport.bootstrap("getDigits", $$robo$$android_icu_text_DecimalFormatSymbols$getDigits(), 0, this);
    }

    char[] getDigitsLocal() {
        return InvokeDynamicSupport.bootstrap("getDigitsLocal", $$robo$$android_icu_text_DecimalFormatSymbols$getDigitsLocal(), 0, this);
    }

    public void setZeroDigit(char c) {
        InvokeDynamicSupport.bootstrap("setZeroDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setZeroDigit(char ), 0, this, c);
    }

    public char getSignificantDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getSignificantDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getSignificantDigit(), 0, this);
    }

    public void setSignificantDigit(char c) {
        InvokeDynamicSupport.bootstrap("setSignificantDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setSignificantDigit(char ), 0, this, c);
    }

    public char getGroupingSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getGroupingSeparator(), 0, this);
    }

    public void setGroupingSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setGroupingSeparator(char ), 0, this, c);
    }

    public char getDecimalSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getDecimalSeparator(), 0, this);
    }

    public void setDecimalSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setDecimalSeparator(char ), 0, this, c);
    }

    public char getPerMill() {
        return (char)InvokeDynamicSupport.bootstrap("getPerMill", $$robo$$android_icu_text_DecimalFormatSymbols$getPerMill(), 0, this);
    }

    public void setPerMill(char c) {
        InvokeDynamicSupport.bootstrap("setPerMill", $$robo$$android_icu_text_DecimalFormatSymbols$setPerMill(char ), 0, this, c);
    }

    public char getPercent() {
        return (char)InvokeDynamicSupport.bootstrap("getPercent", $$robo$$android_icu_text_DecimalFormatSymbols$getPercent(), 0, this);
    }

    public void setPercent(char c) {
        InvokeDynamicSupport.bootstrap("setPercent", $$robo$$android_icu_text_DecimalFormatSymbols$setPercent(char ), 0, this, c);
    }

    public char getDigit() {
        return (char)InvokeDynamicSupport.bootstrap("getDigit", $$robo$$android_icu_text_DecimalFormatSymbols$getDigit(), 0, this);
    }

    public void setDigit(char c) {
        InvokeDynamicSupport.bootstrap("setDigit", $$robo$$android_icu_text_DecimalFormatSymbols$setDigit(char ), 0, this, c);
    }

    public char getPatternSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getPatternSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getPatternSeparator(), 0, this);
    }

    public void setPatternSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setPatternSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setPatternSeparator(char ), 0, this, c);
    }

    public String getInfinity() {
        return InvokeDynamicSupport.bootstrap("getInfinity", $$robo$$android_icu_text_DecimalFormatSymbols$getInfinity(), 0, this);
    }

    public void setInfinity(String string2) {
        InvokeDynamicSupport.bootstrap("setInfinity", $$robo$$android_icu_text_DecimalFormatSymbols$setInfinity(java.lang.String ), 0, this, string2);
    }

    public String getNaN() {
        return InvokeDynamicSupport.bootstrap("getNaN", $$robo$$android_icu_text_DecimalFormatSymbols$getNaN(), 0, this);
    }

    public void setNaN(String string2) {
        InvokeDynamicSupport.bootstrap("setNaN", $$robo$$android_icu_text_DecimalFormatSymbols$setNaN(java.lang.String ), 0, this, string2);
    }

    public char getMinusSign() {
        return (char)InvokeDynamicSupport.bootstrap("getMinusSign", $$robo$$android_icu_text_DecimalFormatSymbols$getMinusSign(), 0, this);
    }

    @Deprecated
    public String getMinusString() {
        return InvokeDynamicSupport.bootstrap("getMinusString", $$robo$$android_icu_text_DecimalFormatSymbols$getMinusString(), 0, this);
    }

    public void setMinusSign(char c) {
        InvokeDynamicSupport.bootstrap("setMinusSign", $$robo$$android_icu_text_DecimalFormatSymbols$setMinusSign(char ), 0, this, c);
    }

    public String getCurrencySymbol() {
        return InvokeDynamicSupport.bootstrap("getCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencySymbol(), 0, this);
    }

    public void setCurrencySymbol(String string2) {
        InvokeDynamicSupport.bootstrap("setCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$setCurrencySymbol(java.lang.String ), 0, this, string2);
    }

    public String getInternationalCurrencySymbol() {
        return InvokeDynamicSupport.bootstrap("getInternationalCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$getInternationalCurrencySymbol(), 0, this);
    }

    public void setInternationalCurrencySymbol(String string2) {
        InvokeDynamicSupport.bootstrap("setInternationalCurrencySymbol", $$robo$$android_icu_text_DecimalFormatSymbols$setInternationalCurrencySymbol(java.lang.String ), 0, this, string2);
    }

    public Currency getCurrency() {
        return InvokeDynamicSupport.bootstrap("getCurrency", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrency(), 0, this);
    }

    public void setCurrency(Currency currency) {
        InvokeDynamicSupport.bootstrap("setCurrency", $$robo$$android_icu_text_DecimalFormatSymbols$setCurrency(android.icu.util.Currency ), 0, this, currency);
    }

    public char getMonetaryDecimalSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getMonetaryDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryDecimalSeparator(), 0, this);
    }

    public char getMonetaryGroupingSeparator() {
        return (char)InvokeDynamicSupport.bootstrap("getMonetaryGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getMonetaryGroupingSeparator(), 0, this);
    }

    String getCurrencyPattern() {
        return InvokeDynamicSupport.bootstrap("getCurrencyPattern", $$robo$$android_icu_text_DecimalFormatSymbols$getCurrencyPattern(), 0, this);
    }

    public void setMonetaryDecimalSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setMonetaryDecimalSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryDecimalSeparator(char ), 0, this, c);
    }

    public void setMonetaryGroupingSeparator(char c) {
        InvokeDynamicSupport.bootstrap("setMonetaryGroupingSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setMonetaryGroupingSeparator(char ), 0, this, c);
    }

    public String getExponentMultiplicationSign() {
        return InvokeDynamicSupport.bootstrap("getExponentMultiplicationSign", $$robo$$android_icu_text_DecimalFormatSymbols$getExponentMultiplicationSign(), 0, this);
    }

    public void setExponentMultiplicationSign(String string2) {
        InvokeDynamicSupport.bootstrap("setExponentMultiplicationSign", $$robo$$android_icu_text_DecimalFormatSymbols$setExponentMultiplicationSign(java.lang.String ), 0, this, string2);
    }

    public String getExponentSeparator() {
        return InvokeDynamicSupport.bootstrap("getExponentSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$getExponentSeparator(), 0, this);
    }

    public void setExponentSeparator(String string2) {
        InvokeDynamicSupport.bootstrap("setExponentSeparator", $$robo$$android_icu_text_DecimalFormatSymbols$setExponentSeparator(java.lang.String ), 0, this, string2);
    }

    public char getPlusSign() {
        return (char)InvokeDynamicSupport.bootstrap("getPlusSign", $$robo$$android_icu_text_DecimalFormatSymbols$getPlusSign(), 0, this);
    }

    @Deprecated
    public String getPlusString() {
        return InvokeDynamicSupport.bootstrap("getPlusString", $$robo$$android_icu_text_DecimalFormatSymbols$getPlusString(), 0, this);
    }

    public void setPlusSign(char c) {
        InvokeDynamicSupport.bootstrap("setPlusSign", $$robo$$android_icu_text_DecimalFormatSymbols$setPlusSign(char ), 0, this, c);
    }

    public char getPadEscape() {
        return (char)InvokeDynamicSupport.bootstrap("getPadEscape", $$robo$$android_icu_text_DecimalFormatSymbols$getPadEscape(), 0, this);
    }

    public void setPadEscape(char c) {
        InvokeDynamicSupport.bootstrap("setPadEscape", $$robo$$android_icu_text_DecimalFormatSymbols$setPadEscape(char ), 0, this, c);
    }

    public String getPatternForCurrencySpacing(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPatternForCurrencySpacing", $$robo$$android_icu_text_DecimalFormatSymbols$getPatternForCurrencySpacing(int boolean ), 0, this, n, bl);
    }

    public void setPatternForCurrencySpacing(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setPatternForCurrencySpacing", $$robo$$android_icu_text_DecimalFormatSymbols$setPatternForCurrencySpacing(int boolean java.lang.String ), 0, this, n, bl, string2);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(), 0, this);
    }

    public ULocale getULocale() {
        return InvokeDynamicSupport.bootstrap("getULocale", $$robo$$android_icu_text_DecimalFormatSymbols$getULocale(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_DecimalFormatSymbols$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DecimalFormatSymbols$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DecimalFormatSymbols$hashCode(), 0, this);
    }

    private static boolean isBidiMark(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBidiMark", $$robo$$android_icu_text_DecimalFormatSymbols$isBidiMark(char ), 0, (char)c);
    }

    private void initialize(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_text_DecimalFormatSymbols$initialize(android.icu.util.ULocale ), 0, this, uLocale);
    }

    static CacheData loadSymbols(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("loadSymbols", $$robo$$android_icu_text_DecimalFormatSymbols$loadSymbols(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    private void initSpacingInfo(CurrencyData.CurrencySpacingInfo currencySpacingInfo) {
        InvokeDynamicSupport.bootstrap("initSpacingInfo", $$robo$$android_icu_text_DecimalFormatSymbols$initSpacingInfo(android.icu.impl.CurrencyData$CurrencySpacingInfo ), 0, this, currencySpacingInfo);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_DecimalFormatSymbols$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    public ULocale getLocale(ULocale.Type type) {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_DecimalFormatSymbols$getLocale(android.icu.util.ULocale$Type ), 0, this, type);
    }

    void setLocale(ULocale uLocale, ULocale uLocale2) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_DecimalFormatSymbols$setLocale(android.icu.util.ULocale android.icu.util.ULocale ), 0, this, uLocale, uLocale2);
    }

    static {
        RobolectricInternals.classInitializing(DecimalFormatSymbols.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecimalFormatSymbols)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CacheData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public char[] digits;
        public String[] symbolsArray;

        private void $$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(char[] digits, String[] symbolsArray) {
            this.digits = digits;
            this.symbolsArray = symbolsArray;
        }

        private void __constructor__(char[] cArray, String[] stringArray) {
            this.$$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(cArray, stringArray);
        }

        public CacheData(char[] cArray, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DecimalFormatSymbols_CacheData$__constructor__(char[] java.lang.String[] ), 0, this, cArray, stringArray);
        }

        public /* synthetic */ CacheData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CacheData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

