/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import com.google.errorprone.annotations.DoNotMock;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DigitList
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int MAX_LONG_DIGITS = 19;
    public static int DBL_DIG = 17;
    public int decimalAt;
    public int count;
    public byte[] digits;
    private boolean didRound;
    private static byte[] LONG_MIN_REP;

    private void $$robo$$android_icu_text_DigitList$__constructor__() {
        this.decimalAt = 0;
        this.count = 0;
        this.digits = new byte[19];
        this.didRound = false;
    }

    private final void $$robo$$android_icu_text_DigitList$ensureCapacity(int digitCapacity, int digitsToCopy) {
        if (digitCapacity > this.digits.length) {
            byte[] newDigits = new byte[digitCapacity * 2];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.digits, (int)0, (byte[])newDigits, (int)0, (int)digitsToCopy);
            this.digits = newDigits;
        }
    }

    private final boolean $$robo$$android_icu_text_DigitList$isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == 48) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_icu_text_DigitList$append(int digit) {
        this.ensureCapacity(this.count + 1, this.count);
        this.digits[this.count++] = (byte)digit;
    }

    private final byte $$robo$$android_icu_text_DigitList$getDigitValue(int i) {
        return (byte)(this.digits[i] - 48);
    }

    private final double $$robo$$android_icu_text_DigitList$getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuilder temp = new StringBuilder(this.count);
        temp.append('.');
        for (int i = 0; i < this.count; ++i) {
            temp.append((char)this.digits[i]);
        }
        temp.append('E');
        temp.append(Integer.toString(this.decimalAt));
        return Double.valueOf(temp.toString());
    }

    private final long $$robo$$android_icu_text_DigitList$getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuilder temp = new StringBuilder(this.count);
        for (int i = 0; i < this.decimalAt; ++i) {
            temp.append(i < this.count ? (char)this.digits[i] : (char)'0');
        }
        return Long.parseLong(temp.toString());
    }

    private final BigInteger $$robo$$android_icu_text_DigitList$getBigInteger(boolean isPositive) {
        int i;
        int len;
        if (this.isZero()) {
            return BigInteger.valueOf(0L);
        }
        int n = len = this.decimalAt > this.count ? this.decimalAt : this.count;
        if (!isPositive) {
            ++len;
        }
        char[] text = new char[len];
        int n2 = 0;
        if (!isPositive) {
            text[0] = 45;
            for (i = 0; i < this.count; ++i) {
                text[i + 1] = (char)this.digits[i];
            }
            n2 = this.count + 1;
        } else {
            for (i = 0; i < this.count; ++i) {
                text[i] = (char)this.digits[i];
            }
            n2 = this.count;
        }
        for (i = n2; i < text.length; ++i) {
            text[i] = 48;
        }
        return new BigInteger(new String(text));
    }

    private final String $$robo$$android_icu_text_DigitList$getStringRep(boolean isPositive) {
        int d;
        if (this.isZero()) {
            return "0";
        }
        StringBuilder stringRep = new StringBuilder(this.count + 1);
        if (!isPositive) {
            stringRep.append('-');
        }
        if ((d = this.decimalAt) < 0) {
            stringRep.append('.');
            while (d < 0) {
                stringRep.append('0');
                ++d;
            }
            d = -1;
        }
        for (int i = 0; i < this.count; ++i) {
            if (d == i) {
                stringRep.append('.');
            }
            stringRep.append((char)this.digits[i]);
        }
        while (d-- > this.count) {
            stringRep.append('0');
        }
        return stringRep.toString();
    }

    private final BigDecimal $$robo$$android_icu_text_DigitList$getBigDecimal(boolean isPositive) {
        if (this.isZero()) {
            return BigDecimal.valueOf(0L);
        }
        long scale = (long)this.count - (long)this.decimalAt;
        if (scale > 0L) {
            int numDigits = this.count;
            if (scale > Integer.MAX_VALUE) {
                long numShift = scale - Integer.MAX_VALUE;
                if (numShift < (long)this.count) {
                    numDigits = (int)((long)numDigits - numShift);
                } else {
                    return new BigDecimal(0);
                }
            }
            StringBuilder significantDigits = new StringBuilder(numDigits + 1);
            if (!isPositive) {
                significantDigits.append('-');
            }
            for (int i = 0; i < numDigits; ++i) {
                significantDigits.append((char)this.digits[i]);
            }
            BigInteger unscaledVal = new BigInteger(significantDigits.toString());
            return new BigDecimal(unscaledVal, (int)scale);
        }
        return new BigDecimal(this.getStringRep(isPositive));
    }

    private final android.icu.math.BigDecimal $$robo$$android_icu_text_DigitList$getBigDecimalICU(boolean isPositive) {
        if (this.isZero()) {
            return android.icu.math.BigDecimal.valueOf(0L);
        }
        long scale = (long)this.count - (long)this.decimalAt;
        if (scale > 0L) {
            int numDigits = this.count;
            if (scale > Integer.MAX_VALUE) {
                long numShift = scale - Integer.MAX_VALUE;
                if (numShift < (long)this.count) {
                    numDigits = (int)((long)numDigits - numShift);
                } else {
                    return new android.icu.math.BigDecimal(0);
                }
            }
            StringBuilder significantDigits = new StringBuilder(numDigits + 1);
            if (!isPositive) {
                significantDigits.append('-');
            }
            for (int i = 0; i < numDigits; ++i) {
                significantDigits.append((char)this.digits[i]);
            }
            BigInteger unscaledVal = new BigInteger(significantDigits.toString());
            return new android.icu.math.BigDecimal(unscaledVal, (int)scale);
        }
        return new android.icu.math.BigDecimal(this.getStringRep(isPositive));
    }

    private final boolean $$robo$$android_icu_text_DigitList$isIntegral() {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        return this.count == 0 || this.decimalAt >= this.count;
    }

    private final void $$robo$$android_icu_text_DigitList$set(double source, int maximumDigits, boolean fixedPoint) {
        if (source == 0.0) {
            source = 0.0;
        }
        String rep = Double.toString(source);
        this.didRound = false;
        this.set(rep, 19);
        if (fixedPoint) {
            if (-this.decimalAt > maximumDigits) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == maximumDigits) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        this.round(fixedPoint ? maximumDigits + this.decimalAt : (maximumDigits == 0 ? -1 : maximumDigits));
    }

    private final void $$robo$$android_icu_text_DigitList$set(String rep, int maxCount) {
        this.decimalAt = -1;
        this.count = 0;
        int exponent = 0;
        int leadingZerosAfterDecimal = 0;
        boolean nonZeroDigitSeen = false;
        int i = 0;
        if (rep.charAt(i) == '-') {
            ++i;
        }
        while (i < rep.length()) {
            char c = rep.charAt(i);
            if (c == '.') {
                this.decimalAt = this.count;
            } else {
                if (c == 'e' || c == 'E') {
                    if (rep.charAt(++i) == '+') {
                        ++i;
                    }
                    exponent = Integer.valueOf(rep.substring(i));
                    break;
                }
                if (this.count < maxCount) {
                    if (!nonZeroDigitSeen) {
                        boolean bl = nonZeroDigitSeen = c != '0';
                        if (!nonZeroDigitSeen && this.decimalAt != -1) {
                            ++leadingZerosAfterDecimal;
                        }
                    }
                    if (nonZeroDigitSeen) {
                        this.ensureCapacity(this.count + 1, this.count);
                        this.digits[this.count++] = (byte)c;
                    }
                }
            }
            ++i;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        this.decimalAt += exponent - leadingZerosAfterDecimal;
    }

    private final boolean $$robo$$android_icu_text_DigitList$shouldRoundUp(int maximumDigits) {
        if (maximumDigits < this.count) {
            if (this.digits[maximumDigits] > 53) {
                return true;
            }
            if (this.digits[maximumDigits] == 53) {
                for (int i = maximumDigits + 1; i < this.count; ++i) {
                    if (this.digits[i] == 48) continue;
                    return true;
                }
                return maximumDigits > 0 && this.digits[maximumDigits - 1] % 2 != 0;
            }
        }
        return false;
    }

    private final void $$robo$$android_icu_text_DigitList$round(int maximumDigits) {
        if (maximumDigits >= 0 && maximumDigits < this.count) {
            if (this.shouldRoundUp(maximumDigits)) {
                do {
                    if (--maximumDigits < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        maximumDigits = 0;
                        this.didRound = true;
                        break;
                    }
                    int n = maximumDigits;
                    this.digits[n] = (byte)(this.digits[n] + 1);
                    this.didRound = true;
                } while (this.digits[maximumDigits] > 57);
                ++maximumDigits;
            }
            this.count = maximumDigits;
        }
        while (this.count > 1 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
    }

    private final boolean $$robo$$android_icu_text_DigitList$wasRounded() {
        return this.didRound;
    }

    private final void $$robo$$android_icu_text_DigitList$set(long source) {
        this.set(source, 0);
    }

    private final void $$robo$$android_icu_text_DigitList$set(long source, int maximumDigits) {
        this.didRound = false;
        if (source <= 0L) {
            if (source == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])LONG_MIN_REP, (int)0, (byte[])this.digits, (int)0, (int)this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int left = 19;
            while (source > 0L) {
                this.digits[--left] = (byte)(48L + source % 10L);
                source /= 10L;
            }
            this.decimalAt = 19 - left;
            int right = 18;
            while (this.digits[right] == 48) {
                --right;
            }
            this.count = right - left + 1;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.digits, (int)left, (byte[])this.digits, (int)0, (int)this.count);
        }
        if (maximumDigits > 0) {
            this.round(maximumDigits);
        }
    }

    private final void $$robo$$android_icu_text_DigitList$set(BigInteger source, int maximumDigits) {
        String stringDigits = source.toString();
        this.count = this.decimalAt = stringDigits.length();
        this.didRound = false;
        while (this.count > 1 && stringDigits.charAt(this.count - 1) == '0') {
            --this.count;
        }
        int offset = 0;
        if (stringDigits.charAt(0) == '-') {
            ++offset;
            --this.count;
            --this.decimalAt;
        }
        this.ensureCapacity(this.count, 0);
        for (int i = 0; i < this.count; ++i) {
            this.digits[i] = (byte)stringDigits.charAt(i + offset);
        }
        if (maximumDigits > 0) {
            this.round(maximumDigits);
        }
    }

    private final void $$robo$$android_icu_text_DigitList$setBigDecimalDigits(String stringDigits, int maximumDigits, boolean fixedPoint) {
        this.didRound = false;
        this.set(stringDigits, stringDigits.length());
        this.round(fixedPoint ? maximumDigits + this.decimalAt : (maximumDigits == 0 ? -1 : maximumDigits));
    }

    private final void $$robo$$android_icu_text_DigitList$set(BigDecimal source, int maximumDigits, boolean fixedPoint) {
        this.setBigDecimalDigits(source.toString(), maximumDigits, fixedPoint);
    }

    private final void $$robo$$android_icu_text_DigitList$set(android.icu.math.BigDecimal source, int maximumDigits, boolean fixedPoint) {
        this.setBigDecimalDigits(source.toString(), maximumDigits, fixedPoint);
    }

    private final boolean $$robo$$android_icu_text_DigitList$isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == LONG_MIN_REP[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_icu_text_DigitList$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DigitList)) {
            return false;
        }
        DigitList other = (DigitList)obj;
        if (this.count != other.count || this.decimalAt != other.decimalAt) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == other.digits[i]) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_icu_text_DigitList$hashCode() {
        int hashcode = this.decimalAt;
        for (int i = 0; i < this.count; ++i) {
            hashcode = hashcode * 37 + this.digits[i];
        }
        return hashcode;
    }

    private final String $$robo$$android_icu_text_DigitList$toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder buf = new StringBuilder("0.");
        for (int i = 0; i < this.count; ++i) {
            buf.append((char)this.digits[i]);
        }
        buf.append("x10^");
        buf.append(this.decimalAt);
        return buf.toString();
    }

    static void __staticInitializer__() {
        String s = Long.toString(Long.MIN_VALUE);
        LONG_MIN_REP = new byte[19];
        for (int i = 0; i < 19; ++i) {
            DigitList.LONG_MIN_REP[i] = (byte)s.charAt(i + 1);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_DigitList$__constructor__();
    }

    DigitList() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_DigitList$__constructor__(), 0, this);
    }

    private void ensureCapacity(int n, int n2) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_text_DigitList$ensureCapacity(int int ), 0, this, n, n2);
    }

    boolean isZero() {
        return (boolean)InvokeDynamicSupport.bootstrap("isZero", $$robo$$android_icu_text_DigitList$isZero(), 0, this);
    }

    public void append(int n) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_DigitList$append(int ), 0, this, n);
    }

    public byte getDigitValue(int n) {
        return (byte)InvokeDynamicSupport.bootstrap("getDigitValue", $$robo$$android_icu_text_DigitList$getDigitValue(int ), 0, this, n);
    }

    public double getDouble() {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$android_icu_text_DigitList$getDouble(), 0, this);
    }

    public long getLong() {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_icu_text_DigitList$getLong(), 0, this);
    }

    public BigInteger getBigInteger(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBigInteger", $$robo$$android_icu_text_DigitList$getBigInteger(boolean ), 0, this, bl);
    }

    private String getStringRep(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getStringRep", $$robo$$android_icu_text_DigitList$getStringRep(boolean ), 0, this, bl);
    }

    public BigDecimal getBigDecimal(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBigDecimal", $$robo$$android_icu_text_DigitList$getBigDecimal(boolean ), 0, this, bl);
    }

    public android.icu.math.BigDecimal getBigDecimalICU(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getBigDecimalICU", $$robo$$android_icu_text_DigitList$getBigDecimalICU(boolean ), 0, this, bl);
    }

    boolean isIntegral() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIntegral", $$robo$$android_icu_text_DigitList$isIntegral(), 0, this);
    }

    void set(double d, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(double int boolean ), 0, this, d, n, bl);
    }

    private void set(String string2, int n) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(java.lang.String int ), 0, this, string2, n);
    }

    private boolean shouldRoundUp(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldRoundUp", $$robo$$android_icu_text_DigitList$shouldRoundUp(int ), 0, this, n);
    }

    public void round(int n) {
        InvokeDynamicSupport.bootstrap("round", $$robo$$android_icu_text_DigitList$round(int ), 0, this, n);
    }

    public boolean wasRounded() {
        return (boolean)InvokeDynamicSupport.bootstrap("wasRounded", $$robo$$android_icu_text_DigitList$wasRounded(), 0, this);
    }

    public void set(long l) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(long ), 0, this, l);
    }

    public void set(long l, int n) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(long int ), 0, this, l, n);
    }

    public void set(BigInteger bigInteger, int n) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(java.math.BigInteger int ), 0, this, bigInteger, n);
    }

    private void setBigDecimalDigits(String string2, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBigDecimalDigits", $$robo$$android_icu_text_DigitList$setBigDecimalDigits(java.lang.String int boolean ), 0, this, string2, n, bl);
    }

    public void set(BigDecimal bigDecimal, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(java.math.BigDecimal int boolean ), 0, this, bigDecimal, n, bl);
    }

    public void set(android.icu.math.BigDecimal bigDecimal, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_DigitList$set(android.icu.math.BigDecimal int boolean ), 0, this, bigDecimal, n, bl);
    }

    private boolean isLongMIN_VALUE() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLongMIN_VALUE", $$robo$$android_icu_text_DigitList$isLongMIN_VALUE(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_DigitList$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_DigitList$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_DigitList$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(DigitList.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DigitList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

