/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.PatternProps;
import android.icu.impl.Utility;
import android.icu.text.DateFormat;
import android.icu.text.DecimalFormat;
import android.icu.text.DecimalFormatSymbols;
import android.icu.text.MessagePattern;
import android.icu.text.NumberFormat;
import android.icu.text.PluralFormat;
import android.icu.text.PluralRules;
import android.icu.text.RuleBasedNumberFormat;
import android.icu.text.SelectFormat;
import android.icu.text.SimpleDateFormat;
import android.icu.text.UFormat;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MessageFormat
extends UFormat
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static long serialVersionUID = 7136212545847378652L;
    private transient ULocale ulocale;
    private transient MessagePattern msgPattern;
    private transient Map<Integer, Format> cachedFormatters;
    private transient Set<Integer> customFormatArgStarts;
    private transient DateFormat stockDateFormatter;
    private transient NumberFormat stockNumberFormatter;
    private transient PluralSelectorProvider pluralProvider;
    private transient PluralSelectorProvider ordinalProvider;
    private static String[] typeList;
    private static int TYPE_NUMBER = 0;
    private static int TYPE_DATE = 1;
    private static int TYPE_TIME = 2;
    private static int TYPE_SPELLOUT = 3;
    private static int TYPE_ORDINAL = 4;
    private static int TYPE_DURATION = 5;
    private static String[] modifierList;
    private static int MODIFIER_EMPTY = 0;
    private static int MODIFIER_CURRENCY = 1;
    private static int MODIFIER_PERCENT = 2;
    private static int MODIFIER_INTEGER = 3;
    private static String[] dateModifierList;
    private static int DATE_MODIFIER_EMPTY = 0;
    private static int DATE_MODIFIER_SHORT = 1;
    private static int DATE_MODIFIER_MEDIUM = 2;
    private static int DATE_MODIFIER_LONG = 3;
    private static int DATE_MODIFIER_FULL = 4;
    private static Locale rootLocale;
    private static char SINGLE_QUOTE = '\'';
    private static char CURLY_BRACE_LEFT = '{';
    private static char CURLY_BRACE_RIGHT = '}';
    private static int STATE_INITIAL = 0;
    private static int STATE_SINGLE_QUOTE = 1;
    private static int STATE_IN_QUOTE = 2;
    private static int STATE_MSG_ELEMENT = 3;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_MessageFormat$__constructor__(String pattern) {
        this.ulocale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.applyPattern(pattern);
    }

    private void $$robo$$android_icu_text_MessageFormat$__constructor__(String pattern, Locale locale) {
    }

    private void $$robo$$android_icu_text_MessageFormat$__constructor__(String pattern, ULocale locale) {
        this.ulocale = locale;
        this.applyPattern(pattern);
    }

    private final void $$robo$$android_icu_text_MessageFormat$setLocale(Locale locale) {
        this.setLocale(ULocale.forLocale(locale));
    }

    private final void $$robo$$android_icu_text_MessageFormat$setLocale(ULocale locale) {
        String existingPattern = this.toPattern();
        this.ulocale = locale;
        this.stockDateFormatter = null;
        this.stockNumberFormatter = null;
        this.pluralProvider = null;
        this.ordinalProvider = null;
        this.applyPattern(existingPattern);
    }

    private final Locale $$robo$$android_icu_text_MessageFormat$getLocale() {
        return this.ulocale.toLocale();
    }

    private final ULocale $$robo$$android_icu_text_MessageFormat$getULocale() {
        return this.ulocale;
    }

    private final void $$robo$$android_icu_text_MessageFormat$applyPattern(String pttrn) {
        try {
            if (this.msgPattern == null) {
                this.msgPattern = new MessagePattern(pttrn);
            } else {
                this.msgPattern.parse(pttrn);
            }
            this.cacheExplicitFormats();
        }
        catch (RuntimeException e) {
            this.resetPattern();
            throw e;
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$applyPattern(String pattern, MessagePattern.ApostropheMode aposMode) {
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern(aposMode);
        } else if (aposMode != this.msgPattern.getApostropheMode()) {
            this.msgPattern.clearPatternAndSetApostropheMode(aposMode);
        }
        this.applyPattern(pattern);
    }

    private final MessagePattern.ApostropheMode $$robo$$android_icu_text_MessageFormat$getApostropheMode() {
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        return this.msgPattern.getApostropheMode();
    }

    private final String $$robo$$android_icu_text_MessageFormat$toPattern() {
        if (this.customFormatArgStarts != null) {
            throw new IllegalStateException("toPattern() is not supported after custom Format objects have been set via setFormat() or similar APIs");
        }
        if (this.msgPattern == null) {
            return "";
        }
        String originalPattern = this.msgPattern.getPatternString();
        return originalPattern == null ? "" : originalPattern;
    }

    private final int $$robo$$android_icu_text_MessageFormat$nextTopLevelArgStart(int partIndex) {
        MessagePattern.Part.Type type;
        if (partIndex != 0) {
            partIndex = this.msgPattern.getLimitPartIndex(partIndex);
        }
        do {
            if ((type = this.msgPattern.getPartType(++partIndex)) != MessagePattern.Part.Type.ARG_START) continue;
            return partIndex;
        } while (type != MessagePattern.Part.Type.MSG_LIMIT);
        return -1;
    }

    private final boolean $$robo$$android_icu_text_MessageFormat$argNameMatches(int partIndex, String argName, int argNumber) {
        MessagePattern.Part part = this.msgPattern.getPart(partIndex);
        return part.getType() == MessagePattern.Part.Type.ARG_NAME ? this.msgPattern.partSubstringMatches(part, argName) : part.getValue() == argNumber;
    }

    private final String $$robo$$android_icu_text_MessageFormat$getArgName(int partIndex) {
        MessagePattern.Part part = this.msgPattern.getPart(partIndex);
        if (part.getType() == MessagePattern.Part.Type.ARG_NAME) {
            return this.msgPattern.getSubstring(part);
        }
        return Integer.toString(part.getValue());
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormatsByArgumentIndex(Format[] newFormats) {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            int argNumber = this.msgPattern.getPart(partIndex + 1).getValue();
            if (argNumber >= newFormats.length) continue;
            this.setCustomArgStartFormat(partIndex, newFormats[argNumber]);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormatsByArgumentName(Map<String, Format> newFormats) {
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            String key = this.getArgName(partIndex + 1);
            if (!newFormats.containsKey(key)) continue;
            this.setCustomArgStartFormat(partIndex, newFormats.get(key));
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormats(Format[] newFormats) {
        int partIndex = 0;
        for (int formatNumber = 0; formatNumber < newFormats.length && (partIndex = this.nextTopLevelArgStart(partIndex)) >= 0; ++formatNumber) {
            this.setCustomArgStartFormat(partIndex, newFormats[formatNumber]);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            if (this.msgPattern.getPart(partIndex + 1).getValue() != argumentIndex) continue;
            this.setCustomArgStartFormat(partIndex, newFormat);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormatByArgumentName(String argumentName, Format newFormat) {
        int argNumber = MessagePattern.validateArgumentName(argumentName);
        if (argNumber < -1) {
            return;
        }
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            if (!this.argNameMatches(partIndex + 1, argumentName, argNumber)) continue;
            this.setCustomArgStartFormat(partIndex, newFormat);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setFormat(int formatElementIndex, Format newFormat) {
        int formatNumber = 0;
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            if (formatNumber == formatElementIndex) {
                this.setCustomArgStartFormat(partIndex, newFormat);
                return;
            }
            ++formatNumber;
        }
        throw new ArrayIndexOutOfBoundsException(formatElementIndex);
    }

    private final Format[] $$robo$$android_icu_text_MessageFormat$getFormatsByArgumentIndex() {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        ArrayList<Format> list = new ArrayList<Format>();
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            int argNumber = this.msgPattern.getPart(partIndex + 1).getValue();
            while (argNumber >= list.size()) {
                list.add(null);
            }
            list.set(argNumber, this.cachedFormatters == null ? null : this.cachedFormatters.get(partIndex));
        }
        return list.toArray(new Format[list.size()]);
    }

    private final Format[] $$robo$$android_icu_text_MessageFormat$getFormats() {
        ArrayList<Format> list = new ArrayList<Format>();
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            list.add(this.cachedFormatters == null ? null : this.cachedFormatters.get(partIndex));
        }
        return list.toArray(new Format[list.size()]);
    }

    private final Set<String> $$robo$$android_icu_text_MessageFormat$getArgumentNames() {
        HashSet<String> result = new HashSet<String>();
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            result.add(this.getArgName(partIndex + 1));
        }
        return result;
    }

    private final Format $$robo$$android_icu_text_MessageFormat$getFormatByArgumentName(String argumentName) {
        if (this.cachedFormatters == null) {
            return null;
        }
        int argNumber = MessagePattern.validateArgumentName(argumentName);
        if (argNumber < -1) {
            return null;
        }
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            if (!this.argNameMatches(partIndex + 1, argumentName, argNumber)) continue;
            return this.cachedFormatters.get(partIndex);
        }
        return null;
    }

    private final StringBuffer $$robo$$android_icu_text_MessageFormat$format(Object[] arguments, StringBuffer result, FieldPosition pos) {
        this.format(arguments, null, new AppendableWrapper(result), pos);
        return result;
    }

    private final StringBuffer $$robo$$android_icu_text_MessageFormat$format(Map<String, Object> arguments, StringBuffer result, FieldPosition pos) {
        this.format(null, arguments, new AppendableWrapper(result), pos);
        return result;
    }

    private static final String $$robo$$android_icu_text_MessageFormat$format(String pattern, Object ... arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    private static final String $$robo$$android_icu_text_MessageFormat$format(String pattern, Map<String, Object> arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    private final boolean $$robo$$android_icu_text_MessageFormat$usesNamedArguments() {
        return this.msgPattern.hasNamedArguments();
    }

    private final StringBuffer $$robo$$android_icu_text_MessageFormat$format(Object arguments, StringBuffer result, FieldPosition pos) {
        this.format(arguments, new AppendableWrapper(result), pos);
        return result;
    }

    private final AttributedCharacterIterator $$robo$$android_icu_text_MessageFormat$formatToCharacterIterator(Object arguments) {
        if (arguments == null) {
            throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
        }
        StringBuilder result = new StringBuilder();
        AppendableWrapper wrapper = new AppendableWrapper(result);
        wrapper.useAttributes();
        this.format(arguments, wrapper, null);
        AttributedString as = new AttributedString(result.toString());
        for (AttributeAndPosition a : wrapper.attributes) {
            as.addAttribute(a.key, a.value, a.start, a.limit);
        }
        return as.getIterator();
    }

    private final Object[] $$robo$$android_icu_text_MessageFormat$parse(String source, ParsePosition pos) {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use named argument.");
        }
        int maxArgId = -1;
        int partIndex = 0;
        while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
            int argNumber = this.msgPattern.getPart(partIndex + 1).getValue();
            if (argNumber <= maxArgId) continue;
            maxArgId = argNumber;
        }
        Object[] resultArray = new Object[maxArgId + 1];
        int backupStartPos = pos.getIndex();
        this.parse(0, source, pos, resultArray, null);
        if (pos.getIndex() == backupStartPos) {
            return null;
        }
        return resultArray;
    }

    private final Map<String, Object> $$robo$$android_icu_text_MessageFormat$parseToMap(String source, ParsePosition pos) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int backupStartPos = pos.getIndex();
        this.parse(0, source, pos, null, result);
        if (pos.getIndex() == backupStartPos) {
            return null;
        }
        return result;
    }

    private final Object[] $$robo$$android_icu_text_MessageFormat$parse(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Object[] result = this.parse(source, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", pos.getErrorIndex());
        }
        return result;
    }

    private final void $$robo$$android_icu_text_MessageFormat$parse(int msgStart, String source, ParsePosition pos, Object[] args, Map<String, Object> argsMap) {
        if (source == null) {
            return;
        }
        String msgString = this.msgPattern.getPatternString();
        int prevIndex = this.msgPattern.getPart(msgStart).getLimit();
        int sourceOffset = pos.getIndex();
        ParsePosition tempStatus = new ParsePosition(0);
        int i = msgStart + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(i);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            int len = index - prevIndex;
            if (len == 0 || msgString.regionMatches(prevIndex, source, sourceOffset, len)) {
                sourceOffset += len;
                prevIndex += len;
            } else {
                pos.setErrorIndex(sourceOffset);
                return;
            }
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                pos.setIndex(sourceOffset);
                return;
            }
            if (type == MessagePattern.Part.Type.SKIP_SYNTAX || type == MessagePattern.Part.Type.INSERT_CHAR) {
                prevIndex = part.getLimit();
            } else {
                if (!$assertionsDisabled && type != MessagePattern.Part.Type.ARG_START) {
                    throw new AssertionError((Object)("Unexpected Part " + part + " in parsed message."));
                }
                int argLimit = this.msgPattern.getLimitPartIndex(i);
                MessagePattern.ArgType argType = part.getArgType();
                part = this.msgPattern.getPart(++i);
                Object argId = null;
                int argNumber = 0;
                String key = null;
                if (args != null) {
                    argNumber = part.getValue();
                    argId = argNumber;
                } else {
                    key = part.getType() == MessagePattern.Part.Type.ARG_NAME ? this.msgPattern.getSubstring(part) : Integer.toString(part.getValue());
                    argId = key;
                }
                Format formatter = null;
                boolean haveArgResult = false;
                Object argResult = null;
                if (this.cachedFormatters != null && (formatter = this.cachedFormatters.get(++i - 2)) != null) {
                    tempStatus.setIndex(sourceOffset);
                    argResult = formatter.parseObject(source, tempStatus);
                    if (tempStatus.getIndex() == sourceOffset) {
                        pos.setErrorIndex(sourceOffset);
                        return;
                    }
                    haveArgResult = true;
                    sourceOffset = tempStatus.getIndex();
                } else if (argType == MessagePattern.ArgType.NONE || this.cachedFormatters != null && this.cachedFormatters.containsKey(i - 2)) {
                    String stringAfterArgument = this.getLiteralStringUntilNextArgument(argLimit);
                    int next = stringAfterArgument.length() != 0 ? source.indexOf(stringAfterArgument, sourceOffset) : source.length();
                    if (next < 0) {
                        pos.setErrorIndex(sourceOffset);
                        return;
                    }
                    String strValue = source.substring(sourceOffset, next);
                    if (!strValue.equals("{" + argId.toString() + "}")) {
                        haveArgResult = true;
                        argResult = strValue;
                    }
                    sourceOffset = next;
                } else if (argType == MessagePattern.ArgType.CHOICE) {
                    tempStatus.setIndex(sourceOffset);
                    double choiceResult = MessageFormat.parseChoiceArgument(this.msgPattern, i, source, tempStatus);
                    if (tempStatus.getIndex() == sourceOffset) {
                        pos.setErrorIndex(sourceOffset);
                        return;
                    }
                    argResult = choiceResult;
                    haveArgResult = true;
                    sourceOffset = tempStatus.getIndex();
                } else {
                    if (argType.hasPluralStyle() || argType == MessagePattern.ArgType.SELECT) {
                        throw new UnsupportedOperationException("Parsing of plural/select/selectordinal argument is not supported.");
                    }
                    throw new IllegalStateException("unexpected argType " + (Object)((Object)argType));
                }
                if (haveArgResult) {
                    if (args != null) {
                        args[argNumber] = argResult;
                    } else if (argsMap != null) {
                        argsMap.put(key, argResult);
                    }
                }
                prevIndex = this.msgPattern.getPart(argLimit).getLimit();
                i = argLimit;
            }
            ++i;
        }
    }

    private final Map<String, Object> $$robo$$android_icu_text_MessageFormat$parseToMap(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.parse(0, source, pos, null, result);
        if (pos.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", pos.getErrorIndex());
        }
        return result;
    }

    private final Object $$robo$$android_icu_text_MessageFormat$parseObject(String source, ParsePosition pos) {
        if (!this.msgPattern.hasNamedArguments()) {
            return this.parse(source, pos);
        }
        return this.parseToMap(source, pos);
    }

    private final Object $$robo$$android_icu_text_MessageFormat$clone() {
        MessageFormat other = (MessageFormat)super.clone();
        if (this.customFormatArgStarts != null) {
            other.customFormatArgStarts = new HashSet<Integer>();
            for (Integer key : this.customFormatArgStarts) {
                other.customFormatArgStarts.add(key);
            }
        } else {
            other.customFormatArgStarts = null;
        }
        if (this.cachedFormatters != null) {
            other.cachedFormatters = new HashMap<Integer, Format>();
            for (Map.Entry<Integer, Format> entry : this.cachedFormatters.entrySet()) {
                other.cachedFormatters.put(entry.getKey(), entry.getValue());
            }
        } else {
            other.cachedFormatters = null;
        }
        other.msgPattern = this.msgPattern == null ? null : (MessagePattern)this.msgPattern.clone();
        other.stockDateFormatter = this.stockDateFormatter == null ? null : (DateFormat)this.stockDateFormatter.clone();
        other.stockNumberFormatter = this.stockNumberFormatter == null ? null : (NumberFormat)this.stockNumberFormatter.clone();
        other.pluralProvider = null;
        other.ordinalProvider = null;
        return other;
    }

    private final boolean $$robo$$android_icu_text_MessageFormat$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFormat other = (MessageFormat)obj;
        return Utility.objectEquals(this.ulocale, other.ulocale) && Utility.objectEquals(this.msgPattern, other.msgPattern) && Utility.objectEquals(this.cachedFormatters, other.cachedFormatters) && Utility.objectEquals(this.customFormatArgStarts, other.customFormatArgStarts);
    }

    private final int $$robo$$android_icu_text_MessageFormat$hashCode() {
        return this.msgPattern.getPatternString().hashCode();
    }

    private final DateFormat $$robo$$android_icu_text_MessageFormat$getStockDateFormatter() {
        if (this.stockDateFormatter == null) {
            this.stockDateFormatter = DateFormat.getDateTimeInstance(3, 3, this.ulocale);
        }
        return this.stockDateFormatter;
    }

    private final NumberFormat $$robo$$android_icu_text_MessageFormat$getStockNumberFormatter() {
        if (this.stockNumberFormatter == null) {
            this.stockNumberFormatter = NumberFormat.getInstance(this.ulocale);
        }
        return this.stockNumberFormatter;
    }

    private final void $$robo$$android_icu_text_MessageFormat$format(int msgStart, PluralSelectorContext pluralNumber, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest, FieldPosition fp) {
        String msgString = this.msgPattern.getPatternString();
        int prevIndex = this.msgPattern.getPart(msgStart).getLimit();
        int i = msgStart + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(i);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            dest.append(msgString, prevIndex, index);
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                return;
            }
            prevIndex = part.getLimit();
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                if (pluralNumber.forReplaceNumber) {
                    dest.formatAndAppend(pluralNumber.formatter, pluralNumber.number, pluralNumber.numberString);
                } else {
                    dest.formatAndAppend(this.getStockNumberFormatter(), pluralNumber.number);
                }
            } else if (type == MessagePattern.Part.Type.ARG_START) {
                Object arg;
                int argLimit = this.msgPattern.getLimitPartIndex(i);
                MessagePattern.ArgType argType = part.getArgType();
                part = this.msgPattern.getPart(++i);
                boolean noArg = false;
                Object argId = null;
                String argName = this.msgPattern.getSubstring(part);
                if (args != null) {
                    int argNumber = part.getValue();
                    if (dest.attributes != null) {
                        argId = argNumber;
                    }
                    if (0 <= argNumber && argNumber < args.length) {
                        arg = args[argNumber];
                    } else {
                        arg = null;
                        noArg = true;
                    }
                } else {
                    argId = argName;
                    if (argsMap != null && argsMap.containsKey(argName)) {
                        arg = argsMap.get(argName);
                    } else {
                        arg = null;
                        noArg = true;
                    }
                }
                ++i;
                int prevDestLength = dest.length;
                Format formatter = null;
                if (noArg) {
                    dest.append("{" + argName + "}");
                } else if (arg == null) {
                    dest.append("null");
                } else if (pluralNumber != null && pluralNumber.numberArgIndex == i - 2) {
                    if (pluralNumber.offset == 0.0) {
                        dest.formatAndAppend(pluralNumber.formatter, pluralNumber.number, pluralNumber.numberString);
                    } else {
                        dest.formatAndAppend(pluralNumber.formatter, arg);
                    }
                } else if (this.cachedFormatters != null && (formatter = this.cachedFormatters.get(i - 2)) != null) {
                    if (formatter instanceof ChoiceFormat || formatter instanceof PluralFormat || formatter instanceof SelectFormat) {
                        String subMsgString = formatter.format(arg);
                        if (subMsgString.indexOf(123) >= 0 || subMsgString.indexOf(39) >= 0 && !this.msgPattern.jdkAposMode()) {
                            MessageFormat subMsgFormat = new MessageFormat(subMsgString, this.ulocale);
                            subMsgFormat.format(0, null, args, argsMap, dest, null);
                        } else if (dest.attributes == null) {
                            dest.append(subMsgString);
                        } else {
                            dest.formatAndAppend(formatter, arg);
                        }
                    } else {
                        dest.formatAndAppend(formatter, arg);
                    }
                } else if (argType == MessagePattern.ArgType.NONE || this.cachedFormatters != null && this.cachedFormatters.containsKey(i - 2)) {
                    if (arg instanceof Number) {
                        dest.formatAndAppend(this.getStockNumberFormatter(), arg);
                    } else if (arg instanceof Date) {
                        dest.formatAndAppend(this.getStockDateFormatter(), arg);
                    } else {
                        dest.append(arg.toString());
                    }
                } else if (argType == MessagePattern.ArgType.CHOICE) {
                    if (!(arg instanceof Number)) {
                        throw new IllegalArgumentException("'" + arg + "' is not a Number");
                    }
                    double number = ((Number)arg).doubleValue();
                    int subMsgStart = MessageFormat.findChoiceSubMessage(this.msgPattern, i, number);
                    this.formatComplexSubMessage(subMsgStart, null, args, argsMap, dest);
                } else if (argType.hasPluralStyle()) {
                    PluralSelectorProvider selector;
                    if (!(arg instanceof Number)) {
                        throw new IllegalArgumentException("'" + arg + "' is not a Number");
                    }
                    if (argType == MessagePattern.ArgType.PLURAL) {
                        if (this.pluralProvider == null) {
                            this.pluralProvider = new PluralSelectorProvider(this, PluralRules.PluralType.CARDINAL);
                        }
                        selector = this.pluralProvider;
                    } else {
                        if (this.ordinalProvider == null) {
                            this.ordinalProvider = new PluralSelectorProvider(this, PluralRules.PluralType.ORDINAL);
                        }
                        selector = this.ordinalProvider;
                    }
                    Number number = (Number)arg;
                    double offset = this.msgPattern.getPluralOffset(i);
                    PluralSelectorContext context = new PluralSelectorContext(i, argName, number, offset);
                    int subMsgStart = PluralFormat.findSubMessage(this.msgPattern, i, selector, context, number.doubleValue());
                    this.formatComplexSubMessage(subMsgStart, context, args, argsMap, dest);
                } else if (argType == MessagePattern.ArgType.SELECT) {
                    int subMsgStart = SelectFormat.findSubMessage(this.msgPattern, i, arg.toString());
                    this.formatComplexSubMessage(subMsgStart, null, args, argsMap, dest);
                } else {
                    throw new IllegalStateException("unexpected argType " + (Object)((Object)argType));
                }
                fp = this.updateMetaData(dest, prevDestLength, fp, argId);
                prevIndex = this.msgPattern.getPart(argLimit).getLimit();
                i = argLimit;
            }
            ++i;
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$formatComplexSubMessage(int msgStart, PluralSelectorContext pluralNumber, Object[] args, Map<String, Object> argsMap, AppendableWrapper dest) {
        String subMsgString;
        if (!this.msgPattern.jdkAposMode()) {
            this.format(msgStart, pluralNumber, args, argsMap, dest, null);
            return;
        }
        String msgString = this.msgPattern.getPatternString();
        StringBuilder sb = null;
        int prevIndex = this.msgPattern.getPart(msgStart).getLimit();
        int i = msgStart;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++i);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (sb == null) {
                    subMsgString = msgString.substring(prevIndex, index);
                    break;
                }
                subMsgString = sb.append(msgString, prevIndex, index).toString();
                break;
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(msgString, prevIndex, index);
                if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                    if (pluralNumber.forReplaceNumber) {
                        sb.append(pluralNumber.numberString);
                    } else {
                        sb.append(this.getStockNumberFormatter().format(pluralNumber.number));
                    }
                }
                prevIndex = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(msgString, prevIndex, index);
            prevIndex = index;
            i = this.msgPattern.getLimitPartIndex(i);
            index = this.msgPattern.getPart(i).getLimit();
            MessagePattern.appendReducedApostrophes(msgString, prevIndex, index, sb);
            prevIndex = index;
        }
        if (subMsgString.indexOf(123) >= 0) {
            MessageFormat subMsgFormat = new MessageFormat("", this.ulocale);
            subMsgFormat.applyPattern(subMsgString, MessagePattern.ApostropheMode.DOUBLE_REQUIRED);
            subMsgFormat.format(0, null, args, argsMap, dest, null);
        } else {
            dest.append(subMsgString);
        }
    }

    private final String $$robo$$android_icu_text_MessageFormat$getLiteralStringUntilNextArgument(int from) {
        StringBuilder b = new StringBuilder();
        String msgString = this.msgPattern.getPatternString();
        int prevIndex = this.msgPattern.getPart(from).getLimit();
        int i = from + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(i);
            MessagePattern.Part.Type type = part.getType();
            int index = part.getIndex();
            b.append(msgString, prevIndex, index);
            if (type == MessagePattern.Part.Type.ARG_START || type == MessagePattern.Part.Type.MSG_LIMIT) {
                return b.toString();
            }
            if (!$assertionsDisabled && type != MessagePattern.Part.Type.SKIP_SYNTAX && type != MessagePattern.Part.Type.INSERT_CHAR) {
                throw new AssertionError((Object)("Unexpected Part " + part + " in parsed message."));
            }
            prevIndex = part.getLimit();
            ++i;
        }
    }

    private final FieldPosition $$robo$$android_icu_text_MessageFormat$updateMetaData(AppendableWrapper dest, int prevLength, FieldPosition fp, Object argId) {
        if (dest.attributes != null && prevLength < dest.length) {
            dest.attributes.add(new AttributeAndPosition(argId, prevLength, dest.length));
        }
        if (fp != null && Field.ARGUMENT.equals(fp.getFieldAttribute())) {
            fp.setBeginIndex(prevLength);
            fp.setEndIndex(dest.length);
            return null;
        }
        return fp;
    }

    private static final int $$robo$$android_icu_text_MessageFormat$findChoiceSubMessage(MessagePattern pattern, int partIndex, double number) {
        int msgStart;
        double boundary;
        int selectorIndex;
        char boundaryChar;
        int count = pattern.countParts();
        partIndex += 2;
        do {
            MessagePattern.Part part;
            MessagePattern.Part.Type type;
            msgStart = partIndex;
            partIndex = pattern.getLimitPartIndex(partIndex);
            if (++partIndex >= count || (type = (part = pattern.getPart(partIndex++)).getType()) == MessagePattern.Part.Type.ARG_LIMIT) break;
            if (!$assertionsDisabled && !type.hasNumericValue()) {
                throw new AssertionError();
            }
            boundary = pattern.getNumericValue(part);
            selectorIndex = pattern.getPatternIndex(partIndex++);
        } while (!((boundaryChar = pattern.getPatternString().charAt(selectorIndex)) == '<' ? !(number > boundary) : !(number >= boundary)));
        return msgStart;
    }

    private static final double $$robo$$android_icu_text_MessageFormat$parseChoiceArgument(MessagePattern pattern, int partIndex, String source, ParsePosition pos) {
        int start;
        int furthest = start = pos.getIndex();
        double bestNumber = Double.NaN;
        double tempNumber = 0.0;
        while (pattern.getPartType(partIndex) != MessagePattern.Part.Type.ARG_LIMIT) {
            int newIndex;
            int msgLimit;
            int len;
            tempNumber = pattern.getNumericValue(pattern.getPart(partIndex));
            if ((len = MessageFormat.matchStringUntilLimitPart(pattern, partIndex += 2, msgLimit = pattern.getLimitPartIndex(partIndex), source, start)) >= 0 && (newIndex = start + len) > furthest) {
                furthest = newIndex;
                bestNumber = tempNumber;
                if (furthest == source.length()) break;
            }
            partIndex = msgLimit + 1;
        }
        if (furthest == start) {
            pos.setErrorIndex(start);
        } else {
            pos.setIndex(furthest);
        }
        return bestNumber;
    }

    private static final int $$robo$$android_icu_text_MessageFormat$matchStringUntilLimitPart(MessagePattern pattern, int partIndex, int limitPartIndex, String source, int sourceOffset) {
        int matchingSourceLength = 0;
        String msgString = pattern.getPatternString();
        int prevIndex = pattern.getPart(partIndex).getLimit();
        while (true) {
            MessagePattern.Part part = pattern.getPart(++partIndex);
            if (partIndex != limitPartIndex && part.getType() != MessagePattern.Part.Type.SKIP_SYNTAX) continue;
            int index = part.getIndex();
            int length = index - prevIndex;
            if (length != 0 && !source.regionMatches(sourceOffset, msgString, prevIndex, length)) {
                return -1;
            }
            matchingSourceLength += length;
            if (partIndex == limitPartIndex) {
                return matchingSourceLength;
            }
            prevIndex = part.getLimit();
        }
    }

    private final int $$robo$$android_icu_text_MessageFormat$findOtherSubMessage(int partIndex) {
        int count = this.msgPattern.countParts();
        MessagePattern.Part part = this.msgPattern.getPart(partIndex);
        if (part.getType().hasNumericValue()) {
            // empty if block
        }
        do {
            int n = ++partIndex;
            ++partIndex;
            part = this.msgPattern.getPart(n);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            if (!$assertionsDisabled && type != MessagePattern.Part.Type.ARG_SELECTOR) {
                throw new AssertionError();
            }
            if (this.msgPattern.partSubstringMatches(part, "other")) {
                return partIndex;
            }
            if (this.msgPattern.getPartType(partIndex).hasNumericValue()) {
                ++partIndex;
            }
            partIndex = this.msgPattern.getLimitPartIndex(partIndex);
        } while (++partIndex < count);
        return 0;
    }

    private final int $$robo$$android_icu_text_MessageFormat$findFirstPluralNumberArg(int msgStart, String argName) {
        int i = msgStart + 1;
        MessagePattern.Part part;
        MessagePattern.Part.Type type;
        while ((type = (part = this.msgPattern.getPart(i)).getType()) != MessagePattern.Part.Type.MSG_LIMIT) {
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                return -1;
            }
            if (type == MessagePattern.Part.Type.ARG_START) {
                MessagePattern.ArgType argType = part.getArgType();
                if (argName.length() != 0 && (argType == MessagePattern.ArgType.NONE || argType == MessagePattern.ArgType.SIMPLE) && this.msgPattern.partSubstringMatches(part = this.msgPattern.getPart(i + 1), argName)) {
                    return i;
                }
                i = this.msgPattern.getLimitPartIndex(i);
            }
            ++i;
        }
        return 0;
    }

    private final void $$robo$$android_icu_text_MessageFormat$format(Object arguments, AppendableWrapper result, FieldPosition fp) {
        if (arguments == null || arguments instanceof Map) {
            this.format(null, (Map)arguments, result, fp);
        } else {
            this.format((Object[])arguments, null, result, fp);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$format(Object[] arguments, Map<String, Object> argsMap, AppendableWrapper dest, FieldPosition fp) {
        if (arguments != null && this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        this.format(0, null, arguments, argsMap, dest, fp);
    }

    private final void $$robo$$android_icu_text_MessageFormat$resetPattern() {
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        if (this.cachedFormatters != null) {
            this.cachedFormatters.clear();
        }
        this.customFormatArgStarts = null;
    }

    private final Format $$robo$$android_icu_text_MessageFormat$createAppropriateFormat(String type, String style2) {
        UFormat newFormat = null;
        int subformatType = MessageFormat.findKeyword(type, typeList);
        block3 : switch (subformatType) {
            case 0: {
                switch (MessageFormat.findKeyword(style2, modifierList)) {
                    case 0: {
                        newFormat = NumberFormat.getInstance(this.ulocale);
                        break block3;
                    }
                    case 1: {
                        newFormat = NumberFormat.getCurrencyInstance(this.ulocale);
                        break block3;
                    }
                    case 2: {
                        newFormat = NumberFormat.getPercentInstance(this.ulocale);
                        break block3;
                    }
                    case 3: {
                        newFormat = NumberFormat.getIntegerInstance(this.ulocale);
                        break block3;
                    }
                }
                newFormat = new DecimalFormat(style2, new DecimalFormatSymbols(this.ulocale));
                break;
            }
            case 1: {
                switch (MessageFormat.findKeyword(style2, dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block3;
                    }
                    case 1: {
                        newFormat = DateFormat.getDateInstance(3, this.ulocale);
                        break block3;
                    }
                    case 2: {
                        newFormat = DateFormat.getDateInstance(2, this.ulocale);
                        break block3;
                    }
                    case 3: {
                        newFormat = DateFormat.getDateInstance(1, this.ulocale);
                        break block3;
                    }
                    case 4: {
                        newFormat = DateFormat.getDateInstance(0, this.ulocale);
                        break block3;
                    }
                }
                newFormat = new SimpleDateFormat(style2, this.ulocale);
                break;
            }
            case 2: {
                switch (MessageFormat.findKeyword(style2, dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block3;
                    }
                    case 1: {
                        newFormat = DateFormat.getTimeInstance(3, this.ulocale);
                        break block3;
                    }
                    case 2: {
                        newFormat = DateFormat.getTimeInstance(2, this.ulocale);
                        break block3;
                    }
                    case 3: {
                        newFormat = DateFormat.getTimeInstance(1, this.ulocale);
                        break block3;
                    }
                    case 4: {
                        newFormat = DateFormat.getTimeInstance(0, this.ulocale);
                        break block3;
                    }
                }
                newFormat = new SimpleDateFormat(style2, this.ulocale);
                break;
            }
            case 3: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 1);
                String ruleset = style2.trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 4: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 2);
                String ruleset = style2.trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            case 5: {
                RuleBasedNumberFormat rbnf = new RuleBasedNumberFormat(this.ulocale, 3);
                String ruleset = style2.trim();
                if (ruleset.length() != 0) {
                    try {
                        rbnf.setDefaultRuleSet(ruleset);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                newFormat = rbnf;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format type \"" + type + "\"");
            }
        }
        return newFormat;
    }

    private static final int $$robo$$android_icu_text_MessageFormat$findKeyword(String s, String[] list) {
        s = PatternProps.trimWhiteSpace(s).toLowerCase(rootLocale);
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_icu_text_MessageFormat$writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.ulocale.toLanguageTag());
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        out.writeObject((Object)this.msgPattern.getApostropheMode());
        out.writeObject(this.msgPattern.getPatternString());
        if (this.customFormatArgStarts == null || this.customFormatArgStarts.isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(this.customFormatArgStarts.size());
            int formatIndex = 0;
            int partIndex = 0;
            while ((partIndex = this.nextTopLevelArgStart(partIndex)) >= 0) {
                if (this.customFormatArgStarts.contains(partIndex)) {
                    out.writeInt(formatIndex);
                    out.writeObject(this.cachedFormatters.get(partIndex));
                }
                ++formatIndex;
            }
        }
        out.writeInt(0);
    }

    private final void $$robo$$android_icu_text_MessageFormat$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String msg;
        in.defaultReadObject();
        String languageTag = (String)in.readObject();
        this.ulocale = ULocale.forLanguageTag(languageTag);
        MessagePattern.ApostropheMode aposMode = (MessagePattern.ApostropheMode)((Object)in.readObject());
        if (this.msgPattern == null || aposMode != this.msgPattern.getApostropheMode()) {
            this.msgPattern = new MessagePattern(aposMode);
        }
        if ((msg = (String)in.readObject()) != null) {
            this.applyPattern(msg);
        }
        for (int numFormatters = in.readInt(); numFormatters > 0; --numFormatters) {
            int formatIndex = in.readInt();
            Format formatter = (Format)in.readObject();
            this.setFormat(formatIndex, formatter);
        }
        for (int numPairs = in.readInt(); numPairs > 0; --numPairs) {
            in.readInt();
            in.readObject();
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$cacheExplicitFormats() {
        if (this.cachedFormatters != null) {
            this.cachedFormatters.clear();
        }
        this.customFormatArgStarts = null;
        int limit = this.msgPattern.countParts() - 2;
        for (int i = 1; i < limit; ++i) {
            MessagePattern.ArgType argType;
            MessagePattern.Part part = this.msgPattern.getPart(i);
            if (part.getType() != MessagePattern.Part.Type.ARG_START || (argType = part.getArgType()) != MessagePattern.ArgType.SIMPLE) continue;
            int index = i;
            i += 2;
            String explicitType = this.msgPattern.getSubstring(this.msgPattern.getPart(i++));
            String style2 = "";
            part = this.msgPattern.getPart(i);
            if (part.getType() == MessagePattern.Part.Type.ARG_STYLE) {
                style2 = this.msgPattern.getSubstring(part);
                ++i;
            }
            Format formatter = this.createAppropriateFormat(explicitType, style2);
            this.setArgStartFormat(index, formatter);
        }
    }

    private final void $$robo$$android_icu_text_MessageFormat$setArgStartFormat(int argStart, Format formatter) {
        if (this.cachedFormatters == null) {
            this.cachedFormatters = new HashMap<Integer, Format>();
        }
        this.cachedFormatters.put(argStart, formatter);
    }

    private final void $$robo$$android_icu_text_MessageFormat$setCustomArgStartFormat(int argStart, Format formatter) {
        this.setArgStartFormat(argStart, formatter);
        if (this.customFormatArgStarts == null) {
            this.customFormatArgStarts = new HashSet<Integer>();
        }
        this.customFormatArgStarts.add(argStart);
    }

    private static final String $$robo$$android_icu_text_MessageFormat$autoQuoteApostrophe(String pattern) {
        StringBuilder buf = new StringBuilder(pattern.length() * 2);
        int state = 0;
        int braceCount = 0;
        int j = pattern.length();
        for (int i = 0; i < j; ++i) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                            ++braceCount;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '{': {
                            ++braceCount;
                            break;
                        }
                        case '}': {
                            if (--braceCount != 0) break;
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
        }
        if (state == 1 || state == 2) {
            buf.append('\'');
        }
        return new String(buf);
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !MessageFormat.class.desiredAssertionStatus();
        typeList = new String[]{"number", "date", "time", "spellout", "ordinal", "duration"};
        modifierList = new String[]{"", "currency", "percent", "integer"};
        dateModifierList = new String[]{"", "short", "medium", "long", "full"};
        rootLocale = new Locale("");
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_MessageFormat$__constructor__(string2);
    }

    public MessageFormat(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, Locale locale) {
        this.$$robo$$android_icu_text_MessageFormat$__constructor__(string2, locale);
    }

    public MessageFormat(String string2, Locale locale) {
        this(string2, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat$__constructor__(java.lang.String java.util.Locale ), 0, this, string2, locale);
    }

    private void __constructor__(String string2, ULocale uLocale) {
        this.$$robo$$android_icu_text_MessageFormat$__constructor__(string2, uLocale);
    }

    public MessageFormat(String string2, ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat$__constructor__(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
    }

    public void setLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_MessageFormat$setLocale(java.util.Locale ), 0, this, locale);
    }

    public void setLocale(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_icu_text_MessageFormat$setLocale(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public Locale getLocale() {
        return InvokeDynamicSupport.bootstrap("getLocale", $$robo$$android_icu_text_MessageFormat$getLocale(), 0, this);
    }

    public ULocale getULocale() {
        return InvokeDynamicSupport.bootstrap("getULocale", $$robo$$android_icu_text_MessageFormat$getULocale(), 0, this);
    }

    public void applyPattern(String string2) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_MessageFormat$applyPattern(java.lang.String ), 0, this, string2);
    }

    public void applyPattern(String string2, MessagePattern.ApostropheMode apostropheMode) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_MessageFormat$applyPattern(java.lang.String android.icu.text.MessagePattern$ApostropheMode ), 0, this, string2, apostropheMode);
    }

    public MessagePattern.ApostropheMode getApostropheMode() {
        return InvokeDynamicSupport.bootstrap("getApostropheMode", $$robo$$android_icu_text_MessageFormat$getApostropheMode(), 0, this);
    }

    public String toPattern() {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$android_icu_text_MessageFormat$toPattern(), 0, this);
    }

    private int nextTopLevelArgStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextTopLevelArgStart", $$robo$$android_icu_text_MessageFormat$nextTopLevelArgStart(int ), 0, this, n);
    }

    private boolean argNameMatches(int n, String string2, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("argNameMatches", $$robo$$android_icu_text_MessageFormat$argNameMatches(int java.lang.String int ), 0, this, n, string2, n2);
    }

    private String getArgName(int n) {
        return InvokeDynamicSupport.bootstrap("getArgName", $$robo$$android_icu_text_MessageFormat$getArgName(int ), 0, this, n);
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        InvokeDynamicSupport.bootstrap("setFormatsByArgumentIndex", $$robo$$android_icu_text_MessageFormat$setFormatsByArgumentIndex(java.text.Format[] ), 0, this, formatArray);
    }

    public void setFormatsByArgumentName(Map<String, Format> map) {
        InvokeDynamicSupport.bootstrap("setFormatsByArgumentName", $$robo$$android_icu_text_MessageFormat$setFormatsByArgumentName(java.util.Map<java.lang.String, java.text.Format> ), 0, this, map);
    }

    public void setFormats(Format[] formatArray) {
        InvokeDynamicSupport.bootstrap("setFormats", $$robo$$android_icu_text_MessageFormat$setFormats(java.text.Format[] ), 0, this, formatArray);
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        InvokeDynamicSupport.bootstrap("setFormatByArgumentIndex", $$robo$$android_icu_text_MessageFormat$setFormatByArgumentIndex(int java.text.Format ), 0, this, n, format);
    }

    public void setFormatByArgumentName(String string2, Format format) {
        InvokeDynamicSupport.bootstrap("setFormatByArgumentName", $$robo$$android_icu_text_MessageFormat$setFormatByArgumentName(java.lang.String java.text.Format ), 0, this, string2, format);
    }

    public void setFormat(int n, Format format) {
        InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_icu_text_MessageFormat$setFormat(int java.text.Format ), 0, this, n, format);
    }

    public Format[] getFormatsByArgumentIndex() {
        return InvokeDynamicSupport.bootstrap("getFormatsByArgumentIndex", $$robo$$android_icu_text_MessageFormat$getFormatsByArgumentIndex(), 0, this);
    }

    public Format[] getFormats() {
        return InvokeDynamicSupport.bootstrap("getFormats", $$robo$$android_icu_text_MessageFormat$getFormats(), 0, this);
    }

    public Set<String> getArgumentNames() {
        return InvokeDynamicSupport.bootstrap("getArgumentNames", $$robo$$android_icu_text_MessageFormat$getArgumentNames(), 0, this);
    }

    public Format getFormatByArgumentName(String string2) {
        return InvokeDynamicSupport.bootstrap("getFormatByArgumentName", $$robo$$android_icu_text_MessageFormat$getFormatByArgumentName(java.lang.String ), 0, this, string2);
    }

    public StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.Object[] java.lang.StringBuffer java.text.FieldPosition ), 0, this, objectArray, stringBuffer, fieldPosition);
    }

    public StringBuffer format(Map<String, Object> map, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(java.util.Map<java.lang.String, java.lang.Object> java.lang.StringBuffer java.text.FieldPosition ), 0, this, map, stringBuffer, fieldPosition);
    }

    public static String format(String string2, Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.String java.lang.Object[] ), 0, (String)string2, (Object[])objectArray);
    }

    public static String format(String string2, Map<String, Object> map) {
        return InvokeDynamicSupport.bootstrapStatic("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.String java.util.Map<java.lang.String, java.lang.Object> ), 0, (String)string2, map);
    }

    public boolean usesNamedArguments() {
        return (boolean)InvokeDynamicSupport.bootstrap("usesNamedArguments", $$robo$$android_icu_text_MessageFormat$usesNamedArguments(), 0, this);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.Object java.lang.StringBuffer java.text.FieldPosition ), 0, this, object, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return InvokeDynamicSupport.bootstrap("formatToCharacterIterator", $$robo$$android_icu_text_MessageFormat$formatToCharacterIterator(java.lang.Object ), 0, this, object);
    }

    public Object[] parse(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_MessageFormat$parse(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public Map<String, Object> parseToMap(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseToMap", $$robo$$android_icu_text_MessageFormat$parseToMap(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    public Object[] parse(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_MessageFormat$parse(java.lang.String ), 0, this, string2);
    }

    private void parse(int n, String string2, ParsePosition parsePosition, Object[] objectArray, Map<String, Object> map) {
        InvokeDynamicSupport.bootstrap("parse", $$robo$$android_icu_text_MessageFormat$parse(int java.lang.String java.text.ParsePosition java.lang.Object[] java.util.Map<java.lang.String, java.lang.Object> ), 0, this, n, string2, parsePosition, objectArray, map);
    }

    public Map<String, Object> parseToMap(String string2) throws ParseException {
        return InvokeDynamicSupport.bootstrap("parseToMap", $$robo$$android_icu_text_MessageFormat$parseToMap(java.lang.String ), 0, this, string2);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return InvokeDynamicSupport.bootstrap("parseObject", $$robo$$android_icu_text_MessageFormat$parseObject(java.lang.String java.text.ParsePosition ), 0, this, string2, parsePosition);
    }

    @Override
    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_MessageFormat$clone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_MessageFormat$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_MessageFormat$hashCode(), 0, this);
    }

    private DateFormat getStockDateFormatter() {
        return InvokeDynamicSupport.bootstrap("getStockDateFormatter", $$robo$$android_icu_text_MessageFormat$getStockDateFormatter(), 0, this);
    }

    private NumberFormat getStockNumberFormatter() {
        return InvokeDynamicSupport.bootstrap("getStockNumberFormatter", $$robo$$android_icu_text_MessageFormat$getStockNumberFormatter(), 0, this);
    }

    private void format(int n, PluralSelectorContext pluralSelectorContext, Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(int android.icu.text.MessageFormat$PluralSelectorContext java.lang.Object[] java.util.Map<java.lang.String, java.lang.Object> android.icu.text.MessageFormat$AppendableWrapper java.text.FieldPosition ), 0, this, n, pluralSelectorContext, objectArray, map, appendableWrapper, fieldPosition);
    }

    private void formatComplexSubMessage(int n, PluralSelectorContext pluralSelectorContext, Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper) {
        InvokeDynamicSupport.bootstrap("formatComplexSubMessage", $$robo$$android_icu_text_MessageFormat$formatComplexSubMessage(int android.icu.text.MessageFormat$PluralSelectorContext java.lang.Object[] java.util.Map<java.lang.String, java.lang.Object> android.icu.text.MessageFormat$AppendableWrapper ), 0, this, n, pluralSelectorContext, objectArray, map, appendableWrapper);
    }

    private String getLiteralStringUntilNextArgument(int n) {
        return InvokeDynamicSupport.bootstrap("getLiteralStringUntilNextArgument", $$robo$$android_icu_text_MessageFormat$getLiteralStringUntilNextArgument(int ), 0, this, n);
    }

    private FieldPosition updateMetaData(AppendableWrapper appendableWrapper, int n, FieldPosition fieldPosition, Object object) {
        return InvokeDynamicSupport.bootstrap("updateMetaData", $$robo$$android_icu_text_MessageFormat$updateMetaData(android.icu.text.MessageFormat$AppendableWrapper int java.text.FieldPosition java.lang.Object ), 0, this, appendableWrapper, n, fieldPosition, object);
    }

    private static int findChoiceSubMessage(MessagePattern messagePattern, int n, double d) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findChoiceSubMessage", $$robo$$android_icu_text_MessageFormat$findChoiceSubMessage(android.icu.text.MessagePattern int double ), 0, (MessagePattern)messagePattern, (int)n, (double)d);
    }

    private static double parseChoiceArgument(MessagePattern messagePattern, int n, String string2, ParsePosition parsePosition) {
        return (double)InvokeDynamicSupport.bootstrapStatic("parseChoiceArgument", $$robo$$android_icu_text_MessageFormat$parseChoiceArgument(android.icu.text.MessagePattern int java.lang.String java.text.ParsePosition ), 0, (MessagePattern)messagePattern, (int)n, (String)string2, (ParsePosition)parsePosition);
    }

    private static int matchStringUntilLimitPart(MessagePattern messagePattern, int n, int n2, String string2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("matchStringUntilLimitPart", $$robo$$android_icu_text_MessageFormat$matchStringUntilLimitPart(android.icu.text.MessagePattern int int java.lang.String int ), 0, (MessagePattern)messagePattern, (int)n, (int)n2, (String)string2, (int)n3);
    }

    private int findOtherSubMessage(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findOtherSubMessage", $$robo$$android_icu_text_MessageFormat$findOtherSubMessage(int ), 0, this, n);
    }

    private int findFirstPluralNumberArg(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("findFirstPluralNumberArg", $$robo$$android_icu_text_MessageFormat$findFirstPluralNumberArg(int java.lang.String ), 0, this, n, string2);
    }

    private void format(Object object, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.Object android.icu.text.MessageFormat$AppendableWrapper java.text.FieldPosition ), 0, this, object, appendableWrapper, fieldPosition);
    }

    private void format(Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        InvokeDynamicSupport.bootstrap("format", $$robo$$android_icu_text_MessageFormat$format(java.lang.Object[] java.util.Map<java.lang.String, java.lang.Object> android.icu.text.MessageFormat$AppendableWrapper java.text.FieldPosition ), 0, this, objectArray, map, appendableWrapper, fieldPosition);
    }

    private void resetPattern() {
        InvokeDynamicSupport.bootstrap("resetPattern", $$robo$$android_icu_text_MessageFormat$resetPattern(), 0, this);
    }

    private Format createAppropriateFormat(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("createAppropriateFormat", $$robo$$android_icu_text_MessageFormat$createAppropriateFormat(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private static int findKeyword(String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findKeyword", $$robo$$android_icu_text_MessageFormat$findKeyword(java.lang.String java.lang.String[] ), 0, (String)string2, (String[])stringArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_text_MessageFormat$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_text_MessageFormat$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    private void cacheExplicitFormats() {
        InvokeDynamicSupport.bootstrap("cacheExplicitFormats", $$robo$$android_icu_text_MessageFormat$cacheExplicitFormats(), 0, this);
    }

    private void setArgStartFormat(int n, Format format) {
        InvokeDynamicSupport.bootstrap("setArgStartFormat", $$robo$$android_icu_text_MessageFormat$setArgStartFormat(int java.text.Format ), 0, this, n, format);
    }

    private void setCustomArgStartFormat(int n, Format format) {
        InvokeDynamicSupport.bootstrap("setCustomArgStartFormat", $$robo$$android_icu_text_MessageFormat$setCustomArgStartFormat(int java.text.Format ), 0, this, n, format);
    }

    public static String autoQuoteApostrophe(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("autoQuoteApostrophe", $$robo$$android_icu_text_MessageFormat$autoQuoteApostrophe(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(MessageFormat.class);
    }

    public /* synthetic */ MessageFormat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageFormat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class AttributeAndPosition
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AttributedCharacterIterator.Attribute key;
        private Object value;
        private int start;
        private int limit;

        private void $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(Object fieldValue, int startIndex, int limitIndex) {
            this.init(Field.ARGUMENT, fieldValue, startIndex, limitIndex);
        }

        private void $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(AttributedCharacterIterator.Attribute field, Object fieldValue, int startIndex, int limitIndex) {
            this.init(field, fieldValue, startIndex, limitIndex);
        }

        private final void $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$init(AttributedCharacterIterator.Attribute field, Object fieldValue, int startIndex, int limitIndex) {
            this.key = field;
            this.value = fieldValue;
            this.start = startIndex;
            this.limit = limitIndex;
        }

        private void __constructor__(Object object, int n, int n2) {
            this.$$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(object, n, n2);
        }

        public AttributeAndPosition(Object object, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(java.lang.Object int int ), 0, this, object, n, n2);
        }

        private void __constructor__(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            this.$$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(attribute, object, n, n2);
        }

        public AttributeAndPosition(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$__constructor__(java.text.AttributedCharacterIterator$Attribute java.lang.Object int int ), 0, this, attribute, object, n, n2);
        }

        public void init(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_text_MessageFormat_AttributeAndPosition$init(java.text.AttributedCharacterIterator$Attribute java.lang.Object int int ), 0, this, attribute, object, n, n2);
        }

        public /* synthetic */ AttributeAndPosition() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AttributeAndPosition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class AppendableWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Appendable app;
        private int length;
        private List<AttributeAndPosition> attributes;

        private void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(StringBuilder sb) {
            this.app = sb;
            this.length = sb.length();
            this.attributes = null;
        }

        private void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(StringBuffer sb) {
            this.app = sb;
            this.length = sb.length();
            this.attributes = null;
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$useAttributes() {
            this.attributes = new ArrayList<AttributeAndPosition>();
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(CharSequence s) {
            try {
                this.app.append(s);
                this.length += s.length();
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(CharSequence s, int start, int limit) {
            try {
                this.app.append(s, start, limit);
                this.length += limit - start;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(CharacterIterator iterator) {
            this.length += AppendableWrapper.append(this.app, iterator);
        }

        private static final int $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(Appendable result, CharacterIterator iterator) {
            try {
                int start = iterator.getBeginIndex();
                int limit = iterator.getEndIndex();
                int length = limit - start;
                if (start < limit) {
                    result.append(iterator.first());
                    while (++start < limit) {
                        result.append(iterator.next());
                    }
                }
                return length;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$formatAndAppend(Format formatter, Object arg) {
            if (this.attributes == null) {
                this.append(formatter.format(arg));
            } else {
                AttributedCharacterIterator formattedArg = formatter.formatToCharacterIterator(arg);
                int prevLength = this.length;
                this.append(formattedArg);
                formattedArg.first();
                int start = formattedArg.getIndex();
                int limit = formattedArg.getEndIndex();
                int offset = prevLength - start;
                while (start < limit) {
                    Map<AttributedCharacterIterator.Attribute, Object> map = formattedArg.getAttributes();
                    int runLimit = formattedArg.getRunLimit();
                    if (map.size() != 0) {
                        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                            this.attributes.add(new AttributeAndPosition(entry.getKey(), entry.getValue(), offset + start, offset + runLimit));
                        }
                    }
                    start = runLimit;
                    formattedArg.setIndex(start);
                }
            }
        }

        private final void $$robo$$android_icu_text_MessageFormat_AppendableWrapper$formatAndAppend(Format formatter, Object arg, String argString) {
            if (this.attributes == null && argString != null) {
                this.append(argString);
            } else {
                this.formatAndAppend(formatter, arg);
            }
        }

        private void __constructor__(StringBuilder stringBuilder) {
            this.$$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(stringBuilder);
        }

        public AppendableWrapper(StringBuilder stringBuilder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        private void __constructor__(StringBuffer stringBuffer) {
            this.$$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(stringBuffer);
        }

        public AppendableWrapper(StringBuffer stringBuffer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$__constructor__(java.lang.StringBuffer ), 0, this, stringBuffer);
        }

        public void useAttributes() {
            InvokeDynamicSupport.bootstrap("useAttributes", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$useAttributes(), 0, this);
        }

        public void append(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(java.lang.CharSequence ), 0, this, charSequence);
        }

        public void append(CharSequence charSequence, int n, int n2) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
        }

        public void append(CharacterIterator characterIterator) {
            InvokeDynamicSupport.bootstrap("append", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(java.text.CharacterIterator ), 0, this, characterIterator);
        }

        public static int append(Appendable appendable, CharacterIterator characterIterator) {
            return (int)InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$append(java.lang.Appendable java.text.CharacterIterator ), 0, (Appendable)appendable, (CharacterIterator)characterIterator);
        }

        public void formatAndAppend(Format format, Object object) {
            InvokeDynamicSupport.bootstrap("formatAndAppend", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$formatAndAppend(java.text.Format java.lang.Object ), 0, this, format, object);
        }

        public void formatAndAppend(Format format, Object object, String string2) {
            InvokeDynamicSupport.bootstrap("formatAndAppend", $$robo$$android_icu_text_MessageFormat_AppendableWrapper$formatAndAppend(java.text.Format java.lang.Object java.lang.String ), 0, this, format, object, string2);
        }

        public /* synthetic */ AppendableWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppendableWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class PluralSelectorProvider
    implements PluralFormat.PluralSelector,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MessageFormat msgFormat;
        private PluralRules rules;
        private PluralRules.PluralType type;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_MessageFormat_PluralSelectorProvider$__constructor__(MessageFormat mf, PluralRules.PluralType type) {
            this.msgFormat = mf;
            this.type = type;
        }

        private final String $$robo$$android_icu_text_MessageFormat_PluralSelectorProvider$select(Object ctx, double number) {
            if (this.rules == null) {
                this.rules = PluralRules.forLocale(this.msgFormat.ulocale, this.type);
            }
            PluralSelectorContext context = (PluralSelectorContext)ctx;
            int otherIndex = this.msgFormat.findOtherSubMessage(context.startIndex);
            context.numberArgIndex = this.msgFormat.findFirstPluralNumberArg(otherIndex, context.argName);
            if (context.numberArgIndex > 0 && this.msgFormat.cachedFormatters != null) {
                context.formatter = (Format)this.msgFormat.cachedFormatters.get(context.numberArgIndex);
            }
            if (context.formatter == null) {
                context.formatter = this.msgFormat.getStockNumberFormatter();
                context.forReplaceNumber = true;
            }
            if (!$assertionsDisabled && context.number.doubleValue() != number) {
                throw new AssertionError();
            }
            context.numberString = context.formatter.format(context.number);
            if (context.formatter instanceof DecimalFormat) {
                PluralRules.FixedDecimal dec = ((DecimalFormat)context.formatter).getFixedDecimal(number);
                return this.rules.select(dec);
            }
            return this.rules.select(number);
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !MessageFormat.class.desiredAssertionStatus();
        }

        private void __constructor__(MessageFormat messageFormat, PluralRules.PluralType pluralType) {
            this.$$robo$$android_icu_text_MessageFormat_PluralSelectorProvider$__constructor__(messageFormat, pluralType);
        }

        public PluralSelectorProvider(MessageFormat messageFormat, PluralRules.PluralType pluralType) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_PluralSelectorProvider$__constructor__(android.icu.text.MessageFormat android.icu.text.PluralRules$PluralType ), 0, this, messageFormat, pluralType);
        }

        @Override
        public String select(Object object, double d) {
            return InvokeDynamicSupport.bootstrap("select", $$robo$$android_icu_text_MessageFormat_PluralSelectorProvider$select(java.lang.Object double ), 0, this, object, d);
        }

        static {
            RobolectricInternals.classInitializing(PluralSelectorProvider.class);
        }

        public /* synthetic */ PluralSelectorProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralSelectorProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class PluralSelectorContext
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int startIndex;
        String argName;
        Number number;
        double offset;
        int numberArgIndex;
        Format formatter;
        String numberString;
        boolean forReplaceNumber;

        private void $$robo$$android_icu_text_MessageFormat_PluralSelectorContext$__constructor__(int start, String name, Number num, double off) {
            this.startIndex = start;
            this.argName = name;
            this.number = off == 0.0 ? (Number)num : (Number)(num.doubleValue() - off);
            this.offset = off;
        }

        private final String $$robo$$android_icu_text_MessageFormat_PluralSelectorContext$toString() {
            throw new AssertionError((Object)"PluralSelectorContext being formatted, rather than its number");
        }

        private /* synthetic */ void $$robo$$android_icu_text_MessageFormat_PluralSelectorContext$__constructor__(int x0, String x1, Number x2, double x3, 1 x4) {
        }

        private void __constructor__(int n, String string2, Number number, double d) {
            this.$$robo$$android_icu_text_MessageFormat_PluralSelectorContext$__constructor__(n, string2, number, d);
        }

        private PluralSelectorContext(int n, String string2, Number number, double d) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_PluralSelectorContext$__constructor__(int java.lang.String java.lang.Number double ), 0, this, n, string2, number, d);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_MessageFormat_PluralSelectorContext$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, String string2, Number number, double d, 1 var6_5) {
            this.$$robo$$android_icu_text_MessageFormat_PluralSelectorContext$__constructor__(n, string2, number, d, var6_5);
        }

        public /* synthetic */ PluralSelectorContext() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PluralSelectorContext)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Field
    extends Format.Field
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = 7510380454602616157L;
        public static Field ARGUMENT;

        private void $$robo$$android_icu_text_MessageFormat_Field$__constructor__(String name) {
        }

        private final Object $$robo$$android_icu_text_MessageFormat_Field$readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("A subclass of MessageFormat.Field must implement readResolve.");
            }
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("Unknown attribute name.");
        }

        static void __staticInitializer__() {
            ARGUMENT = new Field("message argument field");
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_MessageFormat_Field$__constructor__(string2);
        }

        protected Field(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_MessageFormat_Field$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            return InvokeDynamicSupport.bootstrap("readResolve", $$robo$$android_icu_text_MessageFormat_Field$readResolve(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Field.class);
        }

        public /* synthetic */ Field() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Field)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

