/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.text.BreakIterator;
import android.icu.text.CollationElementIterator;
import android.icu.text.Collator;
import android.icu.text.Normalizer;
import android.icu.text.Normalizer2;
import android.icu.text.RuleBasedCollator;
import android.icu.text.SearchIterator;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class StringSearch
extends SearchIterator
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Pattern pattern_;
    private RuleBasedCollator collator_;
    private CollationElementIterator textIter_;
    private CollationPCE textProcessedIter_;
    private CollationElementIterator utilIter_;
    private Normalizer2 nfd_;
    private int strength_;
    int ceMask_;
    int variableTop_;
    private boolean toShift_;
    private static int INITIAL_ARRAY_SIZE_ = 256;
    private static int PRIMARYORDERMASK = -65536;
    private static int SECONDARYORDERMASK = 65280;
    private static int TERTIARYORDERMASK = 255;
    private static int CE_MATCH = -1;
    private static int CE_NO_MATCH = 0;
    private static int CE_SKIP_TARG = 1;
    private static int CE_SKIP_PATN = 2;
    private static int CE_LEVEL2_BASE;
    private static int CE_LEVEL3_BASE;

    private void $$robo$$android_icu_text_StringSearch$__constructor__(String pattern, CharacterIterator target, RuleBasedCollator collator, BreakIterator breakiter) {
        if (collator.getNumericCollation()) {
            throw new UnsupportedOperationException("Numeric collation is not supported by StringSearch");
        }
        this.collator_ = collator;
        this.strength_ = collator.getStrength();
        this.ceMask_ = StringSearch.getMask(this.strength_);
        this.toShift_ = collator.isAlternateHandlingShifted();
        this.variableTop_ = collator.getVariableTop();
        this.nfd_ = Normalizer2.getNFDInstance();
        this.pattern_ = new Pattern(pattern);
        this.search_.setMatchedLength(0);
        this.search_.matchedIndex_ = -1;
        this.utilIter_ = null;
        this.textIter_ = new CollationElementIterator(target, collator);
        this.textProcessedIter_ = null;
        ULocale collLocale = collator.getLocale(ULocale.VALID_LOCALE);
        this.search_.internalBreakIter_ = BreakIterator.getCharacterInstance(collLocale == null ? ULocale.ROOT : collLocale);
        this.search_.internalBreakIter_.setText((CharacterIterator)target.clone());
        this.initialize();
    }

    private void $$robo$$android_icu_text_StringSearch$__constructor__(String pattern, CharacterIterator target, RuleBasedCollator collator) {
    }

    private void $$robo$$android_icu_text_StringSearch$__constructor__(String pattern, CharacterIterator target, Locale locale) {
    }

    private void $$robo$$android_icu_text_StringSearch$__constructor__(String pattern, CharacterIterator target, ULocale locale) {
    }

    private void $$robo$$android_icu_text_StringSearch$__constructor__(String pattern, String target) {
    }

    private final RuleBasedCollator $$robo$$android_icu_text_StringSearch$getCollator() {
        return this.collator_;
    }

    private final void $$robo$$android_icu_text_StringSearch$setCollator(RuleBasedCollator collator) {
        if (collator == null) {
            throw new IllegalArgumentException("Collator can not be null");
        }
        this.collator_ = collator;
        this.ceMask_ = StringSearch.getMask(this.collator_.getStrength());
        ULocale collLocale = collator.getLocale(ULocale.VALID_LOCALE);
        this.search_.internalBreakIter_ = BreakIterator.getCharacterInstance(collLocale == null ? ULocale.ROOT : collLocale);
        this.search_.internalBreakIter_.setText((CharacterIterator)this.search_.text().clone());
        this.toShift_ = collator.isAlternateHandlingShifted();
        this.variableTop_ = collator.getVariableTop();
        this.textIter_ = new CollationElementIterator(this.pattern_.text_, collator);
        this.utilIter_ = new CollationElementIterator(this.pattern_.text_, collator);
        this.initialize();
    }

    private final String $$robo$$android_icu_text_StringSearch$getPattern() {
        return this.pattern_.text_;
    }

    private final void $$robo$$android_icu_text_StringSearch$setPattern(String pattern) {
        if (pattern == null || pattern.length() <= 0) {
            throw new IllegalArgumentException("Pattern to search for can not be null or of length 0");
        }
        this.pattern_.text_ = pattern;
        this.initialize();
    }

    private final boolean $$robo$$android_icu_text_StringSearch$isCanonical() {
        return this.search_.isCanonicalMatch_;
    }

    private final void $$robo$$android_icu_text_StringSearch$setCanonical(boolean allowCanonical) {
        this.search_.isCanonicalMatch_ = allowCanonical;
    }

    private final void $$robo$$android_icu_text_StringSearch$setTarget(CharacterIterator text) {
        super.setTarget(text);
        this.textIter_.setText(text);
    }

    private final int $$robo$$android_icu_text_StringSearch$getIndex() {
        int result = this.textIter_.getOffset();
        if (StringSearch.isOutOfBounds(this.search_.beginIndex(), this.search_.endIndex(), result)) {
            return -1;
        }
        return result;
    }

    private final void $$robo$$android_icu_text_StringSearch$setIndex(int position) {
        super.setIndex(position);
        this.textIter_.setOffset(position);
    }

    private final void $$robo$$android_icu_text_StringSearch$reset() {
        int varTop;
        boolean shift;
        boolean sameCollAttribute = true;
        int newStrength = this.collator_.getStrength();
        if (this.strength_ < 3 && newStrength >= 3 || this.strength_ >= 3 && newStrength < 3) {
            sameCollAttribute = false;
        }
        this.strength_ = this.collator_.getStrength();
        int ceMask = StringSearch.getMask(this.strength_);
        if (this.ceMask_ != ceMask) {
            this.ceMask_ = ceMask;
            sameCollAttribute = false;
        }
        if (this.toShift_ != (shift = this.collator_.isAlternateHandlingShifted())) {
            this.toShift_ = shift;
            sameCollAttribute = false;
        }
        if (this.variableTop_ != (varTop = this.collator_.getVariableTop())) {
            this.variableTop_ = varTop;
            sameCollAttribute = false;
        }
        if (!sameCollAttribute) {
            this.initialize();
        }
        this.textIter_.setText(this.search_.text());
        this.search_.setMatchedLength(0);
        this.search_.matchedIndex_ = -1;
        this.search_.isOverlap_ = false;
        this.search_.isCanonicalMatch_ = false;
        this.search_.elementComparisonType_ = SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON;
        this.search_.isForwardSearching_ = true;
        this.search_.reset_ = true;
    }

    private final int $$robo$$android_icu_text_StringSearch$handleNext(int position) {
        if (this.pattern_.CELength_ == 0) {
            this.search_.matchedIndex_ = this.search_.matchedIndex_ == -1 ? this.getIndex() : this.search_.matchedIndex_ + 1;
            this.search_.setMatchedLength(0);
            this.textIter_.setOffset(this.search_.matchedIndex_);
            if (this.search_.matchedIndex_ == this.search_.endIndex()) {
                this.search_.matchedIndex_ = -1;
            }
        } else {
            if (this.search_.matchedLength() <= 0) {
                this.search_.matchedIndex_ = position - 1;
            }
            this.textIter_.setOffset(position);
            if (this.search_.isCanonicalMatch_) {
                this.handleNextCanonical();
            } else {
                this.handleNextExact();
            }
            if (this.search_.matchedIndex_ == -1) {
                this.textIter_.setOffset(this.search_.endIndex());
            } else {
                this.textIter_.setOffset(this.search_.matchedIndex_);
            }
            return this.search_.matchedIndex_;
        }
        return -1;
    }

    private final int $$robo$$android_icu_text_StringSearch$handlePrevious(int position) {
        if (this.pattern_.CELength_ == 0) {
            int n = this.search_.matchedIndex_ = this.search_.matchedIndex_ == -1 ? this.getIndex() : this.search_.matchedIndex_;
            if (this.search_.matchedIndex_ == this.search_.beginIndex()) {
                this.setMatchNotFound();
            } else {
                --this.search_.matchedIndex_;
                this.textIter_.setOffset(this.search_.matchedIndex_);
                this.search_.setMatchedLength(0);
            }
        } else {
            this.textIter_.setOffset(position);
            if (this.search_.isCanonicalMatch_) {
                this.handlePreviousCanonical();
            } else {
                this.handlePreviousExact();
            }
        }
        return this.search_.matchedIndex_;
    }

    private static final int $$robo$$android_icu_text_StringSearch$getMask(int strength) {
        switch (strength) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    private final int $$robo$$android_icu_text_StringSearch$getCE(int sourcece) {
        sourcece &= this.ceMask_;
        if (this.toShift_) {
            if (this.variableTop_ > sourcece) {
                sourcece = this.strength_ >= 3 ? (sourcece &= 0xFFFF0000) : 0;
            }
        } else if (this.strength_ >= 3 && sourcece == 0) {
            sourcece = 65535;
        }
        return sourcece;
    }

    private static final int[] $$robo$$android_icu_text_StringSearch$addToIntArray(int[] destination, int offset, int destinationlength, int value, int increments) {
        int newlength = destinationlength;
        if (offset + 1 == newlength) {
            int[] temp = new int[newlength += increments];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])destination, (int)0, (int[])temp, (int)0, (int)offset);
            destination = temp;
        }
        destination[offset] = value;
        return destination;
    }

    private static final long[] $$robo$$android_icu_text_StringSearch$addToLongArray(long[] destination, int offset, int destinationlength, long value, int increments) {
        int newlength = destinationlength;
        if (offset + 1 == newlength) {
            long[] temp = new long[newlength += increments];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])destination, (int)0, (long[])temp, (int)0, (int)offset);
            destination = temp;
        }
        destination[offset] = value;
        return destination;
    }

    private final int $$robo$$android_icu_text_StringSearch$initializePatternCETable() {
        int ce;
        int[] cetable = new int[256];
        int cetablesize = cetable.length;
        int patternlength = this.pattern_.text_.length();
        CollationElementIterator coleiter = this.utilIter_;
        if (coleiter == null) {
            this.utilIter_ = coleiter = new CollationElementIterator(this.pattern_.text_, this.collator_);
        } else {
            coleiter.setText(this.pattern_.text_);
        }
        int offset = 0;
        int result = 0;
        while ((ce = coleiter.next()) != -1) {
            int newce = this.getCE(ce);
            if (newce != 0) {
                int[] temp = StringSearch.addToIntArray(cetable, offset, cetablesize, newce, patternlength - coleiter.getOffset() + 1);
                ++offset;
                cetable = temp;
            }
            result += coleiter.getMaxExpansion(ce) - 1;
        }
        cetable[offset] = 0;
        this.pattern_.CE_ = cetable;
        this.pattern_.CELength_ = offset;
        return result;
    }

    private final int $$robo$$android_icu_text_StringSearch$initializePatternPCETable() {
        long pce;
        long[] pcetable = new long[256];
        int pcetablesize = pcetable.length;
        int patternlength = this.pattern_.text_.length();
        CollationElementIterator coleiter = this.utilIter_;
        if (coleiter == null) {
            this.utilIter_ = coleiter = new CollationElementIterator(this.pattern_.text_, this.collator_);
        } else {
            coleiter.setText(this.pattern_.text_);
        }
        int offset = 0;
        int result = 0;
        CollationPCE iter = new CollationPCE(coleiter);
        while ((pce = iter.nextProcessed(null)) != -1L) {
            long[] temp = StringSearch.addToLongArray(pcetable, offset, pcetablesize, pce, patternlength - coleiter.getOffset() + 1);
            ++offset;
            pcetable = temp;
        }
        pcetable[offset] = 0L;
        this.pattern_.PCE_ = pcetable;
        this.pattern_.PCELength_ = offset;
        return result;
    }

    private final int $$robo$$android_icu_text_StringSearch$initializePattern() {
        this.pattern_.PCE_ = null;
        return this.initializePatternCETable();
    }

    private final void $$robo$$android_icu_text_StringSearch$initialize() {
        this.initializePattern();
    }

    @Deprecated
    private final void $$robo$$android_icu_text_StringSearch$setMatchNotFound() {
        super.setMatchNotFound();
        if (this.search_.isForwardSearching_) {
            this.textIter_.setOffset(this.search_.text().getEndIndex());
        } else {
            this.textIter_.setOffset(0);
        }
    }

    private static final boolean $$robo$$android_icu_text_StringSearch$isOutOfBounds(int textstart, int textlimit, int offset) {
        return offset < textstart || offset > textlimit;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$checkIdentical(int start, int end) {
        String patternstr;
        if (this.strength_ != 15) {
            return true;
        }
        String textstr = StringSearch.getString(this.targetText, start, end - start);
        if (Normalizer.quickCheck(textstr, Normalizer.NFD, 0) == Normalizer.NO) {
            textstr = Normalizer.decompose(textstr, false);
        }
        if (Normalizer.quickCheck(patternstr = this.pattern_.text_, Normalizer.NFD, 0) == Normalizer.NO) {
            patternstr = Normalizer.decompose(patternstr, false);
        }
        return textstr.equals(patternstr);
    }

    private final boolean $$robo$$android_icu_text_StringSearch$initTextProcessedIter() {
        if (this.textProcessedIter_ == null) {
            this.textProcessedIter_ = new CollationPCE(this.textIter_);
        } else {
            this.textProcessedIter_.init(this.textIter_);
        }
        return true;
    }

    private final int $$robo$$android_icu_text_StringSearch$nextBoundaryAfter(int startIndex) {
        BreakIterator breakiterator = this.search_.breakIter();
        if (breakiterator == null) {
            breakiterator = this.search_.internalBreakIter_;
        }
        if (breakiterator != null) {
            return breakiterator.following(startIndex);
        }
        return startIndex;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$isBreakBoundary(int index) {
        BreakIterator breakiterator = this.search_.breakIter();
        if (breakiterator == null) {
            breakiterator = this.search_.internalBreakIter_;
        }
        return breakiterator != null && breakiterator.isBoundary(index);
    }

    private static final int $$robo$$android_icu_text_StringSearch$compareCE64s(long targCE, long patCE, SearchIterator.ElementComparisonType compareType) {
        if (targCE == patCE) {
            return -1;
        }
        if (compareType == SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON) {
            return 0;
        }
        long targCEshifted = targCE >>> 32;
        long mask = 0xFFFF0000L;
        int targLev1 = (int)(targCEshifted & mask);
        long patCEshifted = patCE >>> 32;
        int patLev1 = (int)(patCEshifted & mask);
        if (targLev1 != patLev1) {
            if (targLev1 == 0) {
                return 1;
            }
            if (patLev1 == 0 && compareType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD) {
                return 2;
            }
            return 0;
        }
        mask = 65535L;
        int targLev2 = (int)(targCEshifted & mask);
        int patLev2 = (int)(patCEshifted & mask);
        if (targLev2 != patLev2) {
            if (targLev2 == 0) {
                return 1;
            }
            if (patLev2 == 0 && compareType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD) {
                return 2;
            }
            return patLev2 == CE_LEVEL2_BASE || compareType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD && targLev2 == CE_LEVEL2_BASE ? -1 : 0;
        }
        mask = 0xFFFF0000L;
        int targLev3 = (int)(targCE & mask);
        int patLev3 = (int)(patCE & mask);
        if (targLev3 != patLev3) {
            return patLev3 == CE_LEVEL3_BASE || compareType == SearchIterator.ElementComparisonType.ANY_BASE_WEIGHT_IS_WILDCARD && targLev3 == CE_LEVEL3_BASE ? -1 : 0;
        }
        return -1;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$search(int startIdx, Match m) {
        boolean found;
        if (this.pattern_.CELength_ == 0 || startIdx < this.search_.beginIndex() || startIdx > this.search_.endIndex()) {
            throw new IllegalArgumentException("search(" + startIdx + ", m) - expected position to be between " + this.search_.beginIndex() + " and " + this.search_.endIndex());
        }
        if (this.pattern_.PCE_ == null) {
            this.initializePatternPCETable();
        }
        this.textIter_.setOffset(startIdx);
        CEBuffer ceb = new CEBuffer(this);
        int targetIx = 0;
        CEI targetCEI = null;
        int mStart = -1;
        int mLimit = -1;
        targetIx = 0;
        while (true) {
            found = true;
            int targetIxOffset = 0;
            long patCE = 0L;
            CEI firstCEI = ceb.get(targetIx);
            if (firstCEI == null) {
                throw new ICUException("CEBuffer.get(" + targetIx + ") returned null.");
            }
            for (int patIx = 0; patIx < this.pattern_.PCELength_; ++patIx) {
                patCE = this.pattern_.PCE_[patIx];
                targetCEI = ceb.get(targetIx + patIx + targetIxOffset);
                int ceMatch = StringSearch.compareCE64s(targetCEI.ce_, patCE, this.search_.elementComparisonType_);
                if (ceMatch == 0) {
                    found = false;
                    break;
                }
                if (ceMatch <= 0) continue;
                if (ceMatch == 1) {
                    --patIx;
                    ++targetIxOffset;
                    continue;
                }
                --targetIxOffset;
            }
            targetIxOffset += this.pattern_.PCELength_;
            if (found || targetCEI != null && targetCEI.ce_ == -1L) {
                int secondIx;
                int maxLimit;
                if (!found) break;
                CEI lastCEI = ceb.get(targetIx + targetIxOffset - 1);
                mStart = firstCEI.lowIndex_;
                int minLimit = lastCEI.lowIndex_;
                CEI nextCEI = null;
                if (this.search_.elementComparisonType_ == SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON) {
                    nextCEI = ceb.get(targetIx + targetIxOffset);
                    maxLimit = nextCEI.lowIndex_;
                    if (nextCEI.lowIndex_ == nextCEI.highIndex_ && nextCEI.ce_ != -1L) {
                        found = false;
                    }
                } else {
                    while (true) {
                        nextCEI = ceb.get(targetIx + targetIxOffset);
                        maxLimit = nextCEI.lowIndex_;
                        if (nextCEI.ce_ == -1L) break;
                        if ((nextCEI.ce_ >>> 32 & 0xFFFF0000L) == 0L) {
                            int ceMatch = StringSearch.compareCE64s(nextCEI.ce_, patCE, this.search_.elementComparisonType_);
                            if (ceMatch == 0 || ceMatch == 2) {
                                found = false;
                                break;
                            }
                        } else {
                            if (nextCEI.lowIndex_ != nextCEI.highIndex_) break;
                            found = false;
                            break;
                        }
                        ++targetIxOffset;
                    }
                }
                if (!this.isBreakBoundary(mStart)) {
                    found = false;
                }
                if (mStart == (secondIx = firstCEI.highIndex_)) {
                    found = false;
                }
                boolean allowMidclusterMatch = this.breakIterator == null && nextCEI != null && (nextCEI.ce_ >>> 32 & 0xFFFF0000L) != 0L && maxLimit >= lastCEI.highIndex_ && nextCEI.highIndex_ > maxLimit && (this.nfd_.hasBoundaryBefore(StringSearch.codePointAt(this.targetText, maxLimit)) || this.nfd_.hasBoundaryAfter(StringSearch.codePointBefore(this.targetText, maxLimit)));
                mLimit = maxLimit;
                if (minLimit < maxLimit) {
                    if (minLimit == lastCEI.highIndex_ && this.isBreakBoundary(minLimit)) {
                        mLimit = minLimit;
                    } else {
                        int nba = this.nextBoundaryAfter(minLimit);
                        if (!(nba < lastCEI.highIndex_ || allowMidclusterMatch && nba >= maxLimit)) {
                            mLimit = nba;
                        }
                    }
                }
                if (!allowMidclusterMatch) {
                    if (mLimit > maxLimit) {
                        found = false;
                    }
                    if (!this.isBreakBoundary(mLimit)) {
                        found = false;
                    }
                }
                if (!this.checkIdentical(mStart, mLimit)) {
                    found = false;
                }
                if (found) break;
            }
            ++targetIx;
        }
        if (!found) {
            mLimit = -1;
            mStart = -1;
        }
        if (m != null) {
            m.start_ = mStart;
            m.limit_ = mLimit;
        }
        return found;
    }

    private static final int $$robo$$android_icu_text_StringSearch$codePointAt(CharacterIterator iter, int index) {
        char nextUnit;
        int codeUnit;
        int currentIterIndex = iter.getIndex();
        int cp = codeUnit = iter.setIndex(index);
        if (Character.isHighSurrogate((char)codeUnit) && Character.isLowSurrogate(nextUnit = iter.next())) {
            cp = Character.toCodePoint((char)codeUnit, nextUnit);
        }
        iter.setIndex(currentIterIndex);
        return cp;
    }

    private static final int $$robo$$android_icu_text_StringSearch$codePointBefore(CharacterIterator iter, int index) {
        char prevUnit;
        int codeUnit;
        int currentIterIndex = iter.getIndex();
        iter.setIndex(index);
        int cp = codeUnit = iter.previous();
        if (Character.isLowSurrogate((char)codeUnit) && Character.isHighSurrogate(prevUnit = iter.previous())) {
            cp = Character.toCodePoint(prevUnit, (char)codeUnit);
        }
        iter.setIndex(currentIterIndex);
        return cp;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$searchBackwards(int startIdx, Match m) {
        boolean found;
        if (this.pattern_.CELength_ == 0 || startIdx < this.search_.beginIndex() || startIdx > this.search_.endIndex()) {
            throw new IllegalArgumentException("searchBackwards(" + startIdx + ", m) - expected position to be between " + this.search_.beginIndex() + " and " + this.search_.endIndex());
        }
        if (this.pattern_.PCE_ == null) {
            this.initializePatternPCETable();
        }
        CEBuffer ceb = new CEBuffer(this);
        int targetIx = 0;
        if (startIdx < this.search_.endIndex()) {
            BreakIterator bi = this.search_.internalBreakIter_;
            int next = bi.following(startIdx);
            this.textIter_.setOffset(next);
            targetIx = 0;
            while (ceb.getPrevious((int)targetIx).lowIndex_ >= startIdx) {
                ++targetIx;
            }
        } else {
            this.textIter_.setOffset(startIdx);
        }
        CEI targetCEI = null;
        int limitIx = targetIx;
        int mStart = -1;
        int mLimit = -1;
        targetIx = limitIx;
        while (true) {
            found = true;
            CEI lastCEI = ceb.getPrevious(targetIx);
            if (lastCEI == null) {
                throw new ICUException("CEBuffer.getPrevious(" + targetIx + ") returned null.");
            }
            int targetIxOffset = 0;
            for (int patIx = this.pattern_.PCELength_ - 1; patIx >= 0; --patIx) {
                long patCE = this.pattern_.PCE_[patIx];
                targetCEI = ceb.getPrevious(targetIx + this.pattern_.PCELength_ - 1 - patIx + targetIxOffset);
                int ceMatch = StringSearch.compareCE64s(targetCEI.ce_, patCE, this.search_.elementComparisonType_);
                if (ceMatch == 0) {
                    found = false;
                    break;
                }
                if (ceMatch <= 0) continue;
                if (ceMatch == 1) {
                    ++patIx;
                    ++targetIxOffset;
                    continue;
                }
                --targetIxOffset;
            }
            if (found || targetCEI != null && targetCEI.ce_ == -1L) {
                int maxLimit;
                if (!found) break;
                CEI firstCEI = ceb.getPrevious(targetIx + this.pattern_.PCELength_ - 1 + targetIxOffset);
                mStart = firstCEI.lowIndex_;
                if (!this.isBreakBoundary(mStart)) {
                    found = false;
                }
                if (mStart == firstCEI.highIndex_) {
                    found = false;
                }
                int minLimit = lastCEI.lowIndex_;
                if (targetIx > 0) {
                    int nba;
                    boolean allowMidclusterMatch;
                    CEI nextCEI = ceb.getPrevious(targetIx - 1);
                    if (nextCEI.lowIndex_ == nextCEI.highIndex_ && nextCEI.ce_ != -1L) {
                        found = false;
                    }
                    mLimit = maxLimit = nextCEI.lowIndex_;
                    boolean bl = allowMidclusterMatch = this.breakIterator == null && nextCEI != null && (nextCEI.ce_ >>> 32 & 0xFFFF0000L) != 0L && maxLimit >= lastCEI.highIndex_ && nextCEI.highIndex_ > maxLimit && (this.nfd_.hasBoundaryBefore(StringSearch.codePointAt(this.targetText, maxLimit)) || this.nfd_.hasBoundaryAfter(StringSearch.codePointBefore(this.targetText, maxLimit)));
                    if (!(minLimit >= maxLimit || (nba = this.nextBoundaryAfter(minLimit)) < lastCEI.highIndex_ || allowMidclusterMatch && nba >= maxLimit)) {
                        mLimit = nba;
                    }
                    if (!allowMidclusterMatch) {
                        if (mLimit > maxLimit) {
                            found = false;
                        }
                        if (!this.isBreakBoundary(mLimit)) {
                            found = false;
                        }
                    }
                } else {
                    int nba = this.nextBoundaryAfter(minLimit);
                    maxLimit = nba > 0 && startIdx > nba ? nba : startIdx;
                    mLimit = maxLimit;
                }
                if (!this.checkIdentical(mStart, mLimit)) {
                    found = false;
                }
                if (found) break;
            }
            ++targetIx;
        }
        if (!found) {
            mLimit = -1;
            mStart = -1;
        }
        if (m != null) {
            m.start_ = mStart;
            m.limit_ = mLimit;
        }
        return found;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handleNextExact() {
        return this.handleNextCommonImpl();
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handleNextCanonical() {
        return this.handleNextCommonImpl();
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handleNextCommonImpl() {
        Match match;
        int textOffset = this.textIter_.getOffset();
        if (this.search(textOffset, match = new Match())) {
            this.search_.matchedIndex_ = match.start_;
            this.search_.setMatchedLength(match.limit_ - match.start_);
            return true;
        }
        this.setMatchNotFound();
        return false;
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handlePreviousExact() {
        return this.handlePreviousCommonImpl();
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handlePreviousCanonical() {
        return this.handlePreviousCommonImpl();
    }

    private final boolean $$robo$$android_icu_text_StringSearch$handlePreviousCommonImpl() {
        int textOffset;
        if (this.search_.isOverlap_) {
            if (this.search_.matchedIndex_ != -1) {
                textOffset = this.search_.matchedIndex_ + this.search_.matchedLength() - 1;
            } else {
                long pce;
                this.initializePatternPCETable();
                if (!this.initTextProcessedIter()) {
                    this.setMatchNotFound();
                    return false;
                }
                for (int nPCEs = 0; nPCEs < this.pattern_.PCELength_ - 1 && (pce = this.textProcessedIter_.nextProcessed(null)) != -1L; ++nPCEs) {
                }
                textOffset = this.textIter_.getOffset();
            }
        } else {
            textOffset = this.textIter_.getOffset();
        }
        Match match = new Match();
        if (this.searchBackwards(textOffset, match)) {
            this.search_.matchedIndex_ = match.start_;
            this.search_.setMatchedLength(match.limit_ - match.start_);
            return true;
        }
        this.setMatchNotFound();
        return false;
    }

    private static final String $$robo$$android_icu_text_StringSearch$getString(CharacterIterator text, int start, int length) {
        StringBuilder result = new StringBuilder(length);
        int offset = text.getIndex();
        text.setIndex(start);
        for (int i = 0; i < length; ++i) {
            result.append(text.current());
            text.next();
        }
        text.setIndex(offset);
        return result.toString();
    }

    static void __staticInitializer__() {
        CE_LEVEL2_BASE = 5;
        CE_LEVEL3_BASE = 327680;
    }

    private void __constructor__(String string2, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator, BreakIterator breakIterator) {
        this.$$robo$$android_icu_text_StringSearch$__constructor__(string2, characterIterator, ruleBasedCollator, breakIterator);
    }

    public StringSearch(String string2, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator, BreakIterator breakIterator) {
        super(characterIterator, breakIterator);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch$__constructor__(java.lang.String java.text.CharacterIterator android.icu.text.RuleBasedCollator android.icu.text.BreakIterator ), 0, this, string2, characterIterator, ruleBasedCollator, breakIterator);
    }

    private void __constructor__(String string2, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.$$robo$$android_icu_text_StringSearch$__constructor__(string2, characterIterator, ruleBasedCollator);
    }

    public StringSearch(String string2, CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this(string2, characterIterator, ruleBasedCollator, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch$__constructor__(java.lang.String java.text.CharacterIterator android.icu.text.RuleBasedCollator ), 0, this, string2, characterIterator, ruleBasedCollator);
    }

    private void __constructor__(String string2, CharacterIterator characterIterator, Locale locale) {
        this.$$robo$$android_icu_text_StringSearch$__constructor__(string2, characterIterator, locale);
    }

    public StringSearch(String string2, CharacterIterator characterIterator, Locale locale) {
        this(string2, characterIterator, ULocale.forLocale(locale));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch$__constructor__(java.lang.String java.text.CharacterIterator java.util.Locale ), 0, this, string2, characterIterator, locale);
    }

    private void __constructor__(String string2, CharacterIterator characterIterator, ULocale uLocale) {
        this.$$robo$$android_icu_text_StringSearch$__constructor__(string2, characterIterator, uLocale);
    }

    public StringSearch(String string2, CharacterIterator characterIterator, ULocale uLocale) {
        this(string2, characterIterator, (RuleBasedCollator)Collator.getInstance(uLocale), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch$__constructor__(java.lang.String java.text.CharacterIterator android.icu.util.ULocale ), 0, this, string2, characterIterator, uLocale);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_icu_text_StringSearch$__constructor__(string2, string3);
    }

    public StringSearch(String string2, String string3) {
        this(string2, new StringCharacterIterator(string3), (RuleBasedCollator)Collator.getInstance(), null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public RuleBasedCollator getCollator() {
        return InvokeDynamicSupport.bootstrap("getCollator", $$robo$$android_icu_text_StringSearch$getCollator(), 0, this);
    }

    public void setCollator(RuleBasedCollator ruleBasedCollator) {
        InvokeDynamicSupport.bootstrap("setCollator", $$robo$$android_icu_text_StringSearch$setCollator(android.icu.text.RuleBasedCollator ), 0, this, ruleBasedCollator);
    }

    public String getPattern() {
        return InvokeDynamicSupport.bootstrap("getPattern", $$robo$$android_icu_text_StringSearch$getPattern(), 0, this);
    }

    public void setPattern(String string2) {
        InvokeDynamicSupport.bootstrap("setPattern", $$robo$$android_icu_text_StringSearch$setPattern(java.lang.String ), 0, this, string2);
    }

    public boolean isCanonical() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCanonical", $$robo$$android_icu_text_StringSearch$isCanonical(), 0, this);
    }

    public void setCanonical(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCanonical", $$robo$$android_icu_text_StringSearch$setCanonical(boolean ), 0, this, bl);
    }

    @Override
    public void setTarget(CharacterIterator characterIterator) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_icu_text_StringSearch$setTarget(java.text.CharacterIterator ), 0, this, characterIterator);
    }

    @Override
    public int getIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$android_icu_text_StringSearch$getIndex(), 0, this);
    }

    @Override
    public void setIndex(int n) {
        InvokeDynamicSupport.bootstrap("setIndex", $$robo$$android_icu_text_StringSearch$setIndex(int ), 0, this, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_StringSearch$reset(), 0, this);
    }

    @Override
    protected int handleNext(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleNext", $$robo$$android_icu_text_StringSearch$handleNext(int ), 0, this, n);
    }

    @Override
    protected int handlePrevious(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handlePrevious", $$robo$$android_icu_text_StringSearch$handlePrevious(int ), 0, this, n);
    }

    private static int getMask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMask", $$robo$$android_icu_text_StringSearch$getMask(int ), 0, (int)n);
    }

    private int getCE(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCE", $$robo$$android_icu_text_StringSearch$getCE(int ), 0, this, n);
    }

    private static int[] addToIntArray(int[] nArray, int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("addToIntArray", $$robo$$android_icu_text_StringSearch$addToIntArray(int[] int int int int ), 0, (int[])nArray, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private static long[] addToLongArray(long[] lArray, int n, int n2, long l, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("addToLongArray", $$robo$$android_icu_text_StringSearch$addToLongArray(long[] int int long int ), 0, (long[])lArray, (int)n, (int)n2, (long)l, (int)n3);
    }

    private int initializePatternCETable() {
        return (int)InvokeDynamicSupport.bootstrap("initializePatternCETable", $$robo$$android_icu_text_StringSearch$initializePatternCETable(), 0, this);
    }

    private int initializePatternPCETable() {
        return (int)InvokeDynamicSupport.bootstrap("initializePatternPCETable", $$robo$$android_icu_text_StringSearch$initializePatternPCETable(), 0, this);
    }

    private int initializePattern() {
        return (int)InvokeDynamicSupport.bootstrap("initializePattern", $$robo$$android_icu_text_StringSearch$initializePattern(), 0, this);
    }

    private void initialize() {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_text_StringSearch$initialize(), 0, this);
    }

    @Override
    @Deprecated
    protected void setMatchNotFound() {
        InvokeDynamicSupport.bootstrap("setMatchNotFound", $$robo$$android_icu_text_StringSearch$setMatchNotFound(), 0, this);
    }

    private static boolean isOutOfBounds(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isOutOfBounds", $$robo$$android_icu_text_StringSearch$isOutOfBounds(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    private boolean checkIdentical(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkIdentical", $$robo$$android_icu_text_StringSearch$checkIdentical(int int ), 0, this, n, n2);
    }

    private boolean initTextProcessedIter() {
        return (boolean)InvokeDynamicSupport.bootstrap("initTextProcessedIter", $$robo$$android_icu_text_StringSearch$initTextProcessedIter(), 0, this);
    }

    private int nextBoundaryAfter(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextBoundaryAfter", $$robo$$android_icu_text_StringSearch$nextBoundaryAfter(int ), 0, this, n);
    }

    private boolean isBreakBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBreakBoundary", $$robo$$android_icu_text_StringSearch$isBreakBoundary(int ), 0, this, n);
    }

    private static int compareCE64s(long l, long l2, SearchIterator.ElementComparisonType elementComparisonType) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareCE64s", $$robo$$android_icu_text_StringSearch$compareCE64s(long long android.icu.text.SearchIterator$ElementComparisonType ), 0, (long)l, (long)l2, (SearchIterator.ElementComparisonType)elementComparisonType);
    }

    private boolean search(int n, Match match) {
        return (boolean)InvokeDynamicSupport.bootstrap("search", $$robo$$android_icu_text_StringSearch$search(int android.icu.text.StringSearch$Match ), 0, this, n, match);
    }

    private static int codePointAt(CharacterIterator characterIterator, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointAt", $$robo$$android_icu_text_StringSearch$codePointAt(java.text.CharacterIterator int ), 0, (CharacterIterator)characterIterator, (int)n);
    }

    private static int codePointBefore(CharacterIterator characterIterator, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("codePointBefore", $$robo$$android_icu_text_StringSearch$codePointBefore(java.text.CharacterIterator int ), 0, (CharacterIterator)characterIterator, (int)n);
    }

    private boolean searchBackwards(int n, Match match) {
        return (boolean)InvokeDynamicSupport.bootstrap("searchBackwards", $$robo$$android_icu_text_StringSearch$searchBackwards(int android.icu.text.StringSearch$Match ), 0, this, n, match);
    }

    private boolean handleNextExact() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleNextExact", $$robo$$android_icu_text_StringSearch$handleNextExact(), 0, this);
    }

    private boolean handleNextCanonical() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleNextCanonical", $$robo$$android_icu_text_StringSearch$handleNextCanonical(), 0, this);
    }

    private boolean handleNextCommonImpl() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleNextCommonImpl", $$robo$$android_icu_text_StringSearch$handleNextCommonImpl(), 0, this);
    }

    private boolean handlePreviousExact() {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePreviousExact", $$robo$$android_icu_text_StringSearch$handlePreviousExact(), 0, this);
    }

    private boolean handlePreviousCanonical() {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePreviousCanonical", $$robo$$android_icu_text_StringSearch$handlePreviousCanonical(), 0, this);
    }

    private boolean handlePreviousCommonImpl() {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePreviousCommonImpl", $$robo$$android_icu_text_StringSearch$handlePreviousCommonImpl(), 0, this);
    }

    private static String getString(CharacterIterator characterIterator, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getString", $$robo$$android_icu_text_StringSearch$getString(java.text.CharacterIterator int int ), 0, (CharacterIterator)characterIterator, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(StringSearch.class);
    }

    public /* synthetic */ StringSearch() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringSearch)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CEBuffer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int CEBUFFER_EXTRA = 32;
        static int MAX_TARGET_IGNORABLES_PER_PAT_JAMO_L = 8;
        static int MAX_TARGET_IGNORABLES_PER_PAT_OTHER = 3;
        CEI[] buf_;
        int bufSize_;
        int firstIx_;
        int limitIx_;
        StringSearch strSearch_;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_text_StringSearch_CEBuffer$__constructor__(StringSearch ss) {
            String patText;
            this.strSearch_ = ss;
            this.bufSize_ = ((StringSearch)ss).pattern_.PCELength_ + 32;
            if (ss.search_.elementComparisonType_ != SearchIterator.ElementComparisonType.STANDARD_ELEMENT_COMPARISON && (patText = ((StringSearch)ss).pattern_.text_) != null) {
                for (int i = 0; i < patText.length(); ++i) {
                    char c = patText.charAt(i);
                    if (CEBuffer.MIGHT_BE_JAMO_L(c)) {
                        this.bufSize_ += 8;
                        continue;
                    }
                    this.bufSize_ += 3;
                }
            }
            this.firstIx_ = 0;
            this.limitIx_ = 0;
            if (!ss.initTextProcessedIter()) {
                return;
            }
            this.buf_ = new CEI[this.bufSize_];
        }

        private final CEI $$robo$$android_icu_text_StringSearch_CEBuffer$get(int index) {
            int i = index % this.bufSize_;
            if (index >= this.firstIx_ && index < this.limitIx_) {
                return this.buf_[i];
            }
            if (index != this.limitIx_) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            ++this.limitIx_;
            if (this.limitIx_ - this.firstIx_ >= this.bufSize_) {
                ++this.firstIx_;
            }
            CollationPCE.Range range = new CollationPCE.Range();
            if (this.buf_[i] == null) {
                this.buf_[i] = new CEI();
            }
            this.buf_[i].ce_ = this.strSearch_.textProcessedIter_.nextProcessed(range);
            this.buf_[i].lowIndex_ = range.ixLow_;
            this.buf_[i].highIndex_ = range.ixHigh_;
            return this.buf_[i];
        }

        private final CEI $$robo$$android_icu_text_StringSearch_CEBuffer$getPrevious(int index) {
            int i = index % this.bufSize_;
            if (index >= this.firstIx_ && index < this.limitIx_) {
                return this.buf_[i];
            }
            if (index != this.limitIx_) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            ++this.limitIx_;
            if (this.limitIx_ - this.firstIx_ >= this.bufSize_) {
                ++this.firstIx_;
            }
            CollationPCE.Range range = new CollationPCE.Range();
            if (this.buf_[i] == null) {
                this.buf_[i] = new CEI();
            }
            this.buf_[i].ce_ = this.strSearch_.textProcessedIter_.previousProcessed(range);
            this.buf_[i].lowIndex_ = range.ixLow_;
            this.buf_[i].highIndex_ = range.ixHigh_;
            return this.buf_[i];
        }

        private static final boolean $$robo$$android_icu_text_StringSearch_CEBuffer$MIGHT_BE_JAMO_L(char c) {
            return c >= '\u1100' && c <= '\u115e' || c >= '\u3131' && c <= '\u314e' || c >= '\u3165' && c <= '\u3186';
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !StringSearch.class.desiredAssertionStatus();
        }

        private void __constructor__(StringSearch stringSearch) {
            this.$$robo$$android_icu_text_StringSearch_CEBuffer$__constructor__(stringSearch);
        }

        CEBuffer(StringSearch stringSearch) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CEBuffer$__constructor__(android.icu.text.StringSearch ), 0, this, stringSearch);
        }

        CEI get(int n) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_StringSearch_CEBuffer$get(int ), 0, this, n);
        }

        CEI getPrevious(int n) {
            return InvokeDynamicSupport.bootstrap("getPrevious", $$robo$$android_icu_text_StringSearch_CEBuffer$getPrevious(int ), 0, this, n);
        }

        static boolean MIGHT_BE_JAMO_L(char c) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("MIGHT_BE_JAMO_L", $$robo$$android_icu_text_StringSearch_CEBuffer$MIGHT_BE_JAMO_L(char ), 0, (char)c);
        }

        static {
            RobolectricInternals.classInitializing(CEBuffer.class);
        }

        public /* synthetic */ CEBuffer() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CEBuffer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CEI
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long ce_;
        int lowIndex_;
        int highIndex_;

        private void $$robo$$android_icu_text_StringSearch_CEI$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_text_StringSearch_CEI$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_StringSearch_CEI$__constructor__();
        }

        private CEI() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CEI$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_StringSearch_CEI$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CEI)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CollationPCE
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static long PROCESSED_NULLORDER = -1L;
        private static int DEFAULT_BUFFER_SIZE = 16;
        private static int BUFFER_GROW = 8;
        private static int PRIMARYORDERMASK = -65536;
        private static int CONTINUATION_MARKER = 192;
        private PCEBuffer pceBuffer_;
        private CollationElementIterator cei_;
        private int strength_;
        private boolean toShift_;
        private boolean isShifted_;
        private int variableTop_;

        private void $$robo$$android_icu_text_StringSearch_CollationPCE$__constructor__(CollationElementIterator iter) {
            this.pceBuffer_ = new PCEBuffer();
            this.init(iter);
        }

        private final void $$robo$$android_icu_text_StringSearch_CollationPCE$init(CollationElementIterator iter) {
            this.cei_ = iter;
            this.init(iter.getRuleBasedCollator());
        }

        private final void $$robo$$android_icu_text_StringSearch_CollationPCE$init(RuleBasedCollator coll) {
            this.strength_ = coll.getStrength();
            this.toShift_ = coll.isAlternateHandlingShifted();
            this.isShifted_ = false;
            this.variableTop_ = coll.getVariableTop();
        }

        private final long $$robo$$android_icu_text_StringSearch_CollationPCE$processCE(int ce) {
            long primary = 0L;
            long secondary = 0L;
            long tertiary = 0L;
            long quaternary = 0L;
            switch (this.strength_) {
                default: {
                    tertiary = CollationElementIterator.tertiaryOrder(ce);
                }
                case 1: {
                    secondary = CollationElementIterator.secondaryOrder(ce);
                }
                case 0: 
            }
            primary = CollationElementIterator.primaryOrder(ce);
            if (this.toShift_ && this.variableTop_ > ce && primary != 0L || this.isShifted_ && primary == 0L) {
                if (primary == 0L) {
                    return 0L;
                }
                if (this.strength_ >= 3) {
                    quaternary = primary;
                }
                tertiary = 0L;
                secondary = 0L;
                primary = 0L;
                this.isShifted_ = true;
            } else {
                if (this.strength_ >= 3) {
                    quaternary = 65535L;
                }
                this.isShifted_ = false;
            }
            return primary << 48 | secondary << 32 | tertiary << 16 | quaternary;
        }

        private final long $$robo$$android_icu_text_StringSearch_CollationPCE$nextProcessed(Range range) {
            int ce;
            long result = 0L;
            int low = 0;
            int high = 0;
            this.pceBuffer_.reset();
            do {
                low = this.cei_.getOffset();
                ce = this.cei_.next();
                high = this.cei_.getOffset();
                if (ce != -1) continue;
                result = -1L;
                break;
            } while ((result = this.processCE(ce)) == 0L);
            if (range != null) {
                range.ixLow_ = low;
                range.ixHigh_ = high;
            }
            return result;
        }

        private final long $$robo$$android_icu_text_StringSearch_CollationPCE$previousProcessed(Range range) {
            long result = 0L;
            int low = 0;
            int high = 0;
            while (this.pceBuffer_.empty()) {
                int ce;
                RCEBuffer rceb = new RCEBuffer();
                boolean finish = false;
                do {
                    high = this.cei_.getOffset();
                    ce = this.cei_.previous();
                    low = this.cei_.getOffset();
                    if (ce == -1) {
                        if (!rceb.empty()) break;
                        finish = true;
                        break;
                    }
                    rceb.put(ce, low, high);
                } while ((ce & 0xFFFF0000) == 0 || CollationPCE.isContinuation(ce));
                if (finish) break;
                while (!rceb.empty()) {
                    RCEI rcei = rceb.get();
                    result = this.processCE(rcei.ce_);
                    if (result == 0L) continue;
                    this.pceBuffer_.put(result, rcei.low_, rcei.high_);
                }
            }
            if (this.pceBuffer_.empty()) {
                if (range != null) {
                    range.ixLow_ = -1;
                    range.ixHigh_ = -1;
                }
                return -1L;
            }
            PCEI pcei = this.pceBuffer_.get();
            if (range != null) {
                range.ixLow_ = pcei.low_;
                range.ixHigh_ = pcei.high_;
            }
            return pcei.ce_;
        }

        private static final boolean $$robo$$android_icu_text_StringSearch_CollationPCE$isContinuation(int ce) {
            return (ce & 0xC0) == 192;
        }

        private void __constructor__(CollationElementIterator collationElementIterator) {
            this.$$robo$$android_icu_text_StringSearch_CollationPCE$__constructor__(collationElementIterator);
        }

        public CollationPCE(CollationElementIterator collationElementIterator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE$__constructor__(android.icu.text.CollationElementIterator ), 0, this, collationElementIterator);
        }

        public void init(CollationElementIterator collationElementIterator) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_text_StringSearch_CollationPCE$init(android.icu.text.CollationElementIterator ), 0, this, collationElementIterator);
        }

        private void init(RuleBasedCollator ruleBasedCollator) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_icu_text_StringSearch_CollationPCE$init(android.icu.text.RuleBasedCollator ), 0, this, ruleBasedCollator);
        }

        private long processCE(int n) {
            return (long)InvokeDynamicSupport.bootstrap("processCE", $$robo$$android_icu_text_StringSearch_CollationPCE$processCE(int ), 0, this, n);
        }

        public long nextProcessed(Range range) {
            return (long)InvokeDynamicSupport.bootstrap("nextProcessed", $$robo$$android_icu_text_StringSearch_CollationPCE$nextProcessed(android.icu.text.StringSearch$CollationPCE$Range ), 0, this, range);
        }

        public long previousProcessed(Range range) {
            return (long)InvokeDynamicSupport.bootstrap("previousProcessed", $$robo$$android_icu_text_StringSearch_CollationPCE$previousProcessed(android.icu.text.StringSearch$CollationPCE$Range ), 0, this, range);
        }

        private static boolean isContinuation(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isContinuation", $$robo$$android_icu_text_StringSearch_CollationPCE$isContinuation(int ), 0, (int)n);
        }

        public /* synthetic */ CollationPCE() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CollationPCE)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class RCEBuffer
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private RCEI[] buffer_;
            private int bufferIndex_;

            private void $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$__constructor__() {
                this.buffer_ = new RCEI[16];
                this.bufferIndex_ = 0;
            }

            private final boolean $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$empty() {
                return this.bufferIndex_ <= 0;
            }

            private final void $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$put(int ce, int ixLow, int ixHigh) {
                if (this.bufferIndex_ >= this.buffer_.length) {
                    RCEI[] newBuffer = new RCEI[this.buffer_.length + 8];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.buffer_, (int)0, (Object)newBuffer, (int)0, (int)this.buffer_.length);
                    this.buffer_ = newBuffer;
                }
                this.buffer_[this.bufferIndex_] = new RCEI();
                this.buffer_[this.bufferIndex_].ce_ = ce;
                this.buffer_[this.bufferIndex_].low_ = ixLow;
                this.buffer_[this.bufferIndex_].high_ = ixHigh;
                ++this.bufferIndex_;
            }

            private final RCEI $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$get() {
                if (this.bufferIndex_ > 0) {
                    return this.buffer_[--this.bufferIndex_];
                }
                return null;
            }

            private /* synthetic */ void $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$__constructor__();
            }

            private RCEBuffer() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$__constructor__(), 0, this);
            }

            boolean empty() {
                return (boolean)InvokeDynamicSupport.bootstrap("empty", $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$empty(), 0, this);
            }

            void put(int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$put(int int int ), 0, this, n, n2, n3);
            }

            RCEI get() {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$get(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_RCEBuffer$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RCEBuffer)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class RCEI
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int ce_;
            int low_;
            int high_;

            private void $$robo$$android_icu_text_StringSearch_CollationPCE_RCEI$__constructor__() {
            }

            private /* synthetic */ void $$robo$$android_icu_text_StringSearch_CollationPCE_RCEI$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_RCEI$__constructor__();
            }

            private RCEI() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE_RCEI$__constructor__(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_RCEI$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RCEI)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class PCEBuffer
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private PCEI[] buffer_;
            private int bufferIndex_;

            private void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$__constructor__() {
                this.buffer_ = new PCEI[16];
                this.bufferIndex_ = 0;
            }

            private final void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$reset() {
                this.bufferIndex_ = 0;
            }

            private final boolean $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$empty() {
                return this.bufferIndex_ <= 0;
            }

            private final void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$put(long ce, int ixLow, int ixHigh) {
                if (this.bufferIndex_ >= this.buffer_.length) {
                    PCEI[] newBuffer = new PCEI[this.buffer_.length + 8];
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.buffer_, (int)0, (Object)newBuffer, (int)0, (int)this.buffer_.length);
                    this.buffer_ = newBuffer;
                }
                this.buffer_[this.bufferIndex_] = new PCEI();
                this.buffer_[this.bufferIndex_].ce_ = ce;
                this.buffer_[this.bufferIndex_].low_ = ixLow;
                this.buffer_[this.bufferIndex_].high_ = ixHigh;
                ++this.bufferIndex_;
            }

            private final PCEI $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$get() {
                if (this.bufferIndex_ > 0) {
                    return this.buffer_[--this.bufferIndex_];
                }
                return null;
            }

            private /* synthetic */ void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$__constructor__();
            }

            private PCEBuffer() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$__constructor__(), 0, this);
            }

            void reset() {
                InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$reset(), 0, this);
            }

            boolean empty() {
                return (boolean)InvokeDynamicSupport.bootstrap("empty", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$empty(), 0, this);
            }

            void put(long l, int n, int n2) {
                InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$put(long int int ), 0, this, l, n, n2);
            }

            PCEI get() {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$get(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_PCEBuffer$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PCEBuffer)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class PCEI
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            long ce_;
            int low_;
            int high_;

            private void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEI$__constructor__() {
            }

            private /* synthetic */ void $$robo$$android_icu_text_StringSearch_CollationPCE_PCEI$__constructor__(1 x0) {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_PCEI$__constructor__();
            }

            private PCEI() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE_PCEI$__constructor__(), 0, this);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_PCEI$__constructor__(var1_1);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PCEI)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        public static final class Range
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int ixLow_;
            int ixHigh_;

            private void $$robo$$android_icu_text_StringSearch_CollationPCE_Range$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_icu_text_StringSearch_CollationPCE_Range$__constructor__();
            }

            public Range() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_CollationPCE_Range$__constructor__(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Range)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Pattern
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String text_;
        long[] PCE_;
        int PCELength_;
        int[] CE_;
        int CELength_;

        private void $$robo$$android_icu_text_StringSearch_Pattern$__constructor__(String pattern) {
            this.PCELength_ = 0;
            this.CELength_ = 0;
            this.text_ = pattern;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_text_StringSearch_Pattern$__constructor__(string2);
        }

        protected Pattern(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_Pattern$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Pattern() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Pattern)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Match
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int start_;
        int limit_;

        private void $$robo$$android_icu_text_StringSearch_Match$__constructor__() {
            this.start_ = -1;
            this.limit_ = -1;
        }

        private /* synthetic */ void $$robo$$android_icu_text_StringSearch_Match$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_StringSearch_Match$__constructor__();
        }

        private Match() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_StringSearch_Match$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_text_StringSearch_Match$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Match)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

