/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.CharacterIteratorWrapper;
import android.icu.impl.ReplaceableUCharacterIterator;
import android.icu.impl.UCharArrayIterator;
import android.icu.impl.UCharacterIteratorWrapper;
import android.icu.text.Replaceable;
import android.icu.text.UForwardCharacterIterator;
import android.icu.text.UTF16;
import java.text.CharacterIterator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class UCharacterIterator
implements Cloneable,
UForwardCharacterIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_icu_text_UCharacterIterator$__constructor__() {
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(Replaceable source) {
        return new ReplaceableUCharacterIterator(source);
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(String source) {
        return new ReplaceableUCharacterIterator(source);
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(char[] source) {
        return UCharacterIterator.getInstance(source, 0, source.length);
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(char[] source, int start, int limit) {
        return new UCharArrayIterator(source, start, limit);
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(StringBuffer source) {
        return new ReplaceableUCharacterIterator(source);
    }

    private static final UCharacterIterator $$robo$$android_icu_text_UCharacterIterator$getInstance(CharacterIterator source) {
        return new CharacterIteratorWrapper(source);
    }

    private final CharacterIterator $$robo$$android_icu_text_UCharacterIterator$getCharacterIterator() {
        return new UCharacterIteratorWrapper(this);
    }

    public abstract int current();

    private final int $$robo$$android_icu_text_UCharacterIterator$currentCodePoint() {
        int ch = this.current();
        if (UTF16.isLeadSurrogate((char)ch)) {
            this.next();
            int ch2 = this.current();
            this.previous();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch, (char)ch2);
            }
        }
        return ch;
    }

    public abstract int getLength();

    public abstract int getIndex();

    @Override
    public abstract int next();

    private final int $$robo$$android_icu_text_UCharacterIterator$nextCodePoint() {
        int ch1 = this.next();
        if (UTF16.isLeadSurrogate((char)ch1)) {
            int ch2 = this.next();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch1, (char)ch2);
            }
            if (ch2 != -1) {
                this.previous();
            }
        }
        return ch1;
    }

    public abstract int previous();

    private final int $$robo$$android_icu_text_UCharacterIterator$previousCodePoint() {
        int ch1 = this.previous();
        if (UTF16.isTrailSurrogate((char)ch1)) {
            int ch2 = this.previous();
            if (UTF16.isLeadSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch2, (char)ch1);
            }
            if (ch2 != -1) {
                this.next();
            }
        }
        return ch1;
    }

    public abstract void setIndex(int var1);

    private final void $$robo$$android_icu_text_UCharacterIterator$setToLimit() {
        this.setIndex(this.getLength());
    }

    private final void $$robo$$android_icu_text_UCharacterIterator$setToStart() {
        this.setIndex(0);
    }

    public abstract int getText(char[] var1, int var2);

    private final int $$robo$$android_icu_text_UCharacterIterator$getText(char[] fillIn) {
        return this.getText(fillIn, 0);
    }

    private final String $$robo$$android_icu_text_UCharacterIterator$getText() {
        char[] text = new char[this.getLength()];
        this.getText(text);
        return new String(text);
    }

    private final int $$robo$$android_icu_text_UCharacterIterator$moveIndex(int delta) {
        int x = Math.max(0, Math.min(this.getIndex() + delta, this.getLength()));
        this.setIndex(x);
        return x;
    }

    private final int $$robo$$android_icu_text_UCharacterIterator$moveCodePointIndex(int delta) {
        if (delta > 0) {
            while (delta > 0 && this.nextCodePoint() != -1) {
                --delta;
            }
        } else {
            while (delta < 0 && this.previousCodePoint() != -1) {
                ++delta;
            }
        }
        if (delta != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getIndex();
    }

    private final Object $$robo$$android_icu_text_UCharacterIterator$clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_UCharacterIterator$__constructor__();
    }

    protected UCharacterIterator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UCharacterIterator$__constructor__(), 0, this);
    }

    public static UCharacterIterator getInstance(Replaceable replaceable) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(android.icu.text.Replaceable ), 0, (Replaceable)replaceable);
    }

    public static UCharacterIterator getInstance(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(java.lang.String ), 0, (String)string2);
    }

    public static UCharacterIterator getInstance(char[] cArray) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(char[] ), 0, (char[])cArray);
    }

    public static UCharacterIterator getInstance(char[] cArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(char[] int int ), 0, (char[])cArray, (int)n, (int)n2);
    }

    public static UCharacterIterator getInstance(StringBuffer stringBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(java.lang.StringBuffer ), 0, (StringBuffer)stringBuffer);
    }

    public static UCharacterIterator getInstance(CharacterIterator characterIterator) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_text_UCharacterIterator$getInstance(java.text.CharacterIterator ), 0, (CharacterIterator)characterIterator);
    }

    public CharacterIterator getCharacterIterator() {
        return InvokeDynamicSupport.bootstrap("getCharacterIterator", $$robo$$android_icu_text_UCharacterIterator$getCharacterIterator(), 0, this);
    }

    public int currentCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("currentCodePoint", $$robo$$android_icu_text_UCharacterIterator$currentCodePoint(), 0, this);
    }

    @Override
    public int nextCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("nextCodePoint", $$robo$$android_icu_text_UCharacterIterator$nextCodePoint(), 0, this);
    }

    public int previousCodePoint() {
        return (int)InvokeDynamicSupport.bootstrap("previousCodePoint", $$robo$$android_icu_text_UCharacterIterator$previousCodePoint(), 0, this);
    }

    public void setToLimit() {
        InvokeDynamicSupport.bootstrap("setToLimit", $$robo$$android_icu_text_UCharacterIterator$setToLimit(), 0, this);
    }

    public void setToStart() {
        InvokeDynamicSupport.bootstrap("setToStart", $$robo$$android_icu_text_UCharacterIterator$setToStart(), 0, this);
    }

    public int getText(char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_UCharacterIterator$getText(char[] ), 0, this, cArray);
    }

    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_icu_text_UCharacterIterator$getText(), 0, this);
    }

    public int moveIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("moveIndex", $$robo$$android_icu_text_UCharacterIterator$moveIndex(int ), 0, this, n);
    }

    public int moveCodePointIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("moveCodePointIndex", $$robo$$android_icu_text_UCharacterIterator$moveCodePointIndex(int ), 0, this, n);
    }

    public Object clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_UCharacterIterator$clone(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UCharacterIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

