/*
 * Decompiled with CFR 0.152.
 */
package android.icu.text;

import android.icu.impl.BMPSet;
import android.icu.impl.Norm2AllModes;
import android.icu.impl.PatternProps;
import android.icu.impl.RuleCharacterIterator;
import android.icu.impl.SortedSetRelation;
import android.icu.impl.StringRange;
import android.icu.impl.UBiDiProps;
import android.icu.impl.UCaseProps;
import android.icu.impl.UCharacterProperty;
import android.icu.impl.UPropertyAliases;
import android.icu.impl.UnicodeSetStringSpan;
import android.icu.impl.Utility;
import android.icu.lang.CharSequences;
import android.icu.lang.UCharacter;
import android.icu.lang.UScript;
import android.icu.text.BreakIterator;
import android.icu.text.Replaceable;
import android.icu.text.SymbolTable;
import android.icu.text.UTF16;
import android.icu.text.UnicodeFilter;
import android.icu.text.UnicodeMatcher;
import android.icu.text.UnicodeSetIterator;
import android.icu.util.Freezable;
import android.icu.util.ICUUncheckedIOException;
import android.icu.util.OutputInt;
import android.icu.util.ULocale;
import android.icu.util.VersionInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UnicodeSet
extends UnicodeFilter
implements Iterable<String>,
Comparable<UnicodeSet>,
Freezable<UnicodeSet> {
    public transient /* synthetic */ Object __robo_data__;
    public static UnicodeSet EMPTY;
    public static UnicodeSet ALL_CODE_POINTS;
    private static XSymbolTable XSYMBOL_TABLE;
    private static int LOW = 0;
    private static int HIGH = 0x110000;
    public static int MIN_VALUE = 0;
    public static int MAX_VALUE = 0x10FFFF;
    private int len;
    private int[] list;
    private int[] rangeList;
    private int[] buffer;
    TreeSet<String> strings;
    private String pat;
    private static int START_EXTRA = 16;
    private static int GROW_EXTRA = 16;
    private static String ANY_ID = "ANY";
    private static String ASCII_ID = "ASCII";
    private static String ASSIGNED = "Assigned";
    private static UnicodeSet[] INCLUSIONS;
    private volatile BMPSet bmpSet;
    private volatile UnicodeSetStringSpan stringSpan;
    private static int LAST0_START = 0;
    private static int LAST1_RANGE = 1;
    private static int LAST2_SET = 2;
    private static int MODE0_NONE = 0;
    private static int MODE1_INBRACKET = 1;
    private static int MODE2_OUTBRACKET = 2;
    private static int SETMODE0_NONE = 0;
    private static int SETMODE1_UNICODESET = 1;
    private static int SETMODE2_PROPERTYPAT = 2;
    private static int SETMODE3_PREPARSED = 3;
    private static VersionInfo NO_VERSION;
    public static int IGNORE_SPACE = 1;
    public static int CASE = 2;
    public static int CASE_INSENSITIVE = 2;
    public static int ADD_CASE_MAPPINGS = 4;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__() {
        this.strings = new TreeSet();
        this.pat = null;
        this.list = new int[17];
        this.list[this.len++] = 0x110000;
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(UnicodeSet other) {
        this.strings = new TreeSet();
        this.pat = null;
        this.set(other);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(int start, int end) {
        this.complement(start, end);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(int ... pairs) {
        this.strings = new TreeSet();
        this.pat = null;
        if ((pairs.length & 1) != 0) {
            throw new IllegalArgumentException("Must have even number of integers");
        }
        this.list = new int[pairs.length + 1];
        this.len = this.list.length;
        int last = -1;
        int i = 0;
        while (i < pairs.length) {
            int start = pairs[i];
            if (last >= start) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[i++] = last = start;
            int end = pairs[i] + 1;
            if (last >= end) {
                throw new IllegalArgumentException("Must be monotonically increasing.");
            }
            this.list[i++] = last = end;
        }
        this.list[i] = 0x110000;
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(String pattern) {
        this.applyPattern(pattern, null, null, 1);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(String pattern, boolean ignoreWhitespace) {
        this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(String pattern, int options) {
        this.applyPattern(pattern, null, null, options);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(String pattern, ParsePosition pos, SymbolTable symbols) {
        this.applyPattern(pattern, pos, symbols, 1);
    }

    private void $$robo$$android_icu_text_UnicodeSet$__constructor__(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        this.applyPattern(pattern, pos, symbols, options);
    }

    private final Object $$robo$$android_icu_text_UnicodeSet$clone() {
        if (this.isFrozen()) {
            return this;
        }
        UnicodeSet result = new UnicodeSet(this);
        result.bmpSet = this.bmpSet;
        result.stringSpan = this.stringSpan;
        return result;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$set(int start, int end) {
        this.checkFrozen();
        this.clear();
        this.complement(start, end);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$set(UnicodeSet other) {
        this.checkFrozen();
        this.list = (int[])other.list.clone();
        this.len = other.len;
        this.pat = other.pat;
        this.strings = new TreeSet<String>((SortedSet<String>)other.strings);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPattern(String pattern) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, 1);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPattern(String pattern, boolean ignoreWhitespace) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, ignoreWhitespace ? 1 : 0);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPattern(String pattern, int options) {
        this.checkFrozen();
        return this.applyPattern(pattern, null, null, options);
    }

    private static final boolean $$robo$$android_icu_text_UnicodeSet$resemblesPattern(String pattern, int pos) {
        return pos + 1 < pattern.length() && pattern.charAt(pos) == '[' || UnicodeSet.resemblesPropertyPattern(pattern, pos);
    }

    private static final void $$robo$$android_icu_text_UnicodeSet$appendCodePoint(Appendable app, int c) {
        if (!($assertionsDisabled || 0 <= c && c <= 0x10FFFF)) {
            throw new AssertionError();
        }
        try {
            if (c <= 65535) {
                app.append((char)c);
            } else {
                app.append(UTF16.getLeadSurrogate(c)).append(UTF16.getTrailSurrogate(c));
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private static final void $$robo$$android_icu_text_UnicodeSet$append(Appendable app, CharSequence s) {
        try {
            app.append(s);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private static final <T extends Appendable> T $$robo$$android_icu_text_UnicodeSet$_appendToPat(T buf, String s, boolean escapeUnprintable) {
        int cp;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            UnicodeSet._appendToPat(buf, cp, escapeUnprintable);
        }
        return buf;
    }

    private static final <T extends Appendable> T $$robo$$android_icu_text_UnicodeSet$_appendToPat(T buf, int c, boolean escapeUnprintable) {
        try {
            if (escapeUnprintable && Utility.isUnprintable(c) && Utility.escapeUnprintable(buf, c)) {
                return buf;
            }
            switch (c) {
                case 36: 
                case 38: 
                case 45: 
                case 58: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 125: {
                    buf.append('\\');
                    break;
                }
                default: {
                    if (!PatternProps.isWhiteSpace(c)) break;
                    buf.append('\\');
                }
            }
            UnicodeSet.appendCodePoint(buf, c);
            return buf;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private final String $$robo$$android_icu_text_UnicodeSet$toPattern(boolean escapeUnprintable) {
        if (this.pat != null && !escapeUnprintable) {
            return this.pat;
        }
        StringBuilder result = new StringBuilder();
        return this._toPattern(result, escapeUnprintable).toString();
    }

    private final <T extends Appendable> T $$robo$$android_icu_text_UnicodeSet$_toPattern(T result, boolean escapeUnprintable) {
        if (this.pat == null) {
            return this.appendNewPattern(result, escapeUnprintable, true);
        }
        try {
            if (!escapeUnprintable) {
                result.append(this.pat);
                return result;
            }
            boolean oddNumberOfBackslashes = false;
            int i = 0;
            while (i < this.pat.length()) {
                int c = this.pat.codePointAt(i);
                i += Character.charCount(c);
                if (Utility.isUnprintable(c)) {
                    Utility.escapeUnprintable(result, c);
                    oddNumberOfBackslashes = false;
                    continue;
                }
                if (!oddNumberOfBackslashes && c == 92) {
                    oddNumberOfBackslashes = true;
                    continue;
                }
                if (oddNumberOfBackslashes) {
                    result.append('\\');
                }
                UnicodeSet.appendCodePoint(result, c);
                oddNumberOfBackslashes = false;
            }
            if (oddNumberOfBackslashes) {
                result.append('\\');
            }
            return result;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private final StringBuffer $$robo$$android_icu_text_UnicodeSet$_generatePattern(StringBuffer result, boolean escapeUnprintable) {
        return this._generatePattern(result, escapeUnprintable, true);
    }

    private final StringBuffer $$robo$$android_icu_text_UnicodeSet$_generatePattern(StringBuffer result, boolean escapeUnprintable, boolean includeStrings) {
        return this.appendNewPattern(result, escapeUnprintable, includeStrings);
    }

    private final <T extends Appendable> T $$robo$$android_icu_text_UnicodeSet$appendNewPattern(T result, boolean escapeUnprintable, boolean includeStrings) {
        try {
            int end;
            int start;
            int i;
            result.append('[');
            int count = this.getRangeCount();
            if (count > 1 && this.getRangeStart(0) == 0 && this.getRangeEnd(count - 1) == 0x10FFFF) {
                result.append('^');
                for (i = 1; i < count; ++i) {
                    start = this.getRangeEnd(i - 1) + 1;
                    end = this.getRangeStart(i) - 1;
                    UnicodeSet._appendToPat(result, start, escapeUnprintable);
                    if (start == end) continue;
                    if (start + 1 != end) {
                        result.append('-');
                    }
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
            } else {
                for (i = 0; i < count; ++i) {
                    start = this.getRangeStart(i);
                    end = this.getRangeEnd(i);
                    UnicodeSet._appendToPat(result, start, escapeUnprintable);
                    if (start == end) continue;
                    if (start + 1 != end) {
                        result.append('-');
                    }
                    UnicodeSet._appendToPat(result, end, escapeUnprintable);
                }
            }
            if (includeStrings && this.strings.size() > 0) {
                for (String s : this.strings) {
                    result.append('{');
                    UnicodeSet._appendToPat(result, s, escapeUnprintable);
                    result.append('}');
                }
            }
            result.append(']');
            return result;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private final int $$robo$$android_icu_text_UnicodeSet$size() {
        int n = 0;
        int count = this.getRangeCount();
        for (int i = 0; i < count; ++i) {
            n += this.getRangeEnd(i) - this.getRangeStart(i) + 1;
        }
        return n + this.strings.size();
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$isEmpty() {
        return this.len == 1 && this.strings.size() == 0;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$matchesIndexValue(int v) {
        for (int i = 0; i < this.getRangeCount(); ++i) {
            int high;
            int low = this.getRangeStart(i);
            if (!((low & 0xFFFFFF00) == ((high = this.getRangeEnd(i)) & 0xFFFFFF00) ? (low & 0xFF) <= v && v <= (high & 0xFF) : (low & 0xFF) <= v || v <= (high & 0xFF))) continue;
            return true;
        }
        if (this.strings.size() != 0) {
            for (String s : this.strings) {
                int c = UTF16.charAt(s, 0);
                if ((c & 0xFF) != v) continue;
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$matches(Replaceable text, int[] offset, int limit, boolean incremental) {
        if (offset[0] == limit) {
            if (this.contains(65535)) {
                return incremental ? 1 : 2;
            }
            return 0;
        }
        if (this.strings.size() != 0) {
            boolean forward = offset[0] < limit;
            char firstChar = text.charAt(offset[0]);
            int highWaterLength = 0;
            for (String trial : this.strings) {
                char c = trial.charAt(forward ? 0 : trial.length() - 1);
                if (forward && c > firstChar) break;
                if (c != firstChar) continue;
                int length = UnicodeSet.matchRest(text, offset[0], limit, trial);
                if (incremental) {
                    int maxLen;
                    int n = maxLen = forward ? limit - offset[0] : offset[0] - limit;
                    if (length == maxLen) {
                        return 1;
                    }
                }
                if (length != trial.length()) continue;
                if (length > highWaterLength) {
                    highWaterLength = length;
                }
                if (!forward || length >= highWaterLength) continue;
                break;
            }
            if (highWaterLength != 0) {
                offset[0] = offset[0] + (forward ? highWaterLength : -highWaterLength);
                return 2;
            }
        }
        return super.matches(text, offset, limit, incremental);
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$matchRest(Replaceable text, int start, int limit, String s) {
        int maxLen;
        int slen = s.length();
        if (start < limit) {
            maxLen = limit - start;
            if (maxLen > slen) {
                maxLen = slen;
            }
            for (int i = 1; i < maxLen; ++i) {
                if (text.charAt(start + i) == s.charAt(i)) continue;
                return 0;
            }
        } else {
            maxLen = start - limit;
            if (maxLen > slen) {
                maxLen = slen;
            }
            --slen;
            for (int i = 1; i < maxLen; ++i) {
                if (text.charAt(start - i) == s.charAt(slen - i)) continue;
                return 0;
            }
        }
        return maxLen;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_UnicodeSet$matchesAt(CharSequence text, int offset) {
        int cp;
        int lastLen;
        block4: {
            lastLen = -1;
            if (this.strings.size() != 0) {
                int tempLen;
                char firstChar = text.charAt(offset);
                String trial = null;
                Iterator<String> it = this.strings.iterator();
                while (it.hasNext()) {
                    trial = it.next();
                    char firstStringChar = trial.charAt(0);
                    if (firstStringChar < firstChar || firstStringChar <= firstChar) continue;
                    break block4;
                }
                while (lastLen <= (tempLen = UnicodeSet.matchesAt(text, offset, trial))) {
                    lastLen = tempLen;
                    if (!it.hasNext()) break;
                    trial = it.next();
                }
            }
        }
        if (lastLen < 2 && this.contains(cp = UTF16.charAt(text, offset))) {
            lastLen = UTF16.getCharCount(cp);
        }
        return offset + lastLen;
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$matchesAt(CharSequence text, int offsetInText, CharSequence substring) {
        int len = substring.length();
        int textLength = text.length();
        if (textLength + offsetInText > len) {
            return -1;
        }
        int i = 0;
        int j = offsetInText;
        while (i < len) {
            char tc;
            char pc = substring.charAt(i);
            if (pc != (tc = text.charAt(j))) {
                return -1;
            }
            ++i;
            ++j;
        }
        return i;
    }

    private final void $$robo$$android_icu_text_UnicodeSet$addMatchSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$indexOf(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = 0;
        int n = 0;
        int start;
        while (c >= (start = this.list[i++])) {
            int limit;
            if (c < (limit = this.list[i++])) {
                return n + c - start;
            }
            n += limit - start;
        }
        return -1;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$charAt(int index) {
        if (index >= 0) {
            int len2 = this.len & 0xFFFFFFFE;
            int i = 0;
            while (i < len2) {
                int start;
                int count;
                if (index < (count = this.list[i++] - (start = this.list[i++]))) {
                    return start + index;
                }
                index -= count;
            }
        }
        return -1;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add(int start, int end) {
        this.checkFrozen();
        return this.add_unchecked(start, end);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$addAll(int start, int end) {
        this.checkFrozen();
        return this.add_unchecked(start, end);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add_unchecked(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start < end) {
            this.add(this.range(start, end), 2, 0);
        } else if (start == end) {
            this.add(start);
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add(int c) {
        this.checkFrozen();
        return this.add_unchecked(c);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add_unchecked(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        int i = this.findCodePoint(c);
        if ((i & 1) != 0) {
            return this;
        }
        if (c == this.list[i] - 1) {
            this.list[i] = c;
            if (c == 0x10FFFF) {
                this.ensureCapacity(this.len + 1);
                this.list[this.len++] = 0x110000;
            }
            if (i > 0 && c == this.list[i - 1]) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)(i + 1), (int[])this.list, (int)(i - 1), (int)(this.len - i - 1));
                this.len -= 2;
            }
        } else if (i > 0 && c == this.list[i - 1]) {
            int n = i - 1;
            this.list[n] = this.list[n] + 1;
        } else {
            if (this.len + 2 > this.list.length) {
                int[] temp = new int[this.len + 2 + 16];
                if (i != 0) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)0, (int[])temp, (int)0, (int)i);
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)i, (int[])temp, (int)(i + 2), (int)(this.len - i));
                this.list = temp;
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)i, (int[])this.list, (int)(i + 2), (int)(this.len - i));
            }
            this.list[i] = c;
            this.list[i + 1] = c + 1;
            this.len += 2;
        }
        this.pat = null;
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add(CharSequence s) {
        this.checkFrozen();
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.add(s.toString());
            this.pat = null;
        } else {
            this.add_unchecked(cp, cp);
        }
        return this;
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$getSingleCP(CharSequence s) {
        if (s.length() < 1) {
            throw new IllegalArgumentException("Can't use zero-length strings in UnicodeSet");
        }
        if (s.length() > 2) {
            return -1;
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        int cp = UTF16.charAt(s, 0);
        if (cp > 65535) {
            return cp;
        }
        return -1;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$addAll(CharSequence s) {
        int cp;
        this.checkFrozen();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s, i);
            this.add_unchecked(cp, cp);
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retainAll(CharSequence s) {
        return this.retainAll(UnicodeSet.fromAll(s));
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complementAll(CharSequence s) {
        return this.complementAll(UnicodeSet.fromAll(s));
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$removeAll(CharSequence s) {
        return this.removeAll(UnicodeSet.fromAll(s));
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$removeAllStrings() {
        this.checkFrozen();
        if (this.strings.size() != 0) {
            this.strings.clear();
            this.pat = null;
        }
        return this;
    }

    private static final UnicodeSet $$robo$$android_icu_text_UnicodeSet$from(CharSequence s) {
        return new UnicodeSet().add(s);
    }

    private static final UnicodeSet $$robo$$android_icu_text_UnicodeSet$fromAll(CharSequence s) {
        return new UnicodeSet().addAll(s);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retain(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 0);
        } else {
            this.clear();
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retain(int c) {
        return this.retain(c, c);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retain(CharSequence cs) {
        int cp = UnicodeSet.getSingleCP(cs);
        if (cp < 0) {
            String s = cs.toString();
            boolean isIn = this.strings.contains(s);
            if (isIn && this.size() == 1) {
                return this;
            }
            this.clear();
            this.strings.add(s);
            this.pat = null;
        } else {
            this.retain(cp, cp);
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$remove(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.retain(this.range(start, end), 2, 2);
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$remove(int c) {
        return this.remove(c, c);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$remove(CharSequence s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            this.strings.remove(s.toString());
            this.pat = null;
        } else {
            this.remove(cp, cp);
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complement(int start, int end) {
        this.checkFrozen();
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        if (start <= end) {
            this.xor(this.range(start, end), 2, 0);
        }
        this.pat = null;
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complement(int c) {
        return this.complement(c, c);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complement() {
        this.checkFrozen();
        if (this.list[0] == 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)1, (int[])this.list, (int)0, (int)(this.len - 1));
            --this.len;
        } else {
            this.ensureCapacity(this.len + 1);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)0, (int[])this.list, (int)1, (int)this.len);
            this.list[0] = 0;
            ++this.len;
        }
        this.pat = null;
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complement(CharSequence s) {
        this.checkFrozen();
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            String s2 = s.toString();
            if (this.strings.contains(s2)) {
                this.strings.remove(s2);
            } else {
                this.strings.add(s2);
            }
            this.pat = null;
        } else {
            this.complement(cp, cp);
        }
        return this;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$contains(int c) {
        if (c < 0 || c > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(c, 6));
        }
        if (this.bmpSet != null) {
            return this.bmpSet.contains(c);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.contains(c);
        }
        int i = this.findCodePoint(c);
        return (i & 1) != 0;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$findCodePoint(int c) {
        if (c < this.list[0]) {
            return 0;
        }
        if (this.len >= 2 && c >= this.list[this.len - 2]) {
            return this.len - 1;
        }
        int lo = 0;
        int hi = this.len - 1;
        int i;
        while ((i = lo + hi >>> 1) != lo) {
            if (c < this.list[i]) {
                hi = i;
                continue;
            }
            lo = i;
        }
        return hi;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$contains(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = this.findCodePoint(start);
        return (i & 1) != 0 && end < this.list[i];
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$contains(CharSequence s) {
        int cp = UnicodeSet.getSingleCP(s);
        if (cp < 0) {
            return this.strings.contains(s.toString());
        }
        return this.contains(cp);
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsAll(UnicodeSet b) {
        block6: {
            int[] listB = b.list;
            boolean needA = true;
            boolean needB = true;
            int aPtr = 0;
            int bPtr = 0;
            int aLen = this.len - 1;
            int bLen = b.len - 1;
            int startA = 0;
            int startB = 0;
            int limitA = 0;
            int limitB = 0;
            while (true) {
                if (needA) {
                    if (aPtr >= aLen) {
                        if (!needB || bPtr < bLen) {
                            return false;
                        }
                        break block6;
                    }
                    startA = this.list[aPtr++];
                    limitA = this.list[aPtr++];
                }
                if (needB) {
                    if (bPtr >= bLen) break block6;
                    startB = listB[bPtr++];
                    limitB = listB[bPtr++];
                }
                if (startB >= limitA) {
                    needA = true;
                    needB = false;
                    continue;
                }
                if (startB < startA || limitB > limitA) break;
                needA = false;
                needB = true;
            }
            return false;
        }
        return this.strings.containsAll(b.strings);
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsAll(String s) {
        int cp;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s, i);
            if (this.contains(cp)) continue;
            if (this.strings.size() == 0) {
                return false;
            }
            return this.containsAll(s, 0);
        }
        return true;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsAll(String s, int i) {
        if (i >= s.length()) {
            return true;
        }
        int cp = UTF16.charAt(s, i);
        if (this.contains(cp) && this.containsAll(s, i + UTF16.getCharCount(cp))) {
            return true;
        }
        for (String setStr : this.strings) {
            if (!s.startsWith(setStr, i) || !this.containsAll(s, i + setStr.length())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_UnicodeSet$getRegexEquivalent() {
        if (this.strings.size() == 0) {
            return this.toString();
        }
        StringBuilder result = new StringBuilder("(?:");
        this.appendNewPattern(result, true, false);
        for (String s : this.strings) {
            result.append('|');
            UnicodeSet._appendToPat(result, s, true);
        }
        return result.append(")").toString();
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsNone(int start, int end) {
        if (start < 0 || start > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(start, 6));
        }
        if (end < 0 || end > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid code point U+" + Utility.hex(end, 6));
        }
        int i = -1;
        while (start >= this.list[++i]) {
        }
        return (i & 1) == 0 && end < this.list[i];
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsNone(UnicodeSet b) {
        block4: {
            int[] listB = b.list;
            boolean needA = true;
            boolean needB = true;
            int aPtr = 0;
            int bPtr = 0;
            int aLen = this.len - 1;
            int bLen = b.len - 1;
            int startA = 0;
            int startB = 0;
            int limitA = 0;
            int limitB = 0;
            while (true) {
                if (needA) {
                    if (aPtr >= aLen) break block4;
                    startA = this.list[aPtr++];
                    limitA = this.list[aPtr++];
                }
                if (needB) {
                    if (bPtr >= bLen) break block4;
                    startB = listB[bPtr++];
                    limitB = listB[bPtr++];
                }
                if (startB >= limitA) {
                    needA = true;
                    needB = false;
                    continue;
                }
                if (startA < limitB) break;
                needA = false;
                needB = true;
            }
            return false;
        }
        return SortedSetRelation.hasRelation(this.strings, 5, b.strings);
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsNone(CharSequence s) {
        return this.span(s, SpanCondition.NOT_CONTAINED) == s.length();
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsSome(int start, int end) {
        return !this.containsNone(start, end);
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsSome(UnicodeSet s) {
        return !this.containsNone(s);
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$containsSome(CharSequence s) {
        return !this.containsNone(s);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$addAll(UnicodeSet c) {
        this.checkFrozen();
        this.add(c.list, c.len, 0);
        this.strings.addAll(c.strings);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retainAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 0);
        this.strings.retainAll(c.strings);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$removeAll(UnicodeSet c) {
        this.checkFrozen();
        this.retain(c.list, c.len, 2);
        this.strings.removeAll(c.strings);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$complementAll(UnicodeSet c) {
        this.checkFrozen();
        this.xor(c.list, c.len, 0);
        SortedSetRelation.doOperation(this.strings, 5, c.strings);
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$clear() {
        this.checkFrozen();
        this.list[0] = 0x110000;
        this.len = 1;
        this.pat = null;
        this.strings.clear();
        return this;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$getRangeCount() {
        return this.len / 2;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$getRangeStart(int index) {
        return this.list[index * 2];
    }

    private final int $$robo$$android_icu_text_UnicodeSet$getRangeEnd(int index) {
        return this.list[index * 2 + 1] - 1;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$compact() {
        this.checkFrozen();
        if (this.len != this.list.length) {
            int[] temp = new int[this.len];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)0, (int[])temp, (int)0, (int)this.len);
            this.list = temp;
        }
        this.rangeList = null;
        this.buffer = null;
        return this;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            UnicodeSet that = (UnicodeSet)o;
            if (this.len != that.len) {
                return false;
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.list[i] == that.list[i]) continue;
                return false;
            }
            if (!this.strings.equals(that.strings)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$hashCode() {
        int result = this.len;
        for (int i = 0; i < this.len; ++i) {
            result *= 1000003;
            result += this.list[i];
        }
        return result;
    }

    private final String $$robo$$android_icu_text_UnicodeSet$toString() {
        return this.toPattern(true);
    }

    @Deprecated
    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPattern(String pattern, ParsePosition pos, SymbolTable symbols, int options) {
        boolean parsePositionWasNull;
        boolean bl = parsePositionWasNull = pos == null;
        if (parsePositionWasNull) {
            pos = new ParsePosition(0);
        }
        StringBuilder rebuiltPat = new StringBuilder();
        RuleCharacterIterator chars = new RuleCharacterIterator(pattern, symbols, pos);
        this.applyPattern(chars, symbols, rebuiltPat, options);
        if (chars.inVariable()) {
            UnicodeSet.syntaxError(chars, "Extra chars in variable value");
        }
        this.pat = rebuiltPat.toString();
        if (parsePositionWasNull) {
            int i = pos.getIndex();
            if ((options & 1) != 0) {
                i = PatternProps.skipWhiteSpace(pattern, i);
            }
            if (i != pattern.length()) {
                throw new IllegalArgumentException("Parse of \"" + pattern + "\" failed at " + i);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void $$robo$$android_icu_text_UnicodeSet$applyPattern(RuleCharacterIterator chars, SymbolTable symbols, Appendable rebuiltPat, int options) {
        int opts = 3;
        if ((options & 1) != 0) {
            opts |= 4;
        }
        StringBuilder patBuf = new StringBuilder();
        StringBuilder buf = null;
        boolean usePat = false;
        UnicodeSet scratch = null;
        Object backup = null;
        int lastItem = 0;
        int lastChar = 0;
        int mode = 0;
        char op = '\u0000';
        boolean invert = false;
        this.clear();
        String lastString = null;
        block27: while (mode != 2 && !chars.atEnd()) {
            int setMode;
            UnicodeSet nested;
            boolean literal;
            int c;
            block76: {
                UnicodeMatcher m;
                block78: {
                    block77: {
                        c = 0;
                        literal = false;
                        nested = null;
                        setMode = 0;
                        if (!UnicodeSet.resemblesPropertyPattern(chars, opts)) break block77;
                        setMode = 2;
                        break block76;
                    }
                    backup = chars.getPos(backup);
                    c = chars.next(opts);
                    literal = chars.isEscaped();
                    if (c != 91 || literal) break block78;
                    if (mode == 1) {
                        chars.setPos(backup);
                        setMode = 1;
                        break block76;
                    } else {
                        mode = 1;
                        patBuf.append('[');
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        if (c == 94 && !literal) {
                            invert = true;
                            patBuf.append('^');
                            backup = chars.getPos(backup);
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                        }
                        if (c == 45) {
                            literal = true;
                            break block76;
                        } else {
                            chars.setPos(backup);
                            continue;
                        }
                    }
                }
                if (symbols != null && (m = symbols.lookupMatcher(c)) != null) {
                    try {
                        nested = (UnicodeSet)m;
                        setMode = 3;
                    }
                    catch (ClassCastException e) {
                        UnicodeSet.syntaxError(chars, "Syntax error");
                    }
                }
            }
            if (setMode != 0) {
                if (lastItem == 1) {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Char expected after operator");
                    }
                    this.add_unchecked(lastChar, lastChar);
                    UnicodeSet._appendToPat(patBuf, lastChar, false);
                    lastItem = 0;
                    op = '\u0000';
                }
                if (op == '-' || op == '&') {
                    patBuf.append(op);
                }
                if (nested == null) {
                    if (scratch == null) {
                        scratch = new UnicodeSet();
                    }
                    nested = scratch;
                }
                switch (setMode) {
                    case 1: {
                        nested.applyPattern(chars, symbols, patBuf, options);
                        break;
                    }
                    case 2: {
                        chars.skipIgnored(opts);
                        nested.applyPropertyPattern(chars, patBuf, symbols);
                        break;
                    }
                    case 3: {
                        nested._toPattern(patBuf, false);
                        break;
                    }
                }
                usePat = true;
                if (mode == 0) {
                    this.set(nested);
                    mode = 2;
                    break;
                }
                switch (op) {
                    case '-': {
                        this.removeAll(nested);
                        break;
                    }
                    case '&': {
                        this.retainAll(nested);
                        break;
                    }
                    case '\u0000': {
                        this.addAll(nested);
                        break;
                    }
                }
                op = '\u0000';
                lastItem = 2;
                continue;
            }
            if (mode == 0) {
                UnicodeSet.syntaxError(chars, "Missing '['");
            }
            if (!literal) {
                switch (c) {
                    case 93: {
                        if (lastItem == 1) {
                            this.add_unchecked(lastChar, lastChar);
                            UnicodeSet._appendToPat(patBuf, lastChar, false);
                        }
                        if (op == '-') {
                            this.add_unchecked(op, op);
                            patBuf.append(op);
                        } else if (op == '&') {
                            UnicodeSet.syntaxError(chars, "Trailing '&'");
                        }
                        patBuf.append(']');
                        mode = 2;
                        continue block27;
                    }
                    case 45: {
                        if (op == '\u0000') {
                            if (lastItem != 0) {
                                op = (char)c;
                                continue block27;
                            }
                            if (lastString != null) {
                                op = (char)c;
                                continue block27;
                            }
                            this.add_unchecked(c, c);
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 93 && !literal) {
                                patBuf.append("-]");
                                mode = 2;
                                continue block27;
                            }
                        }
                        UnicodeSet.syntaxError(chars, "'-' not after char, string, or set");
                        break;
                    }
                    case 38: {
                        if (lastItem == 2 && op == '\u0000') {
                            op = (char)c;
                            continue block27;
                        }
                        UnicodeSet.syntaxError(chars, "'&' not after set");
                        break;
                    }
                    case 94: {
                        UnicodeSet.syntaxError(chars, "'^' not after '['");
                        break;
                    }
                    case 123: {
                        if (op != '\u0000' && op != '-') {
                            UnicodeSet.syntaxError(chars, "Missing operand after operator");
                        }
                        if (lastItem == 1) {
                            this.add_unchecked(lastChar, lastChar);
                            UnicodeSet._appendToPat(patBuf, lastChar, false);
                        }
                        lastItem = 0;
                        if (buf == null) {
                            buf = new StringBuilder();
                        } else {
                            buf.setLength(0);
                        }
                        boolean ok = false;
                        while (!chars.atEnd()) {
                            c = chars.next(opts);
                            literal = chars.isEscaped();
                            if (c == 125 && !literal) {
                                ok = true;
                                break;
                            }
                            UnicodeSet.appendCodePoint(buf, c);
                        }
                        if (buf.length() < 1 || !ok) {
                            UnicodeSet.syntaxError(chars, "Invalid multicharacter string");
                        }
                        String curString = buf.toString();
                        if (op == '-') {
                            int lastSingle = CharSequences.getSingleCodePoint(lastString == null ? "" : lastString);
                            int curSingle = CharSequences.getSingleCodePoint(curString);
                            if (lastSingle != Integer.MAX_VALUE && curSingle != Integer.MAX_VALUE) {
                                this.add(lastSingle, curSingle);
                            } else {
                                try {
                                    StringRange.expand(lastString, curString, true, this.strings);
                                }
                                catch (Exception e) {
                                    UnicodeSet.syntaxError(chars, e.getMessage());
                                }
                            }
                            lastString = null;
                            op = '\u0000';
                        } else {
                            this.add(curString);
                            lastString = curString;
                        }
                        patBuf.append('{');
                        UnicodeSet._appendToPat(patBuf, curString, false);
                        patBuf.append('}');
                        continue block27;
                    }
                    case 36: {
                        boolean anchor;
                        backup = chars.getPos(backup);
                        c = chars.next(opts);
                        literal = chars.isEscaped();
                        boolean bl = anchor = c == 93 && !literal;
                        if (symbols == null && !anchor) {
                            c = 36;
                            chars.setPos(backup);
                            break;
                        }
                        if (anchor && op == '\u0000') {
                            if (lastItem == 1) {
                                this.add_unchecked(lastChar, lastChar);
                                UnicodeSet._appendToPat(patBuf, lastChar, false);
                            }
                            this.add_unchecked(65535);
                            usePat = true;
                            patBuf.append('$').append(']');
                            mode = 2;
                            continue block27;
                        }
                        UnicodeSet.syntaxError(chars, "Unquoted '$'");
                        break;
                    }
                }
            }
            switch (lastItem) {
                case 0: {
                    if (op == '-' && lastString != null) {
                        UnicodeSet.syntaxError(chars, "Invalid range");
                    }
                    lastItem = 1;
                    lastChar = c;
                    lastString = null;
                    break;
                }
                case 1: {
                    if (op == '-') {
                        if (lastString != null) {
                            UnicodeSet.syntaxError(chars, "Invalid range");
                        }
                        if (lastChar >= c) {
                            UnicodeSet.syntaxError(chars, "Invalid range");
                        }
                        this.add_unchecked(lastChar, c);
                        UnicodeSet._appendToPat(patBuf, lastChar, false);
                        patBuf.append(op);
                        UnicodeSet._appendToPat(patBuf, c, false);
                        lastItem = 0;
                        op = '\u0000';
                        break;
                    }
                    this.add_unchecked(lastChar, lastChar);
                    UnicodeSet._appendToPat(patBuf, lastChar, false);
                    lastChar = c;
                    break;
                }
                case 2: {
                    if (op != '\u0000') {
                        UnicodeSet.syntaxError(chars, "Set expected after operator");
                    }
                    lastChar = c;
                    lastItem = 1;
                    continue block27;
                }
            }
        }
        if (mode != 2) {
            UnicodeSet.syntaxError(chars, "Missing ']'");
        }
        chars.skipIgnored(opts);
        if ((options & 2) != 0) {
            this.closeOver(2);
        }
        if (invert) {
            this.complement();
        }
        if (usePat) {
            UnicodeSet.append(rebuiltPat, patBuf.toString());
            return;
        }
        this.appendNewPattern(rebuiltPat, false, true);
    }

    private static final void $$robo$$android_icu_text_UnicodeSet$syntaxError(RuleCharacterIterator chars, String msg) {
        throw new IllegalArgumentException("Error: " + msg + " at \"" + Utility.escape(chars.toString()) + '\"');
    }

    private final <T extends Collection<String>> T $$robo$$android_icu_text_UnicodeSet$addAllTo(T target) {
        return UnicodeSet.addAllTo(this, target);
    }

    private final String[] $$robo$$android_icu_text_UnicodeSet$addAllTo(String[] target) {
        return UnicodeSet.addAllTo(this, target);
    }

    private static final String[] $$robo$$android_icu_text_UnicodeSet$toArray(UnicodeSet set) {
        return UnicodeSet.addAllTo(set, new String[set.size()]);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add(Iterable<?> source) {
        return this.addAll(source);
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$addAll(Iterable<?> source) {
        this.checkFrozen();
        for (Object o : source) {
            this.add(o.toString());
        }
        return this;
    }

    private final void $$robo$$android_icu_text_UnicodeSet$ensureCapacity(int newLen) {
        if (newLen <= this.list.length) {
            return;
        }
        int[] temp = new int[newLen + 16];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.list, (int)0, (int[])temp, (int)0, (int)this.len);
        this.list = temp;
    }

    private final void $$robo$$android_icu_text_UnicodeSet$ensureBufferCapacity(int newLen) {
        if (this.buffer != null && newLen <= this.buffer.length) {
            return;
        }
        this.buffer = new int[newLen + 16];
    }

    private final int[] $$robo$$android_icu_text_UnicodeSet$range(int start, int end) {
        if (this.rangeList == null) {
            this.rangeList = new int[]{start, end + 1, 0x110000};
        } else {
            this.rangeList[0] = start;
            this.rangeList[1] = end + 1;
        }
        return this.rangeList;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$xor(int[] other, int otherLen, int polarity) {
        int b;
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        if (polarity == 1 || polarity == 2) {
            b = 0;
            if (other[j] == 0) {
                b = other[++j];
            }
        } else {
            b = other[j++];
        }
        while (true) {
            if (a < b) {
                this.buffer[k++] = a;
                a = this.list[i++];
                continue;
            }
            if (b < a) {
                this.buffer[k++] = b;
                b = other[j++];
                continue;
            }
            if (a == 0x110000) break;
            a = this.list[i++];
            b = other[j++];
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$add(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        if (k > 0 && a <= this.buffer[k - 1]) {
                            a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = a;
                            a = this.list[i];
                        }
                        ++i;
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        if (k > 0 && b <= this.buffer[k - 1]) {
                            b = UnicodeSet.max(other[j], this.buffer[--k]);
                        } else {
                            this.buffer[k++] = b;
                            b = other[j];
                        }
                        ++j;
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    if (k > 0 && a <= this.buffer[k - 1]) {
                        a = UnicodeSet.max(this.list[i], this.buffer[--k]);
                    } else {
                        this.buffer[k++] = a;
                        a = this.list[i];
                    }
                    ++i;
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (b <= a) {
                        if (a == 0x110000) break block6;
                        this.buffer[k++] = a;
                    } else {
                        if (b == 0x110000) break block6;
                        this.buffer[k++] = b;
                    }
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$retain(int[] other, int otherLen, int polarity) {
        this.ensureBufferCapacity(this.len + otherLen);
        int i = 0;
        int j = 0;
        int k = 0;
        int a = this.list[i++];
        int b = other[j++];
        block6: while (true) {
            switch (polarity) {
                case 0: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 3: {
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    this.buffer[k++] = a;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 1: {
                    if (a < b) {
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (b < a) {
                        this.buffer[k++] = b;
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                    break;
                }
                case 2: {
                    if (b < a) {
                        b = other[j++];
                        polarity ^= 2;
                        break;
                    }
                    if (a < b) {
                        this.buffer[k++] = a;
                        a = this.list[i++];
                        polarity ^= 1;
                        break;
                    }
                    if (a == 0x110000) break block6;
                    a = this.list[i++];
                    polarity ^= 1;
                    b = other[j++];
                    polarity ^= 2;
                }
            }
        }
        this.buffer[k++] = 0x110000;
        this.len = k;
        int[] temp = this.list;
        this.list = this.buffer;
        this.buffer = temp;
        this.pat = null;
        return this;
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$max(int a, int b) {
        return a > b ? a : b;
    }

    private static final synchronized UnicodeSet $$robo$$android_icu_text_UnicodeSet$getInclusions(int src) {
        if (INCLUSIONS == null) {
            INCLUSIONS = new UnicodeSet[12];
        }
        if (INCLUSIONS[src] == null) {
            UnicodeSet incl = new UnicodeSet();
            switch (src) {
                case 1: {
                    UCharacterProperty.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 2: {
                    UCharacterProperty.INSTANCE.upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 6: {
                    UCharacterProperty.INSTANCE.addPropertyStarts(incl);
                    UCharacterProperty.INSTANCE.upropsvec_addPropertyStarts(incl);
                    break;
                }
                case 7: {
                    Norm2AllModes.getNFCInstance().impl.addPropertyStarts(incl);
                    UCaseProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 8: {
                    Norm2AllModes.getNFCInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 9: {
                    Norm2AllModes.getNFKCInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 10: {
                    Norm2AllModes.getNFKC_CFInstance().impl.addPropertyStarts(incl);
                    break;
                }
                case 11: {
                    Norm2AllModes.getNFCInstance().impl.addCanonIterPropertyStarts(incl);
                    break;
                }
                case 4: {
                    UCaseProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                case 5: {
                    UBiDiProps.INSTANCE.addPropertyStarts(incl);
                    break;
                }
                default: {
                    throw new IllegalStateException("UnicodeSet.getInclusions(unknown src " + src + ")");
                }
            }
            UnicodeSet.INCLUSIONS[src] = incl;
        }
        return INCLUSIONS[src];
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyFilter(Filter filter, int src) {
        this.clear();
        int startHasProperty = -1;
        UnicodeSet inclusions = UnicodeSet.getInclusions(src);
        int limitRange = inclusions.getRangeCount();
        for (int j = 0; j < limitRange; ++j) {
            int start = inclusions.getRangeStart(j);
            int end = inclusions.getRangeEnd(j);
            for (int ch = start; ch <= end; ++ch) {
                if (filter.contains(ch)) {
                    if (startHasProperty >= 0) continue;
                    startHasProperty = ch;
                    continue;
                }
                if (startHasProperty < 0) continue;
                this.add_unchecked(startHasProperty, ch - 1);
                startHasProperty = -1;
            }
        }
        if (startHasProperty >= 0) {
            this.add_unchecked(startHasProperty, 0x10FFFF);
        }
        return this;
    }

    private static final String $$robo$$android_icu_text_UnicodeSet$mungeCharName(String source) {
        source = PatternProps.trimWhiteSpace(source);
        StringBuilder buf = null;
        for (int i = 0; i < source.length(); ++i) {
            int ch = source.charAt(i);
            if (PatternProps.isWhiteSpace(ch)) {
                if (buf == null) {
                    buf = new StringBuilder().append(source, 0, i);
                } else if (buf.charAt(buf.length() - 1) == ' ') continue;
                ch = 32;
            }
            if (buf == null) continue;
            buf.append((char)ch);
        }
        return buf == null ? source : buf.toString();
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyIntPropertyValue(int prop, int value) {
        this.checkFrozen();
        if (prop == 8192) {
            this.applyFilter(new GeneralCategoryMaskFilter(value), 1);
        } else if (prop == 28672) {
            this.applyFilter(new ScriptExtensionsFilter(value), 2);
        } else {
            this.applyFilter(new IntPropertyFilter(prop, value), UCharacterProperty.INSTANCE.getSource(prop));
        }
        return this;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPropertyAlias(String propertyAlias, String valueAlias) {
        return this.applyPropertyAlias(propertyAlias, valueAlias, null);
    }

    /*
     * Unable to fully structure code
     */
    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPropertyAlias(String propertyAlias, String valueAlias, SymbolTable symbols) {
        block23: {
            block24: {
                block21: {
                    block22: {
                        this.checkFrozen();
                        mustNotBeEmpty = false;
                        invert = false;
                        if (symbols != null && symbols instanceof XSymbolTable && ((XSymbolTable)symbols).applyPropertyAlias(propertyAlias, valueAlias, this)) {
                            return this;
                        }
                        if (UnicodeSet.XSYMBOL_TABLE != null && UnicodeSet.XSYMBOL_TABLE.applyPropertyAlias(propertyAlias, valueAlias, this)) {
                            return this;
                        }
                        if (valueAlias.length() <= 0) break block21;
                        p = UCharacter.getPropertyEnum(propertyAlias);
                        if (p == 4101) {
                            p = 8192;
                        }
                        if (!(p >= 0 && p < 57 || p >= 4096 && p < 4118) && (p < 8192 || p >= 8193)) break block22;
                        try {
                            v = UCharacter.getPropertyValueEnum(p, valueAlias);
                        }
                        catch (IllegalArgumentException e) {
                            if (p == 4098 || p == 4112 || p == 4113) {
                                v = Integer.parseInt(PatternProps.trimWhiteSpace(valueAlias));
                                if (v >= 0 && v <= 255) ** GOTO lbl79
                                throw e;
                            }
                            throw e;
                        }
                    }
                    switch (p) {
                        case 12288: {
                            value = Double.parseDouble(PatternProps.trimWhiteSpace(valueAlias));
                            this.applyFilter(new NumericValueFilter(value), 1);
                            return this;
                        }
                        case 16389: {
                            buf = UnicodeSet.mungeCharName(valueAlias);
                            ch = UCharacter.getCharFromExtendedName(buf);
                            if (ch == -1) {
                                throw new IllegalArgumentException("Invalid character name");
                            }
                            this.clear();
                            this.add_unchecked(ch);
                            return this;
                        }
                        case 16395: {
                            throw new IllegalArgumentException("Unicode_1_Name (na1) not supported");
                        }
                        case 16384: {
                            version = VersionInfo.getInstance(UnicodeSet.mungeCharName(valueAlias));
                            this.applyFilter(new VersionFilter(version), 2);
                            return this;
                        }
                        case 28672: {
                            v = UCharacter.getPropertyValueEnum(4106, valueAlias);
                            break block23;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported property");
                        }
                    }
                }
                pnames = UPropertyAliases.INSTANCE;
                p = 8192;
                v = pnames.getPropertyValueEnum(p, propertyAlias);
                if (v != -1 || (v = pnames.getPropertyValueEnum(p = 4106, propertyAlias)) != -1) break block23;
                p = pnames.getPropertyEnum(propertyAlias);
                if (p == -1) {
                    p = -1;
                }
                if (p < 0 || p >= 57) break block24;
                v = 1;
                break block23;
            }
            if (p != -1) ** GOTO lbl78
            if (0 == UPropertyAliases.compare("ANY", propertyAlias)) {
                this.set(0, 0x10FFFF);
                return this;
            }
            if (0 == UPropertyAliases.compare("ASCII", propertyAlias)) {
                this.set(0, 127);
                return this;
            }
            if (0 == UPropertyAliases.compare("Assigned", propertyAlias)) {
                p = 8192;
                v = 1;
                invert = true;
            } else {
                throw new IllegalArgumentException("Invalid property alias: " + propertyAlias + "=" + valueAlias);
lbl78:
                // 1 sources

                throw new IllegalArgumentException("Missing property value");
            }
        }
        this.applyIntPropertyValue(p, v);
        if (invert) {
            this.complement();
        }
        if (mustNotBeEmpty && this.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value");
        }
        return this;
    }

    private static final boolean $$robo$$android_icu_text_UnicodeSet$resemblesPropertyPattern(String pattern, int pos) {
        if (pos + 5 > pattern.length()) {
            return false;
        }
        return pattern.regionMatches(pos, "[:", 0, 2) || pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2);
    }

    private static final boolean $$robo$$android_icu_text_UnicodeSet$resemblesPropertyPattern(RuleCharacterIterator chars, int iterOpts) {
        boolean result = false;
        Object pos = chars.getPos(null);
        int c = chars.next(iterOpts &= 0xFFFFFFFD);
        if (c == 91 || c == 92) {
            int d = chars.next(iterOpts & 0xFFFFFFFB);
            result = c == 91 ? d == 58 : d == 78 || d == 112 || d == 80;
        }
        chars.setPos(pos);
        return result;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$applyPropertyPattern(String pattern, ParsePosition ppos, SymbolTable symbols) {
        String valueName;
        String propName;
        int close;
        int pos = ppos.getIndex();
        if (pos + 5 > pattern.length()) {
            return null;
        }
        boolean posix = false;
        boolean isName = false;
        boolean invert = false;
        if (pattern.regionMatches(pos, "[:", 0, 2)) {
            posix = true;
            if ((pos = PatternProps.skipWhiteSpace(pattern, pos + 2)) < pattern.length() && pattern.charAt(pos) == '^') {
                ++pos;
                invert = true;
            }
        } else if (pattern.regionMatches(true, pos, "\\p", 0, 2) || pattern.regionMatches(pos, "\\N", 0, 2)) {
            char c = pattern.charAt(pos + 1);
            invert = c == 'P';
            isName = c == 'N';
            pos = PatternProps.skipWhiteSpace(pattern, pos + 2);
            if (pos == pattern.length() || pattern.charAt(pos++) != '{') {
                return null;
            }
        } else {
            return null;
        }
        if ((close = pattern.indexOf(posix ? ":]" : "}", pos)) < 0) {
            return null;
        }
        int equals = pattern.indexOf(61, pos);
        if (equals >= 0 && equals < close && !isName) {
            propName = pattern.substring(pos, equals);
            valueName = pattern.substring(equals + 1, close);
        } else {
            propName = pattern.substring(pos, close);
            valueName = "";
            if (isName) {
                valueName = propName;
                propName = "na";
            }
        }
        this.applyPropertyAlias(propName, valueName, symbols);
        if (invert) {
            this.complement();
        }
        ppos.setIndex(close + (posix ? 2 : 1));
        return this;
    }

    private final void $$robo$$android_icu_text_UnicodeSet$applyPropertyPattern(RuleCharacterIterator chars, Appendable rebuiltPat, SymbolTable symbols) {
        String patStr = chars.lookahead();
        ParsePosition pos = new ParsePosition(0);
        this.applyPropertyPattern(patStr, pos, symbols);
        if (pos.getIndex() == 0) {
            UnicodeSet.syntaxError(chars, "Invalid property pattern");
        }
        chars.jumpahead(pos.getIndex());
        UnicodeSet.append(rebuiltPat, patStr.substring(0, pos.getIndex()));
    }

    private static final void $$robo$$android_icu_text_UnicodeSet$addCaseMapping(UnicodeSet set, int result, StringBuilder full) {
        if (result >= 0) {
            if (result > 31) {
                set.add(result);
            } else {
                set.add(full.toString());
                full.setLength(0);
            }
        }
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$closeOver(int attribute) {
        this.checkFrozen();
        if ((attribute & 6) != 0) {
            UCaseProps csp = UCaseProps.INSTANCE;
            UnicodeSet foldSet = new UnicodeSet(this);
            ULocale root = ULocale.ROOT;
            if ((attribute & 2) != 0) {
                foldSet.strings.clear();
            }
            int n = this.getRangeCount();
            StringBuilder full = new StringBuilder();
            int[] locCache = new int[1];
            for (int i = 0; i < n; ++i) {
                int cp;
                int start = this.getRangeStart(i);
                int end = this.getRangeEnd(i);
                if ((attribute & 2) != 0) {
                    for (cp = start; cp <= end; ++cp) {
                        csp.addCaseClosure(cp, foldSet);
                    }
                    continue;
                }
                for (cp = start; cp <= end; ++cp) {
                    int result = csp.toFullLower(cp, null, full, root, locCache);
                    UnicodeSet.addCaseMapping(foldSet, result, full);
                    result = csp.toFullTitle(cp, null, full, root, locCache);
                    UnicodeSet.addCaseMapping(foldSet, result, full);
                    result = csp.toFullUpper(cp, null, full, root, locCache);
                    UnicodeSet.addCaseMapping(foldSet, result, full);
                    result = csp.toFullFolding(cp, full, 0);
                    UnicodeSet.addCaseMapping(foldSet, result, full);
                }
            }
            if (!this.strings.isEmpty()) {
                if ((attribute & 2) != 0) {
                    for (String s : this.strings) {
                        String str = UCharacter.foldCase(s, 0);
                        if (csp.addStringCaseClosure(str, foldSet)) continue;
                        foldSet.add(str);
                    }
                } else {
                    BreakIterator bi = BreakIterator.getWordInstance(root);
                    for (String str : this.strings) {
                        foldSet.add(UCharacter.toLowerCase(root, str));
                        foldSet.add(UCharacter.toTitleCase(root, str, bi));
                        foldSet.add(UCharacter.toUpperCase(root, str));
                        foldSet.add(UCharacter.foldCase(str, 0));
                    }
                }
            }
            this.set(foldSet);
        }
        return this;
    }

    private final boolean $$robo$$android_icu_text_UnicodeSet$isFrozen() {
        return this.bmpSet != null || this.stringSpan != null;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$freeze() {
        if (!this.isFrozen()) {
            this.buffer = null;
            if (this.list.length > this.len + 16) {
                int capacity = this.len == 0 ? 1 : this.len;
                int[] oldList = this.list;
                this.list = new int[capacity];
                int i = capacity;
                while (i-- > 0) {
                    this.list[i] = oldList[i];
                }
            }
            if (!this.strings.isEmpty()) {
                this.stringSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), 127);
            }
            if (this.stringSpan == null || !this.stringSpan.needsStringSpanUTF16()) {
                this.bmpSet = new BMPSet(this.list, this.len);
            }
        }
        return this;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$span(CharSequence s, SpanCondition spanCondition) {
        return this.span(s, 0, spanCondition);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$span(CharSequence s, int start, SpanCondition spanCondition) {
        int which;
        UnicodeSetStringSpan strSpan;
        int end = s.length();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return end;
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span(s, start, spanCondition, null);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.span(s, start, spanCondition);
        }
        if (!this.strings.isEmpty() && (strSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34)).needsStringSpanUTF16()) {
            return strSpan.span(s, start, spanCondition);
        }
        return this.spanCodePointsAndCount(s, start, spanCondition, null);
    }

    @Deprecated
    private final int $$robo$$android_icu_text_UnicodeSet$spanAndCount(CharSequence s, int start, SpanCondition spanCondition, OutputInt outCount) {
        if (outCount == null) {
            throw new IllegalArgumentException("outCount must not be null");
        }
        int end = s.length();
        if (start < 0) {
            start = 0;
        } else if (start >= end) {
            return end;
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanAndCount(s, start, spanCondition, outCount);
        }
        if (this.bmpSet != null) {
            return this.bmpSet.span(s, start, spanCondition, outCount);
        }
        if (!this.strings.isEmpty()) {
            int which = spanCondition == SpanCondition.NOT_CONTAINED ? 33 : 34;
            UnicodeSetStringSpan strSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which |= 0x40);
            return strSpan.spanAndCount(s, start, spanCondition, outCount);
        }
        return this.spanCodePointsAndCount(s, start, spanCondition, outCount);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$spanCodePointsAndCount(CharSequence s, int start, SpanCondition spanCondition, OutputInt outCount) {
        int c;
        boolean spanContained = spanCondition != SpanCondition.NOT_CONTAINED;
        int next = start;
        int length = s.length();
        int count = 0;
        while (spanContained == this.contains(c = Character.codePointAt(s, next))) {
            ++count;
            if ((next += Character.charCount(c)) < length) continue;
        }
        if (outCount != null) {
            outCount.value = count;
        }
        return next;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$spanBack(CharSequence s, SpanCondition spanCondition) {
        return this.spanBack(s, s.length(), spanCondition);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$spanBack(CharSequence s, int fromIndex, SpanCondition spanCondition) {
        int c;
        int which;
        UnicodeSetStringSpan strSpan;
        if (fromIndex <= 0) {
            return 0;
        }
        if (fromIndex > s.length()) {
            fromIndex = s.length();
        }
        if (this.bmpSet != null) {
            return this.bmpSet.spanBack(s, fromIndex, spanCondition);
        }
        if (this.stringSpan != null) {
            return this.stringSpan.spanBack(s, fromIndex, spanCondition);
        }
        if (!this.strings.isEmpty() && (strSpan = new UnicodeSetStringSpan(this, new ArrayList<String>(this.strings), which = spanCondition == SpanCondition.NOT_CONTAINED ? 17 : 18)).needsStringSpanUTF16()) {
            return strSpan.spanBack(s, fromIndex, spanCondition);
        }
        boolean spanContained = spanCondition != SpanCondition.NOT_CONTAINED;
        int prev = fromIndex;
        while (spanContained == this.contains(c = Character.codePointBefore(s, prev)) && (prev -= Character.charCount(c)) > 0) {
        }
        return prev;
    }

    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$cloneAsThawed() {
        UnicodeSet result = new UnicodeSet(this);
        if (!$assertionsDisabled && result.isFrozen()) {
            throw new AssertionError();
        }
        return result;
    }

    private final void $$robo$$android_icu_text_UnicodeSet$checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private final Iterable<EntryRange> $$robo$$android_icu_text_UnicodeSet$ranges() {
        return new EntryRangeIterable(this);
    }

    private final Iterator<String> $$robo$$android_icu_text_UnicodeSet$iterator() {
        return new UnicodeSetIterator2(this);
    }

    private final <T extends CharSequence> boolean $$robo$$android_icu_text_UnicodeSet$containsAll(Iterable<T> collection) {
        for (CharSequence o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    private final <T extends CharSequence> boolean $$robo$$android_icu_text_UnicodeSet$containsNone(Iterable<T> collection) {
        for (CharSequence o : collection) {
            if (!this.contains(o)) continue;
            return false;
        }
        return true;
    }

    private final <T extends CharSequence> boolean $$robo$$android_icu_text_UnicodeSet$containsSome(Iterable<T> collection) {
        return !this.containsNone(collection);
    }

    private final <T extends CharSequence> UnicodeSet $$robo$$android_icu_text_UnicodeSet$addAll(T ... collection) {
        this.checkFrozen();
        for (T str : collection) {
            this.add((CharSequence)str);
        }
        return this;
    }

    private final <T extends CharSequence> UnicodeSet $$robo$$android_icu_text_UnicodeSet$removeAll(Iterable<T> collection) {
        this.checkFrozen();
        for (CharSequence o : collection) {
            this.remove(o);
        }
        return this;
    }

    private final <T extends CharSequence> UnicodeSet $$robo$$android_icu_text_UnicodeSet$retainAll(Iterable<T> collection) {
        this.checkFrozen();
        UnicodeSet toRetain = new UnicodeSet();
        toRetain.addAll(collection);
        this.retainAll(toRetain);
        return this;
    }

    private final int $$robo$$android_icu_text_UnicodeSet$compareTo(UnicodeSet o) {
        return this.compareTo(o, ComparisonStyle.SHORTER_FIRST);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$compareTo(UnicodeSet o, ComparisonStyle style2) {
        int diff;
        if (style2 != ComparisonStyle.LEXICOGRAPHIC && (diff = this.size() - o.size()) != 0) {
            return diff < 0 == (style2 == ComparisonStyle.SHORTER_FIRST) ? -1 : 1;
        }
        int i = 0;
        while (true) {
            int result;
            if (0 != (result = this.list[i] - o.list[i])) {
                if (this.list[i] == 0x110000) {
                    if (this.strings.isEmpty()) {
                        return 1;
                    }
                    String item = this.strings.first();
                    return UnicodeSet.compare(item, o.list[i]);
                }
                if (o.list[i] == 0x110000) {
                    if (o.strings.isEmpty()) {
                        return -1;
                    }
                    String item = o.strings.first();
                    return -UnicodeSet.compare(item, this.list[i]);
                }
                return (i & 1) == 0 ? result : -result;
            }
            if (this.list[i] == 0x110000) break;
            ++i;
        }
        return UnicodeSet.compare(this.strings, o.strings);
    }

    private final int $$robo$$android_icu_text_UnicodeSet$compareTo(Iterable<String> other) {
        return UnicodeSet.compare(this, other);
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$compare(CharSequence string2, int codePoint) {
        return CharSequences.compare(string2, codePoint);
    }

    private static final int $$robo$$android_icu_text_UnicodeSet$compare(int codePoint, CharSequence string2) {
        return -CharSequences.compare(string2, codePoint);
    }

    private static final <T extends Comparable<T>> int $$robo$$android_icu_text_UnicodeSet$compare(Iterable<T> collection1, Iterable<T> collection2) {
        return UnicodeSet.compare(collection1.iterator(), collection2.iterator());
    }

    @Deprecated
    private static final <T extends Comparable<T>> int $$robo$$android_icu_text_UnicodeSet$compare(Iterator<T> first, Iterator<T> other) {
        Comparable item2;
        Comparable item1;
        int result;
        do {
            if (!first.hasNext()) {
                return other.hasNext() ? -1 : 0;
            }
            if (other.hasNext()) continue;
            return 1;
        } while ((result = (item1 = (Comparable)first.next()).compareTo(item2 = (Comparable)other.next())) == 0);
        return result;
    }

    private static final <T extends Comparable<T>> int $$robo$$android_icu_text_UnicodeSet$compare(Collection<T> collection1, Collection<T> collection2, ComparisonStyle style2) {
        int diff;
        if (style2 != ComparisonStyle.LEXICOGRAPHIC && (diff = collection1.size() - collection2.size()) != 0) {
            return diff < 0 == (style2 == ComparisonStyle.SHORTER_FIRST) ? -1 : 1;
        }
        return UnicodeSet.compare(collection1, collection2);
    }

    private static final <T, U extends Collection<T>> U $$robo$$android_icu_text_UnicodeSet$addAllTo(Iterable<T> source, U target) {
        for (T item : source) {
            target.add(item);
        }
        return target;
    }

    private static final <T> T[] $$robo$$android_icu_text_UnicodeSet$addAllTo(Iterable<T> source, T[] target) {
        int i = 0;
        for (T item : source) {
            target[i++] = item;
        }
        return target;
    }

    private final Collection<String> $$robo$$android_icu_text_UnicodeSet$strings() {
        return Collections.unmodifiableSortedSet(this.strings);
    }

    @Deprecated
    private static final int $$robo$$android_icu_text_UnicodeSet$getSingleCodePoint(CharSequence s) {
        return CharSequences.getSingleCodePoint(s);
    }

    @Deprecated
    private final UnicodeSet $$robo$$android_icu_text_UnicodeSet$addBridges(UnicodeSet dontCare) {
        UnicodeSet notInInput = new UnicodeSet(this).complement();
        UnicodeSetIterator it = new UnicodeSetIterator(notInInput);
        while (it.nextRange()) {
            if (it.codepoint == 0 || it.codepoint == UnicodeSetIterator.IS_STRING || it.codepointEnd == 0x10FFFF || !dontCare.contains(it.codepoint, it.codepointEnd)) continue;
            this.add(it.codepoint, it.codepointEnd);
        }
        return this;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_UnicodeSet$findIn(CharSequence value, int fromIndex, boolean findNot) {
        int cp;
        while (fromIndex < value.length() && this.contains(cp = UTF16.charAt(value, fromIndex)) == findNot) {
            fromIndex += UTF16.getCharCount(cp);
        }
        return fromIndex;
    }

    @Deprecated
    private final int $$robo$$android_icu_text_UnicodeSet$findLastIn(CharSequence value, int fromIndex, boolean findNot) {
        int cp;
        --fromIndex;
        while (fromIndex >= 0 && this.contains(cp = UTF16.charAt(value, fromIndex)) == findNot) {
            fromIndex -= UTF16.getCharCount(cp);
        }
        return fromIndex < 0 ? -1 : fromIndex;
    }

    @Deprecated
    private final String $$robo$$android_icu_text_UnicodeSet$stripFrom(CharSequence source, boolean matches) {
        StringBuilder result = new StringBuilder();
        int pos = 0;
        while (pos < source.length()) {
            int inside = this.findIn(source, pos, !matches);
            result.append(source.subSequence(pos, inside));
            pos = this.findIn(source, inside, matches);
        }
        return result.toString();
    }

    @Deprecated
    private static final XSymbolTable $$robo$$android_icu_text_UnicodeSet$getDefaultXSymbolTable() {
        return XSYMBOL_TABLE;
    }

    @Deprecated
    private static final void $$robo$$android_icu_text_UnicodeSet$setDefaultXSymbolTable(XSymbolTable xSymbolTable) {
        INCLUSIONS = null;
        XSYMBOL_TABLE = xSymbolTable;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !UnicodeSet.class.desiredAssertionStatus();
        EMPTY = new UnicodeSet().freeze();
        ALL_CODE_POINTS = new UnicodeSet(0, 0x10FFFF).freeze();
        XSYMBOL_TABLE = null;
        INCLUSIONS = null;
        NO_VERSION = VersionInfo.getInstance(0, 0, 0, 0);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__();
    }

    public UnicodeSet() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(), 0, this);
    }

    private void __constructor__(UnicodeSet unicodeSet) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(unicodeSet);
    }

    public UnicodeSet(UnicodeSet unicodeSet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(n, n2);
    }

    public UnicodeSet(int n, int n2) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(int int ), 0, this, n, n2);
    }

    private void __constructor__(int ... nArray) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(nArray);
    }

    public UnicodeSet(int ... nArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(int[] ), 0, this, nArray);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(string2);
    }

    public UnicodeSet(String string2) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(java.lang.String ), 0, this, string2);
    }

    private void __constructor__(String string2, boolean bl) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(string2, bl);
    }

    public UnicodeSet(String string2, boolean bl) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(string2, n);
    }

    public UnicodeSet(String string2, int n) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private void __constructor__(String string2, ParsePosition parsePosition, SymbolTable symbolTable) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(string2, parsePosition, symbolTable);
    }

    public UnicodeSet(String string2, ParsePosition parsePosition, SymbolTable symbolTable) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(java.lang.String java.text.ParsePosition android.icu.text.SymbolTable ), 0, this, string2, parsePosition, symbolTable);
    }

    private void __constructor__(String string2, ParsePosition parsePosition, SymbolTable symbolTable, int n) {
        this.$$robo$$android_icu_text_UnicodeSet$__constructor__(string2, parsePosition, symbolTable, n);
    }

    public UnicodeSet(String string2, ParsePosition parsePosition, SymbolTable symbolTable, int n) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet$__constructor__(java.lang.String java.text.ParsePosition android.icu.text.SymbolTable int ), 0, this, string2, parsePosition, symbolTable, n);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_icu_text_UnicodeSet$clone(), 0, this);
    }

    public UnicodeSet set(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_UnicodeSet$set(int int ), 0, this, n, n2);
    }

    public UnicodeSet set(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("set", $$robo$$android_icu_text_UnicodeSet$set(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet applyPattern(String string2) {
        return InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_UnicodeSet$applyPattern(java.lang.String ), 0, this, string2);
    }

    public UnicodeSet applyPattern(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_UnicodeSet$applyPattern(java.lang.String boolean ), 0, this, string2, bl);
    }

    public UnicodeSet applyPattern(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_UnicodeSet$applyPattern(java.lang.String int ), 0, this, string2, n);
    }

    public static boolean resemblesPattern(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resemblesPattern", $$robo$$android_icu_text_UnicodeSet$resemblesPattern(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static void appendCodePoint(Appendable appendable, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendCodePoint", $$robo$$android_icu_text_UnicodeSet$appendCodePoint(java.lang.Appendable int ), 0, (Appendable)appendable, (int)n);
    }

    private static void append(Appendable appendable, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_icu_text_UnicodeSet$append(java.lang.Appendable java.lang.CharSequence ), 0, (Appendable)appendable, (CharSequence)charSequence);
    }

    private static <T extends Appendable> T _appendToPat(T t, String string2, boolean bl) {
        return (T)InvokeDynamicSupport.bootstrapStatic("_appendToPat", $$robo$$android_icu_text_UnicodeSet$_appendToPat(T java.lang.String boolean ), 0, t, (String)string2, (boolean)bl);
    }

    private static <T extends Appendable> T _appendToPat(T t, int n, boolean bl) {
        return (T)InvokeDynamicSupport.bootstrapStatic("_appendToPat", $$robo$$android_icu_text_UnicodeSet$_appendToPat(T int boolean ), 0, t, (int)n, (boolean)bl);
    }

    @Override
    public String toPattern(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toPattern", $$robo$$android_icu_text_UnicodeSet$toPattern(boolean ), 0, this, bl);
    }

    private <T extends Appendable> T _toPattern(T t, boolean bl) {
        return (T)InvokeDynamicSupport.bootstrap("_toPattern", $$robo$$android_icu_text_UnicodeSet$_toPattern(T boolean ), 0, this, t, bl);
    }

    public StringBuffer _generatePattern(StringBuffer stringBuffer, boolean bl) {
        return InvokeDynamicSupport.bootstrap("_generatePattern", $$robo$$android_icu_text_UnicodeSet$_generatePattern(java.lang.StringBuffer boolean ), 0, this, stringBuffer, bl);
    }

    public StringBuffer _generatePattern(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("_generatePattern", $$robo$$android_icu_text_UnicodeSet$_generatePattern(java.lang.StringBuffer boolean boolean ), 0, this, stringBuffer, bl, bl2);
    }

    private <T extends Appendable> T appendNewPattern(T t, boolean bl, boolean bl2) {
        return (T)InvokeDynamicSupport.bootstrap("appendNewPattern", $$robo$$android_icu_text_UnicodeSet$appendNewPattern(T boolean boolean ), 0, this, t, bl, bl2);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_icu_text_UnicodeSet$size(), 0, this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_icu_text_UnicodeSet$isEmpty(), 0, this);
    }

    @Override
    public boolean matchesIndexValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesIndexValue", $$robo$$android_icu_text_UnicodeSet$matchesIndexValue(int ), 0, this, n);
    }

    @Override
    public int matches(Replaceable replaceable, int[] nArray, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_icu_text_UnicodeSet$matches(android.icu.text.Replaceable int[] int boolean ), 0, this, replaceable, nArray, n, bl);
    }

    private static int matchRest(Replaceable replaceable, int n, int n2, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("matchRest", $$robo$$android_icu_text_UnicodeSet$matchRest(android.icu.text.Replaceable int int java.lang.String ), 0, (Replaceable)replaceable, (int)n, (int)n2, (String)string2);
    }

    @Deprecated
    public int matchesAt(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrap("matchesAt", $$robo$$android_icu_text_UnicodeSet$matchesAt(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    private static int matchesAt(CharSequence charSequence, int n, CharSequence charSequence2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("matchesAt", $$robo$$android_icu_text_UnicodeSet$matchesAt(java.lang.CharSequence int java.lang.CharSequence ), 0, (CharSequence)charSequence, (int)n, (CharSequence)charSequence2);
    }

    @Override
    public void addMatchSetTo(UnicodeSet unicodeSet) {
        InvokeDynamicSupport.bootstrap("addMatchSetTo", $$robo$$android_icu_text_UnicodeSet$addMatchSetTo(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public int indexOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_icu_text_UnicodeSet$indexOf(int ), 0, this, n);
    }

    public int charAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("charAt", $$robo$$android_icu_text_UnicodeSet$charAt(int ), 0, this, n);
    }

    public UnicodeSet add(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_text_UnicodeSet$add(int int ), 0, this, n, n2);
    }

    public UnicodeSet addAll(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_icu_text_UnicodeSet$addAll(int int ), 0, this, n, n2);
    }

    private UnicodeSet add_unchecked(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("add_unchecked", $$robo$$android_icu_text_UnicodeSet$add_unchecked(int int ), 0, this, n, n2);
    }

    public UnicodeSet add(int n) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_text_UnicodeSet$add(int ), 0, this, n);
    }

    private UnicodeSet add_unchecked(int n) {
        return InvokeDynamicSupport.bootstrap("add_unchecked", $$robo$$android_icu_text_UnicodeSet$add_unchecked(int ), 0, this, n);
    }

    public UnicodeSet add(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_text_UnicodeSet$add(java.lang.CharSequence ), 0, this, charSequence);
    }

    private static int getSingleCP(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSingleCP", $$robo$$android_icu_text_UnicodeSet$getSingleCP(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public UnicodeSet addAll(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_icu_text_UnicodeSet$addAll(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet retainAll(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("retainAll", $$robo$$android_icu_text_UnicodeSet$retainAll(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet complementAll(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("complementAll", $$robo$$android_icu_text_UnicodeSet$complementAll(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet removeAll(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_icu_text_UnicodeSet$removeAll(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet removeAllStrings() {
        return InvokeDynamicSupport.bootstrap("removeAllStrings", $$robo$$android_icu_text_UnicodeSet$removeAllStrings(), 0, this);
    }

    public static UnicodeSet from(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_icu_text_UnicodeSet$from(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static UnicodeSet fromAll(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("fromAll", $$robo$$android_icu_text_UnicodeSet$fromAll(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public UnicodeSet retain(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("retain", $$robo$$android_icu_text_UnicodeSet$retain(int int ), 0, this, n, n2);
    }

    public UnicodeSet retain(int n) {
        return InvokeDynamicSupport.bootstrap("retain", $$robo$$android_icu_text_UnicodeSet$retain(int ), 0, this, n);
    }

    public UnicodeSet retain(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("retain", $$robo$$android_icu_text_UnicodeSet$retain(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet remove(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_UnicodeSet$remove(int int ), 0, this, n, n2);
    }

    public UnicodeSet remove(int n) {
        return InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_UnicodeSet$remove(int ), 0, this, n);
    }

    public UnicodeSet remove(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_UnicodeSet$remove(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet complement(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("complement", $$robo$$android_icu_text_UnicodeSet$complement(int int ), 0, this, n, n2);
    }

    public UnicodeSet complement(int n) {
        return InvokeDynamicSupport.bootstrap("complement", $$robo$$android_icu_text_UnicodeSet$complement(int ), 0, this, n);
    }

    public UnicodeSet complement() {
        return InvokeDynamicSupport.bootstrap("complement", $$robo$$android_icu_text_UnicodeSet$complement(), 0, this);
    }

    public UnicodeSet complement(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("complement", $$robo$$android_icu_text_UnicodeSet$complement(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public boolean contains(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet$contains(int ), 0, this, n);
    }

    private int findCodePoint(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findCodePoint", $$robo$$android_icu_text_UnicodeSet$findCodePoint(int ), 0, this, n);
    }

    public boolean contains(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet$contains(int int ), 0, this, n, n2);
    }

    public boolean contains(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet$contains(java.lang.CharSequence ), 0, this, charSequence);
    }

    public boolean containsAll(UnicodeSet unicodeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_icu_text_UnicodeSet$containsAll(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public boolean containsAll(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_icu_text_UnicodeSet$containsAll(java.lang.String ), 0, this, string2);
    }

    private boolean containsAll(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_icu_text_UnicodeSet$containsAll(java.lang.String int ), 0, this, string2, n);
    }

    @Deprecated
    public String getRegexEquivalent() {
        return InvokeDynamicSupport.bootstrap("getRegexEquivalent", $$robo$$android_icu_text_UnicodeSet$getRegexEquivalent(), 0, this);
    }

    public boolean containsNone(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsNone", $$robo$$android_icu_text_UnicodeSet$containsNone(int int ), 0, this, n, n2);
    }

    public boolean containsNone(UnicodeSet unicodeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsNone", $$robo$$android_icu_text_UnicodeSet$containsNone(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public boolean containsNone(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsNone", $$robo$$android_icu_text_UnicodeSet$containsNone(java.lang.CharSequence ), 0, this, charSequence);
    }

    public boolean containsSome(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsSome", $$robo$$android_icu_text_UnicodeSet$containsSome(int int ), 0, this, n, n2);
    }

    public boolean containsSome(UnicodeSet unicodeSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsSome", $$robo$$android_icu_text_UnicodeSet$containsSome(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public boolean containsSome(CharSequence charSequence) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsSome", $$robo$$android_icu_text_UnicodeSet$containsSome(java.lang.CharSequence ), 0, this, charSequence);
    }

    public UnicodeSet addAll(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_icu_text_UnicodeSet$addAll(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet retainAll(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("retainAll", $$robo$$android_icu_text_UnicodeSet$retainAll(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet removeAll(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_icu_text_UnicodeSet$removeAll(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet complementAll(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("complementAll", $$robo$$android_icu_text_UnicodeSet$complementAll(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public UnicodeSet clear() {
        return InvokeDynamicSupport.bootstrap("clear", $$robo$$android_icu_text_UnicodeSet$clear(), 0, this);
    }

    public int getRangeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRangeCount", $$robo$$android_icu_text_UnicodeSet$getRangeCount(), 0, this);
    }

    public int getRangeStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRangeStart", $$robo$$android_icu_text_UnicodeSet$getRangeStart(int ), 0, this, n);
    }

    public int getRangeEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRangeEnd", $$robo$$android_icu_text_UnicodeSet$getRangeEnd(int ), 0, this, n);
    }

    public UnicodeSet compact() {
        return InvokeDynamicSupport.bootstrap("compact", $$robo$$android_icu_text_UnicodeSet$compact(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_icu_text_UnicodeSet$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_icu_text_UnicodeSet$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_UnicodeSet$toString(), 0, this);
    }

    @Deprecated
    public UnicodeSet applyPattern(String string2, ParsePosition parsePosition, SymbolTable symbolTable, int n) {
        return InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_UnicodeSet$applyPattern(java.lang.String java.text.ParsePosition android.icu.text.SymbolTable int ), 0, this, string2, parsePosition, symbolTable, n);
    }

    private void applyPattern(RuleCharacterIterator ruleCharacterIterator, SymbolTable symbolTable, Appendable appendable, int n) {
        InvokeDynamicSupport.bootstrap("applyPattern", $$robo$$android_icu_text_UnicodeSet$applyPattern(android.icu.impl.RuleCharacterIterator android.icu.text.SymbolTable java.lang.Appendable int ), 0, this, ruleCharacterIterator, symbolTable, appendable, n);
    }

    private static void syntaxError(RuleCharacterIterator ruleCharacterIterator, String string2) {
        InvokeDynamicSupport.bootstrapStatic("syntaxError", $$robo$$android_icu_text_UnicodeSet$syntaxError(android.icu.impl.RuleCharacterIterator java.lang.String ), 0, (RuleCharacterIterator)ruleCharacterIterator, (String)string2);
    }

    public <T extends Collection<String>> T addAllTo(T t) {
        return (T)InvokeDynamicSupport.bootstrap("addAllTo", $$robo$$android_icu_text_UnicodeSet$addAllTo(T ), 0, this, t);
    }

    public String[] addAllTo(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("addAllTo", $$robo$$android_icu_text_UnicodeSet$addAllTo(java.lang.String[] ), 0, this, stringArray);
    }

    public static String[] toArray(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrapStatic("toArray", $$robo$$android_icu_text_UnicodeSet$toArray(android.icu.text.UnicodeSet ), 0, (UnicodeSet)unicodeSet);
    }

    public UnicodeSet add(Iterable<?> iterable) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_text_UnicodeSet$add(java.lang.Iterable<?> ), 0, this, iterable);
    }

    public UnicodeSet addAll(Iterable<?> iterable) {
        return InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_icu_text_UnicodeSet$addAll(java.lang.Iterable<?> ), 0, this, iterable);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_icu_text_UnicodeSet$ensureCapacity(int ), 0, this, n);
    }

    private void ensureBufferCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureBufferCapacity", $$robo$$android_icu_text_UnicodeSet$ensureBufferCapacity(int ), 0, this, n);
    }

    private int[] range(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("range", $$robo$$android_icu_text_UnicodeSet$range(int int ), 0, this, n, n2);
    }

    private UnicodeSet xor(int[] nArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("xor", $$robo$$android_icu_text_UnicodeSet$xor(int[] int int ), 0, this, nArray, n, n2);
    }

    private UnicodeSet add(int[] nArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_text_UnicodeSet$add(int[] int int ), 0, this, nArray, n, n2);
    }

    private UnicodeSet retain(int[] nArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("retain", $$robo$$android_icu_text_UnicodeSet$retain(int[] int int ), 0, this, nArray, n, n2);
    }

    private static int max(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("max", $$robo$$android_icu_text_UnicodeSet$max(int int ), 0, (int)n, (int)n2);
    }

    private static synchronized UnicodeSet getInclusions(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInclusions", $$robo$$android_icu_text_UnicodeSet$getInclusions(int ), 0, (int)n);
    }

    private UnicodeSet applyFilter(Filter filter, int n) {
        return InvokeDynamicSupport.bootstrap("applyFilter", $$robo$$android_icu_text_UnicodeSet$applyFilter(android.icu.text.UnicodeSet$Filter int ), 0, this, filter, n);
    }

    private static String mungeCharName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("mungeCharName", $$robo$$android_icu_text_UnicodeSet$mungeCharName(java.lang.String ), 0, (String)string2);
    }

    public UnicodeSet applyIntPropertyValue(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("applyIntPropertyValue", $$robo$$android_icu_text_UnicodeSet$applyIntPropertyValue(int int ), 0, this, n, n2);
    }

    public UnicodeSet applyPropertyAlias(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("applyPropertyAlias", $$robo$$android_icu_text_UnicodeSet$applyPropertyAlias(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public UnicodeSet applyPropertyAlias(String string2, String string3, SymbolTable symbolTable) {
        return InvokeDynamicSupport.bootstrap("applyPropertyAlias", $$robo$$android_icu_text_UnicodeSet$applyPropertyAlias(java.lang.String java.lang.String android.icu.text.SymbolTable ), 0, this, string2, string3, symbolTable);
    }

    private static boolean resemblesPropertyPattern(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resemblesPropertyPattern", $$robo$$android_icu_text_UnicodeSet$resemblesPropertyPattern(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static boolean resemblesPropertyPattern(RuleCharacterIterator ruleCharacterIterator, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resemblesPropertyPattern", $$robo$$android_icu_text_UnicodeSet$resemblesPropertyPattern(android.icu.impl.RuleCharacterIterator int ), 0, (RuleCharacterIterator)ruleCharacterIterator, (int)n);
    }

    private UnicodeSet applyPropertyPattern(String string2, ParsePosition parsePosition, SymbolTable symbolTable) {
        return InvokeDynamicSupport.bootstrap("applyPropertyPattern", $$robo$$android_icu_text_UnicodeSet$applyPropertyPattern(java.lang.String java.text.ParsePosition android.icu.text.SymbolTable ), 0, this, string2, parsePosition, symbolTable);
    }

    private void applyPropertyPattern(RuleCharacterIterator ruleCharacterIterator, Appendable appendable, SymbolTable symbolTable) {
        InvokeDynamicSupport.bootstrap("applyPropertyPattern", $$robo$$android_icu_text_UnicodeSet$applyPropertyPattern(android.icu.impl.RuleCharacterIterator java.lang.Appendable android.icu.text.SymbolTable ), 0, this, ruleCharacterIterator, appendable, symbolTable);
    }

    private static void addCaseMapping(UnicodeSet unicodeSet, int n, StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("addCaseMapping", $$robo$$android_icu_text_UnicodeSet$addCaseMapping(android.icu.text.UnicodeSet int java.lang.StringBuilder ), 0, (UnicodeSet)unicodeSet, (int)n, (StringBuilder)stringBuilder);
    }

    public UnicodeSet closeOver(int n) {
        return InvokeDynamicSupport.bootstrap("closeOver", $$robo$$android_icu_text_UnicodeSet$closeOver(int ), 0, this, n);
    }

    @Override
    public boolean isFrozen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFrozen", $$robo$$android_icu_text_UnicodeSet$isFrozen(), 0, this);
    }

    @Override
    public UnicodeSet freeze() {
        return InvokeDynamicSupport.bootstrap("freeze", $$robo$$android_icu_text_UnicodeSet$freeze(), 0, this);
    }

    public int span(CharSequence charSequence, SpanCondition spanCondition) {
        return (int)InvokeDynamicSupport.bootstrap("span", $$robo$$android_icu_text_UnicodeSet$span(java.lang.CharSequence android.icu.text.UnicodeSet$SpanCondition ), 0, this, charSequence, spanCondition);
    }

    public int span(CharSequence charSequence, int n, SpanCondition spanCondition) {
        return (int)InvokeDynamicSupport.bootstrap("span", $$robo$$android_icu_text_UnicodeSet$span(java.lang.CharSequence int android.icu.text.UnicodeSet$SpanCondition ), 0, this, charSequence, n, spanCondition);
    }

    @Deprecated
    public int spanAndCount(CharSequence charSequence, int n, SpanCondition spanCondition, OutputInt outputInt) {
        return (int)InvokeDynamicSupport.bootstrap("spanAndCount", $$robo$$android_icu_text_UnicodeSet$spanAndCount(java.lang.CharSequence int android.icu.text.UnicodeSet$SpanCondition android.icu.util.OutputInt ), 0, this, charSequence, n, spanCondition, outputInt);
    }

    private int spanCodePointsAndCount(CharSequence charSequence, int n, SpanCondition spanCondition, OutputInt outputInt) {
        return (int)InvokeDynamicSupport.bootstrap("spanCodePointsAndCount", $$robo$$android_icu_text_UnicodeSet$spanCodePointsAndCount(java.lang.CharSequence int android.icu.text.UnicodeSet$SpanCondition android.icu.util.OutputInt ), 0, this, charSequence, n, spanCondition, outputInt);
    }

    public int spanBack(CharSequence charSequence, SpanCondition spanCondition) {
        return (int)InvokeDynamicSupport.bootstrap("spanBack", $$robo$$android_icu_text_UnicodeSet$spanBack(java.lang.CharSequence android.icu.text.UnicodeSet$SpanCondition ), 0, this, charSequence, spanCondition);
    }

    public int spanBack(CharSequence charSequence, int n, SpanCondition spanCondition) {
        return (int)InvokeDynamicSupport.bootstrap("spanBack", $$robo$$android_icu_text_UnicodeSet$spanBack(java.lang.CharSequence int android.icu.text.UnicodeSet$SpanCondition ), 0, this, charSequence, n, spanCondition);
    }

    @Override
    public UnicodeSet cloneAsThawed() {
        return InvokeDynamicSupport.bootstrap("cloneAsThawed", $$robo$$android_icu_text_UnicodeSet$cloneAsThawed(), 0, this);
    }

    private void checkFrozen() {
        InvokeDynamicSupport.bootstrap("checkFrozen", $$robo$$android_icu_text_UnicodeSet$checkFrozen(), 0, this);
    }

    public Iterable<EntryRange> ranges() {
        return InvokeDynamicSupport.bootstrap("ranges", $$robo$$android_icu_text_UnicodeSet$ranges(), 0, this);
    }

    @Override
    public Iterator<String> iterator() {
        return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_UnicodeSet$iterator(), 0, this);
    }

    public <T extends CharSequence> boolean containsAll(Iterable<T> iterable) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsAll", $$robo$$android_icu_text_UnicodeSet$containsAll(java.lang.Iterable<T> ), 0, this, iterable);
    }

    public <T extends CharSequence> boolean containsNone(Iterable<T> iterable) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsNone", $$robo$$android_icu_text_UnicodeSet$containsNone(java.lang.Iterable<T> ), 0, this, iterable);
    }

    public <T extends CharSequence> boolean containsSome(Iterable<T> iterable) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsSome", $$robo$$android_icu_text_UnicodeSet$containsSome(java.lang.Iterable<T> ), 0, this, iterable);
    }

    public <T extends CharSequence> UnicodeSet addAll(T ... TArray) {
        return InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_icu_text_UnicodeSet$addAll(java.lang.CharSequence[] ), 0, this, TArray);
    }

    public <T extends CharSequence> UnicodeSet removeAll(Iterable<T> iterable) {
        return InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_icu_text_UnicodeSet$removeAll(java.lang.Iterable<T> ), 0, this, iterable);
    }

    public <T extends CharSequence> UnicodeSet retainAll(Iterable<T> iterable) {
        return InvokeDynamicSupport.bootstrap("retainAll", $$robo$$android_icu_text_UnicodeSet$retainAll(java.lang.Iterable<T> ), 0, this, iterable);
    }

    @Override
    public int compareTo(UnicodeSet unicodeSet) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_UnicodeSet$compareTo(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    public int compareTo(UnicodeSet unicodeSet, ComparisonStyle comparisonStyle) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_UnicodeSet$compareTo(android.icu.text.UnicodeSet android.icu.text.UnicodeSet$ComparisonStyle ), 0, this, unicodeSet, comparisonStyle);
    }

    @Override
    public int compareTo(Iterable<String> iterable) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_icu_text_UnicodeSet$compareTo(java.lang.Iterable<java.lang.String> ), 0, this, iterable);
    }

    public static int compare(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_UnicodeSet$compare(java.lang.CharSequence int ), 0, (CharSequence)charSequence, (int)n);
    }

    public static int compare(int n, CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_UnicodeSet$compare(int java.lang.CharSequence ), 0, (int)n, (CharSequence)charSequence);
    }

    public static <T extends Comparable<T>> int compare(Iterable<T> iterable, Iterable<T> iterable2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_UnicodeSet$compare(java.lang.Iterable<T> java.lang.Iterable<T> ), 0, iterable, iterable2);
    }

    @Deprecated
    public static <T extends Comparable<T>> int compare(Iterator<T> iterator, Iterator<T> iterator2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_UnicodeSet$compare(java.util.Iterator<T> java.util.Iterator<T> ), 0, iterator, iterator2);
    }

    public static <T extends Comparable<T>> int compare(Collection<T> collection, Collection<T> collection2, ComparisonStyle comparisonStyle) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_icu_text_UnicodeSet$compare(java.util.Collection<T> java.util.Collection<T> android.icu.text.UnicodeSet$ComparisonStyle ), 0, collection, collection2, (ComparisonStyle)comparisonStyle);
    }

    public static <T, U extends Collection<T>> U addAllTo(Iterable<T> iterable, U u) {
        return (U)InvokeDynamicSupport.bootstrapStatic("addAllTo", $$robo$$android_icu_text_UnicodeSet$addAllTo(java.lang.Iterable<T> U ), 0, iterable, u);
    }

    public static <T> T[] addAllTo(Iterable<T> iterable, T[] TArray) {
        return InvokeDynamicSupport.bootstrapStatic("addAllTo", $$robo$$android_icu_text_UnicodeSet$addAllTo(java.lang.Iterable<T> T[] ), 0, iterable, (Object[])TArray);
    }

    public Collection<String> strings() {
        return InvokeDynamicSupport.bootstrap("strings", $$robo$$android_icu_text_UnicodeSet$strings(), 0, this);
    }

    @Deprecated
    public static int getSingleCodePoint(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSingleCodePoint", $$robo$$android_icu_text_UnicodeSet$getSingleCodePoint(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    @Deprecated
    public UnicodeSet addBridges(UnicodeSet unicodeSet) {
        return InvokeDynamicSupport.bootstrap("addBridges", $$robo$$android_icu_text_UnicodeSet$addBridges(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
    }

    @Deprecated
    public int findIn(CharSequence charSequence, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("findIn", $$robo$$android_icu_text_UnicodeSet$findIn(java.lang.CharSequence int boolean ), 0, this, charSequence, n, bl);
    }

    @Deprecated
    public int findLastIn(CharSequence charSequence, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("findLastIn", $$robo$$android_icu_text_UnicodeSet$findLastIn(java.lang.CharSequence int boolean ), 0, this, charSequence, n, bl);
    }

    @Deprecated
    public String stripFrom(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("stripFrom", $$robo$$android_icu_text_UnicodeSet$stripFrom(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    @Deprecated
    public static XSymbolTable getDefaultXSymbolTable() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultXSymbolTable", $$robo$$android_icu_text_UnicodeSet$getDefaultXSymbolTable(), 0);
    }

    @Deprecated
    public static void setDefaultXSymbolTable(XSymbolTable xSymbolTable) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultXSymbolTable", $$robo$$android_icu_text_UnicodeSet$setDefaultXSymbolTable(android.icu.text.UnicodeSet$XSymbolTable ), 0, (XSymbolTable)xSymbolTable);
    }

    static {
        RobolectricInternals.classInitializing(UnicodeSet.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnicodeSet)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class SpanCondition
    extends Enum<SpanCondition> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ SpanCondition NOT_CONTAINED;
        public static /* enum */ SpanCondition CONTAINED;
        public static /* enum */ SpanCondition SIMPLE;
        public static /* enum */ SpanCondition CONDITION_COUNT;
        private static /* synthetic */ SpanCondition[] $VALUES;

        private static final SpanCondition[] $$robo$$android_icu_text_UnicodeSet_SpanCondition$values() {
            return (SpanCondition[])$VALUES.clone();
        }

        private static final SpanCondition $$robo$$android_icu_text_UnicodeSet_SpanCondition$valueOf(String name) {
            return Enum.valueOf(SpanCondition.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_UnicodeSet_SpanCondition$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NOT_CONTAINED = new SpanCondition();
            CONTAINED = new SpanCondition();
            SIMPLE = new SpanCondition();
            CONDITION_COUNT = new SpanCondition();
            $VALUES = new SpanCondition[]{NOT_CONTAINED, CONTAINED, SIMPLE, CONDITION_COUNT};
        }

        public static SpanCondition[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_UnicodeSet_SpanCondition$values(), 0);
        }

        public static SpanCondition valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UnicodeSet_SpanCondition$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_UnicodeSet_SpanCondition$__constructor__(string2, n);
        }

        private SpanCondition() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_SpanCondition$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SpanCondition.class);
        }

        public /* synthetic */ SpanCondition() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpanCondition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ComparisonStyle
    extends Enum<ComparisonStyle> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ComparisonStyle SHORTER_FIRST;
        public static /* enum */ ComparisonStyle LEXICOGRAPHIC;
        public static /* enum */ ComparisonStyle LONGER_FIRST;
        private static /* synthetic */ ComparisonStyle[] $VALUES;

        private static final ComparisonStyle[] $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$values() {
            return (ComparisonStyle[])$VALUES.clone();
        }

        private static final ComparisonStyle $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$valueOf(String name) {
            return Enum.valueOf(ComparisonStyle.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            SHORTER_FIRST = new ComparisonStyle();
            LEXICOGRAPHIC = new ComparisonStyle();
            LONGER_FIRST = new ComparisonStyle();
            $VALUES = new ComparisonStyle[]{SHORTER_FIRST, LEXICOGRAPHIC, LONGER_FIRST};
        }

        public static ComparisonStyle[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$values(), 0);
        }

        public static ComparisonStyle valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_text_UnicodeSet_ComparisonStyle$__constructor__(string2, n);
        }

        private ComparisonStyle() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_ComparisonStyle$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ComparisonStyle.class);
        }

        public /* synthetic */ ComparisonStyle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ComparisonStyle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class UnicodeSetIterator2
    implements Iterator<String> {
        public transient /* synthetic */ Object __robo_data__;
        private int[] sourceList;
        private int len;
        private int item;
        private int current;
        private int limit;
        private TreeSet<String> sourceStrings;
        private Iterator<String> stringIterator;
        private char[] buffer;

        private void $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$__constructor__(UnicodeSet source) {
            this.len = source.len - 1;
            if (this.len > 0) {
                this.sourceStrings = source.strings;
                this.sourceList = source.list;
                this.current = this.sourceList[this.item++];
                this.limit = this.sourceList[this.item++];
            } else {
                this.stringIterator = source.strings.iterator();
                this.sourceList = null;
            }
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$hasNext() {
            return this.sourceList != null || this.stringIterator.hasNext();
        }

        private final String $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$next() {
            if (this.sourceList == null) {
                return this.stringIterator.next();
            }
            int codepoint = this.current++;
            if (this.current >= this.limit) {
                if (this.item >= this.len) {
                    this.stringIterator = this.sourceStrings.iterator();
                    this.sourceList = null;
                } else {
                    this.current = this.sourceList[this.item++];
                    this.limit = this.sourceList[this.item++];
                }
            }
            if (codepoint <= 65535) {
                return String.valueOf((char)codepoint);
            }
            if (this.buffer == null) {
                this.buffer = new char[2];
            }
            int offset = codepoint - 65536;
            this.buffer[0] = (char)((offset >>> 10) + 55296);
            this.buffer[1] = (char)((offset & 0x3FF) + 56320);
            return String.valueOf(this.buffer);
        }

        private final void $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$remove() {
            throw new UnsupportedOperationException();
        }

        private void __constructor__(UnicodeSet unicodeSet) {
            this.$$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$__constructor__(unicodeSet);
        }

        UnicodeSetIterator2(UnicodeSet unicodeSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$__constructor__(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$hasNext(), 0, this);
        }

        @Override
        public String next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$next(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_UnicodeSet_UnicodeSetIterator2$remove(), 0, this);
        }

        public /* synthetic */ UnicodeSetIterator2() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnicodeSetIterator2)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EntryRangeIterator
    implements Iterator<EntryRange> {
        public transient /* synthetic */ Object __robo_data__;
        int pos;
        EntryRange result;
        /* synthetic */ UnicodeSet this$0;

        private void $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$__constructor__(UnicodeSet unicodeSet) {
            this.result = new EntryRange();
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$hasNext() {
            return this.pos < this.this$0.len - 1;
        }

        private final EntryRange $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$next() {
            if (this.pos >= this.this$0.len - 1) {
                throw new NoSuchElementException();
            }
            this.result.codepoint = this.this$0.list[this.pos++];
            this.result.codepointEnd = this.this$0.list[this.pos++] - 1;
            return this.result;
        }

        private final void $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$remove() {
            throw new UnsupportedOperationException();
        }

        private /* synthetic */ void $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$__constructor__(UnicodeSet x0, 1 x1) {
        }

        private void __constructor__(UnicodeSet unicodeSet) {
            this.$$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$__constructor__(unicodeSet);
        }

        private EntryRangeIterator(UnicodeSet unicodeSet) {
            this.this$0 = unicodeSet;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$__constructor__(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
        }

        @Override
        public boolean hasNext() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$hasNext(), 0, this);
        }

        @Override
        public EntryRange next() {
            return InvokeDynamicSupport.bootstrap("next", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$next(), 0, this);
        }

        @Override
        public void remove() {
            InvokeDynamicSupport.bootstrap("remove", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$remove(), 0, this);
        }

        private /* synthetic */ void __constructor__(UnicodeSet unicodeSet, 1 var2_2) {
            this.$$robo$$android_icu_text_UnicodeSet_EntryRangeIterator$__constructor__(unicodeSet, var2_2);
        }

        public /* synthetic */ EntryRangeIterator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryRangeIterator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class EntryRangeIterable
    implements Iterable<EntryRange> {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ UnicodeSet this$0;

        private void $$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$__constructor__(UnicodeSet unicodeSet) {
        }

        private final Iterator<EntryRange> $$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$iterator() {
            return new EntryRangeIterator(this.this$0);
        }

        private /* synthetic */ void $$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$__constructor__(UnicodeSet x0, 1 x1) {
        }

        private void __constructor__(UnicodeSet unicodeSet) {
            this.$$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$__constructor__(unicodeSet);
        }

        private EntryRangeIterable(UnicodeSet unicodeSet) {
            this.this$0 = unicodeSet;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$__constructor__(android.icu.text.UnicodeSet ), 0, this, unicodeSet);
        }

        @Override
        public Iterator<EntryRange> iterator() {
            return InvokeDynamicSupport.bootstrap("iterator", $$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$iterator(), 0, this);
        }

        private /* synthetic */ void __constructor__(UnicodeSet unicodeSet, 1 var2_2) {
            this.$$robo$$android_icu_text_UnicodeSet_EntryRangeIterable$__constructor__(unicodeSet, var2_2);
        }

        public /* synthetic */ EntryRangeIterable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryRangeIterable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class EntryRange
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int codepoint;
        public int codepointEnd;

        private void $$robo$$android_icu_text_UnicodeSet_EntryRange$__constructor__() {
        }

        private final String $$robo$$android_icu_text_UnicodeSet_EntryRange$toString() {
            StringBuilder b = new StringBuilder();
            return (this.codepoint == this.codepointEnd ? (StringBuilder)UnicodeSet._appendToPat(b, this.codepoint, false) : (StringBuilder)UnicodeSet._appendToPat(((StringBuilder)UnicodeSet._appendToPat(b, this.codepoint, false)).append('-'), this.codepointEnd, false)).toString();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_UnicodeSet_EntryRange$__constructor__();
        }

        EntryRange() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_EntryRange$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_text_UnicodeSet_EntryRange$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntryRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class XSymbolTable
    implements SymbolTable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_text_UnicodeSet_XSymbolTable$__constructor__() {
        }

        private final UnicodeMatcher $$robo$$android_icu_text_UnicodeSet_XSymbolTable$lookupMatcher(int i) {
            return null;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_XSymbolTable$applyPropertyAlias(String propertyName, String propertyValue, UnicodeSet result) {
            return false;
        }

        private final char[] $$robo$$android_icu_text_UnicodeSet_XSymbolTable$lookup(String s) {
            return null;
        }

        private final String $$robo$$android_icu_text_UnicodeSet_XSymbolTable$parseReference(String text, ParsePosition pos, int limit) {
            return null;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_text_UnicodeSet_XSymbolTable$__constructor__();
        }

        public XSymbolTable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_XSymbolTable$__constructor__(), 0, this);
        }

        @Override
        public UnicodeMatcher lookupMatcher(int n) {
            return InvokeDynamicSupport.bootstrap("lookupMatcher", $$robo$$android_icu_text_UnicodeSet_XSymbolTable$lookupMatcher(int ), 0, this, n);
        }

        public boolean applyPropertyAlias(String string2, String string3, UnicodeSet unicodeSet) {
            return (boolean)InvokeDynamicSupport.bootstrap("applyPropertyAlias", $$robo$$android_icu_text_UnicodeSet_XSymbolTable$applyPropertyAlias(java.lang.String java.lang.String android.icu.text.UnicodeSet ), 0, this, string2, string3, unicodeSet);
        }

        @Override
        public char[] lookup(String string2) {
            return InvokeDynamicSupport.bootstrap("lookup", $$robo$$android_icu_text_UnicodeSet_XSymbolTable$lookup(java.lang.String ), 0, this, string2);
        }

        @Override
        public String parseReference(String string2, ParsePosition parsePosition, int n) {
            return InvokeDynamicSupport.bootstrap("parseReference", $$robo$$android_icu_text_UnicodeSet_XSymbolTable$parseReference(java.lang.String java.text.ParsePosition int ), 0, this, string2, parsePosition, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XSymbolTable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VersionFilter
    implements Filter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        VersionInfo version;

        private void $$robo$$android_icu_text_UnicodeSet_VersionFilter$__constructor__(VersionInfo version) {
            this.version = version;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_VersionFilter$contains(int ch) {
            VersionInfo v = UCharacter.getAge(ch);
            return v != NO_VERSION && v.compareTo(this.version) <= 0;
        }

        private void __constructor__(VersionInfo versionInfo) {
            this.$$robo$$android_icu_text_UnicodeSet_VersionFilter$__constructor__(versionInfo);
        }

        VersionFilter(VersionInfo versionInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_VersionFilter$__constructor__(android.icu.util.VersionInfo ), 0, this, versionInfo);
        }

        @Override
        public boolean contains(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet_VersionFilter$contains(int ), 0, this, n);
        }

        public /* synthetic */ VersionFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VersionFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ScriptExtensionsFilter
    implements Filter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int script;

        private void $$robo$$android_icu_text_UnicodeSet_ScriptExtensionsFilter$__constructor__(int script) {
            this.script = script;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_ScriptExtensionsFilter$contains(int c) {
            return UScript.hasScript(c, this.script);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_text_UnicodeSet_ScriptExtensionsFilter$__constructor__(n);
        }

        ScriptExtensionsFilter(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_ScriptExtensionsFilter$__constructor__(int ), 0, this, n);
        }

        @Override
        public boolean contains(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet_ScriptExtensionsFilter$contains(int ), 0, this, n);
        }

        public /* synthetic */ ScriptExtensionsFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScriptExtensionsFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class IntPropertyFilter
    implements Filter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int prop;
        int value;

        private void $$robo$$android_icu_text_UnicodeSet_IntPropertyFilter$__constructor__(int prop, int value) {
            this.prop = prop;
            this.value = value;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_IntPropertyFilter$contains(int ch) {
            return UCharacter.getIntPropertyValue(ch, this.prop) == this.value;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_icu_text_UnicodeSet_IntPropertyFilter$__constructor__(n, n2);
        }

        IntPropertyFilter(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_IntPropertyFilter$__constructor__(int int ), 0, this, n, n2);
        }

        @Override
        public boolean contains(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet_IntPropertyFilter$contains(int ), 0, this, n);
        }

        public /* synthetic */ IntPropertyFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntPropertyFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class GeneralCategoryMaskFilter
    implements Filter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mask;

        private void $$robo$$android_icu_text_UnicodeSet_GeneralCategoryMaskFilter$__constructor__(int mask) {
            this.mask = mask;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_GeneralCategoryMaskFilter$contains(int ch) {
            return (1 << UCharacter.getType(ch) & this.mask) != 0;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_icu_text_UnicodeSet_GeneralCategoryMaskFilter$__constructor__(n);
        }

        GeneralCategoryMaskFilter(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_GeneralCategoryMaskFilter$__constructor__(int ), 0, this, n);
        }

        @Override
        public boolean contains(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet_GeneralCategoryMaskFilter$contains(int ), 0, this, n);
        }

        public /* synthetic */ GeneralCategoryMaskFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GeneralCategoryMaskFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NumericValueFilter
    implements Filter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        double value;

        private void $$robo$$android_icu_text_UnicodeSet_NumericValueFilter$__constructor__(double value) {
            this.value = value;
        }

        private final boolean $$robo$$android_icu_text_UnicodeSet_NumericValueFilter$contains(int ch) {
            return UCharacter.getUnicodeNumericValue(ch) == this.value;
        }

        private void __constructor__(double d) {
            this.$$robo$$android_icu_text_UnicodeSet_NumericValueFilter$__constructor__(d);
        }

        NumericValueFilter(double d) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_text_UnicodeSet_NumericValueFilter$__constructor__(double ), 0, this, d);
        }

        @Override
        public boolean contains(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_icu_text_UnicodeSet_NumericValueFilter$contains(int ), 0, this, n);
        }

        public /* synthetic */ NumericValueFilter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NumericValueFilter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface Filter
    extends InstrumentedInterface {
        public boolean contains(int var1);
    }
}

