/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.Grego;
import android.icu.util.DateTimeRule;
import android.icu.util.TimeZoneRule;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AnnualTimeZoneRule
extends TimeZoneRule
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -8870666707791230688L;
    public static int MAX_YEAR = Integer.MAX_VALUE;
    private DateTimeRule dateTimeRule;
    private int startYear;
    private int endYear;

    private void $$robo$$android_icu_util_AnnualTimeZoneRule$__constructor__(String name, int rawOffset, int dstSavings, DateTimeRule dateTimeRule, int startYear, int endYear) {
        this.dateTimeRule = dateTimeRule;
        this.startYear = startYear;
        this.endYear = endYear > Integer.MAX_VALUE ? Integer.MAX_VALUE : endYear;
    }

    private final DateTimeRule $$robo$$android_icu_util_AnnualTimeZoneRule$getRule() {
        return this.dateTimeRule;
    }

    private final int $$robo$$android_icu_util_AnnualTimeZoneRule$getStartYear() {
        return this.startYear;
    }

    private final int $$robo$$android_icu_util_AnnualTimeZoneRule$getEndYear() {
        return this.endYear;
    }

    private final Date $$robo$$android_icu_util_AnnualTimeZoneRule$getStartInYear(int year, int prevRawOffset, int prevDSTSavings) {
        long ruleDay;
        if (year < this.startYear || year > this.endYear) {
            return null;
        }
        int type = this.dateTimeRule.getDateRuleType();
        if (type == 0) {
            ruleDay = Grego.fieldsToDay(year, this.dateTimeRule.getRuleMonth(), this.dateTimeRule.getRuleDayOfMonth());
        } else {
            boolean after = true;
            if (type == 1) {
                int weeks = this.dateTimeRule.getRuleWeekInMonth();
                if (weeks > 0) {
                    ruleDay = Grego.fieldsToDay(year, this.dateTimeRule.getRuleMonth(), 1);
                    ruleDay += (long)(7 * (weeks - 1));
                } else {
                    after = false;
                    ruleDay = Grego.fieldsToDay(year, this.dateTimeRule.getRuleMonth(), Grego.monthLength(year, this.dateTimeRule.getRuleMonth()));
                    ruleDay += (long)(7 * (weeks + 1));
                }
            } else {
                int month = this.dateTimeRule.getRuleMonth();
                int dom = this.dateTimeRule.getRuleDayOfMonth();
                if (type == 3) {
                    after = false;
                    if (month == 1 && dom == 29 && !Grego.isLeapYear(year)) {
                        --dom;
                    }
                }
                ruleDay = Grego.fieldsToDay(year, month, dom);
            }
            int dow = Grego.dayOfWeek(ruleDay);
            int delta = this.dateTimeRule.getRuleDayOfWeek() - dow;
            delta = after ? (delta < 0 ? delta + 7 : delta) : (delta > 0 ? delta - 7 : delta);
            ruleDay += (long)delta;
        }
        long ruleTime = ruleDay * 86400000L + (long)this.dateTimeRule.getRuleMillisInDay();
        if (this.dateTimeRule.getTimeRuleType() != 2) {
            ruleTime -= (long)prevRawOffset;
        }
        if (this.dateTimeRule.getTimeRuleType() == 0) {
            ruleTime -= (long)prevDSTSavings;
        }
        return new Date(ruleTime);
    }

    private final Date $$robo$$android_icu_util_AnnualTimeZoneRule$getFirstStart(int prevRawOffset, int prevDSTSavings) {
        return this.getStartInYear(this.startYear, prevRawOffset, prevDSTSavings);
    }

    private final Date $$robo$$android_icu_util_AnnualTimeZoneRule$getFinalStart(int prevRawOffset, int prevDSTSavings) {
        if (this.endYear == Integer.MAX_VALUE) {
            return null;
        }
        return this.getStartInYear(this.endYear, prevRawOffset, prevDSTSavings);
    }

    private final Date $$robo$$android_icu_util_AnnualTimeZoneRule$getNextStart(long base, int prevRawOffset, int prevDSTSavings, boolean inclusive) {
        int[] fields = Grego.timeToFields(base, null);
        int year = fields[0];
        if (year < this.startYear) {
            return this.getFirstStart(prevRawOffset, prevDSTSavings);
        }
        Date d = this.getStartInYear(year, prevRawOffset, prevDSTSavings);
        if (d != null && (d.getTime() < base || !inclusive && d.getTime() == base)) {
            d = this.getStartInYear(year + 1, prevRawOffset, prevDSTSavings);
        }
        return d;
    }

    private final Date $$robo$$android_icu_util_AnnualTimeZoneRule$getPreviousStart(long base, int prevRawOffset, int prevDSTSavings, boolean inclusive) {
        int[] fields = Grego.timeToFields(base, null);
        int year = fields[0];
        if (year > this.endYear) {
            return this.getFinalStart(prevRawOffset, prevDSTSavings);
        }
        Date d = this.getStartInYear(year, prevRawOffset, prevDSTSavings);
        if (d != null && (d.getTime() > base || !inclusive && d.getTime() == base)) {
            d = this.getStartInYear(year - 1, prevRawOffset, prevDSTSavings);
        }
        return d;
    }

    private final boolean $$robo$$android_icu_util_AnnualTimeZoneRule$isEquivalentTo(TimeZoneRule other) {
        if (!(other instanceof AnnualTimeZoneRule)) {
            return false;
        }
        AnnualTimeZoneRule otherRule = (AnnualTimeZoneRule)other;
        if (this.startYear == otherRule.startYear && this.endYear == otherRule.endYear && this.dateTimeRule.equals(otherRule.dateTimeRule)) {
            return super.isEquivalentTo(other);
        }
        return false;
    }

    private final boolean $$robo$$android_icu_util_AnnualTimeZoneRule$isTransitionRule() {
        return true;
    }

    private final String $$robo$$android_icu_util_AnnualTimeZoneRule$toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append(", rule={" + this.dateTimeRule + "}");
        buf.append(", startYear=" + this.startYear);
        buf.append(", endYear=");
        if (this.endYear == Integer.MAX_VALUE) {
            buf.append("max");
        } else {
            buf.append(this.endYear);
        }
        return buf.toString();
    }

    private void __constructor__(String string2, int n, int n2, DateTimeRule dateTimeRule, int n3, int n4) {
        this.$$robo$$android_icu_util_AnnualTimeZoneRule$__constructor__(string2, n, n2, dateTimeRule, n3, n4);
    }

    public AnnualTimeZoneRule(String string2, int n, int n2, DateTimeRule dateTimeRule, int n3, int n4) {
        super(string2, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_AnnualTimeZoneRule$__constructor__(java.lang.String int int android.icu.util.DateTimeRule int int ), 0, this, string2, n, n2, dateTimeRule, n3, n4);
    }

    public DateTimeRule getRule() {
        return InvokeDynamicSupport.bootstrap("getRule", $$robo$$android_icu_util_AnnualTimeZoneRule$getRule(), 0, this);
    }

    public int getStartYear() {
        return (int)InvokeDynamicSupport.bootstrap("getStartYear", $$robo$$android_icu_util_AnnualTimeZoneRule$getStartYear(), 0, this);
    }

    public int getEndYear() {
        return (int)InvokeDynamicSupport.bootstrap("getEndYear", $$robo$$android_icu_util_AnnualTimeZoneRule$getEndYear(), 0, this);
    }

    public Date getStartInYear(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("getStartInYear", $$robo$$android_icu_util_AnnualTimeZoneRule$getStartInYear(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public Date getFirstStart(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getFirstStart", $$robo$$android_icu_util_AnnualTimeZoneRule$getFirstStart(int int ), 0, this, n, n2);
    }

    @Override
    public Date getFinalStart(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getFinalStart", $$robo$$android_icu_util_AnnualTimeZoneRule$getFinalStart(int int ), 0, this, n, n2);
    }

    @Override
    public Date getNextStart(long l, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getNextStart", $$robo$$android_icu_util_AnnualTimeZoneRule$getNextStart(long int int boolean ), 0, this, l, n, n2, bl);
    }

    @Override
    public Date getPreviousStart(long l, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPreviousStart", $$robo$$android_icu_util_AnnualTimeZoneRule$getPreviousStart(long int int boolean ), 0, this, l, n, n2, bl);
    }

    @Override
    public boolean isEquivalentTo(TimeZoneRule timeZoneRule) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEquivalentTo", $$robo$$android_icu_util_AnnualTimeZoneRule$isEquivalentTo(android.icu.util.TimeZoneRule ), 0, this, timeZoneRule);
    }

    @Override
    public boolean isTransitionRule() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionRule", $$robo$$android_icu_util_AnnualTimeZoneRule$isTransitionRule(), 0, this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_util_AnnualTimeZoneRule$toString(), 0, this);
    }

    public /* synthetic */ AnnualTimeZoneRule() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnnualTimeZoneRule)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

