/*
 * Decompiled with CFR 0.152.
 */
package android.icu.util;

import android.icu.impl.CalendarCache;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HebrewCalendar
extends Calendar
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -1952524560588825816L;
    public static int TISHRI = 0;
    public static int HESHVAN = 1;
    public static int KISLEV = 2;
    public static int TEVET = 3;
    public static int SHEVAT = 4;
    public static int ADAR_1 = 5;
    public static int ADAR = 6;
    public static int NISAN = 7;
    public static int IYAR = 8;
    public static int SIVAN = 9;
    public static int TAMUZ = 10;
    public static int AV = 11;
    public static int ELUL = 12;
    private static int[][] LIMITS;
    private static int[][] MONTH_LENGTH;
    private static int[][] MONTH_START;
    private static int[][] LEAP_MONTH_START;
    private static CalendarCache cache;
    private static long HOUR_PARTS = 1080L;
    private static long DAY_PARTS = 25920L;
    private static int MONTH_DAYS = 29;
    private static long MONTH_FRACT = 13753L;
    private static long MONTH_PARTS = 765433L;
    private static long BAHARAD = 12084L;

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__() {
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(TimeZone zone) {
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(Locale aLocale) {
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(ULocale locale) {
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(TimeZone zone, Locale aLocale) {
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(TimeZone zone, ULocale locale) {
        this.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(int year, int month, int date) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(Date date) {
        this.setTime(date);
    }

    private void $$robo$$android_icu_util_HebrewCalendar$__constructor__(int year, int month, int date, int hour, int minute, int second) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, date);
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    private final void $$robo$$android_icu_util_HebrewCalendar$add(int field, int amount) {
        switch (field) {
            case 2: {
                int month = this.get(2);
                int year = this.get(1);
                if (amount > 0) {
                    boolean acrossAdar1 = month < 5;
                    month += amount;
                    while (true) {
                        if (acrossAdar1 && month >= 5 && !HebrewCalendar.isLeapYear(year)) {
                            ++month;
                        }
                        if (month > 12) {
                            month -= 13;
                            ++year;
                            acrossAdar1 = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    boolean acrossAdar1 = month > 5;
                    month += amount;
                    while (true) {
                        if (acrossAdar1 && month <= 5 && !HebrewCalendar.isLeapYear(year)) {
                            --month;
                        }
                        if (month >= 0) break;
                        month += 13;
                        --year;
                        acrossAdar1 = true;
                    }
                }
                this.set(2, month);
                this.set(1, year);
                this.pinField(5);
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
    }

    private final void $$robo$$android_icu_util_HebrewCalendar$roll(int field, int amount) {
        switch (field) {
            case 2: {
                int month = this.get(2);
                int year = this.get(1);
                boolean leapYear = HebrewCalendar.isLeapYear(year);
                int yearLength = HebrewCalendar.monthsInYear(year);
                int newMonth = month + amount % yearLength;
                if (!leapYear) {
                    if (amount > 0 && month < 5 && newMonth >= 5) {
                        ++newMonth;
                    } else if (amount < 0 && month > 5 && newMonth <= 5) {
                        --newMonth;
                    }
                }
                this.set(2, (newMonth + 13) % 13);
                this.pinField(5);
                return;
            }
        }
        super.roll(field, amount);
    }

    private static final long $$robo$$android_icu_util_HebrewCalendar$startOfYear(int year) {
        long day = cache.get(year);
        if (day == CalendarCache.EMPTY) {
            int months = (235 * year - 234) / 19;
            long frac = (long)months * 13753L + 12084L;
            day = (long)(months * 29) + frac / 25920L;
            frac %= 25920L;
            int wd = (int)(day % 7L);
            if (wd == 2 || wd == 4 || wd == 6) {
                wd = (int)(++day % 7L);
            }
            if (wd == 1 && frac > 16404L && !HebrewCalendar.isLeapYear(year)) {
                day += 2L;
            } else if (wd == 0 && frac > 23269L && HebrewCalendar.isLeapYear(year - 1)) {
                ++day;
            }
            cache.put(year, day);
        }
        return day;
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$yearType(int year) {
        int yearLength = this.handleGetYearLength(year);
        if (yearLength > 380) {
            yearLength -= 30;
        }
        int type = 0;
        switch (yearLength) {
            case 353: {
                type = 0;
                break;
            }
            case 354: {
                type = 1;
                break;
            }
            case 355: {
                type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal year length " + yearLength + " in year " + year);
            }
        }
        return type;
    }

    @Deprecated
    private static final boolean $$robo$$android_icu_util_HebrewCalendar$isLeapYear(int year) {
        int x;
        return x >= ((x = (year * 12 + 17) % 19) < 0 ? -7 : 12);
    }

    private static final int $$robo$$android_icu_util_HebrewCalendar$monthsInYear(int year) {
        return HebrewCalendar.isLeapYear(year) ? 13 : 12;
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$handleGetMonthLength(int extendedYear, int month) {
        while (month < 0) {
            month += HebrewCalendar.monthsInYear(--extendedYear);
        }
        while (month > 12) {
            month -= HebrewCalendar.monthsInYear(extendedYear++);
        }
        switch (month) {
            case 1: 
            case 2: {
                return MONTH_LENGTH[month][this.yearType(extendedYear)];
            }
        }
        return MONTH_LENGTH[month][0];
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$handleGetYearLength(int eyear) {
        return (int)(HebrewCalendar.startOfYear(eyear + 1) - HebrewCalendar.startOfYear(eyear));
    }

    @Deprecated
    private final void $$robo$$android_icu_util_HebrewCalendar$validateField(int field) {
        if (field == 2 && !HebrewCalendar.isLeapYear(this.handleGetExtendedYear()) && this.internalGet(2) == 5) {
            throw new IllegalArgumentException("MONTH cannot be ADAR_1(5) except leap years");
        }
        super.validateField(field);
    }

    private final void $$robo$$android_icu_util_HebrewCalendar$handleComputeFields(int julianDay) {
        long d = julianDay - 347997;
        long m = d * 25920L / 765433L;
        int year = (int)((19L * m + 234L) / 235L) + 1;
        long ys = HebrewCalendar.startOfYear(year);
        int dayOfYear = (int)(d - ys);
        while (dayOfYear < 1) {
            ys = HebrewCalendar.startOfYear(--year);
            dayOfYear = (int)(d - ys);
        }
        int yearType = this.yearType(year);
        int[][] monthStart = HebrewCalendar.isLeapYear(year) ? LEAP_MONTH_START : MONTH_START;
        int month = 0;
        while (dayOfYear > monthStart[month][yearType]) {
            ++month;
        }
        int dayOfMonth = dayOfYear - monthStart[--month][yearType];
        this.internalSet(0, 0);
        this.internalSet(1, year);
        this.internalSet(19, year);
        this.internalSet(2, month);
        this.internalSet(5, dayOfMonth);
        this.internalSet(6, dayOfYear);
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    private final int $$robo$$android_icu_util_HebrewCalendar$handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        while (month < 0) {
            month += HebrewCalendar.monthsInYear(--eyear);
        }
        while (month > 12) {
            month -= HebrewCalendar.monthsInYear(eyear++);
        }
        long day = HebrewCalendar.startOfYear(eyear);
        if (month != 0) {
            day = HebrewCalendar.isLeapYear(eyear) ? (day += (long)LEAP_MONTH_START[month][this.yearType(eyear)]) : (day += (long)MONTH_START[month][this.yearType(eyear)]);
        }
        return (int)(day + 347997L);
    }

    private final String $$robo$$android_icu_util_HebrewCalendar$getType() {
        return "hebrew";
    }

    static void __staticInitializer__() {
        LIMITS = new int[][]{{0, 0, 0, 0}, {-5000000, -5000000, 5000000, 5000000}, {0, 0, 12, 12}, {1, 1, 51, 56}, new int[0], {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0]};
        MONTH_LENGTH = new int[][]{{30, 30, 30}, {29, 29, 30}, {29, 30, 30}, {29, 29, 29}, {30, 30, 30}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}, {30, 30, 30}, {29, 29, 29}};
        MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {147, 148, 149}, {176, 177, 178}, {206, 207, 208}, {235, 236, 237}, {265, 266, 267}, {294, 295, 296}, {324, 325, 326}, {353, 354, 355}};
        LEAP_MONTH_START = new int[][]{{0, 0, 0}, {30, 30, 30}, {59, 59, 60}, {88, 89, 90}, {117, 118, 119}, {147, 148, 149}, {177, 178, 179}, {206, 207, 208}, {236, 237, 238}, {265, 266, 267}, {295, 296, 297}, {324, 325, 326}, {354, 355, 356}, {383, 384, 385}};
        cache = new CalendarCache();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__();
    }

    public HebrewCalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(), 0, this);
    }

    private void __constructor__(TimeZone timeZone) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(timeZone);
    }

    public HebrewCalendar(TimeZone timeZone) {
        this(timeZone, ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(android.icu.util.TimeZone ), 0, this, timeZone);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(locale);
    }

    public HebrewCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(java.util.Locale ), 0, this, locale);
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(uLocale);
    }

    public HebrewCalendar(ULocale uLocale) {
        this(TimeZone.getDefault(), uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private void __constructor__(TimeZone timeZone, Locale locale) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(timeZone, locale);
    }

    public HebrewCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(android.icu.util.TimeZone java.util.Locale ), 0, this, timeZone, locale);
    }

    private void __constructor__(TimeZone timeZone, ULocale uLocale) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(timeZone, uLocale);
    }

    public HebrewCalendar(TimeZone timeZone, ULocale uLocale) {
        super(timeZone, uLocale);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(android.icu.util.TimeZone android.icu.util.ULocale ), 0, this, timeZone, uLocale);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(n, n2, n3);
    }

    public HebrewCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    private void __constructor__(Date date) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(date);
    }

    public HebrewCalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(java.util.Date ), 0, this, date);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_icu_util_HebrewCalendar$__constructor__(n, n2, n3, n4, n5, n6);
    }

    public HebrewCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), ULocale.getDefault(ULocale.Category.FORMAT));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_util_HebrewCalendar$__constructor__(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void add(int n, int n2) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_util_HebrewCalendar$add(int int ), 0, this, n, n2);
    }

    @Override
    public void roll(int n, int n2) {
        InvokeDynamicSupport.bootstrap("roll", $$robo$$android_icu_util_HebrewCalendar$roll(int int ), 0, this, n, n2);
    }

    private static long startOfYear(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("startOfYear", $$robo$$android_icu_util_HebrewCalendar$startOfYear(int ), 0, (int)n);
    }

    private int yearType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("yearType", $$robo$$android_icu_util_HebrewCalendar$yearType(int ), 0, this, n);
    }

    @Deprecated
    public static boolean isLeapYear(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLeapYear", $$robo$$android_icu_util_HebrewCalendar$isLeapYear(int ), 0, (int)n);
    }

    private static int monthsInYear(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("monthsInYear", $$robo$$android_icu_util_HebrewCalendar$monthsInYear(int ), 0, (int)n);
    }

    @Override
    protected int handleGetLimit(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetLimit", $$robo$$android_icu_util_HebrewCalendar$handleGetLimit(int int ), 0, this, n, n2);
    }

    @Override
    protected int handleGetMonthLength(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetMonthLength", $$robo$$android_icu_util_HebrewCalendar$handleGetMonthLength(int int ), 0, this, n, n2);
    }

    @Override
    protected int handleGetYearLength(int n) {
        return (int)InvokeDynamicSupport.bootstrap("handleGetYearLength", $$robo$$android_icu_util_HebrewCalendar$handleGetYearLength(int ), 0, this, n);
    }

    @Override
    @Deprecated
    protected void validateField(int n) {
        InvokeDynamicSupport.bootstrap("validateField", $$robo$$android_icu_util_HebrewCalendar$validateField(int ), 0, this, n);
    }

    @Override
    protected void handleComputeFields(int n) {
        InvokeDynamicSupport.bootstrap("handleComputeFields", $$robo$$android_icu_util_HebrewCalendar$handleComputeFields(int ), 0, this, n);
    }

    @Override
    protected int handleGetExtendedYear() {
        return (int)InvokeDynamicSupport.bootstrap("handleGetExtendedYear", $$robo$$android_icu_util_HebrewCalendar$handleGetExtendedYear(), 0, this);
    }

    @Override
    protected int handleComputeMonthStart(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("handleComputeMonthStart", $$robo$$android_icu_util_HebrewCalendar$handleComputeMonthStart(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_icu_util_HebrewCalendar$getType(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(HebrewCalendar.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HebrewCalendar)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

