/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputMethodSession;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputMethodWrapper";
    private static int DO_FINISH_INPUT = 60;
    private static int DO_DISPLAY_COMPLETIONS = 65;
    private static int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static int DO_UPDATE_SELECTION = 90;
    private static int DO_UPDATE_CURSOR = 95;
    private static int DO_UPDATE_CURSOR_ANCHOR_INFO = 99;
    private static int DO_APP_PRIVATE_COMMAND = 100;
    private static int DO_TOGGLE_SOFT_INPUT = 105;
    private static int DO_FINISH_SESSION = 110;
    private static int DO_VIEW_CLICKED = 115;
    HandlerCaller mCaller;
    InputMethodSession mInputMethodSession;
    InputChannel mChannel;
    ImeInputEventReceiver mReceiver;

    private void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$__constructor__(Context context, InputMethodSession inputMethodSession, InputChannel channel) {
        this.mCaller = new HandlerCaller(context, null, this, true);
        this.mInputMethodSession = inputMethodSession;
        this.mChannel = channel;
        if (channel != null) {
            this.mReceiver = new ImeInputEventReceiver(this, channel, context.getMainLooper());
        }
    }

    private final InputMethodSession $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$executeMessage(Message msg) {
        if (this.mInputMethodSession == null) {
            switch (msg.what) {
                case 90: 
                case 100: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    args.recycle();
                }
            }
            return;
        }
        switch (msg.what) {
            case 60: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 65: {
                this.mInputMethodSession.displayCompletions((CompletionInfo[])msg.obj);
                return;
            }
            case 67: {
                this.mInputMethodSession.updateExtractedText(msg.arg1, (ExtractedText)msg.obj);
                return;
            }
            case 90: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mInputMethodSession.updateSelection(args.argi1, args.argi2, args.argi3, args.argi4, args.argi5, args.argi6);
                args.recycle();
                return;
            }
            case 95: {
                this.mInputMethodSession.updateCursor((Rect)msg.obj);
                return;
            }
            case 99: {
                this.mInputMethodSession.updateCursorAnchorInfo((CursorAnchorInfo)msg.obj);
                return;
            }
            case 100: {
                SomeArgs args = (SomeArgs)msg.obj;
                this.mInputMethodSession.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                args.recycle();
                return;
            }
            case 105: {
                this.mInputMethodSession.toggleSoftInput(msg.arg1, msg.arg2);
                return;
            }
            case 110: {
                this.doFinishSession();
                return;
            }
            case 115: {
                this.mInputMethodSession.viewClicked(msg.arg1 == 1);
                return;
            }
        }
        Log.w("InputMethodWrapper", "Unhandled message code: " + msg.what);
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$doFinishSession() {
        this.mInputMethodSession = null;
        if (this.mReceiver != null) {
            this.mReceiver.dispose();
            this.mReceiver = null;
        }
        if (this.mChannel != null) {
            this.mChannel.dispose();
            this.mChannel = null;
        }
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$finishInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(60));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$displayCompletions(CompletionInfo[] completions) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(65, completions));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateExtractedText(int token, ExtractedText text) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(67, token, text));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIIIII(90, oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$viewClicked(boolean focusChanged) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(115, focusChanged ? 1 : 0));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateCursor(Rect newCursor) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(95, newCursor));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(99, cursorAnchorInfo));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(100, action, data));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$toggleSoftInput(int showFlags, int hideFlags) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageII(105, showFlags, hideFlags));
    }

    private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$finishSession() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(110));
    }

    private void __constructor__(Context context, InputMethodSession inputMethodSession, InputChannel inputChannel) {
        this.$$robo$$android_inputmethodservice_IInputMethodSessionWrapper$__constructor__(context, inputMethodSession, inputChannel);
    }

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession, InputChannel inputChannel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$__constructor__(android.content.Context android.view.inputmethod.InputMethodSession android.view.InputChannel ), 0, this, context, inputMethodSession, inputChannel);
    }

    public InputMethodSession getInternalInputMethodSession() {
        return InvokeDynamicSupport.bootstrap("getInternalInputMethodSession", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$getInternalInputMethodSession(), 0, this);
    }

    @Override
    public void executeMessage(Message message) {
        InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$executeMessage(android.os.Message ), 0, this, message);
    }

    private void doFinishSession() {
        InvokeDynamicSupport.bootstrap("doFinishSession", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$doFinishSession(), 0, this);
    }

    @Override
    public void finishInput() {
        InvokeDynamicSupport.bootstrap("finishInput", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$finishInput(), 0, this);
    }

    @Override
    public void displayCompletions(CompletionInfo[] completionInfoArray) {
        InvokeDynamicSupport.bootstrap("displayCompletions", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$displayCompletions(android.view.inputmethod.CompletionInfo[] ), 0, this, completionInfoArray);
    }

    @Override
    public void updateExtractedText(int n, ExtractedText extractedText) {
        InvokeDynamicSupport.bootstrap("updateExtractedText", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateExtractedText(int android.view.inputmethod.ExtractedText ), 0, this, n, extractedText);
    }

    @Override
    public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("updateSelection", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateSelection(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void viewClicked(boolean bl) {
        InvokeDynamicSupport.bootstrap("viewClicked", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$viewClicked(boolean ), 0, this, bl);
    }

    @Override
    public void updateCursor(Rect rect) {
        InvokeDynamicSupport.bootstrap("updateCursor", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateCursor(android.graphics.Rect ), 0, this, rect);
    }

    @Override
    public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) {
        InvokeDynamicSupport.bootstrap("updateCursorAnchorInfo", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$updateCursorAnchorInfo(android.view.inputmethod.CursorAnchorInfo ), 0, this, cursorAnchorInfo);
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("appPrivateCommand", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$appPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public void toggleSoftInput(int n, int n2) {
        InvokeDynamicSupport.bootstrap("toggleSoftInput", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$toggleSoftInput(int int ), 0, this, n, n2);
    }

    @Override
    public void finishSession() {
        InvokeDynamicSupport.bootstrap("finishSession", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper$finishSession(), 0, this);
    }

    public /* synthetic */ IInputMethodSessionWrapper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IInputMethodSessionWrapper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class ImeInputEventReceiver
    extends InputEventReceiver
    implements InputMethodSession.EventCallback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseArray<InputEvent> mPendingEvents;
        /* synthetic */ IInputMethodSessionWrapper this$0;

        private void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$__constructor__(IInputMethodSessionWrapper iInputMethodSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.mPendingEvents = new SparseArray();
        }

        private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$onInputEvent(InputEvent event) {
            if (this.this$0.mInputMethodSession == null) {
                this.finishInputEvent(event, false);
                return;
            }
            int seq = event.getSequenceNumber();
            this.mPendingEvents.put(seq, event);
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                this.this$0.mInputMethodSession.dispatchKeyEvent(seq, keyEvent, this);
            } else {
                MotionEvent motionEvent = (MotionEvent)event;
                if (motionEvent.isFromSource(4)) {
                    this.this$0.mInputMethodSession.dispatchTrackballEvent(seq, motionEvent, this);
                } else {
                    this.this$0.mInputMethodSession.dispatchGenericMotionEvent(seq, motionEvent, this);
                }
            }
        }

        private final void $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$finishedEvent(int seq, boolean handled) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index >= 0) {
                InputEvent event = this.mPendingEvents.valueAt(index);
                this.mPendingEvents.removeAt(index);
                this.finishInputEvent(event, handled);
            }
        }

        private void __constructor__(IInputMethodSessionWrapper iInputMethodSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.$$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$__constructor__(iInputMethodSessionWrapper, inputChannel, looper);
        }

        public ImeInputEventReceiver(IInputMethodSessionWrapper iInputMethodSessionWrapper, InputChannel inputChannel, Looper looper) {
            this.this$0 = iInputMethodSessionWrapper;
            super(inputChannel, looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$__constructor__(android.inputmethodservice.IInputMethodSessionWrapper android.view.InputChannel android.os.Looper ), 0, this, iInputMethodSessionWrapper, inputChannel, looper);
        }

        @Override
        public void onInputEvent(InputEvent inputEvent) {
            InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$onInputEvent(android.view.InputEvent ), 0, this, inputEvent);
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("finishedEvent", $$robo$$android_inputmethodservice_IInputMethodSessionWrapper_ImeInputEventReceiver$finishedEvent(int boolean ), 0, this, n, bl);
        }

        public /* synthetic */ ImeInputEventReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImeInputEventReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

