/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDevicePort;
import android.media.AudioFormat;
import android.os.Build;
import android.util.SparseIntArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Iterator;
import java.util.TreeSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AudioDeviceInfo
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int TYPE_UNKNOWN = 0;
    public static int TYPE_BUILTIN_EARPIECE = 1;
    public static int TYPE_BUILTIN_SPEAKER = 2;
    public static int TYPE_WIRED_HEADSET = 3;
    public static int TYPE_WIRED_HEADPHONES = 4;
    public static int TYPE_LINE_ANALOG = 5;
    public static int TYPE_LINE_DIGITAL = 6;
    public static int TYPE_BLUETOOTH_SCO = 7;
    public static int TYPE_BLUETOOTH_A2DP = 8;
    public static int TYPE_HDMI = 9;
    public static int TYPE_HDMI_ARC = 10;
    public static int TYPE_USB_DEVICE = 11;
    public static int TYPE_USB_ACCESSORY = 12;
    public static int TYPE_DOCK = 13;
    public static int TYPE_FM = 14;
    public static int TYPE_BUILTIN_MIC = 15;
    public static int TYPE_FM_TUNER = 16;
    public static int TYPE_TV_TUNER = 17;
    public static int TYPE_TELEPHONY = 18;
    public static int TYPE_AUX_LINE = 19;
    public static int TYPE_IP = 20;
    public static int TYPE_BUS = 21;
    private AudioDevicePort mPort;
    private static SparseIntArray INT_TO_EXT_DEVICE_MAPPING;
    private static SparseIntArray EXT_TO_INT_DEVICE_MAPPING;

    private void $$robo$$android_media_AudioDeviceInfo$__constructor__(AudioDevicePort port) {
        this.mPort = port;
    }

    private final int $$robo$$android_media_AudioDeviceInfo$getId() {
        return this.mPort.handle().id();
    }

    private final CharSequence $$robo$$android_media_AudioDeviceInfo$getProductName() {
        String portName = this.mPort.name();
        return portName.length() != 0 ? portName : Build.MODEL;
    }

    private final String $$robo$$android_media_AudioDeviceInfo$getAddress() {
        return this.mPort.address();
    }

    private final boolean $$robo$$android_media_AudioDeviceInfo$isSource() {
        return this.mPort.role() == 1;
    }

    private final boolean $$robo$$android_media_AudioDeviceInfo$isSink() {
        return this.mPort.role() == 2;
    }

    private final int[] $$robo$$android_media_AudioDeviceInfo$getSampleRates() {
        return this.mPort.samplingRates();
    }

    private final int[] $$robo$$android_media_AudioDeviceInfo$getChannelMasks() {
        return this.mPort.channelMasks();
    }

    private final int[] $$robo$$android_media_AudioDeviceInfo$getChannelIndexMasks() {
        return this.mPort.channelIndexMasks();
    }

    private final int[] $$robo$$android_media_AudioDeviceInfo$getChannelCounts() {
        TreeSet<Integer> countSet = new TreeSet<Integer>();
        for (int mask : this.getChannelMasks()) {
            countSet.add(this.isSink() ? AudioFormat.channelCountFromOutChannelMask(mask) : AudioFormat.channelCountFromInChannelMask(mask));
        }
        for (int index_mask : this.getChannelIndexMasks()) {
            countSet.add(Integer.bitCount(index_mask));
        }
        int[] counts = new int[countSet.size()];
        int index = 0;
        Iterator iterator = countSet.iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            counts[index++] = count;
        }
        return counts;
    }

    private final int[] $$robo$$android_media_AudioDeviceInfo$getEncodings() {
        return AudioFormat.filterPublicFormats(this.mPort.formats());
    }

    private final int $$robo$$android_media_AudioDeviceInfo$getType() {
        return INT_TO_EXT_DEVICE_MAPPING.get(this.mPort.type(), 0);
    }

    private static final int $$robo$$android_media_AudioDeviceInfo$convertDeviceTypeToInternalDevice(int deviceType) {
        return EXT_TO_INT_DEVICE_MAPPING.get(deviceType, 0);
    }

    private static final int $$robo$$android_media_AudioDeviceInfo$convertInternalDeviceToDeviceType(int intDevice) {
        return INT_TO_EXT_DEVICE_MAPPING.get(intDevice, 0);
    }

    static void __staticInitializer__() {
        INT_TO_EXT_DEVICE_MAPPING = new SparseIntArray();
        INT_TO_EXT_DEVICE_MAPPING.put(1, 1);
        INT_TO_EXT_DEVICE_MAPPING.put(2, 2);
        INT_TO_EXT_DEVICE_MAPPING.put(4, 3);
        INT_TO_EXT_DEVICE_MAPPING.put(8, 4);
        INT_TO_EXT_DEVICE_MAPPING.put(16, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(32, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(64, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(128, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(256, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(512, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(1024, 9);
        INT_TO_EXT_DEVICE_MAPPING.put(2048, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(4096, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(8192, 12);
        INT_TO_EXT_DEVICE_MAPPING.put(16384, 11);
        INT_TO_EXT_DEVICE_MAPPING.put(65536, 18);
        INT_TO_EXT_DEVICE_MAPPING.put(131072, 5);
        INT_TO_EXT_DEVICE_MAPPING.put(262144, 10);
        INT_TO_EXT_DEVICE_MAPPING.put(524288, 6);
        INT_TO_EXT_DEVICE_MAPPING.put(0x100000, 14);
        INT_TO_EXT_DEVICE_MAPPING.put(0x200000, 19);
        INT_TO_EXT_DEVICE_MAPPING.put(0x800000, 20);
        INT_TO_EXT_DEVICE_MAPPING.put(0x1000000, 21);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483644, 15);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483640, 7);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483632, 3);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483616, 9);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483584, 18);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483520, 15);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147483136, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147482624, 13);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147481600, 12);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147479552, 11);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147475456, 16);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147467264, 17);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147450880, 5);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147418112, 6);
        INT_TO_EXT_DEVICE_MAPPING.put(-2147352576, 8);
        INT_TO_EXT_DEVICE_MAPPING.put(-2146959360, 20);
        INT_TO_EXT_DEVICE_MAPPING.put(-2146435072, 21);
        EXT_TO_INT_DEVICE_MAPPING = new SparseIntArray();
        EXT_TO_INT_DEVICE_MAPPING.put(1, 1);
        EXT_TO_INT_DEVICE_MAPPING.put(2, 2);
        EXT_TO_INT_DEVICE_MAPPING.put(3, 4);
        EXT_TO_INT_DEVICE_MAPPING.put(4, 8);
        EXT_TO_INT_DEVICE_MAPPING.put(5, 131072);
        EXT_TO_INT_DEVICE_MAPPING.put(6, 524288);
        EXT_TO_INT_DEVICE_MAPPING.put(7, 16);
        EXT_TO_INT_DEVICE_MAPPING.put(8, 128);
        EXT_TO_INT_DEVICE_MAPPING.put(9, 1024);
        EXT_TO_INT_DEVICE_MAPPING.put(10, 262144);
        EXT_TO_INT_DEVICE_MAPPING.put(11, 16384);
        EXT_TO_INT_DEVICE_MAPPING.put(12, 8192);
        EXT_TO_INT_DEVICE_MAPPING.put(13, 2048);
        EXT_TO_INT_DEVICE_MAPPING.put(14, 0x100000);
        EXT_TO_INT_DEVICE_MAPPING.put(15, -2147483644);
        EXT_TO_INT_DEVICE_MAPPING.put(16, -2147475456);
        EXT_TO_INT_DEVICE_MAPPING.put(17, -2147467264);
        EXT_TO_INT_DEVICE_MAPPING.put(18, 65536);
        EXT_TO_INT_DEVICE_MAPPING.put(19, 0x200000);
        EXT_TO_INT_DEVICE_MAPPING.put(20, 0x800000);
        EXT_TO_INT_DEVICE_MAPPING.put(21, 0x1000000);
    }

    private void __constructor__(AudioDevicePort audioDevicePort) {
        this.$$robo$$android_media_AudioDeviceInfo$__constructor__(audioDevicePort);
    }

    AudioDeviceInfo(AudioDevicePort audioDevicePort) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_AudioDeviceInfo$__constructor__(android.media.AudioDevicePort ), 0, this, audioDevicePort);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_media_AudioDeviceInfo$getId(), 0, this);
    }

    public CharSequence getProductName() {
        return InvokeDynamicSupport.bootstrap("getProductName", $$robo$$android_media_AudioDeviceInfo$getProductName(), 0, this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_media_AudioDeviceInfo$getAddress(), 0, this);
    }

    public boolean isSource() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSource", $$robo$$android_media_AudioDeviceInfo$isSource(), 0, this);
    }

    public boolean isSink() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSink", $$robo$$android_media_AudioDeviceInfo$isSink(), 0, this);
    }

    public int[] getSampleRates() {
        return InvokeDynamicSupport.bootstrap("getSampleRates", $$robo$$android_media_AudioDeviceInfo$getSampleRates(), 0, this);
    }

    public int[] getChannelMasks() {
        return InvokeDynamicSupport.bootstrap("getChannelMasks", $$robo$$android_media_AudioDeviceInfo$getChannelMasks(), 0, this);
    }

    public int[] getChannelIndexMasks() {
        return InvokeDynamicSupport.bootstrap("getChannelIndexMasks", $$robo$$android_media_AudioDeviceInfo$getChannelIndexMasks(), 0, this);
    }

    public int[] getChannelCounts() {
        return InvokeDynamicSupport.bootstrap("getChannelCounts", $$robo$$android_media_AudioDeviceInfo$getChannelCounts(), 0, this);
    }

    public int[] getEncodings() {
        return InvokeDynamicSupport.bootstrap("getEncodings", $$robo$$android_media_AudioDeviceInfo$getEncodings(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_media_AudioDeviceInfo$getType(), 0, this);
    }

    public static int convertDeviceTypeToInternalDevice(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertDeviceTypeToInternalDevice", $$robo$$android_media_AudioDeviceInfo$convertDeviceTypeToInternalDevice(int ), 0, (int)n);
    }

    public static int convertInternalDeviceToDeviceType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertInternalDeviceToDeviceType", $$robo$$android_media_AudioDeviceInfo$convertInternalDeviceToDeviceType(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(AudioDeviceInfo.class);
    }

    public /* synthetic */ AudioDeviceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioDeviceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

