/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.media.MediaDataSource;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.RingtoneManager;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.BitSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaPlayer
extends PlayerBase
implements SubtitleController.Listener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean METADATA_UPDATE_ONLY = true;
    public static boolean METADATA_ALL = false;
    public static boolean APPLY_METADATA_FILTER = true;
    public static boolean BYPASS_METADATA_FILTER = false;
    private static String TAG = "MediaPlayer";
    private static String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mStreamType;
    private int mUsage;
    private boolean mBypassInterruptionPolicy;
    private static int INVOKE_ID_GET_TRACK_INFO = 1;
    private static int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static int INVOKE_ID_SELECT_TRACK = 4;
    private static int INVOKE_ID_DESELECT_TRACK = 5;
    private static int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static int INVOKE_ID_GET_SELECTED_TRACK = 7;
    public static int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static int PLAYBACK_RATE_AUDIO_MODE_RESAMPLE = 2;
    public static int PLAYBACK_RATE_AUDIO_MODE_STRETCH = 1;
    public static int PLAYBACK_RATE_AUDIO_MODE_DEFAULT = 0;
    private static int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private Vector<Pair<Integer, SubtitleTrack>> mIndexTrackPairs;
    private BitSet mInbandTrackIndices;
    public static String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    public static String MEDIA_MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    public static String MEDIA_MIMETYPE_TEXT_CEA_708 = "text/cea-708";
    private SubtitleController mSubtitleController;
    private int mSelectedSubtitleTrackIndex;
    private Vector<InputStream> mOpenSubtitleSources;
    private OnSubtitleDataListener mSubtitleDataListener;
    private static int MEDIA_NOP = 0;
    private static int MEDIA_PREPARED = 1;
    private static int MEDIA_PLAYBACK_COMPLETE = 2;
    private static int MEDIA_BUFFERING_UPDATE = 3;
    private static int MEDIA_SEEK_COMPLETE = 4;
    private static int MEDIA_SET_VIDEO_SIZE = 5;
    private static int MEDIA_STARTED = 6;
    private static int MEDIA_PAUSED = 7;
    private static int MEDIA_STOPPED = 8;
    private static int MEDIA_SKIPPED = 9;
    private static int MEDIA_TIMED_TEXT = 99;
    private static int MEDIA_ERROR = 100;
    private static int MEDIA_INFO = 200;
    private static int MEDIA_SUBTITLE_DATA = 201;
    private static int MEDIA_META_DATA = 202;
    private TimeProvider mTimeProvider;
    private OnPreparedListener mOnPreparedListener;
    private OnCompletionListener mOnCompletionListener;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnTimedTextListener mOnTimedTextListener;
    private OnSubtitleDataListener mOnSubtitleDataListener;
    private OnTimedMetaDataAvailableListener mOnTimedMetaDataAvailableListener;
    public static int MEDIA_ERROR_UNKNOWN = 1;
    public static int MEDIA_ERROR_SERVER_DIED = 100;
    public static int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static int MEDIA_ERROR_IO = -1004;
    public static int MEDIA_ERROR_MALFORMED = -1007;
    public static int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static int MEDIA_ERROR_TIMED_OUT = -110;
    public static int MEDIA_ERROR_SYSTEM = Integer.MIN_VALUE;
    private OnErrorListener mOnErrorListener;
    public static int MEDIA_INFO_UNKNOWN = 1;
    public static int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static int MEDIA_INFO_BUFFERING_START = 701;
    public static int MEDIA_INFO_BUFFERING_END = 702;
    public static int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static int MEDIA_INFO_METADATA_UPDATE = 802;
    public static int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    private OnInfoListener mOnInfoListener;

    private void $$robo$$android_media_MediaPlayer$__constructor__() {
        this.mWakeLock = null;
        this.mStreamType = Integer.MIN_VALUE;
        this.mUsage = -1;
        this.mIndexTrackPairs = new Vector();
        this.mInbandTrackIndices = new BitSet();
        this.mSelectedSubtitleTrackIndex = -1;
        this.mSubtitleDataListener = new OnSubtitleDataListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaPlayer this$0;

            private void $$robo$$android_media_MediaPlayer_2$__constructor__(MediaPlayer this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_MediaPlayer_2$onSubtitleData(MediaPlayer mp, SubtitleData data) {
                int index = data.getTrackIndex();
                Vector vector = this.this$0.mIndexTrackPairs;
                synchronized (vector) {
                    for (Pair p : this.this$0.mIndexTrackPairs) {
                        if (p.first == null || (Integer)p.first != index || p.second == null) continue;
                        SubtitleTrack track = (SubtitleTrack)p.second;
                        track.onData(data);
                    }
                }
            }

            private void __constructor__(MediaPlayer mediaPlayer) {
                this.$$robo$$android_media_MediaPlayer_2$__constructor__(mediaPlayer);
            }
            {
                this.this$0 = mediaPlayer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_2$__constructor__(android.media.MediaPlayer ), 0, this, mediaPlayer);
            }

            @Override
            public void onSubtitleData(MediaPlayer mediaPlayer, SubtitleData subtitleData) {
                InvokeDynamicSupport.bootstrap("onSubtitleData", $$robo$$android_media_MediaPlayer_2$onSubtitleData(android.media.MediaPlayer android.media.SubtitleData ), 0, this, mediaPlayer, subtitleData);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOpenSubtitleSources = new Vector();
        this.native_setup(new WeakReference<MediaPlayer>(this));
    }

    private final void $$robo$$android_media_MediaPlayer$_setVideoSurface(Surface surface) {
    }

    private final Parcel $$robo$$android_media_MediaPlayer$newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken("android.media.IMediaPlayer");
        return parcel;
    }

    private final void $$robo$$android_media_MediaPlayer$invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    private final void $$robo$$android_media_MediaPlayer$setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    private final void $$robo$$android_media_MediaPlayer$setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w("MediaPlayer", "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$setVideoScalingMode(int mode) {
        if (!this.isVideoScalingModeSupported(mode)) {
            String msg = "Scaling mode " + mode + " is not supported";
            throw new IllegalArgumentException(msg);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken("android.media.IMediaPlayer");
            request.writeInt(6);
            request.writeInt(mode);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static final MediaPlayer $$robo$$android_media_MediaPlayer$create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    private static final MediaPlayer $$robo$$android_media_MediaPlayer$create(Context context, Uri uri, SurfaceHolder holder) {
        int s = AudioSystem.newAudioSessionId();
        return MediaPlayer.create(context, uri, holder, null, s > 0 ? s : 0);
    }

    private static final MediaPlayer $$robo$$android_media_MediaPlayer$create(Context context, Uri uri, SurfaceHolder holder, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            MediaPlayer mp = new MediaPlayer();
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setAudioSessionId(audioSessionId);
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        return null;
    }

    private static final MediaPlayer $$robo$$android_media_MediaPlayer$create(Context context, int resid) {
        int s = AudioSystem.newAudioSessionId();
        return MediaPlayer.create(context, resid, null, s > 0 ? s : 0);
    }

    private static final MediaPlayer $$robo$$android_media_MediaPlayer$create(Context context, int resid, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer();
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setAudioSessionId(audioSessionId);
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d("MediaPlayer", "create failed:", ex);
        }
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        ContentResolver resolver = context.getContentResolver();
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(scheme) && "settings".equals(uri.getAuthority())) {
            int type = RingtoneManager.getDefaultType(uri);
            Uri cacheUri = RingtoneManager.getCacheForType(type);
            Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
            if (this.attemptDataSource(resolver, cacheUri)) {
                return;
            }
            if (this.attemptDataSource(resolver, actualUri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers);
        } else {
            if (this.attemptDataSource(resolver, uri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_media_MediaPlayer$attemptDataSource(ContentResolver resolver, Uri uri) {
        try (AssetFileDescriptor afd = resolver.openAssetFileDescriptor(uri, "r");){
            this.setDataSource(afd);
            boolean bl = true;
            return bl;
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            Log.w("MediaPlayer", "Couldn't open " + uri + ": " + ex);
            return false;
        }
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, null, null);
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values);
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(String path, String[] keys, String[] values) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("setDataSource failed.");
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.setDataSource(fd);
        is.close();
    }

    private final void $$robo$$android_media_MediaPlayer$nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        this._setDataSource(fd, offset, length);
    }

    private final void $$robo$$android_media_MediaPlayer$_setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$setDataSource(MediaDataSource dataSource) throws IllegalArgumentException, IllegalStateException {
        this._setDataSource(dataSource);
    }

    private final void $$robo$$android_media_MediaPlayer$_setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException, IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$prepare() throws IOException, IllegalStateException {
        this._prepare();
        this.scanInternalSubtitleTracks();
    }

    private final void $$robo$$android_media_MediaPlayer$_prepare() throws IOException, IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$prepareAsync() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$start() throws IllegalStateException {
        this.baseStart();
        this.stayAwake(true);
        this._start();
    }

    private final void $$robo$$android_media_MediaPlayer$_start() throws IllegalStateException {
    }

    private final int $$robo$$android_media_MediaPlayer$getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private final int $$robo$$android_media_MediaPlayer$_getAudioStreamType() throws IllegalStateException {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer$stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private final void $$robo$$android_media_MediaPlayer$_stop() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private final void $$robo$$android_media_MediaPlayer$_pause() throws IllegalStateException {
    }

    private final void $$robo$$android_media_MediaPlayer$setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (SystemProperties.getBoolean("audio.offload.ignore_setawake", false)) {
            Log.w("MediaPlayer", "IGNORING setWakeMode " + mode);
            return;
        }
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$android_media_MediaPlayer$setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w("MediaPlayer", "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private final void $$robo$$android_media_MediaPlayer$stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private final void $$robo$$android_media_MediaPlayer$updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    private final int $$robo$$android_media_MediaPlayer$getVideoWidth() {
        return 0;
    }

    private final int $$robo$$android_media_MediaPlayer$getVideoHeight() {
        return 0;
    }

    private final boolean $$robo$$android_media_MediaPlayer$isPlaying() {
        return false;
    }

    private final PlaybackParams $$robo$$android_media_MediaPlayer$easyPlaybackParams(float rate, int audioMode) {
        PlaybackParams params = new PlaybackParams();
        params.allowDefaults();
        switch (audioMode) {
            case 0: {
                params.setSpeed(rate).setPitch(1.0f);
                break;
            }
            case 1: {
                params.setSpeed(rate).setPitch(1.0f).setAudioFallbackMode(2);
                break;
            }
            case 2: {
                params.setSpeed(rate).setPitch(rate);
                break;
            }
            default: {
                String msg = "Audio playback mode " + audioMode + " is not supported";
                throw new IllegalArgumentException(msg);
            }
        }
        return params;
    }

    private final void $$robo$$android_media_MediaPlayer$setPlaybackParams(PlaybackParams playbackParams) {
    }

    private final PlaybackParams $$robo$$android_media_MediaPlayer$getPlaybackParams() {
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer$setSyncParams(SyncParams syncParams) {
    }

    private final SyncParams $$robo$$android_media_MediaPlayer$getSyncParams() {
        return null;
    }

    private final void $$robo$$android_media_MediaPlayer$seekTo(int n) throws IllegalStateException {
    }

    private final MediaTimestamp $$robo$$android_media_MediaPlayer$getTimestamp() {
        try {
            return new MediaTimestamp((long)this.getCurrentPosition() * 1000L, (long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System"), this.isPlaying() ? this.getPlaybackParams().getSpeed() : 0.0f);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private final int $$robo$$android_media_MediaPlayer$getCurrentPosition() {
        return 0;
    }

    private final int $$robo$$android_media_MediaPlayer$getDuration() {
        return 0;
    }

    private final Metadata $$robo$$android_media_MediaPlayer$getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    private final int $$robo$$android_media_MediaPlayer$setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    private final void $$robo$$android_media_MediaPlayer$setNextMediaPlayer(MediaPlayer mediaPlayer) {
    }

    private final void $$robo$$android_media_MediaPlayer$release() {
        this.baseRelease();
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this._release();
    }

    private final void $$robo$$android_media_MediaPlayer$_release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<Object> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.clear();
            this.mInbandTrackIndices.clear();
        }
    }

    private final void $$robo$$android_media_MediaPlayer$_reset() {
    }

    private final void $$robo$$android_media_MediaPlayer$setAudioStreamType(int streamtype) {
        this.baseUpdateAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamtype).build());
        this._setAudioStreamType(streamtype);
        this.mStreamType = streamtype;
    }

    private final void $$robo$$android_media_MediaPlayer$_setAudioStreamType(int n) {
    }

    private final boolean $$robo$$android_media_MediaPlayer$setParameter(int n, Parcel parcel) {
        return false;
    }

    private final void $$robo$$android_media_MediaPlayer$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            String msg = "Cannot set AudioAttributes to null";
            throw new IllegalArgumentException("Cannot set AudioAttributes to null");
        }
        this.baseUpdateAudioAttributes(attributes);
        this.mUsage = attributes.getUsage();
        this.mBypassInterruptionPolicy = (attributes.getAllFlags() & 0x40) != 0;
        Parcel pattributes = Parcel.obtain();
        attributes.writeToParcel(pattributes, 1);
        this.setParameter(1400, pattributes);
        pattributes.recycle();
    }

    private final void $$robo$$android_media_MediaPlayer$setLooping(boolean bl) {
    }

    private final boolean $$robo$$android_media_MediaPlayer$isLooping() {
        return false;
    }

    private final void $$robo$$android_media_MediaPlayer$setVolume(float leftVolume, float rightVolume) {
        this.baseSetVolume(leftVolume, rightVolume);
    }

    private final void $$robo$$android_media_MediaPlayer$playerSetVolume(float leftVolume, float rightVolume) {
        this._setVolume(leftVolume, rightVolume);
    }

    private final void $$robo$$android_media_MediaPlayer$_setVolume(float f, float f2) {
    }

    private final void $$robo$$android_media_MediaPlayer$setVolume(float volume) {
        this.setVolume(volume, volume);
    }

    private final void $$robo$$android_media_MediaPlayer$setAudioSessionId(int n) throws IllegalArgumentException, IllegalStateException {
    }

    private final int $$robo$$android_media_MediaPlayer$getAudioSessionId() {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer$attachAuxEffect(int n) {
    }

    private final void $$robo$$android_media_MediaPlayer$setAuxEffectSendLevel(float level) {
        this.baseSetAuxEffectSendLevel(level);
    }

    private final int $$robo$$android_media_MediaPlayer$playerSetAuxEffectSendLevel(float level) {
        this._setAuxEffectSendLevel(level);
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer$_setAuxEffectSendLevel(float f) {
    }

    private final int $$robo$$android_media_MediaPlayer$native_invoke(Parcel parcel, Parcel parcel2) {
        return 0;
    }

    private final boolean $$robo$$android_media_MediaPlayer$native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return false;
    }

    private final int $$robo$$android_media_MediaPlayer$native_setMetadataFilter(Parcel parcel) {
        return 0;
    }

    private static final void $$robo$$android_media_MediaPlayer$native_init() {
    }

    private final void $$robo$$android_media_MediaPlayer$native_setup(Object object) {
    }

    private final void $$robo$$android_media_MediaPlayer$native_finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrackInfo[] $$robo$$android_media_MediaPlayer$getTrackInfo() throws IllegalStateException {
        TrackInfo[] trackInfo = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            TrackInfo[] allTrackInfo = new TrackInfo[this.mIndexTrackPairs.size()];
            for (int i = 0; i < allTrackInfo.length; ++i) {
                Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                if (p.first != null) {
                    allTrackInfo[i] = trackInfo[(Integer)p.first];
                    continue;
                }
                SubtitleTrack track = (SubtitleTrack)p.second;
                allTrackInfo[i] = new TrackInfo(track.getTrackType(), track.getFormat());
            }
            return allTrackInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrackInfo[] $$robo$$android_media_MediaPlayer$getInbandTrackInfo() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfo[] trackInfo;
            request.writeInterfaceToken("android.media.IMediaPlayer");
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfo[] trackInfoArray = trackInfo = reply.createTypedArray(TrackInfo.CREATOR);
            return trackInfoArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static final boolean $$robo$$android_media_MediaPlayer$availableMimeTypeForExternalSource(String mimeType) {
        return "application/x-subrip".equals(mimeType);
    }

    private final void $$robo$$android_media_MediaPlayer$setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    private final synchronized void $$robo$$android_media_MediaPlayer$setSubtitleAnchor() {
        if (this.mSubtitleController == null) {
            HandlerThread thread = new HandlerThread("SetSubtitleAnchorThread");
            thread.start();
            Handler handler = new Handler(thread.getLooper());
            handler.post(new Runnable(this, thread){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ HandlerThread val$thread;
                /* synthetic */ MediaPlayer this$0;

                private void $$robo$$android_media_MediaPlayer_1$__constructor__(MediaPlayer this$0, HandlerThread handlerThread) {
                }

                private final void $$robo$$android_media_MediaPlayer_1$run() {
                    Application context = ActivityThread.currentApplication();
                    this.this$0.mSubtitleController = new SubtitleController(context, this.this$0.mTimeProvider, this.this$0);
                    this.this$0.mSubtitleController.setAnchor(new SubtitleController.Anchor(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ 1 this$1;

                        private void $$robo$$android_media_MediaPlayer_1_1$__constructor__(1 this$1) {
                        }

                        private final void $$robo$$android_media_MediaPlayer_1_1$setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
                        }

                        private final Looper $$robo$$android_media_MediaPlayer_1_1$getSubtitleLooper() {
                            return Looper.getMainLooper();
                        }

                        private void __constructor__(1 var1_1) {
                            this.$$robo$$android_media_MediaPlayer_1_1$__constructor__(var1_1);
                        }
                        {
                            this.this$1 = var1_1;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_1_1$__constructor__(android.media.MediaPlayer$1 ), 0, this, var1_1);
                        }

                        @Override
                        public void setSubtitleWidget(SubtitleTrack.RenderingWidget renderingWidget) {
                            InvokeDynamicSupport.bootstrap("setSubtitleWidget", $$robo$$android_media_MediaPlayer_1_1$setSubtitleWidget(android.media.SubtitleTrack$RenderingWidget ), 0, this, renderingWidget);
                        }

                        @Override
                        public Looper getSubtitleLooper() {
                            return InvokeDynamicSupport.bootstrap("getSubtitleLooper", $$robo$$android_media_MediaPlayer_1_1$getSubtitleLooper(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    this.val$thread.getLooper().quitSafely();
                }

                private void __constructor__(MediaPlayer mediaPlayer, HandlerThread handlerThread) {
                    this.$$robo$$android_media_MediaPlayer_1$__constructor__(mediaPlayer, handlerThread);
                }
                {
                    this.this$0 = mediaPlayer;
                    this.val$thread = handlerThread;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_1$__constructor__(android.media.MediaPlayer android.os.HandlerThread ), 0, this, mediaPlayer, handlerThread);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w("MediaPlayer", "failed to join SetSubtitleAnchorThread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (track == null) {
            return;
        }
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (Pair<Integer, SubtitleTrack> p : this.mIndexTrackPairs) {
                if (p.first == null || p.second != track) continue;
                this.mSelectedSubtitleTrackIndex = (Integer)p.first;
                break;
            }
        }
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setOnSubtitleDataListener(this.mSubtitleDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        InputStream fIs = is;
        MediaFormat fFormat = format;
        if (is != null) {
            Vector<InputStream> vector = this.mOpenSubtitleSources;
            synchronized (vector) {
                this.mOpenSubtitleSources.add(is);
            }
        } else {
            Log.w("MediaPlayer", "addSubtitleSource called with null InputStream");
        }
        this.getMediaTimeProvider();
        HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(this, fIs, fFormat, thread){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ InputStream val$fIs;
            /* synthetic */ MediaFormat val$fFormat;
            /* synthetic */ HandlerThread val$thread;
            /* synthetic */ MediaPlayer this$0;

            private void $$robo$$android_media_MediaPlayer_3$__constructor__(MediaPlayer this$0, InputStream inputStream, MediaFormat mediaFormat, HandlerThread handlerThread) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_media_MediaPlayer_3$addTrack() {
                if (this.val$fIs == null || this.this$0.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = this.this$0.mSubtitleController.addTrack(this.val$fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(this.val$fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Vector vector = this.this$0.mOpenSubtitleSources;
                synchronized (vector) {
                    this.this$0.mOpenSubtitleSources.remove(this.val$fIs);
                }
                scanner.close();
                vector = this.this$0.mIndexTrackPairs;
                synchronized (vector) {
                    this.this$0.mIndexTrackPairs.add(Pair.create(null, track));
                }
                Handler h = this.this$0.mTimeProvider.mEventHandler;
                int what = 1;
                int arg1 = 4;
                Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, contents.getBytes());
                Message m = h.obtainMessage(what, arg1, 0, trackData);
                h.sendMessage(m);
                return 803;
            }

            private final void $$robo$$android_media_MediaPlayer_3$run() {
                int res = this.addTrack();
                if (this.this$0.mEventHandler != null) {
                    Message m = this.this$0.mEventHandler.obtainMessage(200, res, 0, null);
                    this.this$0.mEventHandler.sendMessage(m);
                }
                this.val$thread.getLooper().quitSafely();
            }

            private void __constructor__(MediaPlayer mediaPlayer, InputStream inputStream, MediaFormat mediaFormat, HandlerThread handlerThread) {
                this.$$robo$$android_media_MediaPlayer_3$__constructor__(mediaPlayer, inputStream, mediaFormat, handlerThread);
            }
            {
                this.this$0 = mediaPlayer;
                this.val$fIs = inputStream;
                this.val$fFormat = mediaFormat;
                this.val$thread = handlerThread;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_3$__constructor__(android.media.MediaPlayer java.io.InputStream android.media.MediaFormat android.os.HandlerThread ), 0, this, mediaPlayer, inputStream, mediaFormat, handlerThread);
            }

            private int addTrack() {
                return (int)InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_MediaPlayer_3$addTrack(), 0, this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_MediaPlayer$scanInternalSubtitleTracks() {
        if (this.mSubtitleController == null) {
            Log.d("MediaPlayer", "setSubtitleAnchor in MediaPlayer");
            this.setSubtitleAnchor();
        }
        this.populateInbandTracks();
        if (this.mSubtitleController != null) {
            this.mSubtitleController.selectDefaultTrack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$populateInbandTracks() {
        TrackInfo[] tracks = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (int i = 0; i < tracks.length; ++i) {
                if (this.mInbandTrackIndices.get(i)) continue;
                this.mInbandTrackIndices.set(i);
                if (tracks[i].getTrackType() == 4) {
                    SubtitleTrack track = this.mSubtitleController.addTrack(tracks[i].getFormat());
                    this.mIndexTrackPairs.add(Pair.create(i, track));
                    continue;
                }
                this.mIndexTrackPairs.add(Pair.create(i, null));
            }
        }
    }

    private final void $$robo$$android_media_MediaPlayer$addTimedTextSource(String path, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException(path);
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.addTimedTextSource(fd, mimeType);
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
    }

    private final void $$robo$$android_media_MediaPlayer$addTimedTextSource(FileDescriptor fd, String mimeType) throws IllegalArgumentException, IllegalStateException {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) throws IllegalArgumentException, IllegalStateException {
        FileDescriptor fd2;
        if (!MediaPlayer.availableMimeTypeForExternalSource(mime)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mime);
        }
        try {
            fd2 = Libcore.os.dup(fd);
        }
        catch (ErrnoException ex) {
            Log.e("MediaPlayer", ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        MediaFormat fFormat = new MediaFormat();
        fFormat.setString("mime", mime);
        fFormat.setInteger("is-timed-text", 1);
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        if (!this.mSubtitleController.hasRendererFor(fFormat)) {
            Application context = ActivityThread.currentApplication();
            this.mSubtitleController.registerRenderer(new SRTRenderer(context, this.mEventHandler));
        }
        SubtitleTrack track = this.mSubtitleController.addTrack(fFormat);
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.add(Pair.create(null, track));
        }
        this.getMediaTimeProvider();
        FileDescriptor fd3 = fd2;
        long offset2 = offset;
        long length2 = length;
        HandlerThread thread = new HandlerThread("TimedTextReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(this, fd3, offset2, length2, track, thread){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FileDescriptor val$fd3;
            /* synthetic */ long val$offset2;
            /* synthetic */ long val$length2;
            /* synthetic */ SubtitleTrack val$track;
            /* synthetic */ HandlerThread val$thread;
            /* synthetic */ MediaPlayer this$0;

            private void $$robo$$android_media_MediaPlayer_4$__constructor__(MediaPlayer this$0, FileDescriptor fileDescriptor, long l, long l2, SubtitleTrack subtitleTrack, HandlerThread handlerThread) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_media_MediaPlayer_4$addTrack() {
                InputStream is = null;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int bytesToRead;
                    int bytes;
                    Libcore.os.lseek(this.val$fd3, this.val$offset2, OsConstants.SEEK_SET);
                    byte[] buffer = new byte[4096];
                    for (long total = 0L; total < this.val$length2 && (bytes = IoBridge.read(this.val$fd3, buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, this.val$length2 - total))) >= 0; total += (long)bytes) {
                        bos.write(buffer, 0, bytes);
                    }
                    Handler h = this.this$0.mTimeProvider.mEventHandler;
                    int what = 1;
                    int arg1 = 4;
                    Pair<SubtitleTrack, byte[]> trackData = Pair.create(this.val$track, bos.toByteArray());
                    Message m = h.obtainMessage(what, arg1, 0, trackData);
                    h.sendMessage(m);
                    int n = 803;
                    return n;
                }
                catch (Exception e) {
                    Log.e("MediaPlayer", e.getMessage(), e);
                    int n = 900;
                    return n;
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            Log.e("MediaPlayer", e.getMessage(), e);
                        }
                    }
                }
            }

            private final void $$robo$$android_media_MediaPlayer_4$run() {
                int res = this.addTrack();
                if (this.this$0.mEventHandler != null) {
                    Message m = this.this$0.mEventHandler.obtainMessage(200, res, 0, null);
                    this.this$0.mEventHandler.sendMessage(m);
                }
                this.val$thread.getLooper().quitSafely();
            }

            private void __constructor__(MediaPlayer mediaPlayer, FileDescriptor fileDescriptor, long l, long l2, SubtitleTrack subtitleTrack, HandlerThread handlerThread) {
                this.$$robo$$android_media_MediaPlayer_4$__constructor__(mediaPlayer, fileDescriptor, l, l2, subtitleTrack, handlerThread);
            }
            {
                this.this$0 = mediaPlayer;
                this.val$fd3 = fileDescriptor;
                this.val$offset2 = l;
                this.val$length2 = l2;
                this.val$track = subtitleTrack;
                this.val$thread = handlerThread;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_4$__constructor__(android.media.MediaPlayer java.io.FileDescriptor long long android.media.SubtitleTrack android.os.HandlerThread ), 0, this, mediaPlayer, fileDescriptor, l, l2, subtitleTrack, handlerThread);
            }

            private int addTrack() {
                return (int)InvokeDynamicSupport.bootstrap("addTrack", $$robo$$android_media_MediaPlayer_4$addTrack(), 0, this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_MediaPlayer_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int $$robo$$android_media_MediaPlayer$getSelectedTrack(int trackType) throws IllegalStateException {
        SubtitleTrack subtitleTrack;
        if (this.mSubtitleController != null && (trackType == 4 || trackType == 3) && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null) {
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.second != subtitleTrack || subtitleTrack.getTrackType() != trackType) continue;
                    return i;
                }
            }
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken("android.media.IMediaPlayer");
            request.writeInt(7);
            request.writeInt(trackType);
            this.invoke(request, reply);
            int inbandTrackIndex = reply.readInt();
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.first == null || (Integer)p.first != inbandTrackIndex) continue;
                    int n = i;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private final void $$robo$$android_media_MediaPlayer$selectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, true);
    }

    private final void $$robo$$android_media_MediaPlayer$deselectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        this.populateInbandTracks();
        Pair<Integer, SubtitleTrack> p = null;
        try {
            p = this.mIndexTrackPairs.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)p.second;
        if (track == null) {
            this.selectOrDeselectInbandTrack((Integer)p.first, select);
            return;
        }
        if (this.mSubtitleController == null) {
            return;
        }
        if (!select) {
            if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w("MediaPlayer", "trying to deselect track that was not selected");
            }
            return;
        }
        if (track.getTrackType() == 3) {
            int ttIndex = this.getSelectedTrack(3);
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                if (ttIndex >= 0 && ttIndex < this.mIndexTrackPairs.size()) {
                    Pair<Integer, SubtitleTrack> p2 = this.mIndexTrackPairs.get(ttIndex);
                    if (p2.first != null && p2.second == null) {
                        this.selectOrDeselectInbandTrack((Integer)p2.first, false);
                    }
                }
            }
        }
        this.mSubtitleController.selectTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_MediaPlayer$selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken("android.media.IMediaPlayer");
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static final int $$robo$$android_media_MediaPlayer$native_pullBatteryData(Parcel parcel) {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer$setRetransmitEndpoint(InetSocketAddress endpoint) throws IllegalStateException, IllegalArgumentException {
        int ret;
        String addrString = null;
        int port = 0;
        if (null != endpoint) {
            addrString = endpoint.getAddress().getHostAddress();
            port = endpoint.getPort();
        }
        if ((ret = this.native_setRetransmitEndpoint(addrString, port)) != 0) {
            throw new IllegalArgumentException("Illegal re-transmit endpoint; native ret " + ret);
        }
    }

    private final int $$robo$$android_media_MediaPlayer$native_setRetransmitEndpoint(String string2, int n) {
        return 0;
    }

    private final void $$robo$$android_media_MediaPlayer$finalize() {
        this.baseRelease();
        this.native_finalize();
    }

    private final MediaTimeProvider $$robo$$android_media_MediaPlayer$getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    private static final void $$robo$$android_media_MediaPlayer$postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        if (what == 200 && arg1 == 2) {
            mp.start();
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    private final void $$robo$$android_media_MediaPlayer$setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnSubtitleDataListener(OnSubtitleDataListener listener) {
        this.mOnSubtitleDataListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnTimedMetaDataAvailableListener(OnTimedMetaDataAvailableListener listener) {
        this.mOnTimedMetaDataAvailableListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    private final void $$robo$$android_media_MediaPlayer$setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    private final boolean $$robo$$android_media_MediaPlayer$isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"media_jni");
        MediaPlayer.native_init();
    }

    private void __constructor__() {
        this.$$robo$$android_media_MediaPlayer$__constructor__();
    }

    public MediaPlayer() {
        super(new AudioAttributes.Builder().build());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer$__constructor__(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_setVideoSurface$nativeBinding(Surface var1);

    private void _setVideoSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("_setVideoSurface", $$robo$$android_media_MediaPlayer$_setVideoSurface(android.view.Surface ), 1, this, surface);
    }

    public Parcel newRequest() {
        return InvokeDynamicSupport.bootstrap("newRequest", $$robo$$android_media_MediaPlayer$newRequest(), 0, this);
    }

    public void invoke(Parcel parcel, Parcel parcel2) {
        InvokeDynamicSupport.bootstrap("invoke", $$robo$$android_media_MediaPlayer$invoke(android.os.Parcel android.os.Parcel ), 0, this, parcel, parcel2);
    }

    public void setDisplay(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("setDisplay", $$robo$$android_media_MediaPlayer$setDisplay(android.view.SurfaceHolder ), 0, this, surfaceHolder);
    }

    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_media_MediaPlayer$setSurface(android.view.Surface ), 0, this, surface);
    }

    public void setVideoScalingMode(int n) {
        InvokeDynamicSupport.bootstrap("setVideoScalingMode", $$robo$$android_media_MediaPlayer$setVideoScalingMode(int ), 0, this, n);
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaPlayer$create(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder surfaceHolder) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaPlayer$create(android.content.Context android.net.Uri android.view.SurfaceHolder ), 0, (Context)context, (Uri)uri, (SurfaceHolder)surfaceHolder);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder surfaceHolder, AudioAttributes audioAttributes, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaPlayer$create(android.content.Context android.net.Uri android.view.SurfaceHolder android.media.AudioAttributes int ), 0, (Context)context, (Uri)uri, (SurfaceHolder)surfaceHolder, (AudioAttributes)audioAttributes, (int)n);
    }

    public static MediaPlayer create(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaPlayer$create(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static MediaPlayer create(Context context, int n, AudioAttributes audioAttributes, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_media_MediaPlayer$create(android.content.Context int android.media.AudioAttributes int ), 0, (Context)context, (int)n, (AudioAttributes)audioAttributes, (int)n2);
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(android.content.Context android.net.Uri ), 0, this, context, uri);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(android.content.Context android.net.Uri java.util.Map<java.lang.String, java.lang.String> ), 0, this, context, uri, map);
    }

    private boolean attemptDataSource(ContentResolver contentResolver, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("attemptDataSource", $$robo$$android_media_MediaPlayer$attemptDataSource(android.content.ContentResolver android.net.Uri ), 0, this, contentResolver, uri);
    }

    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(java.lang.String ), 0, this, string2);
    }

    public void setDataSource(String string2, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(java.lang.String java.util.Map<java.lang.String, java.lang.String> ), 0, this, string2, map);
    }

    private void setDataSource(String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(java.lang.String java.lang.String[] java.lang.String[] ), 0, this, string2, stringArray, stringArray2);
    }

    private final native /* synthetic */ void $$robo$$nativeSetDataSource$nativeBinding(IBinder var1, String var2, String[] var3, String[] var4) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private void nativeSetDataSource(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("nativeSetDataSource", $$robo$$android_media_MediaPlayer$nativeSetDataSource(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] ), 1, this, iBinder, string2, stringArray, stringArray2);
    }

    public void setDataSource(AssetFileDescriptor assetFileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(android.content.res.AssetFileDescriptor ), 0, this, assetFileDescriptor);
    }

    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    public void setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(java.io.FileDescriptor long long ), 0, this, fileDescriptor, l, l2);
    }

    private final native /* synthetic */ void $$robo$$_setDataSource$nativeBinding(FileDescriptor var1, long var2, long var4) throws IOException, IllegalArgumentException, IllegalStateException;

    private void _setDataSource(FileDescriptor fileDescriptor, long l, long l2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("_setDataSource", $$robo$$android_media_MediaPlayer$_setDataSource(java.io.FileDescriptor long long ), 1, this, fileDescriptor, l, l2);
    }

    public void setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setDataSource", $$robo$$android_media_MediaPlayer$setDataSource(android.media.MediaDataSource ), 0, this, mediaDataSource);
    }

    private final native /* synthetic */ void $$robo$$_setDataSource$nativeBinding(MediaDataSource var1) throws IllegalArgumentException, IllegalStateException;

    private void _setDataSource(MediaDataSource mediaDataSource) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("_setDataSource", $$robo$$android_media_MediaPlayer$_setDataSource(android.media.MediaDataSource ), 1, this, mediaDataSource);
    }

    public void prepare() throws IOException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_media_MediaPlayer$prepare(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_prepare$nativeBinding() throws IOException, IllegalStateException;

    private void _prepare() throws IOException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("_prepare", $$robo$$android_media_MediaPlayer$_prepare(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$prepareAsync$nativeBinding() throws IllegalStateException;

    public void prepareAsync() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("prepareAsync", $$robo$$android_media_MediaPlayer$prepareAsync(), 1, this);
    }

    public void start() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_media_MediaPlayer$start(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_start$nativeBinding() throws IllegalStateException;

    private void _start() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_start", $$robo$$android_media_MediaPlayer$_start(), 1, this);
    }

    private int getAudioStreamType() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioStreamType", $$robo$$android_media_MediaPlayer$getAudioStreamType(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$_getAudioStreamType$nativeBinding() throws IllegalStateException;

    private int _getAudioStreamType() throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("_getAudioStreamType", $$robo$$android_media_MediaPlayer$_getAudioStreamType(), 1, this);
    }

    public void stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_MediaPlayer$stop(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_stop$nativeBinding() throws IllegalStateException;

    private void _stop() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_stop", $$robo$$android_media_MediaPlayer$_stop(), 1, this);
    }

    public void pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_MediaPlayer$pause(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_pause$nativeBinding() throws IllegalStateException;

    private void _pause() throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("_pause", $$robo$$android_media_MediaPlayer$_pause(), 1, this);
    }

    public void setWakeMode(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setWakeMode", $$robo$$android_media_MediaPlayer$setWakeMode(android.content.Context int ), 0, this, context, n);
    }

    public void setScreenOnWhilePlaying(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScreenOnWhilePlaying", $$robo$$android_media_MediaPlayer$setScreenOnWhilePlaying(boolean ), 0, this, bl);
    }

    private void stayAwake(boolean bl) {
        InvokeDynamicSupport.bootstrap("stayAwake", $$robo$$android_media_MediaPlayer$stayAwake(boolean ), 0, this, bl);
    }

    private void updateSurfaceScreenOn() {
        InvokeDynamicSupport.bootstrap("updateSurfaceScreenOn", $$robo$$android_media_MediaPlayer$updateSurfaceScreenOn(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$getVideoWidth$nativeBinding();

    public int getVideoWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoWidth", $$robo$$android_media_MediaPlayer$getVideoWidth(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getVideoHeight$nativeBinding();

    public int getVideoHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoHeight", $$robo$$android_media_MediaPlayer$getVideoHeight(), 1, this);
    }

    private final native /* synthetic */ boolean $$robo$$isPlaying$nativeBinding();

    public boolean isPlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPlaying", $$robo$$android_media_MediaPlayer$isPlaying(), 1, this);
    }

    public PlaybackParams easyPlaybackParams(float f, int n) {
        return InvokeDynamicSupport.bootstrap("easyPlaybackParams", $$robo$$android_media_MediaPlayer$easyPlaybackParams(float int ), 0, this, f, n);
    }

    private final native /* synthetic */ void $$robo$$setPlaybackParams$nativeBinding(PlaybackParams var1);

    public void setPlaybackParams(PlaybackParams playbackParams) {
        InvokeDynamicSupport.bootstrap("setPlaybackParams", $$robo$$android_media_MediaPlayer$setPlaybackParams(android.media.PlaybackParams ), 1, this, playbackParams);
    }

    private final native /* synthetic */ PlaybackParams $$robo$$getPlaybackParams$nativeBinding();

    public PlaybackParams getPlaybackParams() {
        return InvokeDynamicSupport.bootstrap("getPlaybackParams", $$robo$$android_media_MediaPlayer$getPlaybackParams(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$setSyncParams$nativeBinding(SyncParams var1);

    public void setSyncParams(SyncParams syncParams) {
        InvokeDynamicSupport.bootstrap("setSyncParams", $$robo$$android_media_MediaPlayer$setSyncParams(android.media.SyncParams ), 1, this, syncParams);
    }

    private final native /* synthetic */ SyncParams $$robo$$getSyncParams$nativeBinding();

    public SyncParams getSyncParams() {
        return InvokeDynamicSupport.bootstrap("getSyncParams", $$robo$$android_media_MediaPlayer$getSyncParams(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$seekTo$nativeBinding(int var1) throws IllegalStateException;

    public void seekTo(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("seekTo", $$robo$$android_media_MediaPlayer$seekTo(int ), 1, this, n);
    }

    public MediaTimestamp getTimestamp() {
        return InvokeDynamicSupport.bootstrap("getTimestamp", $$robo$$android_media_MediaPlayer$getTimestamp(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$getCurrentPosition$nativeBinding();

    public int getCurrentPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPosition", $$robo$$android_media_MediaPlayer$getCurrentPosition(), 1, this);
    }

    private final native /* synthetic */ int $$robo$$getDuration$nativeBinding();

    public int getDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_media_MediaPlayer$getDuration(), 1, this);
    }

    public Metadata getMetadata(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getMetadata", $$robo$$android_media_MediaPlayer$getMetadata(boolean boolean ), 0, this, bl, bl2);
    }

    public int setMetadataFilter(Set<Integer> set, Set<Integer> set2) {
        return (int)InvokeDynamicSupport.bootstrap("setMetadataFilter", $$robo$$android_media_MediaPlayer$setMetadataFilter(java.util.Set<java.lang.Integer> java.util.Set<java.lang.Integer> ), 0, this, set, set2);
    }

    private final native /* synthetic */ void $$robo$$setNextMediaPlayer$nativeBinding(MediaPlayer var1);

    public void setNextMediaPlayer(MediaPlayer mediaPlayer) {
        InvokeDynamicSupport.bootstrap("setNextMediaPlayer", $$robo$$android_media_MediaPlayer$setNextMediaPlayer(android.media.MediaPlayer ), 1, this, mediaPlayer);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_MediaPlayer$release(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_release$nativeBinding();

    private void _release() {
        InvokeDynamicSupport.bootstrap("_release", $$robo$$android_media_MediaPlayer$_release(), 1, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_media_MediaPlayer$reset(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$_reset$nativeBinding();

    private void _reset() {
        InvokeDynamicSupport.bootstrap("_reset", $$robo$$android_media_MediaPlayer$_reset(), 1, this);
    }

    public void setAudioStreamType(int n) {
        InvokeDynamicSupport.bootstrap("setAudioStreamType", $$robo$$android_media_MediaPlayer$setAudioStreamType(int ), 0, this, n);
    }

    private final native /* synthetic */ void $$robo$$_setAudioStreamType$nativeBinding(int var1);

    private void _setAudioStreamType(int n) {
        InvokeDynamicSupport.bootstrap("_setAudioStreamType", $$robo$$android_media_MediaPlayer$_setAudioStreamType(int ), 1, this, n);
    }

    private final native /* synthetic */ boolean $$robo$$setParameter$nativeBinding(int var1, Parcel var2);

    private boolean setParameter(int n, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("setParameter", $$robo$$android_media_MediaPlayer$setParameter(int android.os.Parcel ), 1, this, n, parcel);
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_MediaPlayer$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    private final native /* synthetic */ void $$robo$$setLooping$nativeBinding(boolean var1);

    public void setLooping(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLooping", $$robo$$android_media_MediaPlayer$setLooping(boolean ), 1, this, bl);
    }

    private final native /* synthetic */ boolean $$robo$$isLooping$nativeBinding();

    public boolean isLooping() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLooping", $$robo$$android_media_MediaPlayer$isLooping(), 1, this);
    }

    public void setVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_MediaPlayer$setVolume(float float ), 0, this, f, f2);
    }

    @Override
    void playerSetVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("playerSetVolume", $$robo$$android_media_MediaPlayer$playerSetVolume(float float ), 0, this, f, f2);
    }

    private final native /* synthetic */ void $$robo$$_setVolume$nativeBinding(float var1, float var2);

    private void _setVolume(float f, float f2) {
        InvokeDynamicSupport.bootstrap("_setVolume", $$robo$$android_media_MediaPlayer$_setVolume(float float ), 1, this, f, f2);
    }

    public void setVolume(float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_MediaPlayer$setVolume(float ), 0, this, f);
    }

    private final native /* synthetic */ void $$robo$$setAudioSessionId$nativeBinding(int var1) throws IllegalArgumentException, IllegalStateException;

    public void setAudioSessionId(int n) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("setAudioSessionId", $$robo$$android_media_MediaPlayer$setAudioSessionId(int ), 1, this, n);
    }

    private final native /* synthetic */ int $$robo$$getAudioSessionId$nativeBinding();

    public int getAudioSessionId() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioSessionId", $$robo$$android_media_MediaPlayer$getAudioSessionId(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$attachAuxEffect$nativeBinding(int var1);

    public void attachAuxEffect(int n) {
        InvokeDynamicSupport.bootstrap("attachAuxEffect", $$robo$$android_media_MediaPlayer$attachAuxEffect(int ), 1, this, n);
    }

    public void setAuxEffectSendLevel(float f) {
        InvokeDynamicSupport.bootstrap("setAuxEffectSendLevel", $$robo$$android_media_MediaPlayer$setAuxEffectSendLevel(float ), 0, this, f);
    }

    @Override
    int playerSetAuxEffectSendLevel(float f) {
        return (int)InvokeDynamicSupport.bootstrap("playerSetAuxEffectSendLevel", $$robo$$android_media_MediaPlayer$playerSetAuxEffectSendLevel(float ), 0, this, f);
    }

    private final native /* synthetic */ void $$robo$$_setAuxEffectSendLevel$nativeBinding(float var1);

    private void _setAuxEffectSendLevel(float f) {
        InvokeDynamicSupport.bootstrap("_setAuxEffectSendLevel", $$robo$$android_media_MediaPlayer$_setAuxEffectSendLevel(float ), 1, this, f);
    }

    private final native /* synthetic */ int $$robo$$native_invoke$nativeBinding(Parcel var1, Parcel var2);

    private int native_invoke(Parcel parcel, Parcel parcel2) {
        return (int)InvokeDynamicSupport.bootstrap("native_invoke", $$robo$$android_media_MediaPlayer$native_invoke(android.os.Parcel android.os.Parcel ), 1, this, parcel, parcel2);
    }

    private final native /* synthetic */ boolean $$robo$$native_getMetadata$nativeBinding(boolean var1, boolean var2, Parcel var3);

    private boolean native_getMetadata(boolean bl, boolean bl2, Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("native_getMetadata", $$robo$$android_media_MediaPlayer$native_getMetadata(boolean boolean android.os.Parcel ), 1, this, bl, bl2, parcel);
    }

    private final native /* synthetic */ int $$robo$$native_setMetadataFilter$nativeBinding(Parcel var1);

    private int native_setMetadataFilter(Parcel parcel) {
        return (int)InvokeDynamicSupport.bootstrap("native_setMetadataFilter", $$robo$$android_media_MediaPlayer$native_setMetadataFilter(android.os.Parcel ), 1, this, parcel);
    }

    private static final native /* synthetic */ void $$robo$$native_init$nativeBinding();

    private static void native_init() {
        InvokeDynamicSupport.bootstrapStatic("native_init", $$robo$$android_media_MediaPlayer$native_init(), 1);
    }

    private final native /* synthetic */ void $$robo$$native_setup$nativeBinding(Object var1);

    private void native_setup(Object object) {
        InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_MediaPlayer$native_setup(java.lang.Object ), 1, this, object);
    }

    private final native /* synthetic */ void $$robo$$native_finalize$nativeBinding();

    private void native_finalize() {
        InvokeDynamicSupport.bootstrap("native_finalize", $$robo$$android_media_MediaPlayer$native_finalize(), 1, this);
    }

    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getTrackInfo", $$robo$$android_media_MediaPlayer$getTrackInfo(), 0, this);
    }

    private TrackInfo[] getInbandTrackInfo() throws IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getInbandTrackInfo", $$robo$$android_media_MediaPlayer$getInbandTrackInfo(), 0, this);
    }

    private static boolean availableMimeTypeForExternalSource(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("availableMimeTypeForExternalSource", $$robo$$android_media_MediaPlayer$availableMimeTypeForExternalSource(java.lang.String ), 0, (String)string2);
    }

    public void setSubtitleAnchor(SubtitleController subtitleController, SubtitleController.Anchor anchor) {
        InvokeDynamicSupport.bootstrap("setSubtitleAnchor", $$robo$$android_media_MediaPlayer$setSubtitleAnchor(android.media.SubtitleController android.media.SubtitleController$Anchor ), 0, this, subtitleController, anchor);
    }

    private synchronized void setSubtitleAnchor() {
        InvokeDynamicSupport.bootstrap("setSubtitleAnchor", $$robo$$android_media_MediaPlayer$setSubtitleAnchor(), 0, this);
    }

    @Override
    public void onSubtitleTrackSelected(SubtitleTrack subtitleTrack) {
        InvokeDynamicSupport.bootstrap("onSubtitleTrackSelected", $$robo$$android_media_MediaPlayer$onSubtitleTrackSelected(android.media.SubtitleTrack ), 0, this, subtitleTrack);
    }

    public void addSubtitleSource(InputStream inputStream, MediaFormat mediaFormat) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("addSubtitleSource", $$robo$$android_media_MediaPlayer$addSubtitleSource(java.io.InputStream android.media.MediaFormat ), 0, this, inputStream, mediaFormat);
    }

    private void scanInternalSubtitleTracks() {
        InvokeDynamicSupport.bootstrap("scanInternalSubtitleTracks", $$robo$$android_media_MediaPlayer$scanInternalSubtitleTracks(), 0, this);
    }

    private void populateInbandTracks() {
        InvokeDynamicSupport.bootstrap("populateInbandTracks", $$robo$$android_media_MediaPlayer$populateInbandTracks(), 0, this);
    }

    public void addTimedTextSource(String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer$addTimedTextSource(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void addTimedTextSource(Context context, Uri uri, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer$addTimedTextSource(android.content.Context android.net.Uri java.lang.String ), 0, this, context, uri, string2);
    }

    public void addTimedTextSource(FileDescriptor fileDescriptor, String string2) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer$addTimedTextSource(java.io.FileDescriptor java.lang.String ), 0, this, fileDescriptor, string2);
    }

    public void addTimedTextSource(FileDescriptor fileDescriptor, long l, long l2, String string2) throws IllegalArgumentException, IllegalStateException {
        InvokeDynamicSupport.bootstrap("addTimedTextSource", $$robo$$android_media_MediaPlayer$addTimedTextSource(java.io.FileDescriptor long long java.lang.String ), 0, this, fileDescriptor, l, l2, string2);
    }

    public int getSelectedTrack(int n) throws IllegalStateException {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedTrack", $$robo$$android_media_MediaPlayer$getSelectedTrack(int ), 0, this, n);
    }

    public void selectTrack(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("selectTrack", $$robo$$android_media_MediaPlayer$selectTrack(int ), 0, this, n);
    }

    public void deselectTrack(int n) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("deselectTrack", $$robo$$android_media_MediaPlayer$deselectTrack(int ), 0, this, n);
    }

    private void selectOrDeselectTrack(int n, boolean bl) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("selectOrDeselectTrack", $$robo$$android_media_MediaPlayer$selectOrDeselectTrack(int boolean ), 0, this, n, bl);
    }

    private void selectOrDeselectInbandTrack(int n, boolean bl) throws IllegalStateException {
        InvokeDynamicSupport.bootstrap("selectOrDeselectInbandTrack", $$robo$$android_media_MediaPlayer$selectOrDeselectInbandTrack(int boolean ), 0, this, n, bl);
    }

    private static final native /* synthetic */ int $$robo$$native_pullBatteryData$nativeBinding(Parcel var0);

    public static int native_pullBatteryData(Parcel parcel) {
        return (int)InvokeDynamicSupport.bootstrapStatic("native_pullBatteryData", $$robo$$android_media_MediaPlayer$native_pullBatteryData(android.os.Parcel ), 1, (Parcel)parcel);
    }

    public void setRetransmitEndpoint(InetSocketAddress inetSocketAddress) throws IllegalStateException, IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setRetransmitEndpoint", $$robo$$android_media_MediaPlayer$setRetransmitEndpoint(java.net.InetSocketAddress ), 0, this, inetSocketAddress);
    }

    private final native /* synthetic */ int $$robo$$native_setRetransmitEndpoint$nativeBinding(String var1, int var2);

    private int native_setRetransmitEndpoint(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("native_setRetransmitEndpoint", $$robo$$android_media_MediaPlayer$native_setRetransmitEndpoint(java.lang.String int ), 1, this, string2, n);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaPlayer$finalize(), 0, this);
    }

    public MediaTimeProvider getMediaTimeProvider() {
        return InvokeDynamicSupport.bootstrap("getMediaTimeProvider", $$robo$$android_media_MediaPlayer$getMediaTimeProvider(), 0, this);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_MediaPlayer$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        InvokeDynamicSupport.bootstrap("setOnPreparedListener", $$robo$$android_media_MediaPlayer$setOnPreparedListener(android.media.MediaPlayer$OnPreparedListener ), 0, this, onPreparedListener);
    }

    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        InvokeDynamicSupport.bootstrap("setOnCompletionListener", $$robo$$android_media_MediaPlayer$setOnCompletionListener(android.media.MediaPlayer$OnCompletionListener ), 0, this, onCompletionListener);
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener onBufferingUpdateListener) {
        InvokeDynamicSupport.bootstrap("setOnBufferingUpdateListener", $$robo$$android_media_MediaPlayer$setOnBufferingUpdateListener(android.media.MediaPlayer$OnBufferingUpdateListener ), 0, this, onBufferingUpdateListener);
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener onSeekCompleteListener) {
        InvokeDynamicSupport.bootstrap("setOnSeekCompleteListener", $$robo$$android_media_MediaPlayer$setOnSeekCompleteListener(android.media.MediaPlayer$OnSeekCompleteListener ), 0, this, onSeekCompleteListener);
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener onVideoSizeChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnVideoSizeChangedListener", $$robo$$android_media_MediaPlayer$setOnVideoSizeChangedListener(android.media.MediaPlayer$OnVideoSizeChangedListener ), 0, this, onVideoSizeChangedListener);
    }

    public void setOnTimedTextListener(OnTimedTextListener onTimedTextListener) {
        InvokeDynamicSupport.bootstrap("setOnTimedTextListener", $$robo$$android_media_MediaPlayer$setOnTimedTextListener(android.media.MediaPlayer$OnTimedTextListener ), 0, this, onTimedTextListener);
    }

    public void setOnSubtitleDataListener(OnSubtitleDataListener onSubtitleDataListener) {
        InvokeDynamicSupport.bootstrap("setOnSubtitleDataListener", $$robo$$android_media_MediaPlayer$setOnSubtitleDataListener(android.media.MediaPlayer$OnSubtitleDataListener ), 0, this, onSubtitleDataListener);
    }

    public void setOnTimedMetaDataAvailableListener(OnTimedMetaDataAvailableListener onTimedMetaDataAvailableListener) {
        InvokeDynamicSupport.bootstrap("setOnTimedMetaDataAvailableListener", $$robo$$android_media_MediaPlayer$setOnTimedMetaDataAvailableListener(android.media.MediaPlayer$OnTimedMetaDataAvailableListener ), 0, this, onTimedMetaDataAvailableListener);
    }

    public void setOnErrorListener(OnErrorListener onErrorListener) {
        InvokeDynamicSupport.bootstrap("setOnErrorListener", $$robo$$android_media_MediaPlayer$setOnErrorListener(android.media.MediaPlayer$OnErrorListener ), 0, this, onErrorListener);
    }

    public void setOnInfoListener(OnInfoListener onInfoListener) {
        InvokeDynamicSupport.bootstrap("setOnInfoListener", $$robo$$android_media_MediaPlayer$setOnInfoListener(android.media.MediaPlayer$OnInfoListener ), 0, this, onInfoListener);
    }

    private boolean isVideoScalingModeSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoScalingModeSupported", $$robo$$android_media_MediaPlayer$isVideoScalingModeSupported(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(MediaPlayer.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaPlayer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TimeProvider
    implements OnSeekCompleteListener,
    MediaTimeProvider,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "MTP";
        private static long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static long MAX_EARLY_CALLBACK_US = 1000L;
        private static long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs;
        private MediaPlayer mPlayer;
        private boolean mPaused;
        private boolean mStopped;
        private boolean mBuffering;
        private long mLastReportedTime;
        private long mTimeAdjustment;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private long mLastNanoTime;
        private Handler mEventHandler;
        private boolean mRefresh;
        private boolean mPausing;
        private boolean mSeeking;
        private static int NOTIFY = 1;
        private static int NOTIFY_TIME = 0;
        private static int REFRESH_AND_NOTIFY_TIME = 1;
        private static int NOTIFY_STOP = 2;
        private static int NOTIFY_SEEK = 3;
        private static int NOTIFY_TRACK_DATA = 4;
        private HandlerThread mHandlerThread;
        public boolean DEBUG;

        private void $$robo$$android_media_MediaPlayer_TimeProvider$__constructor__(MediaPlayer mp) {
            this.mLastTimeUs = 0L;
            this.mPaused = true;
            this.mStopped = true;
            this.mRefresh = false;
            this.mPausing = false;
            this.mSeeking = false;
            this.DEBUG = false;
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayerMTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(this, looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
            this.mTimeAdjustment = 0L;
        }

        private final void $$robo$$android_media_MediaPlayer_TimeProvider$scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && (type == 0 || type == 1)) {
                return;
            }
            if (this.DEBUG) {
                Log.v("MTP", "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        private final void $$robo$$android_media_MediaPlayer_TimeProvider$close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        private final void $$robo$$android_media_MediaPlayer_TimeProvider$finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(1, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$onBuffering(boolean buffering) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onBuffering: " + buffering);
                }
                this.mBuffering = buffering;
                this.scheduleNotification(1, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.mBuffering = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$onSeekComplete(MediaPlayer mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.mBuffering = false;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer_TimeProvider$notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d("MTP", "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d("MTP", "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer_TimeProvider$notifyTrackData(Pair<SubtitleTrack, byte[]> trackData) {
            SubtitleTrack track = (SubtitleTrack)trackData.first;
            byte[] data = (byte[])trackData.second;
            track.onData(data, true, -1L);
        }

        private final synchronized void $$robo$$android_media_MediaPlayer_TimeProvider$notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private final int $$robo$$android_media_MediaPlayer_TimeProvider$registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mListeners, (int)0, (Object)newListeners, (int)0, (int)this.mListeners.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.mTimes, (int)0, (long[])newTimes, (int)0, (int)this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d("MTP", "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (!this.mStopped) {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_MediaPlayer_TimeProvider$cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mListeners, (int)(i + 1), (Object)this.mListeners, (int)i, (int)(this.mListeners.length - i - 1));
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])this.mTimes, (int)(i + 1), (long[])this.mTimes, (int)i, (int)(this.mTimes.length - i - 1));
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private final synchronized void $$robo$$android_media_MediaPlayer_TimeProvider$notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d("MTP", sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d("MTP", "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d("MTP", "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.scheduleNotification(0, nextTimeUs - nowUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        private final long $$robo$$android_media_MediaPlayer_TimeProvider$getEstimatedTime(long nanoTime, boolean monotonic) {
            if (this.mPaused) {
                this.mLastReportedTime = this.mLastTimeUs + this.mTimeAdjustment;
            } else {
                long timeSinceRead = (nanoTime - this.mLastNanoTime) / 1000L;
                this.mLastReportedTime = this.mLastTimeUs + timeSinceRead;
                if (this.mTimeAdjustment > 0L) {
                    long adjustment = this.mTimeAdjustment - timeSinceRead / 2L;
                    if (adjustment <= 0L) {
                        this.mTimeAdjustment = 0L;
                    } else {
                        this.mLastReportedTime += adjustment;
                    }
                }
            }
            return this.mLastReportedTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long $$robo$$android_media_MediaPlayer_TimeProvider$getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                CallSite nanoTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
                if (refreshTime || nanoTime >= this.mLastNanoTime + 5000000000L) {
                    try {
                        this.mLastTimeUs = (long)this.mPlayer.getCurrentPosition() * 1000L;
                        boolean bl = this.mPaused = !this.mPlayer.isPlaying() || this.mBuffering;
                        if (this.DEBUG) {
                            Log.v("MTP", (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (this.mPausing) {
                            this.mPausing = false;
                            this.getEstimatedTime((long)nanoTime, monotonic);
                            this.mPaused = true;
                            if (this.DEBUG) {
                                Log.d("MTP", "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                            }
                            return this.mLastReportedTime;
                        }
                        throw e;
                    }
                    this.mLastNanoTime = (long)nanoTime;
                    if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                        this.mTimeAdjustment = this.mLastReportedTime - this.mLastTimeUs;
                        if (this.mTimeAdjustment > 1000000L) {
                            this.mStopped = false;
                            this.mSeeking = true;
                            this.scheduleNotification(3, 0L);
                        }
                    } else {
                        this.mTimeAdjustment = 0L;
                    }
                }
                return this.getEstimatedTime((long)nanoTime, monotonic);
            }
        }

        private void __constructor__(MediaPlayer mediaPlayer) {
            this.$$robo$$android_media_MediaPlayer_TimeProvider$__constructor__(mediaPlayer);
        }

        public TimeProvider(MediaPlayer mediaPlayer) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_TimeProvider$__constructor__(android.media.MediaPlayer ), 0, this, mediaPlayer);
        }

        private void scheduleNotification(int n, long l) {
            InvokeDynamicSupport.bootstrap("scheduleNotification", $$robo$$android_media_MediaPlayer_TimeProvider$scheduleNotification(int long ), 0, this, n, l);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_MediaPlayer_TimeProvider$close(), 0, this);
        }

        protected void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_MediaPlayer_TimeProvider$finalize(), 0, this);
        }

        public void onPaused(boolean bl) {
            InvokeDynamicSupport.bootstrap("onPaused", $$robo$$android_media_MediaPlayer_TimeProvider$onPaused(boolean ), 0, this, bl);
        }

        public void onBuffering(boolean bl) {
            InvokeDynamicSupport.bootstrap("onBuffering", $$robo$$android_media_MediaPlayer_TimeProvider$onBuffering(boolean ), 0, this, bl);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_media_MediaPlayer_TimeProvider$onStopped(), 0, this);
        }

        @Override
        public void onSeekComplete(MediaPlayer mediaPlayer) {
            InvokeDynamicSupport.bootstrap("onSeekComplete", $$robo$$android_media_MediaPlayer_TimeProvider$onSeekComplete(android.media.MediaPlayer ), 0, this, mediaPlayer);
        }

        public void onNewPlayer() {
            InvokeDynamicSupport.bootstrap("onNewPlayer", $$robo$$android_media_MediaPlayer_TimeProvider$onNewPlayer(), 0, this);
        }

        private synchronized void notifySeek() {
            InvokeDynamicSupport.bootstrap("notifySeek", $$robo$$android_media_MediaPlayer_TimeProvider$notifySeek(), 0, this);
        }

        private synchronized void notifyTrackData(Pair<SubtitleTrack, byte[]> pair) {
            InvokeDynamicSupport.bootstrap("notifyTrackData", $$robo$$android_media_MediaPlayer_TimeProvider$notifyTrackData(android.util.Pair<android.media.SubtitleTrack, byte[]> ), 0, this, pair);
        }

        private synchronized void notifyStop() {
            InvokeDynamicSupport.bootstrap("notifyStop", $$robo$$android_media_MediaPlayer_TimeProvider$notifyStop(), 0, this);
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            return (int)InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_media_MediaPlayer_TimeProvider$registerListener(android.media.MediaTimeProvider$OnMediaTimeListener ), 0, this, onMediaTimeListener);
        }

        @Override
        public void notifyAt(long l, MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("notifyAt", $$robo$$android_media_MediaPlayer_TimeProvider$notifyAt(long android.media.MediaTimeProvider$OnMediaTimeListener ), 0, this, l, onMediaTimeListener);
        }

        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("scheduleUpdate", $$robo$$android_media_MediaPlayer_TimeProvider$scheduleUpdate(android.media.MediaTimeProvider$OnMediaTimeListener ), 0, this, onMediaTimeListener);
        }

        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener onMediaTimeListener) {
            InvokeDynamicSupport.bootstrap("cancelNotifications", $$robo$$android_media_MediaPlayer_TimeProvider$cancelNotifications(android.media.MediaTimeProvider$OnMediaTimeListener ), 0, this, onMediaTimeListener);
        }

        private synchronized void notifyTimedEvent(boolean bl) {
            InvokeDynamicSupport.bootstrap("notifyTimedEvent", $$robo$$android_media_MediaPlayer_TimeProvider$notifyTimedEvent(boolean ), 0, this, bl);
        }

        private long getEstimatedTime(long l, boolean bl) {
            return (long)InvokeDynamicSupport.bootstrap("getEstimatedTime", $$robo$$android_media_MediaPlayer_TimeProvider$getEstimatedTime(long boolean ), 0, this, l, bl);
        }

        @Override
        public long getCurrentTimeUs(boolean bl, boolean bl2) throws IllegalStateException {
            return (long)InvokeDynamicSupport.bootstrap("getCurrentTimeUs", $$robo$$android_media_MediaPlayer_TimeProvider$getCurrentTimeUs(boolean boolean ), 0, this, bl, bl2);
        }

        public /* synthetic */ TimeProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class EventHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimeProvider this$0;

            private void $$robo$$android_media_MediaPlayer_TimeProvider_EventHandler$__constructor__(TimeProvider timeProvider, Looper looper) {
            }

            private final void $$robo$$android_media_MediaPlayer_TimeProvider_EventHandler$handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            this.this$0.notifyTimedEvent(false);
                            break;
                        }
                        case 1: {
                            this.this$0.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            this.this$0.notifyStop();
                            break;
                        }
                        case 3: {
                            this.this$0.notifySeek();
                            break;
                        }
                        case 4: {
                            this.this$0.notifyTrackData((Pair)msg.obj);
                        }
                    }
                }
            }

            private void __constructor__(TimeProvider timeProvider, Looper looper) {
                this.$$robo$$android_media_MediaPlayer_TimeProvider_EventHandler$__constructor__(timeProvider, looper);
            }

            public EventHandler(TimeProvider timeProvider, Looper looper) {
                this.this$0 = timeProvider;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_TimeProvider_EventHandler$__constructor__(android.media.MediaPlayer$TimeProvider android.os.Looper ), 0, this, timeProvider, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaPlayer_TimeProvider_EventHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ EventHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface OnInfoListener
    extends InstrumentedInterface {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener
    extends InstrumentedInterface {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedMetaDataAvailableListener
    extends InstrumentedInterface {
        public void onTimedMetaDataAvailable(MediaPlayer var1, TimedMetaData var2);
    }

    public static interface OnSubtitleDataListener
    extends InstrumentedInterface {
        public void onSubtitleData(MediaPlayer var1, SubtitleData var2);
    }

    public static interface OnTimedTextListener
    extends InstrumentedInterface {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnVideoSizeChangedListener
    extends InstrumentedInterface {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener
    extends InstrumentedInterface {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener
    extends InstrumentedInterface {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener
    extends InstrumentedInterface {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener
    extends InstrumentedInterface {
        public void onPrepared(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaPlayer mMediaPlayer;
        /* synthetic */ MediaPlayer this$0;

        private void $$robo$$android_media_MediaPlayer_EventHandler$__constructor__(MediaPlayer mediaPlayer, MediaPlayer mp, Looper looper) {
            this.mMediaPlayer = mp;
        }

        private final void $$robo$$android_media_MediaPlayer_EventHandler$handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w("MediaPlayer", "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    try {
                        this.this$0.scanInternalSubtitleTracks();
                    }
                    catch (RuntimeException e) {
                        Message msg2 = this.obtainMessage(100, 1, -1010, null);
                        this.sendMessage(msg2);
                    }
                    OnPreparedListener onPreparedListener = this.this$0.mOnPreparedListener;
                    if (onPreparedListener != null) {
                        onPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 2: {
                    OnCompletionListener onCompletionListener = this.this$0.mOnCompletionListener;
                    if (onCompletionListener != null) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    this.this$0.stayAwake(false);
                    return;
                }
                case 8: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onStopped();
                    break;
                }
                case 6: 
                case 7: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onPaused(msg.what == 7);
                    break;
                }
                case 3: {
                    OnBufferingUpdateListener onBufferingUpdateListener = this.this$0.mOnBufferingUpdateListener;
                    if (onBufferingUpdateListener != null) {
                        onBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    OnSeekCompleteListener onSeekCompleteListener = this.this$0.mOnSeekCompleteListener;
                    if (onSeekCompleteListener != null) {
                        onSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                }
                case 9: {
                    TimeProvider timeProvider = this.this$0.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    OnVideoSizeChangedListener onVideoSizeChangedListener = this.this$0.mOnVideoSizeChangedListener;
                    if (onVideoSizeChangedListener != null) {
                        onVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    OnCompletionListener onCompletionListener;
                    Log.e("MediaPlayer", "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    OnErrorListener onErrorListener = this.this$0.mOnErrorListener;
                    if (onErrorListener != null) {
                        error_was_handled = onErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    if ((onCompletionListener = this.this$0.mOnCompletionListener) != null && !error_was_handled) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    this.this$0.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (msg.arg1) {
                        case 700: {
                            Log.i("MediaPlayer", "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            try {
                                this.this$0.scanInternalSubtitleTracks();
                            }
                            catch (RuntimeException e) {
                                Message msg2 = this.obtainMessage(100, 1, -1010, null);
                                this.sendMessage(msg2);
                            }
                        }
                        case 803: {
                            msg.arg1 = 802;
                            if (this.this$0.mSubtitleController == null) break;
                            this.this$0.mSubtitleController.selectDefaultTrack();
                            break;
                        }
                        case 701: 
                        case 702: {
                            TimeProvider timeProvider = this.this$0.mTimeProvider;
                            if (timeProvider == null) break;
                            timeProvider.onBuffering(msg.arg1 == 701);
                        }
                    }
                    OnInfoListener onInfoListener = this.this$0.mOnInfoListener;
                    if (onInfoListener != null) {
                        onInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 99: {
                    OnTimedTextListener onTimedTextListener = this.this$0.mOnTimedTextListener;
                    if (onTimedTextListener == null) {
                        return;
                    }
                    if (msg.obj == null) {
                        onTimedTextListener.onTimedText(this.mMediaPlayer, null);
                    } else if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        TimedText text = new TimedText(parcel);
                        parcel.recycle();
                        onTimedTextListener.onTimedText(this.mMediaPlayer, text);
                    }
                    return;
                }
                case 201: {
                    OnSubtitleDataListener onSubtitleDataListener = this.this$0.mOnSubtitleDataListener;
                    if (onSubtitleDataListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        SubtitleData data = new SubtitleData(parcel);
                        parcel.recycle();
                        onSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 202: {
                    OnTimedMetaDataAvailableListener onTimedMetaDataAvailableListener = this.this$0.mOnTimedMetaDataAvailableListener;
                    if (onTimedMetaDataAvailableListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        TimedMetaData data = TimedMetaData.createTimedMetaDataFromParcel(parcel);
                        parcel.recycle();
                        onTimedMetaDataAvailableListener.onTimedMetaDataAvailable(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    Log.e("MediaPlayer", "Unknown message type " + msg.what);
                    return;
                }
            }
        }

        private void __constructor__(MediaPlayer mediaPlayer, MediaPlayer mediaPlayer2, Looper looper) {
            this.$$robo$$android_media_MediaPlayer_EventHandler$__constructor__(mediaPlayer, mediaPlayer2, looper);
        }

        public EventHandler(MediaPlayer mediaPlayer, MediaPlayer mediaPlayer2, Looper looper) {
            this.this$0 = mediaPlayer;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_EventHandler$__constructor__(android.media.MediaPlayer android.media.MediaPlayer android.os.Looper ), 0, this, mediaPlayer, mediaPlayer2, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_MediaPlayer_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TrackInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static int MEDIA_TRACK_TYPE_METADATA = 5;
        int mTrackType;
        MediaFormat mFormat;
        static Parcelable.Creator<TrackInfo> CREATOR;

        private final int $$robo$$android_media_MediaPlayer_TrackInfo$getTrackType() {
            return this.mTrackType;
        }

        private final String $$robo$$android_media_MediaPlayer_TrackInfo$getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        private final MediaFormat $$robo$$android_media_MediaPlayer_TrackInfo$getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        private void $$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(Parcel in) {
            this.mTrackType = in.readInt();
            String mime = in.readString();
            String language = in.readString();
            this.mFormat = MediaFormat.createSubtitleFormat(mime, language);
            if (this.mTrackType == 4) {
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            }
        }

        private void $$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        private final int $$robo$$android_media_MediaPlayer_TrackInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_MediaPlayer_TrackInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeString(this.mFormat.getString("mime"));
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }

        private final String $$robo$$android_media_MediaPlayer_TrackInfo$toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TrackInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_MediaPlayer_TrackInfo_1$__constructor__() {
                }

                private final TrackInfo $$robo$$android_media_MediaPlayer_TrackInfo_1$createFromParcel(Parcel in) {
                    return new TrackInfo(in);
                }

                private final TrackInfo[] $$robo$$android_media_MediaPlayer_TrackInfo_1$newArray(int size) {
                    return new TrackInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_MediaPlayer_TrackInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_TrackInfo_1$__constructor__(), 0, this);
                }

                @Override
                public TrackInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_MediaPlayer_TrackInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TrackInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_MediaPlayer_TrackInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public int getTrackType() {
            return (int)InvokeDynamicSupport.bootstrap("getTrackType", $$robo$$android_media_MediaPlayer_TrackInfo$getTrackType(), 0, this);
        }

        public String getLanguage() {
            return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_media_MediaPlayer_TrackInfo$getLanguage(), 0, this);
        }

        public MediaFormat getFormat() {
            return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_media_MediaPlayer_TrackInfo$getFormat(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(parcel);
        }

        TrackInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(int n, MediaFormat mediaFormat) {
            this.$$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(n, mediaFormat);
        }

        TrackInfo(int n, MediaFormat mediaFormat) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_MediaPlayer_TrackInfo$__constructor__(int android.media.MediaFormat ), 0, this, n, mediaFormat);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_MediaPlayer_TrackInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_MediaPlayer_TrackInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_MediaPlayer_TrackInfo$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(TrackInfo.class);
        }

        public /* synthetic */ TrackInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TrackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

