/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.IAudioService;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SoundPool
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SAMPLE_LOADED = 1;
    private static String TAG = "SoundPool";
    private static boolean DEBUG;
    private long mNativeContext;
    private EventHandler mEventHandler;
    private OnLoadCompleteListener mOnLoadCompleteListener;
    private boolean mHasAppOpsPlayAudio;
    private Object mLock;
    private AudioAttributes mAttributes;
    private IAppOpsService mAppOps;
    private IAppOpsCallback mAppOpsCallback;
    private static IAudioService sService;

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, int streamType, int srcQuality) {
    }

    private void $$robo$$android_media_SoundPool$__constructor__(int maxStreams, AudioAttributes attributes) {
        if (this.native_setup(new WeakReference<SoundPool>(this), maxStreams, attributes) != 0) {
            throw new RuntimeException("Native setup failed");
        }
        this.mLock = new Object();
        this.mAttributes = attributes;
        IBinder b = ServiceManager.getService("appops");
        this.mAppOps = IAppOpsService.Stub.asInterface(b);
        this.updateAppOpsPlayAudio();
        this.mAppOpsCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SoundPool this$0;

            private void $$robo$$android_media_SoundPool_1$__constructor__(SoundPool this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_SoundPool_1$opChanged(int op, int uid, String packageName) {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (op == 28) {
                        this.this$0.updateAppOpsPlayAudio();
                    }
                }
            }

            private void __constructor__(SoundPool soundPool) {
                this.$$robo$$android_media_SoundPool_1$__constructor__(soundPool);
            }
            {
                this.this$0 = soundPool;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_1$__constructor__(android.media.SoundPool ), 0, this, soundPool);
            }

            @Override
            public void opChanged(int n, int n2, String string2) {
                InvokeDynamicSupport.bootstrap("opChanged", $$robo$$android_media_SoundPool_1$opChanged(int int java.lang.String ), 0, this, n, n2, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.mAppOps.startWatchingMode(28, ActivityThread.currentPackageName(), this.mAppOpsCallback);
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
    }

    private final void $$robo$$android_media_SoundPool$release() {
        try {
            this.mAppOps.stopWatchingMode(this.mAppOpsCallback);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.native_release();
    }

    private final void $$robo$$android_media_SoundPool$native_release() {
    }

    private final void $$robo$$android_media_SoundPool$finalize() {
        this.release();
    }

    private final int $$robo$$android_media_SoundPool$load(String path, int priority) {
        int id2 = 0;
        try {
            File f = new File(path);
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(f, 0x10000000);
            if (fd != null) {
                id2 = this._load(fd.getFileDescriptor(), 0L, f.length(), priority);
                fd.close();
            }
        }
        catch (IOException e) {
            Log.e("SoundPool", "error loading " + path);
        }
        return id2;
    }

    private final int $$robo$$android_media_SoundPool$load(Context context, int resId, int priority) {
        AssetFileDescriptor afd = context.getResources().openRawResourceFd(resId);
        int id2 = 0;
        if (afd != null) {
            id2 = this._load(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), priority);
            try {
                afd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return id2;
    }

    private final int $$robo$$android_media_SoundPool$load(AssetFileDescriptor afd, int priority) {
        if (afd != null) {
            long len = afd.getLength();
            if (len < 0L) {
                throw new AndroidRuntimeException("no length for fd");
            }
            return this._load(afd.getFileDescriptor(), afd.getStartOffset(), len, priority);
        }
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$load(FileDescriptor fd, long offset, long length, int priority) {
        return this._load(fd, offset, length, priority);
    }

    private final boolean $$robo$$android_media_SoundPool$unload(int n) {
        return false;
    }

    private final int $$robo$$android_media_SoundPool$play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        if (this.isRestricted()) {
            rightVolume = 0.0f;
            leftVolume = 0.0f;
        }
        return this._play(soundID, leftVolume, rightVolume, priority, loop, rate);
    }

    private final void $$robo$$android_media_SoundPool$pause(int n) {
    }

    private final void $$robo$$android_media_SoundPool$resume(int n) {
    }

    private final void $$robo$$android_media_SoundPool$autoPause() {
    }

    private final void $$robo$$android_media_SoundPool$autoResume() {
    }

    private final void $$robo$$android_media_SoundPool$stop(int n) {
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float leftVolume, float rightVolume) {
        if (this.isRestricted()) {
            return;
        }
        this._setVolume(streamID, leftVolume, rightVolume);
    }

    private final void $$robo$$android_media_SoundPool$setVolume(int streamID, float volume) {
        this.setVolume(streamID, volume, volume);
    }

    private final void $$robo$$android_media_SoundPool$setPriority(int n, int n2) {
    }

    private final void $$robo$$android_media_SoundPool$setLoop(int n, int n2) {
    }

    private final void $$robo$$android_media_SoundPool$setRate(int n, float f) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_SoundPool$setOnLoadCompleteListener(OnLoadCompleteListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper;
            this.mEventHandler = listener != null ? ((looper = Looper.myLooper()) != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null)) : null;
            this.mOnLoadCompleteListener = listener;
        }
    }

    private static final IAudioService $$robo$$android_media_SoundPool$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("audio");
        sService = IAudioService.Stub.asInterface(b);
        return sService;
    }

    private final boolean $$robo$$android_media_SoundPool$isRestricted() {
        IAudioService service = SoundPool.getService();
        boolean cameraSoundForced = false;
        try {
            cameraSoundForced = service.isCameraSoundForced();
        }
        catch (RemoteException e) {
            Log.e("SoundPool", "Cannot access AudioService in isRestricted()");
        }
        if (cameraSoundForced && (this.mAttributes.getAllFlags() & 1) != 0) {
            return false;
        }
        if ((this.mAttributes.getAllFlags() & 0x40) != 0) {
            return false;
        }
        return !this.mHasAppOpsPlayAudio;
    }

    private final void $$robo$$android_media_SoundPool$updateAppOpsPlayAudio() {
        try {
            int mode = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
            this.mHasAppOpsPlayAudio = mode == 0;
        }
        catch (RemoteException e) {
            this.mHasAppOpsPlayAudio = false;
        }
    }

    private final int $$robo$$android_media_SoundPool$_load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$native_setup(Object object, int n, Object object2) {
        return 0;
    }

    private final int $$robo$$android_media_SoundPool$_play(int n, float f, float f2, int n2, int n3, float f3) {
        return 0;
    }

    private final void $$robo$$android_media_SoundPool$_setVolume(int n, float f, float f2) {
    }

    private static final void $$robo$$android_media_SoundPool$postEventFromNative(Object ref, int msg, int arg1, int arg2, Object obj) {
        SoundPool soundPool = (SoundPool)((WeakReference)ref).get();
        if (soundPool == null) {
            return;
        }
        if (soundPool.mEventHandler != null) {
            Message m = soundPool.mEventHandler.obtainMessage(msg, arg1, arg2, obj);
            soundPool.mEventHandler.sendMessage(m);
        }
    }

    private /* synthetic */ void $$robo$$android_media_SoundPool$__constructor__(int x0, AudioAttributes x1, 1 x2) {
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"soundpool");
        DEBUG = Log.isLoggable("SoundPool", 3);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, n2, n3);
    }

    public SoundPool(int n, int n2, int n3) {
        this(n, new AudioAttributes.Builder().setInternalLegacyStreamType(n2).build());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    private void __constructor__(int n, AudioAttributes audioAttributes) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes);
    }

    private SoundPool(int n, AudioAttributes audioAttributes) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool$__constructor__(int android.media.AudioAttributes ), 0, this, n, audioAttributes);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_SoundPool$release(), 0, this);
    }

    private final native /* synthetic */ void $$robo$$native_release$nativeBinding();

    private void native_release() {
        InvokeDynamicSupport.bootstrap("native_release", $$robo$$android_media_SoundPool$native_release(), 1, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_SoundPool$finalize(), 0, this);
    }

    public int load(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.lang.String int ), 0, this, string2, n);
    }

    public int load(Context context, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.Context int int ), 0, this, context, n, n2);
    }

    public int load(AssetFileDescriptor assetFileDescriptor, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(android.content.res.AssetFileDescriptor int ), 0, this, assetFileDescriptor, n);
    }

    public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("load", $$robo$$android_media_SoundPool$load(java.io.FileDescriptor long long int ), 0, this, fileDescriptor, l, l2, n);
    }

    private final native /* synthetic */ boolean $$robo$$unload$nativeBinding(int var1);

    public boolean unload(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("unload", $$robo$$android_media_SoundPool$unload(int ), 1, this, n);
    }

    public int play(int n, float f, float f2, int n2, int n3, float f3) {
        return (int)InvokeDynamicSupport.bootstrap("play", $$robo$$android_media_SoundPool$play(int float float int int float ), 0, this, n, f, f2, n2, n3, f3);
    }

    private final native /* synthetic */ void $$robo$$pause$nativeBinding(int var1);

    public void pause(int n) {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_media_SoundPool$pause(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$resume$nativeBinding(int var1);

    public void resume(int n) {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_media_SoundPool$resume(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$autoPause$nativeBinding();

    public void autoPause() {
        InvokeDynamicSupport.bootstrap("autoPause", $$robo$$android_media_SoundPool$autoPause(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$autoResume$nativeBinding();

    public void autoResume() {
        InvokeDynamicSupport.bootstrap("autoResume", $$robo$$android_media_SoundPool$autoResume(), 1, this);
    }

    private final native /* synthetic */ void $$robo$$stop$nativeBinding(int var1);

    public void stop(int n) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_media_SoundPool$stop(int ), 1, this, n);
    }

    public void setVolume(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float float ), 0, this, n, f, f2);
    }

    public void setVolume(int n, float f) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_media_SoundPool$setVolume(int float ), 0, this, n, f);
    }

    private final native /* synthetic */ void $$robo$$setPriority$nativeBinding(int var1, int var2);

    public void setPriority(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_media_SoundPool$setPriority(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ void $$robo$$setLoop$nativeBinding(int var1, int var2);

    public void setLoop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLoop", $$robo$$android_media_SoundPool$setLoop(int int ), 1, this, n, n2);
    }

    private final native /* synthetic */ void $$robo$$setRate$nativeBinding(int var1, float var2);

    public void setRate(int n, float f) {
        InvokeDynamicSupport.bootstrap("setRate", $$robo$$android_media_SoundPool$setRate(int float ), 1, this, n, f);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        InvokeDynamicSupport.bootstrap("setOnLoadCompleteListener", $$robo$$android_media_SoundPool$setOnLoadCompleteListener(android.media.SoundPool$OnLoadCompleteListener ), 0, this, onLoadCompleteListener);
    }

    private static IAudioService getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_media_SoundPool$getService(), 0);
    }

    private boolean isRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRestricted", $$robo$$android_media_SoundPool$isRestricted(), 0, this);
    }

    private void updateAppOpsPlayAudio() {
        InvokeDynamicSupport.bootstrap("updateAppOpsPlayAudio", $$robo$$android_media_SoundPool$updateAppOpsPlayAudio(), 0, this);
    }

    private final native /* synthetic */ int $$robo$$_load$nativeBinding(FileDescriptor var1, long var2, long var4, int var6);

    private int _load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("_load", $$robo$$android_media_SoundPool$_load(java.io.FileDescriptor long long int ), 1, this, fileDescriptor, l, l2, n);
    }

    private final native /* synthetic */ int $$robo$$native_setup$nativeBinding(Object var1, int var2, Object var3);

    private int native_setup(Object object, int n, Object object2) {
        return (int)InvokeDynamicSupport.bootstrap("native_setup", $$robo$$android_media_SoundPool$native_setup(java.lang.Object int java.lang.Object ), 1, this, object, n, object2);
    }

    private final native /* synthetic */ int $$robo$$_play$nativeBinding(int var1, float var2, float var3, int var4, int var5, float var6);

    private int _play(int n, float f, float f2, int n2, int n3, float f3) {
        return (int)InvokeDynamicSupport.bootstrap("_play", $$robo$$android_media_SoundPool$_play(int float float int int float ), 1, this, n, f, f2, n2, n3, f3);
    }

    private final native /* synthetic */ void $$robo$$_setVolume$nativeBinding(int var1, float var2, float var3);

    private void _setVolume(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("_setVolume", $$robo$$android_media_SoundPool$_setVolume(int float float ), 1, this, n, f, f2);
    }

    private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
        InvokeDynamicSupport.bootstrapStatic("postEventFromNative", $$robo$$android_media_SoundPool$postEventFromNative(java.lang.Object int int int java.lang.Object ), 0, (Object)object, (int)n, (int)n2, (int)n3, (Object)object2);
    }

    private /* synthetic */ void __constructor__(int n, AudioAttributes audioAttributes, 1 var3_3) {
        this.$$robo$$android_media_SoundPool$__constructor__(n, audioAttributes, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(SoundPool.class);
    }

    public /* synthetic */ SoundPool() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundPool)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMaxStreams;
        private AudioAttributes mAudioAttributes;

        private void $$robo$$android_media_SoundPool_Builder$__constructor__() {
            this.mMaxStreams = 1;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setMaxStreams(int maxStreams) throws IllegalArgumentException {
            if (maxStreams <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = maxStreams;
            return this;
        }

        private final Builder $$robo$$android_media_SoundPool_Builder$setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
            if (attributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = attributes;
            return this;
        }

        private final SoundPool $$robo$$android_media_SoundPool_Builder$build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }

        private void __constructor__() {
            this.$$robo$$android_media_SoundPool_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_Builder$__constructor__(), 0, this);
        }

        public Builder setMaxStreams(int n) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setMaxStreams", $$robo$$android_media_SoundPool_Builder$setMaxStreams(int ), 0, this, n);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_media_SoundPool_Builder$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
        }

        public SoundPool build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_media_SoundPool_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class EventHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SoundPool this$0;

        private void $$robo$$android_media_SoundPool_EventHandler$__constructor__(SoundPool soundPool, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_SoundPool_EventHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (DEBUG) {
                        Log.d("SoundPool", "Sample " + msg.arg1 + " loaded");
                    }
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (this.this$0.mOnLoadCompleteListener != null) {
                            this.this$0.mOnLoadCompleteListener.onLoadComplete(this.this$0, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
                default: {
                    Log.e("SoundPool", "Unknown message type " + msg.what);
                    return;
                }
            }
        }

        private void __constructor__(SoundPool soundPool, Looper looper) {
            this.$$robo$$android_media_SoundPool_EventHandler$__constructor__(soundPool, looper);
        }

        public EventHandler(SoundPool soundPool, Looper looper) {
            this.this$0 = soundPool;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_SoundPool_EventHandler$__constructor__(android.media.SoundPool android.os.Looper ), 0, this, soundPool, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_SoundPool_EventHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ EventHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnLoadCompleteListener
    extends InstrumentedInterface {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }
}

