/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Rect;
import android.os.Parcel;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class TimedText
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int FIRST_PUBLIC_KEY = 1;
    private static int KEY_DISPLAY_FLAGS = 1;
    private static int KEY_STYLE_FLAGS = 2;
    private static int KEY_BACKGROUND_COLOR_RGBA = 3;
    private static int KEY_HIGHLIGHT_COLOR_RGBA = 4;
    private static int KEY_SCROLL_DELAY = 5;
    private static int KEY_WRAP_TEXT = 6;
    private static int KEY_START_TIME = 7;
    private static int KEY_STRUCT_BLINKING_TEXT_LIST = 8;
    private static int KEY_STRUCT_FONT_LIST = 9;
    private static int KEY_STRUCT_HIGHLIGHT_LIST = 10;
    private static int KEY_STRUCT_HYPER_TEXT_LIST = 11;
    private static int KEY_STRUCT_KARAOKE_LIST = 12;
    private static int KEY_STRUCT_STYLE_LIST = 13;
    private static int KEY_STRUCT_TEXT_POS = 14;
    private static int KEY_STRUCT_JUSTIFICATION = 15;
    private static int KEY_STRUCT_TEXT = 16;
    private static int LAST_PUBLIC_KEY = 16;
    private static int FIRST_PRIVATE_KEY = 101;
    private static int KEY_GLOBAL_SETTING = 101;
    private static int KEY_LOCAL_SETTING = 102;
    private static int KEY_START_CHAR = 103;
    private static int KEY_END_CHAR = 104;
    private static int KEY_FONT_ID = 105;
    private static int KEY_FONT_SIZE = 106;
    private static int KEY_TEXT_COLOR_RGBA = 107;
    private static int LAST_PRIVATE_KEY = 107;
    private static String TAG = "TimedText";
    private HashMap<Integer, Object> mKeyObjectMap;
    private int mDisplayFlags;
    private int mBackgroundColorRGBA;
    private int mHighlightColorRGBA;
    private int mScrollDelay;
    private int mWrapText;
    private List<CharPos> mBlinkingPosList;
    private List<CharPos> mHighlightPosList;
    private List<Karaoke> mKaraokeList;
    private List<Font> mFontList;
    private List<Style> mStyleList;
    private List<HyperText> mHyperTextList;
    private Rect mTextBounds;
    private String mTextChars;
    private Justification mJustification;

    private void $$robo$$android_media_TimedText$__constructor__(Parcel parcel) {
        this.mKeyObjectMap = new HashMap();
        this.mDisplayFlags = -1;
        this.mBackgroundColorRGBA = -1;
        this.mHighlightColorRGBA = -1;
        this.mScrollDelay = -1;
        this.mWrapText = -1;
        this.mBlinkingPosList = null;
        this.mHighlightPosList = null;
        this.mKaraokeList = null;
        this.mFontList = null;
        this.mStyleList = null;
        this.mHyperTextList = null;
        this.mTextBounds = null;
        this.mTextChars = null;
        if (!this.parseParcel(parcel)) {
            this.mKeyObjectMap.clear();
            throw new IllegalArgumentException("parseParcel() fails");
        }
    }

    private final String $$robo$$android_media_TimedText$getText() {
        return this.mTextChars;
    }

    private final Rect $$robo$$android_media_TimedText$getBounds() {
        return this.mTextBounds;
    }

    private final boolean $$robo$$android_media_TimedText$parseParcel(Parcel parcel) {
        parcel.setDataPosition(0);
        if (parcel.dataAvail() == 0) {
            return false;
        }
        int type = parcel.readInt();
        if (type == 102) {
            type = parcel.readInt();
            if (type != 7) {
                return false;
            }
            int mStartTimeMs = parcel.readInt();
            this.mKeyObjectMap.put(type, mStartTimeMs);
            type = parcel.readInt();
            if (type != 16) {
                return false;
            }
            int textLen = parcel.readInt();
            byte[] text = parcel.createByteArray();
            this.mTextChars = text == null || text.length == 0 ? null : new String(text);
        } else if (type != 101) {
            Log.w("TimedText", "Invalid timed text key found: " + type);
            return false;
        }
        while (parcel.dataAvail() > 0) {
            int key = parcel.readInt();
            if (!this.isValidKey(key)) {
                Log.w("TimedText", "Invalid timed text key found: " + key);
                return false;
            }
            Object object = null;
            switch (key) {
                case 13: {
                    this.readStyle(parcel);
                    object = this.mStyleList;
                    break;
                }
                case 9: {
                    this.readFont(parcel);
                    object = this.mFontList;
                    break;
                }
                case 10: {
                    this.readHighlight(parcel);
                    object = this.mHighlightPosList;
                    break;
                }
                case 12: {
                    this.readKaraoke(parcel);
                    object = this.mKaraokeList;
                    break;
                }
                case 11: {
                    this.readHyperText(parcel);
                    object = this.mHyperTextList;
                    break;
                }
                case 8: {
                    this.readBlinkingText(parcel);
                    object = this.mBlinkingPosList;
                    break;
                }
                case 6: {
                    this.mWrapText = parcel.readInt();
                    object = this.mWrapText;
                    break;
                }
                case 4: {
                    this.mHighlightColorRGBA = parcel.readInt();
                    object = this.mHighlightColorRGBA;
                    break;
                }
                case 1: {
                    this.mDisplayFlags = parcel.readInt();
                    object = this.mDisplayFlags;
                    break;
                }
                case 15: {
                    int horizontal = parcel.readInt();
                    int vertical = parcel.readInt();
                    this.mJustification = new Justification(horizontal, vertical);
                    object = this.mJustification;
                    break;
                }
                case 3: {
                    this.mBackgroundColorRGBA = parcel.readInt();
                    object = this.mBackgroundColorRGBA;
                    break;
                }
                case 14: {
                    int top = parcel.readInt();
                    int left = parcel.readInt();
                    int bottom = parcel.readInt();
                    int right = parcel.readInt();
                    this.mTextBounds = new Rect(left, top, right, bottom);
                    break;
                }
                case 5: {
                    this.mScrollDelay = parcel.readInt();
                    object = this.mScrollDelay;
                    break;
                }
            }
            if (object == null) continue;
            if (this.mKeyObjectMap.containsKey(key)) {
                this.mKeyObjectMap.remove(key);
            }
            this.mKeyObjectMap.put(key, object);
        }
        return true;
    }

    private final void $$robo$$android_media_TimedText$readStyle(Parcel parcel) {
        boolean endOfStyle = false;
        int startChar = -1;
        int endChar = -1;
        int fontId = -1;
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderlined = false;
        int fontSize = -1;
        int colorRGBA = -1;
        block8: while (!endOfStyle && parcel.dataAvail() > 0) {
            int key = parcel.readInt();
            switch (key) {
                case 103: {
                    startChar = parcel.readInt();
                    continue block8;
                }
                case 104: {
                    endChar = parcel.readInt();
                    continue block8;
                }
                case 105: {
                    fontId = parcel.readInt();
                    continue block8;
                }
                case 2: {
                    int flags = parcel.readInt();
                    isBold = flags % 2 == 1;
                    isItalic = flags % 4 >= 2;
                    isUnderlined = flags / 4 == 1;
                    continue block8;
                }
                case 106: {
                    fontSize = parcel.readInt();
                    continue block8;
                }
                case 107: {
                    colorRGBA = parcel.readInt();
                    continue block8;
                }
            }
            parcel.setDataPosition(parcel.dataPosition() - 4);
            endOfStyle = true;
        }
        Style style2 = new Style(startChar, endChar, fontId, isBold, isItalic, isUnderlined, fontSize, colorRGBA);
        if (this.mStyleList == null) {
            this.mStyleList = new ArrayList<Style>();
        }
        this.mStyleList.add(style2);
    }

    private final void $$robo$$android_media_TimedText$readFont(Parcel parcel) {
        int entryCount = parcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            int id2 = parcel.readInt();
            int nameLen = parcel.readInt();
            byte[] text = parcel.createByteArray();
            String name = new String(text, 0, nameLen);
            Font font = new Font(id2, name);
            if (this.mFontList == null) {
                this.mFontList = new ArrayList<Font>();
            }
            this.mFontList.add(font);
        }
    }

    private final void $$robo$$android_media_TimedText$readHighlight(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        CharPos pos = new CharPos(startChar, endChar);
        if (this.mHighlightPosList == null) {
            this.mHighlightPosList = new ArrayList<CharPos>();
        }
        this.mHighlightPosList.add(pos);
    }

    private final void $$robo$$android_media_TimedText$readKaraoke(Parcel parcel) {
        int entryCount = parcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            int startTimeMs = parcel.readInt();
            int endTimeMs = parcel.readInt();
            int startChar = parcel.readInt();
            int endChar = parcel.readInt();
            Karaoke kara = new Karaoke(startTimeMs, endTimeMs, startChar, endChar);
            if (this.mKaraokeList == null) {
                this.mKaraokeList = new ArrayList<Karaoke>();
            }
            this.mKaraokeList.add(kara);
        }
    }

    private final void $$robo$$android_media_TimedText$readHyperText(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        int len = parcel.readInt();
        byte[] url = parcel.createByteArray();
        String urlString = new String(url, 0, len);
        len = parcel.readInt();
        byte[] alt = parcel.createByteArray();
        String altString = new String(alt, 0, len);
        HyperText hyperText = new HyperText(startChar, endChar, urlString, altString);
        if (this.mHyperTextList == null) {
            this.mHyperTextList = new ArrayList<HyperText>();
        }
        this.mHyperTextList.add(hyperText);
    }

    private final void $$robo$$android_media_TimedText$readBlinkingText(Parcel parcel) {
        int startChar = parcel.readInt();
        int endChar = parcel.readInt();
        CharPos blinkingPos = new CharPos(startChar, endChar);
        if (this.mBlinkingPosList == null) {
            this.mBlinkingPosList = new ArrayList<CharPos>();
        }
        this.mBlinkingPosList.add(blinkingPos);
    }

    private final boolean $$robo$$android_media_TimedText$isValidKey(int key) {
        return key >= 1 && key <= 16 || key >= 101 && key <= 107;
    }

    private final boolean $$robo$$android_media_TimedText$containsKey(int key) {
        return this.isValidKey(key) && this.mKeyObjectMap.containsKey(key);
    }

    private final Set $$robo$$android_media_TimedText$keySet() {
        return this.mKeyObjectMap.keySet();
    }

    private final Object $$robo$$android_media_TimedText$getObject(int key) {
        if (this.containsKey(key)) {
            return this.mKeyObjectMap.get(key);
        }
        throw new IllegalArgumentException("Invalid key: " + key);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_media_TimedText$__constructor__(parcel);
    }

    public TimedText(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_media_TimedText$getText(), 0, this);
    }

    public Rect getBounds() {
        return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_media_TimedText$getBounds(), 0, this);
    }

    private boolean parseParcel(Parcel parcel) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseParcel", $$robo$$android_media_TimedText$parseParcel(android.os.Parcel ), 0, this, parcel);
    }

    private void readStyle(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readStyle", $$robo$$android_media_TimedText$readStyle(android.os.Parcel ), 0, this, parcel);
    }

    private void readFont(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFont", $$robo$$android_media_TimedText$readFont(android.os.Parcel ), 0, this, parcel);
    }

    private void readHighlight(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readHighlight", $$robo$$android_media_TimedText$readHighlight(android.os.Parcel ), 0, this, parcel);
    }

    private void readKaraoke(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readKaraoke", $$robo$$android_media_TimedText$readKaraoke(android.os.Parcel ), 0, this, parcel);
    }

    private void readHyperText(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readHyperText", $$robo$$android_media_TimedText$readHyperText(android.os.Parcel ), 0, this, parcel);
    }

    private void readBlinkingText(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readBlinkingText", $$robo$$android_media_TimedText$readBlinkingText(android.os.Parcel ), 0, this, parcel);
    }

    private boolean isValidKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidKey", $$robo$$android_media_TimedText$isValidKey(int ), 0, this, n);
    }

    private boolean containsKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_media_TimedText$containsKey(int ), 0, this, n);
    }

    private Set keySet() {
        return InvokeDynamicSupport.bootstrap("keySet", $$robo$$android_media_TimedText$keySet(), 0, this);
    }

    private Object getObject(int n) {
        return InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_media_TimedText$getObject(int ), 0, this, n);
    }

    public /* synthetic */ TimedText() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimedText)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class HyperText
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int startChar;
        public int endChar;
        public String URL;
        public String altString;

        private void $$robo$$android_media_TimedText_HyperText$__constructor__(int startChar, int endChar, String url, String alt) {
            this.startChar = startChar;
            this.endChar = endChar;
            this.URL = url;
            this.altString = alt;
        }

        private void __constructor__(int n, int n2, String string2, String string3) {
            this.$$robo$$android_media_TimedText_HyperText$__constructor__(n, n2, string2, string3);
        }

        public HyperText(int n, int n2, String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_HyperText$__constructor__(int int java.lang.String java.lang.String ), 0, this, n, n2, string2, string3);
        }

        public /* synthetic */ HyperText() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HyperText)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Karaoke
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int startTimeMs;
        public int endTimeMs;
        public int startChar;
        public int endChar;

        private void $$robo$$android_media_TimedText_Karaoke$__constructor__(int startTimeMs, int endTimeMs, int startChar, int endChar) {
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.startChar = startChar;
            this.endChar = endChar;
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_media_TimedText_Karaoke$__constructor__(n, n2, n3, n4);
        }

        public Karaoke(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_Karaoke$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        public /* synthetic */ Karaoke() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Karaoke)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Font
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int ID;
        public String name;

        private void $$robo$$android_media_TimedText_Font$__constructor__(int id2, String name) {
            this.ID = id2;
            this.name = name;
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_media_TimedText_Font$__constructor__(n, string2);
        }

        public Font(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_Font$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        public /* synthetic */ Font() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Font)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Style
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int startChar;
        public int endChar;
        public int fontID;
        public boolean isBold;
        public boolean isItalic;
        public boolean isUnderlined;
        public int fontSize;
        public int colorRGBA;

        private void $$robo$$android_media_TimedText_Style$__constructor__(int startChar, int endChar, int fontId, boolean isBold, boolean isItalic, boolean isUnderlined, int fontSize, int colorRGBA) {
            this.startChar = startChar;
            this.endChar = endChar;
            this.fontID = fontId;
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isUnderlined = isUnderlined;
            this.fontSize = fontSize;
            this.colorRGBA = colorRGBA;
        }

        private void __constructor__(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, int n5) {
            this.$$robo$$android_media_TimedText_Style$__constructor__(n, n2, n3, bl, bl2, bl3, n4, n5);
        }

        public Style(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_Style$__constructor__(int int int boolean boolean boolean int int ), 0, this, n, n2, n3, bl, bl2, bl3, n4, n5);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Justification
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int horizontalJustification;
        public int verticalJustification;

        private void $$robo$$android_media_TimedText_Justification$__constructor__(int horizontal, int vertical) {
            this.horizontalJustification = horizontal;
            this.verticalJustification = vertical;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_media_TimedText_Justification$__constructor__(n, n2);
        }

        public Justification(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_Justification$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ Justification() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Justification)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CharPos
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int startChar;
        public int endChar;

        private void $$robo$$android_media_TimedText_CharPos$__constructor__(int startChar, int endChar) {
            this.startChar = startChar;
            this.endChar = endChar;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_media_TimedText_CharPos$__constructor__(n, n2);
        }

        public CharPos(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_TimedText_CharPos$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ CharPos() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharPos)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

