/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiInputPort;
import android.media.midi.MidiOutputPort;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MidiDevice
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MidiDevice";
    private MidiDeviceInfo mDeviceInfo;
    private IMidiDeviceServer mDeviceServer;
    private IMidiManager mMidiManager;
    private IBinder mClientToken;
    private IBinder mDeviceToken;
    private boolean mIsDeviceClosed;
    private CloseGuard mGuard;

    private void $$robo$$android_media_midi_MidiDevice$__constructor__(MidiDeviceInfo deviceInfo, IMidiDeviceServer server, IMidiManager midiManager, IBinder clientToken, IBinder deviceToken) {
        this.mGuard = CloseGuard.get();
        this.mDeviceInfo = deviceInfo;
        this.mDeviceServer = server;
        this.mMidiManager = midiManager;
        this.mClientToken = clientToken;
        this.mDeviceToken = deviceToken;
        this.mGuard.open("close");
    }

    private final MidiDeviceInfo $$robo$$android_media_midi_MidiDevice$getInfo() {
        return this.mDeviceInfo;
    }

    private final MidiInputPort $$robo$$android_media_midi_MidiDevice$openInputPort(int portNumber) {
        if (this.mIsDeviceClosed) {
            return null;
        }
        try {
            Binder token = new Binder();
            ParcelFileDescriptor pfd = this.mDeviceServer.openInputPort(token, portNumber);
            if (pfd == null) {
                return null;
            }
            return new MidiInputPort(this.mDeviceServer, token, pfd, portNumber);
        }
        catch (RemoteException e) {
            Log.e("MidiDevice", "RemoteException in openInputPort");
            return null;
        }
    }

    private final MidiOutputPort $$robo$$android_media_midi_MidiDevice$openOutputPort(int portNumber) {
        if (this.mIsDeviceClosed) {
            return null;
        }
        try {
            Binder token = new Binder();
            ParcelFileDescriptor pfd = this.mDeviceServer.openOutputPort(token, portNumber);
            if (pfd == null) {
                return null;
            }
            return new MidiOutputPort(this.mDeviceServer, token, pfd, portNumber);
        }
        catch (RemoteException e) {
            Log.e("MidiDevice", "RemoteException in openOutputPort");
            return null;
        }
    }

    private final MidiConnection $$robo$$android_media_midi_MidiDevice$connectPorts(MidiInputPort inputPort, int outputPortNumber) {
        if (outputPortNumber < 0 || outputPortNumber >= this.mDeviceInfo.getOutputPortCount()) {
            throw new IllegalArgumentException("outputPortNumber out of range");
        }
        if (this.mIsDeviceClosed) {
            return null;
        }
        ParcelFileDescriptor pfd = inputPort.claimFileDescriptor();
        if (pfd == null) {
            return null;
        }
        try {
            Binder token = new Binder();
            int calleePid = this.mDeviceServer.connectPorts(token, pfd, outputPortNumber);
            if (calleePid != Process.myPid()) {
                IoUtils.closeQuietly(pfd);
            }
            return new MidiConnection(this, token, inputPort);
        }
        catch (RemoteException e) {
            Log.e("MidiDevice", "RemoteException in connectPorts");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiDevice$close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (!this.mIsDeviceClosed) {
                this.mGuard.close();
                this.mIsDeviceClosed = true;
                try {
                    this.mMidiManager.closeDevice(this.mClientToken, this.mDeviceToken);
                }
                catch (RemoteException e) {
                    Log.e("MidiDevice", "RemoteException in closeDevice");
                }
            }
        }
    }

    private final void $$robo$$android_media_midi_MidiDevice$finalize() throws Throwable {
        try {
            this.mGuard.warnIfOpen();
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final String $$robo$$android_media_midi_MidiDevice$toString() {
        return "MidiDevice: " + this.mDeviceInfo.toString();
    }

    private void __constructor__(MidiDeviceInfo midiDeviceInfo, IMidiDeviceServer iMidiDeviceServer, IMidiManager iMidiManager, IBinder iBinder, IBinder iBinder2) {
        this.$$robo$$android_media_midi_MidiDevice$__constructor__(midiDeviceInfo, iMidiDeviceServer, iMidiManager, iBinder, iBinder2);
    }

    MidiDevice(MidiDeviceInfo midiDeviceInfo, IMidiDeviceServer iMidiDeviceServer, IMidiManager iMidiManager, IBinder iBinder, IBinder iBinder2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDevice$__constructor__(android.media.midi.MidiDeviceInfo android.media.midi.IMidiDeviceServer android.media.midi.IMidiManager android.os.IBinder android.os.IBinder ), 0, this, midiDeviceInfo, iMidiDeviceServer, iMidiManager, iBinder, iBinder2);
    }

    public MidiDeviceInfo getInfo() {
        return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_media_midi_MidiDevice$getInfo(), 0, this);
    }

    public MidiInputPort openInputPort(int n) {
        return InvokeDynamicSupport.bootstrap("openInputPort", $$robo$$android_media_midi_MidiDevice$openInputPort(int ), 0, this, n);
    }

    public MidiOutputPort openOutputPort(int n) {
        return InvokeDynamicSupport.bootstrap("openOutputPort", $$robo$$android_media_midi_MidiDevice$openOutputPort(int ), 0, this, n);
    }

    public MidiConnection connectPorts(MidiInputPort midiInputPort, int n) {
        return InvokeDynamicSupport.bootstrap("connectPorts", $$robo$$android_media_midi_MidiDevice$connectPorts(android.media.midi.MidiInputPort int ), 0, this, midiInputPort, n);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiDevice$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_midi_MidiDevice$finalize(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_midi_MidiDevice$toString(), 0, this);
    }

    public /* synthetic */ MidiDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class MidiConnection
    implements Closeable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IMidiDeviceServer mInputPortDeviceServer;
        private IBinder mInputPortToken;
        private IBinder mOutputPortToken;
        private CloseGuard mGuard;
        private boolean mIsClosed;
        /* synthetic */ MidiDevice this$0;

        private void $$robo$$android_media_midi_MidiDevice_MidiConnection$__constructor__(MidiDevice this$0, IBinder outputPortToken, MidiInputPort inputPort) {
            this.mGuard = CloseGuard.get();
            this.mInputPortDeviceServer = inputPort.getDeviceServer();
            this.mInputPortToken = inputPort.getToken();
            this.mOutputPortToken = outputPortToken;
            this.mGuard.open("close");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_midi_MidiDevice_MidiConnection$close() throws IOException {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                if (this.mIsClosed) {
                    return;
                }
                this.mGuard.close();
                try {
                    this.mInputPortDeviceServer.closePort(this.mInputPortToken);
                    this.this$0.mDeviceServer.closePort(this.mOutputPortToken);
                }
                catch (RemoteException e) {
                    Log.e("MidiDevice", "RemoteException in MidiConnection.close");
                }
                this.mIsClosed = true;
            }
        }

        private final void $$robo$$android_media_midi_MidiDevice_MidiConnection$finalize() throws Throwable {
            try {
                this.mGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(MidiDevice midiDevice, IBinder iBinder, MidiInputPort midiInputPort) {
            this.$$robo$$android_media_midi_MidiDevice_MidiConnection$__constructor__(midiDevice, iBinder, midiInputPort);
        }

        MidiConnection(MidiDevice midiDevice, IBinder iBinder, MidiInputPort midiInputPort) {
            this.this$0 = midiDevice;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiDevice_MidiConnection$__constructor__(android.media.midi.MidiDevice android.os.IBinder android.media.midi.MidiInputPort ), 0, this, midiDevice, iBinder, midiInputPort);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiDevice_MidiConnection$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_midi_MidiDevice_MidiConnection$finalize(), 0, this);
        }

        public /* synthetic */ MidiConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

