/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.MediaDescription;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.VolumeProvider;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MediaSession
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaSession";
    public static int FLAG_HANDLES_MEDIA_BUTTONS = 1;
    public static int FLAG_HANDLES_TRANSPORT_CONTROLS = 2;
    public static int FLAG_EXCLUSIVE_GLOBAL_PRIORITY = 65536;
    private Object mLock;
    private int mMaxBitmapSize;
    private Token mSessionToken;
    private MediaController mController;
    private ISession mBinder;
    private CallbackStub mCbStub;
    private CallbackMessageHandler mCallback;
    private VolumeProvider mVolumeProvider;
    private PlaybackState mPlaybackState;
    private boolean mActive;

    private void $$robo$$android_media_session_MediaSession$__constructor__(Context context, String tag) {
    }

    private void $$robo$$android_media_session_MediaSession$__constructor__(Context context, String tag, int userId) {
        this.mLock = new Object();
        this.mActive = false;
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null.");
        }
        if (TextUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        this.mMaxBitmapSize = context.getResources().getDimensionPixelSize(17104916);
        this.mCbStub = new CallbackStub(this);
        MediaSessionManager manager = (MediaSessionManager)context.getSystemService("media_session");
        try {
            this.mBinder = manager.createSession(this.mCbStub, tag, userId);
            this.mSessionToken = new Token(this.mBinder.getController());
            this.mController = new MediaController(context, this.mSessionToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Remote error creating session.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setCallback(Callback callback) {
        this.setCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$setCallback(Callback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            CallbackMessageHandler msgHandler;
            if (callback == null) {
                if (this.mCallback != null) {
                    this.mCallback.mCallback.mSession = null;
                }
                this.mCallback = null;
                return;
            }
            if (this.mCallback != null) {
                this.mCallback.mCallback.mSession = null;
            }
            if (handler == null) {
                handler = new Handler();
            }
            callback.mSession = this;
            this.mCallback = msgHandler = new CallbackMessageHandler(this, handler.getLooper(), callback);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setSessionActivity(PendingIntent pi) {
        try {
            this.mBinder.setLaunchPendingIntent(pi);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setLaunchPendingIntent.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setMediaButtonReceiver(PendingIntent mbr) {
        try {
            this.mBinder.setMediaButtonReceiver(mbr);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setMediaButtonReceiver.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setFlags(int flags) {
        try {
            this.mBinder.setFlags(flags);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setFlags.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setPlaybackToLocal(AudioAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null for local playback.");
        }
        try {
            this.mBinder.setPlaybackToLocal(attributes);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setPlaybackToLocal.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$setPlaybackToRemote(VolumeProvider volumeProvider) {
        if (volumeProvider == null) {
            throw new IllegalArgumentException("volumeProvider may not be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mVolumeProvider = volumeProvider;
        }
        volumeProvider.setCallback((VolumeProvider.Callback)new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSession this$0;

            private void $$robo$$android_media_session_MediaSession_1$__constructor__(MediaSession this$0) {
            }

            private final void $$robo$$android_media_session_MediaSession_1$onVolumeChanged(VolumeProvider volumeProvider) {
                this.this$0.notifyRemoteVolumeChanged(volumeProvider);
            }

            private void __constructor__(MediaSession mediaSession) {
                this.$$robo$$android_media_session_MediaSession_1$__constructor__(mediaSession);
            }
            {
                this.this$0 = mediaSession;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_1$__constructor__(android.media.session.MediaSession ), 0, this, mediaSession);
            }

            @Override
            public void onVolumeChanged(VolumeProvider volumeProvider) {
                InvokeDynamicSupport.bootstrap("onVolumeChanged", $$robo$$android_media_session_MediaSession_1$onVolumeChanged(android.media.VolumeProvider ), 0, this, volumeProvider);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        try {
            this.mBinder.setPlaybackToRemote(volumeProvider.getVolumeControl(), volumeProvider.getMaxVolume());
            this.mBinder.setCurrentVolume(volumeProvider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setPlaybackToRemote.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setActive(boolean active) {
        if (this.mActive == active) {
            return;
        }
        try {
            this.mBinder.setActive(active);
            this.mActive = active;
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Failure in setActive.", e);
        }
    }

    private final boolean $$robo$$android_media_session_MediaSession$isActive() {
        return this.mActive;
    }

    private final void $$robo$$android_media_session_MediaSession$sendSessionEvent(String event, Bundle extras) {
        if (TextUtils.isEmpty(event)) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        try {
            this.mBinder.sendEvent(event, extras);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Error sending event", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$release() {
        try {
            this.mBinder.destroy();
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Error releasing session: ", e);
        }
    }

    private final Token $$robo$$android_media_session_MediaSession$getSessionToken() {
        return this.mSessionToken;
    }

    private final MediaController $$robo$$android_media_session_MediaSession$getController() {
        return this.mController;
    }

    private final void $$robo$$android_media_session_MediaSession$setPlaybackState(PlaybackState state) {
        this.mPlaybackState = state;
        try {
            this.mBinder.setPlaybackState(state);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Dead object in setPlaybackState.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setMetadata(MediaMetadata metadata) {
        if (metadata != null) {
            metadata = new MediaMetadata.Builder(metadata, this.mMaxBitmapSize).build();
        }
        try {
            this.mBinder.setMetadata(metadata);
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Dead object in setPlaybackState.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setQueue(List<QueueItem> queue) {
        try {
            this.mBinder.setQueue(queue == null ? null : new ParceledListSlice<QueueItem>(queue));
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueue.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setQueueTitle(CharSequence title) {
        try {
            this.mBinder.setQueueTitle(title);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setQueueTitle.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setRatingType(int type) {
        try {
            this.mBinder.setRatingType(type);
        }
        catch (RemoteException e) {
            Log.e("MediaSession", "Error in setRatingType.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSession$setExtras(Bundle extras) {
        try {
            this.mBinder.setExtras(extras);
        }
        catch (RemoteException e) {
            Log.wtf("Dead object in setExtras.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$notifyRemoteVolumeChanged(VolumeProvider provider) {
        Object object = this.mLock;
        synchronized (object) {
            if (provider == null || provider != this.mVolumeProvider) {
                Log.w("MediaSession", "Received update from stale volume provider");
                return;
            }
        }
        try {
            this.mBinder.setCurrentVolume(provider.getCurrentVolume());
        }
        catch (RemoteException e) {
            Log.e("MediaSession", "Error in notifyVolumeChanged", e);
        }
    }

    private final String $$robo$$android_media_session_MediaSession$getCallingPackage() {
        try {
            return this.mBinder.getCallingPackage();
        }
        catch (RemoteException e) {
            Log.wtf("MediaSession", "Dead object in getCallingPackage.", e);
            return null;
        }
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepare() {
        this.postToCallback(3);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromMediaId(String mediaId, Bundle extras) {
        this.postToCallback(4, mediaId, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromSearch(String query, Bundle extras) {
        this.postToCallback(5, query, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrepareFromUri(Uri uri, Bundle extras) {
        this.postToCallback(6, uri, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlay() {
        this.postToCallback(7);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromMediaId(String mediaId, Bundle extras) {
        this.postToCallback(8, mediaId, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromSearch(String query, Bundle extras) {
        this.postToCallback(9, query, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPlayFromUri(Uri uri, Bundle extras) {
        this.postToCallback(10, uri, extras);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSkipToItem(long id2) {
        this.postToCallback(11, id2);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPause() {
        this.postToCallback(12);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchStop() {
        this.postToCallback(13);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchNext() {
        this.postToCallback(14);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchPrevious() {
        this.postToCallback(15);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchFastForward() {
        this.postToCallback(16);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchRewind() {
        this.postToCallback(17);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSeekTo(long pos) {
        this.postToCallback(18, pos);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchRate(Rating rating) {
        this.postToCallback(19, rating);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchCustomAction(String action, Bundle args) {
        this.postToCallback(20, action, args);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchMediaButton(Intent mediaButtonIntent) {
        this.postToCallback(2, mediaButtonIntent);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchAdjustVolume(int direction) {
        this.postToCallback(21, direction);
    }

    private final void $$robo$$android_media_session_MediaSession$dispatchSetVolumeTo(int volume) {
        this.postToCallback(22, volume);
    }

    private final void $$robo$$android_media_session_MediaSession$postToCallback(int what) {
        this.postToCallback(what, null);
    }

    private final void $$robo$$android_media_session_MediaSession$postCommand(String command, Bundle args, ResultReceiver resultCb) {
        Command cmd = new Command(command, args, resultCb);
        this.postToCallback(1, cmd);
    }

    private final void $$robo$$android_media_session_MediaSession$postToCallback(int what, Object obj) {
        this.postToCallback(what, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSession$postToCallback(int what, Object obj, Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallback != null) {
                this.mCallback.post(what, obj, extras);
            }
        }
    }

    private static final boolean $$robo$$android_media_session_MediaSession$isActiveState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private void __constructor__(Context context, String string2) {
        this.$$robo$$android_media_session_MediaSession$__constructor__(context, string2);
    }

    public MediaSession(Context context, String string2) {
        this(context, string2, UserHandle.myUserId());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession$__constructor__(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    private void __constructor__(Context context, String string2, int n) {
        this.$$robo$$android_media_session_MediaSession$__constructor__(context, string2, n);
    }

    public MediaSession(Context context, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession$__constructor__(android.content.Context java.lang.String int ), 0, this, context, string2, n);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_session_MediaSession$setCallback(android.media.session.MediaSession$Callback ), 0, this, callback);
    }

    public void setCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_media_session_MediaSession$setCallback(android.media.session.MediaSession$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void setSessionActivity(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setSessionActivity", $$robo$$android_media_session_MediaSession$setSessionActivity(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void setMediaButtonReceiver(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setMediaButtonReceiver", $$robo$$android_media_session_MediaSession$setMediaButtonReceiver(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public void setFlags(int n) {
        InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_media_session_MediaSession$setFlags(int ), 0, this, n);
    }

    public void setPlaybackToLocal(AudioAttributes audioAttributes) {
        InvokeDynamicSupport.bootstrap("setPlaybackToLocal", $$robo$$android_media_session_MediaSession$setPlaybackToLocal(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    public void setPlaybackToRemote(VolumeProvider volumeProvider) {
        InvokeDynamicSupport.bootstrap("setPlaybackToRemote", $$robo$$android_media_session_MediaSession$setPlaybackToRemote(android.media.VolumeProvider ), 0, this, volumeProvider);
    }

    public void setActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_media_session_MediaSession$setActive(boolean ), 0, this, bl);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_media_session_MediaSession$isActive(), 0, this);
    }

    public void sendSessionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendSessionEvent", $$robo$$android_media_session_MediaSession$sendSessionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_session_MediaSession$release(), 0, this);
    }

    public Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_media_session_MediaSession$getSessionToken(), 0, this);
    }

    public MediaController getController() {
        return InvokeDynamicSupport.bootstrap("getController", $$robo$$android_media_session_MediaSession$getController(), 0, this);
    }

    public void setPlaybackState(PlaybackState playbackState) {
        InvokeDynamicSupport.bootstrap("setPlaybackState", $$robo$$android_media_session_MediaSession$setPlaybackState(android.media.session.PlaybackState ), 0, this, playbackState);
    }

    public void setMetadata(MediaMetadata mediaMetadata) {
        InvokeDynamicSupport.bootstrap("setMetadata", $$robo$$android_media_session_MediaSession$setMetadata(android.media.MediaMetadata ), 0, this, mediaMetadata);
    }

    public void setQueue(List<QueueItem> list) {
        InvokeDynamicSupport.bootstrap("setQueue", $$robo$$android_media_session_MediaSession$setQueue(java.util.List<android.media.session.MediaSession$QueueItem> ), 0, this, list);
    }

    public void setQueueTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setQueueTitle", $$robo$$android_media_session_MediaSession$setQueueTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setRatingType(int n) {
        InvokeDynamicSupport.bootstrap("setRatingType", $$robo$$android_media_session_MediaSession$setRatingType(int ), 0, this, n);
    }

    public void setExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_media_session_MediaSession$setExtras(android.os.Bundle ), 0, this, bundle);
    }

    public void notifyRemoteVolumeChanged(VolumeProvider volumeProvider) {
        InvokeDynamicSupport.bootstrap("notifyRemoteVolumeChanged", $$robo$$android_media_session_MediaSession$notifyRemoteVolumeChanged(android.media.VolumeProvider ), 0, this, volumeProvider);
    }

    public String getCallingPackage() {
        return InvokeDynamicSupport.bootstrap("getCallingPackage", $$robo$$android_media_session_MediaSession$getCallingPackage(), 0, this);
    }

    private void dispatchPrepare() {
        InvokeDynamicSupport.bootstrap("dispatchPrepare", $$robo$$android_media_session_MediaSession$dispatchPrepare(), 0, this);
    }

    private void dispatchPrepareFromMediaId(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromMediaId", $$robo$$android_media_session_MediaSession$dispatchPrepareFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void dispatchPrepareFromSearch(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromSearch", $$robo$$android_media_session_MediaSession$dispatchPrepareFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void dispatchPrepareFromUri(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPrepareFromUri", $$robo$$android_media_session_MediaSession$dispatchPrepareFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    private void dispatchPlay() {
        InvokeDynamicSupport.bootstrap("dispatchPlay", $$robo$$android_media_session_MediaSession$dispatchPlay(), 0, this);
    }

    private void dispatchPlayFromMediaId(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromMediaId", $$robo$$android_media_session_MediaSession$dispatchPlayFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void dispatchPlayFromSearch(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromSearch", $$robo$$android_media_session_MediaSession$dispatchPlayFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void dispatchPlayFromUri(Uri uri, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchPlayFromUri", $$robo$$android_media_session_MediaSession$dispatchPlayFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
    }

    private void dispatchSkipToItem(long l) {
        InvokeDynamicSupport.bootstrap("dispatchSkipToItem", $$robo$$android_media_session_MediaSession$dispatchSkipToItem(long ), 0, this, l);
    }

    private void dispatchPause() {
        InvokeDynamicSupport.bootstrap("dispatchPause", $$robo$$android_media_session_MediaSession$dispatchPause(), 0, this);
    }

    private void dispatchStop() {
        InvokeDynamicSupport.bootstrap("dispatchStop", $$robo$$android_media_session_MediaSession$dispatchStop(), 0, this);
    }

    private void dispatchNext() {
        InvokeDynamicSupport.bootstrap("dispatchNext", $$robo$$android_media_session_MediaSession$dispatchNext(), 0, this);
    }

    private void dispatchPrevious() {
        InvokeDynamicSupport.bootstrap("dispatchPrevious", $$robo$$android_media_session_MediaSession$dispatchPrevious(), 0, this);
    }

    private void dispatchFastForward() {
        InvokeDynamicSupport.bootstrap("dispatchFastForward", $$robo$$android_media_session_MediaSession$dispatchFastForward(), 0, this);
    }

    private void dispatchRewind() {
        InvokeDynamicSupport.bootstrap("dispatchRewind", $$robo$$android_media_session_MediaSession$dispatchRewind(), 0, this);
    }

    private void dispatchSeekTo(long l) {
        InvokeDynamicSupport.bootstrap("dispatchSeekTo", $$robo$$android_media_session_MediaSession$dispatchSeekTo(long ), 0, this, l);
    }

    private void dispatchRate(Rating rating) {
        InvokeDynamicSupport.bootstrap("dispatchRate", $$robo$$android_media_session_MediaSession$dispatchRate(android.media.Rating ), 0, this, rating);
    }

    private void dispatchCustomAction(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchCustomAction", $$robo$$android_media_session_MediaSession$dispatchCustomAction(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void dispatchMediaButton(Intent intent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaButton", $$robo$$android_media_session_MediaSession$dispatchMediaButton(android.content.Intent ), 0, this, intent);
    }

    private void dispatchAdjustVolume(int n) {
        InvokeDynamicSupport.bootstrap("dispatchAdjustVolume", $$robo$$android_media_session_MediaSession$dispatchAdjustVolume(int ), 0, this, n);
    }

    private void dispatchSetVolumeTo(int n) {
        InvokeDynamicSupport.bootstrap("dispatchSetVolumeTo", $$robo$$android_media_session_MediaSession$dispatchSetVolumeTo(int ), 0, this, n);
    }

    private void postToCallback(int n) {
        InvokeDynamicSupport.bootstrap("postToCallback", $$robo$$android_media_session_MediaSession$postToCallback(int ), 0, this, n);
    }

    private void postCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("postCommand", $$robo$$android_media_session_MediaSession$postCommand(java.lang.String android.os.Bundle android.os.ResultReceiver ), 0, this, string2, bundle, resultReceiver);
    }

    private void postToCallback(int n, Object object) {
        InvokeDynamicSupport.bootstrap("postToCallback", $$robo$$android_media_session_MediaSession$postToCallback(int java.lang.Object ), 0, this, n, object);
    }

    private void postToCallback(int n, Object object, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("postToCallback", $$robo$$android_media_session_MediaSession$postToCallback(int java.lang.Object android.os.Bundle ), 0, this, n, object, bundle);
    }

    public static boolean isActiveState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isActiveState", $$robo$$android_media_session_MediaSession$isActiveState(int ), 0, (int)n);
    }

    public /* synthetic */ MediaSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallbackMessageHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_COMMAND = 1;
        private static int MSG_MEDIA_BUTTON = 2;
        private static int MSG_PREPARE = 3;
        private static int MSG_PREPARE_MEDIA_ID = 4;
        private static int MSG_PREPARE_SEARCH = 5;
        private static int MSG_PREPARE_URI = 6;
        private static int MSG_PLAY = 7;
        private static int MSG_PLAY_MEDIA_ID = 8;
        private static int MSG_PLAY_SEARCH = 9;
        private static int MSG_PLAY_URI = 10;
        private static int MSG_SKIP_TO_ITEM = 11;
        private static int MSG_PAUSE = 12;
        private static int MSG_STOP = 13;
        private static int MSG_NEXT = 14;
        private static int MSG_PREVIOUS = 15;
        private static int MSG_FAST_FORWARD = 16;
        private static int MSG_REWIND = 17;
        private static int MSG_SEEK_TO = 18;
        private static int MSG_RATE = 19;
        private static int MSG_CUSTOM_ACTION = 20;
        private static int MSG_ADJUST_VOLUME = 21;
        private static int MSG_SET_VOLUME = 22;
        private Callback mCallback;
        /* synthetic */ MediaSession this$0;

        private void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(MediaSession mediaSession, Looper looper, Callback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int what, Object obj, Bundle bundle) {
            Message msg = this.obtainMessage(what, obj);
            msg.setData(bundle);
            msg.sendToTarget();
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int what, Object obj) {
            this.obtainMessage(what, obj).sendToTarget();
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int what) {
            this.post(what, null);
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int what, Object obj, int arg1) {
            this.obtainMessage(what, arg1, 0, obj).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_session_MediaSession_CallbackMessageHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Command cmd = (Command)msg.obj;
                    this.mCallback.onCommand(cmd.command, cmd.extras, cmd.stub);
                    break;
                }
                case 2: {
                    this.mCallback.onMediaButtonEvent((Intent)msg.obj);
                    break;
                }
                case 3: {
                    this.mCallback.onPrepare();
                    break;
                }
                case 4: {
                    this.mCallback.onPrepareFromMediaId((String)msg.obj, msg.getData());
                    break;
                }
                case 5: {
                    this.mCallback.onPrepareFromSearch((String)msg.obj, msg.getData());
                    break;
                }
                case 6: {
                    this.mCallback.onPrepareFromUri((Uri)msg.obj, msg.getData());
                    break;
                }
                case 7: {
                    this.mCallback.onPlay();
                    break;
                }
                case 8: {
                    this.mCallback.onPlayFromMediaId((String)msg.obj, msg.getData());
                    break;
                }
                case 9: {
                    this.mCallback.onPlayFromSearch((String)msg.obj, msg.getData());
                    break;
                }
                case 10: {
                    this.mCallback.onPlayFromUri((Uri)msg.obj, msg.getData());
                    break;
                }
                case 11: {
                    this.mCallback.onSkipToQueueItem((Long)msg.obj);
                    break;
                }
                case 12: {
                    this.mCallback.onPause();
                    break;
                }
                case 13: {
                    this.mCallback.onStop();
                    break;
                }
                case 14: {
                    this.mCallback.onSkipToNext();
                    break;
                }
                case 15: {
                    this.mCallback.onSkipToPrevious();
                    break;
                }
                case 16: {
                    this.mCallback.onFastForward();
                    break;
                }
                case 17: {
                    this.mCallback.onRewind();
                    break;
                }
                case 18: {
                    this.mCallback.onSeekTo((Long)msg.obj);
                    break;
                }
                case 19: {
                    this.mCallback.onSetRating((Rating)msg.obj);
                    break;
                }
                case 20: {
                    this.mCallback.onCustomAction((String)msg.obj, msg.getData());
                    break;
                }
                case 21: {
                    VolumeProvider vp;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        vp = this.this$0.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onAdjustVolume((Integer)msg.obj);
                    break;
                }
                case 22: {
                    VolumeProvider vp;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        vp = this.this$0.mVolumeProvider;
                    }
                    if (vp == null) break;
                    vp.onSetVolumeTo((Integer)msg.obj);
                }
            }
        }

        private void __constructor__(MediaSession mediaSession, Looper looper, Callback callback) {
            this.$$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(mediaSession, looper, callback);
        }

        public CallbackMessageHandler(MediaSession mediaSession, Looper looper, Callback callback) {
            this.this$0 = mediaSession;
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$__constructor__(android.media.session.MediaSession android.os.Looper android.media.session.MediaSession$Callback ), 0, this, mediaSession, looper, callback);
        }

        public void post(int n, Object object, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int java.lang.Object android.os.Bundle ), 0, this, n, object, bundle);
        }

        public void post(int n, Object object) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int java.lang.Object ), 0, this, n, object);
        }

        public void post(int n) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int ), 0, this, n);
        }

        public void post(int n, Object object, int n2) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$post(int java.lang.Object int ), 0, this, n, object, n2);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_media_session_MediaSession_CallbackMessageHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ CallbackMessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackMessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Command
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String command;
        public Bundle extras;
        public ResultReceiver stub;

        private void $$robo$$android_media_session_MediaSession_Command$__constructor__(String command, Bundle extras, ResultReceiver stub) {
            this.command = command;
            this.extras = extras;
            this.stub = stub;
        }

        private void __constructor__(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.$$robo$$android_media_session_MediaSession_Command$__constructor__(string2, bundle, resultReceiver);
        }

        public Command(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Command$__constructor__(java.lang.String android.os.Bundle android.os.ResultReceiver ), 0, this, string2, bundle, resultReceiver);
        }

        public /* synthetic */ Command() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Command)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class QueueItem
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int UNKNOWN_ID = -1;
        private MediaDescription mDescription;
        private long mId;
        public static Parcelable.Creator<QueueItem> CREATOR;

        private void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(MediaDescription description, long id2) {
            if (description == null) {
                throw new IllegalArgumentException("Description cannot be null.");
            }
            if (id2 == -1L) {
                throw new IllegalArgumentException("Id cannot be QueueItem.UNKNOWN_ID");
            }
            this.mDescription = description;
            this.mId = id2;
        }

        private void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(Parcel in) {
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
            this.mId = in.readLong();
        }

        private final MediaDescription $$robo$$android_media_session_MediaSession_QueueItem$getDescription() {
            return this.mDescription;
        }

        private final long $$robo$$android_media_session_MediaSession_QueueItem$getQueueId() {
            return this.mId;
        }

        private final void $$robo$$android_media_session_MediaSession_QueueItem$writeToParcel(Parcel dest, int flags) {
            this.mDescription.writeToParcel(dest, flags);
            dest.writeLong(this.mId);
        }

        private final int $$robo$$android_media_session_MediaSession_QueueItem$describeContents() {
            return 0;
        }

        private final String $$robo$$android_media_session_MediaSession_QueueItem$toString() {
            return "MediaSession.QueueItem {Description=" + this.mDescription + ", Id=" + this.mId + " }";
        }

        private /* synthetic */ void $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<QueueItem>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__() {
                }

                private final QueueItem $$robo$$android_media_session_MediaSession_QueueItem_1$createFromParcel(Parcel p) {
                    return new QueueItem(p);
                }

                private final QueueItem[] $$robo$$android_media_session_MediaSession_QueueItem_1$newArray(int size) {
                    return new QueueItem[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem_1$__constructor__(), 0, this);
                }

                @Override
                public QueueItem createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_session_MediaSession_QueueItem_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public QueueItem[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_session_MediaSession_QueueItem_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(MediaDescription mediaDescription, long l) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(mediaDescription, l);
        }

        public QueueItem(MediaDescription mediaDescription, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(android.media.MediaDescription long ), 0, this, mediaDescription, l);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(parcel);
        }

        private QueueItem(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_QueueItem$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public MediaDescription getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_session_MediaSession_QueueItem$getDescription(), 0, this);
        }

        public long getQueueId() {
            return (long)InvokeDynamicSupport.bootstrap("getQueueId", $$robo$$android_media_session_MediaSession_QueueItem$getQueueId(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_session_MediaSession_QueueItem$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_session_MediaSession_QueueItem$describeContents(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_session_MediaSession_QueueItem$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_session_MediaSession_QueueItem$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(QueueItem.class);
        }

        public /* synthetic */ QueueItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QueueItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CallbackStub
    extends ISessionCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<MediaSession> mMediaSession;

        private void $$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(MediaSession session) {
            this.mMediaSession = new WeakReference<MediaSession>(session);
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onCommand(String command, Bundle args, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.postCommand(command, args, cb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButton(Intent mediaButtonIntent, int sequenceNumber, ResultReceiver cb) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            try {
                if (session != null) {
                    session.dispatchMediaButton(mediaButtonIntent);
                }
            }
            finally {
                if (cb != null) {
                    cb.send(sequenceNumber, null);
                }
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepare() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepare();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromMediaId(String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromMediaId(mediaId, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromSearch(String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromSearch(query, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromUri(Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrepareFromUri(uri, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlay() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlay();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromMediaId(String mediaId, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromMediaId(mediaId, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromSearch(String query, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromSearch(query, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromUri(Uri uri, Bundle extras) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPlayFromUri(uri, extras);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSkipToTrack(long id2) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSkipToItem(id2);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPause() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPause();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onStop() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchStop();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onNext() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchNext();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onPrevious() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchPrevious();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onFastForward() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchFastForward();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onRewind() {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRewind();
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSeekTo(long pos) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSeekTo(pos);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onRate(Rating rating) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchRate(rating);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onCustomAction(String action, Bundle args) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchCustomAction(action, args);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onAdjustVolume(int direction) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchAdjustVolume(direction);
            }
        }

        private final void $$robo$$android_media_session_MediaSession_CallbackStub$onSetVolumeTo(int value) {
            MediaSession session = (MediaSession)this.mMediaSession.get();
            if (session != null) {
                session.dispatchSetVolumeTo(value);
            }
        }

        private void __constructor__(MediaSession mediaSession) {
            this.$$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(mediaSession);
        }

        public CallbackStub(MediaSession mediaSession) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_CallbackStub$__constructor__(android.media.session.MediaSession ), 0, this, mediaSession);
        }

        @Override
        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onCommand", $$robo$$android_media_session_MediaSession_CallbackStub$onCommand(java.lang.String android.os.Bundle android.os.ResultReceiver ), 0, this, string2, bundle, resultReceiver);
        }

        @Override
        public void onMediaButton(Intent intent, int n, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onMediaButton", $$robo$$android_media_session_MediaSession_CallbackStub$onMediaButton(android.content.Intent int android.os.ResultReceiver ), 0, this, intent, n, resultReceiver);
        }

        @Override
        public void onPrepare() {
            InvokeDynamicSupport.bootstrap("onPrepare", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepare(), 0, this);
        }

        @Override
        public void onPrepareFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromMediaId", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onPrepareFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromSearch", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onPrepareFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromUri", $$robo$$android_media_session_MediaSession_CallbackStub$onPrepareFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
        }

        @Override
        public void onPlay() {
            InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSession_CallbackStub$onPlay(), 0, this);
        }

        @Override
        public void onPlayFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromMediaId", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onPlayFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromSearch", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onPlayFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromUri", $$robo$$android_media_session_MediaSession_CallbackStub$onPlayFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
        }

        @Override
        public void onSkipToTrack(long l) {
            InvokeDynamicSupport.bootstrap("onSkipToTrack", $$robo$$android_media_session_MediaSession_CallbackStub$onSkipToTrack(long ), 0, this, l);
        }

        @Override
        public void onPause() {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSession_CallbackStub$onPause(), 0, this);
        }

        @Override
        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSession_CallbackStub$onStop(), 0, this);
        }

        @Override
        public void onNext() {
            InvokeDynamicSupport.bootstrap("onNext", $$robo$$android_media_session_MediaSession_CallbackStub$onNext(), 0, this);
        }

        @Override
        public void onPrevious() {
            InvokeDynamicSupport.bootstrap("onPrevious", $$robo$$android_media_session_MediaSession_CallbackStub$onPrevious(), 0, this);
        }

        @Override
        public void onFastForward() {
            InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSession_CallbackStub$onFastForward(), 0, this);
        }

        @Override
        public void onRewind() {
            InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSession_CallbackStub$onRewind(), 0, this);
        }

        @Override
        public void onSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("onSeekTo", $$robo$$android_media_session_MediaSession_CallbackStub$onSeekTo(long ), 0, this, l);
        }

        @Override
        public void onRate(Rating rating) {
            InvokeDynamicSupport.bootstrap("onRate", $$robo$$android_media_session_MediaSession_CallbackStub$onRate(android.media.Rating ), 0, this, rating);
        }

        @Override
        public void onCustomAction(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCustomAction", $$robo$$android_media_session_MediaSession_CallbackStub$onCustomAction(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        @Override
        public void onAdjustVolume(int n) {
            InvokeDynamicSupport.bootstrap("onAdjustVolume", $$robo$$android_media_session_MediaSession_CallbackStub$onAdjustVolume(int ), 0, this, n);
        }

        @Override
        public void onSetVolumeTo(int n) {
            InvokeDynamicSupport.bootstrap("onSetVolumeTo", $$robo$$android_media_session_MediaSession_CallbackStub$onSetVolumeTo(int ), 0, this, n);
        }

        public /* synthetic */ CallbackStub() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackStub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MediaSession mSession;

        private void $$robo$$android_media_session_MediaSession_Callback$__constructor__() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onCommand(String command, Bundle args, ResultReceiver cb) {
        }

        private final boolean $$robo$$android_media_session_MediaSession_Callback$onMediaButtonEvent(Intent mediaButtonIntent) {
            KeyEvent ke;
            if (this.mSession != null && "android.intent.action.MEDIA_BUTTON".equals(mediaButtonIntent.getAction()) && (ke = (KeyEvent)mediaButtonIntent.getParcelableExtra("android.intent.extra.KEY_EVENT")) != null && ke.getAction() == 0) {
                PlaybackState state = this.mSession.mPlaybackState;
                long validActions = state == null ? 0L : state.getActions();
                switch (ke.getKeyCode()) {
                    case 126: {
                        if ((validActions & 4L) == 0L) break;
                        this.onPlay();
                        return true;
                    }
                    case 127: {
                        if ((validActions & 2L) == 0L) break;
                        this.onPause();
                        return true;
                    }
                    case 87: {
                        if ((validActions & 0x20L) == 0L) break;
                        this.onSkipToNext();
                        return true;
                    }
                    case 88: {
                        if ((validActions & 0x10L) == 0L) break;
                        this.onSkipToPrevious();
                        return true;
                    }
                    case 86: {
                        if ((validActions & 1L) == 0L) break;
                        this.onStop();
                        return true;
                    }
                    case 90: {
                        if ((validActions & 0x40L) == 0L) break;
                        this.onFastForward();
                        return true;
                    }
                    case 89: {
                        if ((validActions & 8L) == 0L) break;
                        this.onRewind();
                        return true;
                    }
                    case 79: 
                    case 85: {
                        boolean canPause;
                        boolean isPlaying = state == null ? false : state.getState() == 3;
                        boolean canPlay = (validActions & 0x204L) != 0L;
                        boolean bl = canPause = (validActions & 0x202L) != 0L;
                        if (isPlaying && canPause) {
                            this.onPause();
                            return true;
                        }
                        if (isPlaying || !canPlay) break;
                        this.onPlay();
                        return true;
                    }
                }
            }
            return false;
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepare() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromMediaId(String mediaId, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromSearch(String query, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPrepareFromUri(Uri uri, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlay() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromSearch(String query, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromMediaId(String mediaId, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPlayFromUri(Uri uri, Bundle extras) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToQueueItem(long id2) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onPause() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToNext() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSkipToPrevious() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onFastForward() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onRewind() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onStop() {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSeekTo(long pos) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onSetRating(Rating rating) {
        }

        private final void $$robo$$android_media_session_MediaSession_Callback$onCustomAction(String action, Bundle extras) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_session_MediaSession_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Callback$__constructor__(), 0, this);
        }

        public void onCommand(String string2, Bundle bundle, ResultReceiver resultReceiver) {
            InvokeDynamicSupport.bootstrap("onCommand", $$robo$$android_media_session_MediaSession_Callback$onCommand(java.lang.String android.os.Bundle android.os.ResultReceiver ), 0, this, string2, bundle, resultReceiver);
        }

        public boolean onMediaButtonEvent(Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMediaButtonEvent", $$robo$$android_media_session_MediaSession_Callback$onMediaButtonEvent(android.content.Intent ), 0, this, intent);
        }

        public void onPrepare() {
            InvokeDynamicSupport.bootstrap("onPrepare", $$robo$$android_media_session_MediaSession_Callback$onPrepare(), 0, this);
        }

        public void onPrepareFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromMediaId", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void onPrepareFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromSearch", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void onPrepareFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPrepareFromUri", $$robo$$android_media_session_MediaSession_Callback$onPrepareFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
        }

        public void onPlay() {
            InvokeDynamicSupport.bootstrap("onPlay", $$robo$$android_media_session_MediaSession_Callback$onPlay(), 0, this);
        }

        public void onPlayFromSearch(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromSearch", $$robo$$android_media_session_MediaSession_Callback$onPlayFromSearch(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void onPlayFromMediaId(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromMediaId", $$robo$$android_media_session_MediaSession_Callback$onPlayFromMediaId(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public void onPlayFromUri(Uri uri, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPlayFromUri", $$robo$$android_media_session_MediaSession_Callback$onPlayFromUri(android.net.Uri android.os.Bundle ), 0, this, uri, bundle);
        }

        public void onSkipToQueueItem(long l) {
            InvokeDynamicSupport.bootstrap("onSkipToQueueItem", $$robo$$android_media_session_MediaSession_Callback$onSkipToQueueItem(long ), 0, this, l);
        }

        public void onPause() {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_media_session_MediaSession_Callback$onPause(), 0, this);
        }

        public void onSkipToNext() {
            InvokeDynamicSupport.bootstrap("onSkipToNext", $$robo$$android_media_session_MediaSession_Callback$onSkipToNext(), 0, this);
        }

        public void onSkipToPrevious() {
            InvokeDynamicSupport.bootstrap("onSkipToPrevious", $$robo$$android_media_session_MediaSession_Callback$onSkipToPrevious(), 0, this);
        }

        public void onFastForward() {
            InvokeDynamicSupport.bootstrap("onFastForward", $$robo$$android_media_session_MediaSession_Callback$onFastForward(), 0, this);
        }

        public void onRewind() {
            InvokeDynamicSupport.bootstrap("onRewind", $$robo$$android_media_session_MediaSession_Callback$onRewind(), 0, this);
        }

        public void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_media_session_MediaSession_Callback$onStop(), 0, this);
        }

        public void onSeekTo(long l) {
            InvokeDynamicSupport.bootstrap("onSeekTo", $$robo$$android_media_session_MediaSession_Callback$onSeekTo(long ), 0, this, l);
        }

        public void onSetRating(Rating rating) {
            InvokeDynamicSupport.bootstrap("onSetRating", $$robo$$android_media_session_MediaSession_Callback$onSetRating(android.media.Rating ), 0, this, rating);
        }

        public void onCustomAction(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCustomAction", $$robo$$android_media_session_MediaSession_Callback$onCustomAction(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Token
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ISessionController mBinder;
        public static Parcelable.Creator<Token> CREATOR;

        private void $$robo$$android_media_session_MediaSession_Token$__constructor__(ISessionController binder) {
            this.mBinder = binder;
        }

        private final int $$robo$$android_media_session_MediaSession_Token$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_session_MediaSession_Token$writeToParcel(Parcel dest, int flags) {
            dest.writeStrongBinder(this.mBinder.asBinder());
        }

        private final int $$robo$$android_media_session_MediaSession_Token$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mBinder == null ? 0 : this.mBinder.asBinder().hashCode());
            return result;
        }

        private final boolean $$robo$$android_media_session_MediaSession_Token$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            return !(this.mBinder == null ? other.mBinder != null : !this.mBinder.asBinder().equals(other.mBinder.asBinder()));
        }

        private final ISessionController $$robo$$android_media_session_MediaSession_Token$getBinder() {
            return this.mBinder;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Token>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_session_MediaSession_Token_1$__constructor__() {
                }

                private final Token $$robo$$android_media_session_MediaSession_Token_1$createFromParcel(Parcel in) {
                    return new Token(ISessionController.Stub.asInterface(in.readStrongBinder()));
                }

                private final Token[] $$robo$$android_media_session_MediaSession_Token_1$newArray(int size) {
                    return new Token[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_session_MediaSession_Token_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Token_1$__constructor__(), 0, this);
                }

                @Override
                public Token createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_session_MediaSession_Token_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Token[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_session_MediaSession_Token_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ISessionController iSessionController) {
            this.$$robo$$android_media_session_MediaSession_Token$__constructor__(iSessionController);
        }

        public Token(ISessionController iSessionController) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSession_Token$__constructor__(android.media.session.ISessionController ), 0, this, iSessionController);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_session_MediaSession_Token$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_session_MediaSession_Token$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_media_session_MediaSession_Token$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_media_session_MediaSession_Token$equals(java.lang.Object ), 0, this, object);
        }

        ISessionController getBinder() {
            return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_media_session_MediaSession_Token$getBinder(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Token.class);
        }

        public /* synthetic */ Token() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Token)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

