/*
 * Decompiled with CFR 0.152.
 */
package android.media.session;

import android.content.ComponentName;
import android.content.Context;
import android.media.IRemoteVolumeController;
import android.media.session.IActiveSessionsListener;
import android.media.session.ISession;
import android.media.session.ISessionController;
import android.media.session.ISessionManager;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class MediaSessionManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SessionManager";
    private ArrayMap<OnActiveSessionsChangedListener, SessionsChangedWrapper> mListeners;
    private Object mLock;
    private ISessionManager mService;
    private Context mContext;

    private void $$robo$$android_media_session_MediaSessionManager$__constructor__(Context context) {
        this.mListeners = new ArrayMap();
        this.mLock = new Object();
        this.mContext = context;
        IBinder b = ServiceManager.getService("media_session");
        this.mService = ISessionManager.Stub.asInterface(b);
    }

    private final ISession $$robo$$android_media_session_MediaSessionManager$createSession(MediaSession.CallbackStub cbStub, String tag, int userId) throws RemoteException {
        return this.mService.createSession(this.mContext.getPackageName(), cbStub, tag, userId);
    }

    private final List<MediaController> $$robo$$android_media_session_MediaSessionManager$getActiveSessions(ComponentName notificationListener) {
        return this.getActiveSessionsForUser(notificationListener, UserHandle.myUserId());
    }

    private final List<MediaController> $$robo$$android_media_session_MediaSessionManager$getActiveSessionsForUser(ComponentName notificationListener, int userId) {
        ArrayList<MediaController> controllers = new ArrayList<MediaController>();
        try {
            List<IBinder> binders = this.mService.getSessions(notificationListener, userId);
            int size = binders.size();
            for (int i = 0; i < size; ++i) {
                MediaController controller = new MediaController(this.mContext, ISessionController.Stub.asInterface(binders.get(i)));
                controllers.add(controller);
            }
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to get active sessions: ", e);
        }
        return controllers;
    }

    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, null);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, Handler handler) {
        this.addOnActiveSessionsChangedListener(sessionListener, notificationListener, UserHandle.myUserId(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener sessionListener, ComponentName notificationListener, int userId, Handler handler) {
        if (sessionListener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        if (handler == null) {
            handler = new Handler();
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.get(sessionListener) != null) {
                Log.w("SessionManager", "Attempted to add session listener twice, ignoring.");
                return;
            }
            SessionsChangedWrapper wrapper = new SessionsChangedWrapper(this.mContext, sessionListener, handler);
            try {
                this.mService.addSessionsListener(wrapper.mStub, notificationListener, userId);
                this.mListeners.put(sessionListener, wrapper);
            }
            catch (RemoteException e) {
                Log.e("SessionManager", "Error in addOnActiveSessionsChangedListener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_session_MediaSessionManager$removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            SessionsChangedWrapper wrapper = this.mListeners.remove(listener);
            if (wrapper != null) {
                try {
                    this.mService.removeSessionsListener(wrapper.mStub);
                }
                catch (RemoteException e) {
                    Log.e("SessionManager", "Error in removeOnActiveSessionsChangedListener.", e);
                }
                finally {
                    wrapper.release();
                }
            }
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$setRemoteVolumeController(IRemoteVolumeController rvc) {
        try {
            this.mService.setRemoteVolumeController(rvc);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Error in setRemoteVolumeController.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.dispatchMediaKeyEvent(keyEvent, false);
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        try {
            this.mService.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to send key event.", e);
        }
    }

    private final void $$robo$$android_media_session_MediaSessionManager$dispatchAdjustVolume(int suggestedStream, int direction, int flags) {
        try {
            this.mService.dispatchAdjustVolume(suggestedStream, direction, flags);
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to send adjust volume.", e);
        }
    }

    private final boolean $$robo$$android_media_session_MediaSessionManager$isGlobalPriorityActive() {
        try {
            return this.mService.isGlobalPriorityActive();
        }
        catch (RemoteException e) {
            Log.e("SessionManager", "Failed to check if the global priority is active.", e);
            return false;
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_media_session_MediaSessionManager$__constructor__(context);
    }

    public MediaSessionManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public ISession createSession(MediaSession.CallbackStub callbackStub, String string2, int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_media_session_MediaSessionManager$createSession(android.media.session.MediaSession$CallbackStub java.lang.String int ), 0, this, callbackStub, string2, n);
    }

    public List<MediaController> getActiveSessions(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getActiveSessions", $$robo$$android_media_session_MediaSessionManager$getActiveSessions(android.content.ComponentName ), 0, this, componentName);
    }

    public List<MediaController> getActiveSessionsForUser(ComponentName componentName, int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSessionsForUser", $$robo$$android_media_session_MediaSessionManager$getActiveSessionsForUser(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName ), 0, this, onActiveSessionsChangedListener, componentName);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName android.os.Handler ), 0, this, onActiveSessionsChangedListener, componentName, handler);
    }

    public void addOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener, ComponentName componentName, int n, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$addOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.content.ComponentName int android.os.Handler ), 0, this, onActiveSessionsChangedListener, componentName, n, handler);
    }

    public void removeOnActiveSessionsChangedListener(OnActiveSessionsChangedListener onActiveSessionsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnActiveSessionsChangedListener", $$robo$$android_media_session_MediaSessionManager$removeOnActiveSessionsChangedListener(android.media.session.MediaSessionManager$OnActiveSessionsChangedListener ), 0, this, onActiveSessionsChangedListener);
    }

    public void setRemoteVolumeController(IRemoteVolumeController iRemoteVolumeController) {
        InvokeDynamicSupport.bootstrap("setRemoteVolumeController", $$robo$$android_media_session_MediaSessionManager$setRemoteVolumeController(android.media.IRemoteVolumeController ), 0, this, iRemoteVolumeController);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchMediaKeyEvent", $$robo$$android_media_session_MediaSessionManager$dispatchMediaKeyEvent(android.view.KeyEvent boolean ), 0, this, keyEvent, bl);
    }

    public void dispatchAdjustVolume(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("dispatchAdjustVolume", $$robo$$android_media_session_MediaSessionManager$dispatchAdjustVolume(int int int ), 0, this, n, n2, n3);
    }

    public boolean isGlobalPriorityActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalPriorityActive", $$robo$$android_media_session_MediaSessionManager$isGlobalPriorityActive(), 0, this);
    }

    public /* synthetic */ MediaSessionManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSessionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SessionsChangedWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private OnActiveSessionsChangedListener mListener;
        private Handler mHandler;
        private IActiveSessionsListener.Stub mStub;

        private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(Context context, OnActiveSessionsChangedListener listener, Handler handler) {
            this.mStub = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SessionsChangedWrapper this$0;

                private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(SessionsChangedWrapper this$0) {
                }

                private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$onActiveSessionsChanged(List<MediaSession.Token> tokens) {
                    if (this.this$0.mHandler != null) {
                        this.this$0.mHandler.post(new Runnable(this, tokens){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ List val$tokens;
                            /* synthetic */ 1 this$1;

                            private void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(1 this$1, List list) {
                            }

                            private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$run() {
                                if (this.this$1.this$0.mListener != null) {
                                    ArrayList<MediaController> controllers = new ArrayList<MediaController>();
                                    int size = this.val$tokens.size();
                                    for (int i = 0; i < size; ++i) {
                                        controllers.add(new MediaController(this.this$1.this$0.mContext, (MediaSession.Token)this.val$tokens.get(i)));
                                    }
                                    this.this$1.this$0.mListener.onActiveSessionsChanged(controllers);
                                }
                            }

                            private void __constructor__(1 var1_1, List list) {
                                this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(var1_1, list);
                            }
                            {
                                this.this$1 = var1_1;
                                this.val$tokens = list;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$__constructor__(android.media.session.MediaSessionManager$SessionsChangedWrapper$1 java.util.List ), 0, this, var1_1, list);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }

                private void __constructor__(SessionsChangedWrapper sessionsChangedWrapper) {
                    this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(sessionsChangedWrapper);
                }
                {
                    this.this$0 = sessionsChangedWrapper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$__constructor__(android.media.session.MediaSessionManager$SessionsChangedWrapper ), 0, this, sessionsChangedWrapper);
                }

                @Override
                public void onActiveSessionsChanged(List<MediaSession.Token> list) {
                    InvokeDynamicSupport.bootstrap("onActiveSessionsChanged", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper_1$onActiveSessionsChanged(java.util.List<android.media.session.MediaSession$Token> ), 0, this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
        }

        private final void $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$release() {
            this.mContext = null;
            this.mListener = null;
            this.mHandler = null;
        }

        private void __constructor__(Context context, OnActiveSessionsChangedListener onActiveSessionsChangedListener, Handler handler) {
            this.$$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(context, onActiveSessionsChangedListener, handler);
        }

        public SessionsChangedWrapper(Context context, OnActiveSessionsChangedListener onActiveSessionsChangedListener, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$__constructor__(android.content.Context android.media.session.MediaSessionManager$OnActiveSessionsChangedListener android.os.Handler ), 0, this, context, onActiveSessionsChangedListener, handler);
        }

        private void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_media_session_MediaSessionManager_SessionsChangedWrapper$release(), 0, this);
        }

        public /* synthetic */ SessionsChangedWrapper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionsChangedWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnActiveSessionsChangedListener
    extends InstrumentedInterface {
        public void onActiveSessionsChanged(List<MediaController> var1);
    }
}

